(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20530,        543]
NotebookOptionsPosition[     17239,        440]
NotebookOutlinePosition[     18947,        488]
CellTagsIndexPosition[     18829,        482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Opener" :> Documentation`HelpLookup["paclet:ref/Opener"], 
          "CellGroup" :> Documentation`HelpLookup["paclet:ref/CellGroup"], 
          "DocumentNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DocumentNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Opener\"\>", 2->"\<\"CellGroup\"\>",
        3->"\<\"DocumentNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Controlling Cell Grouping" :> 
          Documentation`HelpLookup["paclet:guide/ControllingCellGrouping"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Controlling Cell Grouping\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ShowGroupOpener", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowGroupOpener",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowGroupOpener"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells that specifies whether an opener \
icon is displayed next to the leading cell in a cell group to indicate \
whether the cell group is open or closed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ShowGroupOpener", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", no icon appears next to the leading cell in a cell group."
}], "Notes",
 CellID->29901],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ShowGroupOpener", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a triangular opener icon is displayed to the left of the leading cell. \
Clicking the icon opens or closes the cell group. The triangle points to the \
right when the cell group is closed and down when the cell group is open."
}], "Notes",
 CellID->17103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->727235120],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->741915388],

Cell["Place an opener icon on the first cell of a group:", "ExampleText",
 CellID->130079377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"CellGroup", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", 
         RowBox[{"\"\<section\>\"", ",", "\"\<Section\>\"", ",", 
          RowBox[{"ShowGroupOpener", "\[Rule]", "True"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ExpressionCell", "[", 
           RowBox[{"n", ",", "\"\<Output\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "4"}], "}"}]}], "]"}]}], "}"}], "]"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271985558],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1TlNcZx3E6fd/Jv9D/xOnDS2F08sY604hTkaSTcezkhTNxykysSRtN
p0YFIQiRokZDNCz1ufiELAsoIKg8YwXUImhQxJGKvXt2z+7Zs/e94MKeK6HZ
72euMOc697mP++qXw+6y+/ONW9Zu/GleXt4J9V/bT/LyouOioj9SFEVREvVq
/jVFURTlsEy6fnXsAkVRFOWkfOn6gx+hKYqifgSVNl09AMBS/Dq/3G6LEs+1
kq4AkA3SFQAkkK4AsAwffNig8lPXmnXVwQWkKwBkyRekaSdJVwBYKtJVy0v4
oR8IgB8J0tWLRWvaMQAsG+nqQ7oCcIJ09SFdAThBuho87wrAIdLVh4AFkI3k
W14LSFde1QLg2NDIFGdXjXdkAXBFRas+wQYv5WC6AoATOlpnns+RrgDgiolW
j1e1AMARO1o90hUAHCmrDG/dFjKfkVW8pS64hnQFAAmkKwBIIF0BQALpCgAS
SFcAkLB2/SG7JV0BwAnOrgAggXQFAAmkKwBIIF0BQALpCgASSFcAkEC6AsAy
JL/2Jb98zbrq4ALSFQCyxCcQAoAE0tWzvlSLr9YC4Arp6vGdsAAEkK4aoQrA
LdLVIGABOES62ghYAK6Qrj4ELIBsJN/yWkC68qoWAMeGRqY4u2q8HQuAKypa
9Qk2eCkH0xUAnNDROvN8jnQFAFdMtHq8qgUAjtjR6pGuAOBIWWV467aQ+Yys
4i11wTWkKwBIIF0BQALpCgASSFcAkEC6AoCEtesP2S3pCgBOcHYFAAmkKwBI
IF0BQALpCgASSFcAkEC6AoAE0hUAliH5tS/55WvWVQcXkK4AkCU+gRAAJJCu
nvWlWny1FgBXSFeDXAXgEOlqkK4AHCJdDdIVgEOkq0G6AnCIdDVIVwDZS77l
tYB0jSNdAbgyNDLF2VXjvVgAXFHRqk+wwUs5mK4A4ISO1pnnc6QrALhiotXj
VS0AcMSOVo90BQBHyirDW7eFzGdkFW+pC64hXQFAAukKABJIVwCQQLoCgATS
FQAkrF1/yG5JVwBwgrMrAEggXQFAAukKABJIVwCQQLoCgATSFQAkkK4AIIF0
BYBlSH6pVn75mnXVwQWkKwBkic93BQAJpCsASJBO15mZmcnJSTePFQD+f0in
65kzZ44ePbqkhzQxMVFRUbF69Wr9LdhqfO/ePd+aUChUXFxsFqhbfAu6urq2
b9+edge1ePfu3fqSGujJvISFNlED1dpX096SdhJADhJNV3Vw3bFjR0lJycOH
DzN8PCoG89Lp7+/XC6anp02uGiqK7YBVeb7IDipszaQa68lgKqbdxP4/BekK
YBGi6aoOriUxmR9fTXLqMDRhq+b1AnVqtYNRLdOtOYWqE6Y5baoo9hI5aXbI
JBXNtnoTxRxizTGYdAWwCLl0VedVfXDVMj++2tSJ1JdXJuWCzwZo5rd++7ir
JpeUiuZ8azYxebvIcXehSQA5SC5d1YmxxFJdXb2kB6bCUx1TzbOviz9Balve
At+k+XeDa9SlzPcBkLOE0lWdVEsCent7M3lIjY2NvmdW1XnVXM1bmG/BQvtn
koqu1gDIWULp6ju4amVlZW98POb3epOrC71SL5qunF0BZEkiXQcHB4PRmuHx
1aSTOsGmXWCed/XdYs63Jp/NE63Sz7vab/ciXQFoEuk6OTl5dwFv/MsCc2jU
L1qZTAu+Z0Dnngph3ap5vWCh9wyY+M0kXc17FTJ5z4DvH7IfLYCctdL+Eral
pSUvHXOG9KwENtSMzjct7VtVdSoG5/UtwchNu4nJcC81XX3LFjp4A8gdKy1d
vdh51X72Ne3faqno0xmrfqqxHa2aOsGaTewdMk9X/Ujsv9WyE953i3k86tRK
tALwVmS6SksbpADgFukKABJyMF3VL/j6t3h7ksgF4FYOpqtm3lilka4A3MrZ
dAUAUaQrAEggXQFAAukKABJIVwCQQLoCgATSFQAc+uDDBhWh0SogXQHAvRV1
dl21alXwU1YAYGVSkeULseTBNb+8eEvdIpPfc7oCQE4hXQFAAukKABJIVwCQ
QLoCgATSFQAkkK4AIIF0BQAJpCsASCBdAUAC6QoAEkhXAJBAugKABNIVACSQ
rgAggXQFAAmkKwBIIF0BQALpCgASSFcAkEC6AoAE0hUAJJCuACCBdAUACaQr
AEggXQFAAukKABJIVwCQQLoCgATSFQAkkK4AIIF0BQAJpCsASCBdAUCCna6/
f3/X8NC/6hsin+6qpSiKorKsV/95FY70bv3DnqL3P1Ppqqq/f4SiKIrKsux0
7e8b87zXr1/PUxRFUdnUf1/P2+l65/boq1fzsy9eqnoRq/h4Vv2cM+3sbHyB
mjSLzdiuF7S0tLQrtF1yph2oPHbw7V8cKfjl4YJfBUvNq6tqjb7x5cu52dk5
k67dN+8+fTY79fjp1OPp2M+nifG0f/zEXmDWm8lnqVdpaWlpV1S7nEwLvZ0/
v3ef92WNV1WVpr6sUVfVGn3j4yfRW0y6dnYOPfj349HxydGxiZ+99ZZdo+MT
o+OP4uMxe/xIlbVsMjF4ZMa6Tc5b69MuTu4cW6yv6oH/rtSrtLS0tBm10RCb
iE3qmYnEfKLilyaidyV2GNxc6J0+5Z08vmCdPqXW6HvH7k+OjU+ZdG2/PjB0
90H/4JiOLzXQlWjHk/MDyTWJwWhscXzNQMomo3br29x3VbWpC6JX7cWLX6Wl
paV9Y5sYjCcnB1Lb6HjUWhPdYaCo0AvVe18fjb/pSg10mTZUr9bEbhkfGBof
HH5g0jXS2tdz++7NnmGdYGrQ1TNst2aQbnIk7XxX6iZdqZsHr3aljvVVe/Hi
V2lpaWkzbG+mjgM1Yt+lBv50VeqscSJd9V3dt4Zv3bln0lUN2jv62m706gRr
vd4Xae9rvZ5sE4Neexwf3Ohrbe9Ntu3mrt42td5qfc8ABBfrcSR1ZST6j6Zc
NTurAS0tLW3mbdv1PlWtiZ+t0fm+6Hws8fRik2lmh4GiDV7opHf8cLR8jlR7
h6u8E8dUurbqPW/0dXQNmXRtDt++Fu5pCvfoBFODpuaeq+HueNucMu+bvBqb
bGo2i7uT8+EeuzU3Xl1gcXzc3G3u1YszuUpLS0ubQRufUePkTHw+XibTzA79
v3snmqs1X3g1Fd6h8mS0VpV6B/d5X3yuArZ/0zuJW7ojbX2XrtzU6XotfPvi
5U5VOsEar0THF6906NbMm7IXJ2Y6fANf23i5szH1lsboJh3pNu/Qi/VV0y5+
lZaWljaDNj7TGJ9PKWt9yg7RdK096JXv8Q7s8Z9d937mfb7bO1iu0tXscy18
6x+nIzpdm5pvnT3feu5Cm04wNdCl27MX2s9Fq+3c+TY1jrbn263FsUvR+bbY
SnNX+ta32G7NhsGrJnsXupeWlpb2je3Z5HyaTNNXg5nWv2mDV1U+/7ddJlPn
/pocv/jLJ17Z/oFNG2L3tp0933b5atdXxy/G0/XarYbT4VNnIjrB1ECXr/VV
6tUW01rzLcHWKn/r23BJV2lpaWmX2C5eLeZn9HnXsv3PPvlYx+nzP3/8LFa6
/W7nTm//PrXG3Nt4qaOyqiGRrrdP1rfUN0QkSqei25UURVHfWw0XF3qlpVMf
ffTdzj8FS817ZaXDmzfoxd+GIuf/2bln7/F4ujbdqfv62olvwhRFUZSvOt79
jVdR5pWpKk1TpaVeReX1936rF39TFz5zuuPTXbU6XS9f7qk51Hik9hJFURTl
qwOVxzo3rR95d+PQ5sJgjRQXdmwuVGv04sN/v/jtyQjpSlEU5bZIV4qiKIki
XSmKoiTKl65Xm3pqaxqPHrlEURRFZVNHDl8M1SfTdWz8yfDIo+GRCYqiKCrL
un9/2qQrRVEU5bZUuv4PvJmZCg==
   "], {{0, 0}, {458, 174}}, {0, 255}],
  ImageSize->{458 0.75, 174 0.75},
  PlotRange->{{0, 458}, {0, 174}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->118913605]
}, Open  ]],

Cell["Clicking the icon toggles the group between open and closed:", \
"ExampleText",
 CellID->470508921],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkn/0L/E6c/HqqTTp6knWnEqUjayWTaybM4dSbW2AbT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   "], {{0, 0}, {458, 127}}, {0, 255}],
  ImageSize->{458 0.75, 127 0.75},
  PlotRange->{{0, 458}, {0, 127}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->169680144]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DocumentNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DocumentNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->167923694],

Cell[TextData[ButtonBox["Controlling Cell Grouping",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControllingCellGrouping"]], "MoreAbout",
 CellID->48594802],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->367630024],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->45886545]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowGroupOpener - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 29.5729058}", "context" -> "System`", 
    "keywords" -> {
     "show group open close", "cell opener", "cell group opener", 
      "elision opener"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ShowGroupOpener is an option for cells that specifies whether an opener \
icon is displayed next to the leading cell in a cell group to indicate \
whether the cell group is open or closed.", 
    "synonyms" -> {"show group opener"}, "title" -> "ShowGroupOpener", "type" -> 
    "Symbol", "uri" -> "ref/ShowGroupOpener"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5918, 171, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->727235120]},
 "Notebook Image"->{
  Cell[7251, 218, 4166, 71, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->118913605],
  Cell[11540, 296, 3584, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->169680144]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18457, 468},
 {"Notebook Image", 18598, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1848, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2471, 68, 1580, 37, 70, "ObjectNameGrid"],
Cell[4054, 107, 569, 15, 70, "Usage",
 CellID->29763]
}, Open  ]],
Cell[CellGroupData[{
Cell[4660, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5138, 144, 291, 9, 70, "Notes",
 CellID->29901],
Cell[5432, 155, 449, 11, 70, "Notes",
 CellID->17103]
}, Closed]],
Cell[CellGroupData[{
Cell[5918, 171, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->727235120],
Cell[CellGroupData[{
Cell[6303, 185, 148, 5, 70, "ExampleSection",
 CellID->741915388],
Cell[6454, 192, 93, 1, 70, "ExampleText",
 CellID->130079377],
Cell[CellGroupData[{
Cell[6572, 197, 676, 19, 70, "Input",
 CellID->271985558],
Cell[7251, 218, 4166, 71, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->118913605]
}, Open  ]],
Cell[11432, 292, 105, 2, 70, "ExampleText",
 CellID->470508921],
Cell[11540, 296, 3584, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->169680144]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15173, 363, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15492, 374, 714, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[16243, 405, 299, 8, 70, "MoreAboutSection"],
Cell[16545, 415, 150, 3, 70, "MoreAbout",
 CellID->167923694],
Cell[16698, 420, 159, 3, 70, "MoreAbout",
 CellID->48594802],
Cell[16860, 425, 134, 3, 70, "MoreAbout",
 CellID->367630024],
Cell[16997, 430, 170, 3, 70, "MoreAbout",
 CellID->45886545]
}, Open  ]],
Cell[17182, 436, 27, 0, 70, "History"],
Cell[17212, 438, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

