(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23400,        600]
NotebookOptionsPosition[     19851,        487]
NotebookOutlinePosition[     21596,        535]
CellTagsIndexPosition[     21478,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageBreakWithin" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakWithin"], 
          "ScreenStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/ScreenStyleEnvironment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PageBreakWithin\"\>", 
       2->"\<\"ScreenStyleEnvironment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Page Layout & Printing Control\"\>",
        2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowPageBreaks", "ObjectName",
 CellID->24425],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowPageBreaks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowPageBreaks"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether to \
indicate in the on\[Hyphen]screen display of a notebook where page breaks \
would occur if the notebook were printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1675]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowPageBreaks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowPageBreaks"]], "InlineFormula"],
 " is often set using a menu item in the notebook front end. "
}], "Notes",
 CellID->5488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->581090998],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->64142301],

Cell["Create a document with some manual page breaks:", "ExampleText",
 CellID->641606860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", " ", 
    RowBox[{"Insert", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"TextCell", "[", 
         RowBox[{
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<text \>\"", ",", "n"}], "}"}], "]"}], ",", 
          "\"\<Text\>\""}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "40"}], "}"}]}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<new page\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"PageBreakAbove", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", "5", "}"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83930048],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3euPFeUdB/Bt+r7xX+i/0stbNzR9Q5tUMQXXNoa06bsmfWGqtlKbegNR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   "], {{0, 0}, {458, 211}}, {0, 255}],
  ImageSize->{458 0.75, 211 0.75},
  PlotRange->{{0, 458}, {0, 211}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->9992438]
}, Open  ]],

Cell["Show the page breaks:", "ExampleText",
 CellID->22773921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621300316],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zFeUZB/B0+r7DV+g38CMwbV/XmY59084UcAqoHafTvqc6TtUitRQV
EOVBaUDBhwhURGwAeQhJwPAQkBBJbEN0CoIPTGGkQLd7suds9jySbM4dzDm/
31zN3NfuvZvpm//sbHCvHz742589+P2Ojo7B+H/93+voKKyXLPmDUkqpEHXr
9h2llFJNrDRdX9/2gVJKqaZURbre80dopZRqgaqZrlEUdZSk6+pFdk9W9RGA
1lYRe0tK71prpmvpko7yO3RU/Kz1W6Qr0F7ypWvFA2q94K3eANAmcj+71mwb
pKiABdrKtNK1+hm15nvX8vvf5bEWoCXleHZteLcaf8+q96cugNYzf34hV5PK
apCuAEyddAVoluyD6333lZ2SrgAhSFeAEKQrQAjSFSAE6QoQgnQFCEG6AoQg
XQFCkK4AIUhXgBCkK0Bu2f8Sdt68slPSFaApfMUFIATpChDCdGcTTHcmrE9n
A+0p9ExYk1+A9hR6Jqx0BdpT6Jmw3gwA7Sn0TNjIUyvQTnJMLcw3Ezby+Aq0
Jf8iC6BZTC0EmGXSFSAE6QoQgnQFCEG6AoQgXQFCkK4AIUhXgBCkK0AI0hUg
BOkKEIJ0BcjNTFiA0HwjCyCE0FMLo/LPbgO0CVMLAUIIPbWweg9AOwg9tTDy
ZgBoS6YWAoRgaiFAE+WYCQvA1ElXgGYxExZglklXgBCkK0AI0hUgBOkKEIJ0
BQhBugKEIF0BQpCuACFIV4AQpCtAbqYWAoQW+isud/38oO8TAi1pFr6RNcVx
MAIWaCU5ZhNUL6KGo7VqzuGqlj0V4v8pwGya+Vyt7MHq4/UubHwTgLluJuma
fYiNyp9py39F3WlcNdcyFmgB+d4M1PxZ3WYPTv1C6Qq0gOk+u1b/HariNWzN
96jV712z6+rHYIA5ytRCgKCkK0CzmFoIMMukK0AI9dJ15cqVjwGQV710Xb58
+QIA8qqXrp2dnasByKteui5btuwRAPKql65dXV33+qUFwBzm3wwAhCBdAUKQ
rgAhSFeAEKQrQG5mwgKE5htZACFMdzZBzS9mR3U+nZ35LUa6AO0l91ytzB2m
NLRFtAJtJV+61pvk0uCp1bMr0FZmPnG78bNrg+AFaGE5ZsJGtWZnN37pGklX
oM3keHZteLfae7wWANqEmbAAQUlXgGYxExZglklXgBCkK0AI0hUgBOkKEIJ0
BQhBugKEIF0BQpCuACFIV4AQpCtAbqYWAoTmKy4AIUhXgBBmYSasT2cDbSj0
TFhztYD2FHombOPjAK0q9EzYzC8SsEAbCT0T1psBoK3kmFqYeyasv2oBbci/
yAJoFlMLAWaZdAUIQboChCBdAUKQrgAhSFeAEKQrQAjSFSAE6QoQgnQFCEG6
AoQgXQFyMxMWIDTfyAIIIfTUwnpf1QZobbM2tRCgrczC1EIBC7Sh2ZlaKGCB
dmNqIUAIphYCNFGOmbAATJ10BWgWM2EBZpl0BQhBugKEIF0BQpCuACFIV4AQ
pCtACNIVIATpChCCdAUIQboC5GZqIUBoob/ictehWqZuAS1pFr6R1Thap7IN
YM7JMZugehE1nEHQeFBsxVnPsUBrmPlcrezB6uP1Lmx8E4C5bibpmn2Ijcqf
act/Rd1pXDXXMhZoAfneDNT8Wd1mD079QukKtIDpPrtW/x2q4jVszfeo1e9d
s+vqx2CAOcrUQoCgpCtAs5haCDDLpCtACPXSdeXKlY8BkFe9dF2+fPkCAPKq
l66dnZ2rAcirXrouW7bsEQDyqpeuXV1d9/qlBcAc5t8MAIQgXQFCkK4AIUhX
gBCkK0BuZsIChOYbWQAhTHc2Qc0vZkd1Pp3d4DhAa8s9Vytzh7sPbZGrQLvJ
l671JrlIV4DEzCdue3YFqJZjJmxUa3Z245er0hVoNzmeXRverXa0SlegTZgJ
CxCUdAVoFjNhAWaZdAUIoV66zp8/vwOAvOql66ZNm+712ASAOaxeuj7++OM/
ByCvbLr+5tEVIxf+uWNX7zMrOpVSSs2wbv33Vk/vud/9ftWSR5+N0zWu8+dH
lVJKzbCy6Xp+6GIU3blz57ZSSqmZ1P/u3M6m68dnx27dun39xrdx3Zio4vp6
/PNm2l6/XtwQH0w3p+ts3dBqtdrvaDvtTHtx/bYND/xo6/0/3nL/T6orPh6f
jfckF3777c3r12+m6Xr61KffXLt+5eo3V65+PfHzm9L668r1l9kN6f704LXy
s1qtVvudavNk2s4Hfnr7+ReiVzZHGzfWqFc2x2fjPcmFV78sXJKm64kTFz7/
99Wx8S/GLl76wbx52RobvzQ2frm4vphdX44rs+2L0uJyuk7ayeOZ/TU3T955
YnNyNllUXlV+VqvVaqfUFkLs0sTB5Mil0vFSFU9dKlxVusMnSxdFu9+NurbX
rd3vxnuSay9+9sXF8Stpuh47Pnzh08/Pf3Ixia94kVSpHZ88Pjy5p7QYm9hc
3DNcdpOxbFtx84qzcVu+oXA2u7nxWa1Wq71rW1qMTx4cLm8L67HMnsIdhpcs
inbuiN54rfifY8WLpNJ25454z8Ql48MXxj8Z+TxN196+ocGzn54aHEkSLF6c
HBzJtumi1sHRmsdPlt/kZPnNq8+eLF8nZ7ObG5/VarXaKbanytdVNZq9Kl5U
pmvszcy6lK7JVafPjJz5+F9pusaLYwND/R+dSxKs7/hQ77GhvuOTbWlxLrsu
Lj4a6jt2brI9ll51rj/en2kr3gBUb07WveU7ewu/tOxseud4odVqtVNv+48P
xdVX+tlXOD5UOD6ReMnmNNPSOwwvWRjt7Iq2bylUha2boi0bo7e3xenal9zz
o6GBkxfSdD3Sc/Zwz+ChnsEkweLFoSODB3tOF9sjZccrDh6cOHjoSLr59OTx
nsFsm154sM7m4vrI6fTaZPPMz2q1Wm2SYMmReD15pHi8WGmmpXc4/+sFhVzd
/HK0+aXo1XWT0bpxTbThhejl5+KAPb94QemS0739Q/s/PJWk6+Ges/sOnIgr
yajuDwvrfR8OJG16PK3s5tKRgYpFRdt94ER3+SXdhZsM1Lr5QLI5OZu29c4m
t8r+uuprtVqtdqItHukuHi+rzP6yOxTStXNDtG5V9OKqymfX55+NnvtztGFd
nK7pfQ73nPn77t4kXQ8dObNnb9/7H/QnGRUvkkraPR8ce79Q/e/v7Y/XhXbv
sczmiVOF4/0TO9OrarcVm7NtesPqs2n2Nj47xV+k1Wrbs90zebxGpiVnqzPt
/OKF0cZ1t/+6Is3Um3+ZXN9Y/nS0dvXw4oUT1/bv2dt/4ODJ17fvK6br4TO7
dve8+15vElDxIqmKtqLKzx5N28zxo9VtpirbihtO8ezEwbLfftdfpNVqtXer
o+nPwnvXtauvPf1UEqf/+dNT1yYqab968slo9QvxnvTa7v0D6zfuKqXr2a4d
R3fs6g1RSe41d2dzr1VKqQY18tCiaM2aK0888dWTf6yu+Hi0ds3I0oXJ5nd2
9u79x4lVz28vpuuhj9984/Dbb/UopZSqqIGHfxG9tDZaG9eaGrVmTfTS+uOP
/CrZ/NabPe/tHnhmRWeSrgcODG5+tXtr536llFIV9eL6bScW/3L04QcvLF1U
XaMPLRpYuijek2ze8rd973T1SlellGpuSVellApR0lUppUJURboePDTYubn7
ta37lVJKzaS2btm3c8dkul4c/3Jk9PLI6CWllFIzrM8++zpNV6WUUs2tOF3/
D3el1eE=
   "], {{0, 0}, {458, 211}}, {0, 255}],
  ImageSize->{458 0.75, 211 0.75},
  PlotRange->{{0, 458}, {0, 211}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->37852937]
}, Open  ]],

Cell["Automatic page breaks are also indicated:", "ExampleText",
 CellID->28414322],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zVOUZB/B0+r7DV+g38CM4bV/XmY6v2pkKTgG143Ta97YzTtUitRaV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   "], {{0, 0}, {458, 211}}, {0, 255}],
  ImageSize->{458 0.75, 211 0.75},
  PlotRange->{{0, 458}, {0, 211}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->543567985]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18155],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakWithin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakWithin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScreenStyleEnvironment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScreenStyleEnvironment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25746],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->209295900],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->22669616]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowPageBreaks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 35.9949452}", "context" -> "System`", 
    "keywords" -> {"display page breaks", "page break", "pagination"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ShowPageBreaks is a notebook option which specifies whether to indicate \
in the on-screen display of a notebook where page breaks would occur if the \
notebook were printed. ", "synonyms" -> {"show page breaks"}, "title" -> 
    "ShowPageBreaks", "type" -> "Symbol", "uri" -> "ref/ShowPageBreaks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4087, 129, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->581090998]},
 "Notebook Image"->{
  Cell[5567, 181, 4119, 70, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->9992438],
  Cell[9968, 266, 4023, 69, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->37852937],
  Cell[14092, 341, 3678, 63, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->543567985]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21006, 512},
 {"Notebook Image", 21147, 516}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 77, 52, 1, 70, "ObjectName",
 CellID->24425],
Cell[2736, 80, 562, 15, 70, "Usage",
 CellID->1675]
}, Open  ]],
Cell[CellGroupData[{
Cell[3335, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3813, 117, 237, 7, 70, "Notes",
 CellID->5488]
}, Closed]],
Cell[CellGroupData[{
Cell[4087, 129, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->581090998],
Cell[CellGroupData[{
Cell[4472, 143, 147, 5, 70, "ExampleSection",
 CellID->64142301],
Cell[4622, 150, 90, 1, 70, "ExampleText",
 CellID->641606860],
Cell[CellGroupData[{
Cell[4737, 155, 827, 24, 70, "Input",
 CellID->83930048],
Cell[5567, 181, 4119, 70, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->9992438]
}, Open  ]],
Cell[9701, 254, 63, 1, 70, "ExampleText",
 CellID->22773921],
Cell[CellGroupData[{
Cell[9789, 259, 176, 5, 70, "Input",
 CellID->621300316],
Cell[9968, 266, 4023, 69, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->37852937]
}, Open  ]],
Cell[14006, 338, 83, 1, 70, "ExampleText",
 CellID->28414322],
Cell[14092, 341, 3678, 63, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->543567985]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17819, 410, 311, 9, 70, "SeeAlsoSection",
 CellID->18155],
Cell[18133, 421, 492, 17, 70, "SeeAlso",
 CellID->5116]
}, Open  ]],
Cell[CellGroupData[{
Cell[18662, 443, 314, 9, 70, "TutorialsSection",
 CellID->25746],
Cell[18979, 454, 155, 3, 70, "Tutorials",
 CellID->232099468]
}, Open  ]],
Cell[CellGroupData[{
Cell[19171, 462, 299, 8, 70, "MoreAboutSection"],
Cell[19473, 472, 170, 3, 70, "MoreAbout",
 CellID->209295900],
Cell[19646, 477, 133, 3, 70, "MoreAbout",
 CellID->22669616]
}, Open  ]],
Cell[19794, 483, 27, 0, 70, "History"],
Cell[19824, 485, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

