(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27064,        720]
NotebookOptionsPosition[     22913,        585]
NotebookOutlinePosition[     24802,        638]
CellTagsIndexPosition[     24684,        632]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Selectable" :> 
          Documentation`HelpLookup["paclet:ref/Selectable"], "AutoScroll" :> 
          Documentation`HelpLookup["paclet:ref/AutoScroll"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Selectable\"\>", 
       2->"\<\"AutoScroll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ShowSelection", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowSelection",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowSelection"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " which specifies whether to show the current selection highlighted. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1899]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowSelection"]], "InlineFormula"],
 " is often set for styles of cells or whole notebooks instead of individual \
cells. "
}], "Notes",
 CellID->18640],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["ShowSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowSelection"]], "InlineFormula"],
 " affect only how the selection is displayed, not where it is or how it \
works. "
}], "Notes",
 CellID->2969],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"ShowSelection", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is convenient if you want notebook operations to be performed invisibly. "
}], "Notes",
 CellID->18374]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->394209506],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->394991057],

Cell["Create a notebook window and select some content:", "ExampleText",
 CellID->237750221],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", "\"\<one two three\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->779427064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92311909],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnNlPlFcYxml63/gv9P/oVZdbTRtv2iZVTEVtY0yb3jXphanaam3qBmoB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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->564269062]
}, Open  ]],

Cell["Turn off the visible marking of the selection:", "ExampleText",
 CellID->6654369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126390860],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+j961cOtpo03bZMqpqK2MaZN75r0wlRttTbFA3gA
VAqoiAegImI5yGEcBhyQARmQwXYYTUHxlGKkQHfXnjWzZu3DDKMzW4l9nrxO
vvdb31p7e/Nms8V5e8O2jza8WVBQ8I74E3ijoMCsi4q+Qwgh5IUWFpcQQgjl
USpdT52+ghBCKC+ypesrf4RGCKHXQK7pagAAQA4UJd+1kq4AAHmEdAUA8ALS
FQDAC0hXAAAvIF0BALyAdAUA8ALSFQDAC0hXAAAvIF0BALyAdAUA8ALSFQDA
C0hXAAAvIF0BALyAdAUA8ALSFQDghfnm28YPVh+W+vDjY/oS6QoAkBdEwOqW
dAUAyAs5pmtBEqd1Fq57dWsrXC/heoLzuq43lu7SAAB5J5d0zZyNKuucw64d
18l0dfY38Fy3BACQL15aumazXX/+zHCJ57oB50ZCFQBeAi8hXdP9aJ9he97T
Nd2rA9e/FwBA7niRrnpCZvlmIJtH32VPcF7R9R54MwAALwEv/lXLSJN76TY6
nyrTNTNf2sgY8sveEgBAHnmFv5GVe75lfrIFAHiFkK4AAF7wevxvAn7SB4CV
xuuRrgAAK4TUVw2sIV0BAPIPz64AAPlC/46szdvq9CXSFQDAC0hXAAAvIF0B
ALyAdAUA8AI9Xb/cuicy8Ud9o3/3niqEEEI5auGfBZ9/9Kuvi4u27hXpKjQ2
NokQQihH6ek6Fp4yjKWlpUWEEEK56N+lRT1db45EFxYW554+E3oaV6KeE5/z
ys7NJQZEUw2rWtdTLBaLXaH2uTPtUNnp8rXv1qx5r3rN+06JvlgVM3Ljs2fz
c3PzKl2Hbtx+/GTu/uzj+7OP4p+Pk/Uje/1AH1DzqvnEuorFYrEryr5IpjWs
Xb24/4BxvNKoqHDR8UqxKmbkxtkH5haVrgMDE3f/mo3G7kWnpt9atUpXNDYd
jc0k6im9nhHSxu4lixlVS5vqa/Ouw6mT48NyVRb2XdZVLBaLzcqaITYdb8rO
dLKfVGJp2tyVPOHWpkKj6aJxvjatmi6KGbl36s69qdh9la59/eMTt++O3ZqS
8SUKqaSNpfrjqZlkEY0PJ2bGLYdEdWs73LYqrHXAXNWHM69isVjssjZZxFLN
cas166g2Y54wXlRoNNQbZ04mfulKFFLKNtSLmfiW2PhE7FbkrkpXf284NHL7
RigiE0wUg6GIblXh1px07Q9aDxm0Hu5cHbTWclUfzryKxWKxWdob1tqhSX2X
KOzpKqjT6mS6yl1Dw5Hhm3+qdBVFXzAcuD4qE6y3P+zvC/f2p2yyGNXrRHE9
3Ns3mrJ9atdoQMxr1vYGwDksa7910m9e1LKqThYFFovFZm8D/WGh3uRnr9kP
m/144slhlWnqhPGi9UbDeaO22pSNmmNGdYVx7rRI11555vVwcHBCpWuPb6Tb
F+ryhWSCiaKrJ9TpG0rYHkvf1uyMN7t61PBQqu8L6VZt7EwznKh7htReOZz7
KhaLxcoEkx1RpzqJfkIq09QJY5+vM3O18qhRecQ4oX3fYEWJUX7AOLpPBOzY
xnXJLUP+QLj96g2Zrt2+kbaOASGZUa1XzbrtalBa1VfSh5OdoK2w2daOgVbr
llbzkKDb4UE5LFeVTbcqj9Iv59yLxWKxcZvotCb6FmnzlhPMdK0qNw4XG4eK
7c+u+/ca+34yyg+LdFXndPuGf2vyy3Tt6hlubum9fCUgM0oUUtI2X+m7bCpw
uSUgatO29GnD8SWzH4hPql3u1jasW3Wgc1Vlb+bVLC+ExWL/n7Y51XfJNLnq
zLSxjeuNisOLv+xRmTr/c6p++uMuo/Tg+Mb18b2B5pZAR+fgqdq2RLp2Dzc2
+S5e8suAEoWUzdpkXb2mrNa/5rSa7NZ2YJar8abl6steCIvFYpfTNfVpvnct
Pfhk104Zp3//sPNJXNI+3LHDOHhAzKi9re3BsorGZLqOnK+/Vt/o90Iy9/I7
md+9CCGUQZHNhUZJyf3t2x/u+N4p0TdKSyKb1svhCw3+lt8HivfXJtK162bd
me5zZ30IIYRsCm75xDhSapQKlbiopMQ4Utb/xWdy+Gyd71JTcPeeKpmuHR2h
yhOtNVXtCCGEbDpUdnpg46eTWzZMbCp0anJzYXBToZiRw9W/tl047yddEUIo
vyJdEULIC5GuCCHkhWzp2tkVqqpsPVnTjhBCKBfVVLc11KfSdSr2IDI5E5mc
RgghlKPu3Hmk0hUhhFB+JdL1PzHr1yI=
   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->18231757]
}, Open  ]],

Cell["Move the selection:", "ExampleText",
 CellID->554084566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->529888211],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+j961cOtpo03bZMqpqK2MaZN75r0wlRttTbFA3gA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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->4977952]
}, Open  ]],

Cell["Make the selection visible again:", "ExampleText",
 CellID->387978139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->274757738],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhqfpfeNf6P/oVdvLpiatV21SwRTUNqZpf0AvjIdWaiMewANQ
pYDiCYGKiOUgh2EYcEAGZEAGWxhNUfFACpEC3V171syatffsGUZmthj7PHkl
3/t931p7X70ZJoZ3t33zyba3PR7Pe+Kf/y2Px6wLC79HCCHkhpZXVhFCCOVQ
Kl3P1d5ACCGUE9nSdcM/QiOE0Bsgx3Q1AAAgCwrj37WSrgAAOYR0BQBwA9IV
AMANSFcAADcgXQEA3IB0BQBwA9IVAMANSFcAADcgXQEA3IB0BQBwA9IVAMAN
SFcAADcgXQEA1o3Hij4iXQEA1ofHCTUlXQEA1ofI0qI9H7XUF0pdrskjXQEA
ssf2qVUELOkKAJA9uU1X23cLuk0uHM/q1lY4PsLxhuTnOr5YqkcDAGRPDtM1
fTaqrEteduw4bqaqM3+Bl3olAIB1s1Hpmslx/fNnmke81AskHyRUAcANXn26
pvrVPs3xnKer/g5pXgkAYN28gnTVEzLDbwYy+ei75g3JT3R8hzSvBACwbnKY
rvptujVS5F6qg8mfKlM10z/aSBvya74SAEA25DZds3yTHN5AWgLAxkK6AgC4
weuTrjmE3/QBYMN5I9MVAGDDkaGa+FMDV0hXAIAcwGdXAAA38Fj/RlbpoU9J
VwCA7PE4oaakKwDAunHMVQnpCgDgBqQrAIAb6On69a6i8OQf9Y2+A0VVCCGE
stTyP8te39i33xUX7joo0lVofHwKIYRQltLTdTw0Yxirq6srCCGEstG/qyt6
ut4ZnV5eXllYfCG0GFWsXhA/l5RdWIgtiKZaVrWuRSwWi31N7Utn2vGy2vIt
79ds/qB684fJEn0xFTvy4IsXSwsLSypdh2/fez6/8Hju+eO5Z9Gfz+P1M3v9
RF9Q+6o5b51isVjsa2XXk2kNWz5eOXLUOF1pVFQ46HSlmIodeXDuiXlEpevg
4OSDv+amI4+mZ2bf2bRJ13RkdjryMFbP6PVDIW3tUbx4qGppE31t33E5cXN0
WU5lYT9lnWKxWGxG1gyx2WhTdmbj/bhio1nzVPyGu9vzjaarRt35lGq6Knbk
2Zn7j2Yij1W69g9MTN57MH53RsaXKKTiNpLoTyR24sV0dDm2M2G5ZFq3tstt
U2GtC+ZUX04/xWKx2DVtvIgkmhNWa9bT2o55w0RhvtFQb1w4G/tPV6KQUrah
XuxEj0QmJiN3ww9Uuvr6QsHRe7eDYZlgohgKhnWrCqfmlGN/yHrJkPXy5OmQ
tZZTfTn9FIvFYjO0t611kqb0U6Kwp6vgolbH01WeGh4Jj9z5U6WrKPoDIf+t
MZlgfQMhX3+obyBh48WYXseKW6G+/rGE7VenxvxiX7O2bwCSl2Xts276zIda
pupmUWCxWGzm1j8QEuqL/+wz+yGzH008uawyTd0wUZhnNNQZ56tN2aj5xaiu
MC7XinTtk3feCgWGJlW69nhHu73BLm9QJpgounqCnd7hmO2x9G3Nzmizq0ct
Dyf63qBu1cHOFMuxumdYnZXL2U+xWCxWJpjsiDrRifVjUpmmbhj/cquZq5Wn
jMqTxpkTiWitKDHKjxqnDouAHS/YGj8y7POH2m/eluna7R1t6xgUkhnVetOs
224GpFV9JX053gnYCptt7RhstR5pNS8JOF0ekMtyqmyqqbxKf1zyWSwWi43a
WKc11rdI27fcYKZrVblxotg4Xmz/7HrkoHH4J6P8hEhXdU+3d+S3Jp9M166e
keaWvus3/DKjRCElbfON/uum/Ndb/KI2bUu/thwdmX1/dFOdcra2Zd2qC5On
KnvTTzN8EBaL/X/a5kTfIdPkNDnTxgvyjIoTK4eKVKYu/ZyoF3/cb5QemyjI
i571N7f4OzqHzp1vi6Vr90hjk/fqNZ8MKFFI2axN1mmvslq/N9lqslvbhRlO
o03L09d8EBaLxa6lXvXT/N619Nj8/n0yTv/+Yd98VNI+3bvXOHZU7Kizre2B
sorGeLqO1tX31jf63JDMvdxu5vYsQgilUXhHvlFS8nj37qd79yRL9I3SkvD2
PLl8pcHX8vtg8ZHzsXTtunPxQvflS16EEEI2BXZ+ZpwsNUqFShxUUmKcLBv4
6gu5fOmi91pT4EBRlUzXjo5g5ZnWmqp2hBBCNh0vqx0s+Hxq57bJ7fnJmtqR
H9ieL3bkcvWvbVfqfKQrQgjlVqQrQgi5IdIVIYTckC1dO7uCVZWtZ2vaEUII
ZaOa6raG+kS6zkSehKcehqdmEUIIZan795+pdEUIIZRbiXT9DwXXs1k=
   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->132781594]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25865],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoScroll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoScroll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28663]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31059],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->5982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->25698872],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->5069787]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowSelection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 36.5262088}", "context" -> "System`", 
    "keywords" -> {
     "display selection", "flicker", "highlighting", "highlight selection", 
      "invisible selection", "selection", "visible selection"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ShowSelection is an option to Notebook, Cell and Style which specifies \
whether to show the current selection highlighted. ", 
    "synonyms" -> {"show selection"}, "title" -> "ShowSelection", "type" -> 
    "Symbol", "uri" -> "ref/ShowSelection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8990, 245, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->394209506]},
 "Notebook Image"->{
  Cell[9981, 285, 2540, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->564269062],
  Cell[12827, 344, 2519, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->18231757],
  Cell[15599, 402, 2518, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->4977952],
  Cell[18411, 461, 2544, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->132781594]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24107, 612},
 {"Notebook Image", 24248, 616}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1886, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2509, 75, 4197, 83, 70, "ObjectNameGrid"],
Cell[6709, 160, 901, 28, 70, "Usage",
 CellID->1899]
}, Open  ]],
Cell[CellGroupData[{
Cell[7647, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8125, 210, 261, 8, 70, "Notes",
 CellID->18640],
Cell[8389, 220, 274, 9, 70, "Notes",
 CellID->2969],
Cell[8666, 231, 287, 9, 70, "Notes",
 CellID->18374]
}, Closed]],
Cell[CellGroupData[{
Cell[8990, 245, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->394209506],
Cell[CellGroupData[{
Cell[9375, 259, 148, 5, 70, "ExampleSection",
 CellID->394991057],
Cell[9526, 266, 92, 1, 70, "ExampleText",
 CellID->237750221],
Cell[9621, 269, 176, 6, 70, "Input",
 CellID->779427064],
Cell[CellGroupData[{
Cell[9822, 279, 156, 4, 70, "Input",
 CellID->92311909],
Cell[9981, 285, 2540, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->564269062]
}, Open  ]],
Cell[12536, 332, 87, 1, 70, "ExampleText",
 CellID->6654369],
Cell[CellGroupData[{
Cell[12648, 337, 176, 5, 70, "Input",
 CellID->126390860],
Cell[12827, 344, 2519, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->18231757]
}, Open  ]],
Cell[15361, 391, 62, 1, 70, "ExampleText",
 CellID->554084566],
Cell[CellGroupData[{
Cell[15448, 396, 148, 4, 70, "Input",
 CellID->529888211],
Cell[15599, 402, 2518, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->4977952]
}, Open  ]],
Cell[18132, 449, 76, 1, 70, "ExampleText",
 CellID->387978139],
Cell[CellGroupData[{
Cell[18233, 454, 175, 5, 70, "Input",
 CellID->274757738],
Cell[18411, 461, 2544, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->132781594]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21016, 512, 311, 9, 70, "SeeAlsoSection",
 CellID->25865],
Cell[21330, 523, 459, 17, 70, "SeeAlso",
 CellID->28663]
}, Open  ]],
Cell[CellGroupData[{
Cell[21826, 545, 314, 9, 70, "TutorialsSection",
 CellID->31059],
Cell[22143, 556, 150, 3, 70, "Tutorials",
 CellID->5982]
}, Open  ]],
Cell[CellGroupData[{
Cell[22330, 564, 318, 9, 70, "MoreAboutSection",
 CellID->25698872],
Cell[22651, 575, 167, 3, 70, "MoreAbout",
 CellID->5069787]
}, Open  ]],
Cell[22833, 581, 50, 0, 70, "History"],
Cell[22886, 583, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

