(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12624,        433]
NotebookOptionsPosition[      9740,        340]
NotebookOutlinePosition[     11127,        378]
CellTagsIndexPosition[     11042,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SphericalRegion" :> 
          Documentation`HelpLookup["paclet:ref/SphericalRegion"], 
          "ActionDelay" :> 
          Documentation`HelpLookup["paclet:ref/ActionDelay"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SphericalRegion\"\>", 
       2->"\<\"ActionDelay\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ShrinkingDelay", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShrinkingDelay",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShrinkingDelay"]], "InlineFormula"],
     " \[LineSeparator]is an option for dynamic objects that specifies how \
long to delay before shrinking the size of the region in which the object is \
displayed to the actual size of the object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShrinkingDelay", "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " specifies a delay of at most ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->14457],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShrinkingDelay", "->", "0"}]], "InlineFormula"],
 " specifies that the region should always be resized immediately."
}], "Notes",
 CellID->18549],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShrinkingDelay", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that the region should never shrink, so that it is always as \
large as it has ever been in this session."
}], "Notes",
 CellID->1832],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ShrinkingDelay", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " is used in functions such as ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " to indicate that the region should not shrink over the course of the \
animation."
}], "Notes",
 CellID->76283304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShrinkingDelay",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShrinkingDelay"]], "InlineFormula"],
 " applies to both width and height."
}], "Notes",
 CellID->3273]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->800592633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->71991361],

Cell["\<\
Specify a time delay before shrinking the dynamic display region:\
\>", "ExampleText",
 CellID->1229957343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Checkbox", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", "1"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2017956513],

Cell[BoxData[
 CheckboxBox[Dynamic[$CellContext`x], {Graphics[
   Disk[{0, 0}]], 1}]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26381067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ShrinkingDelay", "\[Rule]", "0.1"}]}], "]"}]}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ShrinkingDelay", "\[Rule]", "1"}]}], "]"}]}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1613524113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{180., {88., 92.}},
     ShrinkingDelay->0.1],
    StripOnInput->False], ",", 
   FrameBox[
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{180., {88., 92.}},
     ShrinkingDelay->1],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{410, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98720637]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24945],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ActionDelay",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionDelay"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->408646090]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShrinkingDelay - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 39.8544190}", "context" -> "System`", 
    "keywords" -> {"resize delay", "resizing delay"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ShrinkingDelay is an option for dynamic objects that specifies how long \
to delay before shrinking the size of the region in which the object is \
displayed to the actual size of the object. ", 
    "synonyms" -> {"shrinking delay"}, "title" -> "ShrinkingDelay", "type" -> 
    "Symbol", "uri" -> "ref/ShrinkingDelay"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6142, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->800592633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10899, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1388, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2011, 62, 1579, 37, 70, "ObjectNameGrid"],
Cell[3593, 101, 573, 15, 70, "Usage",
 CellID->13637]
}, Open  ]],
Cell[CellGroupData[{
Cell[4203, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4681, 138, 245, 9, 70, "Notes",
 CellID->14457],
Cell[4929, 149, 187, 5, 70, "Notes",
 CellID->18549],
Cell[5119, 156, 322, 9, 70, "Notes",
 CellID->1832],
Cell[5444, 167, 446, 14, 70, "Notes",
 CellID->76283304],
Cell[5893, 183, 212, 7, 70, "Notes",
 CellID->3273]
}, Closed]],
Cell[CellGroupData[{
Cell[6142, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->800592633],
Cell[CellGroupData[{
Cell[6527, 209, 147, 5, 70, "ExampleSection",
 CellID->71991361],
Cell[6677, 216, 117, 3, 70, "ExampleText",
 CellID->1229957343],
Cell[CellGroupData[{
Cell[6819, 223, 282, 10, 28, "Input",
 CellID->2017956513],
Cell[7104, 235, 225, 7, 36, "Output",
 CellID->26381067]
}, Open  ]],
Cell[CellGroupData[{
Cell[7366, 247, 394, 13, 28, "Input",
 CellID->1613524113],
Cell[7763, 262, 516, 17, 213, "Output",
 CellID->98720637]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8340, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->24945],
Cell[8654, 297, 471, 17, 70, "SeeAlso",
 CellID->23720]
}, Open  ]],
Cell[CellGroupData[{
Cell[9162, 319, 299, 8, 70, "MoreAboutSection"],
Cell[9464, 329, 204, 4, 70, "MoreAbout",
 CellID->408646090]
}, Open  ]],
Cell[9683, 336, 27, 0, 70, "History"],
Cell[9713, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

