(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10477,        378]
NotebookOptionsPosition[      7628,        284]
NotebookOutlinePosition[      9001,        323]
CellTagsIndexPosition[      8917,        318]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberPadding" :> 
          Documentation`HelpLookup["paclet:ref/NumberPadding"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberPadding\"\>", 
       2->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SignPadding", "ObjectName",
 CellID->14316],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SignPadding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SignPadding"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which specifies whether padding should be \
inserted after signs. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SignPadding", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that any padding that is needed should be inserted between the \
sign and the digits in a number. "
}], "Notes",
 CellID->12728],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SignPadding", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " specifies that the padding should be inserted before the sign. "
}], "Notes",
 CellID->2723]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65384384],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->98426550],

Cell["The default pads before signs:", "ExampleText",
 CellID->9233180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.23"}], ",", "2.46"}], "}"}], ",", "5", ",", 
   RowBox[{"NumberPadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\< \>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213642315],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"  -1.23\"\>",
     -1.23,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   2.46\"\>",
     2.46,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5, NumberPadding -> {" ", " "}]& ]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->464713926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212544372],

Cell["Pad between signs and numbers instead:", "ExampleText",
 CellID->31886348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.23"}], ",", "2.46"}], "}"}], ",", "5", ",", 
   RowBox[{"SignPadding", "\[Rule]", "True"}], ",", 
   RowBox[{"NumberPadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\< \>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317706844],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"-  1.23\"\>",
     -1.23,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"   2.46\"\>",
     2.46,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5, SignPadding -> True, 
   NumberPadding -> {" ", " "}]& ]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->248545700]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27242],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberPadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberPadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20958],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->10214]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SignPadding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 47.7452460}", "context" -> "System`", 
    "keywords" -> {
     "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SignPadding is an option for NumberForm and related functions which \
specifies whether padding should be inserted after signs. ", 
    "synonyms" -> {"sign padding"}, "title" -> "SignPadding", "type" -> 
    "Symbol", "uri" -> "ref/SignPadding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3745, 128, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->65384384]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8775, 311}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1306, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1929, 60, 49, 1, 70, "ObjectName",
 CellID->14316],
Cell[1981, 63, 643, 19, 70, "Usage",
 CellID->12651]
}, Open  ]],
Cell[CellGroupData[{
Cell[2661, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3139, 104, 305, 9, 70, "Notes",
 CellID->12728],
Cell[3447, 115, 261, 8, 70, "Notes",
 CellID->2723]
}, Closed]],
Cell[CellGroupData[{
Cell[3745, 128, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65384384],
Cell[CellGroupData[{
Cell[4129, 142, 147, 5, 70, "ExampleSection",
 CellID->98426550],
Cell[4279, 149, 71, 1, 70, "ExampleText",
 CellID->9233180],
Cell[CellGroupData[{
Cell[4375, 154, 324, 10, 28, "Input",
 CellID->213642315],
Cell[4702, 166, 424, 15, 50, "Output",
 CellID->464713926]
}, Open  ]],
Cell[5141, 184, 125, 3, 70, "ExampleDelimiter",
 CellID->212544372],
Cell[5269, 189, 80, 1, 70, "ExampleText",
 CellID->31886348],
Cell[CellGroupData[{
Cell[5374, 194, 377, 11, 70, "Input",
 CellID->317706844],
Cell[5754, 207, 449, 16, 50, "Output",
 CellID->248545700]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6264, 230, 311, 9, 70, "SeeAlsoSection",
 CellID->27242],
Cell[6578, 241, 464, 17, 70, "SeeAlso",
 CellID->4410]
}, Open  ]],
Cell[CellGroupData[{
Cell[7079, 263, 314, 9, 70, "TutorialsSection",
 CellID->20958],
Cell[7396, 274, 160, 3, 70, "Tutorials",
 CellID->10214]
}, Open  ]],
Cell[7571, 280, 27, 0, 70, "History"],
Cell[7601, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

