(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    128641,       3388]
NotebookOptionsPosition[    117014,       2973]
NotebookOutlinePosition[    118267,       3009]
CellTagsIndexPosition[    118180,       3004]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SinhIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinhIntegral"], "CosIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CosIntegral"], "ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], 
          "ExpIntegralEi" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralEi"], "FresnelS" :> 
          Documentation`HelpLookup["paclet:ref/FresnelS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SinhIntegral\"\>", 
       2->"\<\"CosIntegral\"\>", 3->"\<\"ExpIntegralE\"\>", 
       4->"\<\"ExpIntegralEi\"\>", 5->"\<\"FresnelS\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SinIntegral", "ObjectName",
 CellID->9852],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SinIntegral",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SinIntegral"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the sine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Si", "(", "z"}], TraditionalForm]], "InlineMath"],
     "). "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation. \
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Si", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"sin", "(", "t", ")"}], "/", "t"}], " ", "d", 
      "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19241],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->3837],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->62638472],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173570331],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->560255247],

Cell["Evaluate numerically:", "ExampleText",
 CellID->22534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", "2.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3955],

Cell[BoxData["1.8320965890813223`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61163796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22220],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Si", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26889257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1702],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1mU2IVlUYx4/vvfedj9QcDKqV01guW7gMrCDUTCUnHUeSFpMECpVhtqlN
bWpTm9okhC76gL7ASIzAIBIiQRIiISoIg7BFEiQthODtd57nfN1zz/vOjJnM
3LnnnOfz/zznOec+7lw4evCJpxaOHjqwML31yMIzBw8deHZ6y+EjTFUrjDGn
+H3yNsP7gDf5PTUY8Hc/zx7DeRnttM/64ve/nzh+/sMPvrt27Z9JO1NZevln
9grdDvvsv/vOhUMHT0L6xutf83L16rWJIvV2mUXea6+eta89GZ/96pcXnv/c
vo63bHgoW61lzIAp+zpW1LFNZi9f/gtDrlz52zQy/unHPw48/tFwro3ixxdn
fsaDw09/+tzR0/iEkCmhZnjum1+FRMaIBho/jhbfKqtoRRBomJ59VEi68O1v
dkmkTX52+of5uffwAyBYQPKxN88xg2pwXi0y4GEy2gvPKy9/GS3I7b/FPhuA
/+TkRRydffjtl148Yyqrv0EQLm3fdoIXXDKrfGwhRChTfR8XZkDKrJTxpUt/
MsYkiYupeEOIHbe9Dqs4HizsMyZOWIEthBuxY95GnMNdVFtdkik1rIzBlakJ
r50h4JhJLx9rmJWssQD0EiSMHfNbRmfce4wtqrkWZIBl8wNvEQniZf0Svxuw
RhPK3azkXY1m3ICb5ZXeIhID1NSHCrGsyWtmRZ3E0FraFK2c9JkLoSSOPDR1
7NIa7wWgYjYG9nDA1Nj02P73CTwG3SwyyCQ0+UjVKCpbhC6YvUV2WS3Z4DWh
nB/I1noPQMbGROURS/RYM3Pc1UPMcuGpix7f6yMNjpZW/KlIModjLrV2eSe5
6uZyz1Ty/V6yemDyehTs0fIi9saM3u5GY+5vOV5zMguA4DPcEqUiZGSTp4qa
5vzOI2SLycAP8FmMipgAYFfTXh8RQBmE2luq0PneEmrjkkiTPJO9I6MW+/px
bIzWs7Ldm4fkaFeKIlCWsrgNikw1SDO9yDWWcvGkatiTpIzYkiToATICc1+7
eh77moQISR6RlmfDXtcTVBWYfckau5bKUFyrQ260ZApFrU4q0744n5x9OUew
sM1RB+vCvPcwjZyv2DoXrDbZ+V+nSI61sY2pHjT5XNItm7DmvDGsgXeIvn7K
o2jE/Ony+EqiFUYxijp8Pe45qplB3G92vLYor5NflWJs5d6ZSZjJNAi9etIE
5D3+mezpjvacYmrQrowivQYSgDHG2zNaxvRQW+wFdYX9q3OVW0ozZaTk2wdJ
JRlJuU7GhJ8ksPLvWpTjjiJF2+L0lLk+fIWi4nQ3S0VzpqDz/7GKo98JuRFW
6S0xlTFC9xKss/fdpVq3boTutpVpnvvdlY7Xi2SONhev9YX1dKwp/ahwcSFw
mueTWSphYZZS5zTo7H7vkavZe9uz7utEZ20F+dij4G7r0ffyzW34ePV/XA9j
931zw+QtkV4jsDGb3eDiM1ukDrhyfSqgzXZtz+ptSS9adnJPm97dBjIp7qjI
pcSDPpPiim4mxZW0eDcZdu42QQNnKOkVNchXevccTG+DCYV+C88tg7MSrXod
tnO7r0Or3ieHafW+NcmKXvRHcZS/NGLnYE8LU18Z6kQWX1zkwlyMSBMk6sU7
iWG4UWtDI41u5MJHPC2vAaCteQWJKLJfU0Uu/t236Vi61rrfqJm7g6fDvgU8
wroWv24eEc6dGUf3PK47mjWiu5fBX3l/3TfccnjbunXTLIs/z8tkF80uQ07c
nfGePRvQT78K8gxVrfEOPhsj2qGK3aNIFTVrF2C4jCrzb9cIqujFrpYm8fXE
8fOjNMTv2y5v+l27xlvtvu03BbyGdYVKu1vuM2xu+7rKa6DY2uoZ+hAkpe2i
3FOMaH5y5vvE+7zK20up5N7uMgFt2pjz3ZUaY9QjlmaWrLEKCEX8bvL+aEPN
8WnHz5480iWqUYy/eMmsdpJ4pwBgMhtiylvN7sp7mb6zdH2YpJ1EtRTlrkM6
5i1nQ9s+g3bkMEd7b8Bnb0IipaFQYZP282xfU2l5w0hc0h6rkS5arVBTnJHT
FC33u7F8v4gVbsJFNXQl0c4udN07DNRenN66G9a13evOfP2ixAdmsY4FLCNE
eiuLN4ZqqI0lmxX1uMvHs3zQfiWFIs2HmnXGAII5kqMr9UqBUbiLixAgU6Fj
WyCcXJgKu61zCnZQi3EOcQUd+9EttzTXg9ZQ9+xWtnGCAn0siaZx4qnddCax
ICSg7JlOJVEkYic2H0vt6OMGUwjkB4HAfneQ5r1KexJNhu/mom7liv8/UfmY
6n+JmC0tHeN+f4GAXe35sZYEs7WoQ7j6xAkqYNFMh/zBIvWER5l4gixqtrVs
mC9y6d3RrPgXk3Noaw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->664765845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211693848],

Cell[TextData[{
 "Differentiate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Si", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->80132538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SinIntegral", "'"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->475946962],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", "x", "]"}], "x"]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562904611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27897],

Cell["Series expansion at the origin", "ExampleText",
 CellID->698267265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17194],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "18"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "600"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "35280"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "3265920"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 18], 0, 
    Rational[1, 600], 0, 
    Rational[-1, 35280], 0, 
    Rational[1, 3265920]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{255, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563394594]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28898],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->532042279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290566174],

Cell[BoxData[
 RowBox[{"1.9954872853802748`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.22299529660903003`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391527249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->276384129],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->17256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19494],

Cell[BoxData["1.\
6054129768026948485767201481985889408485834223284996602890062442484`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233793752]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->11965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16124],

Cell[BoxData["1.60541297680269484857672014816870653491`21.353236704643535"], \
"Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->619192274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", 
  RowBox[{"{", 
   RowBox[{"1.5", ",", "2.5", ",", "3.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.3246835311721195`", ",", "1.7785201734438267`", ",", 
   "1.8331253986659974`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221340028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13384],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->32522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13298],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23098361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21401],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113405315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224717493],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->295516825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SinIntegral", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->32117073],

Cell[BoxData[
 FormBox[
  RowBox[{"Si", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->43078098]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31661],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->20899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15157],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "18"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2], 
    Rational[1, 18]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{118, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460660265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27304],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->1984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32241],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", "x"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], "3"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 1, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {-2, 0, 4}, 1, 4, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["1", "x"], ")"}], "2"]}]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 2, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {-2}, 2, 4, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{405, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474004077]
}, Open  ]],

Cell[TextData[{
 "Give the result for an arbitrary symbolic direction ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "z", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5618],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"\[Pi]", "-", 
         RowBox[{"2", " ", 
          RowBox[{"Arg", "[", "z", "]"}]}]}], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", "\[Pi]"}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", "x"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "2"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[$CellContext`z], {}, 1, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[$CellContext`z], {-2}, 1, 2, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["1", "x"], ")"}], "2"]}]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "3"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[$CellContext`z], {}, 2, 3, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[$CellContext`z], {-2}, 2, 3, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{470, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279844246]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21462],

Cell["Plot the absolute value in the complex plane:", "ExampleText",
 CellID->6521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15873],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{232, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509014971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110614886],

Cell["\<\
Real part of the Euler\[Dash]Heisenberg effective action:\
\>", "ExampleText",
 CellID->79086659],

Cell[BoxData[
 RowBox[{
  RowBox[{"action", "[", 
   RowBox[{"k_", ",", 
    RowBox[{"{", 
     RowBox[{"m_", ",", "e_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"k", " ", "\[Pi]", " ", 
        FractionBox[
         SuperscriptBox["m", "2"], 
         RowBox[{"e", " ", "a"}]]}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"k", " ", "\[Pi]", " ", 
        FractionBox[
         SuperscriptBox["m", "2"], 
         RowBox[{"e", " ", "b"}]]}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], "a", " ", "b"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Pi]", "3"], "k"}]]}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{"k", " ", "\[Pi]", " ", 
          FractionBox["b", "a"]}], "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"CosIntegral", "[", "x", "]"}], " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"SinIntegral", "[", "x", "]"}], "-", 
             RowBox[{"\[Pi]", "/", "2"}]}], ")"}], 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], "-", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{"k", " ", "\[Pi]", " ", 
          FractionBox["a", "b"]}], "]"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ExpIntegralEi", "[", "y", "]"}], " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"-", "y"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"ExpIntegralEi", "[", 
             RowBox[{"-", "y"}], "]"}], " ", 
            RowBox[{"Exp", "[", "y", "]"}]}]}], ")"}], "/", "2"}]}]}], 
      ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182242883],

Cell[TextData[{
 "Find a leading term in ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->90469920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"q", ">", "0"}], "&&", 
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"m", ">", "0"}], "&&", 
     RowBox[{"k", ">", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"action", "[", 
        RowBox[{"k", ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", "q"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", " ", "b"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"q", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", "Normal"}], "//",
     "FullSimplify"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->511909908],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", "b", " ", 
   SuperscriptBox["q", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"Coth", "[", 
       FractionBox[
        RowBox[{"a", " ", "k", " ", "\[Pi]"}], "b"], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"Coth", "[", 
       FractionBox[
        RowBox[{"b", " ", "k", " ", "\[Pi]"}], "a"], "]"}]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["k", "3"], " ", 
   SuperscriptBox["m", "4"], " ", 
   SuperscriptBox["\[Pi]", "5"]}]]], "Output",
 ImageSize->{236, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124126888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24918],

Cell["Gibbs phenomenon for a square wave:", "ExampleText",
 CellID->23427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], "-", 
       RowBox[{"4", "x", " ", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"Sinc", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "k"}], "-", "1"}], ")"}], "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "n"}], "}"}]}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4899],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1532091]
}, Open  ]],

Cell["Magnify the overshoot region:", "ExampleText",
 CellID->12712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.45", ",", " ", "0.55"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", " ", "1.2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18215],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326016149]
}, Open  ]],

Cell["Compute the asymptotic overshoot:", "ExampleText",
 CellID->163319886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "+", 
   RowBox[{
    RowBox[{"SinIntegral", "[", "Pi", "]"}], "/", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->451454927],

Cell[BoxData["1.0894898722360837`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->136887895]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27381],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->189553821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", 
  RowBox[{"-", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451830851],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"SinIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374823258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16715],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing sine integrals:"
}], "ExampleText",
 CellID->16452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"SinIntegral", "[", "z", "]"}]}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"I", " ", "z"}], "]"}]}], "-", 
    RowBox[{"I", " ", 
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "z"}], "]"}]}]}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169634331],

Cell[BoxData[
 RowBox[{"-", "\[Pi]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103909485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19638],

Cell["Find a numerical root:", "ExampleText",
 CellID->1988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SinIntegral", "[", "z", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "Pi"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.3201269035603038`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33930047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14473],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " from integrals, sums:"
}], "ExampleText",
 CellID->25218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "t", "]"}], "t"], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6397],

Cell[BoxData[
 RowBox[{"SinIntegral", "[", "z", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243961725]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], "\[Infinity]"], 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "k"], " ", 
     SuperscriptBox["z", 
      RowBox[{"2", " ", "k"}]]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "k"}]}], ")"}], "2"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "k"}], ")"}], "!"}]}]]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6776],

Cell[BoxData[
 FractionBox[
  RowBox[{"SinIntegral", "[", "z", "]"}], "z"]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16121047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23715],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " from a differential equation:"
}], "ExampleText",
 CellID->19799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", "z", "]"}], "/.", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"z", " ", 
        RowBox[{
         RowBox[{"w", "'''"}], "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"w", "''"}], "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         RowBox[{"w", "'"}], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Log", "[", 
              FractionBox["\[ImaginaryI]", "z"], "]"}]}], "+", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], "]"}]}], ")"}]}], 
         "-", 
         RowBox[{"Log", "[", "z", "]"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Log", "[", 
              RowBox[{"-", 
               FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "+", 
            RowBox[{"Log", "[", 
             RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}]}], ")"}]}], "-", 
         RowBox[{"Log", "[", "z", "]"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{581, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36935766]
}, Open  ]],

Cell["Calculate the Wronskian:", "ExampleText",
 CellID->30572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
       RowBox[{"CosIntegral", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9420],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   SuperscriptBox["x", "2"]]}]], "Output",
 ImageSize->{29, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410857109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10097],

Cell["Integrals:", "ExampleText",
 CellID->4835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"z", " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"Sqrt", "[", "z", "]"}], "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17512],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", "z"}], ")"}], " ", 
     SqrtBox["z"], " ", 
     RowBox[{"Cos", "[", 
      SqrtBox["z"], "]"}]}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      SqrtBox["z"], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"SinIntegral", "[", 
      SqrtBox["z"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{445, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14608109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23504],

Cell["Laplace transform:", "ExampleText",
 CellID->13405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"SinIntegral", "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24440],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTan", "[", 
   FractionBox["1", "s"], "]"}], "s"]], "Output",
 ImageSize->{75, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605255160]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinIntegral"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->1057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinIntegral", "[", 
  RowBox[{"10000.", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17464],

Cell[BoxData[
 RowBox[{"1.42370188436561767206433693908159`15.954589770191005*^4338", "-", 
  RowBox[{
  "2.7693046782493969602319371260002`15.954589770191005*^4338", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{358, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9193384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9556],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->17855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SinIntegral", "[", 
     RowBox[{"10", "^", "60"}], "]"}], "-", 
    RowBox[{"Pi", "/", "2"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9224],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(\[Pi]\\/2\\)\\)\\)\\) + \
\\(\\(SinIntegral[\
1000000000000000000000000000000000000000000000000000000000000]\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->382934374],

Cell[BoxData["5.5718294824856670897291642`8.817488238297143*^-61"], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212868127]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "70"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SinIntegral", "[", 
       RowBox[{"10", "^", "60"}], "]"}], "-", 
      RowBox[{"Pi", "/", "2"}]}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->755],

Cell[BoxData["5.57182948248566708972916420591398993`20.*^-61"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472590228]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6983],

Cell["Nested integrals:", "ExampleText",
 CellID->11882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"SinIntegral", "[", " ", "x", "]"}], ",", "6"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14098],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Si", "(", "x", ")"}], ",", 
    RowBox[{
     RowBox[{"cos", "(", "x", ")"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"Si", "(", "x", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Si", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     FractionBox[
      RowBox[{"sin", "(", "x", ")"}], "2"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"Si", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"sin", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "24"], " ", 
      RowBox[{"Si", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "24"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "6"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "24"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
      RowBox[{"sin", "(", "x", ")"}]}], "-", 
     FractionBox[
      RowBox[{"sin", "(", "x", ")"}], "6"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "120"], " ", 
      RowBox[{"Si", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{
      FractionBox["1", "120"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "6"}], ")"}], " ", 
      RowBox[{"sin", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "120"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["x", "2"]}], "+", "24"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}]}], "+", 
     FractionBox[
      RowBox[{"cos", "(", "x", ")"}], "6"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "720"], " ", 
      RowBox[{"Si", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "6"]}], "+", 
     RowBox[{
      FractionBox["1", "40"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "6"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "720"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "-", 
        RowBox[{"20", " ", 
         SuperscriptBox["x", "2"]}], "+", "120"}], ")"}], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "60"], " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "120"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
      RowBox[{"sin", "(", "x", ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "720"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["x", "2"]}], "+", "24"}], ")"}], " ", 
      RowBox[{"sin", "(", "x", ")"}]}], "+", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"sin", "(", "x", ")"}]}], "20"]}]}], "}"}], 
  TraditionalForm]], "Output",
 ImageSize->{483, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->41338821]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28214],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinhIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinhIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6116],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->3388]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5505],

Cell[TextData[{
 ButtonBox["Demonstrations with SinIntegral",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=SinIntegral"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/SineIntegral.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/SinIntegral/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
SinIntegral"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->242243725],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->50501426],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->137895331]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SinIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 2.3549950}", "context" -> "System`", 
    "keywords" -> {"si", "sine integral", "sinus integral", "Ssi"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SinIntegral[z] gives the sine integral function Si(z). ", 
    "synonyms" -> {"sin integral"}, "title" -> "SinIntegral", "type" -> 
    "Symbol", "uri" -> "ref/SinIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5751, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173570331]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 118037, 2997}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2402, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3025, 84, 48, 1, 70, "ObjectName",
 CellID->9852],
Cell[3076, 87, 593, 19, 70, "Usage",
 CellID->7516]
}, Open  ]],
Cell[CellGroupData[{
Cell[3706, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4184, 128, 121, 4, 70, "Notes",
 CellID->20640],
Cell[4308, 134, 355, 13, 70, "Notes",
 CellID->19241],
Cell[4666, 149, 355, 12, 70, "Notes",
 CellID->3837],
Cell[5024, 163, 253, 8, 70, "Notes",
 CellID->62638472],
Cell[5280, 173, 224, 7, 70, "Notes",
 CellID->31226],
Cell[5507, 182, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5751, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173570331],
Cell[CellGroupData[{
Cell[6136, 208, 148, 5, 70, "ExampleSection",
 CellID->560255247],
Cell[6287, 215, 60, 1, 70, "ExampleText",
 CellID->22534],
Cell[CellGroupData[{
Cell[6372, 220, 104, 3, 28, "Input",
 CellID->3955],
Cell[6479, 225, 175, 5, 36, "Output",
 CellID->61163796]
}, Open  ]],
Cell[6669, 233, 121, 3, 70, "ExampleDelimiter",
 CellID->22220],
Cell[6793, 238, 162, 7, 70, "ExampleText",
 CellID->26889257],
Cell[CellGroupData[{
Cell[6980, 249, 239, 8, 28, "Input",
 CellID->1702],
Cell[7222, 259, 2612, 47, 129, "Output",
 Evaluatable->False,
 CellID->664765845]
}, Open  ]],
Cell[9849, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->211693848],
Cell[9977, 314, 171, 7, 70, "ExampleText",
 CellID->80132538],
Cell[CellGroupData[{
Cell[10173, 325, 125, 4, 70, "Input",
 CellID->475946962],
Cell[10301, 331, 208, 7, 51, "Output",
 CellID->562904611]
}, Open  ]],
Cell[10524, 341, 121, 3, 70, "ExampleDelimiter",
 CellID->27897],
Cell[10648, 346, 73, 1, 70, "ExampleText",
 CellID->698267265],
Cell[CellGroupData[{
Cell[10746, 351, 220, 7, 70, "Input",
 CellID->17194],
Cell[10969, 360, 777, 26, 54, "Output",
 CellID->563394594]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11795, 392, 216, 7, 70, "ExampleSection",
 CellID->28898],
Cell[12014, 401, 74, 1, 70, "ExampleText",
 CellID->532042279],
Cell[CellGroupData[{
Cell[12113, 406, 132, 4, 70, "Input",
 CellID->290566174],
Cell[12248, 412, 274, 7, 36, "Output",
 CellID->391527249]
}, Open  ]],
Cell[12537, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->276384129],
Cell[12665, 427, 66, 1, 70, "ExampleText",
 CellID->17256],
Cell[CellGroupData[{
Cell[12756, 432, 156, 5, 70, "Input",
 CellID->19494],
Cell[12915, 439, 235, 7, 36, "Output",
 CellID->233793752]
}, Open  ]],
Cell[13165, 449, 109, 3, 70, "ExampleText",
 CellID->11965],
Cell[CellGroupData[{
Cell[13299, 456, 126, 3, 70, "Input",
 CellID->16124],
Cell[13428, 461, 219, 6, 36, "Output",
 CellID->619192274]
}, Open  ]],
Cell[13662, 470, 120, 3, 70, "ExampleDelimiter",
 CellID->5654],
Cell[13785, 475, 218, 7, 70, "ExampleText",
 CellID->455],
Cell[CellGroupData[{
Cell[14028, 486, 166, 5, 70, "Input",
 CellID->18629],
Cell[14197, 493, 275, 9, 36, "Output",
 CellID->221340028]
}, Open  ]],
Cell[14487, 505, 121, 3, 70, "ExampleDelimiter",
 CellID->13384],
Cell[14611, 510, 87, 1, 70, "ExampleText",
 CellID->32522],
Cell[CellGroupData[{
Cell[14723, 515, 103, 3, 70, "Input",
 CellID->13298],
Cell[14829, 520, 157, 5, 36, "Output",
 CellID->23098361]
}, Open  ]],
Cell[CellGroupData[{
Cell[15023, 530, 110, 3, 70, "Input",
 CellID->21401],
Cell[15136, 535, 182, 6, 49, "Output",
 CellID->113405315]
}, Open  ]],
Cell[15333, 544, 125, 3, 70, "ExampleDelimiter",
 CellID->224717493],
Cell[15461, 549, 203, 7, 70, "ExampleText",
 CellID->295516825],
Cell[CellGroupData[{
Cell[15689, 560, 146, 5, 70, "Input",
 CellID->32117073],
Cell[15838, 567, 231, 7, 50, "Output",
 CellID->43078098]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16118, 580, 239, 7, 70, "ExampleSection",
 CellID->31661],
Cell[16360, 589, 211, 7, 70, "ExampleText",
 CellID->20899],
Cell[CellGroupData[{
Cell[16596, 600, 297, 10, 70, "Input",
 CellID->15157],
Cell[16896, 612, 578, 20, 54, "Output",
 CellID->460660265]
}, Open  ]],
Cell[17489, 635, 121, 3, 70, "ExampleDelimiter",
 CellID->27304],
Cell[17613, 640, 73, 1, 70, "ExampleText",
 CellID->1984],
Cell[CellGroupData[{
Cell[17711, 645, 226, 7, 70, "Input",
 CellID->32241],
Cell[17940, 654, 1551, 50, 52, "Output",
 CellID->474004077]
}, Open  ]],
Cell[19506, 707, 176, 6, 70, "ExampleText",
 CellID->26025],
Cell[CellGroupData[{
Cell[19707, 717, 267, 9, 70, "Input",
 CellID->5618],
Cell[19977, 728, 1764, 56, 54, "Output",
 CellID->279844246]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21790, 790, 223, 7, 70, "ExampleSection",
 CellID->21462],
Cell[22016, 799, 83, 1, 70, "ExampleText",
 CellID->6521],
Cell[CellGroupData[{
Cell[22124, 804, 417, 14, 70, "Input",
 CellID->15873],
Cell[22544, 820, 42282, 697, 70, "Output",
 Evaluatable->False,
 CellID->509014971]
}, Open  ]],
Cell[64841, 1520, 125, 3, 70, "ExampleDelimiter",
 CellID->110614886],
Cell[64969, 1525, 107, 3, 70, "ExampleText",
 CellID->79086659],
Cell[65079, 1530, 2025, 64, 70, "Input",
 CellID->182242883],
Cell[67107, 1596, 150, 6, 70, "ExampleText",
 CellID->90469920],
Cell[CellGroupData[{
Cell[67282, 1606, 769, 24, 70, "Input",
 CellID->511909908],
Cell[68054, 1632, 734, 24, 61, "Output",
 CellID->124126888]
}, Open  ]],
Cell[68803, 1659, 121, 3, 70, "ExampleDelimiter",
 CellID->24918],
Cell[68927, 1664, 74, 1, 70, "ExampleText",
 CellID->23427],
Cell[CellGroupData[{
Cell[69026, 1669, 725, 23, 70, "Input",
 CellID->4899],
Cell[69754, 1694, 11211, 188, 70, "Output",
 Evaluatable->False,
 CellID->1532091]
}, Open  ]],
Cell[80980, 1885, 68, 1, 70, "ExampleText",
 CellID->12712],
Cell[CellGroupData[{
Cell[81073, 1890, 338, 11, 70, "Input",
 CellID->18215],
Cell[81414, 1903, 13494, 225, 70, "Output",
 Evaluatable->False,
 CellID->326016149]
}, Open  ]],
Cell[94923, 2131, 76, 1, 70, "ExampleText",
 CellID->163319886],
Cell[CellGroupData[{
Cell[95024, 2136, 210, 7, 70, "Input",
 CellID->451454927],
Cell[95237, 2145, 176, 5, 36, "Output",
 CellID->136887895]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95462, 2156, 233, 7, 70, "ExampleSection",
 CellID->27381],
Cell[95698, 2165, 90, 1, 70, "ExampleText",
 CellID->189553821],
Cell[CellGroupData[{
Cell[95813, 2170, 125, 4, 70, "Input",
 CellID->451830851],
Cell[95941, 2176, 214, 7, 36, "Output",
 CellID->374823258]
}, Open  ]],
Cell[96170, 2186, 121, 3, 70, "ExampleDelimiter",
 CellID->16715],
Cell[96294, 2191, 241, 8, 70, "ExampleText",
 CellID->16452],
Cell[CellGroupData[{
Cell[96560, 2203, 463, 15, 70, "Input",
 CellID->169634331],
Cell[97026, 2220, 179, 6, 36, "Output",
 CellID->103909485]
}, Open  ]],
Cell[97220, 2229, 121, 3, 70, "ExampleDelimiter",
 CellID->19638],
Cell[97344, 2234, 60, 1, 70, "ExampleText",
 CellID->1988],
Cell[CellGroupData[{
Cell[97429, 2239, 274, 9, 70, "Input",
 CellID->25246],
Cell[97706, 2250, 226, 7, 36, "Output",
 CellID->33930047]
}, Open  ]],
Cell[97947, 2260, 121, 3, 70, "ExampleDelimiter",
 CellID->14473],
Cell[98071, 2265, 213, 8, 70, "ExampleText",
 CellID->25218],
Cell[CellGroupData[{
Cell[98309, 2277, 236, 8, 70, "Input",
 CellID->6397],
Cell[98548, 2287, 196, 6, 36, "Output",
 CellID->243961725]
}, Open  ]],
Cell[CellGroupData[{
Cell[98781, 2298, 564, 21, 70, "Input",
 CellID->6776],
Cell[99348, 2321, 216, 7, 51, "Output",
 CellID->16121047]
}, Open  ]],
Cell[99579, 2331, 121, 3, 70, "ExampleDelimiter",
 CellID->23715],
Cell[99703, 2336, 221, 8, 70, "ExampleText",
 CellID->19799],
Cell[CellGroupData[{
Cell[99949, 2348, 591, 20, 70, "Input",
 CellID->7286],
Cell[100543, 2370, 1694, 50, 81, "Output",
 CellID->36935766]
}, Open  ]],
Cell[102252, 2423, 63, 1, 70, "ExampleText",
 CellID->30572],
Cell[CellGroupData[{
Cell[102340, 2428, 555, 18, 70, "Input",
 CellID->9420],
Cell[102898, 2448, 221, 8, 52, "Output",
 CellID->410857109]
}, Open  ]],
Cell[103134, 2459, 121, 3, 70, "ExampleDelimiter",
 CellID->10097],
Cell[103258, 2464, 48, 1, 70, "ExampleText",
 CellID->4835],
Cell[CellGroupData[{
Cell[103331, 2469, 222, 7, 70, "Input",
 CellID->17512],
Cell[103556, 2478, 702, 26, 51, "Output",
 CellID->14608109]
}, Open  ]],
Cell[104273, 2507, 121, 3, 70, "ExampleDelimiter",
 CellID->23504],
Cell[104397, 2512, 57, 1, 70, "ExampleText",
 CellID->13405],
Cell[CellGroupData[{
Cell[104479, 2517, 183, 6, 70, "Input",
 CellID->24440],
Cell[104665, 2525, 233, 8, 59, "Output",
 CellID->605255160]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104947, 2539, 225, 7, 70, "ExampleSection",
 CellID->1542],
Cell[105175, 2548, 237, 7, 70, "ExampleText",
 CellID->1057],
Cell[CellGroupData[{
Cell[105437, 2559, 180, 6, 70, "Input",
 CellID->17464],
Cell[105620, 2567, 336, 9, 36, "Output",
 CellID->9193384]
}, Open  ]],
Cell[105971, 2579, 120, 3, 70, "ExampleDelimiter",
 CellID->9556],
Cell[106094, 2584, 234, 8, 70, "ExampleText",
 CellID->17855],
Cell[CellGroupData[{
Cell[106353, 2596, 234, 8, 70, "Input",
 CellID->9224],
Cell[106590, 2606, 542, 10, 70, "Message",
 CellID->382934374],
Cell[107135, 2618, 208, 5, 36, "Output",
 CellID->212868127]
}, Open  ]],
Cell[CellGroupData[{
Cell[107380, 2628, 366, 12, 70, "Input",
 CellID->755],
Cell[107749, 2642, 204, 5, 36, "Output",
 CellID->472590228]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[108002, 2653, 223, 7, 70, "ExampleSection",
 CellID->6983],
Cell[108228, 2662, 56, 1, 70, "ExampleText",
 CellID->11882],
Cell[CellGroupData[{
Cell[108309, 2667, 306, 10, 70, "Input",
 CellID->14098],
Cell[108618, 2679, 4035, 126, 220, "Output",
 CellID->41338821]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112714, 2812, 311, 9, 70, "SeeAlsoSection",
 CellID->28214],
Cell[113028, 2823, 1217, 44, 70, "SeeAlso",
 CellID->5967]
}, Open  ]],
Cell[CellGroupData[{
Cell[114282, 2872, 313, 9, 70, "TutorialsSection",
 CellID->6116],
Cell[114598, 2883, 143, 3, 70, "Tutorials",
 CellID->3388]
}, Open  ]],
Cell[CellGroupData[{
Cell[114778, 2891, 320, 9, 70, "RelatedLinksSection",
 CellID->5505],
Cell[115101, 2902, 367, 12, 70, "RelatedLinks"],
Cell[115471, 2916, 183, 4, 70, "RelatedLinks"],
Cell[115657, 2922, 196, 4, 70, "RelatedLinks"],
Cell[115856, 2928, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116282, 2946, 319, 9, 70, "MoreAboutSection",
 CellID->242243725],
Cell[116604, 2957, 190, 4, 70, "MoreAbout",
 CellID->50501426],
Cell[116797, 2963, 145, 3, 70, "MoreAbout",
 CellID->137895331]
}, Open  ]],
Cell[116957, 2969, 27, 0, 70, "History"],
Cell[116987, 2971, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

