(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12209,        426]
NotebookOptionsPosition[      9141,        326]
NotebookOutlinePosition[     10497,        363]
CellTagsIndexPosition[     10412,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AutoItalicWords" :> 
          Documentation`HelpLookup["paclet:ref/AutoItalicWords"], "StyleBox" :> 
          Documentation`HelpLookup["paclet:ref/StyleBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AutoItalicWords\"\>", 
       2->"\<\"StyleBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>", 
       3->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SingleLetterItalics", "ObjectName",
 CellID->7239],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SingleLetterItalics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SingleLetterItalics"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether single\[Hyphen]letter names should be \
displayed in italics. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7904]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SingleLetterItalics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is typically set for cells that contain ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " expressions. "
}], "Notes",
 CellID->8084]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639368072],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->2992218],

Cell["\<\
Make variables with one-letter names appear in an italicized form: \
\>", "ExampleText",
 CellID->574549076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"SingleLetterItalics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87718655],

Cell[BoxData[
 StyleBox[
  RowBox[{"Sin", "[", 
   RowBox[{"x", " ", "y"}], "]"}],
  StripOnInput->False,
  SingleLetterItalics->True]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253259716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140295384],

Cell[TextData[{
 "Override single-letter italicization for a particular symbol in a ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output:"
}], "ExampleText",
 CellID->205213398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"T", ",", 
     RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174685336],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"sin", "(", 
    RowBox[{"x", " ", "y"}], ")"}], "+", 
   StyleBox["T",
    StripOnInput->False,
    SingleLetterItalics->False]}], TraditionalForm]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->164614641]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31546],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoItalicWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoItalicWords"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StyleBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StyleBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25176]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19697],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->70295303],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->578885052],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->236579488],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->223327297]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SingleLetterItalics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 50.9640784}", "context" -> "System`", 
    "keywords" -> {"italics", "single-letter italics", "variable names"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SingleLetterItalics is an option for Cell which specifies whether \
single-letter names should be displayed in italics. ", 
    "synonyms" -> {"single letter italics"}, "title" -> "SingleLetterItalics",
     "type" -> "Symbol", "uri" -> "ref/SingleLetterItalics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4561, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->639368072]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10269, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2287, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2910, 83, 56, 1, 70, "ObjectName",
 CellID->7239],
Cell[2969, 86, 644, 19, 70, "Usage",
 CellID->7904]
}, Open  ]],
Cell[CellGroupData[{
Cell[3650, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4128, 127, 396, 13, 70, "Notes",
 CellID->8084]
}, Closed]],
Cell[CellGroupData[{
Cell[4561, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639368072],
Cell[CellGroupData[{
Cell[4946, 159, 146, 5, 70, "ExampleSection",
 CellID->2992218],
Cell[5095, 166, 118, 3, 70, "ExampleText",
 CellID->574549076],
Cell[CellGroupData[{
Cell[5238, 173, 230, 7, 28, "Input",
 CellID->87718655],
Cell[5471, 182, 276, 10, 36, "Output",
 CellID->253259716]
}, Open  ]],
Cell[5762, 195, 125, 3, 70, "ExampleDelimiter",
 CellID->140295384],
Cell[5890, 200, 270, 8, 70, "ExampleText",
 CellID->205213398],
Cell[CellGroupData[{
Cell[6185, 212, 298, 9, 70, "Input",
 CellID->174685336],
Cell[6486, 223, 353, 12, 50, "Output",
 CellID->164614641]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6900, 242, 311, 9, 70, "SeeAlsoSection",
 CellID->31546],
Cell[7214, 253, 465, 17, 70, "SeeAlso",
 CellID->25176]
}, Open  ]],
Cell[CellGroupData[{
Cell[7716, 275, 314, 9, 70, "TutorialsSection",
 CellID->19697],
Cell[8033, 286, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[8257, 295, 318, 9, 70, "MoreAboutSection",
 CellID->70295303],
Cell[8578, 306, 171, 3, 70, "MoreAbout",
 CellID->578885052],
Cell[8752, 311, 180, 3, 70, "MoreAbout",
 CellID->236579488],
Cell[8935, 316, 134, 3, 70, "MoreAbout",
 CellID->223327297]
}, Open  ]],
Cell[9084, 322, 27, 0, 70, "History"],
Cell[9114, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

