(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52304,       1558]
NotebookOptionsPosition[     46125,       1343]
NotebookOutlinePosition[     47454,       1381]
CellTagsIndexPosition[     47368,       1376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ThreeJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/ThreeJSymbol"], 
          "ClebschGordan" :> 
          Documentation`HelpLookup["paclet:ref/ClebschGordan"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ThreeJSymbol\"\>", 
       2->"\<\"ClebschGordan\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions Used in Quantum Mechanics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SixJSymbol", "ObjectName",
 CellID->5768],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SixJSymbol",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SixJSymbol"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["3", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["4", "TR"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["5", "TR"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["6", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the values of the Racah 6\[Hyphen]j symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The 6\[Hyphen]j symbols vanish except when certain triples of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", "i"], TraditionalForm]], "InlineMath"],
 " satisfy triangle inequalities. "
}], "Notes",
 CellID->22990],

Cell[TextData[{
 "The parameters of ",
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 " can be integers, half\[Hyphen]integers or symbolic expressions. "
}], "Notes",
 CellID->23158]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->192116892],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->282132563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44743768],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"5", " ", 
   SqrtBox["21"]}]]], "Output",
 ImageSize->{49, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9291833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435530030],

Cell["Use symbolic arguments to obtain exact symbolic answers:", "ExampleText",
 CellID->366900915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "m", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341802944],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"-", "m"}]], " ", "m", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "m"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"600", "-", 
      RowBox[{"50", " ", "m"}], "-", 
      RowBox[{"49", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m", "3"]}], "+", 
      SuperscriptBox["m", "4"]}]]}], 
   RowBox[{"420", " ", 
    SqrtBox["6"]}]]}]], "Output",
 ImageSize->{292, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312609155]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 " works with integer and half\[Hyphen]integer arguments:"
}], "ExampleText",
 CellID->300859556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "/", "2"}], ",", 
     RowBox[{"7", "/", "2"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401393827],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   SqrtBox["21"]]}]], "Output",
 ImageSize->{47, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658902569]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109121241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->94332792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SixJSymbol", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j1", ",", "j2", ",", "j3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m1", ",", "m2", ",", "m3"}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463406249],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    StyleBox["{",
     SpanMaxSize->DirectedInfinity[1]],
    SixJSymbol], "\[MediumSpace]", GridBox[{
     {"j1", "j2", "j3"},
     {"m1", "m2", "m3"}
    }], "\[MediumSpace]", 
   TagBox[
    StyleBox["}",
     SpanMaxSize->DirectedInfinity[1]],
    SixJSymbol]}], TraditionalForm]], "Output",
 ImageSize->{90, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->613945538]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16283],

Cell[TextData[{
 "Plot 6\[Hyphen]",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " symbol coefficients as a function of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->409142946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SixJSymbol", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"j1", ",", "j2", ",", 
        RowBox[{"j1", "+", "j2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", 
        RowBox[{"j1", "+", "j2", "+", "6"}], ",", 
        RowBox[{"j2", "+", "6"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j1", ",", " ", "0", ",", " ", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j2", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{221, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75633224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347086915],

Cell[TextData[{
 "Confirm the Wigner formula for the asymptotic value of ",
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238554958],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j1", ",", "j2", ",", "j3", ",", "j4", ",", "j5", ",", "j6"}], 
    "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "105", ",", "107", ",", "106", ",", "106", ",", "102", ",", "109"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "j12", ",", "j13", ",", "j14", ",", "j23", ",", "j24", ",", "j34"}], 
    "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j1", ",", "j2", ",", "j3", ",", "j6", ",", "j5", ",", "j4"}], 
     "}"}], "+", 
    RowBox[{"1", "/", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vs", " ", "=", " ", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         SuperscriptBox["j34", "2"], ",", 
         SuperscriptBox["j24", "2"], ",", 
         SuperscriptBox["j23", "2"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["j34", "2"], ",", "0", ",", 
         SuperscriptBox["j14", "2"], ",", 
         SuperscriptBox["j13", "2"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["j24", "2"], ",", 
         SuperscriptBox["j14", "2"], ",", "0", ",", 
         SuperscriptBox["j12", "2"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["j23", "2"], ",", 
         SuperscriptBox["j13", "2"], ",", 
         SuperscriptBox["j12", "2"], ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}]}], "}"}],
      "]"}], "/", "288"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"SixJSymbol", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"j1", ",", "j2", ",", "j3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j4", ",", "j5", ",", "j6"}], "}"}]}], "]"}], "^", "2"}], ",",
     
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"24", " ", "Pi", " ", 
       RowBox[{"Sqrt", "[", "Vs", "]"}]}], ")"}]}]}], "}"}], " ", "//", " ", 
  "N"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->933597956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.394538108323096`*^-8", ",", "9.38530526176451`*^-8"}], 
  "}"}]], "Output",
 ImageSize->{199, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121703548]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12134],

Cell[TextData[{
 "Generate a 6-",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " symbol from a generating function:"
}], "ExampleText",
 CellID->651387548],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "j1", ",", " ", "j2", ",", " ", "j3", ",", " ", "j4", ",", " ", "j5", 
      ",", " ", "j6"}], "}"}], " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", " ", "2", ",", " ", "3", ",", " ", "1", ",", " ", "2", ",", 
      " ", "2"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "j1", "+", "j2", "+", "j3"}], ")"}], "!"}]], " ", 
       
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "j3", "+", "j4", "+", "j5"}], ")"}], "!"}]], " ", 
       
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "j2", "+", "j4", "+", "j6"}], ")"}], "!"}]], " ", 
       
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "j1", "+", "j5", "+", "j6"}], ")"}], "!"}]]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j1", "+", "j2", "-", "j3"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j1", "-", "j2", "+", "j3"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "j1"}], "+", "j2", "+", "j3"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j3", "+", "j4", "-", "j5"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j3", "-", "j4", "+", "j5"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "j3"}], "+", "j4", "+", "j5"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j2", "+", "j4", "-", "j6"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j1", "+", "j5", "-", "j6"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j2", "-", "j4", "+", "j6"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "j2"}], "+", "j4", "+", "j6"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j1", "-", "j5", "+", "j6"}], ")"}], "!"}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "j1"}], "+", "j5", "+", "j6"}], ")"}], "!"}]]}], 
      ")"}]}], "/", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"u", " ", "v", " ", "z"}], "+", 
            RowBox[{"u", " ", "w", " ", "y"}], "+", 
            RowBox[{"v", " ", "w", " ", "x"}], "+", 
            RowBox[{"x", " ", "y", " ", "z"}], "+", 
            RowBox[{"u", " ", "v", " ", "x", " ", "y"}], "+", 
            RowBox[{"u", " ", "w", " ", "x", " ", "z"}], "+", 
            RowBox[{"v", " ", "w", " ", "y", " ", "z"}]}], ")"}], "^", 
          "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0", ",", 
          RowBox[{"2", " ", "j1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "0", ",", 
          RowBox[{"2", " ", "j2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"w", ",", "0", ",", 
          RowBox[{"2", " ", "j3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", " ", "j4"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", 
          RowBox[{"2", " ", "j5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "0", ",", 
          RowBox[{"2", " ", "j6"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", " ", "j1"}], ",", 
        RowBox[{"2", " ", "j2"}], ",", 
        RowBox[{"2", " ", "j3"}], ",", 
        RowBox[{"2", " ", "j4"}], ",", 
        RowBox[{"2", " ", "j5"}], ",", 
        RowBox[{"2", " ", "j6"}]}], "}"}]}], "]"}]}], ")"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->274064440],

Cell[BoxData[
 FractionBox["1", "15"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439425094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j1", ",", "j2", ",", "j3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j4", ",", "j5", ",", "j6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699345827],

Cell[BoxData[
 FractionBox["1", "15"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47123391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27635265],

Cell["Express through Clebsch-Gordan coefficients:", "ExampleText",
 CellID->327358249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j1", "=", "1"}], ",", 
      RowBox[{"j2", "=", "2"}], ",", 
      RowBox[{"j12", "=", "1"}], ",", 
      RowBox[{"j3", "=", "2"}], ",", 
      RowBox[{"j", "=", "3"}], ",", 
      RowBox[{"j23", "=", "2"}], ",", 
      RowBox[{"m", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"j1", "+", "j2", "+", "j3", "+", "j"}], ")"}]}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j12"}], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j23"}], "+", "1"}], ")"}]}], "]"}]}], 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j12", ",", " ", "m12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j3", ",", " ", "m3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "m"}], "}"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", " ", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", " ", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j12", ",", "m12"}], "}"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", " ", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j23", ",", " ", "m23"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "m"}], "}"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j2", ",", " ", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j3", ",", " ", "m3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j23", ",", "m23"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", 
         RowBox[{"-", "j1"}], ",", "j1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m2", ",", 
         RowBox[{"-", "j2"}], ",", "j2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m3", ",", 
         RowBox[{"-", "j3"}], ",", "j3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m12", ",", 
         RowBox[{"-", "j12"}], ",", "j12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m23", ",", 
         RowBox[{"-", "j23"}], ",", "j23"}], "}"}]}], "]"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540428331],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"5", " ", 
   SqrtBox["21"]}]]], "Output",
 ImageSize->{49, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151021312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "=", "1"}], ",", 
     RowBox[{"j2", "=", "2"}], ",", 
     RowBox[{"j12", "=", "1"}], ",", 
     RowBox[{"j3", "=", "2"}], ",", 
     RowBox[{"j", "=", "3"}], ",", 
     RowBox[{"j23", "=", "2"}], ",", 
     RowBox[{"m", "=", "0"}]}], "}"}], ",", 
   RowBox[{"SixJSymbol", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"j1", ",", "j2", ",", "j12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j3", ",", "j", ",", "j23"}], "}"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->528472382],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"5", " ", 
   SqrtBox["21"]}]]], "Output",
 ImageSize->{49, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->974173983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14311],

Cell["\<\
A message is issued and the result 0 returned for unphysical cases:\
\>", "ExampleText",
 CellID->434775593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772169142],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"tri\"\>"}], ":", 
  " ", "\<\"\\!\\(SixJSymbol[\\(\\(\\(\\({1, 2, 3}\\)\\), \\(\\({4, 5, 12}\\)\
\\)\\)\\)]\\) is not triangular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ClebschGordan/tri\\\", ButtonNote -> \
\\\"ClebschGordan::tri\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->569228780],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274066891]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206613638],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"tri\"\>"}], ":", 
  " ", "\<\"\\!\\(SixJSymbol[\\(\\(\\(\\({1, 2, 3}\\)\\), \\(\\({4, 2, \[Pi]}\
\\)\\)\\)\\)]\\) is not triangular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ClebschGordan/tri\\\", ButtonNote -> \
\\\"ClebschGordan::tri\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->437365486],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->644610495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317683583],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 " always returns an exact result:"
}], "ExampleText",
 CellID->356917093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.", ",", "2.", ",", "3."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88499195],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", "21"]}]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320699168]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6721],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ThreeJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ThreeJSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClebschGordan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClebschGordan"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31785],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->1470]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20447],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Wigner6j-Symbol.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/SixJSymbol/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
SixJSymbol"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->818846868],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->432965623]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SixJSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 10.0739426}", "context" -> "System`", 
    "keywords" -> {
     "6j", "6-j symbols", "Racah coefficients", "sixj", "six j symbol", 
      "Wigner 6j-symbol"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SixJSymbol[{j_1, j_2, j_3}, {j_4, j_5, j_6}] gives the values of the \
Racah 6-j symbol. ", "synonyms" -> {"six symbol"}, "title" -> "SixJSymbol", 
    "type" -> "Symbol", "uri" -> "ref/SixJSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4825, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->192116892]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47225, 1369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1946, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2569, 78, 47, 1, 70, "ObjectName",
 CellID->5768],
Cell[2619, 81, 1154, 37, 70, "Usage",
 CellID->27945]
}, Open  ]],
Cell[CellGroupData[{
Cell[3810, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4288, 140, 238, 7, 70, "Notes",
 CellID->22990],
Cell[4529, 149, 259, 8, 70, "Notes",
 CellID->23158]
}, Closed]],
Cell[CellGroupData[{
Cell[4825, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->192116892],
Cell[CellGroupData[{
Cell[5210, 176, 148, 5, 70, "ExampleSection",
 CellID->282132563],
Cell[CellGroupData[{
Cell[5383, 185, 246, 8, 28, "Input",
 CellID->44743768],
Cell[5632, 195, 213, 8, 55, "Output",
 CellID->9291833]
}, Open  ]],
Cell[5860, 206, 125, 3, 70, "ExampleDelimiter",
 CellID->435530030],
Cell[5988, 211, 99, 1, 70, "ExampleText",
 CellID->366900915],
Cell[CellGroupData[{
Cell[6112, 216, 247, 8, 28, "Input",
 CellID->341802944],
Cell[6362, 226, 668, 24, 65, "Output",
 CellID->312609155]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7079, 256, 216, 7, 70, "ExampleSection",
 CellID->21345],
Cell[7298, 265, 236, 7, 70, "ExampleText",
 CellID->300859556],
Cell[CellGroupData[{
Cell[7559, 276, 351, 12, 70, "Input",
 CellID->401393827],
Cell[7913, 290, 210, 8, 55, "Output",
 CellID->658902569]
}, Open  ]],
Cell[8138, 301, 125, 3, 70, "ExampleDelimiter",
 CellID->109121241],
Cell[8266, 306, 202, 7, 70, "ExampleText",
 CellID->94332792],
Cell[CellGroupData[{
Cell[8493, 317, 299, 10, 70, "Input",
 CellID->463406249],
Cell[8795, 329, 488, 18, 66, "Output",
 CellID->613945538]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9332, 353, 223, 7, 70, "ExampleSection",
 CellID->16283],
Cell[9558, 362, 370, 14, 70, "ExampleText",
 CellID->409142946],
Cell[CellGroupData[{
Cell[9953, 380, 604, 18, 70, "Input",
 CellID->839245],
Cell[10560, 400, 17104, 284, 70, "Output",
 Evaluatable->False,
 CellID->75633224]
}, Open  ]],
Cell[27679, 687, 125, 3, 70, "ExampleDelimiter",
 CellID->347086915],
Cell[27807, 692, 242, 8, 70, "ExampleText",
 CellID->238554958],
Cell[CellGroupData[{
Cell[28074, 704, 2186, 67, 70, "Input",
 CellID->933597956],
Cell[30263, 773, 248, 8, 39, "Output",
 CellID->121703548]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30560, 787, 233, 7, 70, "ExampleSection",
 CellID->12134],
Cell[30796, 796, 168, 6, 70, "ExampleText",
 CellID->651387548],
Cell[CellGroupData[{
Cell[30989, 806, 4354, 136, 70, "Input",
 CellID->274064440],
Cell[35346, 944, 179, 6, 51, "Output",
 CellID->439425094]
}, Open  ]],
Cell[CellGroupData[{
Cell[35562, 955, 253, 8, 70, "Input",
 CellID->699345827],
Cell[35818, 965, 178, 6, 51, "Output",
 CellID->47123391]
}, Open  ]],
Cell[36011, 974, 124, 3, 70, "ExampleDelimiter",
 CellID->27635265],
Cell[36138, 979, 87, 1, 70, "ExampleText",
 CellID->327358249],
Cell[CellGroupData[{
Cell[36250, 984, 2694, 80, 70, "Input",
 CellID->540428331],
Cell[38947, 1066, 215, 8, 55, "Output",
 CellID->151021312]
}, Open  ]],
Cell[CellGroupData[{
Cell[39199, 1079, 609, 20, 70, "Input",
 CellID->528472382],
Cell[39811, 1101, 215, 8, 55, "Output",
 CellID->974173983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40075, 1115, 226, 7, 70, "ExampleSection",
 CellID->14311],
Cell[40304, 1124, 118, 3, 70, "ExampleText",
 CellID->434775593],
Cell[CellGroupData[{
Cell[40447, 1131, 248, 8, 70, "Input",
 CellID->772169142],
Cell[40698, 1141, 438, 8, 70, "Message",
 CellID->569228780],
Cell[41139, 1151, 158, 5, 36, "Output",
 CellID->274066891]
}, Open  ]],
Cell[CellGroupData[{
Cell[41334, 1161, 248, 8, 70, "Input",
 CellID->206613638],
Cell[41585, 1171, 441, 8, 70, "Message",
 CellID->437365486],
Cell[42029, 1181, 158, 5, 36, "Output",
 CellID->644610495]
}, Open  ]],
Cell[42202, 1189, 125, 3, 70, "ExampleDelimiter",
 CellID->317683583],
Cell[42330, 1194, 213, 7, 70, "ExampleText",
 CellID->356917093],
Cell[CellGroupData[{
Cell[42568, 1205, 252, 8, 70, "Input",
 CellID->88499195],
Cell[42823, 1215, 197, 7, 51, "Output",
 CellID->320699168]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43081, 1229, 310, 9, 70, "SeeAlsoSection",
 CellID->6721],
Cell[43394, 1240, 466, 17, 70, "SeeAlso",
 CellID->21]
}, Open  ]],
Cell[CellGroupData[{
Cell[43897, 1262, 314, 9, 70, "TutorialsSection",
 CellID->31785],
Cell[44214, 1273, 155, 3, 70, "Tutorials",
 CellID->1470]
}, Open  ]],
Cell[CellGroupData[{
Cell[44406, 1281, 321, 9, 70, "RelatedLinksSection",
 CellID->20447],
Cell[44730, 1292, 186, 4, 70, "RelatedLinks"],
Cell[44919, 1298, 206, 4, 70, "RelatedLinks"],
Cell[45128, 1304, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45553, 1322, 319, 9, 70, "MoreAboutSection",
 CellID->818846868],
Cell[45875, 1333, 178, 3, 70, "MoreAbout",
 CellID->432965623]
}, Open  ]],
Cell[46068, 1339, 27, 0, 70, "History"],
Cell[46098, 1341, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

