(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14753,        534]
NotebookOptionsPosition[     11008,        407]
NotebookOutlinePosition[     12345,        445]
CellTagsIndexPosition[     12260,        440]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/StreamPosition"], 
          "SetStreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/SetStreamPosition"], "Find" :> 
          Documentation`HelpLookup["paclet:ref/Find"], "EndOfFile" :> 
          Documentation`HelpLookup["paclet:ref/EndOfFile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StreamPosition\"\>", 
       2->"\<\"SetStreamPosition\"\>", 3->"\<\"Find\"\>", 
       4->"\<\"EndOfFile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"File Operations\"\>", 
       2->"\<\"Files\"\>", 3->"\<\"Low-Level File Operations\"\>", 
       4->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Skip", "ObjectName",
 CellID->8970],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Skip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Skip"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]skips one object of the specified type in an input \
stream. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Skip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Skip"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["type", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]skips ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " objects of the specified type. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " behaves like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ", except that it returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " when it succeeds in skipping the specified objects, and ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " otherwise. "
}], "Notes",
 CellID->14252]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->396855908],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4249506],

Cell["A file of numbers:", "ExampleText",
 CellID->1013637476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/numbers\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1843663910],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->120222178]
}, Open  ]],

Cell["Open a stream to read the file:", "ExampleText",
 CellID->1228493267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"OpenRead", "[", "\"\<ExampleData/numbers\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1719665206],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"ExampleData/numbers\"\>", ",", "56"}], "]"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490051]
}, Open  ]],

Cell["Read the first number:", "ExampleText",
 CellID->193170794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1280041117],

Cell[BoxData["11.1`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1143439]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " the second number:"
}], "ExampleText",
 CellID->1882465175],

Cell[BoxData[
 RowBox[{"Skip", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->563688414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1360807181],

Cell[BoxData["33.3`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5868650]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->1773744141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1456159867],

Cell[BoxData["\<\"ExampleData/numbers\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->379235505]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23376],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StreamPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetStreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetStreamPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Find",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Find"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndOfFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndOfFile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31360],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->6954]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->438911079],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->153939640],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->133008314],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->489360863],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->283387063]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Skip - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 12.9490162}", "context" -> "System`", 
    "keywords" -> {
     "discard data", "ignore data", "file operations", "file utiltities"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Skip[stream, type] skips one object of the specified type in an input \
stream. Skip[stream, type, n] skips n objects of the specified type. ", 
    "synonyms" -> {"fread"}, "title" -> "Skip", "type" -> "Symbol", "uri" -> 
    "ref/Skip"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5312, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->396855908]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12117, 433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2457, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3080, 84, 41, 1, 70, "ObjectName",
 CellID->8970],
Cell[3124, 87, 1015, 33, 70, "Usage",
 CellID->8320]
}, Open  ]],
Cell[CellGroupData[{
Cell[4176, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4654, 142, 621, 22, 70, "Notes",
 CellID->14252]
}, Closed]],
Cell[CellGroupData[{
Cell[5312, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->396855908],
Cell[CellGroupData[{
Cell[5697, 183, 146, 5, 70, "ExampleSection",
 CellID->4249506],
Cell[5846, 190, 62, 1, 70, "ExampleText",
 CellID->1013637476],
Cell[CellGroupData[{
Cell[5933, 195, 132, 3, 70, "Input",
 CellID->1843663910],
Cell[6068, 200, 128, 5, 70, "Print",
 CellID->120222178]
}, Open  ]],
Cell[6211, 208, 75, 1, 70, "ExampleText",
 CellID->1228493267],
Cell[CellGroupData[{
Cell[6311, 213, 156, 4, 70, "Input",
 CellID->1719665206],
Cell[6470, 219, 243, 7, 36, "Output",
 CellID->490051]
}, Open  ]],
Cell[6728, 229, 65, 1, 70, "ExampleText",
 CellID->193170794],
Cell[CellGroupData[{
Cell[6818, 234, 131, 4, 70, "Input",
 CellID->1280041117],
Cell[6952, 240, 160, 5, 36, "Output",
 CellID->1143439]
}, Open  ]],
Cell[7127, 248, 189, 7, 70, "ExampleText",
 CellID->1882465175],
Cell[7319, 257, 130, 4, 70, "Input",
 CellID->563688414],
Cell[CellGroupData[{
Cell[7474, 265, 131, 4, 70, "Input",
 CellID->1360807181],
Cell[7608, 271, 160, 5, 36, "Output",
 CellID->5868650]
}, Open  ]],
Cell[7783, 279, 61, 1, 70, "ExampleText",
 CellID->1773744141],
Cell[CellGroupData[{
Cell[7869, 284, 104, 3, 70, "Input",
 CellID->1456159867],
Cell[7976, 289, 185, 5, 36, "Output",
 CellID->379235505]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8222, 301, 311, 9, 70, "SeeAlsoSection",
 CellID->23376],
Cell[8536, 312, 963, 35, 70, "SeeAlso",
 CellID->652]
}, Open  ]],
Cell[CellGroupData[{
Cell[9536, 352, 314, 9, 70, "TutorialsSection",
 CellID->31360],
Cell[9853, 363, 148, 3, 70, "Tutorials",
 CellID->6954]
}, Open  ]],
Cell[CellGroupData[{
Cell[10038, 371, 319, 9, 70, "MoreAboutSection",
 CellID->438911079],
Cell[10360, 382, 141, 3, 70, "MoreAbout",
 CellID->153939640],
Cell[10504, 387, 122, 3, 70, "MoreAbout",
 CellID->133008314],
Cell[10629, 392, 159, 3, 70, "MoreAbout",
 CellID->489360863],
Cell[10791, 397, 145, 3, 70, "MoreAbout",
 CellID->283387063]
}, Open  ]],
Cell[10951, 403, 27, 0, 70, "History"],
Cell[10981, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

