(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25647,        982]
NotebookOptionsPosition[     19673,        771]
NotebookOutlinePosition[     21115,        811]
CellTagsIndexPosition[     21030,        806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pure Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PureFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Pure Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Slot" :> Documentation`HelpLookup["paclet:ref/Slot"], 
          "Function" :> Documentation`HelpLookup["paclet:ref/Function"], 
          "Sequence" :> Documentation`HelpLookup["paclet:ref/Sequence"], 
          "BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Slot\"\>", 2->"\<\"Function\"\>", 
       3->"\<\"Sequence\"\>", 
       4->"\<\"BlankNullSequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functional Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SlotSequence ",
 StyleBox["(##)", "OperatorCharacter"]
}], "ObjectName",
 CellID->16710],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["##"], "InlineFormula"],
     "\[LineSeparator]represents the sequence of arguments supplied to a pure \
function. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"##", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]represents the sequence of arguments supplied to a pure \
function, starting with the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox[
        RowBox[{
         StyleBox["n", "TI"], "\[Null]"}]], "th"]], "InlineFormula"],
     " argument. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " is used to represent sequences of arguments in pure functions of the form \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["body", "TI"], "&"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   StyleBox["body", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15397],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"], "[", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"], "[", "1", "]"}]], 
  "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1180723242,
  ButtonNote->"1180723242"]
}], "Notes",
 CellID->14098],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"##", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 ". ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must be a positive integer. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1646539995,
  ButtonNote->"1646539995"]
}], "Notes",
 CellID->12078],

Cell[TextData[{
 "A sequence of arguments supplied to a pure function is \
\[OpenCurlyDoubleQuote]spliced\[CloseCurlyDoubleQuote] into the body of the \
function wherever ",
 Cell[BoxData["##"], "InlineFormula"],
 " and so on appear. "
}], "Notes",
 CellID->5858]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277407463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->21541664],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " represents the complete sequence of arguments supplied to the pure \
function:"
}], "ExampleText",
 CellID->10944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "##", ",", "y", ",", "##"}], "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1662],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "x", ",", "a", ",", "b", ",", "c", ",", "d", ",", "y", ",", "a", ",", "b", 
   ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15863],

Cell["Start with the second argument:", "ExampleText",
 CellID->25826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##2", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27890],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25852]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2340],

Cell["## is short for ##1, all arguments of the function:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1180723242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", "##", "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119020550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1764292919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", "##1", "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1147215190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->781902817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1141880792],

Cell["##2 stands for all arguments starting with the second:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1646539995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", "##2", "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->954706597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57816407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16874],

Cell[TextData[{
 "Programmatically insert a list of iterators into a ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", "##"}], "]"}], "&"}], "@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241666631],

Cell["Numerically integrate over a 1000 variables:", "ExampleText",
 CellID->91280247],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"1", "/", 
    RowBox[{"\[Xi]", ".", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", "1000"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lims", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "0", ",", "1"}], "}"}], "&"}], ",", "\[Xi]"}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1137508336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"f", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6937492],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"0.9362106500704634`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.401530166101117`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.9803536502146104`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"\[LeftSkeleton]", "994", "\[RightSkeleton]"}], "+", 
     RowBox[{"0.2854878189156136`", " ", 
      RowBox[{"x", "[", "998", "]"}]}], "+", 
     RowBox[{"0.9132291144736968`", " ", 
      RowBox[{"x", "[", "999", "]"}]}], "+", 
     RowBox[{"0.5920394770463517`", " ", 
      RowBox[{"x", "[", "1000", "]"}]}]}], ")"}]}],
  Short[#, 5]& ]], "Output",
 ImageSize->{429, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->565652224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{"f", ",", "##"}], "]"}], "&"}], "@@", "lims"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->800901481],

Cell[BoxData["0.004049560348996328`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->72833280]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->957],

Cell[TextData[{
 "The raw object corresponding to ",
 Cell[BoxData["##"], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"##", "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25207],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700837434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1996735],

Cell["#n stands for a single argument:", "ExampleText",
 CellID->511306747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#1", ",", "#2", ",", "#3"}], "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1265331868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572325351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", "##", "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1283000320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16740038]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10918],

Cell["If too few arguments are provided, a message is generated:", \
"ExampleText",
 CellID->17638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##5", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31656],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slots\"\>"}], ":", 
  " ", "\<\"SlotSequence[\\!\\(5\\)] in \\!\\(\\(\\(f[##5]\\)\\) &\\) cannot \
be filled from \\!\\(\\(\\((\\(\\(\\(f[##5]\\)\\) &\\))\\)\\)[\\(\\(a, b, \
c\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slots\\\", ButtonNote -> \
\\\"Function::slots\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->449124078],

Cell[BoxData[
 RowBox[{"f", "[", "##5", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222298755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##5", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20005],

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67182540]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11190],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankNullSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankNullSequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3998],

Cell[TextData[ButtonBox["Pure Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PureFunctions"]], "Tutorials",
 CellID->30219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->741155519],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->195763978]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SlotSequence (##) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 22.6836404}", "context" -> "System`", 
    "keywords" -> {
     "argument sequence", "double hash", "double pound", "rest", 
      "vector arguments"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "## represents the sequence of arguments supplied to a pure function. ## \
n represents the sequence of arguments supplied to a pure function, starting \
with the n\\[Null] th argument. ", "synonyms" -> {"slot sequence", "##"}, 
    "title" -> "SlotSequence", "type" -> "Symbol", "uri" -> 
    "ref/SlotSequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5895, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->277407463]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20887, 799}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2037, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2660, 77, 106, 4, 70, "ObjectName",
 CellID->16710],
Cell[2769, 83, 763, 24, 70, "Usage",
 CellID->19869]
}, Open  ]],
Cell[CellGroupData[{
Cell[3569, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4047, 129, 432, 16, 70, "Notes",
 CellID->15397],
Cell[4482, 147, 551, 21, 70, "Notes",
 CellID->14098],
Cell[5036, 170, 556, 20, 70, "Notes",
 CellID->12078],
Cell[5595, 192, 263, 7, 70, "Notes",
 CellID->5858]
}, Closed]],
Cell[CellGroupData[{
Cell[5895, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277407463],
Cell[CellGroupData[{
Cell[6280, 218, 147, 5, 70, "ExampleSection",
 CellID->21541664],
Cell[6430, 225, 172, 5, 70, "ExampleText",
 CellID->10944],
Cell[CellGroupData[{
Cell[6627, 234, 229, 7, 28, "Input",
 CellID->1662],
Cell[6859, 243, 292, 9, 36, "Output",
 CellID->27045]
}, Open  ]],
Cell[7166, 255, 121, 3, 70, "ExampleDelimiter",
 CellID->15863],
Cell[7290, 260, 70, 1, 70, "ExampleText",
 CellID->25826],
Cell[CellGroupData[{
Cell[7385, 265, 185, 6, 70, "Input",
 CellID->27890],
Cell[7573, 273, 214, 7, 36, "Output",
 CellID->25852]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7836, 286, 215, 7, 70, "ExampleSection",
 CellID->2340],
Cell[8054, 295, 143, 2, 70, "ExampleText",
 CellID->1180723242],
Cell[CellGroupData[{
Cell[8222, 301, 173, 6, 70, "Input",
 CellID->119020550],
Cell[8398, 309, 214, 7, 36, "Output",
 CellID->1764292919]
}, Open  ]],
Cell[CellGroupData[{
Cell[8649, 321, 175, 6, 70, "Input",
 CellID->1147215190],
Cell[8827, 329, 213, 7, 36, "Output",
 CellID->781902817]
}, Open  ]],
Cell[9055, 339, 126, 3, 70, "ExampleDelimiter",
 CellID->1141880792],
Cell[9184, 344, 146, 2, 70, "ExampleText",
 CellID->1646539995],
Cell[CellGroupData[{
Cell[9355, 350, 174, 6, 70, "Input",
 CellID->954706597],
Cell[9532, 358, 202, 7, 36, "Output",
 CellID->57816407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9783, 371, 223, 7, 70, "ExampleSection",
 CellID->16874],
Cell[10009, 380, 224, 8, 70, "ExampleText",
 CellID->17785],
Cell[CellGroupData[{
Cell[10258, 392, 373, 14, 70, "Input",
 CellID->11869],
Cell[10634, 408, 705, 25, 36, "Output",
 CellID->32171]
}, Open  ]],
Cell[11354, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->241666631],
Cell[11482, 441, 86, 1, 70, "ExampleText",
 CellID->91280247],
Cell[11571, 444, 605, 21, 70, "Input",
 CellID->1137508336],
Cell[CellGroupData[{
Cell[12201, 469, 122, 4, 70, "Input",
 CellID->6937492],
Cell[12326, 475, 834, 23, 54, "Output",
 CellID->565652224]
}, Open  ]],
Cell[CellGroupData[{
Cell[13197, 503, 178, 6, 70, "Input",
 CellID->800901481],
Cell[13378, 511, 177, 5, 36, "Output",
 CellID->72833280]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13604, 522, 231, 7, 70, "ExampleSection",
 CellID->957],
Cell[13838, 531, 260, 10, 70, "ExampleText",
 CellID->8130],
Cell[CellGroupData[{
Cell[14123, 545, 155, 5, 70, "Input",
 CellID->25207],
Cell[14281, 552, 236, 7, 36, "Output",
 CellID->700837434]
}, Open  ]],
Cell[14532, 562, 123, 3, 70, "ExampleDelimiter",
 CellID->1996735],
Cell[14658, 567, 75, 1, 70, "ExampleText",
 CellID->511306747],
Cell[CellGroupData[{
Cell[14758, 572, 211, 7, 70, "Input",
 CellID->1265331868],
Cell[14972, 581, 213, 7, 36, "Output",
 CellID->572325351]
}, Open  ]],
Cell[CellGroupData[{
Cell[15222, 593, 174, 6, 70, "Input",
 CellID->1283000320],
Cell[15399, 601, 212, 7, 36, "Output",
 CellID->16740038]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15660, 614, 226, 7, 70, "ExampleSection",
 CellID->10918],
Cell[15889, 623, 99, 2, 70, "ExampleText",
 CellID->17638],
Cell[CellGroupData[{
Cell[16013, 629, 175, 6, 70, "Input",
 CellID->31656],
Cell[16191, 637, 485, 9, 70, "Message",
 CellID->449124078],
Cell[16679, 648, 187, 6, 36, "Output",
 CellID->222298755]
}, Open  ]],
Cell[CellGroupData[{
Cell[16903, 659, 185, 6, 70, "Input",
 CellID->20005],
Cell[17091, 667, 179, 6, 36, "Output",
 CellID->67182540]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17331, 680, 311, 9, 70, "SeeAlsoSection",
 CellID->11190],
Cell[17645, 691, 951, 35, 70, "SeeAlso",
 CellID->30695]
}, Open  ]],
Cell[CellGroupData[{
Cell[18633, 731, 313, 9, 70, "TutorialsSection",
 CellID->3998],
Cell[18949, 742, 138, 3, 70, "Tutorials",
 CellID->30219]
}, Open  ]],
Cell[CellGroupData[{
Cell[19124, 750, 319, 9, 70, "MoreAboutSection",
 CellID->741155519],
Cell[19446, 761, 155, 3, 70, "MoreAbout",
 CellID->195763978]
}, Open  ]],
Cell[19616, 767, 27, 0, 70, "History"],
Cell[19646, 769, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

