(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13625,        453]
NotebookOptionsPosition[     10671,        355]
NotebookOutlinePosition[     11908,        391]
CellTagsIndexPosition[     11823,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Larger" :> Documentation`HelpLookup["paclet:ref/Larger"], 
          "Small" :> Documentation`HelpLookup["paclet:ref/Small"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Larger\"\>", 
       2->"\<\"Small\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Notebook Formatting & Styling\"\>", 3->"\<\"Text Styling\"\>", 
       4->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Smaller", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Smaller",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Smaller"]], "InlineFormula"],
     " \[LineSeparator]is a style or option setting that specifies that \
objects should be smaller."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "Smaller"}], "]"}]], "InlineFormula"],
 " displays with text in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " smaller."
}], "Notes",
 CellID->26269],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Smaller",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Smaller"]], "InlineFormula"],
 " typically represents the same size change as the ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 " keyboard command."
}], "Notes",
 CellID->155784377]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331482736],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->140149340],

Cell["Make a letter incrementally smaller:", "ExampleText",
 CellID->270832958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{"#", ",", "Smaller"}], "]"}], "&"}], ",", "\"\<X\>\"", ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146258601],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVU0EOwiAQpKWN0ZQ23jzWJ/gJPXkwvoA0JPVgNLX/RyC0bqaQIgksM92d
XWB7lWOvnnJ8dLK9DPLdP7pPe34NhuIZY0yZ2RyY2Wuzc1NpbWxhV26xG2wL
uAYsVnC1grnLyoHdmSW3JXpbgxUE07j8p1bMrPflxNKY0vO+FDfwFkI+KTpr
PnPN4DPhUC3kjMiW9MxTrM23Ac0ywsf8KZ9H/ObXXNSKJyxAvYHv//aY7Rbu
T0X5LHhTeJ+YDTHtWFttFXjDfdIbYWYBynVCpmNSJg5KQi97E9XtOCWph3vt
HoxddC/5E2+hqpmKrCz7Ar0aUZQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104862209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25312579],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Smaller",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Smaller"]], "InlineFormula"],
 " to make text smaller relative to the surrounding text style:"
}], "ExampleText",
 CellID->750789520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<aaa\>\"", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<aaa\>\"", ",", "Smaller"}], "]"}], ",", 
         "\"\<aaa\>\""}], "}"}], "]"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "sz"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"sz", ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "17", ",", "24"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486284470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV0tPwzAMTps+YIgLB4TEQzsgLsCdx52d+BHVhLQdEGhsvz84j7XBcdam
TdGQmNR+9RfXjh3HWV+r9eLtvVov59V0tqo+F8v51/TlYwUUTxhjG7juzxg8
C3hS10YIQPvO4Z7DUArIAbMOcgaoXmT6F8KF+ErUq1JiUhTqpwxKMR/IS7up
8TqE7zsfTkZHacccxzKV3SHjsedP18B/lqgsYS1cqTHkwlQ0xjH96ugkWwJZ
IjxC2gctss+O3o8TpI2tY5nqEjErJXQ+Sa8o5ApmJhc2Hv+K97teXmTmqH6c
B/I3keyolaszOUF46+HV3mHuuey7p8I9V/mecxf60TDCVH3K3I6V/jH+0olM
VUVea5ok5PvNWpGdD48I5akwe8VG8rwdNGOfp0OkXbbIPjt6pdvepqyNKYfO
p8nVmLPa9oACIVUdMWUdnc/7tYe/EnSn3dWBt18pNv7ogh1kn51HgXegijNr
4jSDLmP/L2HNWWGju59C2Kcoc+skd7G508tDvVoZa6rCRu5BSj9O5CeRVsD+
Yrbx1MM/C7qWWfINl3QcAQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306190399]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1381],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Larger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Larger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Small",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Small"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->495618049],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->78013683],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->81725478],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->452502144],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->95311216]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Smaller - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 23.4805358}", "context" -> "System`", 
    "keywords" -> {"shrink text", "shrink formulas"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Smaller is a style or option setting that specifies that objects should \
be smaller.", "synonyms" -> {}, "title" -> "Smaller", "type" -> "Symbol", 
    "uri" -> "ref/Smaller"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5588, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331482736]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11680, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1697, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2320, 66, 1572, 37, 70, "ObjectNameGrid"],
Cell[3895, 105, 458, 14, 70, "Usage",
 CellID->7998]
}, Open  ]],
Cell[CellGroupData[{
Cell[4390, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4868, 141, 343, 13, 70, "Notes",
 CellID->26269],
Cell[5214, 156, 337, 11, 70, "Notes",
 CellID->155784377]
}, Closed]],
Cell[CellGroupData[{
Cell[5588, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331482736],
Cell[CellGroupData[{
Cell[5973, 186, 148, 5, 70, "ExampleSection",
 CellID->140149340],
Cell[6124, 193, 79, 1, 70, "ExampleText",
 CellID->270832958],
Cell[CellGroupData[{
Cell[6228, 198, 234, 8, 28, "Input",
 CellID->146258601],
Cell[6465, 208, 545, 13, 36, "Output",
 Evaluatable->False,
 CellID->104862209]
}, Open  ]],
Cell[7025, 224, 124, 3, 70, "ExampleDelimiter",
 CellID->25312579],
Cell[7152, 229, 245, 8, 70, "ExampleText",
 CellID->750789520],
Cell[CellGroupData[{
Cell[7422, 241, 599, 19, 47, "Input",
 CellID->486284470],
Cell[8024, 262, 785, 17, 66, "Output",
 Evaluatable->False,
 CellID->306190399]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8870, 286, 310, 9, 70, "SeeAlsoSection",
 CellID->1381],
Cell[9183, 297, 441, 17, 70, "SeeAlso",
 CellID->16590]
}, Open  ]],
Cell[CellGroupData[{
Cell[9661, 319, 319, 9, 70, "MoreAboutSection",
 CellID->495618049],
Cell[9983, 330, 134, 3, 70, "MoreAbout",
 CellID->78013683],
Cell[10120, 335, 168, 3, 70, "MoreAbout",
 CellID->81725478],
Cell[10291, 340, 135, 3, 70, "MoreAbout",
 CellID->452502144],
Cell[10429, 345, 170, 3, 70, "MoreAbout",
 CellID->95311216]
}, Open  ]],
Cell[10614, 351, 27, 0, 70, "History"],
Cell[10644, 353, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

