(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    216054,       7613]
NotebookOptionsPosition[    185296,       6529]
NotebookOutlinePosition[    186860,       6570]
CellTagsIndexPosition[    186773,       6565]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Simultaneous Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SimultaneousEquations"], 
          "Solving Equations Involving Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"], 
          "Solving Linear Systems" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingLinearSystems"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"], 
          "Generic and Non\[Hyphen]Generic Solutions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GenericAndNonGenericSolutions"], 
          "Eliminating Variables" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EliminatingVariables"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Solving Equations\"\>", 3->"\<\"Simultaneous Equations\"\>", 
       4->"\<\"Solving Equations Involving Power Series\"\>", 
       5->"\<\"Solving Linear Systems\"\>", 
       6->"\<\"Solving Logical Combinations of Equations\"\>", 
       7->"\<\"Generic and Non\[Hyphen]Generic Solutions\"\>", 
       8->"\<\"Eliminating Variables\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root" :> Documentation`HelpLookup["paclet:ref/Root"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "NSolve" :> 
          Documentation`HelpLookup["paclet:ref/NSolve"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"], "SolveAlways" :> 
          Documentation`HelpLookup["paclet:ref/SolveAlways"], "LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], "ToRadicals" :> 
          Documentation`HelpLookup["paclet:ref/ToRadicals"], "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], "DSolve" :> 
          Documentation`HelpLookup["paclet:ref/DSolve"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Root\"\>", 2->"\<\"Reduce\"\>", 
       3->"\<\"FindInstance\"\>", 4->"\<\"NSolve\"\>", 5->"\<\"FindRoot\"\>", 
       6->"\<\"Eliminate\"\>", 7->"\<\"SolveAlways\"\>", 
       8->"\<\"LinearSolve\"\>", 9->"\<\"RowReduce\"\>", 
       10->"\<\"ToRadicals\"\>", 11->"\<\"GroebnerBasis\"\>", 
       12->"\<\"DSolve\"\>", 13->"\<\"RSolve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"]}, #, 2]
        & , Evaluator -> Automatic], {1->"\<\"Equation Solving\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 3->"\<\"Polynomial Equations\"\>", 
       4->"\<\"Polynomial Systems\"\>", 
       5->"\<\"Precollege Education\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Solve", "ObjectName",
 CellID->13408],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Solve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Solve"], "[", 
       RowBox[{
        StyleBox["eqns", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to solve an equation or set of equations for \
the variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Solve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Solve"], "[", 
       RowBox[{
        StyleBox["eqns", "TI"], ",", 
        StyleBox["vars", "TI"], ",", 
        StyleBox["elims", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to solve the equations for ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ", eliminating the variables ",
     Cell[BoxData[
      StyleBox["elims", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Equations are given in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9751],

Cell[TextData[{
 "Simultaneous equations can be combined either in a list or with ",
 Cell[BoxData["&&"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29897],

Cell["A single variable or a list of variables can be specified. ", "Notes",
 CellID->29246],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"], "[", 
   StyleBox["eqns", "TI"], "]"}]], "InlineFormula"],
 " tries to solve for all variables in ",
 Cell[BoxData[
  StyleBox["eqns", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3186],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives solutions in terms of rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "->", 
   StyleBox["sol", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22671],

Cell[TextData[{
 "When there are several variables, the solution is given in terms of lists \
of rules: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["x", "TI"]]}], ",", 
    RowBox[{
     StyleBox["y", "TI"], "->", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["y", "TI"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27834],

Cell[TextData[{
 "When there are several solutions, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives a list of them. "
}], "Notes",
 CellID->11429],

Cell[TextData[{
 "When a particular root has multiplicity greater than one, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives several copies of the corresponding solution. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1484],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " deals primarily with linear and polynomial equations. "
}], "Notes",
 CellID->17682],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["InverseFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunctions"]], "InlineFormula"],
 " specifies whether ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " should use inverse functions to try and find solutions to more general \
equations. The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". In this case, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " can use inverse functions, but prints a warning message. See notes on ",
 Cell[BoxData[
  ButtonBox["InverseFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunctions"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->9915],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives generic solutions only. It discards solutions that are valid only \
when the parameters satisfy special conditions. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the complete set of solutions. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25663],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will not always be able to get explicit solutions to equations. It will \
give the explicit solutions it can, then give a symbolic representation of \
the remaining solutions in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. If there are sufficiently few symbolic parameters, you can then \
use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to get numerical approximations to the solutions. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->363],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " if there are no possible solutions to the equations. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", "}"}], "}"}]], "InlineFormula"],
 " if all variables can have all possible values. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->12974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"Mode", "->", "Modular"}]}], "]"}]], "InlineFormula"],
 " solves equations with equality required only modulo an integer. You can \
specify a particular modulus to use by including the equation ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"], "==", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 ". If you do not include such an equation, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will attempt to solve for the possible moduli. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18354],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " uses special efficient techniques for handling sparse systems of linear \
equations with approximate numerical coefficients. "
}], "Notes",
 CellID->6251]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66521438],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->646022131],

Cell["Solve a quadratic equation:", "ExampleText",
 CellID->27628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"a", " ", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8743],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["a", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["a", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{332, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394059293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29661],

Cell[TextData[{
 "Solve simultaneous equations in ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", "y"}], "==", "7"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "x"}], "-", "y"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["8", 
      RowBox[{"a", "+", "b"}]]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", 
        RowBox[{"7", " ", "b"}]}], 
       RowBox[{"a", "+", "b"}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{169, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5101649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9614],

Cell["Solutions are given as lists of replacements:", "ExampleText",
 CellID->9322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "==", "a"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        SqrtBox[
         RowBox[{"2", "-", 
          SuperscriptBox["a", "2"]}]], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6036545]
}, Open  ]],

Cell[TextData[{
 "Replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " by solutions:"
}], "ExampleText",
 CellID->20281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", "sol"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["a", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["a", "2"], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["a", "2"]}]], "2"]}]}], "}"}]], "Output",
 ImageSize->{207, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303473510]
}, Open  ]],

Cell[TextData[{
 "Replace combinations of ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " by solutions, and simplify the results:"
}], "ExampleText",
 CellID->14417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}]}], "}"}], "/.", "sol"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["a", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["a", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["a", "2"]}]], ",", 
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["a", "2"]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->547796209]
}, Open  ]],

Cell[TextData[{
 "Plot the real parts of the solutions for ",
 Cell[BoxData["y"], "InlineFormula"],
 " as a function of the parameter ",
 Cell[BoxData["a"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Re", "[", 
     RowBox[{"y", "/.", "sol"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16743],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->270780658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9],

Cell["Pick out the 3rd solution:", "ExampleText",
 CellID->26222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"2", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}], "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    FractionBox["1", "3"], "+", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "17"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["33"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "17"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["33"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}], "}"}]], "Output",
 ImageSize->{387, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380254478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"2", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}], "[", 
   RowBox[{"[", "3", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1501],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], "+", 
  FractionBox[
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "17"}], "+", 
       RowBox[{"3", " ", 
        SqrtBox["33"]}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "17"}], "+", 
      RowBox[{"3", " ", 
       SqrtBox["33"]}]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]}]], "Output",
 ImageSize->{350, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83061300]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[3]:=",
 CellID->29712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(16)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->111456608],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Complex Equations in One Variable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5642],

Cell["Polynomial equations solvable in radicals:", "ExampleText",
 CellID->639965264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"x", "^", "2"}], "-", "5"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109018309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], "+", 
        FractionBox[
         SqrtBox["21"], "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox[
        SqrtBox["21"], "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["21"]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["21"]}], ")"}]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{346, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46290648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"5", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175945626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"11", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["2", 
            RowBox[{
             RowBox[{"-", "263"}], "+", 
             RowBox[{"3", " ", 
              SqrtBox["8277"]}]}]], ")"}], 
          RowBox[{"1", "/", "3"}]]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "263"}], "+", 
             RowBox[{"3", " ", 
              SqrtBox["8277"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["2", "3"], "-", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "263"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["8277"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "+", 
      FractionBox[
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "263"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox["8277"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["2", "3"], "-", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "263"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["8277"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "+", 
      FractionBox[
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "263"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox["8277"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{497, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->667417195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220762094],

Cell["General polynomial equations:", "ExampleText",
 CellID->542378015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "17"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721327065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"17", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"17", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"17", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"17", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"17", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{411, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269949305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63270980],

Cell["Polynomial equations with multiple roots:", "ExampleText",
 CellID->304777361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313812518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "\[ImaginaryI]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70302458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->922791320],

Cell["Polynomial equations with symbolic coefficients:", "ExampleText",
 CellID->55057830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25160730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589038447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "5"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->495029460],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1y0zAQVmI7PyRtaEtpWg4EeAYGngBOXIAXyGSYaQ8MTOm0z8KBvg8n
4AAzPI2xbClVVitrJf/kB3UmdiRLq91v1yvt17yZX51/+Di/uljMZ68v55/P
LxZfZq8+XWZdUYexzjfG2Mspy76n2bf8w/9usw9jo+zazbpeiPu1uMfifgSe
34DniXJn7B6/RnKFNJ+ltq9BOwbtiWX+jWU+bHe3WKsFaN+3SI1Ae+go/6Ax
K3h82KRHYhxV3qG/tvGyV8jqGtbmMngTIhuJ+I9E3Ms2tIc3+4jMJGv2VjUR
qyTIjJ7oj40zxkL/QtF8ABoNmC023AaliI0MVldBbFAZsaQWxAaKvtXfi66m
yxiTk6hIM4E0tTcy90JNtFE9BEN9FNexh/gO8wB99kjDRu4qML66BF/weTD3
6ejvgRE4dm2hXw0/LMfUgf7AKMf9fYAekZ7icTeUb5n2rjphD/EriRuZU3Gc
dV2gvKTi/JEyb3nNY7JHsAbGrsSyL7DE815TWPZrwhKPWl8s4fkAam3L6p1c
Dszi8pSCeSBuGGe4L/rijZ0vYtJMuGPtoxrY8gE8TUtM95H+pjGFWakuTBNv
TI8sGtd1+oA7K2658/5nw5507pAnTG1/dvaBjy+hRybaDNcIb+3s54w+hlk9
6Ptmc4gMr3ornsKN1cuhEUm1XpE1A1avxDJviTUYW8Z0qZXSKvvIPaGrWv0z
agw2bLm6BtXySSXLUySy/TLiKYoAZCngWsegza3AztRTQz98S099vFrZiodE
K048rKjPQxxDbtoZ6H+QKjWelpf5k0fGJ+rKTIyE/RTcTbodW3U7I+vGR8YE
3fx4ufeg/dgRAZu8WSNavxVYPa2orZTzzEtLyJm/Q2wv49Dh+Cdg/Cqn/jUt
MuZ3cX+e9/KJt+BbVS5/TPJB02z5cIu02DSOXuNdyVasg6OX8uI7Lf9Lbn5F
ikM2Ctx84ObvRrXNzfeNcmweCQz9+hn67vIFC8y8hrXGJkNuEltVbQeG3o6p
K0Ofx3pg5FdGYmyZy34YuPgyNF25eLxmCNy7XM/dA7Aisf16JTDv9THvB6nC
QtCifieYdtu+tLtMez35bjOY9RNUi+3k16detuDeaYNV56hFhMyxLladohuN
/1s3i07Tsm3WvNCqaZa8YKvp7Dhk100s+d98tO2k4cpH/9kgqVVZ65/eq7qw
zL/MqwSWuAQ/2P5B8lbgQH34N4w7s7X5vOINov6aOTBxy6u2R0HMoJTfKSX6
A4vksh/47UKBB5HrrdUjO1GjNxOhm1G5wl9T1WNbW3Wf3K/qP7W61lp+q1Br
pUK6qaaw1TpFjSFrFz6k+M806/wDSCx3Kg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{413, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106432932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13866999],

Cell["Algebraic equations:", "ExampleText",
 CellID->78207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "x", "]"}], "+", 
     RowBox[{"3", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}]}], "\[Equal]", "5"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52466515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"957", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["2", 
         RowBox[{"1217", "+", 
          RowBox[{"5125", " ", 
           SqrtBox["5"]}]}]], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1217", "+", 
           RowBox[{"5125", " ", 
            SqrtBox["5"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{412, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4626713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->897558702],

Cell["Transcendental equations:", "ExampleText",
 CellID->288893094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "3"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256538498],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->48228413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"ArcSin", "[", 
     FractionBox["1", "3"], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38980955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"2", "a"}], ")"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"x", "^", "a"}]}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490585453],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->35749816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     FractionBox["1", "a"]]}], "}"}], "}"}]], "Output",
 ImageSize->{93, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51397960]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "5"}], "-", "1"}], ")"}], "^", "x"}], "\[Equal]", 
    "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->206328419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"3", "/", "5"}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{255, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->404028426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"5", "\[Equal]", 
    RowBox[{"x", "*", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"x", "^", "2"}], ")"}]}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->266904943],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->148518655],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->65450368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    SqrtBox[
     FractionBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"50", " ", 
        RowBox[{"Log", "[", "2", "]"}]}], "]"}], 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "2", "]"}]}]]]}], "}"}], "}"}]], "Output",
 ImageSize->{222, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->121726737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "2"}]}], "]"}]}]}], "]"}], "\[Equal]", "a"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->276451892],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "a"}], "]"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "a"}], "]"}]}]}], ")"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "a"}], "]"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "a"}], "]"}]}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{247, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->6598531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496261871],

Cell["Symbolic functions:", "ExampleText",
 CellID->111386027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], "^", "3"}], "+", 
     RowBox[{"2", 
      RowBox[{"f", "[", "x", "]"}]}], "-", "3"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65207232],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->343497777],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->324598384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      TagBox[
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]],
       {InverseFunction, 1, 1},
       Editable->False], "[", "1", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      TagBox[
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]],
       {InverseFunction, 1, 1},
       Editable->False], "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["11"]}]}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      TagBox[
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]],
       {InverseFunction, 1, 1},
       Editable->False], "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["11"]}]}], ")"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{478, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576951033]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Systems of Complex Equations in Several Variables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20620],

Cell["Systems of linear equations:", "ExampleText",
 CellID->17776778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       RowBox[{"4", "y"}], "+", 
       RowBox[{"5", "z"}]}], "==", "6"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"7", "x"}], "+", 
       RowBox[{"7", "y"}], "+", 
       RowBox[{"8", "z"}]}], "\[Equal]", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248564057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"z", "\[Rule]", "2"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607223075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503057964],

Cell["Linear equations with symbolic coefficients:", "ExampleText",
 CellID->463598910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", 
      RowBox[{"b", " ", "y"}], "+", 
      RowBox[{"c", " ", "z"}]}], "\[Equal]", "d"}], " ", "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"5", "z"}]}], "==", "6"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "x"}], "+", 
      RowBox[{"7", "y"}], "+", 
      RowBox[{"8", "z"}]}], "\[Equal]", "9"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54580525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "b"}], "+", 
          RowBox[{"2", " ", "c"}], "-", "d"}], ")"}]}], 
       RowBox[{
        RowBox[{"3", " ", "a"}], "-", 
        RowBox[{"11", " ", "b"}], "+", 
        RowBox[{"7", " ", "c"}]}]]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"3", " ", "a"}], "-", 
        RowBox[{"15", " ", "c"}], "+", 
        RowBox[{"11", " ", "d"}]}], 
       RowBox[{
        RowBox[{"3", " ", "a"}], "-", 
        RowBox[{"11", " ", "b"}], "+", 
        RowBox[{"7", " ", "c"}]}]]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", "a"}], "+", 
        RowBox[{"15", " ", "b"}], "-", 
        RowBox[{"7", " ", "d"}]}], 
       RowBox[{
        RowBox[{"3", " ", "a"}], "-", 
        RowBox[{"11", " ", "b"}], "+", 
        RowBox[{"7", " ", "c"}]}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{428, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252707845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426826805],

Cell["Underdetermined systems of linear equations:", "ExampleText",
 CellID->276914946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       RowBox[{"4", "y"}], "+", 
       RowBox[{"5", "z"}]}], "==", "6"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"6", "x"}], "+", 
       RowBox[{"7", "y"}], "+", 
       RowBox[{"8", "z"}]}], "\[Equal]", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123282614],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->18901328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "z"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"3", "-", 
      RowBox[{"2", " ", "z"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57230477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8592199],

Cell["Linear equations with no solutions:", "ExampleText",
 CellID->697543653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "+", 
       RowBox[{"4", "y"}], "+", 
       RowBox[{"5", "z"}]}], "==", "6"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"6", "x"}], "+", 
       RowBox[{"7", "y"}], "+", 
       RowBox[{"8", "z"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105343871],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192836578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->613122198],

Cell["Systems of polynomial equations:", "ExampleText",
 CellID->200377638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261886345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["3", "5"], "-", 
       FractionBox[
        RowBox[{"4", " ", "\[ImaginaryI]"}], "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["6", "5"], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["3", "5"], "+", 
       FractionBox[
        RowBox[{"4", " ", "\[ImaginaryI]"}], "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["6", "5"], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{356, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22010849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169601750],

Cell["Polynomial equations with symbolic coefficients:", "ExampleText",
 CellID->92261027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "c"}], ",", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88463089],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtrFEEQ7t2Z2YfRuCqY+EATg5BLjB5E8BlfUVEhB39AQhAMIj6R3Ba9
BATBoGG9BX+A7jHgJXrKRclBJMecPeWY49jPTG9NzU7t7K7JxlnY6anq6q+r
aqp7uqbuTrx4cP/RxIupyYm+G88mnjyYmnzeN/r4GWc5GcYy3xhjN3sZv/f5
nfyL33f+V7fw7iK/OlzM463H25zgOmacz1zNHwVyXoTcHFHujpz9Euh1xMXb
oKUMY3kg5aFSoyQsaB+ONddCrNuyPcevOU65qEyNt0K9V+qOdeuOnW1irNK8
i1+znDoR6QOX/Iyu1MWg+XO2BRgXtE2e1TK2A4wdFhc3oKP8hNkuULOAf5mI
h9mA4b1rMd4FQLuAzqJeOmnRZjZBliztmPxdj5DcHZL8QJYcaYnOB0D/KOjv
Bf1zMf2XE2l1Sj+XXt3e0m2Pbj8C+mqiWf4AuuCrlVNNjCZ06QL8L3S0IIL9
IC5FC+cyUQDj9C2gi4CGOJ9IukEUp1ZXfrMTwwmtvvOItsa6LIISp11G4hYA
16xp4aMiC2svbAre74uLi2r5sH5xcQYHB9fX181smFxZyhUKhZWVFdG1y8Jn
eucpIuPey3EjIyMR1giaH1ykVRnU7662bBfgQw+cBfTH0POCMUrzNIyebCxu
XmsM47SCxkey6Ky/cvaDMb98tXIUmPl9ps9kcQ+gVoj2TSK8g1q3e5K/sLCg
I/EroF8mQn8q6bGxsWq1GqAGdDLU075aJfaq8vTOLVoZAXwG5pTLZT1mp7az
oGUc3cI4LvjhE7SDyLnWXII9rNu85pfaoAM86UAd0B0x1ptnMCn0jBzm4tGo
9BwfH+ctt57twfQizgBtRt8LCbFwKZw71IDsni1qP+10jnPhLpssthxA59C5
DgIp6QNveXlZ7Rp8U1paWtpY9dCqRjxir7D6+SHUJzpvg9LDCfTJoRabXhgT
7bc45zdiMTwr4LFiMlsYI1Da5JaHED7zNnZX/p6amZlh3X6QibpN7gQ1GHXW
YDNxYOYobZo12Fk23hrz9Gpz+GsYVuzOdxhIqV2iUqlMT0/LV6ikg/doV7SG
KBfLtrEIp2TzzX2DwFfqkG99PQn1dnecN6hfPHBv9PhYJGFfRgV5BMN01tbW
NK3mnJ+fX11djfaWyW1tu5n87bXwbcm8fmbhbyKmZwhoZk51pX+sYXekhrin
8fPfAMpV73uuOA/PaN13gxn2AY0HQD/MJY+2ZJZjoF/OKr/imP1LdB737bM0
X3JaussPvoGZHC+rUU22KfqPEsf16/a41OKVHMV3/JrsK6DLlhQ/CdRkUwGt
pF5LLs+xyvLHHoqLo4JLdN2J6ZfxKZ0UXbeof5dWNTCptKoRaG6+Kpk3w3as
bsgdJJTxwNPt/17lKJK8tLWqHMl0bneVg6ZVs1UO2izUKgfEccjolKqHo+Xc
aNSGqx8/MX9YdLLvyXCVQKmk1Y8fljWUaofxmHoOpvH9cIbQqRWPPMnf1KrH
79BziatySITYCKdXOVbQ5x4XhXVWcYurGrT9gl7VoOElrWrQ0ButatBQO6Gq
Ad/y7dCp0SoHzbtplYMytpEqB5xnq/qjlVWPZLGWVj1o+myvqoeKFZjpptUO
LKPfPOuaq36oHD+tegTorap6YKeAzvJOWgVJqyC2VFoF2W5VEJb5C6gEVww=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614380733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396734724],

Cell["Algebraic equations:", "ExampleText",
 CellID->222879371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "\[Equal]", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], "-", 
       RowBox[{"y", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "1"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184286723],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->140917979],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{371, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10144364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->507297643],

Cell["Transcendental equations:", "ExampleText",
 CellID->190619530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506185029],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->338098336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"5", " ", "\[Pi]"}], "12"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["\[Pi]", "12"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406466148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", "^", 
      RowBox[{"x", "^", "2"}]}], "\[Equal]", "7"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95252965],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->372178319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         FractionBox[
          RowBox[{"Log", "[", "7", "]"}], 
          RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox[
         RowBox[{"Log", "[", "7", "]"}], 
         RowBox[{"Log", "[", "3", "]"}]]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         FractionBox[
          RowBox[{"Log", "[", "7", "]"}], 
          RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox[
        RowBox[{"Log", "[", "7", "]"}], 
        RowBox[{"Log", "[", "3", "]"}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          FractionBox[
           RowBox[{"Log", "[", "7", "]"}], 
           RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox[
         RowBox[{"Log", "[", "7", "]"}], 
         RowBox[{"Log", "[", "3", "]"}]]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          FractionBox[
           RowBox[{"Log", "[", "7", "]"}], 
           RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox[
        RowBox[{"Log", "[", "7", "]"}], 
        RowBox[{"Log", "[", "3", "]"}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          FractionBox[
           RowBox[{"Log", "[", "7", "]"}], 
           RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox[
         RowBox[{"Log", "[", "7", "]"}], 
         RowBox[{"Log", "[", "3", "]"}]]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          FractionBox[
           RowBox[{"Log", "[", "7", "]"}], 
           RowBox[{"Log", "[", "3", "]"}]]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox[
        RowBox[{"Log", "[", "7", "]"}], 
        RowBox[{"Log", "[", "3", "]"}]]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{518, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53698727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "a"}], "+", 
      RowBox[{"y", "^", "b"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", " ", "y"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"a", " ", "b"}], ")"}]}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->478593427],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->557393569],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->93023770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    FractionBox[
     SuperscriptBox["2", 
      FractionBox["1", 
       RowBox[{"a", " ", "b"}]]], "x"]}], "}"}], "}"}]], "Output",
 ImageSize->{82, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->248878097]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modular Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->184776408],

Cell["A linear system:", "ExampleText",
 CellID->75271447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}], "&&", 
    RowBox[{"Modulus", "\[Equal]", "12"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154699585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Modulus", "\[Rule]", "12"}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", "z"}]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"9", "+", "z"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5354664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->856881048],

Cell["Univariate polynomial equation:", "ExampleText",
 CellID->60093961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"Modulus", "==", "5"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55991068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "5"}], ",", 
     RowBox[{"x", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "5"}], ",", 
     RowBox[{"x", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "5"}], ",", 
     RowBox[{"x", "\[Rule]", "2"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{422, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136359215]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25623072],

Cell["A system of polynomial equations and inequations:", "ExampleText",
 CellID->276046792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{"Modulus", "\[Equal]", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221242426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "7"}], ",", 
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Modulus", "\[Rule]", "7"}], ",", 
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "5"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406601982]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15946],

Cell["All variables are solved for:", "ExampleText",
 CellID->24954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}], "+", "1"}], "==", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{262, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537558362]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "==", "2"}], ",", 
    RowBox[{
     RowBox[{"y", "-", "x"}], "==", "1"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["3", "2"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{112, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175443958]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22083604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[TextData[{
    "InverseFunctions",
    "\[NonBreakingSpace]\[NonBreakingSpace]",
    Cell["(3)", "ExampleCount"]
   }], "ExampleSubsection"],
   $Line = 0; Null], Cell[TextData[ButtonBox[" \[RightGuillemet]",
   BaseStyle->"ExampleLink",
   ButtonData->9915]], "Input"]}]], "ExampleSubsection",
 CellID->333281304],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " uses inverse functions but prints warning messages:"
}], "ExampleText",
 CellID->498336114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615068353],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->669920795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     TagBox[
      SuperscriptBox["f", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]],
      {InverseFunction, 1, 1},
      Editable->False], "[", "0", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453548768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474401374],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->309378541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->747506071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101098913],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not print inverse function warning messages:"
}], "ExampleText",
 CellID->41155148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150621549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     TagBox[
      SuperscriptBox["f", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]],
      {InverseFunction, 1, 1},
      Editable->False], "[", "0", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99808831]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->386395636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322138009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135518962],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not use inverse functions:"
}], "ExampleText",
 CellID->208160627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143230375],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78678095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202852608],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17212343]
}, Open  ]],

Cell["\<\
Solving algebraic equations does not require using inverse functions:\
\>", "ExampleText",
 CellID->203165551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413086211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "\[ImaginaryI]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81281597]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[TextData[{
    "Mode",
    "\[NonBreakingSpace]\[NonBreakingSpace]",
    Cell["(1)", "ExampleCount"]
   }], "ExampleSubsection"],
   $Line = 0; Null], Cell[TextData[ButtonBox[" \[RightGuillemet]",
   BaseStyle->"ExampleLink",
   ButtonData->18354]], "Input"]}]], "ExampleSubsection",
 CellID->415375537],

Cell["\<\
Find a modulus for which a system of equations has a solution:\
\>", "ExampleText",
 CellID->640369772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197039454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Modulus", "\[Rule]", "191721"}], ",", 
    RowBox[{"y", "\[Rule]", "96231"}], ",", 
    RowBox[{"x", "\[Rule]", "47377"}]}], "}"}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259280301]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sort",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3236023],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " heuristically selects a variable order which makes the problem easier:"
}], "ExampleText",
 CellID->428032455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "50"}], "+", 
         RowBox[{"22", "x"}], "+", "17"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "-", 
         RowBox[{"x", "^", "51"}], "-", "12"}], "\[Equal]", "0"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "LeafCount"}], "//", 
  "Timing", " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47284086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3299999999999991`", ",", "2751"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383981843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153198263],

Cell[TextData[{
 "This forces ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find solutions for ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " first, and solve for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in terms of these solutions:"
}], "ExampleText",
 CellID->410440875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "50"}], "+", 
         RowBox[{"22", "x"}], "+", "17"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "-", 
         RowBox[{"x", "^", "51"}], "-", "12"}], "\[Equal]", "0"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"Sort", "\[Rule]", "False"}]}], "]"}], "//", "LeafCount"}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203495263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.301`", ",", "765251"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1020129846]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VerifySolutions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->178896398],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " verifies solutions obtained using non-equivalent transformations:"
}], "ExampleText",
 CellID->55614444],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "+", 
       RowBox[{"Sqrt", "[", "x", "]"}]}], "]"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "^", "9"}], "-", "y", "-", 
      RowBox[{"2", " ", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "7"}], ")"}]}]}]}], "\[Equal]", "3"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{"eqns", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ")"}], ";"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->45476055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"31.154`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286294189]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"VerifySolutions", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not verify the solutions:"
}], "ExampleText",
 CellID->64639296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol2", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{"eqns", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"VerifySolutions", "\[Rule]", "False"}]}], "]"}]}], ")"}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->315728882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.577999999999999`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->810340903]
}, Open  ]],

Cell[TextData[{
 "Some of the solutions returned with ",
 Cell[BoxData[
  RowBox[{"VerifySolutions", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " are not correct:"
}], "ExampleText",
 CellID->524121027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{"sol1", ",", " ", "sol2"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210204361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "126"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14876729]
}, Open  ]],

Cell["\<\
This uses a fast numeric test in an attempt to select correct solutions:\
\>", "ExampleText",
 CellID->153674693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol3", "=", 
     RowBox[{"Select", "[", 
      RowBox[{"sol2", ",", 
       RowBox[{
        RowBox[{"TrueQ", "[", 
         RowBox[{"eqns", "/.", 
          RowBox[{"N", "[", 
           RowBox[{"#", ",", "20"}], "]"}]}], "]"}], "&"}]}], "]"}]}], ")"}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->204740677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.863999999999999`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->696785202]
}, Open  ]],

Cell["\<\
In this case numeric verification gives the correct solution set:\
\>", "ExampleText",
 CellID->933296892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "===", "sol1"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->343616274],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->79554254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->742185169],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not verify solutions of equations with inexact coefficients:"
}], "ExampleText",
 CellID->213263060],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "r"}], "-", 
      RowBox[{"5.9", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "3"}]}], " ", "s"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "q"}], "-", 
      RowBox[{"6.15", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "8"}]}], " ", "r"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "p"}], "-", 
      RowBox[{"4.8", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "13"}]}], " ", "q"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", 
      RowBox[{"10", "^", 
       RowBox[{"-", "14"}]}]}], ",", 
     RowBox[{"x", "+", ".162", "-", 
      RowBox[{"(", 
       RowBox[{"y", "+", "r", "+", 
        RowBox[{"2", " ", "q"}], "+", 
        RowBox[{"3", " ", "p"}]}], ")"}]}], ",", 
     RowBox[{"p", "+", "q", "+", "r", "+", "s", "-", ".081"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"polys", "\[Equal]", "0"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->353989898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "0.07810707764845815`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.007550181433829781`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "0.00540035589019256`"}], ",", 
     RowBox[{"q", "\[Rule]", 
      RowBox[{"-", "0.009934190797491253`"}]}], ",", 
     RowBox[{"r", "\[Rule]", "0.15911055613831532`"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.002896300904032571`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "5.536717521949702`*^-19"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.10183327360795578`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "0.10183330687335972`"}], ",", 
     RowBox[{"q", "\[Rule]", 
      RowBox[{"-", "0.02083334013886187`"}]}], ",", 
     RowBox[{"r", "\[Rule]", "3.3265502147856955`*^-8"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9.819973026202257`*^-14"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "8.247882104242984`*^-12"}], ",", 
     RowBox[{"y", "\[Rule]", "0.000051878787011514505`"}], ",", 
     RowBox[{"p", "\[Rule]", "0.00020057659244070118`"}], ",", 
     RowBox[{"q", "\[Rule]", "0.08054696822911195`"}], ",", 
     RowBox[{"r", "\[Rule]", "0.0002524551701994528`"}], ",", 
     RowBox[{"x", "\[Rule]", "1.9275701256816285`*^-10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "8.322008872899453`*^-12"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.00005193850887579079`"}]}], ",", 
     RowBox[{"p", "\[Rule]", 
      RowBox[{"-", "0.00020307897872419144`"}]}], ",", 
     RowBox[{"q", "\[Rule]", "0.08145809628211081`"}], ",", 
     RowBox[{"r", "\[Rule]", 
      RowBox[{"-", "0.00025501731170862946`"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.9253536954466017`*^-10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "0.08400366090383396`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "850.4524367065865`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "1249.7719615319231`"}], ",", 
     RowBox[{"q", "\[Rule]", 
      RowBox[{"-", "1017.2611376631043`"}]}], ",", 
     RowBox[{"r", "\[Rule]", "0.014537840191450612`"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.16500369909609083`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->847416807]
}, Open  ]],

Cell[TextData[{
 "At some of the solutions returned, ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " are quite far from zero:"
}], "ExampleText",
 CellID->102148018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"polys", "/.", "sol1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->492705422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.894586247125311`*^-10"}], ",", 
     "0.000028762620488403456`", ",", 
     RowBox[{"-", "0.00001564105564209392`"}], ",", 
     "0.000021867597302411127`", ",", "0.0112106383158867`", ",", 
     RowBox[{"-", "0.004530356417441525`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.949661018762886`*^-35", ",", "3.944304526105059`*^-31", ",", 
     "3.1554436208840472`*^-30", ",", "0.`", ",", "5.551115123125783`*^-17", 
     ",", 
     RowBox[{"-", "7.657766795775013`*^-18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.310887241768095`*^-30", ",", "0.`", ",", 
     RowBox[{"-", "2.2214323091023692`*^-27"}], ",", 
     RowBox[{"-", "4.543838814073028`*^-28"}], ",", "6.310056643865636`*^-17",
      ",", 
     RowBox[{"-", "1.7889335846010823`*^-17"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.262177448353619`*^-29"}], ",", "0.`", ",", 
     "1.1927576886941698`*^-27", ",", 
     RowBox[{"-", "1.006586515062011`*^-27"}], ",", 
     RowBox[{"-", "4.119968255444917`*^-18"}], ",", 
     RowBox[{"-", "2.927345865710862`*^-18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0028944190077897928`"}], ",", "167.8518506602158`", ",", 
     
     RowBox[{"-", "206.21699667885636`"}], ",", "140.32779796187083`", ",", 
     RowBox[{"-", "864.3587141022624`"}], ",", "232.52836536991427`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{574, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153204770]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"VerifySolutions", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " increases the precision of computations when needed:"
}], "ExampleText",
 CellID->48358916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"polys", "\[Equal]", "0"}], ",", 
    RowBox[{"VerifySolutions", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219039696],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "0.0781070776479125`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3.4526799291043363`*^-12"}]}], ",", 
     RowBox[{"p", "\[Rule]", "5.599222355067483`*^-16"}], ",", 
     RowBox[{"q", "\[Rule]", 
      RowBox[{"-", "3.378548493512777`*^-6"}]}], ",", 
     RowBox[{"r", "\[Rule]", "0.15911045619640546`"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.0028963009040325702`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "5.536717521949638`*^-19"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.10183327360795577`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "0.10183330687335972`"}], ",", 
     RowBox[{"q", "\[Rule]", 
      RowBox[{"-", "0.020833340138861865`"}]}], ",", 
     RowBox[{"r", "\[Rule]", "3.326550214785696`*^-8"}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "9.819973026202258`*^-14"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "8.247882104242985`*^-12"}], ",", 
     RowBox[{"y", "\[Rule]", "0.00005187878701151686`"}], ",", 
     RowBox[{"p", "\[Rule]", "0.0002005765924407127`"}], ",", 
     RowBox[{"q", "\[Rule]", "0.08054696822911195`"}], ",", 
     RowBox[{"r", "\[Rule]", "0.0002524551701994528`"}], ",", 
     RowBox[{"x", "\[Rule]", "1.9275701256816285`*^-10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "8.322008872899451`*^-12"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.000051938508875796024`"}]}], ",", 
     RowBox[{"p", "\[Rule]", 
      RowBox[{"-", "0.00020307897872418526`"}]}], ",", 
     RowBox[{"q", "\[Rule]", "0.0814580962821108`"}], ",", 
     RowBox[{"r", "\[Rule]", 
      RowBox[{"-", "0.00025501731170862946`"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.9253536954466017`*^-10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "0.08400370021556658`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "6.060470192353955`*^-14"}]}], ",", 
     RowBox[{"p", "\[Rule]", 
      RowBox[{"-", "3.2567598837581185`*^-21"}]}], ",", 
     RowBox[{"q", "\[Rule]", "1.1195363080996761`*^-9"}], ",", 
     RowBox[{"r", "\[Rule]", 
      RowBox[{"-", "0.0030037013351028852`"}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.16500369909609086`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{521, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177316093]
}, Open  ]],

Cell[TextData[{
 "The values of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " at the solutions are now much closer to zero:"
}], "ExampleText",
 CellID->247533000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"polys", "/.", "sol2"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->687746332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.6543612251060553`*^-24"}], ",", 
     "1.925929944387236`*^-34", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "3.76158192263132`*^-37", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
     "2.7755575615628914`*^-17", ",", 
     RowBox[{"-", "4.188313226376498`*^-18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.310887241768095`*^-30"}], ",", "0.`", ",", "0.`", ",", 
     "0.`", ",", "5.204170427930421`*^-18", ",", 
     RowBox[{"-", "4.0115480381963664`*^-18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.310887241768095`*^-30"}], ",", "0.`", ",", 
     "6.310887241768095`*^-30", ",", "0.`", ",", "2.883977778811442`*^-17", 
     ",", 
     RowBox[{"-", "2.927345865710862`*^-18"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", 
     RowBox[{"-", "9.4039548065783`*^-38"}], ",", 
     RowBox[{"-", "1.5777218104420236`*^-30"}], ",", 
     "2.7755575615628914`*^-17", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{491, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->126132910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->35528556],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " finds exact solutions of equations:"
}], "ExampleText",
 CellID->521475052],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", " ", 
     RowBox[{"{", "200", "}"}], ",", 
     RowBox[{"{", "200", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "200", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"x", "/@", 
    RowBox[{"Range", "[", "200", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{
         RowBox[{"mat", ".", "vars"}], "\[Equal]", "b"}], "]"}], ",", 
       "vars"}], "]"}]}], ")"}], ";"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->98855390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20.8`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15166963]
}, Open  ]],

Cell["Computing the solution using 100 digit numbers is faster:", \
"ExampleText",
 CellID->104412543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol1", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{
         RowBox[{"mat", ".", "vars"}], "\[Equal]", "b"}], "]"}], ",", "vars", 
       ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]}], ")"}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8719546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.744999999999997`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135604340]
}, Open  ]],

Cell["\<\
The result agrees with the exact solution in the first 100 digits:\
\>", "ExampleText",
 CellID->55610036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"vars", "/.", "sol"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"vars", "/.", "sol1"}], ")"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->385820411],

Cell[BoxData["0``97.97360679976221"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9827314]
}, Open  ]],

Cell["Computing the solution using machine numbers is much faster:", \
"ExampleText",
 CellID->1638663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"sol2", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{
         RowBox[{"mat", ".", "vars"}], "\[Equal]", "b"}], "]"}], ",", "vars", 
       ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], "]"}]}],
     ")"}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9413901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.27100000000000624`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->137416825]
}, Open  ]],

Cell["The result is still quite close to the exact solution:", "ExampleText",
 CellID->13168958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"vars", "/.", "sol"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"vars", "/.", "sol2"}], ")"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->214915095],

Cell[BoxData["4.929390229335695`*^-14"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->580380901]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->39004459],

Cell["Solve a quadratic equation:", "ExampleText",
 CellID->337878005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294558259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91410542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105924854],

Cell["Find intersection points of a circle and a parabola:", "ExampleText",
 CellID->31820714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"y", "-", 
       RowBox[{"2", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"3", "/", "2"}]}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423403341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["5"]}], ")"}]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SqrtBox[
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "-", 
           SqrtBox["5"]}], ")"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["5"]}], ")"}]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox[
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "-", 
           SqrtBox["5"]}], ")"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         FractionBox["5", "8"], "+", 
         FractionBox[
          SqrtBox["5"], "8"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}]}], ",", 
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       RowBox[{
        FractionBox["5", "8"], "+", 
        FractionBox[
         SqrtBox["5"], "8"]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{550, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->635150324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{"y", "-", 
          RowBox[{"2", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"3", "/", "2"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "/.", "pts"}], "]"}]}], "}"}], 
     "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143393633],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlWAlcjWkXTxQ+Q5YZS4yxNIWsMyrGcJCyZGvsU33ZyVKMIuPLMgYxEUVk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    "], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      TagBox[
       TooltipBox[
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189}],
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
       Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
        "Tooltip"]& ]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      TagBox[
       TooltipBox[
        LineBox[{190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
         202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215,
          216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 
         229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242,
          243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 
         256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
          270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 
         283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296,
          297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309}],
        RowBox[{
          RowBox[{
            FractionBox["3", "2"], "-", 
            RowBox[{"2", " ", 
              SuperscriptBox["x", "2"]}], "+", "y"}], "\[Equal]", "0"}]],
       Annotation[#, Rational[3, 2] - 2 $CellContext`x^2 + $CellContext`y == 
        0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 
         322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335,
          336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 
         349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
          363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 
         376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
          390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 
         403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416,
          417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 
         430, 431, 432, 433, 434, 435, 436, 437, 438}],
        RowBox[{
          RowBox[{
            FractionBox["3", "2"], "-", 
            RowBox[{"2", " ", 
              SuperscriptBox["x", "2"]}], "+", "y"}], "\[Equal]", "0"}]],
       Annotation[#, Rational[3, 2] - 2 $CellContext`x^2 + $CellContext`y == 
        0, "Tooltip"]& ]}}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    PointBox[NCache[{{
       Rational[-1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^Rational[1, 2],
         Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^
         Rational[1, 2])}, {-(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 
         5^Rational[1, 2])}}, {{-0.5877852522924731, -0.8090169943749475}, {
      0.5877852522924731, -0.8090169943749475}, {-0.9510565162951535, 
      0.30901699437494745`}, {0.9510565162951535, 0.30901699437494745`}}]]}},
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365758838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7206884],

Cell["Solutions satisfy the equations:", "ExampleText",
 CellID->323289730],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}]}], "\[Equal]", "4"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->45108859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"6", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{551, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47503014]
}, Open  ]],

Cell["\<\
Solutions are given as replacement rules and can be directly used for \
substitution:\
\>", "ExampleText",
 CellID->864653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "/.", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193833205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "True", "}"}], ",", 
   RowBox[{"{", "True", "}"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224688429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119985053],

Cell[TextData[{
 "Solve uses ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " to represent the empty or no solution:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28978]
}], "ExampleText",
 CellID->87905975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"x", "\[Equal]", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33130858],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301628433]
}, Open  ]],

Cell[TextData[{
 "Solve uses ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", "}"}], "}"}]], "InlineFormula"],
 " to represent the universal solution or that all points satisfy the \
equations:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->12974]
}], "ExampleText",
 CellID->618544184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699929497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "}"}], "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->283330032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231012026],

Cell[TextData[{
 "Solve will produce solutions according to their multiplicity:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1484]
}], "ExampleText",
 CellID->4925284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->837282633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284689132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->518158177],

Cell[TextData[{
 "Solutions of algebraic equations are often given in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->363]
}], "ExampleText",
 CellID->498180366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466347090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424084322]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to compute numeric approximations of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->183482082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->854575813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.59059537319672062593716589056785071691`20."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.3641060494347463171440129580599452624`19.528167125286526"}], 
      "-", 
      RowBox[{
      "1.48200219395081592056787738038190569721`20.13778807728499", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{
      "-", "0.3641060494347463171440129580599452624`19.528167125286526"}], 
      "+", 
      RowBox[{
      "1.48200219395081592056787738038190569721`20.13778807728499", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.15940373603310663011259590334387062086`20.076556297850715", "-", 
      RowBox[{
      "0.73855030709145277515102414079759552843`19.880701685411925", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.15940373603310663011259590334387062086`20.076556297850715", "+", 
      RowBox[{
      "0.73855030709145277515102414079759552843`19.88070168541193", " ", 
       "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{584, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133696058]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects may involve parameters:"
}], "ExampleText",
 CellID->153706395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "+", 
     RowBox[{"a", " ", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->447732597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13704583]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " to compute series expansions of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->21342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"x", "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16190],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   FractionBox["a", "5"], "+", 
   FractionBox[
    SuperscriptBox["a", "2"], "25"], "+", 
   FractionBox[
    SuperscriptBox["a", "3"], "125"], "-", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["a", "5"]}], "15625"], "-", 
   FractionBox[
    RowBox[{"78", " ", 
     SuperscriptBox["a", "6"]}], "78125"], "-", 
   FractionBox[
    RowBox[{"187", " ", 
     SuperscriptBox["a", "7"]}], "390625"], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["a", "8"]}], "1953125"], "+", 
   FractionBox[
    RowBox[{"9367", " ", 
     SuperscriptBox["a", "10"]}], "244140625"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "11"],
    SeriesData[$CellContext`a, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {-1, 
    Rational[1, 5], 
    Rational[1, 25], 
    Rational[1, 125], 0, 
    Rational[-21, 15625], 
    Rational[-78, 78125], 
    Rational[-187, 390625], 
    Rational[-286, 1953125], 0, 
    Rational[9367, 244140625]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->318490308]
}, Open  ]],

Cell["The series satisfies the equation up to order 11:", "ExampleText",
 CellID->189248852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "5"}], "+", 
   RowBox[{"a", " ", "x"}], "+", "1"}], "/.", 
  RowBox[{"x", "\[Rule]", "%"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->33769755],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "a", "]"}], "11"],
  SeriesData[$CellContext`a, 0, {}, 11, 11, 1],
  Editable->False]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->504290685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22368179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " represents solutions in terms of replacement rules:"
}], "ExampleText",
 CellID->262753204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "\[Equal]", "4"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675509501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{333, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458652929]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents solutions in terms of ",
 Cell[BoxData["Boolean"], "InlineFormula"],
 " combinations of equations and inequalities:"
}], "ExampleText",
 CellID->24756797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "\[Equal]", "4"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9052013],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{292, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13846453]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve equations and inequalities over specified domains:"
}], "ExampleText",
 CellID->14592355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "\[Equal]", "4"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->288282998],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{128, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->302470061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74549583],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find solution instances:"
}], "ExampleText",
 CellID->762934543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", "x", " ", "y"}], "==", 
     RowBox[{"z", "^", "3"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94194871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"27", "+", 
         RowBox[{"43", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "25"}], " ", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"27", "+", 
             RowBox[{"43", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"9", " ", 
              SuperscriptBox["#1", "4"]}], "+", 
             SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"27", "+", 
              RowBox[{"43", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"9", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
              SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], "3"]}], 
        "-", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"27", "+", 
             RowBox[{"43", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"9", " ", 
              SuperscriptBox["#1", "4"]}], "+", 
             SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], "5"]}], 
       ")"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{517, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564942312]
}, Open  ]],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " can be given inequalities and domain specifications:"
}], "ExampleText",
 CellID->174024972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"0", "<", "x", "<", 
     RowBox[{"10", "^", "10"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66329980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "708158977"}], ",", 
     RowBox[{"y", "\[Rule]", "408855776"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2642885282"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1525870529"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "978122"}], ",", 
     RowBox[{"y", "\[Rule]", "564719"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{421, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242335129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535740441],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to solve differential equations:"
}], "ExampleText",
 CellID->139782572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330621180],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->539356397]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153355340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"Sin", "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331194825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->561526712],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " to solve recurrence equations:"
}], "ExampleText",
 CellID->464195155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"n", " ", 
     RowBox[{"f", "[", "n", "]"}]}]}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141744698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], " ", 
     RowBox[{"Pochhammer", "[", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778768668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"n", "+", 
       RowBox[{"f", "[", "n", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20326289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{149, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6200338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->791025645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " gives the values of parameters for which complex equations are always \
true:"
}], "ExampleText",
 CellID->685179284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", " ", "-", 
        RowBox[{"2", "b"}], "+", "1"}], ")"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", "\[Equal]", 
    
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", "b", "+", 
     RowBox[{"3", "c"}], "-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239943741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "11"}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["13"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["11", "2"]}], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["13"]}], "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20588235]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->286318889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", "-", 
          RowBox[{"2", "b"}], "+", "1"}], ")"}], 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", 
      "\[Equal]", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", "b", "+", 
       RowBox[{"3", "c"}], "-", "1"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52715427],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      SqrtBox["13"]}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SqrtBox["13"]}]}]}], ")"}], "&&", 
  RowBox[{"b", "\[Equal]", 
   FractionBox[
    RowBox[{"1", "+", "a"}], "2"]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", "a"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{393, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12337145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113318179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " eliminates quantifiers, possibly without solving the resulting quantifier \
free system:"
}], "ExampleText",
 CellID->569389538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], ">", 
       RowBox[{"z", "^", "3"}]}]}]}], "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22615369],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "3"], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "4"], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["z", "2"]}], "+", 
      SuperscriptBox["z", "6"]}], "<", "0"}]}], ")"}]}]], "Output",
 ImageSize->{374, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337013210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"x", "\[Equal]", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->393608858],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{384, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471482825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->530410180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " eliminates variables from systems of complex equations:"
}], "ExampleText",
 CellID->171844387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "==", 
     RowBox[{"z", "^", "3"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19781343],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "4"], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   SuperscriptBox["z", "6"]}]}]], "Output",
 ImageSize->{136, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66618012]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->587034929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "==", 
      RowBox[{"z", "^", "3"}]}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21165408],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "4"], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["z", "2"]}], "+", 
      SuperscriptBox["z", "6"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{316, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4682972]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " additionally solves the resulting equations:"
}], "ExampleText",
 CellID->41914721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "==", 
       RowBox[{"z", "^", "3"}]}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258905246],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{580, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->251128819]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->100828262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives generic solutions; solutions involving equations on parameters are \
not given:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25663]
}], "ExampleText",
 CellID->115385123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "x"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132989080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"4", " ", "a"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"4", " ", "a"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{274, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242899886]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives all solutions, including those that require equations on \
parameters:"
}], "ExampleText",
 CellID->37121049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "x"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20682254],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "a"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "a"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{433, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->596620602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168081156],

Cell["\<\
Input equations involving only parameters are treated as assumptions:\
\>", "ExampleText",
 CellID->83488144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "a"}], "==", 
      RowBox[{"2", "b"}]}], ",", 
     RowBox[{
      RowBox[{"2", "x"}], "\[Equal]", "a"}], ",", 
     RowBox[{
      RowBox[{"3", "x"}], "\[Equal]", "b"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324748997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["b", "3"]}], "}"}], "}"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38380023]
}, Open  ]],

Cell[TextData[{
 "Without the assumption on parameters ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives no solutions: "
}], "ExampleText",
 CellID->57455917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "\[Equal]", "a"}], ",", 
     RowBox[{
      RowBox[{"3", "x"}], "\[Equal]", "b"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9801160],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->617861278]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the solution together with the condition on parameters:"
}], "ExampleText",
 CellID->193408673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", "x"}], "\[Equal]", "a"}], "&&", 
    RowBox[{
     RowBox[{"3", "x"}], "\[Equal]", "b"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74785528],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", 
   FractionBox[
    RowBox[{"2", " ", "b"}], "3"]}], "&&", 
  RowBox[{"x", "\[Equal]", 
   FractionBox["b", "3"]}]}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->836869258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23012525],

Cell[TextData[{
 "For transcendental equations ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " may not give all solutions:"
}], "ExampleText",
 CellID->290920712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243345728],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->92924160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455699923]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->301050383],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "3"]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["\[Pi]", "3"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{359, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->779175273]
}, Open  ]],

Cell[TextData[{
 "Using inverse functions allows ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find some solutions fast:"
}], "ExampleText",
 CellID->184751878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "\[Equal]", "1"}], ",", "x"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143189750],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->392997703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000000009`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->227920184]
}, Open  ]],

Cell["\<\
Finding the complete solution may take much longer and the solution may be \
large:\
\>", "ExampleText",
 CellID->280901066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"red", "=", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "n"}], "\[Equal]", "1"}], ",", "x"}], "]"}]}], 
    ")"}], "//", "LeafCount"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->214332995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21.811000000000003`", ",", "635"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->794742715]
}, Open  ]],

Cell[TextData[{
 "This finds the values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", "2"}]], "InlineFormula"],
 " is a solution: "
}], "ExampleText",
 CellID->15786440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "/.", 
    RowBox[{"x", "\[Rule]", "2"}]}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->665377366],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"n", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
    RowBox[{"n", "\[Equal]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"Log", "[", "2", "]"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"n", "\[Equal]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"Log", "[", "2", "]"}]]}]}], ")"}]}]], "Output",
 ImageSize->{492, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->265730387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "2"}], ",", 
      RowBox[{"n", "\[Rule]", 
       RowBox[{"2", "I", " ", "Pi", " ", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "/", 
         RowBox[{"Log", "[", "2", "]"}]}]}]}]}], "}"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], ",", "Integers"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->174944066],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->42321117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62959905],

Cell["\<\
A polynomial modular equation with symbolic coefficients generates an \
implicit solution:\
\>", "ExampleText",
 CellID->210277461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"a", " ", "x"}], "+", "b"}], "\[Equal]", "1"}], ",", 
     RowBox[{"Modulus", "\[Equal]", "4"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7784294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ToRules", "[", 
   RowBox[{
    RowBox[{"Modulus", "\[Equal]", "4"}], "&&", 
    RowBox[{"Roots", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], "\[Equal]", 
       RowBox[{"1", "-", "b"}]}], ",", "x", ",", 
      RowBox[{"Modulus", "\[Rule]", "4"}]}], "]"}]}], "]"}], "}"}]], "Output",\

 ImageSize->{418, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465812836]
}, Open  ]],

Cell["Get explicit solutions:", "ExampleText",
 CellID->2023680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "@@", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"ab", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{"ab", ",", "#"}], "]"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"%", "/.", "ab"}], ")"}]}]}], "]"}], "/@", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "i"}], ",", 
         RowBox[{"b", "\[Rule]", "j"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146085101],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{445, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->804210509]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6726],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolveAlways",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SolveAlways"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32162]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25187],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->399875475],

Cell[TextData[ButtonBox["Simultaneous Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimultaneousEquations"]], "Tutorials",
 CellID->19906],

Cell[TextData[ButtonBox["Solving Equations Involving Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]], "Tutorials",
 CellID->13840],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "Tutorials",
 CellID->27215680],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500],

Cell[TextData[ButtonBox["Generic and Non\[Hyphen]Generic Solutions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GenericAndNonGenericSolutions"]], "Tutorials",
 CellID->30083252],

Cell[TextData[ButtonBox["Eliminating Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EliminatingVariables"]], "Tutorials",
 CellID->309592249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Solve",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Solve"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->686990946],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->255611109],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->338286075],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->111040452],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->67705861],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->686042013]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 34.1058078}", "context" -> "System`", 
    "keywords" -> {
     "algebraic equations", "algebraic inequations", "equations", 
      "inequations", "polynomial equations", "roots of equations", 
      "solution of equations", "solving equations", "quasi algebraic sets", 
      "algebraically constructive sets"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Solve[eqns, vars] attempts to solve an equation or set of equations for \
the variables vars. Solve[eqns, vars, elims] attempts to solve the equations \
for vars, eliminating the variables elims. ", "synonyms" -> {}, "title" -> 
    "Solve", "type" -> "Symbol", "uri" -> "ref/Solve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13877, 428, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66521438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 186630, 6558}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4878, 95, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5501, 122, 43, 1, 70, "ObjectName",
 CellID->13408],
Cell[5547, 125, 1217, 39, 70, "Usage",
 CellID->30535]
}, Open  ]],
Cell[CellGroupData[{
Cell[6801, 169, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7279, 186, 192, 8, 70, "Notes",
 CellID->9751],
Cell[7474, 196, 158, 5, 70, "Notes",
 CellID->29897],
Cell[7635, 203, 92, 1, 70, "Notes",
 CellID->29246],
Cell[7730, 206, 318, 12, 70, "Notes",
 CellID->3186],
Cell[8051, 220, 319, 12, 70, "Notes",
 CellID->22671],
Cell[8373, 234, 505, 19, 70, "Notes",
 CellID->27834],
Cell[8881, 255, 223, 8, 70, "Notes",
 CellID->11429],
Cell[9107, 265, 324, 9, 70, "Notes",
 CellID->1484],
Cell[9434, 276, 216, 7, 70, "Notes",
 CellID->17682],
Cell[9653, 285, 1083, 34, 70, "Notes",
 CellID->9915],
Cell[10739, 321, 490, 14, 70, "Notes",
 CellID->25663],
Cell[11232, 337, 752, 21, 70, "Notes",
 CellID->363],
Cell[11987, 360, 331, 11, 70, "Notes",
 CellID->28978],
Cell[12321, 373, 349, 12, 70, "Notes",
 CellID->12974],
Cell[12673, 387, 878, 26, 70, "Notes",
 CellID->18354],
Cell[13554, 415, 286, 8, 70, "Notes",
 CellID->6251]
}, Closed]],
Cell[CellGroupData[{
Cell[13877, 428, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66521438],
Cell[CellGroupData[{
Cell[14261, 442, 148, 5, 70, "ExampleSection",
 CellID->646022131],
Cell[14412, 449, 66, 1, 70, "ExampleText",
 CellID->27628],
Cell[CellGroupData[{
Cell[14503, 454, 234, 9, 28, "Input",
 CellID->8743],
Cell[14740, 465, 788, 30, 52, "Output",
 CellID->394059293]
}, Open  ]],
Cell[15543, 498, 121, 3, 70, "ExampleDelimiter",
 CellID->29661],
Cell[15667, 503, 177, 7, 70, "ExampleText",
 CellID->5604],
Cell[CellGroupData[{
Cell[15869, 514, 381, 14, 70, "Input",
 CellID->1390],
Cell[16253, 530, 470, 17, 51, "Output",
 CellID->5101649]
}, Open  ]],
Cell[16738, 550, 120, 3, 70, "ExampleDelimiter",
 CellID->9614],
Cell[16861, 555, 83, 1, 70, "ExampleText",
 CellID->9322],
Cell[CellGroupData[{
Cell[16969, 560, 417, 15, 70, "Input",
 CellID->2895],
Cell[17389, 577, 1169, 43, 61, "Output",
 CellID->6036545]
}, Open  ]],
Cell[18573, 623, 119, 5, 70, "ExampleText",
 CellID->20281],
Cell[CellGroupData[{
Cell[18717, 632, 88, 3, 70, "Input",
 CellID->41],
Cell[18808, 637, 517, 20, 61, "Output",
 CellID->303473510]
}, Open  ]],
Cell[19340, 660, 209, 7, 70, "ExampleText",
 CellID->14417],
Cell[CellGroupData[{
Cell[19574, 671, 284, 11, 70, "Input",
 CellID->15122],
Cell[19861, 684, 690, 27, 48, "Output",
 CellID->547796209]
}, Open  ]],
Cell[20566, 714, 214, 7, 70, "ExampleText",
 CellID->21566],
Cell[CellGroupData[{
Cell[20805, 725, 274, 9, 28, "Input",
 CellID->16743],
Cell[21082, 736, 2819, 50, 122, "Output",
 Evaluatable->False,
 CellID->270780658]
}, Open  ]],
Cell[23916, 789, 117, 3, 70, "ExampleDelimiter",
 CellID->9],
Cell[24036, 794, 65, 1, 70, "ExampleText",
 CellID->26222],
Cell[CellGroupData[{
Cell[24126, 799, 283, 10, 70, "Input",
 CellID->29144],
Cell[24412, 811, 941, 34, 67, "Output",
 CellID->380254478]
}, Open  ]],
Cell[CellGroupData[{
Cell[25390, 850, 313, 11, 70, "Input",
 CellID->1501],
Cell[25706, 863, 835, 32, 67, "Output",
 CellID->83061300]
}, Open  ]],
Cell[26556, 898, 65, 2, 70, "Input",
 CellID->29712]
}, Open  ]],
Cell[CellGroupData[{
Cell[26658, 905, 221, 7, 70, "ExampleSection",
 CellID->111456608],
Cell[CellGroupData[{
Cell[26904, 916, 249, 7, 70, "ExampleSubsection",
 CellID->5642],
Cell[27156, 925, 85, 1, 70, "ExampleText",
 CellID->639965264],
Cell[CellGroupData[{
Cell[27266, 930, 245, 9, 70, "Input",
 CellID->109018309],
Cell[27514, 941, 1147, 43, 111, "Output",
 CellID->46290648]
}, Open  ]],
Cell[CellGroupData[{
Cell[28698, 989, 298, 11, 70, "Input",
 CellID->175945626],
Cell[28999, 1002, 3128, 104, 163, "Output",
 CellID->667417195]
}, Open  ]],
Cell[32142, 1109, 125, 3, 70, "ExampleDelimiter",
 CellID->220762094],
Cell[32270, 1114, 72, 1, 70, "ExampleText",
 CellID->542378015],
Cell[CellGroupData[{
Cell[32367, 1119, 241, 9, 70, "Input",
 CellID->721327065],
Cell[32611, 1130, 1463, 52, 77, "Output",
 CellID->269949305]
}, Open  ]],
Cell[34089, 1185, 124, 3, 70, "ExampleDelimiter",
 CellID->63270980],
Cell[34216, 1190, 84, 1, 70, "ExampleText",
 CellID->304777361],
Cell[CellGroupData[{
Cell[34325, 1195, 341, 13, 70, "Input",
 CellID->313812518],
Cell[34669, 1210, 660, 22, 36, "Output",
 CellID->70302458]
}, Open  ]],
Cell[35344, 1235, 125, 3, 70, "ExampleDelimiter",
 CellID->922791320],
Cell[35472, 1240, 90, 1, 70, "ExampleText",
 CellID->55057830],
Cell[CellGroupData[{
Cell[35587, 1245, 271, 10, 70, "Input",
 CellID->25160730],
Cell[35861, 1257, 750, 27, 62, "Output",
 CellID->589038447]
}, Open  ]],
Cell[CellGroupData[{
Cell[36648, 1289, 272, 10, 70, "Input",
 CellID->495029460],
Cell[36923, 1301, 1590, 30, 70, "Output",
 Evaluatable->False,
 CellID->106432932]
}, Open  ]],
Cell[38528, 1334, 124, 3, 70, "ExampleDelimiter",
 CellID->13866999],
Cell[38655, 1339, 59, 1, 70, "ExampleText",
 CellID->78207],
Cell[CellGroupData[{
Cell[38739, 1344, 321, 12, 70, "Input",
 CellID->52466515],
Cell[39063, 1358, 803, 28, 59, "Output",
 CellID->4626713]
}, Open  ]],
Cell[39881, 1389, 125, 3, 70, "ExampleDelimiter",
 CellID->897558702],
Cell[40009, 1394, 68, 1, 70, "ExampleText",
 CellID->288893094],
Cell[CellGroupData[{
Cell[40102, 1399, 212, 7, 70, "Input",
 CellID->256538498],
Cell[40317, 1408, 452, 8, 70, "Message",
 CellID->48228413],
Cell[40772, 1418, 292, 10, 51, "Output",
 CellID->38980955]
}, Open  ]],
Cell[CellGroupData[{
Cell[41101, 1433, 317, 12, 70, "Input",
 CellID->490585453],
Cell[41421, 1447, 452, 8, 70, "Message",
 CellID->35749816],
Cell[41876, 1457, 330, 12, 48, "Output",
 CellID->51397960]
}, Open  ]],
Cell[CellGroupData[{
Cell[42243, 1474, 266, 10, 70, "Input",
 CellID->206328419],
Cell[42512, 1486, 612, 22, 39, "Output",
 CellID->404028426]
}, Open  ]],
Cell[CellGroupData[{
Cell[43161, 1513, 261, 9, 70, "Input",
 CellID->266904943],
Cell[43425, 1524, 428, 8, 70, "Message",
 CellID->148518655],
Cell[43856, 1534, 452, 8, 70, "Message",
 CellID->65450368],
Cell[44311, 1544, 440, 15, 60, "Output",
 CellID->121726737]
}, Open  ]],
Cell[CellGroupData[{
Cell[44788, 1564, 464, 16, 70, "Input",
 CellID->276451892],
Cell[45255, 1582, 794, 25, 53, "Output",
 CellID->6598531]
}, Open  ]],
Cell[46064, 1610, 125, 3, 70, "ExampleDelimiter",
 CellID->496261871],
Cell[46192, 1615, 62, 1, 70, "ExampleText",
 CellID->111386027],
Cell[CellGroupData[{
Cell[46279, 1620, 304, 11, 70, "Input",
 CellID->65207232],
Cell[46586, 1633, 428, 8, 70, "Message",
 CellID->343497777],
Cell[47017, 1643, 428, 8, 70, "Message",
 CellID->324598384],
Cell[47448, 1653, 1330, 48, 51, "Output",
 CellID->576951033]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48827, 1707, 266, 7, 70, "ExampleSubsection",
 CellID->20620],
Cell[49096, 1716, 70, 1, 70, "ExampleText",
 CellID->17776778],
Cell[CellGroupData[{
Cell[49191, 1721, 630, 22, 70, "Input",
 CellID->248564057],
Cell[49824, 1745, 352, 12, 36, "Output",
 CellID->607223075]
}, Open  ]],
Cell[50191, 1760, 125, 3, 70, "ExampleDelimiter",
 CellID->503057964],
Cell[50319, 1765, 87, 1, 70, "ExampleText",
 CellID->463598910],
Cell[CellGroupData[{
Cell[50431, 1770, 634, 22, 70, "Input",
 CellID->54580525],
Cell[51068, 1794, 1279, 43, 52, "Output",
 CellID->252707845]
}, Open  ]],
Cell[52362, 1840, 125, 3, 70, "ExampleDelimiter",
 CellID->426826805],
Cell[52490, 1845, 87, 1, 70, "ExampleText",
 CellID->276914946],
Cell[CellGroupData[{
Cell[52602, 1850, 630, 22, 70, "Input",
 CellID->123282614],
Cell[53235, 1874, 385, 7, 70, "Message",
 CellID->18901328],
Cell[53623, 1883, 390, 14, 36, "Output",
 CellID->57230477]
}, Open  ]],
Cell[54028, 1900, 123, 3, 70, "ExampleDelimiter",
 CellID->8592199],
Cell[54154, 1905, 78, 1, 70, "ExampleText",
 CellID->697543653],
Cell[CellGroupData[{
Cell[54257, 1910, 630, 22, 70, "Input",
 CellID->105343871],
Cell[54890, 1934, 175, 6, 36, "Output",
 CellID->192836578]
}, Open  ]],
Cell[55080, 1943, 125, 3, 70, "ExampleDelimiter",
 CellID->613122198],
Cell[55208, 1948, 75, 1, 70, "ExampleText",
 CellID->200377638],
Cell[CellGroupData[{
Cell[55308, 1953, 421, 15, 70, "Input",
 CellID->261886345],
Cell[55732, 1970, 912, 32, 51, "Output",
 CellID->22010849]
}, Open  ]],
Cell[56659, 2005, 125, 3, 70, "ExampleDelimiter",
 CellID->169601750],
Cell[56787, 2010, 90, 1, 70, "ExampleText",
 CellID->92261027],
Cell[CellGroupData[{
Cell[56902, 2015, 478, 17, 70, "Input",
 CellID->88463089],
Cell[57383, 2034, 1920, 36, 70, "Output",
 Evaluatable->False,
 CellID->614380733]
}, Open  ]],
Cell[59318, 2073, 125, 3, 70, "ExampleDelimiter",
 CellID->396734724],
Cell[59446, 2078, 63, 1, 70, "ExampleText",
 CellID->222879371],
Cell[CellGroupData[{
Cell[59534, 2083, 568, 20, 70, "Input",
 CellID->184286723],
Cell[60105, 2105, 453, 8, 70, "Message",
 CellID->140917979],
Cell[60561, 2115, 2244, 41, 70, "Output",
 Evaluatable->False,
 CellID->10144364]
}, Open  ]],
Cell[62820, 2159, 125, 3, 70, "ExampleDelimiter",
 CellID->507297643],
Cell[62948, 2164, 68, 1, 70, "ExampleText",
 CellID->190619530],
Cell[CellGroupData[{
Cell[63041, 2169, 439, 15, 70, "Input",
 CellID->506185029],
Cell[63483, 2186, 453, 8, 70, "Message",
 CellID->338098336],
Cell[63939, 2196, 375, 13, 51, "Output",
 CellID->406466148]
}, Open  ]],
Cell[CellGroupData[{
Cell[64351, 2214, 394, 14, 70, "Input",
 CellID->95252965],
Cell[64748, 2230, 453, 8, 70, "Message",
 CellID->372178319],
Cell[65204, 2240, 3778, 128, 216, "Output",
 CellID->53698727]
}, Open  ]],
Cell[CellGroupData[{
Cell[69019, 2373, 478, 17, 70, "Input",
 CellID->478593427],
Cell[69500, 2392, 453, 8, 70, "Message",
 CellID->557393569],
Cell[69956, 2402, 385, 7, 70, "Message",
 CellID->93023770],
Cell[70344, 2411, 336, 12, 61, "Output",
 CellID->248878097]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70729, 2429, 238, 7, 70, "ExampleSubsection",
 CellID->184776408],
Cell[70970, 2438, 58, 1, 70, "ExampleText",
 CellID->75271447],
Cell[CellGroupData[{
Cell[71053, 2443, 515, 18, 70, "Input",
 CellID->154699585],
Cell[71571, 2463, 415, 14, 36, "Output",
 CellID->5354664]
}, Open  ]],
Cell[72001, 2480, 125, 3, 70, "ExampleDelimiter",
 CellID->856881048],
Cell[72129, 2485, 73, 1, 70, "ExampleText",
 CellID->60093961],
Cell[CellGroupData[{
Cell[72227, 2490, 297, 10, 70, "Input",
 CellID->55991068],
Cell[72527, 2502, 571, 19, 36, "Output",
 CellID->136359215]
}, Open  ]],
Cell[73113, 2524, 124, 3, 70, "ExampleDelimiter",
 CellID->25623072],
Cell[73240, 2529, 92, 1, 70, "ExampleText",
 CellID->276046792],
Cell[CellGroupData[{
Cell[73357, 2534, 467, 16, 70, "Input",
 CellID->221242426],
Cell[73827, 2552, 526, 17, 36, "Output",
 CellID->406601982]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74414, 2576, 239, 7, 70, "ExampleSection",
 CellID->15946],
Cell[74656, 2585, 68, 1, 70, "ExampleText",
 CellID->24954],
Cell[CellGroupData[{
Cell[74749, 2590, 200, 7, 70, "Input",
 CellID->28752],
Cell[74952, 2599, 610, 23, 51, "Output",
 CellID->537558362]
}, Open  ]],
Cell[CellGroupData[{
Cell[75599, 2627, 247, 9, 70, "Input",
 CellID->7633],
Cell[75849, 2638, 338, 12, 51, "Output",
 CellID->175443958]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76236, 2656, 221, 7, 70, "ExampleSection",
 CellID->22083604],
Cell[CellGroupData[{
Cell[76482, 2667, 363, 10, 70, "ExampleSubsection",
 CellID->333281304],
Cell[76848, 2679, 240, 8, 70, "ExampleText",
 CellID->498336114],
Cell[CellGroupData[{
Cell[77113, 2691, 188, 7, 70, "Input",
 CellID->615068353],
Cell[77304, 2700, 428, 8, 70, "Message",
 CellID->669920795],
Cell[77735, 2710, 412, 15, 39, "Output",
 CellID->453548768]
}, Open  ]],
Cell[CellGroupData[{
Cell[78184, 2730, 190, 7, 70, "Input",
 CellID->474401374],
Cell[78377, 2739, 453, 8, 70, "Message",
 CellID->309378541],
Cell[78833, 2749, 233, 8, 36, "Output",
 CellID->747506071]
}, Open  ]],
Cell[79081, 2760, 125, 3, 70, "ExampleDelimiter",
 CellID->101098913],
Cell[79209, 2765, 475, 17, 70, "ExampleText",
 CellID->41155148],
Cell[CellGroupData[{
Cell[79709, 2786, 243, 7, 70, "Input",
 CellID->150621549],
Cell[79955, 2795, 411, 15, 39, "Output",
 CellID->99808831]
}, Open  ]],
Cell[CellGroupData[{
Cell[80403, 2815, 245, 7, 70, "Input",
 CellID->386395636],
Cell[80651, 2824, 233, 8, 36, "Output",
 CellID->322138009]
}, Open  ]],
Cell[80899, 2835, 125, 3, 70, "ExampleDelimiter",
 CellID->135518962],
Cell[81027, 2840, 460, 17, 70, "ExampleText",
 CellID->208160627],
Cell[CellGroupData[{
Cell[81512, 2861, 244, 7, 70, "Input",
 CellID->143230375],
Cell[81759, 2870, 332, 10, 36, "Output",
 CellID->78678095]
}, Open  ]],
Cell[CellGroupData[{
Cell[82128, 2885, 246, 7, 70, "Input",
 CellID->202852608],
Cell[82377, 2894, 334, 10, 36, "Output",
 CellID->17212343]
}, Open  ]],
Cell[82726, 2907, 120, 3, 70, "ExampleText",
 CellID->203165551],
Cell[CellGroupData[{
Cell[82871, 2914, 265, 8, 70, "Input",
 CellID->413086211],
Cell[83139, 2924, 358, 12, 36, "Output",
 CellID->81281597]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83546, 2942, 352, 10, 70, "ExampleSubsection",
 CellID->415375537],
Cell[83901, 2954, 113, 3, 70, "ExampleText",
 CellID->640369772],
Cell[CellGroupData[{
Cell[84039, 2961, 584, 20, 70, "Input",
 CellID->197039454],
Cell[84626, 2983, 350, 11, 36, "Output",
 CellID->259280301]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85025, 3000, 223, 7, 70, "ExampleSubsection",
 CellID->3236023],
Cell[85251, 3009, 259, 8, 70, "ExampleText",
 CellID->428032455],
Cell[CellGroupData[{
Cell[85535, 3021, 545, 19, 70, "Input",
 CellID->47284086],
Cell[86083, 3042, 224, 7, 36, "Output",
 CellID->383981843]
}, Open  ]],
Cell[86322, 3052, 125, 3, 70, "ExampleDelimiter",
 CellID->153198263],
Cell[86450, 3057, 386, 14, 70, "ExampleText",
 CellID->410440875],
Cell[CellGroupData[{
Cell[86861, 3075, 590, 20, 70, "Input",
 CellID->203495263],
Cell[87454, 3097, 215, 7, 36, "Output",
 CellID->1020129846]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87718, 3110, 236, 7, 70, "ExampleSubsection",
 CellID->178896398],
Cell[87957, 3119, 236, 7, 70, "ExampleText",
 CellID->55614444],
Cell[CellGroupData[{
Cell[88218, 3130, 714, 26, 70, "Input",
 CellID->45476055],
Cell[88935, 3158, 213, 7, 36, "Output",
 CellID->286294189]
}, Open  ]],
Cell[89163, 3168, 372, 14, 70, "ExampleText",
 CellID->64639296],
Cell[CellGroupData[{
Cell[89560, 3186, 356, 12, 70, "Input",
 CellID->315728882],
Cell[89919, 3200, 223, 7, 36, "Output",
 CellID->810340903]
}, Open  ]],
Cell[90157, 3210, 270, 9, 70, "ExampleText",
 CellID->524121027],
Cell[CellGroupData[{
Cell[90452, 3223, 156, 5, 70, "Input",
 CellID->210204361],
Cell[90611, 3230, 204, 7, 36, "Output",
 CellID->14876729]
}, Open  ]],
Cell[90830, 3240, 123, 3, 70, "ExampleText",
 CellID->153674693],
Cell[CellGroupData[{
Cell[90978, 3247, 402, 14, 70, "Input",
 CellID->204740677],
Cell[91383, 3263, 223, 7, 36, "Output",
 CellID->696785202]
}, Open  ]],
Cell[91621, 3273, 116, 3, 70, "ExampleText",
 CellID->933296892],
Cell[CellGroupData[{
Cell[91762, 3280, 100, 3, 70, "Input",
 CellID->343616274],
Cell[91865, 3285, 160, 5, 36, "Output",
 CellID->79554254]
}, Open  ]],
Cell[92040, 3293, 125, 3, 70, "ExampleDelimiter",
 CellID->742185169],
Cell[92168, 3298, 254, 8, 70, "ExampleText",
 CellID->213263060],
Cell[CellGroupData[{
Cell[92447, 3310, 1084, 35, 70, "Input",
 CellID->353989898],
Cell[93534, 3347, 2581, 62, 153, "Output",
 CellID->847416807]
}, Open  ]],
Cell[96130, 3412, 184, 6, 70, "ExampleText",
 CellID->102148018],
Cell[CellGroupData[{
Cell[96339, 3422, 100, 3, 70, "Input",
 CellID->492705422],
Cell[96442, 3427, 1603, 40, 134, "Output",
 CellID->153204770]
}, Open  ]],
Cell[98060, 3470, 392, 14, 70, "ExampleText",
 CellID->48358916],
Cell[CellGroupData[{
Cell[98477, 3488, 235, 7, 70, "Input",
 CellID->219039696],
Cell[98715, 3497, 2623, 63, 172, "Output",
 CellID->177316093]
}, Open  ]],
Cell[101353, 3563, 184, 6, 70, "ExampleText",
 CellID->247533000],
Cell[CellGroupData[{
Cell[101562, 3573, 100, 3, 70, "Input",
 CellID->687746332],
Cell[101665, 3578, 1254, 33, 115, "Output",
 CellID->126132910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102968, 3617, 236, 7, 70, "ExampleSubsection",
 CellID->35528556],
Cell[103207, 3626, 224, 8, 70, "ExampleText",
 CellID->521475052],
Cell[CellGroupData[{
Cell[103456, 3638, 1105, 37, 70, "Input",
 CellID->98855390],
Cell[104564, 3677, 209, 7, 36, "Output",
 CellID->15166963]
}, Open  ]],
Cell[104788, 3687, 102, 2, 70, "ExampleText",
 CellID->104412543],
Cell[CellGroupData[{
Cell[104915, 3693, 413, 14, 70, "Input",
 CellID->8719546],
Cell[105331, 3709, 225, 7, 36, "Output",
 CellID->135604340]
}, Open  ]],
Cell[105571, 3719, 116, 3, 70, "ExampleText",
 CellID->55610036],
Cell[CellGroupData[{
Cell[105712, 3726, 268, 9, 70, "Input",
 CellID->385820411],
Cell[105983, 3737, 175, 5, 36, "Output",
 CellID->9827314]
}, Open  ]],
Cell[106173, 3745, 103, 2, 70, "ExampleText",
 CellID->1638663],
Cell[CellGroupData[{
Cell[106301, 3751, 427, 14, 70, "Input",
 CellID->9413901],
Cell[106731, 3767, 225, 7, 36, "Output",
 CellID->137416825]
}, Open  ]],
Cell[106971, 3777, 96, 1, 70, "ExampleText",
 CellID->13168958],
Cell[CellGroupData[{
Cell[107092, 3782, 268, 9, 70, "Input",
 CellID->214915095],
Cell[107363, 3793, 180, 5, 36, "Output",
 CellID->580380901]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[107604, 3805, 226, 7, 70, "ExampleSection",
 CellID->39004459],
Cell[107833, 3814, 70, 1, 70, "ExampleText",
 CellID->337878005],
Cell[CellGroupData[{
Cell[107928, 3819, 272, 10, 70, "Input",
 CellID->294558259],
Cell[108203, 3831, 749, 27, 62, "Output",
 CellID->91410542]
}, Open  ]],
Cell[108967, 3861, 125, 3, 70, "ExampleDelimiter",
 CellID->105924854],
Cell[109095, 3866, 94, 1, 70, "ExampleText",
 CellID->31820714],
Cell[CellGroupData[{
Cell[109214, 3871, 493, 17, 70, "Input",
 CellID->423403341],
Cell[109710, 3890, 1995, 75, 112, "Output",
 CellID->635150324]
}, Open  ]],
Cell[CellGroupData[{
Cell[111742, 3970, 1041, 33, 70, "Input",
 CellID->143393633],
Cell[112786, 4005, 9497, 169, 70, "Output",
 CellID->365758838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122332, 4180, 236, 7, 70, "ExampleSection",
 CellID->7206884],
Cell[122571, 4189, 75, 1, 70, "ExampleText",
 CellID->323289730],
Cell[CellGroupData[{
Cell[122671, 4194, 503, 18, 70, "Input",
 CellID->45108859],
Cell[123177, 4214, 1141, 39, 51, "Output",
 CellID->47503014]
}, Open  ]],
Cell[124333, 4256, 133, 4, 70, "ExampleText",
 CellID->864653],
Cell[CellGroupData[{
Cell[124491, 4264, 96, 3, 70, "Input",
 CellID->193833205],
Cell[124590, 4269, 258, 9, 36, "Output",
 CellID->224688429]
}, Open  ]],
Cell[124863, 4281, 125, 3, 70, "ExampleDelimiter",
 CellID->119985053],
Cell[124991, 4286, 251, 9, 70, "ExampleText",
 CellID->87905975],
Cell[CellGroupData[{
Cell[125267, 4299, 212, 7, 70, "Input",
 CellID->33130858],
Cell[125482, 4308, 175, 6, 36, "Output",
 CellID->301628433]
}, Open  ]],
Cell[125672, 4317, 317, 11, 70, "ExampleText",
 CellID->618544184],
Cell[CellGroupData[{
Cell[126014, 4332, 155, 5, 70, "Input",
 CellID->699929497],
Cell[126172, 4339, 198, 7, 36, "Output",
 CellID->283330032]
}, Open  ]],
Cell[126385, 4349, 125, 3, 70, "ExampleDelimiter",
 CellID->231012026],
Cell[126513, 4354, 199, 6, 70, "ExampleText",
 CellID->4925284],
Cell[CellGroupData[{
Cell[126737, 4364, 341, 13, 70, "Input",
 CellID->837282633],
Cell[127081, 4379, 509, 17, 36, "Output",
 CellID->284689132]
}, Open  ]],
Cell[127605, 4399, 125, 3, 70, "ExampleDelimiter",
 CellID->518158177],
Cell[127733, 4404, 325, 11, 70, "ExampleText",
 CellID->498180366],
Cell[CellGroupData[{
Cell[128083, 4419, 240, 9, 70, "Input",
 CellID->466347090],
Cell[128326, 4430, 1458, 52, 77, "Output",
 CellID->424084322]
}, Open  ]],
Cell[129799, 4485, 335, 13, 70, "ExampleText",
 CellID->183482082],
Cell[CellGroupData[{
Cell[130159, 4502, 121, 4, 70, "Input",
 CellID->854575813],
Cell[130283, 4508, 1440, 43, 88, "Output",
 CellID->133696058]
}, Open  ]],
Cell[131738, 4554, 201, 7, 70, "ExampleText",
 CellID->153706395],
Cell[CellGroupData[{
Cell[131964, 4565, 245, 9, 70, "Input",
 CellID->447732597],
Cell[132212, 4576, 1457, 52, 77, "Output",
 CellID->13704583]
}, Open  ]],
Cell[133684, 4631, 336, 13, 70, "ExampleText",
 CellID->21342],
Cell[CellGroupData[{
Cell[134045, 4648, 262, 9, 70, "Input",
 CellID->16190],
Cell[134310, 4659, 1266, 43, 54, "Output",
 CellID->318490308]
}, Open  ]],
Cell[135591, 4705, 92, 1, 70, "ExampleText",
 CellID->189248852],
Cell[CellGroupData[{
Cell[135708, 4710, 202, 7, 70, "Input",
 CellID->33769755],
Cell[135913, 4719, 300, 10, 36, "Output",
 CellID->504290685]
}, Open  ]],
Cell[136228, 4732, 124, 3, 70, "ExampleDelimiter",
 CellID->22368179],
Cell[136355, 4737, 223, 7, 70, "ExampleText",
 CellID->262753204],
Cell[CellGroupData[{
Cell[136603, 4748, 180, 6, 70, "Input",
 CellID->675509501],
Cell[136786, 4756, 626, 23, 43, "Output",
 CellID->458652929]
}, Open  ]],
Cell[137427, 4782, 299, 9, 70, "ExampleText",
 CellID->24756797],
Cell[CellGroupData[{
Cell[137751, 4795, 179, 6, 70, "Input",
 CellID->9052013],
Cell[137933, 4803, 489, 18, 38, "Output",
 CellID->13846453]
}, Open  ]],
Cell[138437, 4824, 241, 8, 70, "ExampleText",
 CellID->14592355],
Cell[CellGroupData[{
Cell[138703, 4836, 198, 7, 70, "Input",
 CellID->288282998],
Cell[138904, 4845, 288, 11, 38, "Output",
 CellID->302470061]
}, Open  ]],
Cell[139207, 4859, 124, 3, 70, "ExampleDelimiter",
 CellID->74549583],
Cell[139334, 4864, 222, 8, 70, "ExampleText",
 CellID->762934543],
Cell[CellGroupData[{
Cell[139581, 4876, 440, 15, 70, "Input",
 CellID->94194871],
Cell[140024, 4893, 1899, 58, 95, "Output",
 CellID->564942312]
}, Open  ]],
Cell[141938, 4954, 370, 13, 70, "ExampleText",
 CellID->174024972],
Cell[CellGroupData[{
Cell[142333, 4971, 432, 15, 70, "Input",
 CellID->66329980],
Cell[142768, 4988, 619, 20, 54, "Output",
 CellID->242335129]
}, Open  ]],
Cell[143402, 5011, 125, 3, 70, "ExampleDelimiter",
 CellID->535740441],
Cell[143530, 5016, 215, 8, 70, "ExampleText",
 CellID->139782572],
Cell[CellGroupData[{
Cell[143770, 5028, 298, 10, 70, "Input",
 CellID->330621180],
Cell[144071, 5040, 473, 16, 36, "Output",
 CellID->539356397]
}, Open  ]],
Cell[CellGroupData[{
Cell[144581, 5061, 520, 17, 70, "Input",
 CellID->153355340],
Cell[145104, 5080, 296, 10, 36, "Output",
 CellID->331194825]
}, Open  ]],
Cell[145415, 5093, 125, 3, 70, "ExampleDelimiter",
 CellID->561526712],
Cell[145543, 5098, 213, 8, 70, "ExampleText",
 CellID->464195155],
Cell[CellGroupData[{
Cell[145781, 5110, 307, 10, 70, "Input",
 CellID->141744698],
Cell[146091, 5122, 439, 15, 36, "Output",
 CellID->778768668]
}, Open  ]],
Cell[CellGroupData[{
Cell[146567, 5142, 430, 14, 70, "Input",
 CellID->20326289],
Cell[147000, 5158, 400, 15, 51, "Output",
 CellID->6200338]
}, Open  ]],
Cell[147415, 5176, 125, 3, 70, "ExampleDelimiter",
 CellID->791025645],
Cell[147543, 5181, 261, 8, 70, "ExampleText",
 CellID->685179284],
Cell[CellGroupData[{
Cell[147829, 5193, 545, 19, 70, "Input",
 CellID->239943741],
Cell[148377, 5214, 1299, 48, 86, "Output",
 CellID->20588235]
}, Open  ]],
Cell[149691, 5265, 214, 8, 70, "ExampleText",
 CellID->286318889],
Cell[CellGroupData[{
Cell[149930, 5277, 687, 23, 70, "Input",
 CellID->52715427],
Cell[150620, 5302, 688, 26, 51, "Output",
 CellID->12337145]
}, Open  ]],
Cell[151323, 5331, 125, 3, 70, "ExampleDelimiter",
 CellID->113318179],
Cell[151451, 5336, 264, 8, 70, "ExampleText",
 CellID->569389538],
Cell[CellGroupData[{
Cell[151740, 5348, 457, 15, 70, "Input",
 CellID->22615369],
Cell[152200, 5365, 829, 29, 39, "Output",
 CellID->337013210]
}, Open  ]],
Cell[CellGroupData[{
Cell[153066, 5399, 589, 19, 70, "Input",
 CellID->393608858],
Cell[153658, 5420, 1063, 35, 58, "Output",
 CellID->471482825]
}, Open  ]],
Cell[154736, 5458, 125, 3, 70, "ExampleDelimiter",
 CellID->530410180],
Cell[154864, 5463, 235, 7, 70, "ExampleText",
 CellID->171844387],
Cell[CellGroupData[{
Cell[155124, 5474, 379, 13, 70, "Input",
 CellID->19781343],
Cell[155506, 5489, 429, 16, 39, "Output",
 CellID->66618012]
}, Open  ]],
Cell[155950, 5508, 216, 8, 70, "ExampleText",
 CellID->587034929],
Cell[CellGroupData[{
Cell[156191, 5520, 420, 14, 70, "Input",
 CellID->21165408],
Cell[156614, 5536, 645, 22, 39, "Output",
 CellID->4682972]
}, Open  ]],
Cell[157274, 5561, 217, 7, 70, "ExampleText",
 CellID->41914721],
Cell[CellGroupData[{
Cell[157516, 5572, 503, 17, 70, "Input",
 CellID->258905246],
Cell[158022, 5591, 3413, 60, 70, "Output",
 Evaluatable->False,
 CellID->251128819]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[161484, 5657, 230, 7, 70, "ExampleSection",
 CellID->100828262],
Cell[161717, 5666, 340, 11, 70, "ExampleText",
 CellID->115385123],
Cell[CellGroupData[{
Cell[162082, 5681, 236, 9, 70, "Input",
 CellID->132989080],
Cell[162321, 5692, 668, 25, 57, "Output",
 CellID->242899886]
}, Open  ]],
Cell[163004, 5720, 249, 8, 70, "ExampleText",
 CellID->37121049],
Cell[CellGroupData[{
Cell[163278, 5732, 236, 9, 70, "Input",
 CellID->20682254],
Cell[163517, 5743, 879, 31, 61, "Output",
 CellID->596620602]
}, Open  ]],
Cell[164411, 5777, 125, 3, 70, "ExampleDelimiter",
 CellID->168081156],
Cell[164539, 5782, 119, 3, 70, "ExampleText",
 CellID->83488144],
Cell[CellGroupData[{
Cell[164683, 5789, 367, 14, 70, "Input",
 CellID->324748997],
Cell[165053, 5805, 255, 9, 51, "Output",
 CellID->38380023]
}, Open  ]],
Cell[165323, 5817, 233, 8, 70, "ExampleText",
 CellID->57455917],
Cell[CellGroupData[{
Cell[165581, 5829, 284, 11, 70, "Input",
 CellID->9801160],
Cell[165868, 5842, 175, 6, 36, "Output",
 CellID->617861278]
}, Open  ]],
Cell[166058, 5851, 235, 7, 70, "ExampleText",
 CellID->193408673],
Cell[CellGroupData[{
Cell[166318, 5862, 255, 9, 70, "Input",
 CellID->74785528],
Cell[166576, 5873, 311, 11, 51, "Output",
 CellID->836869258]
}, Open  ]],
Cell[166902, 5887, 124, 3, 70, "ExampleDelimiter",
 CellID->23012525],
Cell[167029, 5892, 233, 8, 70, "ExampleText",
 CellID->290920712],
Cell[CellGroupData[{
Cell[167287, 5904, 212, 7, 70, "Input",
 CellID->243345728],
Cell[167502, 5913, 452, 8, 70, "Message",
 CellID->92924160],
Cell[167957, 5923, 392, 14, 49, "Output",
 CellID->455699923]
}, Open  ]],
Cell[CellGroupData[{
Cell[168386, 5942, 213, 7, 70, "Input",
 CellID->301050383],
Cell[168602, 5951, 643, 21, 50, "Output",
 CellID->779175273]
}, Open  ]],
Cell[169260, 5975, 236, 8, 70, "ExampleText",
 CellID->184751878],
Cell[CellGroupData[{
Cell[169521, 5987, 215, 8, 70, "Input",
 CellID->143189750],
Cell[169739, 5997, 453, 8, 70, "Message",
 CellID->392997703],
Cell[170195, 6007, 305, 10, 36, "Output",
 CellID->227920184]
}, Open  ]],
Cell[170515, 6020, 134, 4, 70, "ExampleText",
 CellID->280901066],
Cell[CellGroupData[{
Cell[170674, 6028, 313, 11, 70, "Input",
 CellID->214332995],
Cell[170990, 6041, 223, 7, 36, "Output",
 CellID->794742715]
}, Open  ]],
Cell[171228, 6051, 258, 10, 70, "ExampleText",
 CellID->15786440],
Cell[CellGroupData[{
Cell[171511, 6065, 183, 6, 70, "Input",
 CellID->665377366],
Cell[171697, 6073, 1137, 34, 85, "Output",
 CellID->265730387]
}, Open  ]],
Cell[CellGroupData[{
Cell[172871, 6112, 539, 18, 70, "Input",
 CellID->174944066],
Cell[173413, 6132, 157, 5, 36, "Output",
 CellID->42321117]
}, Open  ]],
Cell[173585, 6140, 124, 3, 70, "ExampleDelimiter",
 CellID->62959905],
Cell[173712, 6145, 141, 4, 70, "ExampleText",
 CellID->210277461],
Cell[CellGroupData[{
Cell[173878, 6153, 339, 12, 70, "Input",
 CellID->7784294],
Cell[174220, 6167, 563, 19, 39, "Output",
 CellID->465812836]
}, Open  ]],
Cell[174798, 6189, 64, 1, 70, "ExampleText",
 CellID->2023680],
Cell[CellGroupData[{
Cell[174887, 6194, 759, 25, 70, "Input",
 CellID->146085101],
Cell[175649, 6221, 2465, 44, 70, "Output",
 Evaluatable->False,
 CellID->804210509]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178175, 6272, 310, 9, 70, "SeeAlsoSection",
 CellID->6726],
Cell[178488, 6283, 3160, 116, 70, "SeeAlso",
 CellID->32162]
}, Open  ]],
Cell[CellGroupData[{
Cell[181685, 6404, 314, 9, 70, "TutorialsSection",
 CellID->25187],
Cell[182002, 6415, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[182195, 6421, 148, 3, 70, "Tutorials",
 CellID->399875475],
Cell[182346, 6426, 154, 3, 70, "Tutorials",
 CellID->19906],
Cell[182503, 6431, 190, 4, 70, "Tutorials",
 CellID->13840],
Cell[182696, 6437, 156, 3, 70, "Tutorials",
 CellID->27215680],
Cell[182855, 6442, 191, 4, 70, "Tutorials",
 CellID->4500],
Cell[183049, 6448, 184, 3, 70, "Tutorials",
 CellID->30083252],
Cell[183236, 6453, 156, 3, 70, "Tutorials",
 CellID->309592249]
}, Open  ]],
Cell[CellGroupData[{
Cell[183429, 6461, 305, 8, 70, "RelatedLinksSection"],
Cell[183737, 6471, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184129, 6488, 319, 9, 70, "MoreAboutSection",
 CellID->686990946],
Cell[184451, 6499, 143, 3, 70, "MoreAbout",
 CellID->255611109],
Cell[184597, 6504, 147, 3, 70, "MoreAbout",
 CellID->338286075],
Cell[184747, 6509, 151, 3, 70, "MoreAbout",
 CellID->111040452],
Cell[184901, 6514, 146, 3, 70, "MoreAbout",
 CellID->67705861],
Cell[185050, 6519, 151, 3, 70, "MoreAbout",
 CellID->686042013]
}, Open  ]],
Cell[185216, 6525, 50, 0, 70, "History"],
Cell[185269, 6527, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

