(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59956,       2009]
NotebookOptionsPosition[     52188,       1743]
NotebookOutlinePosition[     53714,       1784]
CellTagsIndexPosition[     53628,       1779]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], 
          "Ordering" :> Documentation`HelpLookup["paclet:ref/Ordering"], 
          "OrderedQ" :> Documentation`HelpLookup["paclet:ref/OrderedQ"], 
          "Tally" :> Documentation`HelpLookup["paclet:ref/Tally"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sort\"\>", 2->"\<\"Ordering\"\>", 
       3->"\<\"OrderedQ\"\>", 4->"\<\"Tally\"\>", 
       5->"\<\"Nearest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Data\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>", 
       3->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SortBy", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SortBy",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SortBy"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sorts the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " in the order defined by applying ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to each of them. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SortBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SortBy"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["3", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " sorts the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " so that the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " lie in canonical order."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "If some of the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " are the same, then the canonical order of the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is used."
}], "Notes",
 CellID->344224632],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SortBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SortBy"]], "InlineFormula"],
 " uses the canonical ordering described in the notes for ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13994060],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SortBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SortBy"]], "InlineFormula"],
 " can be used on expressions with any head, not only ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17942]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175277275],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->76171510],

Cell["Sort a list of lists by the last element of each sublist:", \
"ExampleText",
 CellID->4349197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", " ", "Last"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42874859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599556303]
}, Open  ]],

Cell["Sort by the total of each sublist:", "ExampleText",
 CellID->719934251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", " ", "Total"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484254155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498295325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117667417],

Cell["Sort a list of integers by their values modulo 3:", "ExampleText",
 CellID->221704724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", " ", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"#", ",", "3"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6362840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "6", ",", "9", ",", "1", ",", "4", ",", "7", ",", "10", ",", "2", 
   ",", "5", ",", "8"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56133947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Sort by numerical value:", "ExampleText",
 CellID->405167351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E", ",", "Pi", ",", 
     RowBox[{"Sin", "[", "1", "]"}], ",", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], ",", "N"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21226456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "1", "]"}], ",", 
   SqrtBox["2"], ",", "\[ExponentialE]", ",", "\[Pi]"}], "}"}]], "Output",
 ImageSize->{133, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355676259]
}, Open  ]],

Cell["The default order ranks these symbolically:", "ExampleText",
 CellID->422801686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"E", ",", "Pi", ",", 
    RowBox[{"Sin", "[", "1", "]"}], ",", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282213711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", "\[ExponentialE]", ",", "\[Pi]", ",", 
   RowBox[{"Sin", "[", "1", "]"}]}], "}"}]], "Output",
 ImageSize->{133, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125413657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98139402],

Cell["Sort by absolute numerical value:", "ExampleText",
 CellID->161709253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", "10"}], "]"}]}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", "+", "I"}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"2", " ", "I"}], "-", "1"}], "]"}], ",", 
     RowBox[{"Exp", "[", "I", "]"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Abs", "[", "#", "]"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191187143],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]"}]}]], ",", "1.`", ",", 
   SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox["\[ExponentialE]", "10"]]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", "+", "\[ImaginaryI]"}]]}], "}"}]], "Output",
 ImageSize->{208, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858278301]
}, Open  ]],

Cell["Slightly faster way:", "ExampleText",
 CellID->97954097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", "10"}], "]"}]}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", "+", "I"}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"2", " ", "I"}], "-", "1"}], "]"}], ",", 
     RowBox[{"Exp", "[", "I", "]"}]}], "}"}], ",", "RealExponent"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79745309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]"}]}]], ",", "1.`", ",", 
   SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox["\[ExponentialE]", "10"]]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", "+", "\[ImaginaryI]"}]]}], "}"}]], "Output",
 ImageSize->{208, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69721544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10720776],

Cell[TextData[{
 "Sort by ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->4849738],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ",", 
       RowBox[{"1", "+", "\[ImaginaryI]"}]}], "}"}], ",", "20"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19158653],

Cell[BoxData[
 RowBox[{
  RowBox[{"listOrderPlot", "[", "data_", "]"}], ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"Arrow", ",", 
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "#", "]"}], ",", 
             RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], ",", "data"}], 
         "]"}], ",", "2", ",", "1"}], "]"}]}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->637073295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"listOrderPlot", "@", 
    RowBox[{"SortBy", "[", 
     RowBox[{"data", ",", "f"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im", ",", "Arg", ",", "Abs"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->332949089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     ArrowBox[{{-0.8438851942154071, 
      0.19951852092591205`}, {-0.8056484885224844, -0.6329922580436351}}], 
     ArrowBox[{{-0.8056484885224844, -0.6329922580436351}, \
{-0.5940549340392325, -0.8210517212288764}}], 
     ArrowBox[{{-0.5940549340392325, -0.8210517212288764}, \
{-0.5143371602149513, -0.31991566477104216`}}], 
     ArrowBox[{{-0.5143371602149513, -0.31991566477104216`}, \
{-0.48208881657228275`, 0.9975160593238157}}], 
     ArrowBox[{{-0.48208881657228275`, 
      0.9975160593238157}, {-0.47261230353298833`, -0.5309649522803013}}], 
     ArrowBox[{{-0.47261230353298833`, -0.5309649522803013}, \
{-0.34488363490847807`, -0.5404430777634017}}], 
     ArrowBox[{{-0.34488363490847807`, -0.5404430777634017}, \
{-0.31554178039409075`, 0.7829690622963636}}], 
     ArrowBox[{{-0.31554178039409075`, 
      0.7829690622963636}, {-0.27542257505686596`, 0.11441098063437227`}}], 
     ArrowBox[{{-0.27542257505686596`, 
      0.11441098063437227`}, {-0.2596655730980153, 0.27370500061659975`}}], 
     ArrowBox[{{-0.2596655730980153, 
      0.27370500061659975`}, {-0.05371840913631276, -0.5273375768846478}}], 
     ArrowBox[{{-0.05371840913631276, -0.5273375768846478}, \
{-0.050128848611676435`, 0.7345038911231128}}], 
     ArrowBox[{{-0.050128848611676435`, 
      0.7345038911231128}, {-0.01829394797146655, -0.39310120840657214`}}], 
     ArrowBox[{{-0.01829394797146655, -0.39310120840657214`}, \
{-0.017108849286537886`, -0.468884292789427}}], 
     ArrowBox[{{-0.017108849286537886`, -0.468884292789427}, {
      0.11247264383672828`, 0.8043147740554897}}], 
     ArrowBox[{{0.11247264383672828`, 0.8043147740554897}, {
      0.12966213470654298`, 0.40198935831062377`}}], 
     ArrowBox[{{0.12966213470654298`, 0.40198935831062377`}, {
      0.2131929613126018, -0.9140856188396502}}], 
     ArrowBox[{{0.2131929613126018, -0.9140856188396502}, {0.4548004477519676,
       0.351100161762937}}], 
     ArrowBox[{{0.4548004477519676, 0.351100161762937}, {0.6025902909667669, 
      0.795824346370197}}], 
     ArrowBox[{{0.6025902909667669, 0.795824346370197}, {0.6284586615261936, 
      0.13573237623449597`}}]},
    Frame->True,
    PlotRange->1], ",", 
   GraphicsBox[{
     ArrowBox[{{
      0.2131929613126018, -0.9140856188396502}, {-0.5940549340392325, \
-0.8210517212288764}}], 
     ArrowBox[{{-0.5940549340392325, -0.8210517212288764}, \
{-0.8056484885224844, -0.6329922580436351}}], 
     ArrowBox[{{-0.8056484885224844, -0.6329922580436351}, \
{-0.34488363490847807`, -0.5404430777634017}}], 
     ArrowBox[{{-0.34488363490847807`, -0.5404430777634017}, \
{-0.47261230353298833`, -0.5309649522803013}}], 
     ArrowBox[{{-0.47261230353298833`, -0.5309649522803013}, \
{-0.05371840913631276, -0.5273375768846478}}], 
     ArrowBox[{{-0.05371840913631276, -0.5273375768846478}, \
{-0.017108849286537886`, -0.468884292789427}}], 
     ArrowBox[{{-0.017108849286537886`, -0.468884292789427}, \
{-0.01829394797146655, -0.39310120840657214`}}], 
     ArrowBox[{{-0.01829394797146655, -0.39310120840657214`}, \
{-0.5143371602149513, -0.31991566477104216`}}], 
     ArrowBox[{{-0.5143371602149513, -0.31991566477104216`}, \
{-0.27542257505686596`, 0.11441098063437227`}}], 
     ArrowBox[{{-0.27542257505686596`, 0.11441098063437227`}, {
      0.6284586615261936, 0.13573237623449597`}}], 
     ArrowBox[{{0.6284586615261936, 
      0.13573237623449597`}, {-0.8438851942154071, 0.19951852092591205`}}], 
     ArrowBox[{{-0.8438851942154071, 
      0.19951852092591205`}, {-0.2596655730980153, 0.27370500061659975`}}], 
     ArrowBox[{{-0.2596655730980153, 0.27370500061659975`}, {
      0.4548004477519676, 0.351100161762937}}], 
     ArrowBox[{{0.4548004477519676, 0.351100161762937}, {0.12966213470654298`,
       0.40198935831062377`}}], 
     ArrowBox[{{0.12966213470654298`, 
      0.40198935831062377`}, {-0.050128848611676435`, 0.7345038911231128}}], 
     ArrowBox[{{-0.050128848611676435`, 
      0.7345038911231128}, {-0.31554178039409075`, 0.7829690622963636}}], 
     ArrowBox[{{-0.31554178039409075`, 0.7829690622963636}, {
      0.6025902909667669, 0.795824346370197}}], 
     ArrowBox[{{0.6025902909667669, 0.795824346370197}, {0.11247264383672828`,
       0.8043147740554897}}], 
     ArrowBox[{{0.11247264383672828`, 
      0.8043147740554897}, {-0.48208881657228275`, 0.9975160593238157}}]},
    Frame->True,
    PlotRange->1], ",", 
   GraphicsBox[{
     ArrowBox[{{-0.5143371602149513, -0.31991566477104216`}, \
{-0.8056484885224844, -0.6329922580436351}}], 
     ArrowBox[{{-0.8056484885224844, -0.6329922580436351}, \
{-0.47261230353298833`, -0.5309649522803013}}], 
     ArrowBox[{{-0.47261230353298833`, -0.5309649522803013}, \
{-0.5940549340392325, -0.8210517212288764}}], 
     ArrowBox[{{-0.5940549340392325, -0.8210517212288764}, \
{-0.34488363490847807`, -0.5404430777634017}}], 
     ArrowBox[{{-0.34488363490847807`, -0.5404430777634017}, \
{-0.05371840913631276, -0.5273375768846478}}], 
     ArrowBox[{{-0.05371840913631276, -0.5273375768846478}, \
{-0.01829394797146655, -0.39310120840657214`}}], 
     ArrowBox[{{-0.01829394797146655, -0.39310120840657214`}, \
{-0.017108849286537886`, -0.468884292789427}}], 
     ArrowBox[{{-0.017108849286537886`, -0.468884292789427}, {
      0.2131929613126018, -0.9140856188396502}}], 
     ArrowBox[{{0.2131929613126018, -0.9140856188396502}, {0.6284586615261936,
       0.13573237623449597`}}], 
     ArrowBox[{{0.6284586615261936, 0.13573237623449597`}, {
      0.4548004477519676, 0.351100161762937}}], 
     ArrowBox[{{0.4548004477519676, 0.351100161762937}, {0.6025902909667669, 
      0.795824346370197}}], 
     ArrowBox[{{0.6025902909667669, 0.795824346370197}, {0.12966213470654298`,
       0.40198935831062377`}}], 
     ArrowBox[{{0.12966213470654298`, 0.40198935831062377`}, {
      0.11247264383672828`, 0.8043147740554897}}], 
     ArrowBox[{{0.11247264383672828`, 
      0.8043147740554897}, {-0.050128848611676435`, 0.7345038911231128}}], 
     ArrowBox[{{-0.050128848611676435`, 
      0.7345038911231128}, {-0.31554178039409075`, 0.7829690622963636}}], 
     ArrowBox[{{-0.31554178039409075`, 
      0.7829690622963636}, {-0.48208881657228275`, 0.9975160593238157}}], 
     ArrowBox[{{-0.48208881657228275`, 
      0.9975160593238157}, {-0.2596655730980153, 0.27370500061659975`}}], 
     ArrowBox[{{-0.2596655730980153, 
      0.27370500061659975`}, {-0.27542257505686596`, 0.11441098063437227`}}], 
     ArrowBox[{{-0.27542257505686596`, 
      0.11441098063437227`}, {-0.8438851942154071, 0.19951852092591205`}}]},
    Frame->True,
    PlotRange->1], ",", 
   GraphicsBox[{
     ArrowBox[{{-0.27542257505686596`, 
      0.11441098063437227`}, {-0.2596655730980153, 0.27370500061659975`}}], 
     ArrowBox[{{-0.2596655730980153, 
      0.27370500061659975`}, {-0.01829394797146655, -0.39310120840657214`}}], 
     ArrowBox[{{-0.01829394797146655, -0.39310120840657214`}, {
      0.12966213470654298`, 0.40198935831062377`}}], 
     ArrowBox[{{0.12966213470654298`, 
      0.40198935831062377`}, {-0.017108849286537886`, -0.468884292789427}}], 
     ArrowBox[{{-0.017108849286537886`, -0.468884292789427}, \
{-0.05371840913631276, -0.5273375768846478}}], 
     ArrowBox[{{-0.05371840913631276, -0.5273375768846478}, {
      0.4548004477519676, 0.351100161762937}}], 
     ArrowBox[{{0.4548004477519676, 
      0.351100161762937}, {-0.5143371602149513, -0.31991566477104216`}}], 
     ArrowBox[{{-0.5143371602149513, -0.31991566477104216`}, \
{-0.34488363490847807`, -0.5404430777634017}}], 
     ArrowBox[{{-0.34488363490847807`, -0.5404430777634017}, {
      0.6284586615261936, 0.13573237623449597`}}], 
     ArrowBox[{{0.6284586615261936, 
      0.13573237623449597`}, {-0.47261230353298833`, -0.5309649522803013}}], 
     ArrowBox[{{-0.47261230353298833`, -0.5309649522803013}, \
{-0.050128848611676435`, 0.7345038911231128}}], 
     ArrowBox[{{-0.050128848611676435`, 0.7345038911231128}, {
      0.11247264383672828`, 0.8043147740554897}}], 
     ArrowBox[{{0.11247264383672828`, 
      0.8043147740554897}, {-0.31554178039409075`, 0.7829690622963636}}], 
     ArrowBox[{{-0.31554178039409075`, 
      0.7829690622963636}, {-0.8438851942154071, 0.19951852092591205`}}], 
     ArrowBox[{{-0.8438851942154071, 0.19951852092591205`}, {
      0.2131929613126018, -0.9140856188396502}}], 
     ArrowBox[{{0.2131929613126018, -0.9140856188396502}, {0.6025902909667669,
       0.795824346370197}}], 
     ArrowBox[{{0.6025902909667669, 
      0.795824346370197}, {-0.5940549340392325, -0.8210517212288764}}], 
     ArrowBox[{{-0.5940549340392325, -0.8210517212288764}, \
{-0.8056484885224844, -0.6329922580436351}}], 
     ArrowBox[{{-0.8056484885224844, -0.6329922580436351}, \
{-0.48208881657228275`, 0.9975160593238157}}]},
    Frame->True,
    PlotRange->1]}], "}"}]], "Output",
 ImageSize->{390, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->33838628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14458770],

Cell["Sort by date:", "ExampleText",
 CellID->3219160],

Cell[BoxData[
 RowBox[{
  RowBox[{"dates", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Mon 21 May 2007 08:20:36\>\"", ",", 
     "\"\<Sun 4 Mar 2007 04:42:29\>\"", ",", 
     "\"\<Thu 8 Mar 2007 18:21:40\>\"", ",", 
     "\"\<Thu 8 Mar 2007 18:08:36\>\"", ",", 
     "\"\<Sun 2 Jan 2005 07:50:25\>\"", ",", 
     "\"\<Wed 11 Mar 2009 08:10:14\>\"", ",", 
     "\"\<Thu 8 Mar 2007 22:02:12\>\"", ",", 
     "\"\<Thu 8 Mar 2007 18:07:24\>\"", ",", 
     "\"\<Thu 8 Mar 2007 18:08:43\>\"", ",", 
     "\"\<Fri 9 Mar 2007 08:54:39\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190396552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"SortBy", "[", 
   RowBox[{"dates", ",", "AbsoluteTime"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67458774],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"\<\"Sun 2 Jan 2005 07:50:25\"\>"},
     {"\<\"Sun 4 Mar 2007 04:42:29\"\>"},
     {"\<\"Thu 8 Mar 2007 18:07:24\"\>"},
     {"\<\"Thu 8 Mar 2007 18:08:36\"\>"},
     {"\<\"Thu 8 Mar 2007 18:08:43\"\>"},
     {"\<\"Thu 8 Mar 2007 18:21:40\"\>"},
     {"\<\"Thu 8 Mar 2007 22:02:12\"\>"},
     {"\<\"Fri 9 Mar 2007 08:54:39\"\>"},
     {"\<\"Mon 21 May 2007 08:20:36\"\>"},
     {"\<\"Wed 11 Mar 2009 08:10:14\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{172, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->5284687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SortBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SortBy"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->69665171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"h", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"h", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"h", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"h", "[", "1", "]"}]}], "]"}], ",", "Last"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15582019],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"h", "[", "1", "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"2", ",", "2"}], "]"}]}], "]"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614324017]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Show top ten countries according to different criteria: ", "ExampleText",
 CellID->707141533],

Cell[BoxData[
 RowBox[{
  RowBox[{"allcountries", " ", "=", " ", 
   RowBox[{"CountryData", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451821129],

Cell[BoxData[
 RowBox[{
  RowBox[{"topten", "[", 
   RowBox[{"crit_", ",", " ", 
    RowBox[{"lors_:", "\"\<Largest\>\""}]}], "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "data", "}"}], ",", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"SortBy", "[", 
       RowBox[{
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"c", ",", 
              RowBox[{"CountryData", "[", 
               RowBox[{"c", ",", "crit"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"c", ",", "allcountries"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"_", ",", "_Missing"}], "}"}]}], "]"}], ",", "Last"}], 
       "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lors", "===", "\"\<Largest\>\""}], ",", 
       RowBox[{"Take", "[", 
        RowBox[{"data", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "10"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Take", "[", 
        RowBox[{"data", ",", "10"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->321650200],

Cell["\<\
Sort the first ten countries in alphabetical order by population:\
\>", "ExampleText",
 CellID->3481061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"topten", "[", "\"\<Population\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->101898053],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"China\"\>", "1.292985544`*^9"},
    {"\<\"India\"\>", "1.103370802`*^9"},
    {"\<\"UnitedStates\"\>", "2.98212895`*^8"},
    {"\<\"Indonesia\"\>", "2.22781487`*^8"},
    {"\<\"Brazil\"\>", "1.86404913`*^8"},
    {"\<\"Pakistan\"\>", "1.57935075`*^8"},
    {"\<\"Russia\"\>", "1.43201572`*^8"},
    {"\<\"Bangladesh\"\>", "1.41822276`*^8"},
    {"\<\"Nigeria\"\>", "1.31529669`*^8"},
    {"\<\"Japan\"\>", "1.28084652`*^8"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{176, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->322297351]
}, Open  ]],

Cell["Sort the first ten countries in alphabetical order by area:", \
"ExampleText",
 CellID->12650471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"topten", "[", 
   RowBox[{"\"\<Area\>\"", ",", "\"\<Smallest\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->919934649],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"VaticanCity\"\>", "0.44`"},
    {"\<\"Monaco\"\>", "1.95`"},
    {"\<\"Gibraltar\"\>", "6.5`"},
    {"\<\"Tokelau\"\>", "10.`"},
    {"\<\"CocosKeelingIslands\"\>", "14.`"},
    {"\<\"Nauru\"\>", "21.`"},
    {"\<\"Tuvalu\"\>", "26.`"},
    {"\<\"Macau\"\>", "28.2`"},
    {"\<\"NorfolkIsland\"\>", "34.6`"},
    {"\<\"PitcairnIslands\"\>", "47.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{173, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TableForm=",
 CellID->37850279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691291087],

Cell["\<\
Sort mathematically equivalent expressions by different criteria:\
\>", "ExampleText",
 CellID->473089273],

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ")"}]}], " ", "+", " ", 
    
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], ")"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ops", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "Identity", ",", " ", "Together", ",", " ", "TrigReduce", ",", " ", 
     "TrigExpand", ",", " ", "Simplify", ",", " ", "FullSimplify"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"exprs", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"op", "[", "e", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"op", ",", "ops"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->262851801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"ops", ",", "exprs"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->242487414],

Cell[BoxData[
 TagBox[GridBox[{
    {"Identity", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "+", 
      FractionBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]]}]},
    {"Together", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]]},
    {"TrigReduce", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"Csc", "[", "x", "]"}], " ", 
         RowBox[{"Sec", "[", "x", "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"Sec", "[", "x", "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "x"}], "]"}], " ", 
         RowBox[{"Csc", "[", "x", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
        RowBox[{
         RowBox[{"Csc", "[", "x", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}]}], ")"}]}]},
    {"TrigExpand", 
     RowBox[{
      FractionBox["3", "2"], "+", 
      FractionBox[
       RowBox[{"Cot", "[", "x", "]"}], "2"], "+", 
      RowBox[{
       FractionBox["3", "2"], " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       RowBox[{"Sec", "[", "x", "]"}]}], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"], "2"], "-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}], "2"], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"], "2"]}]},
    {"Simplify", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Csc", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", " ", "x"}], "]"}], "-", 
        RowBox[{"Sin", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}], ")"}]}]},
    {"FullSimplify", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cot", "[", "x", "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{601, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->253699399]
}, Open  ]],

Cell[TextData[{
 "Sort by ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->89050112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{"exprs", ",", "LeafCount"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->130445232],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cot", "[", "x", "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Csc", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "x"}], "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}]]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       RowBox[{"Sec", "[", "x", "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "x"}], "]"}], " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "x"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["3", "2"], "+", 
    FractionBox[
     RowBox[{"Cot", "[", "x", "]"}], "2"], "+", 
    RowBox[{
     FractionBox["3", "2"], " ", 
     RowBox[{"Csc", "[", "x", "]"}], " ", 
     RowBox[{"Sec", "[", "x", "]"}]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"], "2"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], "2"], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "2"], "2"]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]]}], "}"}]], "Output",
 ImageSize->{544, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->594075497]
}, Open  ]],

Cell[TextData[{
 "Sort by size of error for numerical evaluation with machine numbers at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->971513878],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hp", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"e", " ", "/.", " ", 
      RowBox[{"x", "\[Rule]", "1"}]}], ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", "e_", "]"}], ":=", 
   RowBox[{"Abs", "[", 
    RowBox[{"hp", "-", 
     RowBox[{"N", "[", 
      RowBox[{"e", "/.", 
       RowBox[{"x", "\[Rule]", "1."}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->373107464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{"exprs", ",", " ", "err"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->766914229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["3", "2"], "+", 
    FractionBox[
     RowBox[{"Cot", "[", "x", "]"}], "2"], "+", 
    RowBox[{
     FractionBox["3", "2"], " ", 
     RowBox[{"Csc", "[", "x", "]"}], " ", 
     RowBox[{"Sec", "[", "x", "]"}]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"], "2"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], "2"], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "2"], "2"]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       RowBox[{"Sec", "[", "x", "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "x"}], "]"}], " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "x"}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Csc", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "x"}], "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cot", "[", "x", "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], "}"}]], "Output",
 ImageSize->{536, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->453902969]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SortBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SortBy"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sort",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sort"], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@",
      
     StyleBox["e", "TI"]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->115811300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231045238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675407333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{"e", ",", "Last"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->537736552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->212283087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Last", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", "e"}],
    "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14719972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->165787815]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->310878622],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->221981993],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->351052661]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SortBy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 36.2308622}", "context" -> "System`", 
    "keywords" -> {
     "arrange", "ascending order", "cardinal sort", "collation", 
      "decreasing order", "descending order", "grade", "increasing order", 
      "largest", "lists ordering", "ranking", "sorting", "sorting of lists", 
      "sorting of strings", "string order", "sorting by date", 
      "sorting by size", "sorting by criteria"}, "index" -> True, "label" -> 
    "Mathematica Symbol", "language" -> "en", "paclet" -> "", "status" -> 
    "None", "summary" -> 
    "SortBy[list, f] sorts the elements of list in the order defined by \
applying f to each of them. ", "synonyms" -> {}, "title" -> "SortBy", "type" -> 
    "Symbol", "uri" -> "ref/SortBy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5786, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->175277275]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53485, 1772}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1876, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2499, 69, 49, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2551, 72, 725, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3313, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3791, 117, 879, 34, 70, "Notes",
 CellID->1067943069],
Cell[4673, 153, 398, 15, 70, "Notes",
 CellID->344224632],
Cell[5074, 170, 339, 12, 70, "Notes",
 CellID->13994060],
Cell[5416, 184, 333, 12, 70, "Notes",
 CellID->17942]
}, Closed]],
Cell[CellGroupData[{
Cell[5786, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175277275],
Cell[CellGroupData[{
Cell[6171, 215, 147, 5, 70, "ExampleSection",
 CellID->76171510],
Cell[6321, 222, 100, 2, 70, "ExampleText",
 CellID->4349197],
Cell[CellGroupData[{
Cell[6446, 228, 451, 15, 28, "Input",
 CellID->42874859],
Cell[6900, 245, 450, 15, 36, "Output",
 CellID->599556303]
}, Open  ]],
Cell[7365, 263, 77, 1, 70, "ExampleText",
 CellID->719934251],
Cell[CellGroupData[{
Cell[7467, 268, 453, 15, 28, "Input",
 CellID->484254155],
Cell[7923, 285, 450, 15, 36, "Output",
 CellID->498295325]
}, Open  ]],
Cell[8388, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->117667417],
Cell[8516, 308, 92, 1, 70, "ExampleText",
 CellID->221704724],
Cell[CellGroupData[{
Cell[8633, 313, 239, 8, 70, "Input",
 CellID->6362840],
Cell[8875, 323, 291, 9, 36, "Output",
 CellID->56133947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9215, 338, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9439, 347, 67, 1, 70, "ExampleText",
 CellID->405167351],
Cell[CellGroupData[{
Cell[9531, 352, 261, 8, 70, "Input",
 CellID->21226456],
Cell[9795, 362, 286, 9, 43, "Output",
 CellID->355676259]
}, Open  ]],
Cell[10096, 374, 86, 1, 70, "ExampleText",
 CellID->422801686],
Cell[CellGroupData[{
Cell[10207, 379, 233, 7, 70, "Input",
 CellID->282213711],
Cell[10443, 388, 286, 9, 43, "Output",
 CellID->125413657]
}, Open  ]],
Cell[10744, 400, 124, 3, 70, "ExampleDelimiter",
 CellID->98139402],
Cell[10871, 405, 76, 1, 70, "ExampleText",
 CellID->161709253],
Cell[CellGroupData[{
Cell[10972, 410, 589, 19, 70, "Input",
 CellID->191187143],
Cell[11564, 431, 591, 18, 60, "Output",
 CellID->858278301]
}, Open  ]],
Cell[12170, 452, 62, 1, 70, "ExampleText",
 CellID->97954097],
Cell[CellGroupData[{
Cell[12257, 457, 520, 17, 70, "Input",
 CellID->79745309],
Cell[12780, 476, 590, 18, 60, "Output",
 CellID->69721544]
}, Open  ]],
Cell[13385, 497, 124, 3, 70, "ExampleDelimiter",
 CellID->10720776],
Cell[13512, 502, 527, 23, 70, "ExampleText",
 CellID->4849738],
Cell[14042, 527, 339, 12, 70, "Input",
 CellID->19158653],
Cell[14384, 541, 673, 20, 70, "Input",
 CellID->637073295],
Cell[CellGroupData[{
Cell[15082, 565, 355, 12, 70, "Input",
 CellID->332949089],
Cell[15440, 579, 8995, 172, 381, "Output",
 CellID->33838628]
}, Open  ]],
Cell[24450, 754, 124, 3, 70, "ExampleDelimiter",
 CellID->14458770],
Cell[24577, 759, 54, 1, 70, "ExampleText",
 CellID->3219160],
Cell[24634, 762, 604, 16, 70, "Input",
 CellID->190396552],
Cell[CellGroupData[{
Cell[25263, 782, 176, 5, 70, "Input",
 CellID->67458774],
Cell[25442, 789, 1098, 31, 182, "Output",
 CellID->5284687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26589, 826, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[26836, 835, 214, 7, 70, "ExampleText",
 CellID->69665171],
Cell[CellGroupData[{
Cell[27075, 846, 406, 13, 70, "Input",
 CellID->15582019],
Cell[27484, 861, 420, 14, 36, "Output",
 CellID->614324017]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27953, 881, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[28183, 890, 99, 1, 70, "ExampleText",
 CellID->707141533],
Cell[28285, 893, 165, 5, 70, "Input",
 CellID->451821129],
Cell[28453, 900, 1274, 38, 70, "Input",
 CellID->321650200],
Cell[29730, 940, 114, 3, 70, "ExampleText",
 CellID->3481061],
Cell[CellGroupData[{
Cell[29869, 947, 155, 4, 70, "Input",
 CellID->101898053],
Cell[30027, 953, 1064, 29, 212, "Output",
 CellID->322297351]
}, Open  ]],
Cell[31106, 985, 103, 2, 70, "ExampleText",
 CellID->12650471],
Cell[CellGroupData[{
Cell[31234, 991, 188, 5, 70, "Input",
 CellID->919934649],
Cell[31425, 998, 988, 29, 182, "Output",
 CellID->37850279]
}, Open  ]],
Cell[32428, 1030, 125, 3, 70, "ExampleDelimiter",
 CellID->691291087],
Cell[32556, 1035, 116, 3, 70, "ExampleText",
 CellID->473089273],
Cell[32675, 1040, 1020, 35, 70, "Input",
 CellID->262851801],
Cell[CellGroupData[{
Cell[33720, 1079, 196, 6, 70, "Input",
 CellID->242487414],
Cell[33919, 1087, 3942, 122, 190, "Output",
 CellID->253699399]
}, Open  ]],
Cell[37876, 1212, 192, 8, 70, "ExampleText",
 CellID->89050112],
Cell[CellGroupData[{
Cell[38093, 1224, 137, 4, 70, "Input",
 CellID->130445232],
Cell[38233, 1230, 3218, 104, 178, "Output",
 CellID->594075497]
}, Open  ]],
Cell[41466, 1337, 223, 7, 70, "ExampleText",
 CellID->971513878],
Cell[41692, 1346, 484, 16, 70, "Input",
 CellID->373107464],
Cell[CellGroupData[{
Cell[42201, 1366, 136, 4, 70, "Input",
 CellID->766914229],
Cell[42340, 1372, 3218, 104, 153, "Output",
 CellID->453902969]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45607, 1482, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[45848, 1491, 809, 32, 70, "ExampleText",
 CellID->115811300],
Cell[CellGroupData[{
Cell[46682, 1527, 218, 7, 70, "Input",
 CellID->231045238],
Cell[46903, 1536, 774, 27, 36, "Output",
 CellID->675407333]
}, Open  ]],
Cell[CellGroupData[{
Cell[47714, 1568, 128, 4, 70, "Input",
 CellID->537736552],
Cell[47845, 1574, 774, 27, 36, "Output",
 CellID->212283087]
}, Open  ]],
Cell[CellGroupData[{
Cell[48656, 1606, 334, 13, 70, "Input",
 CellID->14719972],
Cell[48993, 1621, 774, 27, 36, "Output",
 CellID->165787815]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49828, 1655, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[50147, 1666, 1174, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[51358, 1715, 299, 8, 70, "MoreAboutSection"],
Cell[51660, 1725, 139, 3, 70, "MoreAbout",
 CellID->310878622],
Cell[51802, 1730, 177, 3, 70, "MoreAbout",
 CellID->221981993],
Cell[51982, 1735, 164, 3, 70, "MoreAbout",
 CellID->351052661]
}, Open  ]],
Cell[52161, 1741, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

