(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35344,       1232]
NotebookOptionsPosition[     29801,       1044]
NotebookOutlinePosition[     31046,       1080]
CellTagsIndexPosition[     30960,       1075]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dividers" :> Documentation`HelpLookup["paclet:ref/Dividers"], 
          "ItemSize" :> Documentation`HelpLookup["paclet:ref/ItemSize"], 
          "FrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/FrameMargins"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dividers\"\>", 
       2->"\<\"ItemSize\"\>", 3->"\<\"FrameMargins\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Grids & Tables\"\>", 
       2->"\<\"Layout & Tables\"\>", 3->"\<\"Palettes\"\>", 
       4->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Spacings", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Spacings",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " and related constructs which specifies the spacings to leave between \
successive objects."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", settings for ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " are in units of the current font size. "
}], "Notes",
 CellID->127629085],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 ", settings are in printer's points. "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "A setting of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " gives spacing that is a fraction ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " of the size of an item."
}], "Notes",
 CellID->291295856],

Cell[TextData[{
 "A setting of the form ",
 Cell[BoxData[
  RowBox[{"Spacings", "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " specifies that the absolute space between items should be ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ", independent of the presence of frames or dividers. A setting of the form \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 " inserts space ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " beyond space taken by frames or dividers."
}], "Notes",
 CellID->102254104],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs can be given as:"
}], "Notes",
 CellID->46514975],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at successive ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " positions"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3275027],

Cell[TextData[{
 "For a grid with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " items in a particular direction, ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for spacings in the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "+", "1"}]], "InlineFormula"],
 " gaps between items, starting before the first item, and ending after the \
last item."
}], "Notes",
 CellID->49335815],

Cell["\<\
The outer edge of the grid is taken to be at the midpoint of the outermost \
spacing on every side.\
\>", "Notes",
 CellID->553461841],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in each direction can have the following forms:"
}], "Notes",
 CellID->247188],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     StyleBox["c", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], "1"]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], "2"], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "1"], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "1"]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "2"], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "2"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, False, True, True, True, 
      True}}}},
 CellID->16534]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246623239],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->550257277],

Cell["Set the horizontal spacing between items:", "ExampleText",
 CellID->2609790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57263510],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x"},
    {"x", "x", "x"},
    {"x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 ImageSize->{99, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630804636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91349375],

Cell["Set the horizontal and vertical spacings:", "ExampleText",
 CellID->1695160959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427974663],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x"},
    {"x", "x", "x"},
    {"x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{99, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1954235660]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Insert no additional space between columns:", "ExampleText",
 CellID->1284553133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1403149669],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAKxpQQDkP0fyAJj
w///gTQyyQQUZgKyQDQDM1gIDOgpxggRYoVQ/8EArpQFWYh2IkyQ0IC6iJVE
mpkKugeF/wdNasBMqcSQg8f9gyI2R1PzIEkNo6l5NDWPpubB4v5BEZujqXmQ
pAbMlMrACABlY5dj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80414530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "0"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10671330],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{55, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1560909408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142253632],

Cell["Insert no additional space between rows or columns:", "ExampleText",
 CellID->831403040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1079027757],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAKxtgQDkP0fyAJj
w///gTQmyQSUZAKyQDQDM1gIDOgpxggRYoVQ/8EArpQFWYh2IkyQ0IC6iJVE
mpkKugeF/wdNahhNr0TF12h6HSSpYTS9EhVfo+l1kKSG0fRKVHyNptdBkhow
UyoDIwBiCmrR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102471217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1849272558],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " to indicate spacings in addition to the thickness of any frames or \
dividers:"
}], "ExampleText",
 CellID->193059275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Offset", "[", "1", "]"}], ",", 
      RowBox[{"Offset", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "4", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2046927955],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcEKwjAMzebWqSfRi8d9jZ78iDKEDRFl7of2pTWruQwURCr00QzSJM0e
6wh579CTHdrz1Q5dY+tjb+9t1zzqw63nrUVGRCPbZU8cO468jc6xl5WI3q0F
25bfmPzuS78Rr+jf0QVnOftc/FKqZST75ey0U+YD5x8OVlI3EVbM7OxG/mgt
u9Wf8iqCryL3CWsicJknRbSqn6LDoLFYClkPVLcx+oQ1EbjMkyJadVvRYdBY
LIWsB6rbGH3Cmghc5kkRrbqt6DBoLJZC1gPVbYw+YU0ELvNgoj8p7+sWmLIn
a3okdg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->604502448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "4", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1647315453],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcsOgjAQXKA8TurRI1+jJ7/BNIQEDkaD/ARfXZeyHkwwMRBjxyxJu9su
E9psZubAyfZNfbF9W9ny2Nlb01b38nDteCuJiGjgcd4T544zPwbnOMpMRHOz
4bHjN8a4/TBuJCp6OdrwKuYYS8ykmgSyn76cdlz5xPmHk1zqJsDK807T2TO5
USG76ZfWeQBfRe4TFiNwledXaHWgf0JjsRVZF9W/MPqExQhc5VH/UvR6NBZb
kXVR/QujT1iMwFUe9S9Fr0djsRVZF9W/MPqExQhc5cFEv3O/6e8YRQ8t+BjL
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342361873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2005621667],

Cell["Insert additional space at the second horizontal divider:", \
"ExampleText",
 CellID->1580033957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "3"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1995420144],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw1AKxpQQDkP0fyALj
2v//gTQyyQQUZgKyQLQqlIbxOanMZwTbyMAKof6DAZDBoA6iWZCFuGkmwgTx
NdRFmlCal0iamQq6B4X/6R7rmCmPGHI0dY6mztHUOZo6R1PnaOocTZ1DJXUy
MAIA1Cmomw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426225482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->813337823],

Cell["Set the size of the grid's margins:", "ExampleText",
 CellID->1035378006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", "}"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"{", "}"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538155201],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {5, {}, 5}, "Rows" -> {5, {}, 5}}],
  "Grid"]], "Output",
 ImageSize->{169, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323893169]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dividers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dividers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->1906352],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->13153257],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->702862639],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->395636897]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spacings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 59.5127082}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Spacings is an option to Grid and related constructs which specifies the \
spacings to leave between successive objects.", "synonyms" -> {}, "title" -> 
    "Spacings", "type" -> "Symbol", "uri" -> "ref/Spacings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16830, 557, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->246623239]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30816, 1068}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2557, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3180, 87, 1573, 37, 70, "ObjectNameGrid"],
Cell[4756, 126, 630, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5423, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5901, 167, 592, 23, 70, "Notes",
 CellID->127629085],
Cell[6496, 192, 498, 18, 70, "Notes",
 CellID->1067943069],
Cell[6997, 212, 365, 13, 70, "Notes",
 CellID->291295856],
Cell[7365, 227, 656, 21, 70, "Notes",
 CellID->102254104],
Cell[8024, 250, 348, 13, 70, "Notes",
 CellID->46514975],
Cell[8375, 265, 984, 32, 70, "2ColumnTableMod",
 CellID->3275027],
Cell[9362, 299, 501, 16, 70, "Notes",
 CellID->49335815],
Cell[9866, 317, 144, 4, 70, "Notes",
 CellID->553461841],
Cell[10013, 323, 209, 8, 70, "Notes",
 CellID->247188],
Cell[10225, 333, 6568, 219, 70, "2ColumnTableMod",
 CellID->16534]
}, Closed]],
Cell[CellGroupData[{
Cell[16830, 557, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246623239],
Cell[CellGroupData[{
Cell[17215, 571, 148, 5, 70, "ExampleSection",
 CellID->550257277],
Cell[17366, 578, 82, 1, 70, "ExampleText",
 CellID->2609790],
Cell[CellGroupData[{
Cell[17473, 583, 325, 10, 28, "Input",
 CellID->57263510],
Cell[17801, 595, 356, 13, 72, "Output",
 CellID->630804636]
}, Open  ]],
Cell[18172, 611, 124, 3, 70, "ExampleDelimiter",
 CellID->91349375],
Cell[18299, 616, 85, 1, 70, "ExampleText",
 CellID->1695160959],
Cell[CellGroupData[{
Cell[18409, 621, 377, 12, 70, "Input",
 CellID->427974663],
Cell[18789, 635, 374, 13, 56, "Output",
 CellID->1954235660]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19212, 654, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[19436, 663, 87, 1, 70, "ExampleText",
 CellID->1284553133],
Cell[CellGroupData[{
Cell[19548, 668, 281, 9, 70, "Input",
 CellID->1403149669],
Cell[19832, 679, 409, 11, 70, "Output",
 Evaluatable->False,
 CellID->80414530]
}, Open  ]],
Cell[CellGroupData[{
Cell[20278, 695, 325, 10, 70, "Input",
 CellID->10671330],
Cell[20606, 707, 458, 14, 88, "Output",
 CellID->1560909408]
}, Open  ]],
Cell[21079, 724, 125, 3, 70, "ExampleDelimiter",
 CellID->142253632],
Cell[21207, 729, 94, 1, 70, "ExampleText",
 CellID->831403040],
Cell[CellGroupData[{
Cell[21326, 734, 332, 11, 70, "Input",
 CellID->1079027757],
Cell[21661, 747, 406, 11, 70, "Output",
 Evaluatable->False,
 CellID->102471217]
}, Open  ]],
Cell[22082, 761, 126, 3, 70, "ExampleDelimiter",
 CellID->1849272558],
Cell[22211, 766, 261, 9, 70, "ExampleText",
 CellID->193059275],
Cell[CellGroupData[{
Cell[22497, 779, 539, 16, 70, "Input",
 CellID->2046927955],
Cell[23039, 797, 526, 13, 70, "Output",
 Evaluatable->False,
 CellID->604502448]
}, Open  ]],
Cell[CellGroupData[{
Cell[23602, 815, 465, 14, 70, "Input",
 CellID->1647315453],
Cell[24070, 831, 517, 13, 70, "Output",
 Evaluatable->False,
 CellID->342361873]
}, Open  ]],
Cell[24602, 847, 126, 3, 70, "ExampleDelimiter",
 CellID->2005621667],
Cell[24731, 852, 103, 2, 70, "ExampleText",
 CellID->1580033957],
Cell[CellGroupData[{
Cell[24859, 858, 376, 13, 70, "Input",
 CellID->1995420144],
Cell[25238, 873, 407, 11, 70, "Output",
 Evaluatable->False,
 CellID->426225482]
}, Open  ]],
Cell[25660, 887, 125, 3, 70, "ExampleDelimiter",
 CellID->813337823],
Cell[25788, 892, 79, 1, 70, "ExampleText",
 CellID->1035378006],
Cell[CellGroupData[{
Cell[25892, 897, 555, 18, 70, "Input",
 CellID->538155201],
Cell[26450, 917, 445, 13, 128, "Output",
 CellID->323893169]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26956, 937, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[27275, 948, 708, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28020, 979, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[28341, 990, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[28491, 995, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[28831, 1009, 299, 8, 70, "MoreAboutSection"],
Cell[29133, 1019, 138, 3, 70, "MoreAbout",
 CellID->1906352],
Cell[29274, 1024, 141, 3, 70, "MoreAbout",
 CellID->13153257],
Cell[29418, 1029, 128, 3, 70, "MoreAbout",
 CellID->702862639],
Cell[29549, 1034, 180, 3, 70, "MoreAbout",
 CellID->395636897]
}, Open  ]],
Cell[29744, 1040, 27, 0, 70, "History"],
Cell[29774, 1042, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

