(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6957,        230]
NotebookOptionsPosition[      5157,        175]
NotebookOutlinePosition[      6307,        206]
CellTagsIndexPosition[      6264,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Make Spanning" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/MakeSpanning"], 
         "Split Spanning" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/SplitSpanning"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Make Spanning\"\>", 
      2->"\<\"Split Spanning\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpanCharacterRounding", "ObjectName",
 CellID->19199],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->192405312],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpanCharacterRounding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanCharacterRounding"]], "InlineFormula"],
     "\[LineSeparator]is an option for selections that specifies the method \
used for rounding a spanning character when its size is to be adjusted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The size of any spanning character can only be varied in discrete steps \
determined by the size of the small elements it is built from. If you set the \
size of any spanning character to a value that would require a non-integer \
number of elements, then the actual size is determined by rounding off to the \
nearest integer number. ",
 Cell[BoxData[
  ButtonBox["SpanCharacterRounding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanCharacterRounding"]], "InlineFormula"],
 " determines the method used to perform this rounding. Possible settings are \
",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20710],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"SpanCharacterRounding", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", an appropriate rounding method is used for each spanning character. For \
example, radical signs are always rounded to the next highest value (that is, \
",
 Cell[BoxData[
  RowBox[{"SpanCharacterRounding", "->", 
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"]}]], "InlineFormula"],
 ") to ensure that they are always larger than the expression they wrap \
around."
}], "Notes",
 CellID->18271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3580],

Cell[TextData[{
 StyleBox[ButtonBox["Make Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeSpanning"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Split Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SplitSpanning"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->1331]
}, Open  ]],

Cell["New in 3.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpanCharacterRounding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 0.7783656}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpanCharacterRounding is an option for selections that specifies the \
method used for rounding a spanning character when its size is to be \
adjusted.", "synonyms" -> {"span character rounding"}, "title" -> 
    "SpanCharacterRounding", "type" -> "Symbol", "uri" -> 
    "ref/SpanCharacterRounding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 721, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1344, 44, 59, 1, 70, "ObjectName",
 CellID->19199],
Cell[1406, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->192405312],
Cell[1627, 55, 536, 14, 70, "Usage",
 CellID->12420]
}, Open  ]],
Cell[CellGroupData[{
Cell[2200, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2678, 91, 978, 28, 70, "Notes",
 CellID->20710],
Cell[3659, 121, 650, 18, 70, "Notes",
 CellID->18271]
}, Closed]],
Cell[CellGroupData[{
Cell[4346, 144, 310, 9, 70, "SeeAlsoSection",
 CellID->3580],
Cell[4659, 155, 424, 13, 70, "SeeAlso",
 CellID->1331]
}, Open  ]],
Cell[5098, 171, 29, 0, 70, "History"],
Cell[5130, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

