(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24884,        869]
NotebookOptionsPosition[     19793,        698]
NotebookOutlinePosition[     21288,        738]
CellTagsIndexPosition[     21203,        733]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpanFromLeft" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromLeft"], "SpanFromBoth" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromBoth"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpanFromLeft\"\>", 
       2->"\<\"SpanFromBoth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Grids & Tables\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpanFromAbove", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpanFromAbove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromAbove"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that can appear at a particular position \
in a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears above it."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10235]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SpanFromAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromAbove"]], "InlineFormula"],
 " appears at the same position in several successive rows, it indicates \
spanning across all these rows."
}], "Notes",
 CellID->19897]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->294441308],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->456412442],

Cell["Make the element 2 span the row below it:", "ExampleText",
 CellID->1979176505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1645311152],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2131219101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1941764778],

Cell["Make it span two rows:", "ExampleText",
 CellID->1592068765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "SpanFromAbove", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253491735],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "\[SpanFromAbove]", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1519682194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2079124034],

Cell[TextData[{
 "Spanning in a ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->288779941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "SpanFromAbove", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211426167],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr1uwjAQx23MxNfEwGfFjMSAxABbpnbqQ0SoEgxVK8pDIVa6R+IFeKT0
f0mJ4zQhBCIa0EWKdee739+OHVBOyau9Xry92+vl3B68rOzPxXL+NXj+WKFL
SSHEN50tAduF5Z9qt9s1m03LssSMGlWr1UajEZlTz4dTr9ePcYlccMpxHHiu
64oZNQoOusicer4Zl4QzxRRTTDGVG9Xxsuh/3DtEL0WljaaE9Kdc1LqR/G6s
alzWKVWaBaX3clGjKxZlnX9r3fi8PJTD65S2nrTn/X+/W5liiimmHoXabreV
SsUKKic46NKUGZewf8eaTCZoxYwa5TvGWKG4hH0fq8EUU0wxdR9U2vN+C005
eLrW3Omn6TTVdiguYtSzVBV6dlo/WsF1r9APz7MfGSd6nZ0LxwmvZlZ9lbgL
Saqt2FmlVcCX7bIe3+RKiWtR/N8MU0wxxVQhqeFw6AQ1le8YVCguYRO12Wwa
jYYV1G9w0KUpMy5h381qMMUUU0w9LHXu24/TlULWtz69SH6nwKrXVaq3edd3
3pUn1XPZ9rr49zRTTDHFVPGo/X5vfCNYrVbH4zGZ/jeCcNB1jB+/EYTA4XBw
gqoMKo53/PGnaCRyQckfHBcGwQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120876471]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12081],

Cell["Spanned elements inherit their styles:", "ExampleText",
 CellID->79646317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", "3"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "SpanFromAbove", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1445038790],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", 
     ItemBox["2",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "\[SpanFromAbove]", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334178274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "SpanFromAbove", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->733337738],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "\[SpanFromAbove]", "9"}
   },
   GridBoxBackground->{
    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}, 
     "ItemsIndexed" -> {{1, 2} -> RGBColor[1, 0, 0]}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->864514213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39584034],

Cell["Graphics will default to filling the available space:", "ExampleText",
 CellID->1716412515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "2"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467458428],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFhCQYg+z+QBcZb
/v8H0vjJeCDpD1TMRpDHDuVxjoqOio6KjoqOio6KDqBo3IDyBkMIjIqOio6K
joqOio480XiiecT0AiEkAyMAAqdg0A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260992614]
}, Open  ]],

Cell[TextData[{
 "An explicit ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " setting will prevent this behavior:"
}], "ExampleText",
 CellID->597309454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->851155348],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw3AdhCQYg+z+QBcb3
//8H0uSRZUAyHmgI1yhvlDeMeMpA0oABQo+KjoqOig4V0Z4hwhsMYTUqOio6
KooQHUwtkFHeKI82vPsUkwyMAAQ4xbY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{223, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27696931]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14300],

Cell["Spanning regions must be rectangular in shape:", "ExampleText",
 CellID->1808496775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2069241434],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1247627544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1211719407],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 " when spanning across both columns and rows:"
}], "ExampleText",
 CellID->1985128186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938198202],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->845802700]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16273],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromBoth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromBoth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31279],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->364672191],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->222127007]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpanFromAbove - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 1.5127594}", "context" -> "System`", 
    "keywords" -> {
     "span cells", "vertical span", "table span", "merge table cells", 
      "combine columns", "span from below", "span vertically"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SpanFromAbove is a symbol that can appear at a particular position in a \
Grid or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears above it.", 
    "synonyms" -> {"span from above"}, "title" -> "SpanFromAbove", "type" -> 
    "Symbol", "uri" -> "ref/SpanFromAbove"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5782, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->294441308]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21060, 726}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2023, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2646, 77, 1578, 37, 70, "ObjectNameGrid"],
Cell[4227, 116, 714, 20, 70, "Usage",
 CellID->10235]
}, Open  ]],
Cell[CellGroupData[{
Cell[4978, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5456, 158, 289, 9, 70, "Notes",
 CellID->19897]
}, Closed]],
Cell[CellGroupData[{
Cell[5782, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->294441308],
Cell[CellGroupData[{
Cell[6167, 186, 148, 5, 70, "ExampleSection",
 CellID->456412442],
Cell[6318, 193, 85, 1, 70, "ExampleText",
 CellID->1979176505],
Cell[CellGroupData[{
Cell[6428, 198, 420, 13, 28, "Input",
 CellID->1645311152],
Cell[6851, 213, 330, 12, 72, "Output",
 CellID->2131219101]
}, Open  ]],
Cell[7196, 228, 126, 3, 70, "ExampleDelimiter",
 CellID->1941764778],
Cell[7325, 233, 66, 1, 70, "ExampleText",
 CellID->1592068765],
Cell[CellGroupData[{
Cell[7416, 238, 431, 13, 70, "Input",
 CellID->253491735],
Cell[7850, 253, 345, 12, 72, "Output",
 CellID->1519682194]
}, Open  ]],
Cell[8210, 268, 126, 3, 70, "ExampleDelimiter",
 CellID->2079124034],
Cell[8339, 273, 205, 8, 70, "ExampleText",
 CellID->288779941],
Cell[CellGroupData[{
Cell[8569, 285, 439, 13, 28, "Input",
 CellID->211426167],
Cell[9011, 300, 851, 18, 201, "Output",
 Evaluatable->False,
 CellID->120876471]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9911, 324, 216, 7, 70, "ExampleSection",
 CellID->12081],
Cell[10130, 333, 80, 1, 70, "ExampleText",
 CellID->79646317],
Cell[CellGroupData[{
Cell[10235, 338, 550, 17, 70, "Input",
 CellID->1445038790],
Cell[10788, 357, 423, 15, 72, "Output",
 CellID->334178274]
}, Open  ]],
Cell[CellGroupData[{
Cell[11248, 377, 652, 20, 70, "Input",
 CellID->733337738],
Cell[11903, 399, 481, 15, 72, "Output",
 CellID->864514213]
}, Open  ]],
Cell[12399, 417, 124, 3, 70, "ExampleDelimiter",
 CellID->39584034],
Cell[12526, 422, 97, 1, 70, "ExampleText",
 CellID->1716412515],
Cell[CellGroupData[{
Cell[12648, 427, 571, 18, 70, "Input",
 CellID->467458428],
Cell[13222, 447, 367, 10, 70, "Output",
 Evaluatable->False,
 CellID->260992614]
}, Open  ]],
Cell[13604, 460, 232, 8, 70, "ExampleText",
 CellID->597309454],
Cell[CellGroupData[{
Cell[13861, 472, 963, 29, 70, "Input",
 CellID->851155348],
Cell[14827, 503, 366, 10, 70, "Output",
 Evaluatable->False,
 CellID->27696931]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15242, 519, 226, 7, 70, "ExampleSection",
 CellID->14300],
Cell[15471, 528, 90, 1, 70, "ExampleText",
 CellID->1808496775],
Cell[CellGroupData[{
Cell[15586, 533, 431, 13, 70, "Input",
 CellID->2069241434],
Cell[16020, 548, 344, 12, 70, "Output",
 CellID->1247627544]
}, Open  ]],
Cell[16379, 563, 126, 3, 70, "ExampleDelimiter",
 CellID->1211719407],
Cell[16508, 568, 239, 8, 70, "ExampleText",
 CellID->1985128186],
Cell[CellGroupData[{
Cell[16772, 580, 441, 13, 70, "Input",
 CellID->938198202],
Cell[17216, 595, 357, 12, 72, "Output",
 CellID->845802700]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17634, 614, 311, 9, 70, "SeeAlsoSection",
 CellID->16273],
Cell[17948, 625, 467, 17, 70, "SeeAlso",
 CellID->17037]
}, Open  ]],
Cell[CellGroupData[{
Cell[18452, 647, 314, 9, 70, "TutorialsSection",
 CellID->31279],
Cell[18769, 658, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[18919, 663, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[19259, 677, 319, 9, 70, "MoreAboutSection",
 CellID->364672191],
Cell[19581, 688, 140, 3, 70, "MoreAbout",
 CellID->222127007]
}, Open  ]],
Cell[19736, 694, 27, 0, 70, "History"],
Cell[19766, 696, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

