(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21157,        721]
NotebookOptionsPosition[     16763,        575]
NotebookOutlinePosition[     18264,        615]
CellTagsIndexPosition[     18179,        610]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpanFromLeft" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromLeft"], 
          "SpanFromAbove" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromAbove"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpanFromLeft\"\>", 
       2->"\<\"SpanFromAbove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Grids & Tables\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpanFromBoth", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpanFromBoth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that can appear at a particular position \
in a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears above and to its left."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["e", "TI"], ",", "SpanFromLeft", ",", "SpanFromLeft", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "SpanFromBoth", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "can be used to indicate that an element spans both multiple rows and \
multiple columns. "
}], "Notes",
 CellID->2543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610527943],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->171060275],

Cell["Span throughout a 2x2 block:", "ExampleText",
 CellID->210615047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839795991],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285481060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2117637710],

Cell["Set a red background throughout the spanned region:", "ExampleText",
 CellID->1062546877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Item", "[", 
        RowBox[{"1", ",", 
         RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", 
       "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->601763502],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["1",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "\[SpanFromLeft]", "3"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601708022]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10161],

Cell["Graphics will default to filling the available space:", "ExampleText",
 CellID->1716412515],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->992050930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->890510239],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr1qg1AYhs+JwcG/yaFjBifRQbCg4HCmdupFSCgkQ2hJvQ9vQ1ztLngD
XpL9jq0SW1vSNrQpfQUP38/7vDG46He8SbPN7S7Ntut0db1P7zfb9cPq6m5P
JYUzxh7lecEo7ih6PpWqqmzbFkKwWC6KYRi+78sw6nNKTNMc+py0xCl1XVPW
dR2L5aJQQiUZRn0+7XOJ/xq1oCWUJZksR5qOS6ouXnkcquEFL3jBC17wghe8
4AUveMELXvCC13te5zoRKMtS0zQxTjp0XQ+CQIyTDtd1VVUd+py0L78VhiGt
LJaL0jRN3R8s6vM8z8ll6HPSTq8wO+p/fE318X34nFpWd1RaggIFChQoUKBA
gQL1p6n5Z+kj1VEUzarpZWF85qdYqquq8jzvrbooCsuyxPBeQfEPXPdJ1ed/
j0GBAgUKFChQoED9T+p7E/JTzuYPVU3TTL6xdBwnSRIx7jwEQaDr+tAfvrEk
g7Zt65mdh7mdCE5aovgT18/0Ag==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233531046]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1281043476],

Cell["An explicit ImageSize setting will prevent this behavior:", \
"ExampleText",
 CellID->597309454],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1974139957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->747911149],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3EFqg0AYhuFfbTyDy5xBV8VCdi0u0pUbV0VCiQZKJQ24zMLLeKDcJ51x
BmohtkkpjcX3B4eZyTyfEpKNTrLMd8XzS74rV/n8YZtXRbl6m9+/btWU54g4
S30EovpHEXPoelSH6Q73Zrr1sizbdyWFatw0TTd64IVh2JsXb71et23bkZ5W
5+vrOI6N/jwv3mKxqOv6hO6u9iiFaly1cjMwfzMppWefxMzrVTM79r9ZRxpp
pJFGGmmkkUYaaaSRRhpppJFGGmmkkUYaaaSRRhpppJF2/bTxP5Mdq1Ilpg66
8RzHseOyGydJYrV78lyHi65smqvP+wyjUCgUCoVCoVCoIXVrV92h0Wg0Go1G
oyekv74POxm178r+Vi6KojRNu5d+oOM4rqrqAj3+d+cK6v9+o9BoNBqNRqPR
v6XHf08dhUKhUCgUCoUaixrPbu6/Xh0EgZgyO/R937djs0O/aRqrzQ593T3n
//s+euK8Awj3fxs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{333, 333},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67342356]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18877],

Cell[TextData[{
 "To span across both rows and columns requires appropriate use of ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1862285898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromAbove", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2012416308],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "2"},
    {"\[SpanFromAbove]", "\[SpanFromAbove]", "3"},
    {"4", "5", "6"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406232031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2099287209],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "2"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "3"},
    {"4", "5", "6"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->691231204]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10650],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromAbove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6717],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->233495246],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->306594215]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpanFromBoth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 4.5753378}", "context" -> "System`", 
    "keywords" -> {
     "span cells", "horizontal span", "table span", "merge table cells", 
      "combine rows", "span from left", "span from right"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpanFromBoth is a symbol that can appear at a particular position in a \
Grid or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears above and to its left.", 
    "synonyms" -> {"span from both"}, "title" -> "SpanFromBoth", "type" -> 
    "Symbol", "uri" -> "ref/SpanFromBoth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6066, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->610527943]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18036, 603}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2037, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2660, 78, 1577, 37, 70, "ObjectNameGrid"],
Cell[4240, 117, 725, 20, 70, "Usage",
 CellID->20583]
}, Open  ]],
Cell[CellGroupData[{
Cell[5002, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5480, 159, 549, 15, 70, "Notes",
 CellID->2543]
}, Closed]],
Cell[CellGroupData[{
Cell[6066, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610527943],
Cell[CellGroupData[{
Cell[6451, 193, 148, 5, 70, "ExampleSection",
 CellID->171060275],
Cell[6602, 200, 71, 1, 70, "ExampleText",
 CellID->210615047],
Cell[CellGroupData[{
Cell[6698, 205, 441, 13, 28, "Input",
 CellID->839795991],
Cell[7142, 220, 357, 12, 72, "Output",
 CellID->285481060]
}, Open  ]],
Cell[7514, 235, 126, 3, 70, "ExampleDelimiter",
 CellID->2117637710],
Cell[7643, 240, 95, 1, 70, "ExampleText",
 CellID->1062546877],
Cell[CellGroupData[{
Cell[7763, 245, 561, 17, 70, "Input",
 CellID->601763502],
Cell[8327, 264, 436, 15, 72, "Output",
 CellID->601708022]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8812, 285, 216, 7, 70, "ExampleSection",
 CellID->10161],
Cell[9031, 294, 97, 1, 70, "ExampleText",
 CellID->1716412515],
Cell[9131, 297, 255, 9, 70, "Input",
 CellID->992050930],
Cell[CellGroupData[{
Cell[9411, 310, 449, 13, 70, "Input",
 CellID->890510239],
Cell[9863, 325, 729, 16, 70, "Output",
 Evaluatable->False,
 CellID->233531046]
}, Open  ]],
Cell[10607, 344, 126, 3, 70, "ExampleDelimiter",
 CellID->1281043476],
Cell[10736, 349, 102, 2, 70, "ExampleText",
 CellID->597309454],
Cell[10841, 353, 305, 10, 70, "Input",
 CellID->1974139957],
Cell[CellGroupData[{
Cell[11171, 367, 449, 13, 70, "Input",
 CellID->747911149],
Cell[11623, 382, 716, 16, 70, "Output",
 Evaluatable->False,
 CellID->67342356]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12388, 404, 226, 7, 70, "ExampleSection",
 CellID->18877],
Cell[12617, 413, 257, 8, 70, "ExampleText",
 CellID->1862285898],
Cell[CellGroupData[{
Cell[12899, 425, 443, 13, 70, "Input",
 CellID->2012416308],
Cell[13345, 440, 358, 12, 70, "Output",
 CellID->406232031]
}, Open  ]],
Cell[CellGroupData[{
Cell[13740, 457, 442, 13, 70, "Input",
 CellID->2099287209],
Cell[14185, 472, 357, 12, 72, "Output",
 CellID->691231204]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14603, 491, 311, 9, 70, "SeeAlsoSection",
 CellID->10650],
Cell[14917, 502, 469, 17, 70, "SeeAlso",
 CellID->16086]
}, Open  ]],
Cell[CellGroupData[{
Cell[15423, 524, 313, 9, 70, "TutorialsSection",
 CellID->6717],
Cell[15739, 535, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[15889, 540, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[16229, 554, 319, 9, 70, "MoreAboutSection",
 CellID->233495246],
Cell[16551, 565, 140, 3, 70, "MoreAbout",
 CellID->306594215]
}, Open  ]],
Cell[16706, 571, 27, 0, 70, "History"],
Cell[16736, 573, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

