(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27109,        944]
NotebookOptionsPosition[     21565,        757]
NotebookOutlinePosition[     23038,        797]
CellTagsIndexPosition[     22953,        792]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpanFromAbove" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromAbove"], 
          "SpanFromBoth" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromBoth"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpanFromAbove\"\>", 
       2->"\<\"SpanFromBoth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Grids & Tables\"\>", 
       2->"\<\"Layout & Tables\"\>", 
       3->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpanFromLeft", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpanFromLeft",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that can appear at a particular position \
in a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears to its left."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SpanFromLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
 " appears at several successive positions in a row, it indicates spanning \
across all these positions."
}], "Notes",
 CellID->27471]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->876939645],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->105989056],

Cell["Make the element 4 span the column to its right:", "ExampleText",
 CellID->578952123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromLeft", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348140959],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromLeft]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421925882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1783799005],

Cell["Make it span two columns:", "ExampleText",
 CellID->581884849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromLeft", ",", "SpanFromLeft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74187149],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317296380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1438164915],

Cell["Span across the remaining width of the grid:", "ExampleText",
 CellID->1948327763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "SpanFromLeft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->714063285],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4"},
    {"5", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"6", "7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{69, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1869090915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1309279420],

Cell[TextData[{
 "Spanning in a ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1712804487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromLeft", ",", "SpanFromLeft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86724974],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr1uwjAQgJ2aCQITAw20YkZiiJQBtkzt1K2l7RihSjBUrShPwlMgpkp0
j5QX4JHSO5OQxBgwoVRpdZFyyv18d8ZKjHPKnTcdvbx60/HQa99OvPfRePjR
vnmbgIkbjLEvPBsMrkO4Wp98uVzW63XXdVkfBTdNs9vt4mVP6KBUq9XYb0As
cNz3fdDCMGR9FBwUMOFlT+hZv4E4UUQRRRRRP0ZZIgrXcXGwlpTlEsQFuK+k
bLH9OlfWBopS4mdRRJKhKWVoKuuooo6rgyPlkf34/PtmZ7vuOcavW0kdd55a
6TnVmS0rZf+LzxBRRBFFVPGoxWJRLpfdzZtZpVKxbdvdvJmBAqbYb0BsVMtx
HJCsj4IHQeCLY0vvgTAgNjvCT+W4yUrWtHUg7ttkN/F4QtQ9CNyYPO30xjlA
smdl1EO43oXk8eqNsgizTtbCWjudTrLGzmazzJqb6GLNhVik5vN5rVZL1vcD
nTeIzY6gqP9bRBFFFFH/mdrVJcE+TImpuy8Yr+6S6HSq0nsgOXtL4q1cVeS+
X/MsVWS/JVXZ3086NftvdSb15ir9W3U7k7vvouI/NUQRRRRRxaOCIMh8BXGg
1xZ9BQEJVquVr9trg1igjG/9vvyN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->539572430]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->628],

Cell["Spanned elements inherit their styles:", "ExampleText",
 CellID->79646317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Item", "[", 
        RowBox[{"4", ",", 
         RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", " ", 
       "SpanFromLeft", ",", " ", "SpanFromLeft"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"Frame", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1445038790],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {
     ItemBox["4",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874379607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1285420987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "SpanFromLeft", ",", " ", "SpanFromLeft"}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"Frame", "->", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->733337738],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"7", "8", "9"}
   },
   GridBoxBackground->{
    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}, 
     "ItemsIndexed" -> {{2, 1} -> RGBColor[1, 0, 0]}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->798712433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39584034],

Cell["Graphics will default to filling the available space:", "ExampleText",
 CellID->1716412515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", ".5"}]}], "]"}], ",", 
      "SpanFromLeft"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467458428],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiQQkGIPs/kAXG
vP///3cCMsShNA+QZmAYzqJbiCAZGAF2/46b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24532778]
}, Open  ]],

Cell["An explicit ImageSize setting will prevent this behavior:", \
"ExampleText",
 CellID->597309454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", ".5"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}], ",", 
      "SpanFromLeft"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1641427300],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw3AdhCQYg+z+QBcb3
//8H0sOJdASS8UCv2Y/yRnl0490f1iQ31K88UJprVHRUdFR0VHRUdFR0VHRU
FC56n2KSgREA6XEqUg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{223, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142499327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4481],

Cell["Spanning regions must be rectangular in shape:", "ExampleText",
 CellID->1808496775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2069241434],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1247627544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1211719407],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 " when spanning across both columns and rows:"
}], "ExampleText",
 CellID->1985128186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938198202],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->845802700]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30951],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromAbove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpanFromBoth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpanFromBoth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28435],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->185213599],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->78925544],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->29785403],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->332897979]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpanFromLeft - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 5.4347348}", "context" -> "System`", 
    "keywords" -> {
     "span from right", "span cells", "horizontal span", "table span", 
      "merge table cells", "combine rows"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpanFromLeft is a symbol that can appear at a particular position in a \
Grid or related construct to indicate that the corresponding position is \
occupied by a spanning element that appears to its left.", 
    "synonyms" -> {"span from left"}, "title" -> "SpanFromLeft", "type" -> 
    "Symbol", "uri" -> "ref/SpanFromLeft"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6131, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->876939645]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22810, 785}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2376, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2999, 85, 1577, 37, 70, "ObjectNameGrid"],
Cell[4579, 124, 715, 20, 70, "Usage",
 CellID->30623]
}, Open  ]],
Cell[CellGroupData[{
Cell[5331, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5809, 166, 285, 9, 70, "Notes",
 CellID->27471]
}, Closed]],
Cell[CellGroupData[{
Cell[6131, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->876939645],
Cell[CellGroupData[{
Cell[6516, 194, 148, 5, 70, "ExampleSection",
 CellID->105989056],
Cell[6667, 201, 91, 1, 70, "ExampleText",
 CellID->578952123],
Cell[CellGroupData[{
Cell[6783, 206, 418, 13, 28, "Input",
 CellID->348140959],
Cell[7204, 221, 328, 12, 70, "Output",
 CellID->421925882]
}, Open  ]],
Cell[7547, 236, 126, 3, 70, "ExampleDelimiter",
 CellID->1783799005],
Cell[7676, 241, 68, 1, 70, "ExampleText",
 CellID->581884849],
Cell[CellGroupData[{
Cell[7769, 246, 428, 13, 70, "Input",
 CellID->74187149],
Cell[8200, 261, 342, 12, 70, "Output",
 CellID->317296380]
}, Open  ]],
Cell[8557, 276, 126, 3, 70, "ExampleDelimiter",
 CellID->1438164915],
Cell[8686, 281, 88, 1, 70, "ExampleText",
 CellID->1948327763],
Cell[CellGroupData[{
Cell[8799, 286, 428, 13, 70, "Input",
 CellID->714063285],
Cell[9230, 301, 372, 12, 70, "Output",
 CellID->1869090915]
}, Open  ]],
Cell[9617, 316, 126, 3, 70, "ExampleDelimiter",
 CellID->1309279420],
Cell[9746, 321, 206, 8, 70, "ExampleText",
 CellID->1712804487],
Cell[CellGroupData[{
Cell[9977, 333, 436, 13, 28, "Input",
 CellID->86724974],
Cell[10416, 348, 851, 18, 201, "Output",
 Evaluatable->False,
 CellID->539572430]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11316, 372, 214, 7, 70, "ExampleSection",
 CellID->628],
Cell[11533, 381, 80, 1, 70, "ExampleText",
 CellID->79646317],
Cell[CellGroupData[{
Cell[11638, 386, 605, 18, 70, "Input",
 CellID->1445038790],
Cell[12246, 406, 421, 15, 70, "Output",
 CellID->874379607]
}, Open  ]],
Cell[12682, 424, 126, 3, 70, "ExampleDelimiter",
 CellID->1285420987],
Cell[CellGroupData[{
Cell[12833, 431, 712, 22, 70, "Input",
 CellID->733337738],
Cell[13548, 455, 479, 15, 70, "Output",
 CellID->798712433]
}, Open  ]],
Cell[14042, 473, 124, 3, 70, "ExampleDelimiter",
 CellID->39584034],
Cell[14169, 478, 97, 1, 70, "ExampleText",
 CellID->1716412515],
Cell[CellGroupData[{
Cell[14291, 483, 575, 18, 70, "Input",
 CellID->467458428],
Cell[14869, 503, 308, 9, 70, "Output",
 Evaluatable->False,
 CellID->24532778]
}, Open  ]],
Cell[15192, 515, 102, 2, 70, "ExampleText",
 CellID->597309454],
Cell[CellGroupData[{
Cell[15319, 521, 968, 29, 70, "Input",
 CellID->1641427300],
Cell[16290, 552, 355, 10, 70, "Output",
 Evaluatable->False,
 CellID->142499327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16694, 568, 225, 7, 70, "ExampleSection",
 CellID->4481],
Cell[16922, 577, 90, 1, 70, "ExampleText",
 CellID->1808496775],
Cell[CellGroupData[{
Cell[17037, 582, 431, 13, 70, "Input",
 CellID->2069241434],
Cell[17471, 597, 344, 12, 70, "Output",
 CellID->1247627544]
}, Open  ]],
Cell[17830, 612, 126, 3, 70, "ExampleDelimiter",
 CellID->1211719407],
Cell[17959, 617, 239, 8, 70, "ExampleText",
 CellID->1985128186],
Cell[CellGroupData[{
Cell[18223, 629, 441, 13, 70, "Input",
 CellID->938198202],
Cell[18667, 644, 357, 12, 72, "Output",
 CellID->845802700]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19085, 663, 311, 9, 70, "SeeAlsoSection",
 CellID->30951],
Cell[19399, 674, 469, 17, 70, "SeeAlso",
 CellID->28761]
}, Open  ]],
Cell[CellGroupData[{
Cell[19905, 696, 314, 9, 70, "TutorialsSection",
 CellID->28435],
Cell[20222, 707, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[20372, 712, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[20712, 726, 319, 9, 70, "MoreAboutSection",
 CellID->185213599],
Cell[21034, 737, 139, 3, 70, "MoreAbout",
 CellID->78925544],
Cell[21176, 742, 141, 3, 70, "MoreAbout",
 CellID->29785403],
Cell[21320, 747, 173, 3, 70, "MoreAbout",
 CellID->332897979]
}, Open  ]],
Cell[21508, 753, 27, 0, 70, "History"],
Cell[21538, 755, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

