(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8396,        275]
NotebookOptionsPosition[      6446,        214]
NotebookOutlinePosition[      7571,        245]
CellTagsIndexPosition[      7528,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Check Spelling" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/CheckSpelling"], 
         "SpellingOptions" :> 
         Documentation`HelpLookup["paclet:ref/SpellingOptions"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Check Spelling\"\>", 
      2->"\<\"SpellingOptions\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpellingDictionaries", "ObjectName",
 CellID->10542],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->479293115],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpellingDictionaries", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " \[LineSeparator]is a global option that specifies settings for \
spellchecking."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options may be specified:", "Notes",
 CellID->21547],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CorrectWords\>\"", 
    RowBox[{"{", "}"}], Cell[
    "correct words to add to the main dictionary", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncorrectWords\>\"", 
    RowBox[{"{", "}"}], Cell[
    "words marked incorrect during spell check", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Suggestions\>\"", 
    RowBox[{"{", "}"}], Cell["\<\
words in list will cause spell check to stop and offer an alternative\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->30502],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<CorrectWords\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"word\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"word\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " means that if any word in the list is found during a spell check, it is \
skipped even if it does not exist in the main dictionary."
}], "Notes",
 CellID->9099],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<IncorrectWords\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"word\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"word\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " means that if any word in the list is found, the spell check stops, even \
if the word exists in the main dictionary."
}], "Notes",
 CellID->25023],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<Suggestions\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"word\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", "\"\<\!\(\*SubscriptBox[
StyleBox[\"newword\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\""}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " means that if any word in the list is found, the spell check stops and the \
corresponding new word is offered as an alternative in the ",
 StyleBox["Check Spelling", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->17226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8636],

Cell[TextData[{
 StyleBox[ButtonBox["Check Spelling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpellingOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 " "
}], "SeeAlso",
 CellID->1567449]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpellingDictionaries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 16.1381338}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpellingDictionaries -> {opt_1 -> val_1, opt_2 -> val_2, ...} is a \
global option that specifies settings for spellchecking.", 
    "synonyms" -> {"spelling dictionaries"}, "title" -> 
    "SpellingDictionaries", "type" -> "Symbol", "uri" -> 
    "ref/SpellingDictionaries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 718, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1341, 44, 58, 1, 70, "ObjectName",
 CellID->10542],
Cell[1402, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->479293115],
Cell[1623, 55, 917, 29, 70, "Usage",
 CellID->7376]
}, Open  ]],
Cell[CellGroupData[{
Cell[2577, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3055, 106, 72, 1, 70, "Notes",
 CellID->21547],
Cell[3130, 109, 769, 17, 70, "3ColumnTableMod",
 CellID->30502],
Cell[3902, 128, 515, 13, 70, "Notes",
 CellID->9099],
Cell[4420, 143, 504, 13, 70, "Notes",
 CellID->25023],
Cell[4927, 158, 634, 17, 70, "Notes",
 CellID->17226]
}, Closed]],
Cell[CellGroupData[{
Cell[5598, 180, 310, 9, 70, "SeeAlsoSection",
 CellID->8636],
Cell[5911, 191, 461, 16, 70, "SeeAlso",
 CellID->1567449]
}, Open  ]],
Cell[6387, 210, 29, 0, 70, "History"],
Cell[6419, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

