(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6507,        215]
NotebookOptionsPosition[      4702,        161]
NotebookOutlinePosition[      5910,        193]
CellTagsIndexPosition[      5867,        190]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Check Spelling" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/CheckSpelling"], 
         "SpellingDictionaries" :> 
         Documentation`HelpLookup["paclet:ref/SpellingDictionaries"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Check Spelling\"\>", 
      2->"\<\"SpellingDictionaries\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpellingDictionariesPath", "ObjectName",
 CellID->19047],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->170643138],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpellingDictionariesPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpellingDictionariesPath"]], "InlineFormula"],
     "\[LineSeparator]is a global option that specifies which directories are \
searched for spelling dictionaries when the ",
     StyleBox[ButtonBox["Edit",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/EditMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Check Spelling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName"],
     " menu item is used."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2352]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The directories to be searched are specified using the ",
 Cell[BoxData["FrontEnd`FileName"], "InlineFormula"],
 " function. A typical directory included on ",
 Cell[BoxData[
  ButtonBox["SpellingDictionariesPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpellingDictionariesPath"]], "InlineFormula"],
 " is ",
 Cell[BoxData["FrontEnd`FileName"], "InlineFormula"],
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["$UserBaseDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$UserBaseDirectory"], ",", "\"\<Autoload\>\"", 
     ",", "\"\<SystemFiles\>\"", ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\"\<SpellingDictionaries\>\"", "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9658]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4422],

Cell[TextData[{
 StyleBox[ButtonBox["Check Spelling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpellingDictionaries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingDictionaries"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->71525783]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpellingDictionariesPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 16.4193910}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpellingDictionariesPath is a global option that specifies which \
directories are searched for spelling dictionaries when the Edit \
\\[FilledRightTriangle] Check Spelling menu item is used.", 
    "synonyms" -> {"spelling dictionaries path"}, "title" -> 
    "SpellingDictionariesPath", "type" -> "Symbol", "uri" -> 
    "ref/SpellingDictionariesPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 734, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1357, 44, 62, 1, 70, "ObjectName",
 CellID->19047],
Cell[1422, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->170643138],
Cell[1643, 55, 858, 22, 70, "Usage",
 CellID->2352]
}, Open  ]],
Cell[CellGroupData[{
Cell[2538, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3016, 99, 796, 24, 70, "Notes",
 CellID->9658]
}, Closed]],
Cell[CellGroupData[{
Cell[3849, 128, 310, 9, 70, "SeeAlsoSection",
 CellID->4422],
Cell[4162, 139, 466, 15, 70, "SeeAlso",
 CellID->71525783]
}, Open  ]],
Cell[4643, 157, 29, 0, 70, "History"],
Cell[4675, 159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

