(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11332,        371]
NotebookOptionsPosition[      9021,        297]
NotebookOutlinePosition[     10125,        327]
CellTagsIndexPosition[     10082,        324]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Check Spelling" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/CheckSpelling"], 
         "SpellingDictionaries" :> 
         Documentation`HelpLookup["paclet:ref/SpellingDictionaries"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Check Spelling\"\>", 
      2->"\<\"SpellingDictionaries\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpellingOptions", "ObjectName",
 CellID->6747],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->426104623],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpellingOptions", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " \[LineSeparator]is an option for notebooks that specifies settings for \
spell checking."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following suboptions can be specified:", "Notes",
 CellID->5869],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlwaysSkip\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<SingleCharacterWords\>\"", ",", " ", "\"\<Numbers\>\"", ",", " ", 
      "\"\<WordsWithNumbers\>\"", ",", " ", "\"\<WordsInAllCaps\>\""}], "}"}],
     Cell["criteria for skipping words during a spell check", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlwaysStop\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<UncapitalizedStartOfSentence\>\"", ",", " ", 
      "\"\<RepeatedWords\>\""}], "}"}], Cell[
    "criteria for stopping a spell check", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WordSplitting\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Hyphen\>\"", ",", " ", "\"\<Underscore\>\"", ",", " ", 
      "\"\<InternalCapitals\>\""}], "}"}], Cell["\<\
whether compound words of a given type should be split before being tested by \
the spell checker\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->14398],

Cell[TextData[{
 Cell[BoxData["\"\<AlwaysSkip\>\""], "InlineFormula"],
 " is given as a list of conditions to be tested. If a word being tested \
satisfies any of the conditions, the spell checker skips that word. This \
option allows you to customize a spell check to ignore certain types of \
words."
}], "Notes",
 CellID->27352],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData["\"\<AlwaysStop\>\""], "InlineFormula"],
 " override those for ",
 Cell[BoxData["\"\<AlwaysSkip\>\""], "InlineFormula"],
 " if the same condition is specified for both options."
}], "Notes",
 CellID->25679],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"\"\<AlwaysSkip\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<SingleCharacterWords\>\"", ",", "  ", "\"\<Numbers\>\"", ",", " ", 
     "\"\<WordsWithNumbers\>\"", ",", " ", "\"\<WordsInAllCaps\>\""}], 
    "}"}]}]], "InlineFormula"],
 StyleBox[". ", "TR"]
}], "Notes",
 CellID->28053],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<AlwaysSkip\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<UncapitalizedStartOfSentence\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RepeatedWords\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SingleCharacterWords\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Numbers\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<WordsWithNumbers\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<WordsInAllCaps\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RomanNumerals\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AlternateSpellings\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<CaseDifferences\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<EncliticForms\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<HyphenatedWords\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<WordsWithUnderscores\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<WordsWithInternalCapitals\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->13043],

Cell[TextData[{
 Cell[BoxData["\"\<AlwaysStop\>\""], "InlineFormula"],
 " is given as a list of conditions to be tested. If a word being tested \
satisfies any of the conditions, the spell check stops at that word. This \
option allows you to generalize a spell check to search for errors other than \
ordinary spelling errors."
}], "Notes",
 CellID->1563],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"\"\<AlwaysStop\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<UncapitalizedStartOfSentence\>\"", ",", " ", 
     "\"\<RepeatedWords\>\""}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25834],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<AlwaysStop\>\""], "InlineFormula"],
 " are the same as for ",
 Cell[BoxData["\"\<AlwaysSkip\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->9850],

Cell[TextData[{
 "When the spell checker encounters a compound word of a type specified in ",
 Cell[BoxData["\"\<WordSplitting\>\""], "InlineFormula"],
 ", it splits the word and tests each of its component words separately. "
}], "Notes",
 CellID->21911],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"\"\<WordSplitting\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Hyphen\>\"", ",", " ", "\"\<Underscore\>\"", ",", " ", 
     "\"\<InternalCapitals\>\""}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2104457814],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<WordSplitting\>\"", "->", "\"\<All\>\""}]], "InlineFormula"],
 ", the spell checker will attempt to split up compound words even if they \
are not internally capitalized or hyphenated or have no underscore. For \
example, \"shortstop\" could be tested as \"short\" and \"stop\"."
}], "Notes",
 CellID->9492]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29876],

Cell[TextData[{
 StyleBox[ButtonBox["Check Spelling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpellingDictionaries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingDictionaries"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19178]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpellingOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 16.6693974}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpellingOptions -> {opt_1 -> val_1, opt_2 -> val_2, ...} is an option \
for notebooks that specifies settings for spell checking.", 
    "synonyms" -> {"spelling options"}, "title" -> "SpellingOptions", "type" -> 
    "Symbol", "uri" -> "ref/SpellingOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 734, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1357, 44, 52, 1, 70, "ObjectName",
 CellID->6747],
Cell[1412, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->426104623],
Cell[1633, 55, 922, 29, 70, "Usage",
 CellID->26308]
}, Open  ]],
Cell[CellGroupData[{
Cell[2592, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3070, 106, 74, 1, 70, "Notes",
 CellID->5869],
Cell[3147, 109, 1177, 27, 70, "3ColumnTableMod",
 CellID->14398],
Cell[4327, 138, 331, 7, 70, "Notes",
 CellID->27352],
Cell[4661, 147, 258, 7, 70, "Notes",
 CellID->25679],
Cell[4922, 156, 369, 11, 70, "Notes",
 CellID->28053],
Cell[5294, 169, 1031, 31, 70, "Notes",
 CellID->13043],
Cell[6328, 202, 356, 7, 70, "Notes",
 CellID->1563],
Cell[6687, 211, 286, 10, 70, "Notes",
 CellID->25834],
Cell[6976, 223, 211, 7, 70, "Notes",
 CellID->9850],
Cell[7190, 232, 255, 5, 70, "Notes",
 CellID->21911],
Cell[7448, 239, 307, 10, 70, "Notes",
 CellID->2104457814],
Cell[7758, 251, 375, 8, 70, "Notes",
 CellID->9492]
}, Closed]],
Cell[CellGroupData[{
Cell[8170, 264, 311, 9, 70, "SeeAlsoSection",
 CellID->29876],
Cell[8484, 275, 463, 15, 70, "SeeAlso",
 CellID->19178]
}, Open  ]],
Cell[8962, 293, 29, 0, 70, "History"],
Cell[8994, 295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

