(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    836294,      14948]
NotebookOptionsPosition[    824956,      14571]
NotebookOutlinePosition[    826234,      14607]
CellTagsIndexPosition[    826146,      14602]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Circle" :> Documentation`HelpLookup["paclet:ref/Circle"], 
          "Cylinder" :> Documentation`HelpLookup["paclet:ref/Cylinder"], 
          "Cuboid" :> Documentation`HelpLookup["paclet:ref/Cuboid"], 
          "GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], 
          "SphericalPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/SphericalPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Circle\"\>", 2->"\<\"Cylinder\"\>", 
       3->"\<\"Cuboid\"\>", 4->"\<\"GraphicsComplex\"\>", 
       5->"\<\"SphericalPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Precollege Education\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Sphere", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sphere",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sphere"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["z", "TI"]}], "}"}], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sphere of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], ")"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sphere",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sphere"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["z", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sphere of radius 1. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " renders as a sphere in ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1942],

Cell[TextData[{
 "Colors and other material properties of spheres can be specified using \
color directives as well as ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23362],

Cell[TextData[{
 "Spheres can be specified as transparent using ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " directives. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3427],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sphere",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sphere"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sphere",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sphere"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16641]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602831967],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->141158433],

Cell["A unit sphere at the origin:", "ExampleText",
 CellID->23083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3794],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8442,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10971],

Cell["Two intersecting spheres:", "ExampleText",
 CellID->6679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31732],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}, 1], 
   SphereBox[{0, 0, 1}, Rational[1, 2]]}]], "Output",
 ImageSize->{154, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1309,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->103486585],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sphere Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->494790463],

Cell["A unit sphere:", "ExampleText",
 CellID->453908246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93580876],

Cell[BoxData[
 Graphics3DBox[SphereBox[{1, 1, 1}]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478265894,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79700778],

Cell["Spheres with different radii:", "ExampleText",
 CellID->112034894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19698400],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}, 1], SphereBox[{3, 3, 0}, 2]}]], "Output",\

 ImageSize->{184, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39380930,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->768042278],

Cell[TextData[{
 "Short form for a unit sphere at the origin: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16641]
}], "ExampleText",
 CellID->91147115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50259812],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Axes->True]], "Output",
 ImageSize->{184, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139016790,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275586159],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->414922542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".8", ",", ".5"}], "}"}], "]"}], ",", "1"}], "]"}],
     "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227910572],

Cell[BoxData[
 Graphics3DBox[SphereBox[Scaled[{0.5, 0.8, 0.5}], 1],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->344040866,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sphere Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->182991362],

Cell["Colored spheres:", "ExampleText",
 CellID->120500777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127048219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0, 0], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 1, 0], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVW3ucTeUafu09wzCMQUIlU9FFGJMY0gUV0k2lo9DFZQqZQyi5VJw6iqhU
uugciaJzyDF1Ikqlciqly3Q5JRx16OpaSf0xv3Pe93m/79vf/taamT1+Zu+9
1vrWWs/zvc/7vO9ae+0Lh04cWVI6dOKo4UML+owfOm7kqOETCnqPHc+rkrWI
qIT/xjQn/vw//oS/XhUVFZQsKSmpwD8qkBc6i1+zeeUxWDqDXxO8lDTvura7
Wcr2jsCv5ghd+VVW1pGlLHd8/tAK27uYvXODvXVrJ7N3g8jeR2N7kdk7X5ay
3XZzjJYYU2jGNK5iTDtznsOCWUgEy0dgdFtzxGYZjT7RjG4RbE0Gy9hObQyS
I4OtWcFyc4w+zhz76IxGF5hjFwRbs4Nl8KKjzbGPy2j0UWZ0m2Br7WD5cIxu
YZCcEGytEyw3xehm5thtMxrd1IxuF2zNCZYRa2pskHQIttYNlptgdL45dlFG
oxuYY59azWgok3LNsYszGl3XjO4WbK0XLDfC6Bwz+rRga26wnO9G+7nYmt/r
UfvI6Cr2jmR6E94/1EL9YLlhav9Inko+tOBjhFlTxTGqyMzDDSKqTx1I3vU/
f+7IhmE/tyc9ecNg77zYc4TIRANN5Ug5csRT2MzwWmRfO1FCPiX5TLoTheeB
60VUHuafzHojOU/S4C+Sj/xSWw5/KlFndlk2YqJufMbTiLL5gy7KxPIOmZ03
jJ7MQmM5b5Y5byc5VYKKhTEfvjsXDKIzuYgQ9SDqSdSLt54t5++JM/cACsaY
FxfTyPnDZRmV585faP4nBEmeYFHOzPd0QODz87nPJepD1JfoPKJ+ROfz+AsI
apPFvhhzumZu9YhCBUjuNdRIFCIMPPkJmf48AdMtHUlvnI5Pyue/iKg/0SVE
l/H4AXwiuhwzNEDWyCYec04UVW4sqtAvBGW+oGqZQqVwuiM8PXHsPhbLxQYI
Q6CBRFcQDSIaTDSE6CqAugqfB2PTAOwS4qoXiyt0pto2fkeY+HWEGDRsUWgX
YiIcrkFAcTXRNURDiYYRDScaIQAT0t5k82dZea2glr1Cn1CM1TmS1NH6Oncd
LEDNZJ7EYqirMph/ILoS03QVUAwTdHQd0fVEo4hGcwOG2UzyO6O9AWuvx7gr
o2jrxqIN511crkGAtjNw6oyeJSkowoviHGIncjhAjjQIqZRoLNE4ovFAm0UT
BO14rCrFuMFRtDmxaMMsR+yPT3mHavIMmMU5SI7zocYAo06kziID/KNBJ8Bu
IrqZ6BaiyQA7hWgqyetkrJyEYWMyROs80ZSGXHk5JqXUzpFJPQ+TegmS4grM
y9WYUUU72qK9EVBvBp7JQDiN6Dai24F5ujjGDPHu6bJKNkzF0LER3HVicUs1
kFpNrVNYi6xiu8KCeli56vxeivkdZIWqAtDJHQu4EwFXsd4KSIztT0R3EP0Z
oGeyiu8SzDNljayfDlbjIh1CPGaZ61yH2em2SzrgvvCa/pjfgZhfVUMJZHiD
ndyJ3sw6qHcCGGOcRTQbmOcw5rk813OkftxDdDcG3Qo1IOxSzk1dVtRxdReo
26Sh9iE7SVxuBawTrHoohXQneLOreO/wwDIyRngv0X1APY/oASkvD8ps86d5
skFG3CXYswz2sPuvHYu/ofU24FfwmoA9UScVvK+OoXayVRrjkXG3pM+0Ip8N
UHOBjjEy3IeA/2GiR2TCHxX8/Gk+tt0v01/hXSdmhL2e8w8ta52tHfcC/H4o
q5ema0WV7SZ+Euzh1jjs9wLWAwJcUDPgx8DgcQb+V/HAv8ga4TAPe8VVtyhu
8cC6grttqldzqakzr/asvuegO82oxv1pnwHhqloUt074fIBjiI+TYF0I9IuI
niRazApaIhFYjMVFslVGPlhTFieldRTF8MMedvZjKWiajreanwaT06m/G2qf
a+fdx88T/oRBLiyeJloqPrmMeTwjPHiJ1z0FKgvkMGEPVA2PEyUaRbYKqalr
+l6UTmKEJ39NXKcfztqZNgj3WeVEGSwB1GXg8TfmsJz/VvDfs8JjBfEyrxZC
T8remfFoYLPhJJPJAYkLvTy41iPhJ4GvpNkIg8pIta8MFkkAZJqXCgPBuRw8
GPs/JB6rOLPLJDdWYQVTeQY7haoC/sg9CheNk000uiChz0K33LdKFur5mg++
mDQZNA4LkAYaBKXA4P5OMufAL0SeI3qe6J/C5QX+Wy0xeQEr+H8ZBi6rAZs6
2ju46uDSvJetZpdYd9UE8Qlpgmt2BMKanx4TKykNCK0kmf8yoSKcmMQaoheF
01rOl3XCaS1WrAbblXKAUGfVcOrgLvdSSd8b/UR/1LpB6H1cxmuyRAlprqvI
HouER9motsBGQrEGnJjES0QvE61nsb0iiltPsvJFDFtONedT6LWgZ9q8uRi9
xpWofcPSyUyyZDTtXcY4rbl0edoKLcJEwrAOfJjCq0SvEW1gKq8Lnw1Ysx6U
yjLlIz6Q4/icguA4tWn6XGEL+XUoJzUis8RmjRPZcx4TDcgr4MPo3yB6k2gj
U/mX8NmINRtAaXWN+RQKH63vTmmaOuoFJSjrrrBMsUYQkNGkWWg1phmzAmTK
kOKrMd/rDBMJyOvgw+iZxVtEbxO9I/3LJuH0DlZtBK2XKuMU3hVymis0Mepq
BdfPCm6QV2pKUe9rxMlJ7TlwctGxhCQQGwW6MGMi7xK9Jz3lZnaI94XXe1i3
CaNei7p3VqW8aguvotTlXHc0NH3StaeJ5GxuMurnDJi2swQVXiyvVTZ/NFDr
kScbUqQkRJtAbTMJnQ+IPpSIfSTMPsTyZgTxjZowyxZm7VLV9TQvaP3ThTja
87tp6AzuRDma4zFbEGG20jJTCb4EZhquNyE+0OLQJPSmATNhRh9L3D6R+0Wf
krzzcjn4bsY+mfPLct1DoddAuOBdBhe82taoUpto6hraNNyD6vRghJ/zC5di
a21++WGTG8YcoY8QOubBhD6TmvVv/vsc7xzEz0DxQ5mKzLklhdsJaVfDXeCL
fviGWFO8AcK8CcLUhNOG6F5U3oetHcZyW2O5qSQ5cLiSrCsZ9T5wlyNMn4Lk
50RfCMMt/Pcl3pnhF2RIbq5p9I5L9RndYJN+6NRP1COdNDXpZts2aT6KsFq9
r0vHbZ3lBlb1JYnehdQ+sGLkoHGcmNgWMNzKrLbx33a8M7svyRD8oBJ24X36
hpZdgWHXGVfXZ6M8+5FTS7kxXZV+1j2K/sJVMd9MVgs1cGosMXsL9hCE7DMy
8WIKW4kZyfD/EO0g+opzcIew245Nn8tkZMYu37I7UgyzG3rdc9EXuoQbYQ1l
oqfImenZ9jj6psW2aVJeyKcmEq3XbYptsqz8YHmUHB+90/dfccyvZVm2bcE+
mfNC1rWQlDsVXqJNyEVoDwd7IRtv24/pXgkIMu1p8EKEmqUMJEpNdeiitQW8
toEXk2AqTGmnYfeNsNuJVV9hXDlF7lYlq2Z3uLESFWQ/tCQDbdRGpUftDvhI
RI3g1NwU6xcqYaYZVh5hth3hUlq7iBkl6FtuQ+SQ35H5/y02fY3BH9WEYUIY
HiZZ18letThpDkKtu85LuWk2fuom0CW4HWWSzfnIi7YXUYP0Y6cMnSb9wO0U
ekKGKX3PPH/gmieH/5Hk4/fYtBMkw7uk1TDMNzW9GMnX2yp0CPqUkdYvvRgi
r1qlCXOFNZI1tiV5jdKMxI+ez80LnRITMj9KTdgtNX0PpLobq77DuG2Z8sO3
vnnaZopKi1ER+sIzB3rGoqVuqsbqGBc6YylaBZbbZlIzT+m9gQbjnUjaOXo7
bNx2ITgetz2sUdpLtA//94LkHmz+BrKOZ+jfj8W367nmS9oiyLMnKoI2mddY
bYJVa1PDNfe0yC20dqlloMw2lH7uvY3q9n6E23aPm4sbE9stXBJCKYf2Ex3A
//3C0Qh1V+T7migzPJNgLg+EVi9c6mjKgc0JxlK0wM2yfYmGbJFtSlYgZE6R
QbZtRl372JpJEC/lpMHaI5yERILJZNFPUuX2Wz47M+WTNJHqaqpSO8kt9ceb
rPVrSVNz1C7EBWilDZCaY1R85ahlaosusXwmu8FkH5m4MI2fGdQvUgF+xhqN
0bboN9GJWEaIRKEE5wJcsA3x0mkSzNBJbh4qmabTEhsb5xbqhL7efBtUl1cP
DOho+lguQiWLDgqfX7Bqn4hSQFbPp5Hlg0da2sMqVHWX43JtBFriG9EzqgfO
shavRczZ4LNenJxJRBX3ha1dX8H9YlkppYPC6ldxwoNkiO2V2Cr42G8/07nl
GW64Ei+U3rEnmA0AsxJ4xAQvnWajqXrIswhnf9F4ReXnJ5K6nsuigNavklGH
5E7cbyTvv2LDARkd9vdhx2VZptbkGpY5yrIjLk37RVhOsSVa80z7qyc8x1hl
6/PL6cFzFuhL0mXY9+kUf/IoHpL4/SaXqMpvX/QOT/Xs5PsgcQ1UhQ5y4d0H
hqg5NwYt1hRrIXPSzVB1udIWL+eEmm3R6FUmyv0RXr9x/H7nP7A7iM0/RO/L
h3eEouzsN3ao1+2kjeyP9tinNgNeMtdS05RbGhHmq9YX/XyLhkxrseOlqvR4
JZmXhu2QCVp1T70YVqknviq8ZylPlohdgLI8DE4yIcLpUWv3mmyBDLVqaSUO
YrUjPVaBBi0hJvO7ROkQaB6I3qcL+dQCH6GDpybbSlQGoOMdjcuVyVCbwlcX
XAhvX2azyFlgIDXf/4J4aArtt34exiMpPFRmsd+oR9D7a/AU6onie4Nx0TUO
Xq4JE1BQIyjzssV5XSAp3+iqTJWUA/yEWGWKX128xDz5x33PZVBQKS43boOR
zfHko+CfjYB3+eBb2DarnV2VaMfNf0IFpBZ9IK7nCZ9lUPyxz/a2lmv6kdDQ
NFTS2egPHrH6jxJwCe08ONao4gwYlRNNzn4pmJFn/EKvMqqv0OdEoZljBe8Y
tDTTcTPlPpQNNaBlcVLxwVbmqj96zRjUniUgk1rdK+y1S3iPIYI0nHfMcCvp
Kaeils+BshegDiy1xqKZGcX6SeWu4jslQCa1YRQe4dPiYdQVaR1/TlsKwttg
H/fb0D9ly9Tz8D1nHC7rPonLum/TLjwY1j552Sur5ERNM8IWeiFm8Qi5Iz8L
yfWYnT8Xa600zpW1gsa2dfaqLykgk/IZrRuFT80Lslq8KIgUVdgVYOaayZw9
gJA+aXOl2glzkNy1aEKgJfVmgTt2UM3S0djnsuFDTcSR7rET84wN29o4FB97
V41b5aTb5WUrmTO1RBr6VVOOrdU0dBlUokb+WFH3Ylwf+XEJOu5y4YsvCcrt
WfGbjbSns/WMeYZl8+DMnb3lFL78YFSotvi9wswO88f+FkRHNzZL4ahis16j
E24NzyFIstxo+9uAcFSRGaXf2YUKDa+i2pvR+lRmc3PMcJT87kPCq09ThzoL
62Brc0x9uj/89UeYEQVmtP6awv72Ihx1pEGgv0MJfyMSVt5m5pj6y5tW5pjh
qCZmFH4VomqqwmUaGgT4nQcdW5H6/VA4F3JM/GIDM5Gu0Lpme0dsb+PtLdrK
MufAryzoeH6tXWJ+F0FU6/9CVjGO\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 0, 1], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->326650194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50742823],

Cell[TextData[{
 "Different properties can be specified for front and back of faces using ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->45613324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".8"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35360879],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], SphereBox[{0, 0, 0}]},
  PlotRange->{{-1, 1}, {-0.8, 1}, {-1, 1}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->576373000,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->600880851],

Cell[TextData[{
 "Spheres with different specular exponents: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23362]
}], "ExampleText",
 CellID->358441062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "n"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "20", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->227665862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 100], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->344422584]
}, Open  ]],

Cell["White sphere that glows red: ", "ExampleText",
 CellID->291906364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Glow", "[", "Red", "]"}], ",", "Black", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3405511],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0, 0]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->372393495,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVWNtO20AQdWLnHpIQbgmk4BIgEKDcA0KqKvWhfepHRDQSSK1aUX7fandm
x7FzPEkMEkJFwsnsnHO82Z0Zr+fb8Ol+9HP49HA39L8+Dn/fP9z98b/8ejRD
bsZxnO/m/0fLMd//mm/8/zkIAscdjUYB/zlbdHE+mWvODPpsfTTXrLFc+bSj
t+ZKxFxMwVxF4UawRdU7EG+ZLG98d/Nlk/0Xol0lKzf2i8Y7xpyJRn0G5kQw
TRXTYcyR3GsZViILdpvRfVFcS4XuiXYbvC7YLUbvinYnFbor6E3wemDzTB1f
ZuKDNwf2KqM3RbubCr0h2rvgzYO9wui2aO+nQq8Jug/eAti8e3ylwSPwFsFe
YnRTtE9SoRuCPgNvCWyONWdBZnIB3jLYi4yuiPYgFbok6BvwVsBuMLoo6Ns5
2hE6nq875rMsM5x1r3rEnshnyvem8eB+VcGuRfxEnlJ8tYwXI3uGxozMpJh9
Z3CcVnbYMmOYBVbCOeP9KS58VgLmXCXMI1r77bGS42hzqqpKmDXE6saVzNe6
tncJJW2HdkApK5E9Xw13gWJ2D9RcRa2sqmGOkb8Hap6ixrzEGmHs0m7sg1rO
XDC+dDVEeYpaXlErqmr4Cyh6D16shjHUB6WColRQlaIYskycU1FRyqtKFOuH
wC4pFcaytUw5Vu5Nv58KTzE1qyQVhYYws3OqCq3BB03FmGqGp1Kg6oq1WGfT
bp68EZvi8hTYFXkWJdm4nrVXYePMvVdg0+8+A3ZVmfnbs/GUWPuv2bRjdGqp
KTvlTmVRjtNQNsV+T1fpi0o+RbZYFTxjUJ73RKWsVIz0Kl2pLzWl5qVX8WUu
zRerUAXtiMoqqBSepdIWlXVQ0Z642akqK7Ium6DiPUulKXPBE5M7VSV+aqTz
X00U8DSSTa1QEQV+NntjhSB5mtH5ReHjc2U+m9+WZB3Px2yLnj/38F3reg4z
k2AuCpPHZLYDZYfwRBAqTWZr+Py+eZECxW14bhgoNRjjOqlQkDnQel8FyScn
1rykQngKoYi8DOafpUUhes8Kog7GuVJlUc/yiU6dhFMle3VGfGQ9sCcZ7fSY
MSYxJnd+JG9yR2YMz6X5BAvrMnUNKEMaMJ5LMGk1s1xf7Dm8CQwvwcATKq0K
vasszWXiOtEs6T1uFcbdBDN8K6cV2TJ2CxjZBAP3iH7fRmC7L9OYUWchQtl8
WzYX7sXl4lFEe2R5WD14fhMR1whsD2ryfd+ycX+xW3Y5hVcP9O7aVcyO5rgI
KOzghV1Giw67PYi6nlgv9OI9aCbuGL0imoiiHpEndclJ/HpcneMg/u6CkYAZ
dhDY3qztB4TdNETtiqbtGGGMYIXwRdP23DqiiaiOaK4zCvuOWhbZJ3QgsUaa
iFqSO28z6j14sQrURbPH6G3watWf0IeMDvuliMrLDLgLyOsWjzRPNDhinT1z
zY+k8+Y4mX/b2d6a\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213113131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " specify the face opacity:"
}], "ExampleText",
 CellID->94273435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "o", "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"o", ",", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", "0.5", ",", "0.9"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36811579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0.3], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.9], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVm3lcW9eZ96mT7jNtp52ZTmc6XafTeTvTt9OZNrExoAUnjhM7iZ14YZWx
jW3MrstqwOyr2fd9FZvMJhaBQAiEECAJARIIECBA7EJHz9XGkj/yeV9J0DYR
TprwuQg99zyc8/ue/S7PNY+gx56+HkFe9z1+dpnqEfDY6z72szf9qaZTr3zF
xsbG0/Tr8082pu//z/TN8kv++OOPbV7x9PT82PJj8zPzhw3R9Pmq6eTPLZa9
6dPs8orp7znT3xOfi6fW1z519vyp7zc+ka/p0+anltTXTn2//dLUP5ym/q3Z
evXPmkxffmJJ//1p3t81W1/9c/ppHv9q8fndaR7f/xyf3576/L0V+zkr+58t
3r85LfUfrVJfsbJ/ZPH+j9O8f/SFvH91mve/WKW+amX/k8X7l6d5/+QLef/8
k+3yidSvWtk/tHj/5FTJL6xSv2ZlW2rB5senef/qC3n/6DTvX1ulft3K/geL
9w9P8/7NF/L+h1Pv3/4Vb0tb23z/VMnvrFK/YWX/wOL9vdO8/+cLeX/n1PsP
VqnftLItPdPm26dKXrNK/ZaV/XcW72+e5n3hC3t/8ux5K/vbVvb3LP9lPWL/
zVLAh7YB7raBnrZUH1sq1ZYabEsNu0CNuECNPG86Aq1z+pycPzWeLeP9Bzfs
Au/YUe/aUR/bYf52WLAd9tQOe2aHxdthSRex1ItYui2WaYvl2GK5F7C881j+
eWr+69T01wLP9LO/sbK/+5dyz8wBlrH2vRt2AbftqW721PsO2BMHLMABC3PA
ouyxGHssyR5Ls8ey7LBcOyzfDiu6iJVexM5V2GI2X6+6gNVcwGrPY3WvY7Wv
YVV/pBb9IeDM2P5bK/s7Z+r345fMNpax8tMP7QNuO1DdHLB7DpiXRVewAxbh
gMU5YEkOWKoDlumA5dljRfZYqT1WYYdV2WG1F7H6i1iDLdZki9EvYC22WOsF
rPU81vo61mI6XqPS/jfglP27X0iZNY+lf//8pn3ALYfAOwQqhYB5EjAfAoYR
sHAC9oyAJRCwNAKWScByHbBCB6zUAau0x2rsMZo91miHNdthrXZYmx3GuIh1
2mJdF7EeO6zHAWM6YL22WO/rWM8FaufrgWZ933tZTZ7RZz3fWXr9j285BNwm
UO8QMAoRe0TE/IhYMBGLJGIxRCyRiKUTsBwCVkDAiglYuQNW7YDRHLAme4zu
gLUSsA4C1kXEeghYLwHrI2L9JGyAhA2SsHMcMmbz1SFHbIiADdpjpiJ7zwec
qcUTldYzjnUftdT1r2/Z+98mBDoTqK7ETwmNImKxRCyZiGUQsVwiVkjESolY
JTGojhjUQAiiE4NbyEEdjkGdl4KYjkF9l4IGLmGDb2Kcy9jwFYx7BRt5Gxt9
G+NfwfhvY2Om4y2z1lFH6jAhsPeP/idlW4+XM4qtbYvXL247+N8hBLoQqW5E
6t1PV22cWXFQBjE4lxhSSAwtI4VWkcLqyGGN5LAXjuFt5PDON8K73wzvvRLW
/07Y4DthQ1fDuFdDee+G8N8LGb8ePHEjaOI6JvwAE93AzolvYJaxOvkuJrpK
HbscOEw8q/vbL9Vt3T8ss+J/3nHwdzLVtEW3h0k3CfMjYcGkoAhScBwpJJkU
mkEKyyWGFxKflhMjqkkRNHJEEzmixTGy/VJk9xtRzMtRrLcj2Vcjh96N5L4f
MXojYuzDiImbTwW3wkV3wsVOYVPOoVNOITNOwRLnIKmzub6ltzHJTerMB4GT
7waOX/E/Mw+8XL31bG2h+fUdgr8TMcCZGOhKpN4jmdX7koKDSCFPSaExpPAU
0tMMUkQOKaKIHFVGiq4mxdAc45oux7Vcjm9/K7777Xjm2wn91xIG34sfuh7P
+zCefzN+/E680ClW5BIz5Ro94x4loUTOekTMeoTP3Q2TeYTOe4SYx9+5BQpm
8+q8G1XmHCi9FSC65m/N8K2XMlivQ5a+/zsngp8zMcCFGGhuATNDsC8pBCOF
hZPCY0gRiaSo56SYbFJcISm+lJxQTU6iOSY3vZHa8lZq+ztpXdfSmO8/H7ie
PvhB+vCt56O3n485P59wTRO5pYnvpsx4JEvuJUnvJ8g84+cfxs0/il58HCV/
HLH8OHz5UahJx8rDoJUH2PJ96iIlUOYSMPWB35nW+OZLSaxXMMtc83snBz9n
gr+JxHTcJQV5kkK8SaEBpKehpMgoUnQ8KS6VlJBNSi4gpZaQ0yod0+suZTRd
ynxxOav97eyuaznM93P6P8jl3M7l3snlueSOueUIKTmTHjlTD7IlnlnSh5my
xxkLT9IXnzyX+6Qu+ySt+CYo/OIUfjGr/pEmKeu+oes+IWtPsNXHgYoHgfK7
/pI7fmfWvBMe61nHmtqy6vyvk4Ovi5knwNXUwUhB90jBXqSn/qSoEHJsJDkh
lpyUQkrNJKXnkTOLydkVjjk1l3MbruTTr+S3Xy3ofK+QeaOo/2bR4J1irksx
z614jFIs8CgSPyiaelgkfVw4610w75O/6JMv989bCchRULNWAzPWsPR1LFUZ
lLwRFG9Ss4lFbWFPt6nBmwHYhm/g+pOA5Qf+c26+Z6i+8VIqy7xw/s+2k72P
C8HPlehvwnEjYe6kME9SlA8plkpOCCenxpDTEx0znjtm55Bzi8j5ZW8UVr9Z
RLtS0nyttO3dMsb18p4Py1l3KtjOFcNulaOUyvF7lQLPSvHDiimvCql3xZxv
+YJfuTywbIlauoKVrAYXrYcUKkPzN8JzN8Oyt8Izt5+mm5RshyfshMfuhkXt
hIbuBFG3qQEbfv6Kx35iJ2/rPvVyJsuq8vqJ7ULwtdAEmGgopHAPUowXKcGf
nBpCTo8iZ8U75qY65mddKsxzLCl1LKt8s7zuSkXT1aqW96oZN2p6btX2OdWx
XeuGKLSRe7TxBzTBI9rkE9qUD03qR5MF0BawOnlQ7XJwjSK0ei28Svm0YiOi
fCuydDuqePdZ4W50/k5MrknG3rN0VXTq/rPEvcjovYhw1dOg3ZCArUD/VZ+z
rfT1lxJZVvPX79g9cSX4uRH93YjBbqSIu6TYB6Rkb3I6lZwVTs6LIRcmORY/
dyzLvVRe5FhV8UZNzZXa+qs0+nVa+wf1nbcbe52b+t2bOHebufeb+Y/oE150
kQ992p8+E9A8hzXPBzfLQ5uWwxpXIxrWIuqVUbTNaNp2bO1ObPVeXKUqvnw/
vkyVUGzGScjbT8xCCenq+GRVbOx+dMR+VLAq3H872G/Zx8cy7s077M9pm/NO
dk9MDePi4ONGDHEnRbmT4j1IaY9Imf7k3BByQSS5JJ5cnuZYmflGTd6bdaVv
0aquNNRda2q63txyk86409Lj0sKitLLvtXI923iP2ya824V+7VMB7TPU9tng
9vnQNnl423Jk22pk63p0y0ZMy2YcfTu+eTexSZXYsJ9E20+pQyk1KLXSJEuV
WrKfUoBS81BKBkpOUSfGq+Oj1LHB6ii/rTBfM4NZvGUjdwLxGS1k4brg4uDt
SvA1QbkSTFAJFFKaJynLm5RPJZWEk8ujHauSHGvT36TlXGkoerup7Cq95t2W
hhutL261tTl1dLoyej06Bx50DT3qHvHq5vt0C/y7xdTumeDu2ZBuWXj3YkT3
clS3IqZ7PbZrI6FzK4Gxk9Sxm9K+n9q6n9aC0ugovUmT0YAyaCZZ6swqdUa5
OrMEZeSh51koLQ2lJqqTo9QJweoY340wb8t8bAaw3gN+7bPniYtOdl6upkYj
BLsTo9yJie6ENA9SzkNSoS+pLIhcGeFYG+dISyE3ZrxBz7/SUnK1tfL99rob
nU23ulqcuxluPd0eTNaD3sHHfdwnfaO+rIkAlhBjTYf0S8L65572L0Sxlp6x
VmJZa/F9ysTeraTe7VTmblrPfnq3OqMLZTLwrHbIadXktKAcuhkxl6bOrUW5
lSi3DOUUoOwclPUcZSSon0epU4JVsT5SXy8Lwkv3k2eu3i0teNHF/okbAXMn
RprwKMR0E95dQuFjUlkAuSaEXBdFbown09PIrdlvthdcYZS921V9o7v+NpPu
3Nfmxury6O/1HOj3YnO82Ty/QX7goDCIMxnKmXk6NBvJmX/GWYzlLMdz1pIG
15MHN1PZ28/Zu+kD+5n96mwWyunDc5navG48vwsKOzWF7WbCQrq6sBEV1qHC
alRYhgqKUF4uyn2OchJVGRGq5ICtWK+X7xg+g87VIcCNEOFOTDChUYi5HqTi
+6QKL0INldwQRm6OJr9IJHekX+rKvdJddI1ZfqOv9lZ/gzO7xZ3d4cHp8hzq
8xpm+3CH/Ud41JGJEJ4wlDcdMSp5NiqLHl2IG11K4CmSeGspvI3nvO30kZ1M
7l7OsDp3COVxIJ+tLRzQFvXjxX14CRNKuk3KUFm7uqwVldFRaT0qq0GlFftF
RfuF2fv5qSgvHmWH76f5f0E6S++0d7F74uYQ4k6IdSemUog5d4kmusqHpFof
UmMgsTmC3BZLZiQ7dmdc6c27xiq+MVBxi13nzGlyH271GOn05DG9Rvt9+ZwA
Phcb44eMC8LGRRHjM9ET0piJ+YQJefLEcsrE6vNxZcb4Zub4TvbYXh5fncdH
haNQxMNLRrQlw9oyjrZ8EK9gQyXLDFjRjaoYqKp9v6J5v5y2X16NKipReTEq
zUHFaagwRp0TvJ3sdWbf+nmMrqZLbYdId4IJMJtCLLpLrLxPrHtMavIjtQST
O8KJjDhHZsplVuZVdv4NTumt4SrnEZrbaLMHv+3hWJfXeK/vxECAYAgTjoaK
xsImhZGT4uhJSZx4LlG8kCxeShWvpIvXM8Qb2ZPbeZM7+SJVoRAVCTSlE3jp
uLZ8TFfB11aOaqtH8OphqOaYu2hN335Nz34NA9W1o9oWVNuEaupQTQWqKkKV
2ag0GRVF7mf7nWnHr76U0bLHcnCyfehmH+bukEAhZFIIhRRiBYVYd5/Y9JjY
4k/qDCV3Rzn2xV5ipb0zmH2dW3CTV+bEr3Ybq/eYoHsK271E3b6TfQHiAUw8
HDo1+nR6PGpGFD0zHT8jTZTIUiSLaZLlDIkiS7KeI9nMn9kpmNktmt4vmdKU
iaFcrK2c1FWJdDUCXc2Etm4MankaGtekT1M/iBoGUGMfauhGDQzU0IIamlB9
HaqrQLWFqDoDlSeoi0O/BCXB5aKvm320u8NzCqGAQiijEGspxKb7xNYnREYg
sSeM3P/sEjvhynDqNW7OB/zCO+PlroIaD1HDA/ELr6kO3+nugBkWJhkMlXKf
zvKj5gQxMlG8bCZJJk2RzafL5JmylWzZWq5MWSDbKpTtlsj2yuZQ+aymUqqt
luhqZ/S109paEV4ngnoB3iiApnEzZfMIog8jOhvRWYjejZoZqLkVNTWhplrU
WI5o+ajmOap4tpvre6bPnpBaryWWPktwtcPc7ZPcHbIphFIKoYZCbLxLbL1P
ZHgTmVQS66kjJ+YtbuI1Xvr1seybE0Uuk+V3xbUPphu9JC0+UkbAXA8m6w+V
cZ7O86IWxmIWhQmLk0nymRT5XLp8IXNpKWdpJX9pvUC+USzfKZXvli+qKhZR
9YKmeg6vmdXWzepoUn2jVNck0TZP43Qx/mLSTNoyhlp5qJWLWjmolYVamaiV
gVpaUEsjelGDmkpQQzaqTVSXBn0pUje7CHf7dIpDIYVQRSE0UAgvPIiMB8Re
b1I/5sh5enkk9h1+0vWJ9JvCPGdxodtUxX1p3eO5pieyFv/5TmyRGSofeLo0
FLXMi1kZS1gRJinEqQpJumIuU7GYo1jKVygKFMpixUapYqdcsVOxrKpaUtfI
gbasa1zSN8n1TQt6+rzuhUzbOqdtk+Jt02bSdiFiTCAGHzG4qIODGP2og4k6
OlDHC9TegForEb0QNaapqyO+JGmcu30OxaGc4kCjEOh3Ce0eBKYnqd/nEgd7
kxvxzljce4LkD0UZTlP57pKSe3PlnnN1T+ab/OSt1KXOkBVmmGIgSjEUszoa
vzaetC5KXZ9KV0ozlbKcjcWCjeXCjdWSjbXStY2yte3Ktb3adXXdOtSv4U2r
+maFnq7Qt6zo25Z07XJt+4KWIcMZc9A1Y4btnkRdE6ibj7q4qGsIdbNQFxN1
taNOOmLUofZy9CIb1cd9SdJUd/tCikMVxaGR4tB2l9Bzn8h6SOb4vjkSdHks
4pow/oY45fZ0psts/t25Es/5Si95rbe8OXClNXi1K2y9N1LJjt4Yjt/kJ22N
p25PZmxPZ25Lc7dlBduLhZvy4k1F2aaycnurZnu3bltF20YNW9C8iTdv6ls2
DK1KQ/uavl2hY6xoO5e13XK8Zx565sykzGnEnERMIeodQ70jqJeDelmotwcx
21B3I+qqQh0FiJ7yBUktMxLJxdbfzS7d3b6MYl9HcWi569B1j9j7gDz4yHHE
7/JY8NvCiPfF8TclKU7STIos//5i6ePlKp8VWsBqI3W1LVTZFbnZG73Njt8e
Ttrhp+4K0vcmM/fEWTuSvN25gt2lUtVKhWq1UqWsUW3VqfbqVarGPdS8Cy92
ta07hrZtQ8eWgbGp71Lqutd1zFUtcxlnLkHfohm2X4r6JahfjPqFqH8M9Y+g
/kHU34tYXaivBfXWoa5S1JaxVR14hvfVz+UNc7uYQ7Grotg3URza7xKY94ns
h2Su16Uxv8vC4GviyBuS+DuzqW4LmR7y/IfLpd6r1f7rNOpGc+hmS9hGV/RO
X+wuO3FvOEXFS1ONZ+yLsvanCzSzhZr5Us1ShWalUrNeo1HWabbqNXtNGhUd
oRYEbWpdh8rA2NN37Rq6d/Q9W7reTV3vhpa1jvevAnvZzDuwgAZm0aAEccRo
UIA4fMThIg4bDfaggQ7U34R6K1Bn7m5D+GfwWt93/s4J74Vo94tFFLtaiv0L
in0XxaH/HpHjSRr1ekPgf0Uc/N5M5M3ZeOeFVIo868FK/uO1Ul9ldeAmLWSb
Hr7T9myXEb3HjFP1J+5zUvf5mRpBDkwWwEwhPluKz1fgS1XalVrtOg3faMC3
m/E9Oq5qBU0bAEOjYyB9N9L3qA29Kn3frq5/RzewrR3YxAeVMLhm5h2So6EF
NDyLhmcQdxJxBYg7irgcNMxCQ12I8wKxahCzSEWP/jK8v3e5EO9+sYRi10Cx
a6fYMyn2bA8Hnuel8SdvTfpfmwm+MRt5eyHebSn1niLr0Vq+t7LUf6sqaIcW
tkeP2G+LVjNi9/uSNew04Gbi/BydIF8/WaifKTXMVhjmKw1LtcYVmnG9wbDR
bNimG/ZaDfvteg1DD506XQ+uZ4K+T2NgIf2AWsfe13F2tZwdnLNlY74ytvmO
hqtAI3I0soBGZhFvGvEm0eg44vHQCBtxmYjbjgbrEatE1ZbwJXh/63I+yc22
gnKxiWLHoNixKPbDHqSxh28Ivd+ZCnhvNvjmQqSzPJ6iSPVcz/LayPfbKg3c
rQpR0Z6q6c9QW5ymMxH6UnXsDD0328DPMwgKjZMlxply42zlwXzNwRLtYKXh
YL35YIN+sNV6sNd+oGIYNV0G6DHoeg36Pr2+X6dna/WDYHlAZfM9GNkG3oZ5
GzyqQGNyNLaAxqRofAqNC9E4H40NI34/4jEQtwkNlO+0fxnS37icT3OzrXK/
2EKx66HYsSkOPAp54sFl8ZOrEv/r88G35BGuiniPtdSHm1ne2/n+u6VBqqpw
RIvS0GPwtgQdI1Hbl25gZxmHcw/5BYeCkqPJsqPpyqPZmqP5umN5w/FK8/Ea
/VjZerTVfrTHOFZ1HSPmEfQd6liHun6j5Y7A3+uGce2IRstT46Mq4O8Bf9vM
Or6GJhRIIEeCeSSQIIEYCSaQYARNDKKxbsR7gTiV660xX4zVcs327262te62
bZSLvRSHIQqJT3GcvHd55vG7Mr8PFoOdFBHua3EPNlO8tjP9dvOx/dJgVPUU
pz3TNcfr2pIMjBRDb8YhO+dwuOCIX3w0UXo0WXE0XXMsrTuerz+WN3+0Qv9o
rfUjZfvxFuN4t/tYxTxCfUcWvn/UDR3oho26EYOOp9OO6rR8wMcQTOxrJnY1
AgurcA2JVpBoEU3K0OQMEomQiI+EQ0jQi8baELfaejf8OZS/dLtAc7dtp1zs
p9iNUIjjlEtijyuzj96d97u5HOSyGnF3I85zO8V7L9N/Pz9IUxKmrYzS0mL1
zUmG1pSDjufG3uxDdv7RcOHRaOnxePlHk9UfTdd+JK3/SNb00SL9o+XWj1bb
P1IyPtrq+shStM2PgH2Ec460Q0fa4UMd71A/eqDjG7Rjeu24FhdoQYA0wn2N
aA9NWkjFq2hqGU3Po+lZNCVGUxNokotELDTRjkbqztzpfuWzOX/mdr7e/UIn
xXaAcpFHcRDedZzxeHvu4fUl39srmJsy4v527OO9ZN/9DKomLwQvjtBVPDPU
xR80JR22Pj/sSD9k5hwP5B8PFR+Plh+PVR6Lao+naMeSxmMZ/Xix5Xi5/dhC
9+Md1vEe61jNPtZwjvGhYy33WMs70vGP9GOHuvFD7YRRK9TjQh2IcM0k0oj3
0dQemrGQShRIIkeSOSSZRhIhmuYh8QASMNBo/csprZ+9Wu5U/tj1fIP7hW6K
7SDFlk+xm/S4JL1/deHBB8ved9Yx982nD3ZjvPaT/FA6hueF6YojDRWxB3WJ
h02phy3ph+1ZBz35RwNFR5yyI17F0VjNkbDuWNxwbJlVfqroPFb2HG+wjk2I
u+xjFedIM3QE3COdhU83dmTi0wkPtaJDXHiAT+phSquZBs0MQpJ9JNlF0k0z
5ewyml1As1IkFSHJKJoeRKKu/dH6z2jJlzL+yPX1erfzPZQLQxTbcQphyuON
2ftX5Z4frnq7bFDvboc/VEX7aBID8PRgXe5TQ9Gzg/K4g9qkg4a0w5bMw7Zs
Y3fBYX/JIaf8iFt1dNInfzlDP5ptPVpgHC11Hq30HK33HW2wjrbYR7ucI9XQ
EeIeaUaPtPxDnakRJ04htZMHuPgAnzbCjEEj1SEJjmY1aE6F5iytKVMgmRzJ
ZtGcGM2OIwkHiXt2eZ/VY1/K+Y/Of6xye53pfn6YcnGcQpq+e3n+3rtL92+u
eblsBnjshj7af+YDCVTd8xB9doShMMZQnmCsSTmoTz94kX3QmmvsLjq00P37
KO1Q0HQoaj6cbj2UdhzOM47k3UfLvUerrEMl+3CTc7g7dLjHPVSPHmr4hzB+
wnigFR1oTYBTFkaJAaQmTD2a0yGZBs3vo4VdtGBZYxaX0IIMzU8j2QSSDqEp
5tZIzRejtDzz/r6rBdHdTkAhT1OuLHi8t3L/tvKx27b/fVWIF4r0w+MxXWqY
PitKnx9nKEsyVqcaaRknK8F/9JUdDFQfDNUejtYfjjcfiloOp9rMiLLuw0Xm
4VLfoaL/cH3wcGPocId7uMs7VPEP0PiBZsIMp7PwaaeM+IwRlxrBdMzqNTI9
mtehBRwtIiRXIfk2kivNlPJ5tDiN5gVodlg11W397OBz+L7j+lqX2+tcdzsh
hSShvLVAub56//bGQ/cd3wfqoCeaCH9tXJAuJVyX+UxvGWf/2ZxrfJFv6Cw1
MisPBmoPOLQDXuPBGP1A2How2XEw03Uw13Ow0HcgZx2ssA/Whw6UwwdbvIMd
/sHe2IF64gAJD0Bk1ImNJ2RaqRGfNcCcQTOv1yzo0KIOyXG0pEFL+2h5By0r
0bLCwidBC0I0N7Ir7jrzZORz6L7t8sd2t9dG3C+K3ImzlCuLJjqPO5sPKHve
nmrMG54Gak9G2E/y4vXFKYaKdENdjqEx30Av0jPKjN1VRlatcbDByG0yjr4w
CtqNIoZxuvtA2nsgYx0ssg+Whw5Wh43rPOPmqHFnzLg7YdwXGpHIqBEb8Smj
dsaASw3n8DmDzXfBhGdmMx1atIyjZQ1aUSPFHlJsopVVtLJo6aoi1dzwmqDl
Mwg/+azB8q7V113/OORmK3InzLm/tUR5f43itHX/7t4J0e+fhWgTI3TPY3U5
ifrCNH15pr4mR99QYGgu0rVXGLpqDH11hoFG4xDdyGsxjrcbhV3GqR6jpNc4
N2BcGDQuDRlXuMa1UaNyzLg1btwRGvdEBrXYgKYMGgsXPqfHZXpY0MOiXmPi
WtKZuVYAKTRodR+t7qLVLbS6hhRytDxrUrQ7O3TmXYNzL+d61eUPbNfzQjeH
OffLSxaaPzx+uO/nAyFUPDJUGx+pTY3VZSXp8tN0pVm6qjw9rUjfVKxtrdR3
1hiY9Yb+RgPnhWGkzcBnGATdBlGvYYZlkLANMo5hYdiwzDMoRg3r44YNgWFb
ZNiZNOxNGdQzeiTVayxM+IIO5DoTk2ZZi1a0SKFFq4DWNGh9H63vofVttLaO
VpfQivlye32G9cWoLKPndff3lXfvbJtayfOR2scXMCoeEYbHRuHJcdqMZG3e
c21xlq4iT1dbrGso0b6o1nfU6rsa9H3NenarfrhNz+vUTzD1wl79VL9hhmOY
GzIsjOjlo/qVMf3qhH5dqN8Q6bfF+p0ZvUqq35/VqWU6jYUG5NpTmlUcreFo
HZBSg5RqpFSplTtofR2tLatWZncWxi2XIX+VyDy6LC3z36Yvzn8YcbWVuL25
7Pae0v3OrgdF9eAReuILgVQIC4Nnz/CEODw9Bc9J1xZka8sKtNVF2roynF6l
a6XpOht1TLqO1abjdOhHuvR8pl7A0osG9NMcvYSrl/H083z90rh+RahfE+qU
Yt3WtG5bqtuZ1anmdKp57f6iVm0eUVqNAj9BewUpweabSIksaLtIqdxfW9pd
lihmuSfyX/68/lN03zmls9wT+a3La9Oul+Ru15Rut3fcKfv3Hmoe+YAvFYLC
IOIZxMVDSjKekY7nZeMlBXhlibamHBqrtS9o2o5GbdcLXV+rjs3QDfXoeEzd
eL9OMKgTc3TTXN0sTyfj6xYmdEtC3cqkbm1ap5RoN6Xa7Tntzrx2b1G7J8dV
y7hKgatXQb0ONudMZOfQBth8DW1q1BvqfeXuvlK5s7qolE9Z7ymtd9hnGf/0
dqTlaezvnP5nzIW44Hpt3e3mrpub2t0TPH3BGwNqOIRFQ3Q8JKbA8wzIyYHC
Qry0BK8q19BqcHqDtrVJy2jRMtu1LIZ2sEfL7dOO9msnBrXCYe3UiHZmVDs7
ppUJtIsi7ZJYuzKjXZNo12e1G/P41iK+Lcd3lvHdFdhdhd11UClBrQQz4Dm0
aaJUb8L+JlIpd3fW1zZW5uekPOu7NdZXS3+i/MuZr5+OPMuM+n+dz8+4vLXq
+sGOmxuieGo8fDSPqOAbBkHP4Gk8xKZASgZk5EJuIRSXQlm5prYWGupxejPe
0YJ3tuO9XfgAE+f04SNsnD+IT3BxEQ+f4uMzE/icEJdN4ovT+JIEX5HiqzJ8
fQGUcthcgq0V2F6FnTXYVsKuEvY2QLUJr6i2TJfDe5toW7m9sbYql89YPwv4
62x/ek5rWen+y5ksd3l/y9VZ7XZf4/FEcz9Q4xUKgVEQFg/PUiAhA9JyIbsA
CkqhuBxV1QKtHpqboaUFOtqhpwt6mcBm4UMD+AgHH+PiEzx8cgyfEoBEBLNi
kM3AogSW5mB5HhSLsCaHtWVQKmBjDTaVsKWE7Q3Y3oRzOyaqr25vwfaWZnND
vabclK/I/+rbWF85IfvL26unXJa14De3/0fo/Paay22Vy13k6qWhBGg8Q8A7
ErA4eJoMMemQlAPpBZBTCgXlqLwOquuhvhmaW6CtAxhd0MOEvn5gD8DQEIyM
wNgoTIzDpBDEIpBMwawE5qSwIAP5AsjlsLIEihVYXYW1dVhTgnIDzm2YqDbN
VMotWN9ECuXewurahFR05o04a/uEygxleVf8N3cc5pyvb7m4qV0eIlc/uBcM
jyPBPw5CkiEyHeJyILUA0ktQbiUU10JFA9TQoaEF6B3Q3gUMJjD7gcWGwWEY
HgEeH/jjMCEA0SSIp2FGAtJZmJ0H2SIsyGFhGZYUsLQGy+ugUIJiA1ZN/W3V
3N8Um5olpVq2tiWYn7OeIaxb6US/+a6U5W3e/7hzecnpjsr5HnLxBgoV7j2F
xzEQkAShz+FZNiQUQHIxyqqA/FoorodKOtS2QmMH0LugrRc6+6FnEFhcYPNg
iA8jE8AXwrgYhDMwKYWpOZhZAIkcpEsgW4H5VZhfhwUlLCpBbmqBJVMLyE3z
wSsyJZKu7U0sLp/ZH1m/k3Cq3eqsJR7g17evrjm57Ts90jgHgHso3HsG3glA
TYPwLIjOh/gilFYBWTVQUA+lzVDZArUd0NAF9F5o64dODvRwgTUK7DHgCIAr
At4UjElAIAWhDCYXYEoO00swswLSVZhdhzklyEyHeUaTmQhendsAqVIjXlWN
LCisV6GXM7w0puGXt95bu+OBnHzAKQhcIuBBLPikAJYB4bkQVYCSyuF5DWTV
Q0EzlLZARQfUdkFDL9BZ0DoIDC5086BvDPoFMCiC4SkYkcDoLIzJYGIBBHIQ
LsPkCohXQbxm0j1tWk2/NqOE6Q2YUoJ4HcYV6gHZqvX7udaz12nv//jkjR9L
D/r5bU/NnQC4Ew7uMeCZBD7pgOVAaD6KLoOkanheB1lNUPACSjqgvAtqeqGe
Bc2D0MKFDh50jgFTAH0iGJiCQQkMzQJXBrwF4MthbAnGVmBCAQKzXqFpoXxV
qATBOvBXYWQZfd9KmfUacqLUuvYt9fyrW480t6ngHAHucfAgBbyzIDAPhZdA
dCUk1kJaI2S+gPx2KO6EciZUs4A2CI3DQOdB2xgwBNAlAuYU9EmgXwpsGXAW
YEgOw0vAXYaRFeCtwuiq+XNkFTgrwJJrbKyjZcxav2IyzRpPdH79tEYtcTM/
uflg71YQOD0D10S4lw6Ps1FgEYSWQ1Q1JDRAajNktEEuAwp7oJQFlWyoHQba
CDTxgT4BbSJoF0PnDHRLgDkHvfPQtwj9chhYAvYSnGMvm0YcawmYcqBL9mxe
FpnzaWXWs7qlBv/5JlVzKxqck8EtAz3KB/8SCK6CiDqIa4LEFkjrgOxuyO+D
ogEo40AlF2pGgTYOjQJonoSWKWiVQJsUOuagcx66FuBc16JJVecitM9Ds1Rz
EoXzuaq+9cke+MMPojQ3k5BzFtwvAO8yCKyGsHqIaobYNkhmQDoTslmQx4bC
YSgZgXI+VE1AjRBok0CbhoYZaJKYSjX1seZZk4oGKVRPayyQVirOnVFhPV9Z
6uYHJvtGmOpmOrjkw/1S8K6GwHoIpUNUO8R2QiITUlmQwYbsIcgdgQI+FI1D
iQDKhKbCyydNHyUiOM3vXy1D8JPrp3mfe7JjsJ5nrOvM4vU3twrAvQIe1oFv
E2AtEMaAyG6I7oW4fkhkQ8oQpHHh3PMRU6mp3D+Vaolc+1TMyUmJf4rSsS7p
j5+w/6LPOh7hH6zsP8WznXj/3an1Mq9P5n1S7z+w8rKeC14/ze3E++8//kRc
m1Xer/zZy3okWM+E5gg6c1Oc3NP+oVWq9ZWVOabKXIUnbxb/06kCa6//c+p1
EgVh3d+s72b926mCk0ilf/n4bDyg+evPTvM8iR/7V6tU693Mv5zmeRKvZx0d
Z713+OFp3icxhz89VWDt9YNTr19avH5ulfqyZ+5mBZYIN5tfnOZp7fWt0zz/
y+Jlia86My6+cerz3xafX53m9Mlro3OnZVnizGx+fWpZIsNsbL7y/wGaCN1X
\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->19353714]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11359],

Cell["Platonic polyhedrons represented by spheres:", "ExampleText",
 CellID->27289629],

Cell[BoxData[
 RowBox[{
  RowBox[{"vc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"#", ",", "\"\<VertexCoordinates\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69733258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Specularity", "[", 
         RowBox[{"White", ",", "30"}], "]"}], ",", "Orange", ",", 
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{"#", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Sphere", "[", "i", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "#", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], "&"}], "/@", "vc"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250350978],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], {SphereBox[1], SphereBox[2], 
       SphereBox[3], SphereBox[4], SphereBox[5], SphereBox[6], SphereBox[7], 
       SphereBox[8]}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], Rational[
         1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
         Rational[1, 2], Rational[-1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[3, 4] + 
          Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 0, 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
         Rational[1, 2], 
         0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
        0, 0, -1.4012585384440737`}, {
        0.17841104488654497`, -1.3090169943749475`, 0.46708617948135783`}, {
        0.17841104488654497`, 1.3090169943749475`, 0.46708617948135783`}, {
        0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
        0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
        1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
        1.0444364486709836`, 0.8090169943749475, 
        0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
        0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
        0.46708617948135783`}, {
        1.2228474935575286`, -0.5, -0.46708617948135783`}, {
        1.2228474935575286`, 
        0.5, -0.46708617948135783`}, {-0.9341723589627157, 
         0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
        0.8090169943749475, 1.0444364486709836`}, {
        0.9341723589627157, 0, 
         1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
        0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
        1.3090169943749475`, -0.46708617948135783`}}], {SphereBox[1], 
       SphereBox[2], SphereBox[3], SphereBox[4], SphereBox[5], SphereBox[6], 
       SphereBox[7], SphereBox[8], SphereBox[9], SphereBox[10], SphereBox[11],
        SphereBox[12], SphereBox[13], SphereBox[14], SphereBox[15], 
       SphereBox[16], SphereBox[17], SphereBox[18], SphereBox[19], 
       SphereBox[20]}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
        0, 0, 5 (50 - 10 5^Rational[1, 2])^
          Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
         0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
          Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), Rational[
         1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
        0, 0, -0.9510565162951536}, {
        0, 0, 0.9510565162951536}, {-0.85065080835204, 
         0, -0.42532540417601994`}, {
        0.85065080835204, 0, 0.42532540417601994`}, {
        0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868,
         0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
        0.42532540417601994`}, {-0.6881909602355868, 0.5, 
        0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
        0.8090169943749475, -0.42532540417601994`}, {
        0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
        0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], {
       SphereBox[1], SphereBox[2], SphereBox[3], SphereBox[4], SphereBox[5], 
       SphereBox[6], SphereBox[7], SphereBox[8], SphereBox[9], SphereBox[10], 
       SphereBox[11], SphereBox[12]}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
        Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
        0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
        Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5, 
         0}, {0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {
        0.5, -0.5, 0}, {0.5, 0.5, 0}}], {SphereBox[1], SphereBox[2], 
       SphereBox[3], SphereBox[4], SphereBox[5], SphereBox[6]}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
         Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
        0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
        0.5773502691896258, 0, -0.20412414523193154`}}], {SphereBox[1], 
       SphereBox[2], SphereBox[3], SphereBox[4]}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}],
  Row[{
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
         Rational[-1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2]}, {
         Rational[-1, 2], 
         Rational[-1, 2], 
         Rational[1, 2]}, {
         Rational[-1, 2], 
         Rational[1, 2], 
         Rational[-1, 2]}, {
         Rational[-1, 2], 
         Rational[1, 2], 
         Rational[1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[1, 2]}, {
         Rational[1, 2], 
         Rational[1, 2], 
         Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[1, 2], 
         Rational[1, 2]}}, {
        Sphere[1], 
        Sphere[2], 
        Sphere[3], 
        Sphere[4], 
        Sphere[5], 
        Sphere[6], 
        Sphere[7], 
        Sphere[8]}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[3, 4] + 
          Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 0, 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
         Rational[1, 2], 
         0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}}, {
        Sphere[1], 
        Sphere[2], 
        Sphere[3], 
        Sphere[4], 
        Sphere[5], 
        Sphere[6], 
        Sphere[7], 
        Sphere[8], 
        Sphere[9], 
        Sphere[10], 
        Sphere[11], 
        Sphere[12], 
        Sphere[13], 
        Sphere[14], 
        Sphere[15], 
        Sphere[16], 
        Sphere[17], 
        Sphere[18], 
        Sphere[19], 
        Sphere[20]}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
        0, 0, 5 (50 - 10 5^Rational[1, 2])^
          Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
         0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
          Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), 
         Rational[
         1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
          5^Rational[1, 2]), 
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {(
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {
        Sphere[1], 
        Sphere[2], 
        Sphere[3], 
        Sphere[4], 
        Sphere[5], 
        Sphere[6], 
        Sphere[7], 
        Sphere[8], 
        Sphere[9], 
        Sphere[10], 
        Sphere[11], 
        Sphere[12]}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
         Rational[-1, 2], 
         Rational[-1, 2], 0}, {
         Rational[-1, 2], 
         Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
        0, 0, 2^Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 0}, {
         Rational[1, 2], 
         Rational[1, 2], 0}}, {
        Sphere[1], 
        Sphere[2], 
        Sphere[3], 
        Sphere[4], 
        Sphere[5], 
        Sphere[6]}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, Rational[2, 3]^Rational[1, 2] + 
         Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], 
         Rational[-1, 2], Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], 
         Rational[1, 2], Rational[-1, 2] 6^Rational[-1, 2]}, {
        3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {
        Sphere[1], 
        Sphere[2], 
        Sphere[3], 
        Sphere[4]}]}, Boxed -> False]}]]], "Output",
 ImageSize->{504, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->457137421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131480501],

Cell["Double helix:", "ExampleText",
 CellID->508542850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "30"}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "=", 
            RowBox[{"2", 
             RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
           RowBox[{"y", "=", 
            RowBox[{"2", 
             RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
           RowBox[{"p", "=", 
            RowBox[{"2", 
             RowBox[{"Sin", "[", 
              RowBox[{"t", "+", " ", "Pi"}], "]"}]}]}], ",", 
           RowBox[{"q", "=", 
            RowBox[{"2", 
             RowBox[{"Sin", "[", 
              RowBox[{"t", "+", " ", "Pi"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"t", "/", 
             RowBox[{"(", 
              RowBox[{"5", "Pi"}], ")"}]}], "]"}], ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "t"}], "}"}], ",", ".3"}], "]"}], 
           ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"p", ",", "q", ",", "t"}], "}"}], ",", ".3"}], "]"}], 
           ",", 
           RowBox[{"Cylinder", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "y", ",", "t"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"p", ",", "q", ",", "t"}], "}"}]}], "}"}], ",", 
             ".1"}], "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"5", "Pi"}], ",", ".3"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140034873],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    GrayLevel[1], 30], 
   {Hue[0.], SphereBox[{2., 0., 0.}, 0.3], 
    SphereBox[{2.4492935982947064`*^-16, 2.4492935982947064`*^-16, 0.}, 0.3], 
    CylinderBox[{{2., 0., 0.}, {2.4492935982947064`*^-16, 
     2.4492935982947064`*^-16, 0.}}, 0.1]}, 
   {Hue[0.01909859317102744], 
    SphereBox[{1.910672978251212, 0.5910404133226791, 0.3}, 0.3], 
    SphereBox[{-0.5910404133226785, -0.5910404133226785, 0.3}, 0.3], 
    CylinderBox[{{1.910672978251212, 0.5910404133226791, 
     0.3}, {-0.5910404133226785, -0.5910404133226785, 0.3}}, 0.1]}, 
   {Hue[0.03819718634205488], 
    SphereBox[{1.6506712298193567`, 1.1292849467900707`, 0.6}, 0.3], 
    SphereBox[{-1.1292849467900707`, -1.1292849467900707`, 0.6}, 0.3], 
    CylinderBox[{{1.6506712298193567`, 1.1292849467900707`, 
     0.6}, {-1.1292849467900707`, -1.1292849467900707`, 0.6}}, 0.1]}, 
   {Hue[0.057295779513082325`], 
    SphereBox[{1.243219936541329, 1.5666538192549666`, 0.8999999999999999}, 
     0.3], SphereBox[{-1.566653819254967, -1.566653819254967, 
     0.8999999999999999}, 0.3], 
    CylinderBox[{{1.243219936541329, 1.5666538192549666`, 
     0.8999999999999999}, {-1.566653819254967, -1.566653819254967, 
     0.8999999999999999}}, 0.1]}, 
   {Hue[0.07639437268410976], 
    SphereBox[{0.7247155089533472, 1.8640781719344526`, 1.2}, 0.3], 
    SphereBox[{-1.8640781719344528`, -1.8640781719344528`, 1.2}, 0.3], 
    CylinderBox[{{0.7247155089533472, 1.8640781719344526`, 
     1.2}, {-1.8640781719344528`, -1.8640781719344528`, 1.2}}, 0.1]}, 
   {Hue[0.09549296585513722], 
    SphereBox[{0.1414744033354058, 1.994989973208109, 1.5}, 0.3], 
    SphereBox[{-1.994989973208109, -1.994989973208109, 1.5}, 0.3], 
    CylinderBox[{{0.1414744033354058, 1.994989973208109, 
     1.5}, {-1.994989973208109, -1.994989973208109, 1.5}}, 0.1]}, 
   {Hue[0.11459155902616465`], 
    SphereBox[{-0.4544041893861738, 1.9476952617563905`, 1.7999999999999998`},
      0.3], SphereBox[{-1.9476952617563905`, -1.9476952617563905`, 
     1.7999999999999998`}, 0.3], 
    CylinderBox[{{-0.4544041893861738, 1.9476952617563905`, 
     1.7999999999999998`}, {-1.9476952617563905`, -1.9476952617563905`, 
     1.7999999999999998`}}, 0.1]}, 
   {Hue[0.1336901521971921], 
    SphereBox[{-1.0096922091997151`, 1.7264187332977474`, 2.1}, 0.3], 
    SphereBox[{-1.726418733297748, -1.726418733297748, 2.1}, 0.3], 
    CylinderBox[{{-1.0096922091997151`, 1.7264187332977474`, 
     2.1}, {-1.726418733297748, -1.726418733297748, 2.1}}, 0.1]}, 
   {Hue[0.15278874536821951`], 
    SphereBox[{-1.4747874310824909`, 1.350926361102302, 2.4}, 0.3], 
    SphereBox[{-1.3509263611023015`, -1.3509263611023015`, 2.4}, 0.3], 
    CylinderBox[{{-1.4747874310824909`, 1.350926361102302, 
     2.4}, {-1.3509263611023015`, -1.3509263611023015`, 2.4}}, 0.1]}, 
   {Hue[0.17188733853924695`], 
    SphereBox[{-1.808144284034122, 0.8547597604676603, 2.6999999999999997`}, 
     0.3], SphereBox[{-0.8547597604676613, -0.8547597604676613, 
     2.6999999999999997`}, 0.3], 
    CylinderBox[{{-1.808144284034122, 0.8547597604676603, 
     2.6999999999999997`}, {-0.8547597604676613, -0.8547597604676613, 
     2.6999999999999997`}}, 0.1]}, 
   {Hue[0.19098593171027445`], 
    SphereBox[{-1.9799849932008908`, 0.2822400161197344, 3.}, 0.3], 
    SphereBox[{-0.2822400161197347, -0.2822400161197347, 3.}, 0.3], 
    CylinderBox[{{-1.9799849932008908`, 0.2822400161197344, 
     3.}, {-0.2822400161197347, -0.2822400161197347, 3.}}, 0.1]}, 
   {Hue[0.21008452488130186`], 
    SphereBox[{-1.9749595398177298`, -0.3154913882864964, 3.3}, 0.3], 
    SphereBox[{0.31549138828649614`, 0.31549138828649614`, 3.3}, 0.3], 
    CylinderBox[{{-1.9749595398177298`, -0.3154913882864964, 3.3}, {
     0.31549138828649614`, 0.31549138828649614`, 3.3}}, 0.1]}, 
   {Hue[0.2291831180523293], 
    SphereBox[{-1.7935168326682944`, -0.8850408865897041, 
     3.5999999999999996`}, 0.3], 
    SphereBox[{0.8850408865897039, 0.8850408865897039, 3.5999999999999996`}, 
     0.3], CylinderBox[{{-1.7935168326682944`, -0.8850408865897041, 
     3.5999999999999996`}, {0.8850408865897039, 0.8850408865897039, 
     3.5999999999999996`}}, 0.1]}, 
   {Hue[0.24828171122335674`], 
    SphereBox[{-1.4518646084002804`, -1.3755323183679475`, 3.9}, 0.3], 
    SphereBox[{1.375532318367948, 1.375532318367948, 3.9}, 0.3], 
    CylinderBox[{{-1.4518646084002804`, -1.3755323183679475`, 3.9}, {
     1.375532318367948, 1.375532318367948, 3.9}}, 0.1]}, 
   {Hue[0.2673803043943842], 
    SphereBox[{-0.9805216426813989, -1.7431515448271764`, 4.2}, 0.3], 
    SphereBox[{1.7431515448271762`, 1.7431515448271762`, 4.2}, 0.3], 
    CylinderBox[{{-0.9805216426813989, -1.7431515448271764`, 4.2}, {
     1.7431515448271762`, 1.7431515448271762`, 4.2}}, 0.1]}, 
   {Hue[0.2864788975654116], 
    SphereBox[{-0.4215915988615594, -1.955060235330194, 4.5}, 0.3], 
    SphereBox[{1.955060235330194, 1.955060235330194, 4.5}, 0.3], 
    CylinderBox[{{-0.4215915988615594, -1.955060235330194, 4.5}, {
     1.955060235330194, 1.955060235330194, 4.5}}, 0.1]}, 
   {Hue[0.30557749073643903`], 
    SphereBox[{0.1749979668788928, -1.9923292176716814`, 4.8}, 0.3], 
    SphereBox[{1.9923292176716814`, 1.9923292176716814`, 4.8}, 0.3], 
    CylinderBox[{{0.1749979668788928, -1.9923292176716814`, 4.8}, {
     1.9923292176716814`, 1.9923292176716814`, 4.8}}, 0.1]}, 
   {Hue[0.3246760839074665], 
    SphereBox[{0.7559554854259605, -1.851629364655465, 5.1}, 0.3], 
    SphereBox[{1.851629364655465, 1.851629364655465, 5.1}, 0.3], 
    CylinderBox[{{0.7559554854259605, -1.851629364655465, 5.1}, {
     1.851629364655465, 1.851629364655465, 5.1}}, 0.1]}, 
   {Hue[0.3437746770784939], 
    SphereBox[{1.2693857518852678`, -1.5455289751119754`, 
     5.3999999999999995`}, 0.3], 
    SphereBox[{1.5455289751119767`, 1.5455289751119767`, 5.3999999999999995`},
      0.3], CylinderBox[{{1.2693857518852678`, -1.5455289751119754`, 
     5.3999999999999995`}, {1.5455289751119767`, 1.5455289751119767`, 
     5.3999999999999995`}}, 0.1]}, 
   {Hue[0.36287327024952143`], 
    SphereBox[{1.6694255696783196`, -1.1013710851952752`, 5.7}, 0.3], 
    SphereBox[{1.101371085195277, 1.101371085195277, 5.7}, 0.3], 
    CylinderBox[{{1.6694255696783196`, -1.1013710851952752`, 5.7}, {
     1.101371085195277, 1.101371085195277, 5.7}}, 0.1]}, 
   {Hue[0.3819718634205489], 
    SphereBox[{1.920340573300732, -0.5588309963978517, 6.}, 0.3], 
    SphereBox[{0.5588309963978519, 0.5588309963978519, 6.}, 0.3], 
    CylinderBox[{{1.920340573300732, -0.5588309963978517, 6.}, {
     0.5588309963978519, 0.5588309963978519, 6.}}, 0.1]}, 
   {Hue[0.40107045659157625`], 
    SphereBox[{1.9997172727668302`, 0.033627800968699426`, 6.3}, 0.3], 
    SphereBox[{-0.03362780096870096, -0.03362780096870096, 6.3}, 0.3], 
    CylinderBox[{{1.9997172727668302`, 0.033627800968699426`, 
     6.3}, {-0.03362780096870096, -0.03362780096870096, 6.3}}, 0.1]}, 
   {Hue[0.4201690497626037], 
    SphereBox[{1.9004651839170592`, 0.6230827270267557, 6.6}, 0.3], 
    SphereBox[{-0.6230827270267555, -0.6230827270267555, 6.6}, 0.3], 
    CylinderBox[{{1.9004651839170592`, 0.6230827270267557, 
     6.6}, {-0.6230827270267555, -0.6230827270267555, 6.6}}, 0.1]}, 
   {Hue[0.43926764293363113`], 
    SphereBox[{1.6314502002507147`, 1.1568795287763989`, 6.8999999999999995`},
      0.3], SphereBox[{-1.1568795287763973`, -1.1568795287763973`, 
     6.8999999999999995`}, 0.3], 
    CylinderBox[{{1.6314502002507147`, 1.1568795287763989`, 
     6.8999999999999995`}, {-1.1568795287763973`, -1.1568795287763973`, 
     6.8999999999999995`}}, 0.1]}, 
   {Hue[0.4583662361046586], 
    SphereBox[{1.2167026290645104`, 1.5873357276983053`, 7.199999999999999}, 
     0.3], SphereBox[{-1.587335727698305, -1.587335727698305, 
     7.199999999999999}, 0.3], 
    CylinderBox[{{1.2167026290645104`, 1.5873357276983053`, 
     7.199999999999999}, {-1.587335727698305, -1.587335727698305, 
     7.199999999999999}}, 0.1]}, 
   {Hue[0.477464829275686], 
    SphereBox[{0.6932706356700516, 1.8759999535494778`, 7.5}, 0.3], 
    SphereBox[{-1.8759999535494776`, -1.8759999535494776`, 7.5}, 0.3], 
    CylinderBox[{{0.6932706356700516, 1.8759999535494778`, 
     7.5}, {-1.8759999535494776`, -1.8759999535494776`, 7.5}}, 0.1]}, 
   {Hue[0.4965634224467135], 
    SphereBox[{0.1079108411252995, 1.99708669074921, 7.8}, 0.3], 
    SphereBox[{-1.99708669074921, -1.99708669074921, 7.8}, 0.3], 
    CylinderBox[{{0.1079108411252995, 1.99708669074921, 
     7.8}, {-1.99708669074921, -1.99708669074921, 7.8}}, 0.1]}, 
   {Hue[0.5156620156177409], 
    SphereBox[{-0.4870883074715822, 1.9397796216901726`, 8.1}, 0.3], 
    SphereBox[{-1.9397796216901728`, -1.9397796216901728`, 8.1}, 0.3], 
    CylinderBox[{{-0.4870883074715822, 1.9397796216901726`, 
     8.1}, {-1.9397796216901728`, -1.9397796216901728`, 8.1}}, 0.1]}, 
   {Hue[0.5347606087887684], 
    SphereBox[{-1.0385773082333711`, 1.7091978161765609`, 8.4}, 0.3], 
    SphereBox[{-1.709197816176561, -1.709197816176561, 8.4}, 0.3], 
    CylinderBox[{{-1.0385773082333711`, 1.7091978161765609`, 
     8.4}, {-1.709197816176561, -1.709197816176561, 8.4}}, 0.1]}, 
   {Hue[0.5538592019597958], 
    SphereBox[{-1.4972932911947974`, 1.3259384601643667`, 8.7}, 0.3], 
    SphereBox[{-1.325938460164367, -1.325938460164367, 8.7}, 0.3], 
    CylinderBox[{{-1.4972932911947974`, 1.3259384601643667`, 
     8.7}, {-1.325938460164367, -1.325938460164367, 8.7}}, 0.1]}, 
   {Hue[0.5729577951308232], 
    SphereBox[{-1.8222605237693539`, 0.8242369704835132, 9.}, 0.3], 
    SphereBox[{-0.8242369704835134, -0.8242369704835134, 9.}, 0.3], 
    CylinderBox[{{-1.8222605237693539`, 0.8242369704835132, 
     9.}, {-0.8242369704835134, -0.8242369704835134, 9.}}, 0.1]}, 
   {Hue[0.5920563883018507], 
    SphereBox[{-1.9844506509052064`, 0.24890884701412694`, 9.299999999999999},
      0.3], SphereBox[{-0.24890884701412716`, -0.24890884701412716`, 
     9.299999999999999}, 0.3], 
    CylinderBox[{{-1.9844506509052064`, 0.24890884701412694`, 
     9.299999999999999}, {-0.24890884701412716`, -0.24890884701412716`, 
     9.299999999999999}}, 0.1]}, 
   {Hue[0.6111549814728781], 
    SphereBox[{-1.969375711588254, -0.3486535624459593, 9.6}, 0.3], 
    SphereBox[{0.348653562445959, 0.348653562445959, 9.6}, 0.3], 
    CylinderBox[{{-1.969375711588254, -0.3486535624459593, 9.6}, {
     0.348653562445959, 0.348653562445959, 9.6}}, 0.1]}, 
   {Hue[0.6302535746439056], 
    SphereBox[{-1.7783823052507217`, -0.9150717875506427, 9.9}, 0.3], 
    SphereBox[{0.9150717875506426, 0.9150717875506426, 9.9}, 0.3], 
    CylinderBox[{{-1.7783823052507217`, -0.9150717875506427, 9.9}, {
     0.9150717875506426, 0.9150717875506426, 9.9}}, 0.1]}, 
   {Hue[0.649352167814933], 
    SphereBox[{-1.4285313040544005`, -1.3997493751870846`, 10.2}, 0.3], 
    SphereBox[{1.3997493751870846`, 1.3997493751870846`, 10.2}, 0.3], 
    CylinderBox[{{-1.4285313040544005`, -1.3997493751870846`, 10.2}, {
     1.3997493751870846`, 1.3997493751870846`, 10.2}}, 0.1]}, 
   {Hue[0.6684507609859605], 
    SphereBox[{-0.951073855991985, -1.75939151994334, 10.5}, 0.3], 
    SphereBox[{1.75939151994334, 1.75939151994334, 10.5}, 0.3], 
    CylinderBox[{{-0.951073855991985, -1.75939151994334, 10.5}, {
     1.75939151994334, 1.75939151994334, 10.5}}, 0.1]}, 
   {Hue[0.6875493541569878], 
    SphereBox[{-0.3886598129106731, -1.9618724601329824`, 
     10.799999999999999`}, 0.3], 
    SphereBox[{1.9618724601329824`, 1.9618724601329824`, 10.799999999999999`},
      0.3], CylinderBox[{{-0.3886598129106731, -1.9618724601329824`, 
     10.799999999999999`}, {1.9618724601329824`, 1.9618724601329824`, 
     10.799999999999999`}}, 0.1]}, 
   {Hue[0.7066479473280154], 
    SphereBox[{0.20847205373139374`, -1.9891051764079783`, 11.1}, 0.3], 
    SphereBox[{1.9891051764079783`, 1.9891051764079783`, 11.1}, 0.3], 
    CylinderBox[{{0.20847205373139374`, -1.9891051764079783`, 11.1}, {
     1.9891051764079783`, 1.9891051764079783`, 11.1}}, 0.1]}, 
   {Hue[0.7257465404990429], 
    SphereBox[{0.7869817326957818, -1.8386570513293514`, 11.4}, 0.3], 
    SphereBox[{1.8386570513293514`, 1.8386570513293514`, 11.4}, 0.3], 
    CylinderBox[{{0.7869817326957818, -1.8386570513293514`, 11.4}, {
     1.8386570513293514`, 1.8386570513293514`, 11.4}}, 0.1]}, 
   {Hue[0.7448451336700702], 
    SphereBox[{1.2951926773077518`, -1.5239671678380666`, 11.7}, 0.3], 
    SphereBox[{1.5239671678380666`, 1.5239671678380666`, 11.7}, 0.3], 
    CylinderBox[{{1.2951926773077518`, -1.5239671678380666`, 11.7}, {
     1.5239671678380666`, 1.5239671678380666`, 11.7}}, 0.1]}, 
   {Hue[0.7639437268410978], 
    SphereBox[{1.6877079174649843`, -1.0731458360008699`, 12.}, 0.3], 
    SphereBox[{1.07314583600087, 1.07314583600087, 12.}, 0.3], 
    CylinderBox[{{1.6877079174649843`, -1.0731458360008699`, 12.}, {
     1.07314583600087, 1.07314583600087, 12.}}, 0.1]}, 
   {Hue[0.783042320012125], 
    SphereBox[{1.9294652357732187`, -0.5264635827316053, 12.299999999999999`},
      0.3], SphereBox[{0.5264635827316055, 0.5264635827316055, 
     12.299999999999999`}, 0.3], 
    CylinderBox[{{1.9294652357732187`, -0.5264635827316053, 
     12.299999999999999`}, {0.5264635827316055, 0.5264635827316055, 
     12.299999999999999`}}, 0.1]}, 
   {Hue[0.8021409131831525], 
    SphereBox[{1.9988691710020094`, 0.06724609444227339, 12.6}, 0.3], 
    SphereBox[{-0.06724609444227314, -0.06724609444227314, 12.6}, 0.3], 
    CylinderBox[{{1.9988691710020094`, 0.06724609444227339, 
     12.6}, {-0.06724609444227314, -0.06724609444227314, 12.6}}, 0.1]}, 
   {Hue[0.82123950635418], 
    SphereBox[{1.8897200763197213`, 0.6549488782753861, 12.9}, 0.3], 
    SphereBox[{-0.6549488782753893, -0.6549488782753893, 12.9}, 0.3], 
    CylinderBox[{{1.8897200763197213`, 0.6549488782753861, 
     12.9}, {-0.6549488782753893, -0.6549488782753893, 12.9}}, 0.1]}, 
   {Hue[0.8403380995252074], 
    SphereBox[{1.6117679152809015`, 1.184147029414446, 13.2}, 0.3], 
    SphereBox[{-1.1841470294144458`, -1.1841470294144458`, 13.2}, 0.3], 
    CylinderBox[{{1.6117679152809015`, 1.184147029414446, 
     13.2}, {-1.1841470294144458`, -1.1841470294144458`, 13.2}}, 0.1]}, 
   {Hue[0.8594366926962349], 
    SphereBox[{1.189841326619784, 1.607568853103242, 13.5}, 0.3], 
    SphereBox[{-1.6075688531032417`, -1.6075688531032417`, 13.5}, 0.3], 
    CylinderBox[{{1.189841326619784, 1.607568853103242, 
     13.5}, {-1.6075688531032417`, -1.6075688531032417`, 13.5}}, 0.1]}, 
   {Hue[0.8785352858672623], 
    SphereBox[{0.6616297558980972, 1.8873913388882084`, 13.799999999999999`}, 
     0.3], SphereBox[{-1.8873913388882095`, -1.8873913388882095`, 
     13.799999999999999`}, 0.3], 
    CylinderBox[{{0.6616297558980972, 1.8873913388882084`, 
     13.799999999999999`}, {-1.8873913388882095`, -1.8873913388882095`, 
     13.799999999999999`}}, 0.1]}, 
   {Hue[0.8976338790382898], 
    SphereBox[{0.07431676958165281, 1.9986187774958353`, 14.1}, 0.3], 
    SphereBox[{-1.9986187774958353`, -1.9986187774958353`, 14.1}, 0.3], 
    CylinderBox[{{0.07431676958165281, 1.9986187774958353`, 
     14.1}, {-1.9986187774958353`, -1.9986187774958353`, 14.1}}, 0.1]}, 
   {Hue[0.9167324722093172], 
    SphereBox[{-0.5196347124275082, 1.931315553098556, 14.399999999999999`}, 
     0.3], SphereBox[{-1.931315553098556, -1.931315553098556, 
     14.399999999999999`}, 0.3], 
    CylinderBox[{{-0.5196347124275082, 1.931315553098556, 
     14.399999999999999`}, {-1.931315553098556, -1.931315553098556, 
     14.399999999999999`}}, 0.1]}, 
   {Hue[0.9358310653803447], 
    SphereBox[{-1.0671687731782353`, 1.6914936622858685`, 14.7}, 0.3], 
    SphereBox[{-1.6914936622858687`, -1.6914936622858687`, 14.7}, 0.3], 
    CylinderBox[{{-1.0671687731782353`, 1.6914936622858685`, 
     14.7}, {-1.6914936622858687`, -1.6914936622858687`, 14.7}}, 0.1]}, 
   {Hue[0.954929658551372], 
    SphereBox[{-1.5193758257176426`, 1.3005756803142337`, 15.}, 0.3], 
    SphereBox[{-1.3005756803142339`, -1.3005756803142339`, 15.}, 0.3], 
    CylinderBox[{{-1.5193758257176426`, 1.3005756803142337`, 
     15.}, {-1.3005756803142339`, -1.3005756803142339`, 15.}}, 0.1]}, 
   {Hue[0.9740282517223995], 
    SphereBox[{-1.835861560828585, 0.7934811462612273, 15.299999999999999`}, 
     0.3], SphereBox[{-0.7934811462612243, -0.7934811462612243, 
     15.299999999999999`}, 0.3], 
    CylinderBox[{{-1.835861560828585, 0.7934811462612273, 
     15.299999999999999`}, {-0.7934811462612243, -0.7934811462612243, 
     15.299999999999999`}}, 0.1]}, 
   {Hue[0.993126844893427], 
    SphereBox[{-1.9883552503676303`, 0.21550730459888812`, 15.6}, 0.3], 
    SphereBox[{-0.2155073045988919, -0.2155073045988919, 15.6}, 0.3], 
    CylinderBox[{{-1.9883552503676303`, 0.21550730459888812`, 
     15.6}, {-0.2155073045988919, -0.2155073045988919, 15.6}}, 0.1]}},
  Background->GrayLevel[0.2],
  Boxed->False]], "Output",
 ImageSize->{93, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499094130,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78739628],

Cell["Bubbles:", "ExampleText",
 CellID->246952071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", "=", 
       RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".7", "]"}], ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "20"}], "]"}], ",", 
       RowBox[{"c", "[", "0", "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"i", "/", "7"}], "]"}], ",", 
           RowBox[{"Sphere", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "Pi", " ", 
                 RowBox[{"i", "/", "6"}]}], "]"}], ",", "0", ",", 
               RowBox[{"Sin", "[", 
                RowBox[{"2", "Pi", " ", 
                 RowBox[{"i", "/", "6"}]}], "]"}]}], "}"}], ",", "1"}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "6"}], "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Front"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329009926],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.396811, 0.31014, 0.204105], Opacity[0.7], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}], {
    {RGBColor[0.6295151428571429, 0.30967042857142857`, 0.152196], 
     SphereBox[
      NCache[{Rational[1, 2], 0, Rational[1, 2] 3^Rational[1, 2]}, {
       0.5, 0, 0.8660254037844386}], 1]}, 
    {RGBColor[0.7039602857142857, 0.47008871428571425`, 0.2484432857142857], 
     SphereBox[
      NCache[{Rational[-1, 2], 0, Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 0, 
        0.8660254037844386}], 1]}, 
    {RGBColor[0.7817357142857143, 0.6567842857142857, 0.4163314285714286], 
     SphereBox[{-1, 0, 0}, 1]}, 
    {RGBColor[0.8430185714285714, 0.7806107142857143, 0.4140508571428571], 
     SphereBox[
      NCache[{Rational[-1, 2], 0, Rational[-1, 2] 3^Rational[1, 2]}, {-0.5, 
        0, -0.8660254037844386}], 1]}, 
    {RGBColor[0.7860280000000001, 0.7867405714285715, 0.3305471428571429], 
     SphereBox[
      NCache[{Rational[1, 2], 0, Rational[-1, 2] 3^Rational[1, 2]}, {
       0.5, 0, -0.8660254037844386}], 1]}, 
    {RGBColor[0.6065192857142857, 0.7025961428571429, 0.4066644285714286], 
     SphereBox[{1, 0, 0}, 1]}}},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->Front]], "Output",
 ImageSize->{184, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11576694,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499494878],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " to render nodes in a ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432756382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "50"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"#1", ",", "0.1"}], "]"}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Sphere", "[", 
        RowBox[{"#", ",", "0.3"}], "]"}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35075088],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{1.1721484307569534`, -10.725600641115502`, 
      2.108959357747445}, {1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}}, 0.1], 
     CylinderBox[{{1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}, {2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}}, 0.1], 
     CylinderBox[{{0.6483534787183691, -4.2197462623975905`, 
      0.7439528378651883}, {1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}}, 0.1], 
     CylinderBox[{{1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}, {2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}}, 0.1], 
     CylinderBox[{{2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}, {3.345256361380913, -9.281973713350302, 
      0.949554530220349}}, 0.1], 
     CylinderBox[{{7.063805839579562, -9.49268738990686, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{3.345256361380913, -9.281973713350302, 
      0.949554530220349}, {3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}}, 0.1], 
     CylinderBox[{{3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}, {2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}}, 0.1], 
     CylinderBox[{{7.770912620548202, -8.147581751024529, 0.}, {
      7.770912620682892, -7.1475817510245285`, 0.}}, 0.1], 
     CylinderBox[{{7.770912620682892, -7.1475817510245285`, 0.}, {
      6.904887216935867, -6.647581750959726, 0.}}, 0.1], 
     CylinderBox[{{0.6483534787183691, -7.094493788375964, 
      0.7300713125464304}, {1.266732340127061, -7.619729005002492, 
      0.5850752453833055}}, 0.1], 
     CylinderBox[{{1.266732340127061, -7.619729005002492, 
      0.5850752453833055}, {2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}}, 0.1], 
     CylinderBox[{{2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}, {2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}}, 0.1], 
     CylinderBox[{{7.1831273685502355`, -0.6483534787183693, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}, {3.74719383210438, -2.685840432377382, 
      1.001138983650924}}, 0.1], 
     CylinderBox[{{3.74719383210438, -2.685840432377382, 1.001138983650924}, {
      3.387645521160266, -3.684779950783155, 1.2447467088530106`}}, 0.1], 
     CylinderBox[{{4.549188208941657, -6.770652932907409, 
      1.3923625979386745`}, {3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}}, 0.1], 
     CylinderBox[{{3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}, {3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}}, 0.1], 
     CylinderBox[{{2.2255457207013944`, -0.6483534787183691, 
      2.1504421989560116`}, {2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}}, 0.1], 
     CylinderBox[{{2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}, {2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}}, 0.1], 
     CylinderBox[{{2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}, {2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}}, 0.1], 
     CylinderBox[{{7.063805839452575, -10.906900952248208`, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{5.523149147029444, -1.8662039256725445`, 
      0.721505837589105}, {4.781100675086404, -2.203838265930645, 
      0.6049935385663198}}, 0.1], 
     CylinderBox[{{4.781100675086404, -2.203838265930645, 
      0.6049935385663198}, {3.74719383210438, -2.685840432377382, 
      1.001138983650924}}, 0.1], 
     CylinderBox[{{6.904887216935867, -3.8024761120125934`, 0.}, {
      7.770912620682892, -4.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{7.770912620682892, -4.302476112077396, 0.}, {
      7.770912620548202, -5.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{6.819856104466182, -1.7663874674112716`, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{3.387645521160266, -3.684779950783155, 
      1.2447467088530106`}, {2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}}, 0.1], 
     CylinderBox[{{4.880146823665609, -10.506117514497866`, 
      0.7482364660203219}, {4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}}, 0.1], 
     CylinderBox[{{4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}, {3.345256361380913, -9.281973713350302, 
      0.949554530220349}}, 0.1], 
     CylinderBox[{{4.179205544430305, -5.473945975470671, 
      1.5158986108498584`}, {3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}}, 0.1], 
     CylinderBox[{{3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}, {3.387645521160266, -3.684779950783155, 
      1.2447467088530106`}}, 0.1], 
     CylinderBox[{{4.154199961738533, -5.209423405100645, 
      2.233310496618497}, {3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}}, 0.1], 
     CylinderBox[{{4.696458634260625, -10.370239357036512`, 
      0.01374291795333904}, {4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}}, 0.1], 
     CylinderBox[{{7.770912620657169, -2.457370473130262, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{8.636938024564607, -3.8024761122458828`, 0.}, {
      7.770912620682892, -4.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{5.285016025937254, -1.9623498402928048`, 0.}, {
      4.781100675086404, -2.203838265930645, 0.6049935385663198}}, 0.1], 
     CylinderBox[{{8.478019401793924, -10.906900952438688`, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{1.7164837218704114`, -0.6732162596522508, 
      1.5962356716757307`}, {2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}}, 0.1], 
     CylinderBox[{{4.225546571367519, -6.7877592537986216`, 
      2.082044311446766}, {3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}}, 0.1], 
     CylinderBox[{{8.721969137034291, -1.7663874676674665`, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{0.7987328948235619, -7.2771651354098985`, 0.}, {
      1.266732340127061, -7.619729005002492, 0.5850752453833055}}, 0.1], 
     CylinderBox[{{8.636938024564607, -6.647581751193016, 0.}, {
      7.770912620682892, -7.1475817510245285`, 0.}}, 0.1], 
     CylinderBox[{{8.478019402047897, -9.492687390097341, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{0.8115797774473554, -3.99445546379731, 
      0.03306167449385167}, {1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}}, 0.1], 
     CylinderBox[{{1.087798418663198, -10.95529963388428, 
      1.3779910738079852`}, {1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}}, 0.1], 
     CylinderBox[{{8.358697873251412, -0.648353478876706, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1]}, {
     SphereBox[{7.770912620791858, -1.4573704731302621`, 0.}, 0.3], 
     SphereBox[{6.904887216935867, -6.647581750959726, 0.}, 0.3], 
     SphereBox[{1.1721484307569534`, -10.725600641115502`, 2.108959357747445},
       0.3], SphereBox[{1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}, 0.3], 
     SphereBox[{0.6483534787183691, -4.2197462623975905`, 0.7439528378651883},
       0.3], SphereBox[{1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}, 0.3], 
     SphereBox[{2.2838591323395194`, -9.399509914585488, 1.1651916493196308`},
       0.3], SphereBox[{7.063805839579562, -9.49268738990686, 0.}, 0.3], 
     SphereBox[{7.770912620718489, -10.199794171141027`, 0.}, 0.3], 
     SphereBox[{3.345256361380913, -9.281973713350302, 0.949554530220349}, 
      0.3], SphereBox[{3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}, 0.3], 
     SphereBox[{7.770912620548202, -8.147581751024529, 0.}, 0.3], 
     SphereBox[{7.770912620682892, -7.1475817510245285`, 0.}, 0.3], 
     SphereBox[{0.6483534787183691, -7.094493788375964, 0.7300713125464304}, 
      0.3], SphereBox[{1.266732340127061, -7.619729005002492, 
      0.5850752453833055}, 0.3], 
     SphereBox[{2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}, 0.3], 
     SphereBox[{7.1831273685502355`, -0.6483534787183693, 0.}, 0.3], 
     SphereBox[{2.7487337392470628`, -2.3233646124846663`, 1.243831944116861},
       0.3], SphereBox[{3.74719383210438, -2.685840432377382, 
      1.001138983650924}, 0.3], 
     SphereBox[{4.549188208941657, -6.770652932907409, 1.3923625979386745`}, 
      0.3], SphereBox[{3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}, 0.3], 
     SphereBox[{2.2255457207013944`, -0.6483534787183691, 
      2.1504421989560116`}, 0.3], 
     SphereBox[{2.264160197264273, -1.2878752583523871`, 1.6324827933232195`},
       0.3], SphereBox[{2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}, 0.3], 
     SphereBox[{7.063805839452575, -10.906900952248208`, 0.}, 0.3], 
     SphereBox[{5.523149147029444, -1.8662039256725445`, 0.721505837589105}, 
      0.3], SphereBox[{4.781100675086404, -2.203838265930645, 
      0.6049935385663198}, 0.3], 
     SphereBox[{6.904887216935867, -3.8024761120125934`, 0.}, 0.3], 
     SphereBox[{7.770912620682892, -4.302476112077396, 0.}, 0.3], 
     SphereBox[{6.819856104466182, -1.7663874674112716`, 0.}, 0.3], 
     SphereBox[{3.387645521160266, -3.684779950783155, 1.2447467088530106`}, 
      0.3], SphereBox[{4.880146823665609, -10.506117514497866`, 
      0.7482364660203219}, 0.3], 
     SphereBox[{4.245618735140671, -10.003207631020977`, 0.5976470465028314}, 
      0.3], SphereBox[{4.179205544430305, -5.473945975470671, 
      1.5158986108498584`}, 0.3], 
     SphereBox[{3.8739031269176722`, -4.718305400407193, 1.6341896150392876`},
       0.3], SphereBox[{7.770912620548202, -5.302476112077396, 0.}, 0.3], 
     SphereBox[{4.154199961738533, -5.209423405100645, 2.233310496618497}, 
      0.3], SphereBox[{4.696458634260625, -10.370239357036512`, 
      0.01374291795333904}, 0.3], 
     SphereBox[{7.770912620657169, -2.457370473130262, 0.}, 0.3], 
     SphereBox[{8.636938024564607, -3.8024761122458828`, 0.}, 0.3], 
     SphereBox[{5.285016025937254, -1.9623498402928048`, 0.}, 0.3], 
     SphereBox[{8.478019401793924, -10.906900952438688`, 0.}, 0.3], 
     SphereBox[{1.7164837218704114`, -0.6732162596522508, 
      1.5962356716757307`}, 0.3], 
     SphereBox[{4.225546571367519, -6.7877592537986216`, 2.082044311446766}, 
      0.3], SphereBox[{8.721969137034291, -1.7663874676674665`, 0.}, 0.3], 
     SphereBox[{0.7987328948235619, -7.2771651354098985`, 0.}, 0.3], 
     SphereBox[{8.636938024564607, -6.647581751193016, 0.}, 0.3], 
     SphereBox[{8.478019402047897, -9.492687390097341, 0.}, 0.3], 
     SphereBox[{0.8115797774473554, -3.99445546379731, 0.03306167449385167}, 
      0.3], SphereBox[{1.087798418663198, -10.95529963388428, 
      1.3779910738079852`}, 0.3], 
     SphereBox[{8.358697873251412, -0.648353478876706, 0.}, 0.3]}},
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllHlM02cYx3sIEUQsYJlYegAtM4gQBQYOyPuCClIMlwOT0XVEpFyTI0Tm
cIsgFBwihxgtJRwiRy0bG45rG9BXMExhDBy4IExQ6AGMy1pquUdAfknjmzz/
fP/45vt8nud5Lc7HB0UQcDicw2YRN+uHq8dpMWQ6ZBIyfgkPfCfBvX881yOP
hKUUuCe+ppZ+9yDa0e9mX2uiPVKCuANfzqYlsVCBMoFsPYaDZBtln5nuEiA+
9SseFzAR4TStLJKrAS0rMT3+EikYfaBno/OahNjNOXbJfylAt4geNli9COiO
714xUg1R4f3DNZTdUiC+2T9/7hQBklkn8nP+tERjvKaNskolUFlHB4Z4mMNI
IZ/vsWqJ5Vl3c9nKP6KejfXlMTG9cJ73mNypD2vPdY9w8y3R4P4KO3R+DsTe
8FbfG9CDi4LZrKIEBlrrdKhnlCoBKcBpy0fXa/B5ni8D84kvd97SDXJEmxzM
MX2nr8mN7uWOMHN0y/9CejtHARrMPrf4/qQK2HyT7i5MoaHJ4cKW+ZZxoEvK
+6rVjAg/nav94wuBPvKUj2U+sFkAOg21bfzfzeFv234Y/56/Q6lRazqQmyi0
h3cI6GtXytlW+VtwlM3vgMt7YV+dcLLoWx0kTBX4i3ctAH/iwAXuMWN4teSl
vjWZgnLpMhzNWw38XPpERsX7IHdezRWfpqLc2ywzF18NiA46Oj3di4fv+5AI
K6z0KY54yHFP08FRCTDDGZhaFask6/V63tW0ZXD4fq6jNBgP3ZVVdxJ+ZKB/
Sw85y1znQLKGtzUXkltwUHA/C+Pz+qfFqIaPTKF0vKtKM7ImSbbXjy40VYC2
jKXhIboJzOycU126h0dZr3qjKJwJsLNvt4OyBJdjDT/g79t18kyrkxGm98X1
h173pkBZlk8a/cQqxg0noMlkZntgdZ7t1MWUvajOLSLzyvRb0OvzndMpvglc
5f363ILIQo2xiqKbbxTAaYSdkr5CghyxW1wlnokOrkw+nKFPgGOca6K0ZhIs
GCUcCJKR0ZW4YTnNQwPYo/YzaM0Q7jp0MenGmDFqUqQSKlnL2P5s5yRjOTOH
PAXyEhKMfthnmvTPfjQU2CV99hIPHcSPk2yfGsOps58R89uYKJXJPg5YOcDP
frtfY3zHi3oREfOZsaloM/eygCUheVp8jJQt7iNWZGggc1I+idjAOMio6Yvt
KgacHw3RmstEj6CiOXkFXF9gD6xmyyTd0qgYu+wlEL5uV7coJ8H/2ss5YmsK
6pCavNAV4aBzQcBCVaIFnLEM1eJM++RnH5e8KWDbGHbkGYX6QU5SYq3WvxF+
hr+Vx8s9S+t+XSK9P07WTAFmg5JUpdqHwi5HNl6aLQdpT3ICyiLfgKEB4W7q
FAuJ1J5caKAG8owIUNPMgA3tqVr38j98TPhe
     "]]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->17629805,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydfAlcFVeWN91uicl0Mp1Op3syPd2TmV6mZ8otMdEsxmgSk5gC97jGrRBU
QBBREBFUxAU3FhVZFFF22WRfFdmUfd/Bx77vPHi8V//f91XdqmeT+94k+b78
iD8u99S559x77jn/c+6tYncfMTU2331k/97df1p1eLel6f691n/68tBh4U8z
fmFgYNAi/B//OwPh9/8j/Eb+bwFgYHBZ+PeXxsbG60jrovDvDKFlMEP4xZj8
Z7CW9JyTe2aKLfEXicBgDek9K3OZo7f3tPzsy2JrptQrERiRfif56VfF1qwX
/TIPQ0LjIPP41Y/QHJdp/nmaFOKvv6Taqwm1rTzqb6jeGVT7G0JtI/P+LdU7
k2p/TaitZd6//1nUljLvt6neWVT7K0JtLlP/G9U7m2qvItQHZUn+/WdRm8q8
/4PqnUO1vyTU+2Tef/0J6i8I9V6Z939RvS9R7c8J9S6Z+n9+FvX3siTzqd6X
qfZKQr1N5r2Q6p1LtVcQ6i0y7/d+FvUmmff7VO8rVPszQr1epl5K9b5KtZcT
6rWyJB9Tvf9EtT8l1IYy72U/i/pbmfdnVO+vqDbhRuxW/ONKqvc1qv0Jof5S
pv6I9B5iuP9lLfU//fl0rWdtZ7irDBf3rmnxF1z9t5wOj9epNnmKzLb4R8Jx
Dsscsp9/JWSlX9GugO6jflPOVzRnLHSslvYiRHoyW6I0ZNZeFjhtZu5dWJkR
b1JQe7ZE6VOA8AxE3+d99uvsMP38PpYl+0zmd2fr4oLLu1qTzw41BoxNJQ/j
WRtKC5Dlo8Pv11T7Q8Jvqczvc5lf6qbVXa626gRf1CVDWQooNOjqQn2iDr83
qDaxSYMPZH1Xyfyy126ZcDyP8AcoyUefApphQKkaV6Tr8KP96hLC7z1ZPiLt
jGNkNaG1yjnsdtXBq/CKR1oFanvQO4mBCZXOyujnvEiWlMzr7A0M58KYRC0+
VLTKrHkDV7OaI3tqNsuEGZ2D7UP4lSGpE1kDoC3oTar9AeE+X5ab2NNLLHPQ
grniv8w/7/uQjmOBk+du8Zccu6w4sstnsl/0ucQibwgbQidpL0HHD+InDP5H
5v6pzP22w7L0B3uLy89UDvuU8xF5iI/BAxci6WxDhrNnOJbx2u6I4GpUNGbR
vkX/GH/HtB3+Css4r1uUc2pLa5TTSNWdibEkJfL7UFmD4ujiz7h7DCdFn9lr
Ge4kYxb27lH2w7ZTEeJ80b7pLaq9mIz2V0zzEG+xjI/hMsWJQ1NhN1CagKFi
wQ559IygvUCT1KcJqVLdSBtx8m/nTgqDs4zpbubKjQ/vP9oesekoAspR2dWk
Pm+q40N/R7WJhzb483SL/S371cChk7gdhOwctDZjcgj8BFR9FUWNaGpATzVG
S6DKUQlSsMytQ++n++8ofepY1+Ndx0eUITkDiT5k1mcK9uTMcEEMpydOv0vG
fUfW+GvJkj9t23gK5x8gqghFHWhRomuSl7DFa8fS4VeKpDoUNoKd98hqjSLA
bjTfR92XoOHzx1DdiqrH7cYnS1Zw94V1mKld9ZOMddgHToVGp4RBBk25f9Er
xR9lKVixNYs1Ve4KwMVchDQjvkv2uK+zi2sOGk/6XkVONDoKgOdA3xR66qR5
0IRWq26mjzjdbTd2LPmM+57xlBDhxJUocTDPwwb0yIvIyH+Q530H2c7sEsWO
w/xVPyQ9Qm09RgbAT2JyWJFYK2rd2IDuaoyUSGwMZvt8X5Xt9LzTV8HH1CHj
qZ45JrGajCz+cZe0lw/j6F3czUGmArUjUExgpiyDwcsJteLUHjBq9bWbyPHh
OxPBF6pR1yt26uf9O/nZvWTmDLdOsW44lgqvKgQrJAwpPkJW8GV2YdWevarr
l5ERDUUB1ApggMeAQh/3BYT7m/LzxNnNYJn4/dcQ2/IPvsR7zmUX1a234M96
IyodZXXoG8CUCuMjbSAwl+ZM0A6JAy84zyJ2woUIDsJo9HKaRD5Xmq39OOCL
G5lIakLJEGrGQSNdGq3OI/xfl+dlnyw5t59x8l3iIa3cjClHc5la9n2Ok/ti
cL4IbhVqGr/S+1Xi/0+y/FrsaTCr7ETB8PWnfFAaIu7h9iEdj0zLyRA+r8hy
fi31Mpw7w4UK+0drlwYvrWEynDY0RNv3VfsMK+MGkdOG4kLk+NP+kuZPMCjZ
O9P2t+AJGJNbjM3jFccbvjvSvce4YQNHNCQ6iFPOMt5GHzc6mKkeePAVsRgt
BJqF4NuLpnTaZ9IzI404W5b8WzLiGsbx1II70WsjqyxjRlwe8J6+uH7yhV2R
uX6JXTVgdQJ37+NpNrqaoB4UgrNmoj2H5k+3/5uMN2v6eEKst1w3/+Flo6IU
m7rnHk2asFokP0N6FMLtCJYRH39JmosVXVtO41IE4opR3onOCfROqHVmkW7/
/cWY0zPG1fLYtzd/VH3FbCjNXaOIgjpXjap+NFSgMIAgUvEBKVtkD6n3BcEt
H5EtSO6Bzu6jNZ026g8y0W/kcUPWGQ6ec0J8MOqyoWwAeoHBvqmGeILJX2RS
s4T1P85wgQyX/SFXsZLTyQbocf/rH+POevFXWedvpFncMHnEFfdjsZHhzjDc
DYZTT04QviKbd7RWxzEOXovdM9fdUpjdnDhxccrR7CfH/hsZm8496d1Psss5
G89jF8N5MgdSllpUfmuq2MjlL+eIJYqkf5asjHGzefdh8OasYrv8QQ9ho6Yj
4j58zehsi17xv+qVg26TuD3HiLFxXOgZ+fW9cpOgAYe76otucLUmMoukf5VX
65gRk3ZiTX24bW/FreGx2CHktKOkCDm3f3JO9MtCe6wvZH3NNzFhl7/OTrEo
bb5UoQ4oRsxjxAeJhH+XJXEzXFJnazoZ4saXxmC4QNrqfWhM+UnU8he9ktBo
muB5Ab36bv+o1M2kO/3SeEvohObxKPFsM5DnJ9P9tyTxyh4zO/gFICcL7U2Y
GgImNH1NKTR2o2X5s15ZaPwtZX0sE7fJsO/SSV6OBOjQoLeLb0yQ/PFL7MeK
DY44F47oQpR0ol2JDqWqw5L7/5OBRukkI54hbJVLBJIZkHmYHf4QJSXo64R6
XMB5E02VUSTGzGGNh3YGwDUPIc8R04E+JdBWpZMJ05L8p15JaCtfJtukwUul
O26w3w7sugz3RCRVo7wPLZNoHB5+V5qPeQmBlZicAKpSPRkucRFX+AmXvoh7
URU7S+JV+kKOjg6kGqOzX2m7+lArx9wtjP/Vlclp+3Oen81bexKscd/eUFwq
QOBz3GtULZZmxAopAmpRImalZ+Wu64M2l9Qnj0izLFgZZ8ccE1gVrjvXaeI4
anmAlugdvRLRK/u+LBGpvwl7xGvH+/k3uJYnF/o7Agf51G7k16EonU86K+VY
wj6z++4Ginrw2Cy37Xze1O1HYp4ZdHq23Gu6lbnu+nGkwLHxRJrKIwH+9+Br
R0dv/bLRay2uyS+1cVOQLX4r2+3hoH50F60Z4Ct5tE6io0FdGiDJ9lshMnAf
F98ybcu5NNgdOsRndKGwCgXRjc75DaefNpzKrXfMqnfIrLN/JOQROxY+8dhe
98ipXRiAj1cguwQ5D+g5/He9cv5KlmuBPHdzZN0frNumcrmMuFjUlGK0AxgD
Pz6wRJYtd/fGgRunNE8C0fEEqOXRMY72YsETlhairBDlBagoQGW+AElSd3zT
7n5sKsOHb00Wgw+eD0NRRFv+n/TKRtdW/i7L+IpkUZsnzD3gl4ondWgcRK8K
rcN9Um4uyF++0Zh39UBiIuoroewRLW9qoE67soUbd6guuCIhGvVFmGgngg01
/zyp6LrKXzCtUizYsivryB95CJ9yxHYgtl2jlYgz+qSZ3c8f8UFAJnKa0TSC
LhVkRGOsPnoD99PwtB6tQxieInGajmd/1CsPXZfR5oWSnOuXN0enoXNSriu8
spfhrjDcHTGh32f0qeLETQQLmcsVHE+FXw0i2uU64+w17jiTiuA6pPeJXAV+
dBb2b3qloas6f5Tti/x9pjALJx1R/BytPTWLtfMiiHSTOZSxzJpl9q9Z0erg
jZA60BicXps/kNHpSjv91NvyXEh/Z+cXBEWhdVyuUAgI195hvnfEt6EVZhFr
Pm939EVovW59gW7rH5n2Cm/JI0tyW1nwudXoHh8z0GptazQv6sLqZ4lW1c3X
6jWhVUjKQWogrSU99r/qHZumekMeW1oxIW76BKB5WNZaGDtg45JKV9PB5Kvq
55EC1p1CdS/qC34Ks7+td2ya6jVMO1uYtYtY256tI+kF6FFpXkjw0IgdPHMS
sYGozcZEE9DPY7CNtndaL/0S6D/z2E1ArbYtdpO5ExHtHtHerDKW2Vz1QE0P
6tdz0t6Yw25SHb6EgDg8q0BnH5QqDI906lQfaKn+Ra9U5K+vTEfeQqbswHBh
87inn3J1q7mqr4h04t4g+1pAoPaO832iDMOqzCNGnEM0bl7wsJP82az1F+Cc
gPBq5PSjcFiukou7yZHUiDLmczT+pKX8vV4pyYzOkdoCNxPG+fZHXnlb77Rb
+RAy4gGFaGW6Zl70JTY/xbr6uVudJrQSSblIC0eojXSiJEZwS8YmYLHzU6Pz
HSanxqx0sLl+ebTnftD6E5GCZTztlyZpUV5YBmJCEeZsoJXFc9OSyisHBtOv
TbVE8ZqcSVQJ1luKfD8poxA9ynrG7cz7EbHbUuqOZ0x6JOFuEPwdf0qi3+mV
iEgxO85psN5/VJU0hGftKCtFUQSR9hVWrNKdCdmStebbfhdHJAShIQeTYhYn
2HPPRF3MC5mubGQeuX5Xm+zQofDt5uPbkFOBpzE/tWpv6cik9WgEjrHv1ztY
qKK8UJ2E8VKgRYOeAbTnD1sejWY4yTfPXEcqif7E6RPENHM7QbEh5IfQvPo9
w7l94B19oDL71lTxI7Brx61dERiL/HJ09mBiUoCR41/LmkStXaG4eHgqyYtv
ToKmlIdiHG3lNDqkNfmtjiaiBYjWT/brr9klioP28A/G0zx0KjA1TOp3/TWa
zDEE5046Xiz+mNvMcJcZ88Ql1hWGFu3buZbNktX/RtDHjTmc+oltzYYj3btN
Or7nrJn9fl9GJdm3PQ3mS54hvwVR7aIY687ibBweVCGvFxVjCCvN12oVv2bD
uKMLIiNQWYjRdhHvYLjl/12r32Iajvq14VE4h5GSbCcUSrROwCoCiQV4XopJ
we9GV9kw10O+DCzZF9Z/Mkhz+Rbv7jjixBFM8CrLHD3G+IStDis7GD14Jpx3
9+Nvnsm4OFIQi5IK5HTgWplSyu9NEmCVoRRgEEampnyMDeSK0Sal6VV4J+Fx
rYiPelRA1h0dzExr9KaORtpoItfbruBEBnxrEaSQ6nlvr7+O4DzBewQ6f5Ed
Z1becKlGda8CsblIiUbM+d79R/sOHOs/aNdvdnzAwn7w0Ikhy5NDVo7D1k5n
v3oWb1nTeK1xKqQGSfnIeFjUgLQu7UmnbSB6+oHWMgO5VuLEWz2EV4UIUnI6
gXEe92wsxNrBD6shB4U2rdVvdLR6HfrP7olOLxktKjy3pyfx4kRT6JQ6cwJl
faitRFnEL1E/+ks0jAlkjeNoEn8En9qsNJhzzngg8Yq6KQLqHDWqBtEo5GPh
8mzHloIfBRIvGJAq+Zw9AagdBAZ678y3yF5h2bTRpHWzfLI4az1JLyMYruAz
ru4bTgfRaDX5YaYxYzrCsmM4H1IqIt7+94cZrvRrU/VV7xh/1DzCeA3QxWNg
CO25j3uR0Yu0HqR0I7kbiV2I70RsJ9jPOk8eR9Q9VD/BWD2pSQ0PqVseSfrM
3nkNTV1AT6uQQQYw3F2G+0breZ1SBZSD+HWh9ZbhynP34HFp5BQ3W7JHxtSE
Oeuz1EuQtdPad+rspSlnUx393tDRT1tnJZSvr2G408z+iPcti746pPjOuH0r
l/4BN+F4BUnJaKnzj0BeEdo7MDEOtUrT1pon76XlXaZn4BclZkatXRifwKRK
jZJgodOU4TxIIkziw2z/LEyNIn6pTYWRVef3+9q2cWQ3vcky5zcvjHdbW/jo
WG37jXpNRDlSHyHJM+eb09mrHLO+OJG5wu7x8mMZy46wjLfNB8kh3+cLMo/6
FCPyMeICdPDhr3X01NZ7CeXrAjw3YS7f/uQuOfELUp334a+5TJ3fh9oyjPaw
tnCMENwX8rpRPY6SQSXZAf/E2sDuAe6X4nEXigU1GptFPWtjC424rJU2TZst
undxZd9K9TVxvcwsGM+Az4MKjCN6T4byV/3462f6HLivZI2jt3/W4G458vg6
3xkHvkCF+g7UpjYnoDkez+PwPBbPH0IRzbPzsuw2KMIdRirvTIr6FAtCFers
wX/W0XiWrPHvpf3NeNt+lPFgb3GFc+WoXzkf9RRJcYjzyDsmR7IZ+2LhXADt
7hXy0NWKyFaMTmnQnFF/OHL8fDDveR0eh4XODQy3Wzw5EGAJZyMmO/fsl2dH
7q+svlivvFeN+AKkx+Ghi1bTnI3fjbm6IDkCzwugaRXMXc13F10pgHsRrhfD
qwTepeIZGrvkubX5VNANlCRhpIL4koGun6Gp9tSFYNC57LxMh81tUadGq+9O
KlOUKOxHdR0qU3qirAWa1yWvynDniFnGExTLMoc3LogPaED/FN9xs4GPqERa
9uVPYq5+nnptdbb7+mKPLdUeu5o9TTrZBc9Oft8TfU5VG4LJTDUqhtBQi/II
qc4p7lGWyWb3qO08EZKG4nr0DEM5hTnSHl3Zu/cEbgYjMx+t7ZhQkjyUxviv
/0A/Y7ka9keJ/+Lao+ZToTdRloShMqBNwPbj6K6gkSfxJH9gxVPzo3GfOFZv
cugzsew3FYTz3fppnafV6JObfFc8sbq6bvfrcPPGtTu4cg+XQnAxHOejhLVQ
2BzmQ/1QloFhwal1C6s2qm7N7N5rId2NeWWniBfEs2VR6XeLD5/DnWKsd8f5
dEQ04smAXFubzTrAPgJBpcjpQdkYjHXvUZGbIkTLdyQt51XuOQavQDzJheI5
JkagUWF8qInOhsmufI1lTPYy3re/jM4/mNTvEm9J/PPDedzadSOC0aUIRpcP
dQswyGOoTdqbr7AfNO4UViIMjwW00I4xpeCxNPUZGI3qm3KP7fz+gHQzRlxP
Af5cYw6lfCR4nn3s0ppjV3G/EvSdBdr/vKZjo+9Ic3EQQuANfIbsNtSMoX4c
dI36ZVknv0PL8kPMmgQBDjBmd+fb533twDLm7IYJm2sITkZRLboGxBxqYKRb
qui+ylrwh0NwpxAZHSgaQVRtvfFtxKShMR1jkT1T16Latu77WI4Vxw4zXkGr
Qkv2Rw2dCXPwQki9rg50+1eYHuVFuyQV1RkmMbhYjCtlap3KMokOv2KZxxZb
B4LP82uZ82cXByVujWUZK/aDJvYsjJxxOhFhNXjSh9xBEMt/1SwAceloTsd4
RKfqcnjLJmmHiu7mprBhF3CPFnFkpJkbGe4ssUDh52/yepmwTLjD50+jzWvr
rjZPhdYhNR+Pw/QiS7qeqFNtoW+rzZFsh8nZeVAUaB2T4vZdZaajotOvhT0P
p6cCBAzvuW0sRd1XrIOQlA5FGpThraqLQTsYM/eFDmmfO9dvPzVkbj1krr2T
sVH0ReYPl9iUGx7u/N5EgN5/lXW5zC4oPblnIMaVr4/AVB6PuiE0l/5UBYXs
fZ06t15d5rL7eccAbFje5HZkMtOH70wBL6QczQNQFPeknSGc59qGIDVD0NfR
ekFAkGFsyaHkwfMJ8A7D3Wtjl6QMR4x1+xmP28uDnu6J6HYI46/e4W84dx6X
NJnDrui2sUVIAMqyMNIMDAm+pF3H79FrIulB7w+9erzEnoOh0cjZc2LNsbEY
qg5AgITDbaRO8IYRE+3wVXGUVXONe/tEeAvSq5CbjtSrYy6hI2eChp0CWCbg
6CdZYfsqK87VjwXUIF7YRAmIdTGQ5V/ZvfMMrkfhUTma+zCkQkFDrlyD3sFw
5xnuuoCK6QyY1ocgfJ2TIL36zGG/6DlwBf4pyK1DyxAGptDQ2yxVPd4wXFh2
Yu9w5GW+OgITeUDdJFoVqImZaMJkI1QNYBfk2W7tCj8zWRmI8UcalI+gsR4V
EdLJ4UzWWm3+ALdKEdcJooNYX9gmern9yUvNa4xM27Zw1N1eM4ajkSTxvTo7
Xq82s9i9/YeixJLtww4E1A5KdZGX2I/brY4i8C6KnqBfSOoHhKxQOdSULFvU
4mbLQ5r73ihKxUC1FH/GVIr0pdL8MEesGc+gL+6XmoQNnbqvueamdjWRzzuE
0deLMJaLnM8VfcbVfsPRVVNJdvoMipadyDFrJ1lcdkGB90PUKeU6yhx2fskW
B1wNR3IRarvQNyH8qKQ9N4ddXLfVDu7BSHuGxjaMKAU3rZbu3wn7xIJlQh1X
5sYcrKq/XK8OrkJyDtL85To1YyoM77tUrBF1H/FWu1yYPG2sU/Mla0P+FSMm
OZ37QSVMGOMicy5plRtnwafWCqiyon4PJ1W3Z++9B/d8RLfCxR6NXp244jVT
WqH9GvNA+BQgpR3PhuXbh4K019mFpU57+h+6ahoeQJ2rQW0fGp9qTzGEyO9j
syRZGLziVJnSrwjRjxDvS8dGopvO+RY52ZyrrY1Z7mGC/QzT861z+q9m8/eS
8eAe7tu9I9nrglp/F/TequXPHF8hj+zJft5ja4fwAFRmY1xyKYMNWrlc2PnZ
thtbwx1HBf6qdCXKulGTp18uOmMncr1M6mT3D6wov2/VVXp9aDRmQLxeUlKM
/GDp/E7I/ycTr/BKr1xjkuFEEsgh3b6dw34zwLngVgyeVKClXzxvQKCt1lMx
59mlisMW6iAvMYyO1pBq1oCC3l+EWuecSz4PZtK5raP+rnxhFIbEG1+8WJhq
zf5P2Yq4Hcw+N+ZI6jL72k1He433d+2RJXuZtddYx+B2BRK6UNonTNvgNlKt
Chf8F8GQcwXr2fTek2OHNAJY3X1ShEiZRaKgykk87yylfRrxZjq3iomUczaa
8Nd8kJEJheCYhsGr0NuRL2EGQQN7G8Y3+JsHJQdjBs5EwNMf3mebjnGkHjvD
RMh0peoymYXXLSLQKrjzjtrYD+2rNtgJCq5hYix3jVzyxd0iYvIn+GORuFcO
IeU21p4K/DATMtC5j0zO+mezawfMfOGfg6xWEZFVjaj/LEsY4fTlsxgLAUY0
TQbXiRs9Mw6xp8gszTTU1gH8GG6BtIMY7jABInmfcA2GnCS5kHVZXc4WXUCO
cXzPmTgB+7tchV82Aho1Or6TtgBJau19Lck7rb2L4zmkl9wzeI1dWHZ670Cs
ABDCMZXNo3oYzbUoDSKbirNnTELfO1S4yqJlM9e6hZNuaP2GVHCdLr93M23d
3RbLu6qznvylI0KPCamgC8Zwa55JwIITov1/+PTuvoaii20jIa1Ir0Zeymyt
rkeI1UPKT2gEQnyKzsnZf1NtYgmvs5912dki/C7KMzFSDwhGOTLcXxPJMsbb
GNfrS/wfbw1pOxoyddGP93DuP8kRf/cWy7juXhDnvfHZ0+MVA14VELLZlMgM
82dPjtdmn+3IcxvN81E9DRTm4On+7/r9z2iKQjAizFuDWrw/EZgy6Xix9mvZ
4mdL2txfdDB/5QHFJk6P/ZBIoOOHaX3+Q9Jneeee0/CKwOMSNHdhZEL4mSTL
cf3A4jT/HSWFTjWDvtV8TCHSEhB/kejzJ5aJ51Y1+dqM5Puoh5LVKBlGQ016
HpIKEVOK4HL4lOFcgRDZ63YcxI1byMpAZwP4IfDjQ90tUNcB+SN4WAT3uxsZ
l0uL/VI3BiuOCLPmy3s4GEtvxYjhXLIp2hPq1WQWa8VbheN2CVLIxWpptoR9
kWZm1BJgP158RzOcqkHJCBoaURXzttYyyHkjl/4uV/4Zp70HPq9ox87J61eQ
HYfucqBLWOMRLTawxslARBSgpEs8pJdGefV4GhLr0dgi+vbv3026sak450Rt
n08d/7AEGfGS2WlrjDRql1aL3k20jv8laTO/bK/xlI878hLQI0jWKaAMpbot
623ZMiydGdf4VTcaTG4qT7iqz5hLeMnwIH/aDw+zxbu9g0ohAx+V9sVWISJ+
3mvogeOZ8KyWvaPgj5N2f/Xc66gy15fvTwHKlWhu1DkrelleIRofStrQfpfW
RvJtJi/exSA7craRBX/eH/HZqFVgcAzjKo2MvBi7bUyo5+rH2YcLet0K+eBM
xIZM3t5HtJu52RuXcxDdgsQufpZ2h3DkSHuDPZLbkbuMk1EqU7R5p+raFTyK
Q7swez0CghvX0Ux724w+jZE0o30HrZl0L3AtOWV5uJArWSme7km5w8ydPnDP
QVwLsgfxr7Jmwd9/UnXLvO+p5/hgLLkEX12BPK83ZXmFwHHUaaEby2TahqJW
CY3rce0tmQP8CV88yEJZK3qUAujulc53piMrsUHHOqLti9vGNIacK4+7z4y5
cH+5d8nuO0PHb6kvuKjO7pN0mMUu64yrApQjjxeKIELC+MITjzZvGnU/hyeR
6BZCXLsAb0YkKxB0dFjHRFxZnZNxuKzDvYIPy0dSLB96RMKzhjfg/ARBzf+Y
d9oPSxLT565/12OPohy+Dp9mxO0vbnYt1wQWIj4VibekNZtD8F+0fy7UU+g2
PTF+eH/+Ok46eZzjw5iPXU5wuomHj1HTLCB3KCenXsgf8t1H1dcODj72mOqO
VaNgDPWNKA7Q3gSdfo6gX3b6Vigtu4ym5+ee2tmdeHGy5YGaz1Wiuh11WS9k
4DYK4JbhLMjVzAfCxrnnjzu2xDO+IkX321JpYZ7lhEcKnnd/dwNXsxCnQNYg
XsxAypr1o+edkfIALYVklUYmCNIVLYXOwPW+xyjdOfgRXeSd9v5z26PikUFd
DlTPxVpWvGArWl3cyOHyPh/GKvOzI03fWfTs5pAX9oZ2lY4w+4MWWRd+bd2+
w7RzJ4fWXgMZ9ZOiihepgorviPxG2gnbVTYeCElHSRN6xzA4OaWtndMZLn2D
SNLoDz9Ho1d3OOJWNHIq0TaAPV80uH8YGjNvvyCQOYFV8fPF4uzrsn5Ra5hT
pxb4xRiF1lg8GHMJ4j094Wn5a61+GxnXSx/cS9sa2WoXpb56H94XtZmYWL07
4D7fLmOlU/MO+yGzA7VbZS1nGl7GqXQEN4oHMrPkFaPRNo0YJf3oNzVp/Yjf
EE9STpFjoph5nGmInG4L/61b1U4uSZh5L7DP/sqpbbfdiLlp3XbuNe3eXjsv
9rJRQZpNTatHnSa8AqnZyAgkuv6aZa5tX5h+c2tF3qnmfv9mPqFSAALJKy/E
L7WPevdQ6DxhPzoeWhAQyMaWWSaPusbDLxD+p7RvWdB7Sb8n+6M+7eb+ML/k
TjKWUR8cr1hn28OZ9e3jtLPtbL8oKHpTfL1t8qRbLPzv4s4JaQ4FHHxv08e1
V8yG0z00bTHgn6lQ14PG/HEXTqL4ja2QQy0+UrovZPvXrTftpvLu8P0ZQJUa
LW1PgpDjj1xvdZ7nGMvE2K0qjTysqL3eqRby2KxKPIvT3gaiY75+DcWbDqKv
JpHmTW0Gym1jPG8uD881jus5/RA3gnDn0tAFLuVDq5yvTxdvu76GSTi7tir5
RFurXyefoEBuCZ5GiGej8rqtGXE5jYRQITnGlELIq3gMKZDs9mKf2ZIdljGf
S5gnn7e85SgEtKXHKw486L5RPZaiVNZg3Y6py1eRnoDWKmgEIDwuJI4wjcWJ
VFx8BHZRxTFu7MFVvuYhVEJMUEyio5qgUtF26Zo6rfsviO7vUH8lKOh3JNu9
bvx+TsC++lLX1rEQhVgiy0tH6qWBVL4vC70FMPyg7oyFKvEW35ICvoJH2yja
S9PN8tM3hyR/eiqSVEmIXn9jyeGQgAHTBAy4gsv5UK7fshsmrK7gXiLya9Ax
gLEp1HdWoTYJdy5PHOWKPhbPEUyZw7ffO51n6NJp4qi0NqvbySUsc6w6FNPj
XT+ePqmsF8+s8waJFe5UWXsjKAsFLWgTENXouGyFH7fvt4X/fRTmYaBVmENM
jbS9OI+m9y6946VZot+XJrO0hGUSufU9d501JaEYzZWSiRbURN6pg00mL4q0
vNv6FMIiUFmC0W7xTqRdIDwCcN8bMVeQ7Nidbi5MV2jy8tORYui0PMu4Jnx1
o2HfDaX9RZYxY5m77HulLBNueBoOCQisRlovgut7xGsHnc/EGxPdg6guR8ZD
wTZjtqTU26erPJNwPwj3To4/Vo03iv2Z/ZAQpFUSrlcR6eWc7QRcIhFbjvJ+
NE9Kmot2Q1sEXQ+RZuQ/9c3I7A0c7+kl5iJdDdCIr+JNErw4a40TLsUhqQaV
Q2hQyh7xTUNP8ezDXTsfLHNkOxN649vHudb5fW75LJO3bu3gLluY+8I+HexW
1dHrCH0kBqHuUQyqeLk+EdyM6lGMTeDshrqkk50td3r5pHbxSllBVEqvfC5j
lS67qhfvW9DvtNPVKEnLP1N/JfXS2exW5ZHbCHmKwg7xpbTqoREpc9+fpB1F
zvU9BZ3u7VxW6XOoN//62FDsGJ712CYCRYHyXSHWGQ4puF+H2C7p3GeO4cfN
py2nErz556ngq3h0KNFZ+uKtPzqy6Jf6L/rWZsbuKLgUkvYbkodiErZsGr1+
HjlR6C0iJ4eDI1PNKa/IvRy7asD6DEIjUV6K4W7xvcrhvuq3ZSuZR41BY3lJ
EnGWX3hW+jT+JcNd6tNeiHuMumaMjkKl0qC4HR6nXtZKYG3YFB6O9c4QIldC
LcqGUDWG38tz8S7Fk8YikgT01wjotiTJJg9ce4J4wYsPwfQuqmqBGjWiwqVT
JZY5ZLelMzoOhYP4F1n/Dyg+dO1YGp1eL3p0ghpfTSqCuhHIKho7YkyO90TX
GSp6hJNOewfjUsUriNo3zz76WePqzW3pcee6paBbGLe0h2OMBaiYtcL6+eaD
LuZjSU9QMALtzapP9Yz4C6EpjiSNRuc4ekd7adsNlFTDcf7th2vD6w9HKi8G
wcv92TC08Yr+1sAcnXGYnxhHi37N1zBxF41K0m0bOm418zHVyMzCYz+tx/+K
emq2zji0bdPjvCmPc8How7qLFuPpN/mOJPBlPBQ9aM58VdZn9U+OI77f+Us9
u1rKTQ1XDzk6IzYSDSVQdYlxa6K7mFi5SLqGemaWDnf66xd/o9oytl9YuNsV
3snIakDzCNomyc0EkWwDRT9TZ4RFPzGChL42B+K84Hf66wgHcWY2U3QzdDjT
e1uv7DPZhVWPS4DhTlni7T/Jl/7GB81Xe6crM/GpMOHDxvKbyP8LTwPpdvmP
8NPezhZvhd+NyhQQwKTBHormlz/g+L5sE7TNvYLp3+cJTBLdsfgr4TZrOhoX
h5N4LaF40DFvNqZVmMSbbD7RIlsBlv4YV/pbJjRX7d0b+a4HySjdgqFRQvGd
cccOifcP3s2U+H6oh69IRvDHnDXMaeeFfonrQ5utw1Su/rh5YVDIFKbP5T8k
pH2k3lgv7N8Ta5kEt/UlWfb1vT4NvICEMtORcmWvvAISL/pbLHRs1fK6vf7T
RjdrZZYP35cKlKugaENtLPeDtf2EepZGF9J7NkYMt2bdmMsFJD9ESzk04rs0
agPjH3BaJstIc5grSyPkY6bslx373XH3EZ4+R8s4GsdUu+UZlbKe5dSzNO4j
6yfkafu2MldvfnSPZYqOP8DWEJwtwGA2kOpLvsozQ2s/BvSXZegvEmn5eZl8
kHlvb1X5+UZlUD1Si1jmcV6kgIkqDbbK8knnmSuo5/+kj99clkk3Xd99/4ym
PAQTAgavH0drjcclgd/EJobbiGl5vAEdYejMlnB8VeC4xQRet/D0MfqaBPcC
frx/w9YJO4YLns/lLuFKl3NGMl/p5tnnFB86p5gr8TXW2N9DZCFKu8VMjSRF
x33evZS33r3b4pLq5PFRe241puWt5O1UcZVpfiTDFLLra0cWPQzf9qTmZJ7q
1hM8eIhoN3LrTJRMul2/inqSrvG9LnGal358XXPMyYGmu6N8+gBKmlGVQWZL
5CS9A0NHTTq7lDktqj9iPvXgFmrToRJAVK8a/fXE0kRS6f2ur6kn6bMVMqez
dtjDOxx5JeL79BMq6VtBojTSu5LfUM/QNWOpsmERhjtl4l1b4lvEp6W3gunI
TNfSV8vU0lvz31K9dE3hK1k76WsNLKbdnp1G9bnMU/qWhpFeef/RXi5TS192
oWM9XTf8BNO+uSN9z41emWntpTLvTwj1OqqXrnAtlqn/8T2rH6spLJSpvyDU
G+S5oKnmYdqXFsgXtX4sp/m7zJOsg8F3VC+dd/xFppa+TEcjDTpH+A9Mwzrk
S2A/hq3/KPMmMhBvpVPFnNbWZkrbCPU2qpc+1XlLpt5JqLfLM6fvm0tik3zD
hPhfnTojtfIiT/JlD4OdVK++G6Ii9QFCTXCPDgLQohALQiPGkx9G8jkyDyvS
T0fnGXKvDekVdRAHsCMtg1/8X4OoL8U=\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9230],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " to get ellipsoids:"
}], "ExampleText",
 CellID->332788306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503769331],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJx1m3l01UWWx0NCgLAIjCg7JCSALGJzdNotUGER6bbdFRIQNwK227gvjaFB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    "], 
    {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJw12VW0lVUYRmH+n+6OI6BiUSrSjYBgYFCKgiihlBKiGDQYGLSBgkWXLYqC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      "]], 
     Polygon3DBox[{{721, 40, 39}, {721, 39, 38}, {721, 38, 37}, {721, 37, 
      36}, {721, 36, 35}, {721, 35, 34}, {721, 34, 33}, {721, 33, 32}, {721, 
      32, 31}, {721, 31, 30}, {721, 30, 29}, {721, 29, 28}, {721, 28, 27}, {
      721, 27, 26}, {721, 26, 25}, {721, 25, 24}, {721, 24, 23}, {721, 23, 
      22}, {721, 22, 21}, {721, 21, 20}, {721, 20, 19}, {721, 19, 18}, {721, 
      18, 17}, {721, 17, 16}, {721, 16, 15}, {721, 15, 14}, {721, 14, 13}, {
      721, 13, 12}, {721, 12, 11}, {721, 11, 10}, {721, 10, 9}, {721, 9, 8}, {
      721, 8, 7}, {721, 7, 6}, {721, 6, 5}, {721, 5, 4}, {721, 4, 3}, {721, 3,
       2}, {721, 2, 1}, {721, 1, 40}, {722, 681, 682}, {722, 682, 683}, {722, 
      683, 684}, {722, 684, 685}, {722, 685, 686}, {722, 686, 687}, {722, 687,
       688}, {722, 688, 689}, {722, 689, 690}, {722, 690, 691}, {722, 691, 
      692}, {722, 692, 693}, {722, 693, 694}, {722, 694, 695}, {722, 695, 
      696}, {722, 696, 697}, {722, 697, 698}, {722, 698, 699}, {722, 699, 
      700}, {722, 700, 701}, {722, 701, 702}, {722, 702, 703}, {722, 703, 
      704}, {722, 704, 705}, {722, 705, 706}, {722, 706, 707}, {722, 707, 
      708}, {722, 708, 709}, {722, 709, 710}, {722, 710, 711}, {722, 711, 
      712}, {722, 712, 713}, {722, 713, 714}, {722, 714, 715}, {722, 715, 
      716}, {722, 716, 717}, {722, 717, 718}, {722, 718, 719}, {722, 719, 
      720}, {722, 720, 681}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJx1m3lwllWWxkMIEMhHyM4qJAQEGQVtaaAh5r1Blp6u0VZAG3CsUUZcEB3B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     "]],
   Scale[
    Sphere[{0, 0, 0}], {2, 4, 3}, {0, 0, 0}]],
  Axes->True]], "Output",
 ImageSize->{154, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->238903350,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347290869],

Cell[TextData[{
 "The 2D version of ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Circle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Circle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->173013051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74441559],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->69919696]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243332541],

Cell[TextData[{
 "An implicit specification of a sphere generated by ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->509670244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68478577],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->684640774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204569051],

Cell[TextData[{
 "A parametric specification of a sphere generated by ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->261646573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540407307],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVewdUXNe5LlFz4jhO7DjXKS9+Kc/35ubePbIkS3bk7tixY/ug3iVLSIcu
CdEkmpBAIBBFIBBFVAkQHdF77x2G3ntvQ5s+8633zhxmLDyAr5zcddd6LJiZ
c2bvf3/f33Y5P5SWmZ72JS0z/Qtav/vMROuKnv4F09/9zciEubX5BxoaGjTz
Z/5LDebz/2U+sX80AOaLVa/vMq+bma82Ka4UH8D+aGxiPr7GtnhP7ZvNipct
T681NH77/0W77cyrgtXmVe01FMyV9xTv25TvK8w5ayQ9pzbWn/6H2m1V4vqJ
qr22trbi42/Yr/+wDjOVDTetK2t1q+eh9ABG5oq836/ps2XNnU3KMZ9Tvv8Q
an6kRPjrZ5b4slLCCr6V7szr95DwM6UEVqtbViSsCPnVM8v4iVLG8xvI+Jd1
dK3yohXoq4StI//Hqy259Rv5Sq6/ZBv9Yn0/2fJ0tKee+rzyXT1+f7wG/4rs
nzKvW9b1C3VfVGnz5XWRvvpdSFdJeVGJ7xerrKr4uEnt+hW2+ze+qCZlfe2q
ouJFZa9Xn2mMH6vJ3jBqvqONyoq/Vhths9r1z9kRtyh1ri6Fvd66mpJqfFVU
/WgD66oz3aJ2/fLGTNeNudf+m+SpfOZ3av23ql2/9IzyVJb9wzPJU8WCKjZe
UPZ+Xa31NrXrn7G9X8P6vqc+9nNq1z9le/9GaeN/f6bWv1IiXKG8Yvc/q7X8
odr1i2zTV9fp+Z/P1PNHG/BTZTPFre1qPX+kdv2Tb/T83XZbPYYiW/xWcf38
AUIfJ/TXhKYJbUBoY0JfI/RNQjsS2pnQ6qifV7t+gRW9SannLc+E4RtNKWcj
Ngf+ZD+hT7MgLhLalNCWhLYltAOh7xDag9D3Cf2A0MGE1tgcqnhhbqk09UwI
n007T6NaLVu8pEnow4Q+822AN1gtuRDak9C+hA4i9CNCPyZ0LKETOAzIhO3M
y5PtdOJ2xXf/JdIf/wN2XE8DbOS8ShH6IKFPElqLBX2ZteuKSl0JfY/Q/ow+
OXTYdjpyOx3Lgkzl0Jnb6ew36NyddN6bdM4uBnPWToZD9g46mdAKn/nJehzW
x7xNPYdqrIlxVtqvGKT7CH2M9UPGBXQIbURoC1a9twntRmhv1viM3R9z6Jjt
dMIbdMpOOmOXAmDhLrr4Tbp0N12+h658i8Fb8zaDt2KP4tbGeFUZXJWTNq26
XmOR3zP4mCBh/PMQi09bpUwmSJw4tDtH25uj/YCj/ZCjE8nRiePoJL6hk7ZD
J2unTv4uneI9OuV7tavepWvep+s/oBs/ops+pls+oVv+Sjd/rEDY8B5duINe
8VL1GFfOz0/1qI6PbfVHBp8mq8LDq/BdJdq2RMeJ6Lpz9Lw5eg84+qEc/ccc
gziOQfJ2w/QdBtm7DQreNih516DiA/3av+rXf6rH/Uy35XOdti+0O7/S7tak
ezTpbkoBsfsruv1zBXrl3LAeStVqc02Wff0bdEcIfYrQF4j2RaJjRnRsiJ4j
0Xcnht6ciw84l0I5lx9zjGI5xkk7TdL3mOT8xaTgPeOSD40rP7lS+9kV7pdG
LdSl9v2GnQcNeg7p9x3RGzymO3RcZ/g4M5z28DF66Cjdd5Bu/ftajD/8Fkb1
3MmuVhiIGq8z9j2q0J+2FtE1ILomRN+KGNqTyy7E+B4x8+OYB3OuhW+3iNlp
mbjHKn2vdc77NgUfWZd8al35uVXtV1aN+yxbD1l2HLnWfcy874TJ4Okrw19f
Hjt3cUJLf1JLjxlwUkt7SoueOEsPn6R7Dq3FyWrrmzXGeitZ9eyqzmWzisu/
sVy0TxGdc0RXl1w0IkbXiMkNYn6bWNwl1r7ENmj7jbBdN6P22CXstU993yH7
I8eCTx1L/u5Q8ZVD7X6HxkO3Wo/d6jxp33PGrv+s7ZCWzegFqwkdiyk98xl9
k1mDy8yYPEPdeUMdngE9o0tPnKeHztBr8tkKo21r8tdza+6wUfp0Xcz8bFbw
+NNBon2M6JwmhhfIlYvE3IxY2BDrW+SGK7Hz5jgE7HAK3e38eO+duPdckj9y
zfjULe9z9+Kv3Mv3udcccms46tZ80rXja9ceLdd++s6wjtOYnuOk4a2ZS3Y8
oxsLxjYLJhbMiEumRnxTA4GZzpIxPX+ZnjWgB76m1ZlsW4GpnN033lmor7Of
7g5XZClIsRb6s6Yim+gfJ0bniLkesTImNyyI/U3i4EScPLa7+O50D97tEb7X
M/r9e08+9kr7zDvny/uF+3zKDvlUH/WpP+nTdOZ+u9b9btq7X8972ODe2CWP
SaO7M8ZuPDOXxavOyxaOfEs7ZkiBtaXQ2kxsc0VspS+0oJfN6QVjuvccre45
257ZUuxKicP0ZFiwvzr7yOXDxOw0saTJjUvkljlxsiEut4i76xueXru8Avb4
PPyLX+T7/vEfP0j+LCDzq8D8/UElR4IrTwTXng7mngtqpYO6dIP6DAOHLgeO
GT+YNPWfuerLs7i/aOXFv+4pvOEuuunCDCext5fespU5WMnsTaV2F6U3tEU2
NM90jaW2bsBEtStRnSm8qIoVQhE9ihjvIxbHyfVzxF6POF0hbhbE8ybH22mH
z93d/j5vBwS9ExT+QWjMJ6FPPn+YRj3KORhWeDS8/FREzdmIhvMRzToRHfrh
PZfCB4zDR83CJq49mrYMnbMJXrQN4tsFiG75Sxx9pbe9GJCyOy5yFye56y24
XJffuSp3MpI76ont6NmrNKtrBZGNokb9hEB9FfCCihGHIgYUMaWI9UFid5Lc
Pk9cDYmnKblvvd3f/s0Al7eC770T6v/+o9CPIyI/jYz7Iip5X3TGoZi847El
p+MqteLqtOO5enFtF+O6jOL6TGOHr8aOW8VMXY+euxG5YP942SFc4PRIfCdU
6hosdQ9QkPLwlnt6yO+54t5teN6Qe1jK7xrLXfVFDvQWJSf1HdiWb+U61btq
FmYjZgfrXYYrRDSJwyHicop4XCDel4j/VU6Q7RuhjrvD3PZGeL8fGfDXmEef
xUV/mfBk/5PUw4nZJ5IKziSXnU+u1klpMEhpvpzSYZLSY54yYJk8apM8eTN5
xj6R5/hk0Tme7xIrco+RekTJ7kXIvB8puPgEyv385P734X8Xfs7wtYOPtdzb
VO6hx3ekWQrqc/AKl1fUrMFm950sB12KmFHEhiIOmsTtMPE6Q/x0SKARJ9Ri
e7jdzijnPTEe78T5fvgk+G9J4V+mxB5ISzqSnn4yPefrjKILmeW6WbUXs7lX
sltNszuvZfVZZQ3ZZo3bZU47Zs46Z/Bc0hbdUwWeyWKvJJnPE7lfvNw/WkEj
MEweFCoPCUSIL0LuIdgFQQ4ItIGfseyernr0rzD4+Wrt72KRG1PkOkUcNYn7
fnL/KAk4R0L0OWEm2yOtd8TeevOJy96kex+m+H+aFvJlxuMDWfFHc5JP5Wae
zcuj80v0CiovFdQbFzabF7ZbFnbbFA7cLBy5VTDhVDDrUsBzz1vwzF3yyhb4
ZIn9MmQBaQhKQUgiA0n+KEYeFimPCEdEMCL8EeGFcDeEOSLUGgFGfHd6zSrj
KXr1aFCwYBzIiiK3Ncnd/cTnEAk8QR6d5zw23B5jtivBZk+y4940tw8yvD/N
evBl7sP9+VFHC5+cKk49V5JNlxTol5ZeKqs2KW+4Wt5iVdFhW95rVz7oWD7q
XD7lVjbnUbbgVbrkU8z3KxIGFIiD82WhuXiUjfAMBbTIJEQnICYWsY8RE4qY
AMTcR8xdRDoizFIWYLgBC9V6dL3TD9VuUMWM8albDK0DxOcwCTpGwk9zoumd
8Zd2J5m/nWr7bqbTB7l3P82//0Vh4P7isCOl0afKE89VpmlX5ehXFV6uLjep
qbla02BV02Jb22lf23e7dsildty9ZvpeDe9+zaJf1XJApSCoQhRaJg0rlUcU
I7IQ0XmIzVYgTkhFYhIS45EYhcRHSAxEog/i3RBzC+HmGzDbuiafrX96uSaG
dlPEiCK2FHHTJD4HSNBhEn6UxJzhJOrsSjF6K+PaOzk3P8h3/qTY44tS333l
QUcqw09Wx5yrSdKuyzCoz73cUGTSWH61scaqsdG2sdWe23mb2+fCHb7LnfDi
zvhw5x9wl4Ia+CH1wke14ogaSWSVLKZCHleOhBIkFilIpOQgLRNpKUhLQHo0
0sORFoxUHyS6IM5WEqK75izh+/FVnYgoeFpQxIki3pok+ACJOERij5Oks5x0
vZ3ZV/bkWb5bZPdxqfPnFR6aVb6HaoJP1EWcbYiluckGzZmXW/JMWouvtpZb
tdbYtjbat7bebu1yaeu72zbs1Tbh2zYb0LYQ0rb0sJUf3ix4zBVGN4pj6yUJ
tbLEGnlyFVLLFeAzi5Cdj+wsZKci5wlyYpETgawgZHgjxVkaabLGrpv/abva
UcSDIgGaJGI/iT1Ekk6SDC2Sq7+r0HhvidWHFXZ/q3L+qsbjQJ3vscbgM00R
F1ri9NpSLndmmXblX+sqse6quNFde6ub69Td5trd7dE94N0z6tczGdgzF9Kz
GNaz9LhrOaqDH9MmiG8RPWkWJ3MlqQ2y9Hp5Vq2CRF4F8ktQUICCHBSmozAJ
hbHID0NuADI9kGT7/fius9d9UcnShSK+FHlEkdj9JOkIyTjNybuws9jg7XKT
96usPqm1+6LeeX+jx5Em31MtwVrtj3W74i/1pJj0ZV3rL7AZKL05UOUwWO88
2Ow22OE52HN/aNB/aCxoaCp0aC58cDFycDmmXxDfJ3zSI0zqEqV0iNLbxJkt
0uwmWR5XAb2oFsVVKClFaSHKclGWgbIklMag6CHyfZHu8P1YrnsqynrvHopc
ocg9igRTJIoiSftJxrE38r7eVUy/VWH4bo3px/VWnzfaaTY7H271PNnhd64r
VKc38mJ/vPFg6rXhbJuRgpujpQ6j1c5jDe7jLffGO30m+h5MDAWNjz0cnw4f
50WNLcWO8RNGhUnDotQhcfqAJLNPktMjzeuSFXTIitoU+MubUFGPympUlqOq
CNV5qMpAZSLKo1ASjLy76zNVZdzVJwFrfJVhZ81aMYwi8RTJOLgj7/ju4rNv
V2i/W3vxQ67p35qtqTb7Q50uJ7rvne17oD3w0HA46spowtWxVOuJnJuThQ5T
Zc7T1e7TDfdmWn1mOh/M9gXPDD2cGY+YmY6a4cXNLD2Z5idPCdMmxZnj0pwx
Wd6IvGBIXjyA0j6U9ygwV7ejphm1DairQX0F6otRn4vaNNTEozIMxffXZ/fy
6gzDsLhFkSCKRFMkheLkHN5ZeHJPudbeGp33Gy9+0mb2ZafNgR6H431uXw96
0yMBBmOPjCaizCYTLKdTb8zmOMwVOvPK3HjVnvMNPvMt/vOdQQt9DxeGIhbG
oxem4+bnE+eXUnj89Dlh1qw4d0ZaMC0vmkLpBMrHUDmM6kEFtvoeNHSgsQXc
RjTVoqkCTcXgZqMhBbXRKH+wMYs1NvkTRe5Q5CFFnlAkc9/2giO7Sk+/VaX1
TsP5D9suft5ltq/P5sigw+lht/Nj3nqTAZenH5rORFnMJVyfT7VfyHFaKnRb
KvNcrr6/3OC/3BLE73jI743gD0Xxx+P404n8+VT+YsYyP3tJmLcoKpiXFPNk
ZXPyihlUTyngMQptGkBzL1o60dqKNi7aatFWjtZCtGSiMQE1oRMJV9Rnhu9g
8zqbCiMokkqR3ANvlBx7s/L02/Vn3ms5/0mX4Vf95oeGbU6MOpydcNWZ9jKc
fWA8F3p1PtJ6McFuOfW2INtVWOgpKvMWVfmJ6gNFzaHijnBxb5R4ME48liie
ThXPZ0oWs8XLeUJ+oUBYsiwuW2JhMZu5xlk0TaFlQgGyfRAdfejsQlcburjo
rEZnKdpz0ZyEhghe5vU1uYKNFfaUX7WjUpyVMd6VSZGigzsqju2uPb63+cSH
Xec/6zfcN2x2bNzmzJTDhRlXfd69y/P+ZoshlsuPbQXxDqKUO+JsD0mht6TM
T1IVKK0PlTaHSzuipL1x0sFE6ViqdDpDysuRLuVLl4skK9hfEtfwpfXLMu4S
mhfQykP7DDonFeC6h9Dbj94u9LWitwG9VeguQns6mqLXnJg8ZbDaIuwK+DU2
1HMoTtnBnTWH3m46/F7n8b/2a305bHBw3PTktM25uVu6Cy4XFz2Nl/2uCUJs
RBH24jgnSYq7NMtLWuArLQ2UVYfK6sNlzVGyjjhZb6JsKFU2liGbzpGx+F8R
VkhF1RJRrVjcIJJwRdIWgbydj84ldM+jZxa9UwqYA8MY7MNgJwabMVCHvlJ0
Z8taYtfnsQXf/Sx9s2p1/2uKJFIkj9perflm476/tB/4oO/Y34bPaY7rH5k2
OcOzphftDfh3jASe5kI/K1HITfFjR2mcqyzFU5blIysIkJeGyKvC5PVR8uY4
eUeifAv76HGuWL5YJudXysU1MkmdTNoolTZJZK1ieYcIXSL0CNG3jP55DMwq
cA+PYWQII70YacdwIwYq0JcnbY3bwEJrz8A3OJl4VcmMU6u5q2Xf2937Pxw8
9vnouf2T+sfmTM4uWukK7C8J75iKPC3FfszqzUH6+I4s7q482Vue6S/PD0bJ
I1RGrgDQ+E1PBgazMZqPySLMlWGhEvwaiOrlMq5c3iJDmwydUnRL0CtBvxiD
QgwtYXgeIyzBsVGMD2C8G2MtGKnBQKGk7XuyU1v/s/H1CpvvGH711M4Ozb/0
7fvryPEvJrQOzhicmDfW4lvoi+yuiJ2vSjxspL72shAneYQ7Yr2Q5IuMQHYn
rvFaXQK4yWhLR3cWBvIwUoSJMsxWYr4Gy/UQciFtAdqBTqBHjj4ZBmUYkmJE
glEBxpYwPo+JGQWFqRFM9mGiDWP18sEicXvcP2m7l5glEsutkdrZpfnu4L5P
x49/Na11mKd3esmIFl27KLlhKnWylN+9AR8HBLkgzENpqd/lhqMoCuXxqElE
YypaM9GZi75CDJdivBLTNeDVY5ELQQvE7ZB1McyAfmAQGAZG5RiXYUKMSQGm
ljDNwwzLb3oAUx2YaJQNFamfMm3EbPUpk/rzdo0XmNROcZqoN7up90f2fTZ1
fN/c2WOLOmcFF3Wl5pdl181x2wZsLP0xyhcJgUh9hOxIxbK07AmqU9CQgeYc
dBSgtwRDFRirxlQ9ZrlYaMZyG4SdkPRAzrAaAkaAMWACmJJjWoYZMWb5mFsE
jwcemyNnuuWTjdKhojVntt/FbNUdJU/2SdOPWF4t1J5e6sPRfX+fPXpg4cxJ
Pn1ebGggX7HPv7k6wMsF/h4IuY/HDxAXguRwZEYjPwElyahMQ10WuHloK0J3
GQaqMFrH6B3TzeC1YbET/B6I+iFdITYOTDLEgBlgDuBJMC/EwhIW5uXzipwp
n+2WTTZKhgrXnLD/4FtZUnXqtPqZLctnm8IJSZOCzwej1Je8g4eXWRb/fsUU
lpawu4k7t+HpBt97CPJFeCBiHiLxMdJjkZuIolSUZ6ImF43MUqAUnUxeq8Fw
A8aaMNmK2Q7Md2OpD4JBiEcgX+EyDcyyXOaBBQkWhVhaxtKibGFKxhtmRpZO
Nax5PrTC5WdKDiszGEUaqDcVq0W2akjjPw99LT2tI9e+hEtmMLeGrR1uO+Pu
Xdz3RoA/HgYjMgwJUUiNR3YyCtJRmo2qfMXSsqkc7dXoqcdgE0ZaMd6OqS7M
9WJhAMvDEI1BMgnZCmoei3oRWJJiWYhlAfh86eKMdH5EylNA2Rj36vhQxD+r
4zeod0eoL3jUUeG+s7LjunItIxiYw8QGVrdgfweunvDygX8AQkIREYHYGCQ/
QWYq8rNQnIeKQtSWglupWIx1NaK/BUPtGO3CRC9mBsAbxtIYBBMQTUM8CykP
8gUW+TLAl0IghkAkFwilS7OShREJrxvs8+n1fUgdv6KVInLZ6NlO7eyk3hmm
/s7QEO0/Kz2iJ//6CnSuweg6rjnghguc7sHDDz5BCHqEsEhEx+FJEtLSkcts
RQtQVoLqCjTUoKUBnc3obcNAJ4Z7MN6PqSHMjWJhAktT4M9AOAfRPCSLkDEc
BIBQBqEUIolcJJLy58SLo/NTLWueDquv4tZn9EOlRdjTTg5Fqqm9CkaaR0UH
z0qO6stOGeOCBQxtYeoIa1fc8oKrP7xD8CAcD6MRmYD4FKRkIisPBUUoKUNl
Ferq0MRFeyu6O9DXjaE+jA5icgQz4+BNYX4Gi3NYnodgEaJliAWQCCEVySUi
mUQklYiEIv7cPG9A/SR5fTY/VWOzTcmGzXb/Su3uoj6bpQ4L938tOawnO26M
s5bQvQmj27Bwx01vOD+A50P4PUZwLMITEZuGpGykFyC3BEUVKKtBdQMamtHS
jo4u9PRiYBDDIxgfx9QUM3dgbg7z81hcVIQxXwCBEJuEImb3LBTJhGKpQChY
XJ7uH2teU8+jvl9Y4aKw339VIbJZyY+dZ16nPhqnDvI1z0gO6siOGOGEBS7c
xEUnmN2FzX04BMDtEe5HISAeD5MRmY74HKQUIrMUeZUorkVFI2pa0NiBlm7F
hqBnCAOjGJnA+DSmZjHDw+wCeEy+5WNRoEhWGpuWGHZblsTyJZFkXrDcO9Gt
fkauYPYD5lLB6AdPZ5hnqsdQxBW7Z/oDRc1Tp8T7teWHLuPYNZy+AV1nXPGA
hQ9uBsE5DB5R8E1QHCWHZSA6F0+KkFaO7Grk16OEi8pW1HWC24PWAXQMo2cM
A5MYmcEYD5MLmF5i50gBNs0xlLbyROCJmV/5jFA4uji3xs+2/ROM2Dqx/00d
WaZo+YFLOGyO47Y45wRDD5j7wiYIt8LgEo17CfBPRUgWIvIQW4ykCqTXIKcB
hc0oa0dVF+r6wB1E6wg6x9E7zSysFavP0UVMLDM2YRYzGtsmhZgSsb9i+ZhA
Mri0tN7zsu/LQ31/8YsVPn9pp04LKQMcNMPR6zjhCPouLvviWhBsw+AYDbcE
eKciIAsP8xFZgvhKpNQisxG5LSjqQHkPqvpRNwTuKFon0TmDnjn0LWBgEUMK
PiMMn60jQoyKMCSQ9y/LOhcEa2b4f4SNaj2gqCHV+D/UZ0OUlpi6LD9ojWMO
OOMO3fswCoTFI9yMhlMC7qbCJxtBBQgrRXQlEuqQwkVmK/I6UdSD8gFUD6Nu
DNxJtMygbQ6d8+heQu8y+gToF6JXIO9alrctyprmxeq1KVv+AfTbVqP/PaUj
oUxl+2/guCvOekPvAa48hGUk7BJwJxWe2fAtQHApwioRXYcELlJakdmJ3F4U
DqB0GJXjqJlE/Qy4c+ymehFty2A2pa3Lcu6irH5eVjMnVebWb59qfBv16mqa
1VXIrJ/8ijKUUNdkmg446oGzftALgfFjWMbDPgV3suCZD98SBFUirA5RXMS3
IqUTGT3IGUD+MIrHUDaJymlUz6F2nvGKugVGH3UL8iqevHxOljmy/JIauk1r
0KnqD9Xz6Ra1tSD7ROlVykpKOcsPe+FMAHQf4UoMLJNgnwHnPHgUw6cCgbUI
rUNcK2J6kdSL1H5kDCF7FHnjKJxC8QxKZhkUJXPMWIUz8qQh0TeyN0C5qp58
tdXVkLL2fomylx70wakgaEfgcjwsUnEjG7cL4F4Gryr41uEBF2FtiOxCbC8S
BpA0xIyVOsqISB1D6jjSxhHZJ2Lz0dbV1ReKpdgKFkVEPXtl3+oWrLV/pqgU
cJUcCsSZcOjGwTgVVjmwK4RTGdyr4VUPvyYEtiG0E2E9CO/FpvA+Rkp4P4K6
pQoBv/wObOvqaU2m2rDO+ccnInE+AYZpMMuFdRFulMGhCnfq4FIPlwa4NmKl
Avdb9drPOvIWpZepW3p1Vej3YaKKpZfV5BHF/W9wvYCnkadaF6zO1Oo+rp6B
ON/yw1fWoFhvz6Qu49uIVJXt310rozqlUpelqNvdoqof2ACPxnOrd6VP5anP
Da8rZT23gSzV3l31rt5fUT29VbUj2KD/ahuq5KzWlfoK738pMa3UOqtq1FQz
kvJRovJndX3qN/9PsUrWL5WyVurpf70G38bPH1cjVF+T/lzJ+pfPLFU9U6hL
/KkS52+fWaJKk+qSnldi+/0zS1JFkYqxIgJ/pMTzr88sRTWfbVX2ZGvE2Vrz
1bPeeqewKo0rULP/T7RSx/6dZ39v/g+1U2Ws9fYZb2zQR93n1+YttnZd449Y
Jy+t0+4/nlHef3e7P6vZboXv2v/L0/jB/wPTjdJv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->145738026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12991973],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChemicalData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChemicalData"]], "InlineFormula"],
 " plots a molecule using spheres and cylinders:"
}], "ExampleText",
 CellID->380548320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<MoleculePlot\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287154983],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJwtUw1MjWEUbjSzpFmrlaYisVBrLSqUDmlJqHvLvbdbrtv9q/une2+XWmRC
wxgLtSkjN6GttaIhjLOYyVKYxNIoK3+Zv/IXm/d9j7N9O9v7nfec53nO887R
FEr1k9zc3CLZN5l9fxq/PF4fEgffw3KPdJRp8KwtwaNvUQHcHmcHX+3YV88O
5GkYzSNThVObZil1Wjm+mx81tckzHdx4vFXjgy4WO4xQnXTQ8mZiLcx0l3lF
eEvAgzf4rcbtPs0pgwuVeK72zuwWRxIEV3yQXFXl0ZwQPWVpLip1y1+m+2bB
qORqUIU5HC7cTYs90AqwRHUt1dN7NbiSL3/7q9sIbyYY8KpMlOe03hpVhaCV
Hyg3Is1V0P25BsKbBrgH759JrpaigceIFQQelwbKqxjgfbHEuygPBd4hNQyW
soLKQqr/aofFu67Abo0vcNhBVQaws/J6hQUXMNnG9xtxIHRKeZVWQby6nSB0
8zOC4Hs0DllVWG6xhXJPPulWYiHd4nWkS2kG1Jxg0erEz+c58XRkKEt9Nhhh
DQfUYyc8XkWk15AC+fiwUD1wOqV7rdC57ebpgE8xIHDNsAOHaessJry4jubW
GUifCSPxPmgi3lIjzS930t6v6NHvefePzKIsYNUfJBkmFDguOfCYPxO6LBXq
fkaNNA8HApd5+aJNqFjadm9bgAbaeb27lXg8Ssb+XztNN5wKfMFz2zLkLmnc
KoWxv09K3l1U4s/M1w2179V4h/PaHQGr1MMPQ6KVKPY/bxNy1xQ0KIDDrY8v
wLJE5ojbeSD2O20liP2bUv/rZwZ+vT8vGxy8Xh0DXOauli1wMtrVFnshAY5+
3JG4JGgz4Oip+PDZUhQ4OuQo3sFwBvnjsBaF8cIkKPq1R+EKLlSjgd5Dupb4
ekmIv1YGx7kuvZuht4S9kDE58nUfceWTL4a0NDdAQr55Zac9vdDTvelxKPCP
G1DgVeiIr/sWFPo/05DPgrPJhwkOrAuIHAiVZZMP/PUgcpeNfLLLAVgWGJd/
KAVFHzZH9FHa4KlsNPJ6Sjj5IMcCUv5jwAnFEXOCxyyJIHDXGED4b6GZ+nmY
8IaTbb5DQ7hldiQ/5eNvvl6zjHyYZSY8JYXkk0op/ANM5hbS
    "], {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[15, 24.], SphereBox[16, 24.], 
      SphereBox[17, 24.], SphereBox[18, 24.], SphereBox[19, 24.], 
      SphereBox[20, 24.], SphereBox[21, 24.], SphereBox[22, 24.], 
      SphereBox[23, 24.], SphereBox[24, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[7, 34.], SphereBox[8, 34.], 
      SphereBox[9, 34.], SphereBox[10, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.], SphereBox[13, 34.], SphereBox[14, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[3, 32.], 
      SphereBox[4, 32.], SphereBox[5, 32.], SphereBox[6, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.], 
      SphereBox[2, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{38, 15}, 15.], 
      CylinderBox[{39, 16}, 15.], CylinderBox[{40, 17}, 15.], 
      CylinderBox[{41, 18}, 15.], CylinderBox[{42, 19}, 15.], 
      CylinderBox[{43, 20}, 15.], CylinderBox[{44, 21}, 15.], 
      CylinderBox[{45, 22}, 15.], CylinderBox[{46, 23}, 15.], 
      CylinderBox[{47, 24}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{25, 9}, 15.], 
      CylinderBox[{26, 10}, 15.], CylinderBox[{27, 8}, 15.], 
      CylinderBox[{28, 10}, 15.], CylinderBox[{29, 12}, 15.], 
      CylinderBox[{30, 7}, 15.], CylinderBox[{31, 11}, 15.], 
      CylinderBox[{32, 13}, 15.], CylinderBox[{33, 9}, 15.], 
      CylinderBox[{34, 10}, 15.], CylinderBox[{35, 14}, 15.], 
      CylinderBox[{36, 8}, 15.], CylinderBox[{37, 11}, 15.], 
      CylinderBox[{7, 8}, 15.], CylinderBox[{7, 9}, 15.], 
      CylinderBox[{11, 38}, 15.], CylinderBox[{12, 39}, 15.], 
      CylinderBox[{12, 40}, 15.], CylinderBox[{12, 41}, 15.], 
      CylinderBox[{13, 42}, 15.], CylinderBox[{13, 43}, 15.], 
      CylinderBox[{13, 44}, 15.], CylinderBox[{14, 45}, 15.], 
      CylinderBox[{14, 46}, 15.], CylinderBox[{14, 47}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{3, 27}, 15.], 
      CylinderBox[{3, 28}, 15.], CylinderBox[{3, 29}, 15.], 
      CylinderBox[{4, 30}, 15.], CylinderBox[{4, 31}, 15.], 
      CylinderBox[{4, 32}, 15.], CylinderBox[{5, 33}, 15.], 
      CylinderBox[{5, 34}, 15.], CylinderBox[{5, 35}, 15.], 
      CylinderBox[{6, 36}, 15.], CylinderBox[{6, 37}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 25}, 15.], 
      CylinderBox[{2, 26}, 15.]}}]},
  Boxed->False,
  ImageSize->289.7480032635572,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{294, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444385097,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58680780],

Cell[TextData[{
 "Several ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " formats use spheres to represent molecules:"
}], "ExampleText",
 CellID->542043455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", 
   RowBox[{"\"\<Rendering\>\"", "\[Rule]", "\"\<Spacefilling\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->508200095],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[2], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJxVmXtw1NUVx1eZUtBUQBnrA60oDQ8jAmGcqBQXKBEk5WECJELIgyTknWyS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    "], {
     {RGBColor[0.4, 0.4, 0.4], SphereBox[2, 170.], SphereBox[3, 170.], 
      SphereBox[6, 170.], SphereBox[7, 170.], SphereBox[9, 170.], 
      SphereBox[10, 170.], SphereBox[11, 170.], SphereBox[13, 170.], 
      SphereBox[14, 170.], SphereBox[16, 170.], SphereBox[19, 170.], 
      SphereBox[20, 170.], SphereBox[22, 170.], SphereBox[23, 170.], 
      SphereBox[24, 170.], SphereBox[28, 170.], SphereBox[29, 170.], 
      SphereBox[31, 170.], SphereBox[32, 170.], SphereBox[33, 170.], 
      SphereBox[35, 170.], SphereBox[36, 170.], SphereBox[38, 170.], 
      SphereBox[40, 170.], SphereBox[42, 170.], SphereBox[43, 170.], 
      SphereBox[45, 170.], SphereBox[46, 170.], SphereBox[47, 170.], 
      SphereBox[48, 170.], SphereBox[49, 170.], SphereBox[50, 170.], 
      SphereBox[51, 170.], SphereBox[54, 170.], SphereBox[55, 170.], 
      SphereBox[57, 170.], SphereBox[58, 170.], SphereBox[59, 170.], 
      SphereBox[61, 170.], SphereBox[62, 170.], SphereBox[65, 170.], 
      SphereBox[66, 170.], SphereBox[68, 170.], SphereBox[69, 170.], 
      SphereBox[73, 170.], SphereBox[74, 170.], SphereBox[76, 170.], 
      SphereBox[77, 170.], SphereBox[81, 170.], SphereBox[82, 170.], 
      SphereBox[84, 170.], SphereBox[86, 170.], SphereBox[87, 170.], 
      SphereBox[89, 170.], SphereBox[90, 170.], SphereBox[91, 170.], 
      SphereBox[93, 170.], SphereBox[94, 170.], SphereBox[96, 170.], 
      SphereBox[97, 170.], SphereBox[98, 170.], SphereBox[100, 170.], 
      SphereBox[101, 170.], SphereBox[103, 170.], SphereBox[104, 170.], 
      SphereBox[105, 170.], SphereBox[109, 170.], SphereBox[110, 170.], 
      SphereBox[112, 170.], SphereBox[113, 170.], SphereBox[117, 170.], 
      SphereBox[118, 170.], SphereBox[120, 170.], SphereBox[121, 170.], 
      SphereBox[122, 170.], SphereBox[123, 170.], SphereBox[125, 170.], 
      SphereBox[126, 170.], SphereBox[128, 170.], SphereBox[129, 170.], 
      SphereBox[130, 170.], SphereBox[131, 170.], SphereBox[133, 170.], 
      SphereBox[134, 170.], SphereBox[136, 170.], SphereBox[137, 170.], 
      SphereBox[138, 170.], SphereBox[140, 170.], SphereBox[144, 170.], 
      SphereBox[145, 170.], SphereBox[147, 170.], SphereBox[148, 170.], 
      SphereBox[149, 170.], SphereBox[150, 170.], SphereBox[151, 170.], 
      SphereBox[152, 170.], SphereBox[153, 170.], SphereBox[155, 170.], 
      SphereBox[156, 170.], SphereBox[158, 170.], SphereBox[159, 170.], 
      SphereBox[160, 170.], SphereBox[161, 170.], SphereBox[162, 170.], 
      SphereBox[163, 170.], SphereBox[164, 170.], SphereBox[167, 170.], 
      SphereBox[168, 170.], SphereBox[170, 170.], SphereBox[171, 170.], 
      SphereBox[175, 170.], SphereBox[176, 170.], SphereBox[178, 170.], 
      SphereBox[179, 170.], SphereBox[183, 170.], SphereBox[184, 170.], 
      SphereBox[186, 170.], SphereBox[187, 170.], SphereBox[188, 170.], 
      SphereBox[189, 170.], SphereBox[191, 170.], SphereBox[192, 170.], 
      SphereBox[194, 170.], SphereBox[195, 170.], SphereBox[196, 170.], 
      SphereBox[200, 170.], SphereBox[201, 170.], SphereBox[203, 170.], 
      SphereBox[204, 170.], SphereBox[205, 170.], SphereBox[209, 170.], 
      SphereBox[210, 170.], SphereBox[212, 170.], SphereBox[213, 170.], 
      SphereBox[214, 170.], SphereBox[215, 170.], SphereBox[216, 170.], 
      SphereBox[217, 170.], SphereBox[218, 170.], SphereBox[221, 170.], 
      SphereBox[222, 170.], SphereBox[224, 170.], SphereBox[225, 170.], 
      SphereBox[226, 170.], SphereBox[227, 170.], SphereBox[229, 170.], 
      SphereBox[230, 170.], SphereBox[232, 170.], SphereBox[233, 170.], 
      SphereBox[237, 170.], SphereBox[238, 170.], SphereBox[240, 170.], 
      SphereBox[241, 170.], SphereBox[242, 170.], SphereBox[244, 170.], 
      SphereBox[245, 170.], SphereBox[247, 170.], SphereBox[248, 170.], 
      SphereBox[249, 170.], SphereBox[251, 170.], SphereBox[252, 170.], 
      SphereBox[254, 170.], SphereBox[256, 170.], SphereBox[258, 170.], 
      SphereBox[259, 170.], SphereBox[261, 170.], SphereBox[262, 170.], 
      SphereBox[263, 170.], SphereBox[265, 170.], SphereBox[269, 170.], 
      SphereBox[270, 170.], SphereBox[272, 170.], SphereBox[273, 170.], 
      SphereBox[275, 170.], SphereBox[276, 170.], SphereBox[279, 170.], 
      SphereBox[280, 170.], SphereBox[282, 170.], SphereBox[283, 170.], 
      SphereBox[284, 170.], SphereBox[286, 170.], SphereBox[290, 170.], 
      SphereBox[291, 170.], SphereBox[293, 170.], SphereBox[294, 170.], 
      SphereBox[295, 170.], SphereBox[296, 170.], SphereBox[297, 170.], 
      SphereBox[298, 170.], SphereBox[299, 170.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[1, 160.], 
      SphereBox[5, 160.], SphereBox[12, 160.], SphereBox[18, 160.], 
      SphereBox[26, 160.], SphereBox[27, 160.], SphereBox[34, 160.], 
      SphereBox[41, 160.], SphereBox[53, 160.], SphereBox[60, 160.], 
      SphereBox[64, 160.], SphereBox[72, 160.], SphereBox[80, 160.], 
      SphereBox[85, 160.], SphereBox[92, 160.], SphereBox[99, 160.], 
      SphereBox[108, 160.], SphereBox[116, 160.], SphereBox[124, 160.], 
      SphereBox[132, 160.], SphereBox[139, 160.], SphereBox[141, 160.], 
      SphereBox[142, 160.], SphereBox[143, 160.], SphereBox[154, 160.], 
      SphereBox[166, 160.], SphereBox[174, 160.], SphereBox[181, 160.], 
      SphereBox[182, 160.], SphereBox[190, 160.], SphereBox[198, 160.], 
      SphereBox[199, 160.], SphereBox[207, 160.], SphereBox[208, 160.], 
      SphereBox[220, 160.], SphereBox[228, 160.], SphereBox[235, 160.], 
      SphereBox[236, 160.], SphereBox[243, 160.], SphereBox[250, 160.], 
      SphereBox[257, 160.], SphereBox[264, 160.], SphereBox[266, 160.], 
      SphereBox[267, 160.], SphereBox[268, 160.], SphereBox[274, 160.], 
      SphereBox[277, 160.], SphereBox[278, 160.], SphereBox[285, 160.], 
      SphereBox[287, 160.], SphereBox[288, 160.], SphereBox[289, 160.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[4, 155.], 
      SphereBox[8, 155.], SphereBox[15, 155.], SphereBox[17, 155.], 
      SphereBox[21, 155.], SphereBox[25, 155.], SphereBox[30, 155.], 
      SphereBox[37, 155.], SphereBox[39, 155.], SphereBox[44, 155.], 
      SphereBox[52, 155.], SphereBox[56, 155.], SphereBox[63, 155.], 
      SphereBox[67, 155.], SphereBox[70, 155.], SphereBox[71, 155.], 
      SphereBox[75, 155.], SphereBox[78, 155.], SphereBox[79, 155.], 
      SphereBox[83, 155.], SphereBox[88, 155.], SphereBox[95, 155.], 
      SphereBox[102, 155.], SphereBox[106, 155.], SphereBox[107, 155.], 
      SphereBox[111, 155.], SphereBox[114, 155.], SphereBox[115, 155.], 
      SphereBox[119, 155.], SphereBox[127, 155.], SphereBox[135, 155.], 
      SphereBox[146, 155.], SphereBox[157, 155.], SphereBox[165, 155.], 
      SphereBox[169, 155.], SphereBox[172, 155.], SphereBox[173, 155.], 
      SphereBox[177, 155.], SphereBox[180, 155.], SphereBox[185, 155.], 
      SphereBox[193, 155.], SphereBox[197, 155.], SphereBox[202, 155.], 
      SphereBox[206, 155.], SphereBox[211, 155.], SphereBox[219, 155.], 
      SphereBox[223, 155.], SphereBox[231, 155.], SphereBox[234, 155.], 
      SphereBox[239, 155.], SphereBox[246, 155.], SphereBox[253, 155.], 
      SphereBox[255, 155.], SphereBox[260, 155.], SphereBox[271, 155.], 
      SphereBox[281, 155.], SphereBox[292, 155.], SphereBox[300, 155.], 
      SphereBox[301, 155.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-2.5145218716634106`, 0.03179619103164899, 
   2.2584438800116806`}]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312621358,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14761],

Cell["Random sphere collections:", "ExampleText",
 CellID->416227571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", "3", "}"}]}], "]"}], ",", 
        RowBox[{"RandomReal", "[", "0.1", "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "200", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144985119],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->67492215]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133213040],

Cell["Cubic lattice of spheres:", "ExampleText",
 CellID->32377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"#", ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", "3"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14861],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{-2, -2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, -1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 0, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 0, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-2, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, -1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 0, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 0, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{-1, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, -1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, -1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, -1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, -2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, -1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 2}, NCache[Rational[1, 2], 0.5]]},
  ImageMargins->0.,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->483945881,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15951],

Cell["BCC lattice of spheres:", "ExampleText",
 CellID->16580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"#", ",", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], "&"}], "/@", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Total", "[", "#", "]"}], ",", "2"}], "]"}], "\[Equal]", 
       "0"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30647],

Cell[BoxData[
 Graphics3DBox[{
   SphereBox[{-3, -3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, -1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 0, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 0, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 0, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 0, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-3, 3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, -1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 0, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 0, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 0, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-2, 3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, -1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 0, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 0, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 0, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 0, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{-1, 3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, -1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 0, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 0, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 0, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{0, 3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, -1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 0, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 0, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 0, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 0, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{1, 3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, -1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 0, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 0, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 0, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 1, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 1, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 1, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 1, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 2, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 2, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 2, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 3, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 3, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 3, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{2, 3, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, -1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 0, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 0, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 0, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 0, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 1, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 1, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 1, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 2, -3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 2, -1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 2, 1}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 2, 3}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 3, -2}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 3, 0}, NCache[2^Rational[-1, 2], 0.7071067811865475]], 
   SphereBox[{3, 3, 2}, NCache[2^Rational[-1, 2], 0.7071067811865475]]},
  ImageMargins->0.,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->384523419,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->469658180],

Cell[TextData[{
 "Sample points used by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->31164110],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"val", ",", 
     RowBox[{"{", "data", "}"}]}], "}"}], "=", 
   RowBox[{"Reap", "@", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}], "<", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "2"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23089588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"#", ",", ".05"}], "]"}], "&"}], "/@", "data"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->61085999],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->713212628]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31270],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cylinder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cylinder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->187977964]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5080],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Sphere",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Sphere"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->764445423],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->28701776],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->63023992],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->196673562],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->126107051],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->172854264]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sphere - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 17.8725532}", "context" -> "System`", 
    "keywords" -> {"sphere", "ball", "3D sphere"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sphere[{x, y, z}, r] represents a sphere of radius r centered at (x, y, \
z). Sphere[{x, y, z}] represents a sphere of radius 1. ", "synonyms" -> {}, 
    "title" -> "Sphere", "type" -> "Symbol", "uri" -> "ref/Sphere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8597, 264, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->602831967]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 826003, 14595}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2996, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3619, 95, 1571, 37, 70, "ObjectNameGrid"],
Cell[5193, 134, 1335, 44, 70, "Usage",
 CellID->25095]
}, Open  ]],
Cell[CellGroupData[{
Cell[6565, 183, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7043, 200, 316, 12, 70, "Notes",
 CellID->1942],
Cell[7362, 214, 450, 15, 70, "Notes",
 CellID->23362],
Cell[7815, 231, 276, 9, 70, "Notes",
 CellID->3427],
Cell[8094, 242, 466, 17, 70, "Notes",
 CellID->16641]
}, Closed]],
Cell[CellGroupData[{
Cell[8597, 264, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602831967],
Cell[CellGroupData[{
Cell[8982, 278, 148, 5, 70, "ExampleSection",
 CellID->141158433],
Cell[9133, 285, 67, 1, 70, "ExampleText",
 CellID->23083],
Cell[CellGroupData[{
Cell[9225, 290, 193, 6, 28, "Input",
 CellID->3794],
Cell[9421, 298, 27707, 459, 184, 62, 1, "CachedBoxData", "BoxData", "Output",
 CellID->8442]
}, Open  ]],
Cell[37143, 760, 121, 3, 70, "ExampleDelimiter",
 CellID->10971],
Cell[37267, 765, 63, 1, 70, "ExampleText",
 CellID->6679],
Cell[CellGroupData[{
Cell[37355, 770, 428, 14, 70, "Input",
 CellID->31732],
Cell[37786, 786, 30117, 499, 204, 109, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->1309]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67952, 1291, 220, 7, 70, "ExampleSection",
 CellID->103486585],
Cell[CellGroupData[{
Cell[68197, 1302, 241, 7, 70, "ExampleSubsection",
 CellID->494790463],
Cell[68441, 1311, 57, 1, 70, "ExampleText",
 CellID->453908246],
Cell[CellGroupData[{
Cell[68523, 1316, 197, 6, 70, "Input",
 CellID->93580876],
Cell[68723, 1324, 38467, 635, 216, 62, 1, "CachedBoxData", "BoxData", \
"Output",
 CellID->478265894]
}, Open  ]],
Cell[107205, 1962, 124, 3, 70, "ExampleDelimiter",
 CellID->79700778],
Cell[107332, 1967, 72, 1, 70, "ExampleText",
 CellID->112034894],
Cell[CellGroupData[{
Cell[107429, 1972, 407, 14, 70, "Input",
 CellID->19698400],
Cell[107839, 1988, 24082, 400, 190, 92, 1, "CachedBoxData", "BoxData", \
"Output",
 CellID->39380930]
}, Open  ]],
Cell[131936, 2391, 125, 3, 70, "ExampleDelimiter",
 CellID->768042278],
Cell[132064, 2396, 184, 6, 70, "ExampleText",
 CellID->91147115],
Cell[CellGroupData[{
Cell[132273, 2406, 193, 6, 70, "Input",
 CellID->50259812],
Cell[132469, 2414, 33699, 558, 227, 76, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->139016790]
}, Open  ]],
Cell[166183, 2975, 125, 3, 70, "ExampleDelimiter",
 CellID->275586159],
Cell[166311, 2980, 195, 8, 70, "ExampleText",
 CellID->414922542],
Cell[CellGroupData[{
Cell[166531, 2992, 639, 21, 70, "Input",
 CellID->227910572],
Cell[167173, 3015, 3828, 68, 199, 135, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->344040866]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[171050, 3089, 235, 7, 70, "ExampleSubsection",
 CellID->182991362],
Cell[171288, 3098, 59, 1, 70, "ExampleText",
 CellID->120500777],
Cell[CellGroupData[{
Cell[171372, 3103, 386, 13, 70, "Input",
 CellID->127048219],
Cell[171761, 3118, 26759, 452, 131, "Output",
 CellID->326650194]
}, Open  ]],
Cell[198535, 3573, 124, 3, 70, "ExampleDelimiter",
 CellID->50742823],
Cell[198662, 3578, 254, 8, 70, "ExampleText",
 CellID->45613324],
Cell[CellGroupData[{
Cell[198941, 3590, 618, 21, 70, "Input",
 CellID->35360879],
Cell[199562, 3613, 21546, 358, 184, 159, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->576373000]
}, Open  ]],
Cell[221123, 3974, 125, 3, 70, "ExampleDelimiter",
 CellID->600880851],
Cell[221251, 3979, 184, 6, 70, "ExampleText",
 CellID->358441062],
Cell[CellGroupData[{
Cell[221460, 3989, 451, 15, 70, "Input",
 CellID->227665862],
Cell[221914, 4006, 35367, 592, 131, "Output",
 CellID->344422584]
}, Open  ]],
Cell[257296, 4601, 72, 1, 70, "ExampleText",
 CellID->291906364],
Cell[CellGroupData[{
Cell[257393, 4606, 230, 7, 70, "Input",
 CellID->3405511],
Cell[257626, 4615, 1836, 36, 129, 111, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->372393495]
}, Open  ]],
Cell[259477, 4654, 125, 3, 70, "ExampleDelimiter",
 CellID->213113131],
Cell[259605, 4659, 200, 7, 70, "ExampleText",
 CellID->94273435],
Cell[CellGroupData[{
Cell[259830, 4670, 403, 14, 70, "Input",
 CellID->36811579],
Cell[260236, 4686, 37882, 632, 131, "Output",
 CellID->19353714]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[298179, 5325, 223, 7, 70, "ExampleSection",
 CellID->11359],
Cell[298405, 5334, 86, 1, 70, "ExampleText",
 CellID->27289629],
Cell[298494, 5337, 311, 10, 70, "Input",
 CellID->69733258],
Cell[CellGroupData[{
Cell[298830, 5351, 714, 22, 70, "Input",
 CellID->250350978],
Cell[299547, 5375, 77335, 1380, 139, "Output",
 CellID->457137421]
}, Open  ]],
Cell[376897, 6758, 125, 3, 70, "ExampleDelimiter",
 CellID->131480501],
Cell[377025, 6763, 56, 1, 70, "ExampleText",
 CellID->508542850],
Cell[CellGroupData[{
Cell[377106, 6768, 2054, 59, 70, "Input",
 CellID->140034873],
Cell[379163, 6829, 37834, 642, 237, 16921, 295, "CachedBoxData", "BoxData", \
"Output",
 CellID->499094130]
}, Open  ]],
Cell[417012, 7474, 124, 3, 70, "ExampleDelimiter",
 CellID->78739628],
Cell[417139, 7479, 51, 1, 70, "ExampleText",
 CellID->246952071],
Cell[CellGroupData[{
Cell[417215, 7484, 1403, 39, 70, "Input",
 CellID->329009926],
Cell[418621, 7525, 60235, 997, 189, 1254, 26, "CachedBoxData", "BoxData", \
"Output",
 CellID->11576694]
}, Open  ]],
Cell[478871, 8525, 125, 3, 70, "ExampleDelimiter",
 CellID->499494878],
Cell[478999, 8530, 335, 13, 70, "ExampleText",
 CellID->432756382],
Cell[CellGroupData[{
Cell[479359, 8547, 832, 26, 70, "Input",
 CellID->35075088],
Cell[480194, 8575, 27733, 468, 202, 12878, 220, "CachedBoxData", "BoxData", \
"Output",
 CellID->17629805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[507976, 9049, 232, 7, 70, "ExampleSection",
 CellID->9230],
Cell[508211, 9058, 199, 8, 70, "ExampleText",
 CellID->332788306],
Cell[CellGroupData[{
Cell[508435, 9070, 390, 12, 70, "Input",
 CellID->503769331],
Cell[508828, 9084, 46045, 762, 219, 19379, 320, "CachedBoxData", "BoxData", \
"Output",
 CellID->238903350]
}, Open  ]],
Cell[554888, 9849, 125, 3, 70, "ExampleDelimiter",
 CellID->347290869],
Cell[555016, 9854, 321, 13, 70, "ExampleText",
 CellID->173013051],
Cell[CellGroupData[{
Cell[555362, 9871, 131, 4, 70, "Input",
 CellID->74441559],
Cell[555496, 9877, 240, 7, 121, "Output",
 CellID->69919696]
}, Open  ]],
Cell[555751, 9887, 125, 3, 70, "ExampleDelimiter",
 CellID->243332541],
Cell[555879, 9892, 244, 8, 70, "ExampleText",
 CellID->509670244],
Cell[CellGroupData[{
Cell[556148, 9904, 581, 19, 70, "Input",
 CellID->68478577],
Cell[556732, 9925, 10506, 176, 70, "Output",
 Evaluatable->False,
 CellID->684640774]
}, Open  ]],
Cell[567253, 10104, 125, 3, 70, "ExampleDelimiter",
 CellID->204569051],
Cell[567381, 10109, 251, 8, 70, "ExampleText",
 CellID->261646573],
Cell[CellGroupData[{
Cell[567657, 10121, 651, 19, 70, "Input",
 CellID->540407307],
Cell[568311, 10142, 10555, 177, 70, "Output",
 Evaluatable->False,
 CellID->145738026]
}, Open  ]],
Cell[578881, 10322, 124, 3, 70, "ExampleDelimiter",
 CellID->12991973],
Cell[579008, 10327, 231, 7, 70, "ExampleText",
 CellID->380548320],
Cell[CellGroupData[{
Cell[579264, 10338, 165, 4, 70, "Input",
 CellID->287154983],
Cell[579432, 10344, 26701, 446, 318, 3749, 65, "CachedBoxData", "BoxData", \
"Output",
 CellID->444385097]
}, Open  ]],
Cell[606148, 10793, 124, 3, 70, "ExampleDelimiter",
 CellID->58680780],
Cell[606275, 10798, 230, 8, 70, "ExampleText",
 CellID->542043455],
Cell[CellGroupData[{
Cell[606530, 10810, 220, 6, 70, "Input",
 CellID->508200095],
Cell[606753, 10818, 39506, 638, 212, 11833, 180, "CachedBoxData", "BoxData", \
"Output",
 CellID->312621358]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[646308, 11462, 224, 7, 70, "ExampleSection",
 CellID->14761],
Cell[646535, 11471, 69, 1, 70, "ExampleText",
 CellID->416227571],
Cell[CellGroupData[{
Cell[646629, 11476, 525, 16, 70, "Input",
 CellID->144985119],
Cell[647157, 11494, 27667, 458, 70, "Output",
 Evaluatable->False,
 CellID->67492215]
}, Open  ]],
Cell[674839, 11955, 125, 3, 70, "ExampleDelimiter",
 CellID->133213040],
Cell[674967, 11960, 64, 1, 70, "ExampleText",
 CellID->32377],
Cell[CellGroupData[{
Cell[675056, 11965, 380, 14, 70, "Input",
 CellID->14861],
Cell[675439, 11981, 55228, 922, 184, 7192, 130, "CachedBoxData", "BoxData", \
"Output",
 CellID->483945881]
}, Open  ]],
Cell[730682, 12906, 121, 3, 70, "ExampleDelimiter",
 CellID->15951],
Cell[730806, 12911, 62, 1, 70, "ExampleText",
 CellID->16580],
Cell[CellGroupData[{
Cell[730893, 12916, 648, 22, 70, "Input",
 CellID->30647],
Cell[731544, 12940, 58510, 930, 184, 12873, 177, "CachedBoxData", "BoxData", \
"Output",
 CellID->384523419]
}, Open  ]],
Cell[790069, 13873, 125, 3, 70, "ExampleDelimiter",
 CellID->469658180],
Cell[790197, 13878, 209, 8, 70, "ExampleText",
 CellID->31164110],
Cell[790409, 13888, 985, 30, 70, "Input",
 CellID->23089588],
Cell[CellGroupData[{
Cell[791419, 13922, 216, 8, 70, "Input",
 CellID->61085999],
Cell[791638, 13932, 29208, 483, 70, "Output",
 Evaluatable->False,
 CellID->713212628]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[820907, 14422, 311, 9, 70, "SeeAlsoSection",
 CellID->31270],
Cell[821221, 14433, 1210, 44, 70, "SeeAlso",
 CellID->187977964]
}, Open  ]],
Cell[CellGroupData[{
Cell[822468, 14482, 313, 9, 70, "TutorialsSection",
 CellID->5080],
Cell[822784, 14493, 197, 4, 70, "Tutorials",
 CellID->595610080]
}, Open  ]],
Cell[CellGroupData[{
Cell[823018, 14502, 305, 8, 70, "RelatedLinksSection"],
Cell[823326, 14512, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[823720, 14529, 319, 9, 70, "MoreAboutSection",
 CellID->764445423],
Cell[824042, 14540, 142, 3, 70, "MoreAbout",
 CellID->28701776],
Cell[824187, 14545, 150, 3, 70, "MoreAbout",
 CellID->63023992],
Cell[824340, 14550, 162, 3, 70, "MoreAbout",
 CellID->196673562],
Cell[824505, 14555, 197, 4, 70, "MoreAbout",
 CellID->126107051],
Cell[824705, 14561, 179, 3, 70, "MoreAbout",
 CellID->172854264]
}, Open  ]],
Cell[824899, 14567, 27, 0, 70, "History"],
Cell[824929, 14569, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

