(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26818,        970]
NotebookOptionsPosition[     21308,        781]
NotebookOutlinePosition[     22689,        820]
CellTagsIndexPosition[     22604,        815]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HankelH1" :> Documentation`HelpLookup["paclet:ref/HankelH1"], 
          "SphericalHankelH2" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHankelH2"], 
          "SphericalBesselY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselY"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HankelH1\"\>", 
       2->"\<\"SphericalHankelH2\"\>", 
       3->"\<\"SphericalBesselY\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SphericalHankelH1", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SphericalHankelH1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SphericalHankelH1"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the spherical Hankel function of the first kind ",
     
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["h", "n", 
         RowBox[{"(", "1", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14577]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFormula"],
 " is given in terms of ordinary Hankel functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["h", "n", 
      RowBox[{"(", "1", ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"\[Pi]", "/", "2"}]], "/", 
      SqrtBox["z"]}], 
     RowBox[{
      SubsuperscriptBox["H", 
       RowBox[{"n", "+", 
        FractionBox["1", "2"]}], 
       RowBox[{"(", "1", ")"}]], "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->12304],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH1"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13558],

Cell[TextData[{
 "Explicit symbolic forms for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be obtained using ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14500],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SphericalHankelH1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->4381561],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628741160],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->122989791],

Cell["Evaluate numerically:", "ExampleText",
 CellID->298310181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH1", "[", 
  RowBox[{"3", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307335585],

Cell[BoxData[
 RowBox[{"0.028324641582471808`", "\[InvisibleSpace]", "-", 
  RowBox[{"3.7892735647020435`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445852303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->510315795],

Cell["Series at infinity:", "ExampleText",
 CellID->677941440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SphericalHankelH1", "[", 
    RowBox[{"3", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667826158],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "x"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "x"], "+", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "2"]}], "-", 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "3"]}], "-", 
     RowBox[{"15", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "6"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 2, 12, 2],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {1, 0, 
      Complex[0, 6], 0, -15, 0, 
      Complex[0, -15]}, 2, 12, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{298, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201420043]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3676],

Cell[TextData[{
 "Find explicit symbolic forms using ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1676613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"SphericalHankelH1", "[", 
   RowBox[{"1", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122198930],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "r"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], "-", "r"}], ")"}]}], 
  SuperscriptBox["r", "2"]]], "Output",
 ImageSize->{80, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13986064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"SphericalHankelH1", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->266823877],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", "r"}], "]"}]}], 
   SqrtBox["r"]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"BesselY", "[", 
     RowBox[{"1", ",", "r"}], "]"}]}], 
   SqrtBox["r"]]}]], "Output",
 ImageSize->{277, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166231411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->583455659],

Cell["Evaluate for complex arguments and orders:", "ExampleText",
 CellID->168756706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH1", "[", 
  RowBox[{
   RowBox[{"3", "+", 
    RowBox[{"2", " ", "I"}]}], ",", 
   RowBox[{"5", "-", 
    RowBox[{"0.2", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->593547515],

Cell[BoxData[
 RowBox[{"1.2537521686991344`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.5180114359217904`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390311868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133153095],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->339175458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", " ", 
  RowBox[{
   RowBox[{"SphericalHankelH1", "[", 
    RowBox[{"1", ",", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89131405],

Cell[BoxData[
 RowBox[{"0.\
3456774997623559548794959096668771318919967282332256209475540639925`50.\
1434286193938", "+", 
  RowBox[{
  "0.0629591636023159767743709318118811625392088115398657307064931121368`49.\
40381645716058", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148257117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282337929],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->175906109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH1", "[", 
  RowBox[{"1", ",", "3.0000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272242306],

Cell[BoxData[
 RowBox[{"0.345677499762355954879495909666877495781860227283`30.\
36957739418189", "+", 
  RowBox[{
  "0.062959163602315976774370931811881162539208810971`30.150519917545047", 
   " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281396624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->716662293],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH1"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->17043502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "4.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->552427445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.001429581245757399`"}], "+", 
    RowBox[{"0.22763858414438107`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.21627586087284995`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.10491554511163632`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2417360933267018`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11106575624256294`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776429274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143909965],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->314796908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalHankelH1", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337034732],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["h",
     SphericalHankelH1], "n", 
    RowBox[{"(", "1", ")"}]], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{35, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->18016993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["r", "2"], 
    RowBox[{"SphericalHankelH1", "[", 
     RowBox[{"n", ",", "r"}], "]"}], " ", 
    RowBox[{"SphericalHankelH2", "[", 
     RowBox[{"n", ",", "r"}], "]"}]}], ",", "r"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->755976949],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", "\[Pi]", " ", 
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], ",", "r"}], "]"}], "2"], "-", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "n"}], ",", "r"}], "]"}], " ", 
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        FractionBox["3", "2"], "+", "n"}], ",", "r"}], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], ",", "r"}], "]"}], "2"], "-", 
    RowBox[{
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "n"}], ",", "r"}], "]"}], " ", 
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        FractionBox["3", "2"], "+", "n"}], ",", "r"}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{427, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63489727]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3726],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalHankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselY"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->235],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->20181]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->75197358],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->438719895],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->141746414]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SphericalHankelH1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 25.9821358}", "context" -> "System`", 
    "keywords" -> {
     "spherical Bessel function", "spherical Hankel function", 
      "spherical Hankel H1"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SphericalHankelH1[n, z] gives the spherical Hankel function of the first \
kind SubsuperscriptBox[h, n, (1)](z). ", 
    "synonyms" -> {"spherical hankel h1"}, "title" -> "SphericalHankelH1", 
    "type" -> "Symbol", "uri" -> "ref/SphericalHankelH1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8162, 267, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->628741160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22461, 808}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2203, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2826, 81, 1582, 37, 70, "ObjectNameGrid"],
Cell[4411, 120, 765, 25, 70, "Usage",
 CellID->14577]
}, Open  ]],
Cell[CellGroupData[{
Cell[5213, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5691, 167, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5814, 173, 686, 25, 70, "Notes",
 CellID->12304],
Cell[6503, 200, 584, 21, 70, "Notes",
 CellID->13558],
Cell[7090, 223, 307, 11, 70, "Notes",
 CellID->14500],
Cell[7400, 236, 264, 8, 70, "Notes",
 CellID->4381561],
Cell[7667, 246, 236, 7, 70, "Notes",
 CellID->31226],
Cell[7906, 255, 219, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8162, 267, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628741160],
Cell[CellGroupData[{
Cell[8547, 281, 148, 5, 70, "ExampleSection",
 CellID->122989791],
Cell[8698, 288, 64, 1, 70, "ExampleText",
 CellID->298310181],
Cell[CellGroupData[{
Cell[8787, 293, 138, 4, 28, "Input",
 CellID->307335585],
Cell[8928, 299, 275, 7, 36, "Output",
 CellID->445852303]
}, Open  ]],
Cell[9218, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->510315795],
Cell[9346, 314, 62, 1, 70, "ExampleText",
 CellID->677941440],
Cell[CellGroupData[{
Cell[9433, 319, 261, 8, 70, "Input",
 CellID->667826158],
Cell[9697, 329, 1121, 36, 52, "Output",
 CellID->201420043]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10867, 371, 215, 7, 70, "ExampleSection",
 CellID->3676],
Cell[11085, 380, 228, 8, 70, "ExampleText",
 CellID->1676613],
Cell[CellGroupData[{
Cell[11338, 392, 178, 5, 70, "Input",
 CellID->122198930],
Cell[11519, 399, 382, 13, 56, "Output",
 CellID->13986064]
}, Open  ]],
Cell[CellGroupData[{
Cell[11938, 417, 203, 6, 70, "Input",
 CellID->266823877],
Cell[12144, 425, 527, 20, 65, "Output",
 CellID->166231411]
}, Open  ]],
Cell[12686, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->583455659],
Cell[12814, 453, 85, 1, 70, "ExampleText",
 CellID->168756706],
Cell[CellGroupData[{
Cell[12924, 458, 231, 8, 70, "Input",
 CellID->593547515],
Cell[13158, 468, 273, 7, 36, "Output",
 CellID->390311868]
}, Open  ]],
Cell[13446, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->133153095],
Cell[13574, 483, 70, 1, 70, "ExampleText",
 CellID->339175458],
Cell[CellGroupData[{
Cell[13669, 488, 195, 6, 70, "Input",
 CellID->89131405],
Cell[13867, 496, 396, 11, 54, "Output",
 CellID->148257117]
}, Open  ]],
Cell[14278, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->282337929],
Cell[14406, 515, 113, 3, 70, "ExampleText",
 CellID->175906109],
Cell[CellGroupData[{
Cell[14544, 522, 168, 4, 70, "Input",
 CellID->272242306],
Cell[14715, 528, 360, 10, 36, "Output",
 CellID->281396624]
}, Open  ]],
Cell[15090, 541, 125, 3, 70, "ExampleDelimiter",
 CellID->716662293],
Cell[15218, 546, 227, 7, 70, "ExampleText",
 CellID->17043502],
Cell[CellGroupData[{
Cell[15470, 557, 197, 6, 70, "Input",
 CellID->552427445],
Cell[15670, 565, 576, 15, 36, "Output",
 CellID->776429274]
}, Open  ]],
Cell[16261, 583, 125, 3, 70, "ExampleDelimiter",
 CellID->143909965],
Cell[16389, 588, 203, 7, 70, "ExampleText",
 CellID->314796908],
Cell[CellGroupData[{
Cell[16617, 599, 175, 5, 70, "Input",
 CellID->337034732],
Cell[16795, 606, 325, 11, 54, "Output",
 CellID->18016993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17169, 623, 233, 7, 70, "ExampleSection",
 CellID->21357],
Cell[CellGroupData[{
Cell[17427, 634, 327, 10, 70, "Input",
 CellID->755976949],
Cell[17757, 646, 1186, 41, 83, "Output",
 CellID->63489727]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19004, 694, 310, 9, 70, "SeeAlsoSection",
 CellID->3726],
Cell[19317, 705, 730, 26, 70, "SeeAlso",
 CellID->11262]
}, Open  ]],
Cell[CellGroupData[{
Cell[20084, 736, 312, 9, 70, "TutorialsSection",
 CellID->235],
Cell[20399, 747, 144, 3, 70, "Tutorials",
 CellID->20181]
}, Open  ]],
Cell[CellGroupData[{
Cell[20580, 755, 318, 9, 70, "MoreAboutSection",
 CellID->75197358],
Cell[20901, 766, 158, 3, 70, "MoreAbout",
 CellID->438719895],
Cell[21062, 771, 174, 3, 70, "MoreAbout",
 CellID->141746414]
}, Open  ]],
Cell[21251, 777, 27, 0, 70, "History"],
Cell[21281, 779, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

