(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27704,        993]
NotebookOptionsPosition[     22067,        800]
NotebookOutlinePosition[     23449,        839]
CellTagsIndexPosition[     23364,        834]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HankelH2" :> Documentation`HelpLookup["paclet:ref/HankelH2"], 
          "SphericalHankelH1" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHankelH1"], 
          "SphericalBesselJ" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselJ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HankelH2\"\>", 
       2->"\<\"SphericalHankelH1\"\>", 
       3->"\<\"SphericalBesselJ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Functions Used in Optics\"\>", 
       4->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SphericalHankelH2", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SphericalHankelH2",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SphericalHankelH2"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the spherical Hankel function of the second kind \
",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["h", "n", 
         RowBox[{"(", "2", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFormula"],
 " is given in terms of ordinary Hankel functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["h", "n", 
      RowBox[{"(", "2", ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"\[Pi]", "/", "2"}]], "/", 
      SqrtBox["z"]}], 
     RowBox[{
      SubsuperscriptBox["H", 
       RowBox[{"n", "+", 
        FractionBox["1", "2"]}], 
       RowBox[{"(", "2", ")"}]], "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->11835],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH2"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7932],

Cell[TextData[{
 "Explicit symbolic forms for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be obtained using ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31912],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SphericalHankelH2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->189063324],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270043593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->110641441],

Cell["Evaluate numerically:", "ExampleText",
 CellID->298310181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH2", "[", 
  RowBox[{"3", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307335585],

Cell[BoxData[
 RowBox[{"0.028324641582471808`", "\[InvisibleSpace]", "+", 
  RowBox[{"3.7892735647020435`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274989916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->510315795],

Cell["Series at infinity:", "ExampleText",
 CellID->677941440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SphericalHankelH2", "[", 
    RowBox[{"3", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667826158],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "x"], "-", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "2"]}], "-", 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "3"]}], "+", 
     RowBox[{"15", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "6"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 2, 12, 2],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {1, 0, 
      Complex[0, -6], 0, -15, 0, 
      Complex[0, 15]}, 2, 12, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{303, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->942276382]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30062],

Cell[TextData[{
 "Find explicit symbolic forms using ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1676613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"SphericalHankelH2", "[", 
   RowBox[{"1", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122198930],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "r"}]], " ", 
   RowBox[{"(", 
    RowBox[{"\[ImaginaryI]", "-", "r"}], ")"}]}], 
  SuperscriptBox["r", "2"]]], "Output",
 ImageSize->{78, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11478846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"SphericalHankelH2", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->266823877],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", "r"}], "]"}]}], 
   SqrtBox["r"]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"BesselY", "[", 
     RowBox[{"1", ",", "r"}], "]"}]}], 
   SqrtBox["r"]]}]], "Output",
 ImageSize->{277, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87774369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64171090],

Cell["Evaluate for complex arguments and orders:", "ExampleText",
 CellID->168756706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH2", "[", 
  RowBox[{
   RowBox[{"3", "+", 
    RowBox[{"2", "I"}]}], ",", 
   RowBox[{"5", "-", 
    RowBox[{"0.2", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->593547515],

Cell[BoxData[
 RowBox[{"0.021762763269216376`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.022400190611090488`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22922335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133153095],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->339175458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SphericalHankelH2", "[", 
    RowBox[{"1", ",", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89131405],

Cell[BoxData[
 RowBox[{"0.\
3456774997623559548794959096668771318919967282332256209475540639925`50.\
1434286193938", "-", 
  RowBox[{
  "0.0629591636023159767743709318118811625392088115398657307064931121368`49.\
40381645716058", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469800723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282337929],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->175906109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH2", "[", 
  RowBox[{"1", ",", "3.0000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272242306],

Cell[BoxData[
 RowBox[{"0.345677499762355954879495909666877495781860227283`30.\
36957739418189", "-", 
  RowBox[{
  "0.062959163602315976774370931811881162539208810971`30.150519917545047", 
   " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14620018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->716662293],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHankelH2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->17043502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHankelH2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "4.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->552427445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.001429581245757399`"}], "-", 
    RowBox[{"0.22763858414438107`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.21627586087284995`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.10491554511163632`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2417360933267018`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.11106575624256294`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323364678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->590847459],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->856117998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalHankelH2", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->820556978],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["h",
     SphericalHankelH2], "n", 
    RowBox[{"(", "2", ")"}]], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{35, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->121667780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["r", "2"], 
    RowBox[{"SphericalHankelH2", "[", 
     RowBox[{"n", ",", "r"}], "]"}], " ", 
    RowBox[{"SphericalHankelH1", "[", 
     RowBox[{"n", ",", "r"}], "]"}]}], ",", "r"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->755976949],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", "\[Pi]", " ", 
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], ",", "r"}], "]"}], "2"], "-", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "n"}], ",", "r"}], "]"}], " ", 
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{
        FractionBox["3", "2"], "+", "n"}], ",", "r"}], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], ",", "r"}], "]"}], "2"], "-", 
    RowBox[{
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "n"}], ",", "r"}], "]"}], " ", 
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        FractionBox["3", "2"], "+", "n"}], ",", "r"}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{427, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81059836]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21440],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalHankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23144]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24454],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->24630]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->328968],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->223001418],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->140508364],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->270259495],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->60347423]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SphericalHankelH2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 26.9509106}", "context" -> "System`", 
    "keywords" -> {
     "spherical Bessel function", "spherical Hankel function", 
      "spherical Hankel H2"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SphericalHankelH2[n, z] gives the spherical Hankel function of the \
second kind SubsuperscriptBox[h, n, (2)](z). ", 
    "synonyms" -> {"spherical hankel h2"}, "title" -> "SphericalHankelH2", 
    "type" -> "Symbol", "uri" -> "ref/SphericalHankelH2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8551, 274, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->270043593]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23221, 827}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2594, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3217, 88, 1582, 37, 70, "ObjectNameGrid"],
Cell[4802, 127, 762, 25, 70, "Usage",
 CellID->16884]
}, Open  ]],
Cell[CellGroupData[{
Cell[5601, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6079, 174, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6202, 180, 686, 25, 70, "Notes",
 CellID->11835],
Cell[6891, 207, 583, 21, 70, "Notes",
 CellID->7932],
Cell[7477, 230, 307, 11, 70, "Notes",
 CellID->31912],
Cell[7787, 243, 266, 8, 70, "Notes",
 CellID->189063324],
Cell[8056, 253, 236, 7, 70, "Notes",
 CellID->31226],
Cell[8295, 262, 219, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8551, 274, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270043593],
Cell[CellGroupData[{
Cell[8936, 288, 148, 5, 70, "ExampleSection",
 CellID->110641441],
Cell[9087, 295, 64, 1, 70, "ExampleText",
 CellID->298310181],
Cell[CellGroupData[{
Cell[9176, 300, 138, 4, 28, "Input",
 CellID->307335585],
Cell[9317, 306, 275, 7, 36, "Output",
 CellID->274989916]
}, Open  ]],
Cell[9607, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->510315795],
Cell[9735, 321, 62, 1, 70, "ExampleText",
 CellID->677941440],
Cell[CellGroupData[{
Cell[9822, 326, 261, 8, 70, "Input",
 CellID->667826158],
Cell[10086, 336, 1141, 37, 52, "Output",
 CellID->942276382]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11276, 379, 216, 7, 70, "ExampleSection",
 CellID->30062],
Cell[11495, 388, 228, 8, 70, "ExampleText",
 CellID->1676613],
Cell[CellGroupData[{
Cell[11748, 400, 178, 5, 70, "Input",
 CellID->122198930],
Cell[11929, 407, 382, 13, 56, "Output",
 CellID->11478846]
}, Open  ]],
Cell[CellGroupData[{
Cell[12348, 425, 203, 6, 70, "Input",
 CellID->266823877],
Cell[12554, 433, 526, 20, 65, "Output",
 CellID->87774369]
}, Open  ]],
Cell[13095, 456, 124, 3, 70, "ExampleDelimiter",
 CellID->64171090],
Cell[13222, 461, 85, 1, 70, "ExampleText",
 CellID->168756706],
Cell[CellGroupData[{
Cell[13332, 466, 226, 8, 70, "Input",
 CellID->593547515],
Cell[13561, 476, 276, 7, 36, "Output",
 CellID->22922335]
}, Open  ]],
Cell[13852, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->133153095],
Cell[13980, 491, 70, 1, 70, "ExampleText",
 CellID->339175458],
Cell[CellGroupData[{
Cell[14075, 496, 190, 6, 70, "Input",
 CellID->89131405],
Cell[14268, 504, 396, 11, 54, "Output",
 CellID->469800723]
}, Open  ]],
Cell[14679, 518, 125, 3, 70, "ExampleDelimiter",
 CellID->282337929],
Cell[14807, 523, 113, 3, 70, "ExampleText",
 CellID->175906109],
Cell[CellGroupData[{
Cell[14945, 530, 168, 4, 70, "Input",
 CellID->272242306],
Cell[15116, 536, 359, 10, 36, "Output",
 CellID->14620018]
}, Open  ]],
Cell[15490, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->716662293],
Cell[15618, 554, 227, 7, 70, "ExampleText",
 CellID->17043502],
Cell[CellGroupData[{
Cell[15870, 565, 197, 6, 70, "Input",
 CellID->552427445],
Cell[16070, 573, 576, 15, 36, "Output",
 CellID->323364678]
}, Open  ]],
Cell[16661, 591, 125, 3, 70, "ExampleDelimiter",
 CellID->590847459],
Cell[16789, 596, 203, 7, 70, "ExampleText",
 CellID->856117998],
Cell[CellGroupData[{
Cell[17017, 607, 175, 5, 70, "Input",
 CellID->820556978],
Cell[17195, 614, 326, 11, 54, "Output",
 CellID->121667780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17570, 631, 233, 7, 70, "ExampleSection",
 CellID->12700],
Cell[CellGroupData[{
Cell[17828, 642, 327, 10, 70, "Input",
 CellID->755976949],
Cell[18158, 654, 1186, 41, 83, "Output",
 CellID->81059836]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19405, 702, 311, 9, 70, "SeeAlsoSection",
 CellID->21440],
Cell[19719, 713, 730, 26, 70, "SeeAlso",
 CellID->23144]
}, Open  ]],
Cell[CellGroupData[{
Cell[20486, 744, 314, 9, 70, "TutorialsSection",
 CellID->24454],
Cell[20803, 755, 144, 3, 70, "Tutorials",
 CellID->24630]
}, Open  ]],
Cell[CellGroupData[{
Cell[20984, 763, 316, 9, 70, "MoreAboutSection",
 CellID->328968],
Cell[21303, 774, 158, 3, 70, "MoreAbout",
 CellID->223001418],
Cell[21464, 779, 195, 4, 70, "MoreAbout",
 CellID->140508364],
Cell[21662, 785, 157, 3, 70, "MoreAbout",
 CellID->270259495],
Cell[21822, 790, 173, 3, 70, "MoreAbout",
 CellID->60347423]
}, Open  ]],
Cell[22010, 796, 27, 0, 70, "History"],
Cell[22040, 798, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

