(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30312,       1108]
NotebookOptionsPosition[     24413,        905]
NotebookOutlinePosition[     25762,        942]
CellTagsIndexPosition[     25677,        937]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"],
           "ClebschGordan" :> 
          Documentation`HelpLookup["paclet:ref/ClebschGordan"], 
          "SphericalBesselJ" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselJ"], "ZernikeR" :> 
          Documentation`HelpLookup["paclet:ref/ZernikeR"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LegendreP\"\>", 
       2->"\<\"ClebschGordan\"\>", 3->"\<\"SphericalBesselJ\"\>", 
       4->"\<\"ZernikeR\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Optics\"\>", 
       3->"\<\"Functions Used in Quantum Mechanics\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SphericalHarmonicY", "ObjectName",
 CellID->6270],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SphericalHarmonicY",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the spherical harmonic ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["Y", "l", "m"], "(", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["\<\
The spherical harmonics are orthonormal with respect to integration over the \
surface of the unit sphere. \
\>", "Notes",
 CellID->22160],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"l", "\[GreaterEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["Y", "l", "m"], "(", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "l", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "\[Pi]"}], ")"}]}]], 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"l", "-", "m"}], ")"}], "!", "/", 
       RowBox[{"(", 
        RowBox[{"l", "+", "m"}], ")"}], "!"}]], 
     RowBox[{
      SubsuperscriptBox["P", "l", "m"], "(", 
      RowBox[{"cos", 
       RowBox[{"(", "\[Theta]", ")"}]}], ")"}], 
     SuperscriptBox["e", 
      RowBox[{
      "i", "\[InvisibleSpace]", "m", "\[InvisibleSpace]", "\[Phi]"}]]}]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["P", "l", "m"], TraditionalForm]], "InlineMath"],
 " is the associated Legendre function. "
}], "Notes",
 CellID->28740],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"l", "\[LessEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["Y", "l", "m"], "(", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["Y", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"l", "+", "1"}], ")"}]}], "m"], "(", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->18923],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->189274208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215913105],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->20325698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHarmonicY", "[", 
  RowBox[{"3", ",", "1", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26728671],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "8"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}]], " ", 
  SqrtBox[
   FractionBox["21", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]], "Output",
 ImageSize->{234, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584329048]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20659],

Cell["Evaluate for complex arguments and orders:", "ExampleText",
 CellID->306116168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHarmonicY", "[", 
  RowBox[{"3", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.5", "+", "I"}], ")"}], "/", "3"}], ",", 
   RowBox[{"Pi", "/", "6"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281937370],

Cell[BoxData[
 RowBox[{"0.0210561952692097`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.21517289252086158`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393070025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97997514],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->297563304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SphericalHarmonicY", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"Pi", "/", "7"}], ",", 
     RowBox[{"Pi", "/", "3"}]}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325800380],

Cell[BoxData[
 RowBox[{"0.377054264064847236439263799876390444390170363708`30.\
08804562952784", "+", 
  RowBox[{
  "0.21769238085693578848684667850536023781752984642`29.84948500216801", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391817075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72365494],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->37443045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHarmonicY", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"Pi", "/", "7"}], ",", 
   RowBox[{"Pi", "/", "3.00000000000000000000000"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121892260],

Cell[BoxData[
 RowBox[{"0.37705426406484723643926379987639044438`23.565166884247503", "+", 
  RowBox[{
  "0.21769238085693578848684667850536023781`23.326606256887672", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->884496861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157353618],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " ",
 "threads element-wise over lists",
 ":"
}], "ExampleText",
 CellID->245500348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHarmonicY", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", "0", ",", "\[Theta]", ",", 
   "\[Phi]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114154754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     FractionBox["3", "\[Pi]"]], " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     FractionBox["5", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{319, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394032774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11615290],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->62071316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalHarmonicY", "[", 
   RowBox[{"n", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51936098],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["Y", "n", "m"], "(", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{46, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->117278714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12174],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->27504811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalHarmonicY", "[", 
  RowBox[{"n", ",", "0", ",", 
   RowBox[{"\[Theta]", "+", 
    RowBox[{
     RowBox[{"O", "[", "\[Theta]", "]"}], "^", "3"}]}], ",", "\[Phi]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53142285],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}]], 
    RowBox[{"2", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["n", "4"]}], "-", 
       FractionBox[
        SuperscriptBox["n", "2"], "4"]}], ")"}], " ", 
     SuperscriptBox["\[Theta]", "2"]}], 
    RowBox[{"2", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Theta]", "]"}], "4"],
    SeriesData[$CellContext`\[Theta], 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Theta], 0, {
   Rational[1, 2] (1 + 2 $CellContext`n)^Rational[1, 2] Pi^Rational[-1, 2], 0,
     Rational[1, 2] (1 + 2 $CellContext`n)^Rational[1, 2] (
     Rational[-1, 4] $CellContext`n + Rational[-1, 4] $CellContext`n^2) 
    Pi^Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{256, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237724431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29353],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SphericalHarmonicY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFormula"],
 " is an eigenfunction of the spherical part of the Laplace operator:"
}], "ExampleText",
 CellID->287351033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]], 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", "\[Theta]", "]"}], 
            RowBox[{"D", "[", 
             RowBox[{"#", ",", "\[Theta]"}], "]"}]}], ",", "\[Theta]"}], 
          "]"}]}], "+", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
         RowBox[{"D", "[", 
          RowBox[{"#", ",", "\[Phi]", ",", "\[Phi]"}], "]"}]}]}], ")"}], "/", 
      "#"}], ")"}], "&"}], "@", 
   RowBox[{"SphericalHarmonicY", "[", 
    RowBox[{"4", ",", "1", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2079926345],

Cell[BoxData[
 RowBox[{"-", "20"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11151159]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21565],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHarmonicY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Theta]", "TR"], ",", 
    StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
 " for half-integers ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->287840022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", " ", 
  RowBox[{"SphericalHarmonicY", "[", 
   RowBox[{
    FractionBox["3", "2"], ",", 
    FractionBox["1", "2"], ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117405390],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}], "2"]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}], 
  RowBox[{
   SqrtBox["2"], " ", "\[Pi]", " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 ImageSize->{277, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83583834]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96216390],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}], "2"]], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "\[Theta]"}], "]"}]}], 
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 ImageSize->{97, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69304023]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1520],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClebschGordan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClebschGordan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZernikeR",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZernikeR"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5281],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->2482]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22097],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/SphericalHarmonic.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/SphericalHarmonicY/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
SphericalHarmonicY"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->91288640],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->41359297],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->480904049],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->113493353],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->7236790]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SphericalHarmonicY - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 30.1072414}", "context" -> "System`", 
    "keywords" -> {"spherical harmonics", "spherical harmonic Y"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SphericalHarmonicY[l, m, \\[Theta], \\[Phi]] gives the spherical \
harmonic SubsuperscriptBox[Y, l, m](\\[Theta], \\[Phi]). ", 
    "synonyms" -> {"spherical harmonic Y"}, "title" -> "SphericalHarmonicY", 
    "type" -> "Symbol", "uri" -> "ref/SphericalHarmonicY"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7427, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->215913105]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25534, 930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2693, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3316, 90, 55, 1, 70, "ObjectName",
 CellID->6270],
Cell[3374, 93, 829, 26, 70, "Usage",
 CellID->12461]
}, Open  ]],
Cell[CellGroupData[{
Cell[4240, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4718, 141, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4841, 147, 148, 4, 70, "Notes",
 CellID->22160],
Cell[4992, 153, 1098, 39, 70, "Notes",
 CellID->28740],
Cell[6093, 194, 561, 22, 70, "Notes",
 CellID->18923],
Cell[6657, 218, 268, 8, 70, "Notes",
 CellID->189274208],
Cell[6928, 228, 238, 7, 70, "Notes",
 CellID->31226],
Cell[7169, 237, 221, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7427, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215913105],
Cell[CellGroupData[{
Cell[7812, 263, 147, 5, 70, "ExampleSection",
 CellID->20325698],
Cell[CellGroupData[{
Cell[7984, 272, 168, 4, 28, "Input",
 CellID->26728671],
Cell[8155, 278, 566, 19, 60, "Output",
 CellID->584329048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8770, 303, 216, 7, 70, "ExampleSection",
 CellID->20659],
Cell[8989, 312, 85, 1, 70, "ExampleText",
 CellID->306116168],
Cell[CellGroupData[{
Cell[9099, 317, 259, 8, 70, "Input",
 CellID->281937370],
Cell[9361, 327, 274, 7, 36, "Output",
 CellID->393070025]
}, Open  ]],
Cell[9650, 337, 124, 3, 70, "ExampleDelimiter",
 CellID->97997514],
Cell[9777, 342, 70, 1, 70, "ExampleText",
 CellID->297563304],
Cell[CellGroupData[{
Cell[9872, 347, 318, 10, 70, "Input",
 CellID->325800380],
Cell[10193, 359, 358, 10, 36, "Output",
 CellID->391817075]
}, Open  ]],
Cell[10566, 372, 124, 3, 70, "ExampleDelimiter",
 CellID->72365494],
Cell[10693, 377, 112, 3, 70, "ExampleText",
 CellID->37443045],
Cell[CellGroupData[{
Cell[10830, 384, 279, 8, 70, "Input",
 CellID->121892260],
Cell[11112, 394, 339, 9, 36, "Output",
 CellID->884496861]
}, Open  ]],
Cell[11466, 406, 125, 3, 70, "ExampleDelimiter",
 CellID->157353618],
Cell[11594, 411, 240, 9, 70, "ExampleText",
 CellID->245500348],
Cell[CellGroupData[{
Cell[11859, 424, 232, 7, 70, "Input",
 CellID->114154754],
Cell[12094, 433, 692, 26, 62, "Output",
 CellID->394032774]
}, Open  ]],
Cell[12801, 462, 124, 3, 70, "ExampleDelimiter",
 CellID->11615290],
Cell[12928, 467, 202, 7, 70, "ExampleText",
 CellID->62071316],
Cell[CellGroupData[{
Cell[13155, 478, 215, 6, 70, "Input",
 CellID->51936098],
Cell[13373, 486, 300, 9, 52, "Output",
 CellID->117278714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13722, 501, 239, 7, 70, "ExampleSection",
 CellID->12174],
Cell[13964, 510, 230, 7, 70, "ExampleText",
 CellID->27504811],
Cell[CellGroupData[{
Cell[14219, 521, 258, 8, 70, "Input",
 CellID->53142285],
Cell[14480, 531, 1180, 38, 66, "Output",
 CellID->237724431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15709, 575, 223, 7, 70, "ExampleSection",
 CellID->29353],
Cell[15935, 584, 264, 7, 70, "ExampleText",
 CellID->287351033],
Cell[CellGroupData[{
Cell[16224, 595, 916, 29, 70, "Input",
 CellID->2079926345],
Cell[17143, 626, 175, 6, 36, "Output",
 CellID->11151159]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17367, 638, 233, 7, 70, "ExampleSection",
 CellID->21565],
Cell[17603, 647, 687, 25, 70, "ExampleText",
 CellID->287840022],
Cell[CellGroupData[{
Cell[18315, 676, 265, 8, 70, "Input",
 CellID->117405390],
Cell[18583, 686, 1037, 36, 90, "Output",
 CellID->83583834]
}, Open  ]],
Cell[CellGroupData[{
Cell[19657, 727, 103, 3, 70, "Input",
 CellID->96216390],
Cell[19763, 732, 538, 18, 68, "Output",
 CellID->69304023]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20362, 757, 310, 9, 70, "SeeAlsoSection",
 CellID->1520],
Cell[20675, 768, 968, 35, 70, "SeeAlso",
 CellID->5722]
}, Open  ]],
Cell[CellGroupData[{
Cell[21680, 808, 313, 9, 70, "TutorialsSection",
 CellID->5281],
Cell[21996, 819, 153, 3, 70, "Tutorials",
 CellID->2482]
}, Open  ]],
Cell[CellGroupData[{
Cell[22186, 827, 321, 9, 70, "RelatedLinksSection",
 CellID->22097],
Cell[22510, 838, 188, 4, 70, "RelatedLinks"],
Cell[22701, 844, 202, 4, 70, "RelatedLinks"],
Cell[22906, 850, 396, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23339, 868, 318, 9, 70, "MoreAboutSection",
 CellID->91288640],
Cell[23660, 879, 194, 4, 70, "MoreAbout",
 CellID->41359297],
Cell[23857, 885, 157, 3, 70, "MoreAbout",
 CellID->480904049],
Cell[24017, 890, 178, 3, 70, "MoreAbout",
 CellID->113493353],
Cell[24198, 895, 143, 3, 70, "MoreAbout",
 CellID->7236790]
}, Open  ]],
Cell[24356, 901, 27, 0, 70, "History"],
Cell[24386, 903, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

