(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59104,       1531]
NotebookOptionsPosition[     53745,       1354]
NotebookOutlinePosition[     55307,       1395]
CellTagsIndexPosition[     55221,       1390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RotationAction" :> 
          Documentation`HelpLookup["paclet:ref/RotationAction"], "ViewAngle" :> 
          Documentation`HelpLookup["paclet:ref/ViewAngle"], "PlotRegion" :> 
          Documentation`HelpLookup["paclet:ref/PlotRegion"], "ViewPoint" :> 
          Documentation`HelpLookup["paclet:ref/ViewPoint"], "ImagePadding" :> 
          Documentation`HelpLookup["paclet:ref/ImagePadding"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RotationAction\"\>", 
       2->"\<\"ViewAngle\"\>", 3->"\<\"PlotRegion\"\>", 
       4->"\<\"ViewPoint\"\>", 5->"\<\"ImagePadding\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Interactive 3D Control" :> 
          Documentation`HelpLookup["paclet:guide/Interactive3DControl"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup[
           "paclet:guide/PlottingAndImageRegions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Coordinates\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 
       4->"\<\"Graphics Shape & Size\"\>", 
       5->"\<\"Interactive 3D Control\"\>", 
       6->"\<\"Plotting and Image Regions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SphericalRegion", "ObjectName",
 CellID->19733],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SphericalRegion",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SphericalRegion"]], "InlineFormula"],
     "\[LineSeparator]is an option for three\[Hyphen]dimensional graphics \
functions which specifies whether the final image should be scaled so that a \
sphere drawn around the three\[Hyphen]dimensional bounding box would fit in \
the display area specified. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19562]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SphericalRegion", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " scales three\[Hyphen]dimensional images to be as large as possible, given \
the display area specified. "
}], "Notes",
 CellID->28032],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SphericalRegion", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " scales three\[Hyphen]dimensional images so that a sphere drawn around the \
three\[Hyphen]dimensional bounding box always fits in the display area \
specified. "
}], "Notes",
 CellID->7279],

Cell["\<\
The center of the sphere is taken to be at the center of the bounding box. \
The radius of the sphere is chosen so that the bounding box just fits within \
the sphere. \
\>", "Notes",
 CellID->19134],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"SphericalRegion", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the image of a particular object remains consistent in size, regardless \
of the orientation of the object. "
}], "Notes",
 CellID->31081]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49335549],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->571177489],

Cell["\<\
Size a 3D plot to be within the bounding box at any orientation:\
\>", "ExampleText",
 CellID->5251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"SphericalRegion", "->", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1708],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[CuboidBox[{0, 0, 0}],
   SphericalRegion->True,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126112737]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30474],

Cell["\<\
Make a sequence of images be consistently sized independent of orientation:\
\>", "ExampleText",
 CellID->3741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
     RowBox[{"ImageSize", "->", "80"}], ",", 
     RowBox[{"ViewPoint", "->", 
      RowBox[{"3.", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], ",", 
         RowBox[{"Cos", "[", "t", "]"}], ",", "1"}], "}"}]}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28395],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    SphericalRegion->True,
    ViewPoint->{0, 3., 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdlksOgjAQhkfZ8tCdS9Yqim68ga5MvAJBElwYjXIzr+J1Gp1CgfhbHzE+
wCaddMrX+dtpWjoPkjhaB8kqDNzZLtjGq3DvTjc77jIaRLSQtUPcPnErrQsh
BHc+bVtsh1EUtQuPDHYpKz1ppC/SQs4VdfCW1JXGYCcDs+9vpZycSj2eV06x
L8cCpWL1IZbzB5QNmfAgE0CpWJJqwl5aWnIAqnalKQuyMYRsvEQpRR8UrUpT
JqxxBGt8iVKKY1A0f0hNuEczy6PgMWzuR/4uVeRYUQ92QkdZoOiDYk2o4txd
rvHW6dRRNigOQLFelMfmwX0s8vv9MhuafwUDfVD9K0plogeZ0LwfGOhCrM9S
6bxgH8s3Uvmuev49Ro0zyXwe3Q==\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    SphericalRegion->True,
    ViewPoint->{2.52441295442369, 1.62090691760442, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVl9tu2kAQhjfY5mAgYEiIA6FAc2jTNO1F1dMLtFeVmos+AEqQkouqVZoX
6bP0Vfo6qN2ZWXvN70nkILHy4v/7Z3a8xuMvy7vr1ffl3c3lcv75dvnz+uby
1/zTj1v7U7BljLmw36+pscf/7BF/X63XaxOsVqs1f8ycBnNuR/pxwbMzO9bs
zISWEKkdRXmanavz1Hw7v6IZ60TxLFMEucLUaAjJ6veVuM345LGiDWmIXORM
bp6w4BD09Klv6uXA6ReKvkn6uvfPkClLeA2hLFr0MekD71+jIZC0SDRh5RMX
qWaFHZWwc7cWIQ6UtXeBDDLSxRqzdKyQPSBDIPdZmipkAmQE60tZOlIqOVRJ
H1PI3VJFR8z58iO3x8phoaIpEHXIccREUiDGQDSA4KxMr0AcqITPSoiuUsEp
kE0gd1jaVsgZkC3IcsjSuFTBhcr5HSZcK48o4QhCMoZcBznJKpfnIVBtoJJK
VAdW138E5WNVo7pA9ZhqFv79qI5HQG0Dtf0A5fd9D9bV3aRchjrlY1Wj+kB1
KlGJHWgnVFcXY7SZakAVjh9NZbFoOnhY7TJ7age+P//8XT9UBZ2euViRSvtn
YKzSUxebSetAJnVwwiuvO00UpxY44c4TpzrUfOycekzfv9vLNOWROnoANN5h
QLtVjBy9A5lXo4fuWuyptL8WLZVOlAqm4NRWnSKoYF9xmoBTDFdVd9p2Tguo
ZgvqUaZpRR1HHwGNzw6gXT1iR59A5tXohrsWp0DjE0+nI6WCL1Qnfy34H8f2
JJsVDBWnc3DCJ73uVHNOb6Ca2FmUae5O7eE7ILF/8iSJPkCW96uLWX4ECru7
Zmmn0CFSNZWiO6bYXRD0XiV9LRvq043XVs8rkbfgEqelqSNfN+m+RRuDlvMp
deqibWta9/4ho+g6ms6t0bthl0ait8Vq5KvvgR/tIOoGszqRiSj7oHxtlQEo
5Y5JQPky8wxzpf3IM2sA2ueqVvqQIWiPlAykE9tR1j9TnaVTHIHzgaqVLnsP
tKmShX/bKCp3VVd5G9oHbaJq5a1uDNqukoG8yU6UOjRV50MWTME5UrUnfJZz
8V25ksMpn5lt6tw/yBnP5m7Gb+XmojCarf92JIKl\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    SphericalRegion->True,
    ViewPoint->{2.72789228047704, -1.24844050964143, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1l+1y0kAUhrckAcJH+W4RaEURS6tMtXoN+qszcgPOMC0z7Q9Hp/bOvBWv
wbtgdM/Zk03yZqFRaaYcstn3ec/J7jZkL5f3N6svy/vbq+X4493y283t1ffx
h693+pK3p5Ra6M+nvtLnv/UZfxbr9Vp3cBzp6K1WqwtuDXUs6JbytE6f0ym1
z9O9wa/P1yo6qIuuzlkzoEiGuoeir6UFkvnGzhxnVmuzaR25Bk79CeufUPRj
b6VCrSZYeVatpmnt5fzaaGtO5+es7lMMjM4CqhERCfdxWq/Fsb7lzHDExCHF
os1goa6TGaQZA1jmwHHXXJE6SIy+lqsCBWnT6Pad2Xpp1qTKsEMn22a2B3m9
iJVZPXJU3EyTkhXJsTNrndkuZPWBncD8kbyaJiUrklMKnllm5G+oDuQLNlHy
n+OmfBjXk0QuklaYam/K9QhUC6jibikZDUM1gSrthJpBhSFTDaDKj0jtAxXC
2vhPSkbDUHWgKjuhTqHCMlO1TZSMxlluih7Gf5GD5D9+rs0fdb7MxYaJ+jSo
AqEnMCZuugx0KPR4Oy1PEaRrQh9D5SUnXQK6KfTQSVcfqLwjdD8XjbkPhe79
Ez3QgaavBaPmpotAH1Pw7bNXHw32iZ/hxe0+ZsmoZxmfGtwN+Mg8BFDPNOMT
5vLxwec041N0+lQiH/3tqud1xsfb7uP43SGLtzLHyRnKR74X0q32HOrsKthI
yexZKrXyKjDGhQdylbdTkusdUOZ5GcI8YC6kKjHleM/Dyqpb1ehdi9WBVZuT
jLaeRyujmtCm3pVRt58eEdFhZv7lNGPuG9C4XYCuGesSOwVUtazK7hFkvs5B
2c740fEGVJ20n89NOeZwvx27bsiwQN+6cwaqrv1d9ROqCeQ1b9ctUaXzPgUt
v4MzkdUOQMu7A97nJGvsgcrsC0aRoxc70ptxE9S8a+I9TjZ/He7eaF84tWXQ
mv3MDGr1QDVk1avIsZh0NAWO+BLtRmlpH3FrkYlq7w8diqFy\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    SphericalRegion->True,
    ViewPoint->{0.423360024179602, -2.96997748980134, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFll1OwkAQx5cWwkdLSwETopEQX1Q+rSY+eAB9MpEjNNgEHowGOY+X8Cpe
p8GZ7UDKuC0YlvDQYWf+v/5nNqWwz8FiGr4Fi9kk6DzNg4/pbPLZeXyfQ8nM
CSHGcL20BKyXsJLXOIoiEFLiA0QjDMMTmfkQy5AJExbwicWmVK4hlqCCQhFs
hRnLKDYk0aF7DSJKX4NXYcJiw6fFfDxGxV4u8zpVUnVSL5SqgxGnBAGB7sGp
6oqSmRC9bIq8dqP6jKofibLZHgc6KOp4KAqramrIvLx/UBbb40gHRR2PS2E1
pipsep951Q5H0Vy7UVcQLEg9pdqGUIG0/P0TbfdqEt1Q0mW2C4vo83Q6H5cA
JPYylUXUT6g4lbrvHfNw/+wFgdtsirzUlMW8fB3U6tkrKZt53eigqKOaqjKv
UTa1eof3oJwtHZ1NKsUrplzmNdRBUUc1VWNeAx0UdVRTHvPq70HVGdXTQdH0
vKP8NsT/5QkvfPMLiCdOT7aSPINQQRDqBSg7mxR1dYnKQ46/f/HZocm8jARl
Q7m9pvDkJ6emWQwiumuiCNm9zLLPkSL3C1iRa6c=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    SphericalRegion->True,
    ViewPoint->{-2.27040748592378, -1.96093086259084, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1l9tuEzEQht3sZrM5b3M+NmkopbmIVCQESAUu4aoSeYSojdReVKDSd+CB
eBVeJwLPjOM4vy2IhIia7Tr7f/+M7V3v+Hr1dLd+WD3d36ymnx5XX+/ub75N
P3551D9FR0qppf5+7il9/kuf8Xe52WyUutDHeL1eP+fWCzomusktpU/keMbt
czqm9ur14pbOv9+K5hn/SsqcbuX0jzmtUHnRWJmasY7VkfVSMWkTq7XyU75+
alxVZEMLEe3cc3SIhCLVhKVTiFMAKgLqhHUToFKgYqDGrBs7fS8CkQdixMQI
4pSBSoAasm4IVAWoAlAD1vWd7KpApED0mehBnDpQRaBYr7pAZUCVgGK9atsZ
luklCMkykB0mWxCvCVQFqDbrGs5otICoAsER1DHE6QBVA6rJugyoLlB1oBqs
qznZ9ZgwCi3OgOC8dM77cQZAHQPFeemx2aeGQDWAqrOu5GQ3AqIJRM0SHMc8
u2OgWkBVD6LaQHFv9F2536cToDpAlfcpEwupLlCl/0j1ZGHabAxVDFITuJMw
1r9QKYwhUTTj/T+rnXmSZ/nHz+1rpHcQOdpmp9vEsoGTLc542GVg4hc0Tf87
MJ5pkOpD7JRj4z36N5euiV0BGp8LoQvOOBPdsSMnSZAJOuEzGXZqQ28ycMH1
AFxMb5omnzbMA65aYboBOXTMfGQwkoUgnZnYA8i8dhBdh9hDcME1XlwSGMWa
yWECNL5TwnTF0DOg8T0GtOlBGXpwBnOAb9+wS9HkcBGkBSUkCdIp5DA3M1iE
ORA6D6tGwcReQP+xPvFpLhwNfQk01kRhOobMX4IL1mPgYvqfMzm8htHDqtGh
E0tLfazP3wKNlapDx+ttya0/V2a0IxhtVuoa1OjlgqbeU5zE9pH++FJi9W4N
TWIm8rtRkbUa7gUzmx9IGytnV5DYJw993zmjvXMsOhkr/lxtdaYPiX3vo+Ob
bXRR0uq+sRXMnucrTylviWrA9dLTSjVQ91wXnlJqlCzgOve0Ujc1PNdzTynV
XDPgOvO0UmFuK2eqxiaeRqpdrMlHnk6q8F4gbtfTyu5gAJ5tT7fbraBnne5s
giIrdvZQrms1oJSd3UnANw2oZQc59cY+H9DKHtbuNmPrHNDKjpmJvOtLJ0Tz
Xpr3wxR2zq2lc1RHvwGMMlXF\
\>"]]}], "}"}]], "Output",
 ImageSize->{463, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20527]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["SphericalRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalRegion"]], "InlineFormula"],
 ", each image is made as big as possible:"
}], "ExampleText",
 CellID->5964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "->", "80"}], ",", 
     RowBox[{"ViewPoint", "->", 
      RowBox[{"3.", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], ",", 
         RowBox[{"Cos", "[", "t", "]"}], ",", "1"}], "}"}]}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    ViewPoint->{0, 3., 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdl1+OgjAQxgcLeAUfvYBXAP9ifDDuCTYhLok+GI16M6/idRoddJTttzQb
m02WSgJ04Md8/YZSYJ4fV8UmP66XeXe6z3er9fLQzbZ7PqQCIvrg9bND3L5w
67bGWutRURRt3hOVESkO9W2hFOLoB8U5KCk3igM5FJsUnzz1vigpN4oDByoC
xfRB3UX/n5Le96H30Z9TIfRrAP3yhBKPQ/AYvkApUByBoieUeByDR/UC1QLF
CSi+FSWVyKASrfvVYTULEU0hk8eMzK5lfWbgPBCiquAMcrwfseBmHXvWv2Xz
joC7/H0c1BIwmkyd+hHnA2M8/wxk4B6o51xi5rLNOD5RCioxhko4UfrxrjIV
bW+0ZlAheByCRydKFAegaPvKaQYVgcc+eHSiRDEFRdv3cTOoGDwm4NGJEkX7
f071B0XBFV6QvWg=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    ViewPoint->{2.52441295442369, 1.62090691760442, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmM1O20AUhQfbcUjixHH+SAgJgSgllNKithJSK/Vn06666KKLLiOIBIuq
FeVF+ix9lb6O1XruHXuc4yswtWCIPec7994ZxzPm0+r2av1tdXt9sZp9vFn9
uLq++Dn78P0mueRuKaU+J79fhyr5/Df5RL9ncRwrd71ex3SoqW7Us6TVF/fp
7DRpneRMeXSq1nSw8gT6+HCy/uO037X9zpfTS+WxUXI1aSfUeSRoPa2tGO2v
S5arPRIsBL2v9X6mTz4wMibJXCC2NwmGMuJQt54dH6XqWu/aCI5uXI6iFSOS
zSCShhoimaVoyKmQYxNIF8ghSfcEMgTSS0mT7Q5JdwWyQ6QdFA/qHJB0KJA9
kbTZMjkQyAGQFci2T9J+YU6GwPmQa49kXWFORkBWgeySNBJyHYukrZLJUCAn
QG5DlR2SNgVyH8gaZBuRtCGQByJps2WyJpBzIOuQbZuk27k5YW4BXAO4kJS+
MCePgAygylZGksrkuYQ7PYAKi5QGkGpCls1SVAuogKhK7tmqMzwGKoS6Gg+g
bF3lqDZkWN+kTF1IRZBh7QGUzbAc1YEM6Y7iZSVX12OgukBVS1G9pNF3naw+
gfsPY/iblKnn/yidmc6kL6pdYVa12tEnhVh2nioifWRoWu1+/4n5h2P2Sjks
Ugc3c1Cebu6Yx6KTrntunOpE20qiu2kzageGDiB2OXqaNPo0BBq/I0w7MAYT
YQza4BSWchoLTl3Ryc6LJzqNBKcBOLXuddJjs2Oc9mBe8LkItBnZvqGnELsc
3THzcgB0INL0JxuCSBiBQ/DBFUjyCQWfBfhkK6B5vkk+TcFnKfpYyiyBuSuB
cXkKs4Hr/iap74i6Ic8gZg3GoEhWzSy8ABJ3KSlp78KKUPNLcKne6+IKLufg
4ssudv8heLwSPewYOhseazrewbhXRAYjvYVIuIvNUxxUA++Awp26I37z3wPl
ihQ+x5FyRArXRaKqGRXnXq8MQc+5jZ05VeVnQJy+wrHel/UVq8+769UaR+0N
6W0l9MHoa5A/zYt57+SWdXVJZ0bDujXuUOlLW3Q9KFT0OtHxep3dVkbbLGjP
jVZHdLP8WkLdz5NGB0+fOnzwOtOGTM9yrtqHd1YRqJ5AbN4hdkC1FOPyLrmb
q0fRMTfqNDK/K/QKdc8gNr8B9YW6x2J8fi/cgVyHEJ3fkoeg6kPsXbo+AlUk
xp1Q726h7gAiz6hnXKi7BrHpvw2F9/h0l1WMvyDBdDO+qFxS3z5UleZ3Quc6
S21zyr1b/wAGho8p\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    ViewPoint->{2.72789228047704, -1.24844050964143, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmN1OE0EYhof963bbUgoUChapgEAqv4oRE1CP9IgDjk1MGmgCB0aD3Jm3
4jV4F43OfPPtdubd2XarDUx2mfd5329+unR6NXi8G34dPN7fDHqfHgbf7+5v
fvQ+fnuQf/LnhBDX8vdzR8jrP/KKfq9Ho5EQHdl6w+HwDd2t8p0I5MUwfZ1Z
fZ6EPXnty+tT6llRrbrVkPB+f7n1WaWI40xF3qpLKuSP8GVj+h2Qsq3aYOwn
RGzolEff1ske3SacbNe/R+pl1Yba9erwVgOiARXs2FrZM9Y2YVxbpF1SbZT5
ZvJFZy2bNqP9M6YN49wg9aIxv1IqPNX4mlCzuOJMWrdZnZRj12D8q0S1INEH
qgt1tm2KszKKV/ups06qUCxAYgDsM6izaVOciNQ2rFiDqCZkhUDtOutMbBYT
eWb6MDMxUfNFiUwdpImsoe1hk5yH5BG9jeQNv1cqRDUgL5qN4qxyVB2yKkAd
p5SW8LjqkFWOqkFWPBvFWYUUj0tTCWRVZ6M4qwp7y01VISsB6gTGFdoUZ5Wj
4qIsHtfpZAqzkOJxaaoCWbXZKM6akdIP1JJUBFl1oF7CbAT/QYUwGw3ZqGfE
K6gM1I6M9FFxMjP589dIeKoJdHX6dVjKpwY+Uc6n/08+iWzU7T7Mmu+kE6Dn
mX7upIMJO1DRLaa3oHI3jdltpjcn0wWVd5julqKrQHeZXidaowrxnHQMdI/p
VZi1cvQ208tQuZuuAL3HdMtJ+xOe8Yruy0Z96GuUojH7KLdnk8k+BWM4zfnE
sA5zTp8IfF7nfEJYkSk+klcW5zkfD8bl9gmhngt6Y5s+GnfTAdAfVONnNGd6
sCaY+T6lrBVACrOQ8m2qoMJ3QAVOyp9ChaWoy3RNRvRSa+vkvKlcNJnjPXAJ
VerPZ+aedFZoEHGOcNZmENWpxAUQ+nM0/QvNhqIv0LtWqETPulaGmVK3WmfN
5ESl4ahPCvYpFDXzPPaxBhX6lJKdenmd3oJqwfJR1agTxDmoWpmXmmzVcQaK
xWyXBIbqODcHWheB7gW40RmVVkupyFV27oKKTso0E77htQWq8fnQTNwAFX2P
QFozsQMqfUJdA9USqDqk2oC6mqBaI1UPvGpO1Q6oIlDp8/Y+qESgZKnoCWkO
jKrMp2WXetW3JeEwPfuLub+woOXr\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    ViewPoint->{0.423360024179602, -2.96997748980134, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzV111Kw0AQAOBtk7ZJbdWK4A8KRVCwoChUH0T7o231xQePEDSgD6LUnsdL
eBWvE3Rmd6LrZE2bJqIGGnZ2v87ObpqEXnqjW//eG91de/Xzofd4e3f9VB88
DKHLygkhruDjLQtov0FLfq6CIBCiDWfH9/2yjA7h7EJUwsiCRiAP4cjRXbI4
6kKKqNjUvu8AcJ53boQFDQWFK9W6lgdVzagWWa4VTcFBqsJybRgVVmdDWKTK
G6GC+FNFVg2gyWpzvkqhjuOxCoFZFbVZMdfJDyms4wcVrbHF6iolUAU2Y/tX
FVbLFFWfRtlsxs5EqsuqL/62ojV22X2klMVynbI1/hV1xtZYmEbRTphVnuXq
sf36X6rP1mirflt9SQWDjAw+IcoQFQxjTRpzXl4DvWpTngbZhQlsneya2VoU
wrFEcusb+blnVZJ7Y6VF8sgoi9jEXhhF0A0V/cKj+S40IS+kYcXn05vCh6H5
BkbHf0MJFe2BZbwz+8kU7VQSxZ+KvQxVn+2E3IPIG6mXQulvXQRn8Sp83qVQ
JaZOEyusNolymOL3RfbKjVHYlUugyuwKdeIV5UqjZtiM7XhFudKoClMttquZ
KHoCKFVl6mQihbnwr1IOupSYZXu1D6cKCug3KMqzSQqvh/2tWgU1Q6rih++5
OTZjlanah8pr7wPMh8oltf5F5bWRbTkyT9GBqiX3DiEZ5mM=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    ImageSize->80,
    ViewPoint->{-2.27040748592378, -1.96093086259084, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmM1uEzEUhZ35TdKk+W/+2yQt0ApVCCQqAUICAWXVRZcsozZSu0Cg0nfg
gXgVXicC+15nnBxfoimR6saZ8x0fX89kPLmY398svs7vb6/mk8938+83t1c/
Juff7vRHYUEpdan/vvSUfv9Hv6O/y+VyqQ9Qe6LbaLFYHFHv2LSJ7lJP8Rvd
HlL/sW4D3VMpH744vTY9pVikZvTxI9NGmYd+BVqoYvPJz2unntJxGjd06sho
E9auyyd0fLZKEGYJmEgzYmOMA5JNvUSJYUI3SmCa0HH7pJxAtiJQIVBj0u0L
GZGMgByRdOzlLAMXAzck5QhyVoBKgBqQbmBzBvpAFYgUiD4RfRinBlQRqB7p
ukI9kCwB2SXpnlePBnBl4IhQHcjZAmoHKNKrlpATyQqQbZI2vZwd4KrAtUjZ
gJxdoHaBonFUbW3dekDUgKARtM/mOAOg6kDVSVcR6oFkA8gaSXe8eoyAawJH
CfVqbubcB6oFVJV0RSEnkm0gKyRNvZwT4DrA0cz09bQakYczEJJ7QJYzcn2G
M6C6QJU2KTs7pHpAFXNRfaDSXNRgRdlJJA+j7FhMxVCNQ6CG/CVLiJHED6Bc
QqBswv+nzMqPcqmnVm2uVLHyW+nsjNL9X7+XKjDNihLWj10iqM6BzZCItKtt
5NEb15HNkIJLb7uLncnIZqgQLVwjW+mBpUmpHYyJcTKf5XPowyzqMIu26BJC
JXs2RxvoVi66Cxk6oourZOi5GIOOzdAHurmdtnVoQ4YhrEcdZiK7NG2GA7sG
+ai6pWaQfFekA6heHZIfgks1l8uuzfAEaLyr+7QZvgoZjkUXtwaB6LJjM5xC
7cswA6BtFUvCtYBOpVxORZjNc7uaMk0ndVbI1KZ4CRVIc7AJjHsGHrhXtR7r
dwE7+muRdLqCR0Yw9htwiLc6mDMosGO/g5qHMHOB1P8/2Br/Q213Igx8MiMk
WbYlPdWYewmvpjtNaSagzspnnWPuuSvh3Ohj586jFtyVa7OwnNyjLG/maxZ2
PYl5fVyrqfNMPM/3phbK1chpU8H1raDmwyVQm+FfCWq+O/o70zNByzsh3P8a
5xeCmvdou57zM0HL+8ea4PxUUPP+tuE5Hwta3nk3BecjQc3PBW3PeSpo+Vml
IziPBTU/S3U954Gg5ae8nuC8J6j5GXTgnUktQcvPxUPhTKoJ6jEdHnvOFUHL
vyjgM755FQU1/8Yx8ZxjQcu/sUxXzlHmLGjpNxYi1lOYlu5v1DUa8xV1wgcL
fwHTi23i\
\>"]]}], "}"}]], "Output",
 ImageSize->{463, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26630]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19438],

Cell["\<\
By default, 3D graphics are sized just to fit in the 2D bounding box:\
\>", "ExampleText",
 CellID->1307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15767],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  Background->GrayLevel[0.85],
  RotationAction->"Fit"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52252675,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdmutSFFcUhZu5McNwkzsIOMAoIIGgSBQloYiRYIxammhpLDWoE8ELKmoq
5Y9YlR/GmGiM5gWSZ8gb5A3yg7exkj77nB5Or71Pz7QhlpWpsmWa86219u7T
w3T3Obp0b7l0c+neyuWlwsdrS7eXVy7fLSzcWvN3JWs8z/vD//dnl+f//Lf/
E/37Zn193UuWSqV1enkzauPd97cpf+cBenfX3yb8d0nz/37ae8e8S1sK/tYo
rPpbtbNW/O0Nw6rfJv0YXqqcwP9hH41ZsRQS/pDErfGHXtr/wR7q6bFXjV7W
jE2pscnyWC8BVU4TVYIUGYtSoZJA7SHqEuTKWdSr39Yc1JfglVdUaoPiblPE
nQe3xqALPlRGWX2aPQeezSKLvruJPQtsS1ClZr2EopXWevBSe7XvacjcDmxS
saky6+/S3Ofg2SlxzFPnPWmxyrMH2JTI7iL2uMmbMb69wKb9/7FL7xJ5FFy3
CSR3nST2E+jSIMyjNOuS5hahS0WJY5467wLkHQY2I7ITxB6ELo0CW8vyam4e
PN+ROOY5TuwcsBPAZpmn5mYh6yRwOeGI7iRyPzhOCSRPO0bsXnCdBraOpdXc
NHjukzjmqfNOAbsfZmBeZEeJnYS8s8DWs7yamwDPOYljniPEjoHnPLANzFNz
o+D5EXCNwhHdTuQwkAsCydPuILYIaReBbWJpNTcInkckjnnqvAXDBp7HYDZw
T831WVmV5wngmhlXJG4rZP1M4ljWIWK7oD+ngN3CPDXXAZ5nJI55DhLbBv35
AtgWkR0gdgv06DywrSyv5pphZqUNf1HimXeBNJpM7pTJvQRsG/Pe4ILvR3qr
nK/AjGoX5n8f42mH95XA8tT9VdIdLHcskvnq1I3U5jKtBZhCJ/OOQ3cxujcu
zdJv3VAI1X4V6G7mXS3ZIxzpLge7DHOMu/bQwAaxYqR7GN0dl2b96oqhsJX5
W3So7hUgexnZGYdkqTuqpPuYrybrxXqR7heOdGs1vJkp/cy9PQa9jdFtcWnW
Nyt9qG/XgC4w72rJAUa2/EsyL9aL9CCjt8SlWbeaYygMMX+LDtV9HcgiI5vi
kCx1o4O+AbOb+2qyTqwX6e0BXQpeDa9Dl73fEjrUsZubRu7wN3iPgI6QlxMz
34QjrXh6b45xw5tkQxXXvx10qNur/zmZFRMjPQydfqNsKHV+s+hQt24Ls3pz
yVox8ebSw8K5mIvJ20cqrnc4eV01tPNIWXSo33eqJDOi7/+HHoFjtUks6zXd
H/d3jrC0OQe1aig1CaPr1QppMfN1a34pmq5vf//rVfRnWpTiVStXLlBy/v2L
UrpiKTWAEv/uEaW0ZCk1Q3XbhbO5NkLrgtCxNtAswpG3soWO4TkrVzdo8O+D
9KnopcRUZyylPugV/2YbpXTKUhoAJf4NO0rppNCpIlQZT/G49cxFv0ZBj193
ROkdsWodByV+9RSltGgp7YKubRNmGJ3P+skN01qwtKZBi18R1kYoHRSOwAwo
8ivcKMU5K9v70LF4SrOW0jwo8av9KKUZS+kQKPE7DlFK7wn9Ogz94vdQLMXQ
2T1l5TomqOCcoM8H/SSQJZu0tE5AjT3waVMboTNu6ZwCHX5vKROhtFPo1VlQ
5PfnohSH2dl9AbrG7xZG6Q1ZtV4CJX7PM0qpYCmVoEaXEk2Ikv302t/n66gi
e4XerYBu+2vodrMOrgqqOO9SFXXbrfrXoJP8rne6ol6Lpfc16PE7+JX1moR+
PgDdltfQrWf9/Bb66VRlcyhv1fwdqPCnLC6VrKXyCCrkz4dcKmlL5YmggjMk
6dBJCH1/Bnr8aVfKoaYMX0BnnLS1IkW5EuOzCn8JGo0OjeBZThTLn2bys0Xt
Ud38FSrnT1+Nr3T+WRlegE7eoROs5gmeZb0Ejj+t1ly6gv9z6EFemBH0nr7F
bKwgcivwJHpGZYV5pir5BSrJOficw/9n4PkqA83nHf7PgecrIzRfX6GTT6EP
Lp0GRx3IZxx8k6MOPBczwpGsIYVmR4KfQCFYSVPjv1ekplsc/k+BTrH8eh61
OtyfQP0uvl3wj9Lh65e0Toejjh+hjoSD73TU8YPapMu8oj39ORDuY7fDn/KH
1ppxtsfh/Riy20fP83ordO77wNl0Luys1yxIiR9Dx8NUvyPrI6tP5daaGVpw
OCkmEfz5CBEDDpeH/iblbXx+6tFDFTrxwFDZUCXF9Y01ASrFfX+UKiAf0t5R
QXvVaCsqXT6rhx0VX7NGqwsOfV064qj2kklUZ7T1feGdFRKdBw/9LGwMqj0L
o/TTyfEK2icgkX4GPWFp26M/BQ+9NmESPBIm0SKM1itOdlVING+oIJFeA7Qb
qp21cittvfZrTwXtadDW6/imHdVOWqOVh157utdR7Rgk0mtp91VIVIREs0TN
QLUFSDJPow5U0O6CRIeImnVU2wpJDtPoDxzVNkGiYzR6zqGdhdEnafS8Qztp
cudMktM0+kNhNF3je8ErUD9H4w+aLNLdHqV6kUYdsn5Lf9WMxhX6rVrhmfHf
LdM7r+Yf3N6IoA==\
\>"]]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["SphericalRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalRegion"]], "InlineFormula"],
 ", the graphics can lie inside the bounding box:"
}], "ExampleText",
 CellID->27925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
   RowBox[{"Background", "->", "LightGray"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  Background->GrayLevel[0.85],
  RotationAction->"Fit",
  SphericalRegion->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410589546,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32250],

Cell["\<\
A circumscribing circle just touches a corner of the bounding box:\
\>", "ExampleText",
 CellID->3274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", "0.5"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->734],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  Boxed->False,
  Epilog->CircleBox[
    Scaled[{0.5, 0.5}], 0.5],
  ImageMargins->0.,
  RotationAction->"Fit",
  SphericalRegion->True,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774219068,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", "0.5"}], "]"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", "80"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"3.", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], ",", 
         RowBox[{"Cos", "[", "t", "]"}], ",", "1"}], "}"}]}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->True,
    ViewPoint->{0, 3., 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdmF9OwkAQxhcKAgVRCRJi1BDjg/yT+OAV9MnEKzRoAg9Gg9zMq3CdRmdn
F8SP2S5NaoISu9sZ5vt1pdvuzD5E88nzSzSfjqPO/Sx6m0zH75271xm5gpxS
6lEfbUXnn3TGx0UcxzU60b1S59QWyKpRX6T+jL0n1ntMfaCMrVSb2jxZp7Zv
s7dlrY7tW+xtWuvS9k32Nqx1ZfsGe490qy8T80f1wD7gqEPwDsCuc1TdklXA
Jn/6dOSt30Tt67a40trQ/sfwaZ2YhytUOa4G3lUUqTWgC5QA4kOmVMEbeCgF
iK8wJQRvwUMpQnyZKRUPBX8XpJQypJTBW/RQ9iCebcOSohwUjOerbrBLHgqO
vZAhRbxzCRS8G4FIwbEMqNFPCc4ro8Y5iGMYesaQz5CCT1XFQ8H/KJchBd8T
oYein339ctbq3SXgbzFKIHy/b5ff/F8lrAcJyppVZqHC+3njGOVfVN0qsyIn
MRcx/RFzsbEi/0VVFVQjUK3PAWmmyqpt5viuKt1vn99Qh/H2709DGCZcPyuC
ezWSCWnXtDQU9yotU9Ku9Wko7qxFpmAG5ct9DGVAjTv3cWdxRt33jMGXC6ah
uLNbmSJnt+5MW6bImbY765cpaWuHNBTxziVQxNmZUJkZStdDMZWZu0qUKXKV
6KpTFzLb2qZOxUpYi3qoVMuKWFfX17DemLp7u+pcruzlXQB5x0DeXZB3IuRd
i587Gyr3Bdr/OxE=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->True,
    ViewPoint->{2.5244129544236893`, 1.6209069176044193`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9mOtu0zAUx73m0jTpZWt36QobWweTQEwIcRG8AHxCgg88QLUhbR8m0NiL
8Cy8Cq8Tge1z3Jq/T5K2Q1Spkzjn//OxYzv2+TC7vfxyPbu9Op8dvb+Zfbu8
Ov9+9O7rjc6KNpRSn/T/41jp69/6yv6nZVl29cWJPit1qNNY33X1OVF0r9SE
cwf63NLnWJ8jfb5nn445d2jujNnnswtlfyk/2bd2u75dSnZ06Ovyx0XGz/es
9bZvHc2tVWQTUuhDddhux6qGnsqcU2MdL6yVyvnJyNpvOXppf2qTn2ZGl8x1
JFWFYK0o9XJdK+XgaUsnXcFWqT4rXOldQemrXB1I3ZOYXoshLQIa1sr6qNDT
PlD7QI0bqPY+yO0BdROoiU76oMktKRe8tu9VIAS18+47ltYRvDW03RVpmUhz
fXQMtFSoHREyIdcQJkBoC4S2JbSFXEO4LxDqapRaWiqV4b03pGYN1ESkJkA9
DMZ6WFsiJZAbc22PBUKdX7FIi8AvpOYNfZ+ocQN1CtSigRqtRe3qBGcMIkWl
4HUDqc6/1lrUnjDXhdRWQ89Bar+BurEWdSDM6DIJa30ikIJZ6c7UTYFqlgGG
RkR+9cZgMRoraFs6Ke5MwFntf9IeaYIRDJdQVvcCM/rN3NL6+atctrXriQ+Y
mAjEYmnKAVMyoAxWoky4jQqg4AjKliaO2a8BEHGk1xP3mTIECs5C1RQcLTtM
3P5nxBET9wRivjRliykToBQrUfr8Hg+Akq9E6bIvx0DB72i7lthjykOg4CoB
KYvRi1+1DhNPG4ipMLKrqW2mPgYqrpFWoyZMfSpQ6+csJLX4nT4DUiqS7Nci
mXtNWMsw3rwABq5skyV41ied8RpYuBfANYr8NTOkN+uTgpq+BRbue2QWrlcM
G0m4H5M0IWl+r2kGiK1mqLjyJFLlGs8nLXa5+hAVASeu56iKOoirbZ/zKuCI
K5eAk0gcbiFVSancRXgU07eCtUX1roaVL+flU4+q3ln5qudCeaTEXR0qz3QS
CfUkNa4JUf2Ey8W3LO9JM1CfshprR2pcL6N6yp5jDWl3jTuDDqgPuWwshXb6
4o7dU09YjXYUccC9Dqp32XO0oyiIi8zkoBpxme45RWIwEoStNGCVFDEKY1Go
LthTKWa1iHihp20u0z2nuJeLrmFrRGw9Kv2omovc+R7Z8ehZUtTOxQKxF7nS
KRLo4omGbowojijHHv+OT6qNP9TSPIU=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->True,
    ViewPoint->{2.727892280477045, -1.2484405096414273`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmG1uEzEQhp39yG42SZOGpElTWgLhIwhVKh9ngF+V4AJIUYvU/kCg0ptx
Fc7ALVbgsceb7ZvJehNAomp2Y2fexzO2d23P+fL26tPn5e31xXL27mb59er6
4tvs7ZcbXRU2lFIf9Of9ROnvv/Q383mU53lHf5nru1In+hrpUkffY2XLSk25
dqTvob4fmdqJvga6FPDdlQ/NrwdciqhEop8fLxVZ68+YfxsbyyGXYqfQlmWr
kbEacCkxvPPTS0Y22dq1d89Y77tWc/Onmq5shaqlVaFjl+z6Rt2HWmozICXH
Qe1m3O4QbHuGsMfetKgU2XZt0z3WuXisfRcopAuhxbKybNsxhI5AUHHRMsc9
ZAZG2DaMNtRmNO7gxZB7bk+wVfaKteEqfuzFMfsjxc+9B17GQJgyAX1PRYLP
n2OOLhVpWCv5M2N/EmEOrde2wR8c8znTYmk+r2Z1aSY0gfCELiWbEDSxSEK/
cBbUo6LXHQ/1qYcaiVT0FUekHjXy+Oqjoj4UqegrjlY9KkaAvvqo2IOBSEVf
k52ogcdXpD7zUBsiFX1N/2MqvoOQugAqPZu0eBPNEnkaKKk//4yGEbf+Ke25
0H+badhv2Q60zaNANCoipRxhNcFER2v99x+5/acf8SnZkhcWPBUxcb4zMQVi
ysTZVsQ2UNpMOano/3VKBpQeU45qU4q1fUN0AyZOdiYmQDxg4uivEQ+ZONiZ
2ATiMRP7mpjUpsRAeciUrrAebSbiCDxmSuah5MUzThTsowVTEmEd3/y2kEgv
9IUe0HArUrHrw10LU8+YWv328lFe06XSJ1xHmkAMPcRoa2IAxDeCj/71jqg4
vyTf6pF8/SavwdL+FEmvPCR5l2Q8XztnYU/h/tqyxN3dGgsjRJa80zS1d06e
yMGziOWIUVdy0B95l26yBNDjLz0eWZLhN4ta/VcvnrhSjaONZzurTlz0pqRq
6OzJjGqpEiNEa3sqpHcVnfLOPNbrZ1ryiJSntZR4Og/Yy4VHbU/jeMKOWT33
qG1mAPMTCasfeNQ2M4H5gYzVU4/a5kZcNmaPVSNh5qxyMZgbIRVNgb5nvlk1
Zp72uc2u56mxmSeXFXKZtlR4J62yXC5zNmbrUHirrjJoLkM2Yes4L2fhXPbu
fl7O4smZPzlLeDeTqBq/AbudF7Q=\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->True,
    ViewPoint->{0.4233600241796016, -2.9699774898013365`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdmFlOwzAQht2k6UYKlLKUsqgCRNnKcgl4QoIjVIAEDwgEnIdLcBWuY8F4
MkD5PTRtFUBQqXY8mf+L48TxeI67D5cX192Hq7Nu6+iue3t5dXbfOry5I1OY
M8ac0v+kYej4hY74v2KtjelglWpjlqnMUyumOjJJ25imWGeoDqleYGuDyoBa
i1LPs3VWWi2p59g6La01qWfYOiWtDanrbK250l3G8o9JRWqGYJ9k70mwNsS7
9Ng5DxTVBKvGe67ovGvk3esVyPnEuwqMiqiaoMqDX8zqGKyhqFdAHYHfGKu5
jN6tbDNmG7QFpYcmKeGuuE1qB9gEShH8y0wpK/3vRymBfylDClqRsgUUvCrf
oXefeaDg6CKFR9sb8yiFgk8jypCC704hhTKmjUBGFJwFxRSKNj98CvZlZyAK
zn7sC1JwpgcZUgKwloDSSaHk/jzFfXXdMuTUCUEek3P4mGWi3v3XauXrIuq9
PurfV+Iz3h9Z2aaiYpIVfDDFkijKT892tGvWhVAfmVAWwtJQhEBU7eFU1DwY
vqekcCJUVjNTWv/NF+U+KGM70Lz5BXUF1Hup6i+/dt9GwPVVp+A47P4gBVdG
pHSAokakGVEwYsDRxTtSY0mPktYXnYKRFPYFKWpEmhEFI0yk7ABFjUgzomAP
iykUNSL1xhwp20BRI1I9qu9DwbdU39eMRsE3GilbQFFnrzdHI43i7SX1Xaqq
lfNOxRGhFxfmQbVORcEk++2PXTd6Nalwq2Nke3fduLMPQFUVFfolas4iePca
imYBNEku4S0fgaO7anvzE3ouQ8976DkSPZ+i514+52dM7hVdGqCB\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->True,
    ViewPoint->{-2.2704074859237844`, -1.960930862590836, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmNtu00AQhrfxKbYTJ2nSJD0HEBVCKkioQkgILuGqEjxCVJDaCwQqfQce
iFfhdSLY2Z213d+TrMMNRIrXa+98/md248zO5fLu+vOX5d3N1XLx/nb57frm
6vvi3ddbfSnYUUp91N8Pc6XPf+sz8324Wq16+uSRbpU60cdQ97rUo5OV+0TK
3lXqgMfkug10m3B7aO7O9bGjewX1yOjy/BNxftBRpXx334yd1sZS26GxoR1t
DTK+MzPjJ9wbUC+wbDIxdlFpx8/KefSesd3l3hBsA3OontmhQ1B6XioYG8rI
WfPdAmgR0AKg5WBv1FSa1lBjoIYeqolPGdUBtylQIoFSRlf1PZqQFgOtB/am
37iK1AyoiYdqPG/432dP+kDremiZoWUCra4RqamHmhpq6qEWQM081K5IzYE6
BGruWTmW2vVQR0DteaiJoSZCtGmWJkDre2ixocXS3NU0IrXwUCORmgJ1D6gD
4W3RpEZClMnzOdCGHloo0hLQiNQRUHHNWGrooe4DdddDDURqxJ4fAW0MNFyB
lhZI0a1pROrEQ+38FXUPqLiuLbUDV2MPdeqh7ohU1HoM1BlQcX3/T9S5PtAq
okSFCJbCU6+kNXnSQte/opF3NtPZhoKr5NhlRD9/0RB6Z7TgrV91h6wqJJ5n
TTvqZuKBi5omEjQSyGlr2pz1pUCZbEWZgaYMaPi2iTeSnaYCKPgG3EyZMmWk
KdS2t8bfzRi8G4Mu/E9qTx6xxplA7LamDEHfHGjFVrSCNR0BBbOEaCNxwJRT
oGDmsplSgGcLnksfpfp9h+Bdxroegy7MKUPhV76emoLOM4G++T2ExIR1PgVS
d2tSxKRzIGGmHzSo+H9C/QQ8fQZU3JW0ozqNL3h+kYI2NVJUXrUhUCEovACF
uEPcht1hna+AiXtYmWkmKa6uuq36a4GGOZKcOZGWN2Rd7eHX2pp1Edaf/pYs
4+q5dv1wvmvHNyJgbHjnXxqsybrLKPBMkJ+B4py/MZpUd+5Fw7Ll3UcI7Jdl
FJzURLRz+fBF7SnSjFmPMCeM4anPgYKRt9oxC45ZwzlYizuCRp6fgIYnQJH2
Pk2K2xGdgTV6bK1xX5SChgdAQY/tjhx3gK42dQrWqNVWCcTaQU3DAVBQs61c
YJUlB8oUKKjZVlVcpacH1mPBuqrwYNUJn13w26+AcdYaK2FonbP1AMbZiper
xvXBKqlZVVU3V/frcRvBKFvhm67kKNRH2jqiq1HW41FVJV19k6iEsXVNVxkl
elULvV89VTt/AJlUhVA=\
\>"]]}], "}"}]], "Output",
 ImageSize->{463, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->899417305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157081893],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["SphericalRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalRegion"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->615683380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "False"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", "0.5"}], "]"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", "80"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"3.", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], ",", 
         RowBox[{"Cos", "[", "t", "]"}], ",", "1"}], "}"}]}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->858209360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->False,
    ViewPoint->{0, 3., 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztl1GOgjAQhgcKeAUfvYBHMEiI68NmE09gQtREH4xGvZlX8TrNOi1Vyt8K
PgOElqH9/gmU0un8Fbf97ljcDptisrwU5/1hc538nC7cJAIiWnFZj4ntf7Z0
SaSUIRtzvpJgQ+qDYlWVtdWaGbrsjVQdvXv5SMm0WppQs0I7tVm2Kb1Ptw5r
3QclJwxue2elEs/Ag0LVqyplXa0ftkUdWWqlrPc0KWOjJBq1kIn2/R2VAIXj
FQ+Uf74aKvN8335QOF9zz38yUBUlgFr4VqZeUCFQS6CCgapRdnT6JXJG8SH5
ZO3DE9kG6kUJoBZA4QzuLhUBlQOFq1rfqRioDCiMmt2lEqBSoHAn1V1qBNQM
KNyDN1HOODcoqizAn3X4VZh1yHc8aVO62c6nPMuz0jhrMORzL53jDeak6UhN
7Kvyw+bckoInb6bawg==\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->False,
    ViewPoint->{2.5244129544236893`, 1.6209069176044193`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9mMtu00AUhie+x3Hi1E2T0JbSqqWFSFQgBBIStxWsWLBgwTJqkNoFApW+
SJ+FV+F1LJjLGWf8+1iOuqBS7czx//0zY58Zz/jT8uby2/flzdXF8vDj9fLn
5dXFr8MPP65lyO8JIT7L/69zIX//lb/0/25Zlr78sSPPgTzvybMQM4ru03mu
o0rjydI9VVLhUv+JiOJTrdp2VMqxT+WJvrrlXFVn78uTlfG6XSlBSvFCq3NQ
B676diUyio+1egTtmtHVSFHBmhJiCEpdrtzmdE4UF1acQbXWsx5iwNSpy5JV
eAIt9uQhBybVTilEp+CUMk6NPjjlvnbtQ9Q+wyG4+R1uiXZLIDohtxzcgg63
WLvFELWZUzBuYybnhDk60cLmWkd7MFNC7RZC1ObqFNzCDrdAuwWMm/s80TWS
hy1gfO3kQ3QMTnNwihknTzt5ELXja49xQJ1b7rFudmTcB7ek434ZN+qscJ0e
gFOfeqYmM0VZcu01IPKIIbFH1qXuYOerY3BImV6sHey89RCoQQvljEx6ikhm
lPVGHZP/I0bVuLfrkUXeZ0ANufHZSY2AyjaicnnYrFU5+A82osZAmdk0Agrv
25Y8ZBsrm/NqF1UAlWxEbQMVb0RN5IFv1eMOfzOLhkAt/iOl+qKKU6lOWMWp
PKjM93//KdGfJ47JMwICn8l61j+hOlIg8NkbIoD6DonO7kQfEJ0DjXnN0/tE
F0DjWOLpXaJ3GDpmiRnd2zkQoxoxJ999UOG8Y96UPtQxIfrgTnRB9BHQOFPy
9JjoE6BxHufpEdFnQOO7g6cHdG8XDB1VREZ1nIOqX6k88E2IeMoQzdUG0hHR
z4HGtzpPB0S/BBpXGDztEf0K6KiTVu9MRb5myLBSK8V7UIQ1hb4iFUr0jlE2
11h+B4VrUa8+zlooXJ979ZmvhcI9gqEijmrsc0yOJqB9qw6BqzW6Pqertd+u
ZFJQvqk7CnPfjbbxBkWOWm1UCuDXc8h5pHRXgGW1+uRa6FG7mqteVKtc9StD
VA9A/YK8cY3fq+dSC/2M6sK9BuRUC31OdeMuyq/nVgu9IBr3hEE9x1roU2o5
7k/NyMOdoV3VHxOFu+6onqsUzaDOA2oxvxvFliC9S3Xj7sWsQXD3jvSUaNzH
mnUb9gfpbWp5weVe9d1iCFROdRbu9Ub77b3NSD2B64bKW+qIqWX2u4L5EmN3
ztgPn+qwavOVx+773Ryx8/e0dL8eWQ7vto2bL1D81yvR+wfGehW/\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->False,
    ViewPoint->{2.727892280477045, -1.2484405096414273`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmMluE0EQhtue3eMli41NYrKKKCEyCVIOkcJyg1MOnJGQrCRSckCgkDfj
VXgG3sKCXv7xjH93Z1rBsmfc7f+rqq7p8vT05fTh9ubb9OHuarrz6X764/bu
6ufOx+/3sitoCCE+y8+XkZDf/8pv+jOczWaB/DLGeSTPQvTR2sN5oHvX5LEp
W4c4r+veFbRiaPfRXtW/9tRRdc/0S6t0+8/Xa/kWhZeqpqvJDuykOEdSrs67
aBtVm9hUty8n18aFSEDtkC7XdAu2WsWvBhQtSanmFn436oxsaFoRlfHk8Ldl
iwvRLVoQofFrXPfgeUzKRPOJZRQBRbACCxu2zJf5r+YhmkeA8Q8wiuekjrSN
iHrVNQgpigGiGJI21BZCi4Ui/8oQZ3WEeJ4RF2hrAfWqmRORhU1Y6JO2qS00
LRYei2cLo1sjrqGtISzVqec/x7KLWFSFqLJU1DLZpRj4Ou8jhq7FymItxUQe
gGxXSFPHVX98RY8QdQ7KEAmpjmE7nat6ZJezMSn+BhZmuqJSLyXniUfrpjJS
vialqRieCzxiN9XyUvLc51G7qdxLmdfYP3FSbP+UlObfoEX2Oatuqu2lzMg+
Z9VNdbyUKdn3G7Wiul7KhOzzqN8QFf4n1fNSxhb76kbkr9b3rV+/Z+atGlxp
dnaeXwOKCPSrJ9GZPKjmIdGBlW4R3QH90kl3iFgBseck2kT0QWxbiagmwiHo
sRedEb0JekPSkZVIidgGMSR/TS96D3Tfi06IPgC96qQ5O0cguk6CMzIBkVuJ
sCbCU9CZpEMrERNxBiImfw0rHRF9Djp4En2Bygqs6pDUH9TB6oOz8J6UZe54
9Kyk9ZojkndEhVYqqKEiL+otUbGVatZQSUktraU5r6WWx81W07myLurMqbwg
pb5bmyu28NzB2csdOvbcLnXIl3CozGpQKYNHFdqfbLn9lWvWYr38mM/l1bV6
cV46S+oi0nOLcrlOqs8gepzyc1ZD0n9OpVc1T2pougNUZr1qHtuuk/vuWpmb
Kv0HNTStbCpzS98ba2hTY/ws3AH9ooY29cPP4j1EPqqhTU0Vz/3roNYts798
7mcbxe5Iz1YzSzVU7GMM4Su31G65n8H7JSNQsa3iK21DF3sxY1AiUJiZlIUf
sy9T7OXwPkUyq+7t2PeBROMfonm9cQ==\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->False,
    ViewPoint->{0.4233600241796016, -2.9699774898013365`, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzll9tOwkAQhpceaDlpNBox8UDUGGI0McqF4XwSr7zwERo0gQujQZ7Hl/BV
fB2iO9sBym9BDK2G2KQ73Znv322nZZa9dfqdh0en3207mZue89zptl8yraee
dOkRIcSdPJ20kNcf8kqdycFgoMmLHNuUtELEuXfFNqG8MWp12R2oQ+ShbyvK
8owYk1boyq0Ol4iC7lQ2NkVfz+6FOfKzzFLWBM0Ra9ZI4/FrwBlKbYB3l9Xb
oNaBc29d4yfaYtUBqAyO84OyoXaVc3ACCsoAvZAIWVaNoxbPk5uhcnNJsxaB
spjibFNEEgQVgLRH4ywvZQFV8snGslNRoMq/TlV8vsS/oEygqktN1YAyf0AZ
QNX/AdXwqbtiXLOZagZIUW2l+h31jV7IJk519u3dZ81BOsv0+lz0HtM7vrQG
9CbTx3PRCabP56I1zkF+Kk1LdmP2WDJKQAsoffLZmbpegDKAaoZOmUBhJoKn
okDVA6RwRvUGx+vUlLGCp2ygagtQMaCqoVNxoCqhU4lvqEjgVBKocuhUCqjS
AtQKUMUwKaEOjweft+BREDrcE7jGT0FzTO4ghrsUfHtU5ZOjwXAnhN/zIdO4
14P6xF78/aVlk5DdDeDc1QD3fVgJkqzeB879NzDcV3rnpFyRIuuNfbl3k6OX
fnc/Za8rIp9Xhf58\
\>"]], ",", 
   Graphics3DBox[CuboidBox[{0, 0, 0}],
    Boxed->False,
    Epilog->CircleBox[
      Scaled[{0.5, 0.5}], 0.5],
    ImageSize->80,
    RotationAction->"Fit",
    SphericalRegion->False,
    ViewPoint->{-2.2704074859237844`, -1.960930862590836, 3.},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9mMtu00AUQJ3YsRPnnTSPpilNeUg8hCpAgi5AIJXHqguWLKuC1C4QqPQf
+CB+hd+xwDNzJ56cTOpsIFLseHzPuXecZDzj07Priy9fz64vz88WH67Ovl9c
nv9YvP92lTeFlSAIPubvT9Mg//wn/6Tf+1mWxfmHVPa38n0QzPJtmB+NZb+n
WydyNJf9VLeO8m01PxrKvi37sT5rW3fUUZR/OH38OdCvjnsm6DtHal9VcSpJ
9lPHd6V9oKPtkcqto/JoBWgqMpQBexLZ01zHxmf6ZXI7fKg2tSUvufug2trV
RqvtaexUrgRVtXHibO3G0tzQE1pCWHrInmpbWtK/BNaoxNrQ1saGnqaw1Ups
dW2re2xujbTGJdZEWxO0DuxVhi0pscXaFntsbo201kusNW2tlVg7sDZKrJG2
Rmi1/6Q+bGmJLfTaeqiR1maJtaqtYYl1AGvL859Zt1bRuhwVYGuX2CraJhcg
8NVHY8djVAOsMq3b7Eg3haULS8djwajj1ERb7wbbqqkF0y5MfZjaKyY7vs9B
DTZQwVo+kkOQrSXZBLkPcsdDmvFKVbhA9AjR2l6MR5KD1BhUuhU1AWVG0gTU
IagpqPpW1C6oZCtqBir+h9RevtmuL3vwm5EzBnX7P1KqQjPr2Sb6IN+o3174
63d203fkp2/ZCnNaCSKPJVmSNlc9j1L74mwN3jm8Kbz8jUdey0zydUDzf+Wn
p0L3QfM/7Kcn6MEAFo4hfstIahh76HhJMNdErm8RFcE7FO8cXo7JoZfuC30A
mvcHP91DtQtYeK/yWzpSw13QvHf66TZquAcL7+eFxeZ9INdY5astz9L7CF7O
aTDbkOoakuMINOdXfjoR+ilozvn8dIwePIOF81G/JZIaXoDm3LigmffYQ0bL
aOt/Kd9CcbaKStTZN3BxbVJZI9W9/AQU10UFpXK8U9FrK7Fw9epI397qobIw
G4uZQUS+2JUqbOTa79OhTuS6VLJNc6pI6i78OsIzt4zhfi1uN2adSsT/SqLD
jHNFzoYT5DkWkjP8yuo1dWgV/Vworl2qq+OAtNaR84nQXJ35aTtvOxKKK0Vz
OVhJipwPheaq1fyeubJLJed9obiCNmMR628i5x2hm4gzdwv2w675D4Vq4by5
h7P+FnLOlyOm5ztY60dLcs6E4pMQMz+1lXWQayQUV05mLswK2qD7Dl08+WAF
dl3RlWiuJA1lHV3kSB2qeN7Td/rjzpRslHmaNMz8vQ4RbZ5UjZxemP+tijUv
G2mefdnnZfx+25n7/Mz/rC2o/AWvokTe\
\>"]]}], "}"}]], "Output",
 ImageSize->{463, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174561660]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12845],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16342],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with SphericalRegion",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
SphericalRegion"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->58921629],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->497934178],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->21047472],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->6284125],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->773764830],

Cell[TextData[ButtonBox["Interactive 3D Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Interactive3DControl"]], "MoreAbout",
 CellID->42410705],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->410615900]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SphericalRegion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 30.3431584}", "context" -> "System`", 
    "keywords" -> {
     "centering in 3D", "centering of three-dimensional object", 
      "circumscribing sphere", "orientation of 3D object", 
      "rotation of 3D coordinates"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SphericalRegion is an option for three-dimensional graphics functions \
which specifies whether the final image should be scaled so that a sphere \
drawn around the three-dimensional bounding box would fit in the display area \
specified. ", "synonyms" -> {"spherical region"}, "title" -> 
    "SphericalRegion", "type" -> "Symbol", "uri" -> "ref/SphericalRegion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6084, 181, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49335549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55079, 1383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3012, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3635, 95, 53, 1, 70, "ObjectName",
 CellID->19733],
Cell[3691, 98, 636, 16, 70, "Usage",
 CellID->19562]
}, Open  ]],
Cell[CellGroupData[{
Cell[4364, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4842, 136, 307, 9, 70, "Notes",
 CellID->28032],
Cell[5152, 147, 360, 10, 70, "Notes",
 CellID->7279],
Cell[5515, 159, 209, 5, 70, "Notes",
 CellID->19134],
Cell[5727, 166, 320, 10, 70, "Notes",
 CellID->31081]
}, Closed]],
Cell[CellGroupData[{
Cell[6084, 181, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49335549],
Cell[CellGroupData[{
Cell[6468, 195, 148, 5, 70, "ExampleSection",
 CellID->571177489],
Cell[6619, 202, 110, 3, 70, "ExampleText",
 CellID->5251],
Cell[CellGroupData[{
Cell[6754, 209, 299, 9, 28, "Input",
 CellID->1708],
Cell[7056, 220, 2492, 47, 213, "Output",
 CellID->126112737]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9597, 273, 216, 7, 70, "ExampleSection",
 CellID->30474],
Cell[9816, 282, 121, 3, 70, "ExampleText",
 CellID->3741],
Cell[CellGroupData[{
Cell[9962, 289, 656, 20, 70, "Input",
 CellID->28395],
Cell[10621, 311, 5539, 110, 103, "Output",
 CellID->20527]
}, Open  ]],
Cell[16175, 424, 239, 8, 70, "ExampleText",
 CellID->5964],
Cell[CellGroupData[{
Cell[16439, 436, 597, 19, 70, "Input",
 CellID->27887],
Cell[17039, 457, 6011, 116, 120, "Output",
 CellID->26630]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23099, 579, 233, 7, 70, "ExampleSection",
 CellID->19438],
Cell[23335, 588, 115, 3, 70, "ExampleText",
 CellID->1307],
Cell[CellGroupData[{
Cell[23475, 595, 267, 8, 70, "Input",
 CellID->15767],
Cell[23745, 605, 2886, 53, 216, 118, 3, "CachedBoxData", "BoxData", "Output",
 CellID->52252675]
}, Open  ]],
Cell[26646, 661, 244, 8, 70, "ExampleText",
 CellID->27925],
Cell[CellGroupData[{
Cell[26915, 673, 316, 9, 70, "Input",
 CellID->45],
Cell[27234, 684, 2509, 47, 201, 143, 4, "CachedBoxData", "BoxData", "Output",
 CellID->410589546]
}, Open  ]],
Cell[29758, 734, 121, 3, 70, "ExampleDelimiter",
 CellID->32250],
Cell[29882, 739, 112, 3, 70, "ExampleText",
 CellID->3274],
Cell[CellGroupData[{
Cell[30019, 746, 522, 16, 70, "Input",
 CellID->734],
Cell[30544, 764, 2995, 59, 201, 308, 11, "CachedBoxData", "BoxData", "Output",
 
 CellID->774219068]
}, Open  ]],
Cell[CellGroupData[{
Cell[33576, 828, 939, 28, 70, "Input",
 CellID->1945],
Cell[34518, 858, 7066, 147, 103, "Output",
 CellID->899417305]
}, Open  ]],
Cell[41599, 1008, 125, 3, 70, "ExampleDelimiter",
 CellID->157081893],
Cell[41727, 1013, 205, 8, 70, "ExampleText",
 CellID->615683380],
Cell[CellGroupData[{
Cell[41957, 1025, 945, 28, 70, "Input",
 CellID->858209360],
Cell[42905, 1055, 6648, 140, 120, "Output",
 CellID->174561660]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49614, 1202, 311, 9, 70, "SeeAlsoSection",
 CellID->12845],
Cell[49928, 1213, 1213, 44, 70, "SeeAlso",
 CellID->2953]
}, Open  ]],
Cell[CellGroupData[{
Cell[51178, 1262, 314, 9, 70, "TutorialsSection",
 CellID->16342],
Cell[51495, 1273, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[51694, 1281, 305, 8, 70, "RelatedLinksSection"],
Cell[52002, 1291, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52411, 1308, 318, 9, 70, "MoreAboutSection",
 CellID->58921629],
Cell[52732, 1319, 148, 3, 70, "MoreAbout",
 CellID->497934178],
Cell[52883, 1324, 150, 3, 70, "MoreAbout",
 CellID->21047472],
Cell[53036, 1329, 161, 3, 70, "MoreAbout",
 CellID->6284125],
Cell[53200, 1334, 153, 3, 70, "MoreAbout",
 CellID->773764830],
Cell[53356, 1339, 153, 3, 70, "MoreAbout",
 CellID->42410705],
Cell[53512, 1344, 161, 3, 70, "MoreAbout",
 CellID->410615900]
}, Open  ]],
Cell[53688, 1350, 27, 0, 70, "History"],
Cell[53718, 1352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

