(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24219,        802]
NotebookOptionsPosition[     19948,        657]
NotebookOutlinePosition[     21239,        694]
CellTagsIndexPosition[     21154,        689]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpheroidalFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Spheroidal Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalS1" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalS1"], 
          "SphericalBesselJ" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselJ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpheroidalS1\"\>", 
       2->"\<\"SphericalBesselJ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/SpheroidalAndRelatedFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Spheroidal and Related Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpheroidalRadialFactor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SpheroidalRadialFactor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpheroidalRadialFactor"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the spheroidal radial factor with degree ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and order ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalRadialFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalRadialFactor"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalRadialFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalRadialFactor"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147782363],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->216182753],

Cell["Evaluate numerically:", "ExampleText",
 CellID->196752360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalRadialFactor", "[", 
  RowBox[{"3", ",", "2", ",", "10."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74099548],

Cell[BoxData["0.00059367807461740452610979932429160343`21.00732451123215"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112954402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103230330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SpheroidalRadialFactor", "[", 
    RowBox[{"3", ",", "2", ",", "c"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614377517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mH1o1WUUx3/bvXdTa/ZilnnntmypmW4aklbGKFOzEq2wFyxorWD7wxY2
/6ko7cVVai8qpBRJ9EYvfxiJERhEQiREQiREBWEQ9kcSJP0xCH59znl+v/2e
33PP7nY3aNzd+5zfc873vJ/nuXdt90DvQ5u6B/p6uttWb+5+pLev59G2Vf2b
eVSoi6LoEP+bZkSsY1b6fyiO+fTfO3gvsNXMZzH5FLpVdmUR619UTp4XVaoz
2G326MiQbg7oloCuU7lzR5GaNQrKzMSHUHuGXs/D0VDKBp/41DYum0P0cL85
0daSfEaFL478UpMGsTcqZrSdu1SHPu/rPXjmzFBUMPF97jQOI1VEVAQHtEj/
MjyRe135twwcPvbNb8pqatuv9P59x95957gsSybXPqUBAk6WDSbXa0qfPv1P
zwMf8x41VuHK7HJcTby/r16E/FMCulDjfnGC8uH+/21PvdInT/7Fo6Ghf12G
Ru2DsMu2KN3/8KfHv/tdlpNNqb1Kf3b4x8HtXw7bMlxRe9P83rfxA6nfs0yM
PUpv23rENdIIXLvjfEWdbXK9qjReU1ESgaacPQ7jow+/37P7a1k2mRivBFZP
rcK1a+fRTw6ekKXN9bLSP//0J/bI8pwqXI8/9vnRr37Nc4nVIYZKp82b9bFf
ASzDrL8U6EhQcnNIK63yiYeyS2kgAJLleRNAwR2cqg1FQHYGNpw/gnTBiMLO
QLMlG8qE1u9QmragOWQ5rSIfjUnmbMksB9Nyed4R5PkCs1ZeDDBsrhcCrOlV
uLIanp6zx+3SB3dteE/myIUmxvNK01C0lSxtrsE46UuwZNJfVIUr689qXACd
OvV3nkusHgyqY0ZFdsbSLduV5qA88cMfHkqNdf5ckIWLJ4CSzUcLpZR4L58i
+myQu5nj0iwo9Qfe/LY8LulngpyXKzLR4FldKYm7OC3Lci7Dzresh7NdH+Pp
IPbNVbg4vDjCRubaFkRzVs4eh8F1iEuRLGdVwbht3dvAjMy1Nc5Xb0sVruxs
trmeCiLQmrPaYWR92+olMf2rDxCtXD2pNOckrkls9NZdIVkYtVocTtb7NeGU
WBAL95Jz/wll5gCHqBWtoEOC6CLedd3+qKBvEDziFUlHRAVGJrqkrvsVKruZ
XDLOCOgdWe5tzg2nZzLTGaUEd+WKN1hQqjxmW24mfSqRnQXj1ax3lylkD1wa
AQVoumXNAbQCTk6Ygg/GSQ/wUJaz47F2s55Qk5DESpLLUHWuoAbc+5U7+z4x
O1elOusmOcvgRxb1xIDZwMONcX7CXGr2gfZ0I/u4xkBBOU6xlmq9O85PGhtB
q6eE+WgmLPCS7ejOOD+HbFn1pwFdKKFAsBRHMeZ25ctuEe05v+eoRg44AoPH
icb1Qb7bTY3zVHZYHekTT29VLhB5JMvLTNn5qV4SlcneHOdnhS27QGVxLSe7
Os0RgRN6jinbYcqujPMzIZOVGC3Wuh6WIaMrgnqY65W7NdO00Y1+uDJFJt/k
lyRdH1gy1+y0YoAd4i5RJsqFnJNFwtylHNmpYOOGHRXeYK5SXIqCIUXBEIDl
ypGdI/NM3IaAln0hlyoeMJQqoaT0rg1qfex4Pn11GlcqkxeLZYGdl5u4o08w
Zx+GEgEKwXng2etwxzKtNHLyKwm5dzZq1rwZMT9XhV2eZnhc7Xg1eMUwt6+l
K9UCJopYLAoqzJZzdYiHaGN4ur7xtC0wpW5I4878dPWhfF5H23I3Kk0RICen
qnru3YMW5iKxSnfdfQNYF3NvWi00daxKaw1jiDeR0C73JmOHKXeTF3c5LdvT
SCTf/DtNqTWpB+78cTPbi0NnziM3M925I5htgWWLTB1OiuwgJbXYkupMfuVa
7JVwbiqVhjGSrbA211bUZjn1GlKioNVX8/xY58VSLNZvC96t2EYVlKJ3Z1qf
t47pJt/M5BazZER5f1qGVuoJWXRWUYM4qTcJuSuAKUsbtxjbnX1HWmkAuGbV
3x0KrgvR4ObomPE26CZuIk1qwZua1geZl1mwNA6nTqMRA8HWe0iJ3gGL5sI/
cN1vbkV3s6TkKMFlZsXdI28NSCCHNMaQAhwSU6ISN1UukZwx7ifU6BoT4944
6V5yToD0Apz+NiBVu9yUeqvK06juP7i893w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551358870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->94393633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalRadialFactor", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"2", "/", "3"}], ",", 
   RowBox[{
    RowBox[{"-", "0.35"}], "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74231086],

Cell[BoxData[
 RowBox[{"1.0213412274331560269831154970278621649`24.453650037871817", "+", 
  RowBox[{
  "0.01574834311814187945677163263134081497`22.683824929371756", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4423986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472739114],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->928164396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SpheroidalRadialFactor", "[", 
    RowBox[{"1", ",", "0", ",", "5"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403439115],

Cell[BoxData["0.\
2318358916822950197289667801488936890290082725962259593992028212245`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273891633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Build a near-spherical approximation to ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{
     SubsuperscriptBox["S", 
      RowBox[{
       TagBox["n",
        SpheroidalS1,
        Editable->True,
        Selectable->True], ",", 
       TagBox["m",
        SpheroidalS1,
        Editable->True,
        Selectable->True]}], 
      RowBox[{"(", "1", ")"}]], "(", 
     RowBox[{
      TagBox["c",
       SpheroidalS1,
       Editable->True,
       Selectable->True], ",", 
      TagBox[
       FractionBox["z", "c"],
       SpheroidalS1,
       Editable->True,
       Selectable->True]}], ")"}],
    InterpretTemplate[SpheroidalS1[
      SlotSequence[1]]& ],
    Editable->False,
    Selectable->False], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->286150991],

Cell[BoxData[
 RowBox[{
  RowBox[{"nsLimitS1", "[", 
   RowBox[{"n_", ",", "m_", ",", "z_", ",", 
    RowBox[{"{", 
     RowBox[{"c_", ",", "ord_Integer"}], "}"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{"SpheroidalPS", "[", 
          RowBox[{"n1", ",", 
           RowBox[{"-", "m1"}], ",", "c", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "0", ",", "ord"}], "}"}]}], "]"}], "/.", 
       RowBox[{
        RowBox[{"LegendreP", "[", 
         RowBox[{"k_", ",", 
          RowBox[{"-", "m1"}], ",", "2", ",", "x"}], "]"}], "\[RuleDelayed]", 
        
        RowBox[{"SphericalBesselJ", "[", 
         RowBox[{"k", ",", "z"}], "]"}]}]}], "]"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "/", 
          RowBox[{"z", "^", "2"}]}]}], ")"}], 
       RowBox[{"m", "/", "2"}]], "/", 
      RowBox[{"SpheroidalRadialFactor", "[", 
       RowBox[{"n", ",", 
        RowBox[{"-", "m"}], ",", "c"}], "]"}]}]}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n1", "\[Rule]", "n"}], ",", 
     RowBox[{"m1", "\[Rule]", "m"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404895175],

Cell["First few terms of the approximation:", "ExampleText",
 CellID->57232580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nsLimitS1", "[", 
   RowBox[{"n", ",", "m", ",", "z", ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "3"}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111144286],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        SuperscriptBox["c", "2"], 
        SuperscriptBox["z", "2"]]}], ")"}], 
     RowBox[{"m", "/", "2"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "n", "+", "1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", "n", "+", "2"}], ")"}], " ", 
           RowBox[{
            SubscriptBox["j", 
             RowBox[{"n", "+", "2"}]], "(", "z", ")"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n"}], "+", "1"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "n"}], "+", "3"}], ")"}], "2"]}]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "m"}], "+", "n", "-", "1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"n", "-", "m"}], ")"}], " ", 
           RowBox[{
            SubscriptBox["j", 
             RowBox[{"n", "-", "2"}]], "(", "z", ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}], ")"}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["j", "n"], "(", "z", ")"}]}], ")"}]}], 
   RowBox[{"SpheroidalRadialFactor", "(", 
    RowBox[{"n", ",", 
     RowBox[{"-", "m"}], ",", "c"}], ")"}]], TraditionalForm]], "Output",
 ImageSize->{364, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->335708470]
}, Open  ]],

Cell["Compare numerically:", "ExampleText",
 CellID->577236429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"nsLimitS1", "[", 
       RowBox[{"3", ",", "1", ",", "1`30", ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "k"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "2", ",", "10", ",", "2"}], "}"}]}], "]"}], "-", 
    RowBox[{"SpheroidalS1", "[", 
     RowBox[{"3", ",", "1", ",", "c", ",", 
      RowBox[{"1", "/", "c"}]}], "]"}]}], ")"}], "/.", 
  RowBox[{"{", 
   RowBox[{"c", "\[Rule]", 
    RowBox[{"1", "/", "100"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->136602514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.71842850533997164466418731564607539056441`24.212633723879254*^-7", ",", 
   RowBox[{
   "-", "4.30266962150866038339839385636246585`18.61123643183938*^-13"}], ",",
    "3.31037816135772564844751008062`12.497376039845689*^-19", ",", 
   "3.887082972217352208755736`7.567122242583016*^-24", ",", 
   RowBox[{"-", "2.4248752627708794207`2.362187834675437*^-29"}]}], 
  "}"}]], "Output",
 ImageSize->{422, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->157721428]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpheroidalFunctions"]], "Tutorials",
 CellID->12303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Spheroidal and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], "MoreAbout",
 CellID->450712018],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->26798221]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpheroidalRadialFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 34.3276354}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpheroidalRadialFactor[n, m, c] gives the spheroidal radial factor with \
degree n and order m.", "synonyms" -> {"spheroidal radial factor"}, "title" -> 
    "SpheroidalRadialFactor", "type" -> "Symbol", "uri" -> 
    "ref/SpheroidalRadialFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6278, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->147782363]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21011, 682}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2127, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2750, 80, 1587, 37, 70, "ObjectNameGrid"],
Cell[4340, 119, 785, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5162, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5640, 165, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5763, 171, 246, 7, 70, "Notes",
 CellID->31226],
Cell[6012, 180, 229, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6278, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147782363],
Cell[CellGroupData[{
Cell[6663, 206, 148, 5, 70, "ExampleSection",
 CellID->216182753],
Cell[6814, 213, 64, 1, 70, "ExampleText",
 CellID->196752360],
Cell[CellGroupData[{
Cell[6903, 218, 152, 4, 28, "Input",
 CellID->74099548],
Cell[7058, 224, 218, 6, 36, "Output",
 CellID->112954402]
}, Open  ]],
Cell[7291, 233, 125, 3, 70, "ExampleDelimiter",
 CellID->103230330],
Cell[CellGroupData[{
Cell[7441, 240, 267, 8, 28, "Input",
 CellID->614377517],
Cell[7711, 250, 2384, 43, 130, "Output",
 Evaluatable->False,
 CellID->551358870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10144, 299, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[10368, 308, 88, 1, 70, "ExampleText",
 CellID->94393633],
Cell[CellGroupData[{
Cell[10481, 313, 245, 8, 70, "Input",
 CellID->74231086],
Cell[10729, 323, 336, 9, 36, "Output",
 CellID->4423986]
}, Open  ]],
Cell[11080, 335, 125, 3, 70, "ExampleDelimiter",
 CellID->472739114],
Cell[11208, 340, 70, 1, 70, "ExampleText",
 CellID->928164396],
Cell[CellGroupData[{
Cell[11303, 345, 206, 6, 70, "Input",
 CellID->403439115],
Cell[11512, 353, 235, 7, 36, "Output",
 CellID->273891633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11796, 366, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12026, 375, 802, 33, 70, "ExampleText",
 CellID->286150991],
Cell[12831, 410, 1372, 42, 70, "Input",
 CellID->404895175],
Cell[14206, 454, 79, 1, 70, "ExampleText",
 CellID->57232580],
Cell[CellGroupData[{
Cell[14310, 459, 241, 8, 70, "Input",
 CellID->111144286],
Cell[14554, 469, 1982, 61, 87, "Output",
 CellID->335708470]
}, Open  ]],
Cell[16551, 533, 63, 1, 70, "ExampleText",
 CellID->577236429],
Cell[CellGroupData[{
Cell[16639, 538, 620, 19, 70, "Input",
 CellID->136602514],
Cell[17262, 559, 559, 14, 58, "Output",
 CellID->157721428]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17882, 580, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18201, 591, 479, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18717, 613, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19038, 624, 150, 3, 70, "Tutorials",
 CellID->12303]
}, Open  ]],
Cell[CellGroupData[{
Cell[19225, 632, 299, 8, 70, "MoreAboutSection"],
Cell[19527, 642, 173, 3, 70, "MoreAbout",
 CellID->450712018],
Cell[19703, 647, 173, 3, 70, "MoreAbout",
 CellID->26798221]
}, Open  ]],
Cell[19891, 653, 27, 0, 70, "History"],
Cell[19921, 655, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

