(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27318,        950]
NotebookOptionsPosition[     21910,        765]
NotebookOutlinePosition[     23317,        803]
CellTagsIndexPosition[     23232,        798]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpheroidalFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Spheroidal Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalS1" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalS1"], 
          "SpheroidalS2Prime" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalS2Prime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpheroidalS1\"\>", 
       2->"\<\"SpheroidalS2Prime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/SpheroidalAndRelatedFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Spheroidal and Related Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpheroidalS1Prime", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SpheroidalS1Prime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpheroidalS1Prime"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["\[Gamma]", "TR"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the derivative with respect to ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " of the radial spheroidal function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "1", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the first kind."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12910]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SpheroidalS1Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS1Prime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->136428252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalS1Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS1Prime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalS1Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS1Prime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41509285],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->121335297],

Cell["Evaluate numerically:", "ExampleText",
 CellID->45503221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS1Prime", "[", 
  RowBox[{"1", ",", "0", ",", "2", ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416581269],

Cell[BoxData[
 RowBox[{"-", 
  "0.38299219592183266607315611515`15.954589770191003"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73138286]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22341],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->94393633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS1Prime", "[", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"1", "-", "I"}], ",", " ", "3.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314925903],

Cell[BoxData[
 RowBox[{"1.36351253800602201238234556513`16.04579747946951", "-", 
  RowBox[{
  "0.76412455365159070996838863721`15.794302498787143", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5104114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217504807],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->283569038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SpheroidalS1Prime", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"1", "/", "3"}], ",", "5"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->852018633],

Cell[BoxData["0.\
0484068802244975135633555466007398113435437055670894101525294116524`50."], \
"Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567612831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3535261],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->173158339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS1Prime", "[", 
  RowBox[{"2", ",", "1", ",", 
   RowBox[{"1", "/", "3"}], ",", "5.000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429954945],

Cell[BoxData["0.048406880224497513563355546600739811343682124515`27.\
69897000433602"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259807488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165479942],

Cell[TextData[{
 "For certain parameters ",
 Cell[BoxData[
  ButtonBox["SpheroidalS1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFormula"],
 " evaluates exactly:"
}], "ExampleText",
 CellID->160938561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "3"}], "}"}], ",", 
   RowBox[{"SpheroidalS1Prime", "[", 
    RowBox[{"n", ",", "1", ",", 
     RowBox[{"n", " ", 
      RowBox[{"Pi", "/", "2"}]}], ",", " ", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10306910],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["3", "2"], " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "]"}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}]], " ", "x"}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["3", "2"], " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "]"}]}], 
   RowBox[{"3", " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["x", "2"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox["x", "4"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["3", "2"], " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "]"}]}], 
   RowBox[{"3", " ", "\[Pi]", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}]], " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{384, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120715219]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->728648831],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " typesetting:"
}], "ExampleText",
 CellID->558624730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SpheroidalS1Prime", "[", 
   RowBox[{"n", ",", "m", ",", "c", ",", "\[Eta]"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261657998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VM0OwiAM7uh+NPFgzA7Gi0t8Ax9CTz7EYkz0YDTq+09axoCC2U6SUNaO
fl9/gFP7uV7u7ed2bpvjq31eb+d3c3i8tAkzANjrWa9Bf3f6i+e+6/Rq5IIk
kpUH7NhakiyMFXjYbYDGRFLpdev2o9ufh/69dS64UOgVidzplqyahF4JtELo
fk4DASiz5n6uxIo9DzmUYVx6qN6T1iKKmvyo9Bmrdi+Usp6GSQ0pWWsZIapJ
uWDAawLzQKCOcBfJijuMXPCu0gjJqjoU2ecxnTtZCczOnaGhokEkfbVHsJOn
wtNtV2e2Mzi0TNQmjiDi/tU5T69jTD8aeeOS1R6r58rjcB2Jzx1OQpdnYil0
wzCbhCXz3fzJd8t2fo+Cmy8xG/5jXkrIvqi1oBI=\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{50, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->444121785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24127],

Cell["\<\
Find resonant frequencies for Neumann problem in prolate spheroidal cavity:\
\>", "ExampleText",
 CellID->24395564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SpheroidalS1Prime", "[", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"k", "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}], " ", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146527133],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1.05263157894737*^-6, -1.33171705476199*^-13}, {
     0.506213367828942, -0.0300150927243199}, {
     1.0124256830263, -0.111003885258043}, {
     1.56121784003288, -0.227429649060833}, {
     2.11000999703945, -0.331700613845702}, {
     2.62243462743417, -0.381343129691862}, {
     3.1348592578289, -0.361857395172961}, {
     3.63723215108546, -0.271375893618795}, {
     4.13960504434203, -0.124614850122507}, {4.6845577794078, 
     0.0635797364233468}, {5.22951051447357, 0.234909848660831}, {
     5.7380957229275, 0.339174109905306}, {6.24668093138143, 
     0.363948801219537}, {6.79784598164457, 0.294121610699481}, {
     7.3490110319077, 0.142631518635366}, {
     7.89012434503268, -0.0450395738361446}, {
     8.43123765815765, -0.220450303460741}, {
     8.93598344467078, -0.330947828607517}, {
     9.44072923118391, -0.363050497440609}, {
     9.98805485950625, -0.30082304171746}, {
     10.5353804878286, -0.154916559105093}, {11.0463385895391, 
     0.0212537454992248}, {11.5572966912496, 0.192238116944866}, {
     12.0582030558219, 0.314576384010426}, {12.5591094203942, 
     0.363093803414524}, {13.1025956267758, 0.319433845807737}, {
     13.6460818331573, 0.18774046767299}, {14.153200512927, 
     0.0171847861116485}, {14.6603191926967, -0.15752566793796}, {
     15.2100177142756, -0.30290416640211}, {
     15.7597162358545, -0.362818681332829}, {
     16.2993630202953, -0.321988717425745}, {
     16.839009804736, -0.193452554739793}, {
     17.3422890625649, -0.0251060423485071}, {17.8455683203938, 
     0.149227545431913}, {18.3914274200319, 0.297063884454096}, {
     18.93728651967, 0.362103525435029}, {19.4467780926963, 
     0.331668760778089}, {19.9562696657225, 0.220403815743499}, {
     19.9781343065455, 0.214172868457868}, {19.9999989473684, 
     0.207843743795342}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  Method->{},
  PlotRange->{{0, 20}, {-0.381343129691862, 0.363948801219537}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{184, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44640186]
}, Open  ]],

Cell["Determine first few frequencies:", "ExampleText",
 CellID->585505651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"SpheroidalS1Prime", "[", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"k", "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}], " ", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79022032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "k", "\[Rule]", 
   "4.5021679233695749693271033467543397765370498515698667982237217702562`50.\
"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176681103]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"SpheroidalS1Prime", "[", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"k", "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}], " ", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117813954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "k", "\[Rule]", 
   "7.7626415228352641017635554684102428715539601592549249270351070012848`50.\
"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->480190376]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18020],

Cell[TextData[{
 "Spheroidal functions do not evaluate for half-integer values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and generic values of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->348355882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS1Prime", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "1", ",", "1", ",", "0.5"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->175415402],

Cell[BoxData[
 RowBox[{"SpheroidalS1Prime", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", "1", ",", "1", ",", "0.5`"}], "]"}]], "Output",\

 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{217, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174460104]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->126],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalS2Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS2Prime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19083],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpheroidalFunctions"]], "Tutorials",
 CellID->12303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->370093280],

Cell[TextData[ButtonBox["Spheroidal and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], "MoreAbout",
 CellID->312647264],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->3271432]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpheroidalS1Prime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 35.3745372}", "context" -> "System`", 
    "keywords" -> {"radial spheroidal functions", "spheroidal functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SpheroidalS1Prime[n, m, \\[Gamma], z] gives the derivative with respect \
to z of the radial spheroidal function SubsuperscriptBox[S, n, m, \
(1)](\\[Gamma], z) of the first kind.", "synonyms" -> {"spheroidal s1 prime"},
     "title" -> "SpheroidalS1Prime", "type" -> "Symbol", "uri" -> 
    "ref/SpheroidalS1Prime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6759, 209, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41509285]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23090, 791}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2130, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2753, 80, 1582, 37, 70, "ObjectNameGrid"],
Cell[4338, 119, 1019, 31, 70, "Usage",
 CellID->12910]
}, Open  ]],
Cell[CellGroupData[{
Cell[5394, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5872, 172, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5995, 178, 266, 8, 70, "Notes",
 CellID->136428252],
Cell[6264, 188, 236, 7, 70, "Notes",
 CellID->31226],
Cell[6503, 197, 219, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6759, 209, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41509285],
Cell[CellGroupData[{
Cell[7143, 223, 148, 5, 70, "ExampleSection",
 CellID->121335297],
Cell[7294, 230, 63, 1, 70, "ExampleText",
 CellID->45503221],
Cell[CellGroupData[{
Cell[7382, 235, 158, 4, 28, "Input",
 CellID->416581269],
Cell[7543, 241, 227, 7, 36, "Output",
 CellID->73138286]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7819, 254, 216, 7, 70, "ExampleSection",
 CellID->22341],
Cell[8038, 263, 88, 1, 70, "ExampleText",
 CellID->94393633],
Cell[CellGroupData[{
Cell[8151, 268, 187, 5, 70, "Input",
 CellID->314925903],
Cell[8341, 275, 366, 11, 36, "Output",
 CellID->5104114]
}, Open  ]],
Cell[8722, 289, 125, 3, 70, "ExampleDelimiter",
 CellID->217504807],
Cell[8850, 294, 70, 1, 70, "ExampleText",
 CellID->283569038],
Cell[CellGroupData[{
Cell[8945, 299, 239, 8, 70, "Input",
 CellID->852018633],
Cell[9187, 309, 283, 9, 36, "Output",
 CellID->567612831]
}, Open  ]],
Cell[9485, 321, 123, 3, 70, "ExampleDelimiter",
 CellID->3535261],
Cell[9611, 326, 113, 3, 70, "ExampleText",
 CellID->173158339],
Cell[CellGroupData[{
Cell[9749, 333, 211, 6, 70, "Input",
 CellID->429954945],
Cell[9963, 341, 276, 8, 36, "Output",
 CellID->259807488]
}, Open  ]],
Cell[10254, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->165479942],
Cell[10382, 357, 232, 8, 70, "ExampleText",
 CellID->160938561],
Cell[CellGroupData[{
Cell[10639, 369, 320, 10, 70, "Input",
 CellID->10306910],
Cell[10962, 381, 1393, 50, 85, "Output",
 CellID->120715219]
}, Open  ]],
Cell[12370, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->728648831],
Cell[12498, 439, 204, 7, 70, "ExampleText",
 CellID->558624730],
Cell[CellGroupData[{
Cell[12727, 450, 203, 6, 70, "Input",
 CellID->261657998],
Cell[12933, 458, 682, 16, 70, "Output",
 Evaluatable->False,
 CellID->444121785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13664, 480, 223, 7, 70, "ExampleSection",
 CellID->24127],
Cell[13890, 489, 125, 3, 70, "ExampleText",
 CellID->24395564],
Cell[CellGroupData[{
Cell[14040, 496, 520, 15, 70, "Input",
 CellID->146527133],
Cell[14563, 513, 2329, 51, 120, "Output",
 CellID->44640186]
}, Open  ]],
Cell[16907, 567, 75, 1, 70, "ExampleText",
 CellID->585505651],
Cell[CellGroupData[{
Cell[17007, 572, 477, 14, 70, "Input",
 CellID->79022032],
Cell[17487, 588, 339, 12, 36, "Output",
 CellID->176681103]
}, Open  ]],
Cell[CellGroupData[{
Cell[17863, 605, 478, 14, 70, "Input",
 CellID->117813954],
Cell[18344, 621, 339, 12, 36, "Output",
 CellID->480190376]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18732, 639, 226, 7, 70, "ExampleSection",
 CellID->18020],
Cell[18961, 648, 284, 9, 70, "ExampleText",
 CellID->348355882],
Cell[CellGroupData[{
Cell[19270, 661, 184, 6, 70, "Input",
 CellID->175415402],
Cell[19457, 669, 320, 11, 51, "Output",
 CellID->174460104]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19838, 687, 309, 9, 70, "SeeAlsoSection",
 CellID->126],
Cell[20150, 698, 477, 17, 70, "SeeAlso",
 CellID->17220]
}, Open  ]],
Cell[CellGroupData[{
Cell[20664, 720, 314, 9, 70, "TutorialsSection",
 CellID->19083],
Cell[20981, 731, 150, 3, 70, "Tutorials",
 CellID->12303]
}, Open  ]],
Cell[CellGroupData[{
Cell[21168, 739, 319, 9, 70, "MoreAboutSection",
 CellID->370093280],
Cell[21490, 750, 173, 3, 70, "MoreAbout",
 CellID->312647264],
Cell[21666, 755, 172, 3, 70, "MoreAbout",
 CellID->3271432]
}, Open  ]],
Cell[21853, 761, 27, 0, 70, "History"],
Cell[21883, 763, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

