(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18188,        636]
NotebookOptionsPosition[     13961,        497]
NotebookOutlinePosition[     15525,        539]
CellTagsIndexPosition[     15440,        534]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Splicing Mathematica Output into External Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Splicing Mathematica Output into External Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"RunThrough\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"C/C++ Language Interface\"\>", 
       2->"\<\"File Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Mathematica Expressions in Files\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Splice", "ObjectName",
 CellID->18597],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Splice",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Splice"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]splices ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output into an external file. It takes text enclosed between ",
     Cell[BoxData[
      RowBox[{"<", "*"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"*", ">"}]], "InlineFormula"],
     " in the file, evaluates the text as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input, and replaces the text with the resulting ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"infile\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"outfile\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " processes text from the file ",
 Cell[BoxData[
  StyleBox["infile", "TI"]], "InlineFormula"],
 ", and writes output into ",
 Cell[BoxData[
  StyleBox["outfile", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " takes files with names of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", 
   StyleBox[
    RowBox[{"m", 
     StyleBox["x", "TI"]}]]}]], "InlineFormula"],
 " and writes output in files with names ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12912],

Cell[TextData[{
 "Text in the input file not enclosed between ",
 Cell[BoxData[
  RowBox[{"<", "*"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"*", ">"}]], "InlineFormula"],
 " is copied without change to the output file. "
}], "Notes",
 CellID->6736],

Cell[TextData[{
 "The default format for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output is determined by the extension of the input file name: "
}], "Notes",
 CellID->3676],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["name", "TI"], ".", "mc"}], Cell[TextData[Cell[BoxData[
     ButtonBox["CForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CForm"]], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["name", "TI"], ".", "mf"}], Cell[TextData[Cell[BoxData[
     ButtonBox["FortranForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"]], 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["name", "TI"], ".", "mtex"}], Cell[TextData[Cell[BoxData[
     ButtonBox["TeXForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"]], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->19684],

Cell[TextData[{
 "The following options for ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " can be used: "
}], "Notes",
 CellID->10294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Delimiters", 
    RowBox[{"{", 
     RowBox[{"\"\<<*\>\"", ",", "\"\<*>\>\""}], "}"}], Cell[
    "delimiters to search for ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "default format for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "78", Cell[
    "number of character widths per output line ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->23733],

Cell[TextData[{
 "You can use pipes instead of files for input and output to ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2633]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9569614],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16211891],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["mf", "TI"]}]], "InlineFormula"],
 " file with an expression:"
}], "ExampleText",
 CellID->309689976],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test.mf\>\""}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->973132726],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"file", ",", 
   RowBox[{"OutputForm", "[", "\"\<y = <* D[x^x,x] *>\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1606549951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "file", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1017606108],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test.mf\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81217621]
}, Open  ]],

Cell["Read the file:", "ExampleText",
 CellID->206270330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->746830052],

Cell["y = <* D[x^x,x] *>", "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->517089399]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output into the file:"
}], "ExampleText",
 CellID->341290617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Splice", "[", "file", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->142578782],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test.mf\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->348304571]
}, Open  ]],

Cell["Read the output file:", "ExampleText",
 CellID->1945121670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test.f\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->314911980],

Cell["y = x**x*(1 + Log(x))", "Print",
 CellLabel->"During evaluation of In[25]:=",
 CellID->61927096]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23061],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RunThrough",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunThrough"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1287],

Cell[TextData[{
 ButtonBox["Splicing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Output into External Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"]
}], "Tutorials",
 CellID->7244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->163082795],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout",
 CellID->95545367],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->745238],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->156839420],

Cell[TextData[ButtonBox["Mathematica Expressions in Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]], "MoreAbout",
 CellID->177710067]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Splice - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 36.7495724}", "context" -> "System`", 
    "keywords" -> {
     "code generation", "C programs", "document preparation", 
      "external programs", "insertion into external files", 
      "output in external files", "splicing into files", 
      "splicing Mathematica output"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Splice[\"file\"] splices Mathematica output into an external file. It \
takes text enclosed between < * and * > in the file, evaluates the text as \
Mathematica input, and replaces the text with the resulting Mathematica \
output. ", "synonyms" -> {}, "title" -> "Splice", "type" -> "Symbol", "uri" -> 
    "ref/Splice"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8756, 286, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9569614]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15299, 527}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2258, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2881, 82, 44, 1, 70, "ObjectName",
 CellID->18597],
Cell[2928, 85, 969, 30, 70, "Usage",
 CellID->16201]
}, Open  ]],
Cell[CellGroupData[{
Cell[3934, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4412, 137, 523, 18, 70, "Notes",
 CellID->29974],
Cell[4938, 157, 567, 21, 70, "Notes",
 CellID->12912],
Cell[5508, 180, 264, 9, 70, "Notes",
 CellID->6736],
Cell[5775, 191, 187, 6, 70, "Notes",
 CellID->3676],
Cell[5965, 199, 1152, 29, 70, "2ColumnTableMod",
 CellID->19684],
Cell[7120, 230, 208, 8, 70, "Notes",
 CellID->10294],
Cell[7331, 240, 1157, 31, 70, "3ColumnTableMod",
 CellID->23733],
Cell[8491, 273, 228, 8, 70, "Notes",
 CellID->2633]
}, Closed]],
Cell[CellGroupData[{
Cell[8756, 286, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9569614],
Cell[CellGroupData[{
Cell[9139, 300, 147, 5, 70, "ExampleSection",
 CellID->16211891],
Cell[9289, 307, 174, 7, 70, "ExampleText",
 CellID->309689976],
Cell[9466, 316, 185, 6, 70, "Input",
 CellID->973132726],
Cell[9654, 324, 194, 6, 70, "Input",
 CellID->1606549951],
Cell[CellGroupData[{
Cell[9873, 334, 105, 3, 28, "Input",
 CellID->1017606108],
Cell[9981, 339, 241, 6, 36, "Output",
 CellID->81217621]
}, Open  ]],
Cell[10237, 348, 57, 1, 70, "ExampleText",
 CellID->206270330],
Cell[CellGroupData[{
Cell[10319, 353, 108, 3, 70, "Input",
 CellID->746830052],
Cell[10430, 358, 100, 2, 70, "Print",
 CellID->517089399]
}, Open  ]],
Cell[10545, 363, 250, 10, 70, "ExampleText",
 CellID->341290617],
Cell[CellGroupData[{
Cell[10820, 377, 105, 3, 70, "Input",
 CellID->142578782],
Cell[10928, 382, 242, 6, 36, "Output",
 CellID->348304571]
}, Open  ]],
Cell[11185, 391, 65, 1, 70, "ExampleText",
 CellID->1945121670],
Cell[CellGroupData[{
Cell[11275, 396, 162, 4, 70, "Input",
 CellID->314911980],
Cell[11440, 402, 102, 2, 70, "Print",
 CellID->61927096]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11603, 411, 311, 9, 70, "SeeAlsoSection",
 CellID->23061],
Cell[11917, 422, 200, 6, 70, "SeeAlso",
 CellID->29248]
}, Open  ]],
Cell[CellGroupData[{
Cell[12154, 433, 313, 9, 70, "TutorialsSection",
 CellID->1287],
Cell[12470, 444, 465, 12, 70, "Tutorials",
 CellID->7244]
}, Open  ]],
Cell[CellGroupData[{
Cell[12972, 461, 319, 9, 70, "MoreAboutSection",
 CellID->163082795],
Cell[13294, 472, 153, 3, 70, "MoreAbout",
 CellID->95545367],
Cell[13450, 477, 138, 3, 70, "MoreAbout",
 CellID->745238],
Cell[13591, 482, 122, 3, 70, "MoreAbout",
 CellID->156839420],
Cell[13716, 487, 173, 3, 70, "MoreAbout",
 CellID->177710067]
}, Open  ]],
Cell[13904, 493, 27, 0, 70, "History"],
Cell[13934, 495, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

