(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86124,       2619]
NotebookOptionsPosition[     74225,       2186]
NotebookOutlinePosition[     75517,       2223]
CellTagsIndexPosition[     75431,       2218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power" :> Documentation`HelpLookup["paclet:ref/Power"], 
          "PowerExpand" :> Documentation`HelpLookup["paclet:ref/PowerExpand"],
           "SqrtBox" :> Documentation`HelpLookup["paclet:ref/SqrtBox"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Power\"\>", 
       2->"\<\"PowerExpand\"\>", 3->"\<\"SqrtBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arithmetic Functions\"\>", 
       2->"\<\"Elementary Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Sqrt ",
 StyleBox["(\[Sqrt])", "OperatorCharacter"],
 "\n"
}], "ObjectName",
 LineSpacing->{0.33, 1., 2.},
 CellID->7030],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sqrt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sqrt"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      SqrtBox[
       StyleBox["z", "TI"]]], "InlineFormula"],
     " gives the square root of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  SqrtBox[
   StyleBox["z", "TI"]]], "InlineFormula"],
 " can be entered using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 StyleBox[" ", "KeyEventDelimiter"],
 StyleBox["z", "KeyEvent"],
 " or ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{"\[Backslash]", 
     RowBox[{"@", 
      StyleBox["z", "TI"]}], "\[Backslash]"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18552],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->11607],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   RowBox[{
    StyleBox["z", "TI"], "^", "2"}], "]"}]], "InlineFormula"],
 " is not automatically converted to ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23306],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   RowBox[{
    StyleBox["a", "TI"], " ", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is not automatically converted to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sqrt", "[", 
    StyleBox["a", "TI"], "]"}], 
   RowBox[{"Sqrt", "[", 
    StyleBox["b", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17965],

Cell[TextData[{
 "These conversions can be done using ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ", but will typically be correct only for positive real arguments. "
}], "Notes",
 CellID->19578],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  SqrtBox[
   StyleBox["z", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Sqrt]", 
   StyleBox["z", "TI"]}]], "InlineFormula"],
 " can also be used for input. The ",
 Cell[BoxData["\[Sqrt]"], "InlineFormula"],
 " character is entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sqrt\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Sqrt]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sqrt"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->20577]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->395398925],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount"]
}], "ExampleSection",
 CellID->947560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3635],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351631467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3891],

Cell["Evaluate numerically to any precision:", "ExampleText",
 CellID->6231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27408],

Cell[BoxData["1.\
4142135623730950488016887242096980785696718753769480731766797379907`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->958911186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6660],

Cell["Negative numbers have imaginary square roots:", "ExampleText",
 CellID->8248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"-", "25"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13497],

Cell[BoxData[
 RowBox[{"5", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6311796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3329],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->30221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", "2", ",", 
   SqrtBox["5"]}], "}"}]], "Output",
 ImageSize->{131, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18834270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21623],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzll2uIVVUUx/fcx4w97DlOQ8IwUTgaVkhR9EAqUTMre1hGJnWdrLmVjo+x
h/bQivxSXwqkIPJDD+jxwQiMwCASIiESIiEqCIOwD0mQ9GEguP3W2mfP3Wef
dWfuvV+7cM85e++1/uv13+vsc2ttYmzDxtpEfbQ2vHxrbfNYfXTb8LLxrUyV
e5xze/nXBh3PDZ70v7fR4B5fR7hWWDpPRmWR0Z8b4FLK5uUuY1kuZeOyas+P
tJyBMkculebYGTMDhRmxIQH0yF2nFiS4/ZnXRd3u8C9O8M+14iqglsyVmdH7
I92y6WE7Po+09Glwxiq0gz+/BVrMiPhezjGjyLSzEpwXp5mdzXVP5lUkc/z4
3/qY6FSScafr/0s8zapV34FkbHWG6dab6Dp7+JvfGsVqf7L/aH5WPHkpL7Pm
7veLMq7sSSCTu/Pyr7/29Ucffp9aOvrDH/Wx/dls5pz+4qzIWNCrU1ZG13/8
809/Nq3kd0tfErPyNJPABzx5oU2tsloj1BMn/pG5Xe1aq06NPzvw456XvzT9
DPHI3fVOrfDz8VnWqgabSmEvln065fH5Qkb7MsmUf17z1VcOZVV/LldRX4fJ
yX/Xrf2A2karRQ5jfXzTp8i6Z00pb9lXQB6fyVnqTfzYaWJUgz87d3wOeTMp
Dx1+pTTCKNe+WidPTpKnY8f+cjtUMdUoR4yJDEQSHoeMELHk5ekucWYlOE91
gCMCpwR9Txn3ZJd+nBrygh+C80SXOKdFOEe++91tb6Q87G00WS/32ZEGpXcT
Zt3PEGnIsS3HGS+FFrpsUbfF1PVjvCFHcNRtNqXO1jEoYEmnGs9Z0jNHBd7B
XaiHuxtNlH4dH/rqV/aL8PPxKE0WP9Pe5t/9eLF94sCbbxzG4KNmJXqTcbru
+/577x7JYq53haJvnwr7hN1C8on6kbZxZHh+qE+WjYdN7dDD0t42N8oFOefh
oZb6Ft5QqAUNnEy40QIXW/XEoVBtSoDrUKdmVns45AfO4CHb8IEcay7Udc8G
oMjfOhNH5arYw03vrHTRtTmseYoFBEDI8F65z8QaCVnjtUPxMX6vylWm6Yzx
nJ7mK/QAAkKfst2T43A0KHQCwVsY9KmabwKrzarN3EsuUQkAgPFId6pgemIq
mUgicFkegVzc3gFCLLEoIPmsgHRbJljQmhbncq20zy5VZGtIpVcWmJl2yStV
D4KxDdHb9/a30u9WmAy4SmVZRwpZeCBvuuU5Nl0TGAePICe1km691MS7TmUh
AikkdjTE5xtN2cUhPqzeseodvJW32vU52zeoDEwmevzDtvSGxSbekmAbKb8z
JO5rTUanvXRZyBk7Bl/wSDrh1QabzTNcNL5JkQicPki28BvvfU067qk3KxYV
ITdNr64weZnuzdBXb1FDvnq45AlBoItMlPDtl6KtUhTUPE/IsC/tpQazW507
7wr1IY6VK/ZxlVouLPC5VaddHUXiS0yxcGmByYY1wWPfJwkdNUoxL8cv7ZtV
suo5uHvXQbaru8hEvD/Y/+LgL2xJHwJb4YIc4oMqhSHMsQkA5RgAyYdMzPUq
DU85RrBfcNRLz/XVcUb/MTK8IcSaoAyaNbY7mODWW+DM6QAnlnisBd45hZpX
TSyB2mRhULAzG9aOmvlNsSXCgxS+8UDE07uMUc+gfVSQnQ4rly55CxLBEOl7
s6aqmPZoPbv3eS4hjxaM8gT1uSgwRb9e5IQC6eBVJGV8cWc62bdyz3+qIu6j
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->164858720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21053],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 "is not automatically replaced by ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->3321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30843],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383925701]
}, Open  ]],

Cell[TextData[{
 "It can be simplified to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " if one assumes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->31132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7783],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251303531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646],

Cell[TextData[{
 "Enter ",
 Cell[BoxData[
  FormBox[
   SqrtBox["x"], TraditionalForm]], "InlineMath"],
 " using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->18480],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox["100"]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20345011]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24941],

Cell["Exact roots are factored out when possible:", "ExampleText",
 CellID->21912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7636],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66253425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2792],

Cell["Find square roots of complex numbers:", "ExampleText",
 CellID->4579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4607],

Cell[BoxData[
 RowBox[{"1.6113010897357534`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3103082367318438`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161448837]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12279],

Cell["Roots of quadratic polynomial:", "ExampleText",
 CellID->129435838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->910703014],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["c", "b"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{369, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19266897]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264636501],

Cell["Generate periodic continued fractions:", "ExampleText",
 CellID->3418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Sqrt", "[", "111", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "6", ",", "1", ",", "1", ",", "20"}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207658858]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "111", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "1", ",", "1", ",", "6", ",", "1", ",", "1", ",", "20", ",", "1",
    ",", "1", ",", "6", ",", "1", ",", "1", ",", "20", ",", "1", ",", "1", 
   ",", "6", ",", "1", ",", "1", ",", "20", ",", "1"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39749724]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8996],

Cell["Reduce combinations of square roots:", "ExampleText",
 CellID->16327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13895],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227760694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11250],

Cell["Evaluate power series involving square roots:", "ExampleText",
 CellID->3261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31880],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SqrtBox["x"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]], "12"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"9", "/", "2"}]], "1440"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"11", "/", "2"}]],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 0, 0, 
    Rational[-1, 12], 0, 0, 0, 
    Rational[1, 1440]}, 1, 11, 2],
  Editable->False]], "Output",
 ImageSize->{173, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256491576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3604],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Arg", "[", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}]}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Arg", "[", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}]}], "]"}]}]}]], "Output",
 ImageSize->{412, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614511436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18326],

Cell["Factor polynomials with square roots in coefficients:", "ExampleText",
 CellID->7172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21353],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{93, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61542634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15510],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{67, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21168292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24174],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " handles expressions involving square roots:"
}], "ExampleText",
 CellID->30500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18165],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160257031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11661],

Cell["\<\
There are many subtle issues in handling square roots for arbitrary complex \
arguments:\
\>", "ExampleText",
 CellID->3066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"z", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10260],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
  SqrtBox[
   RowBox[{"\[ImaginaryI]", " ", "z"}]]}]], "Output",
 ImageSize->{85, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911072202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " expands forms involving square roots:"
}], "ExampleText",
 CellID->5846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29403],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "x", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "y", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], " ", 
  SqrtBox["x"], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{200, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298538768]
}, Open  ]],

Cell["It generically assumes that all variables are positive:", "ExampleText",
 CellID->19453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8044],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{55, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20751603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}]}], "}"}], "\[Element]", 
  "Algebraics"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19717],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83308212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21375],

Cell["Take limits accounting for branch-cuts:", "ExampleText",
 CellID->4445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"I", " ", "x"}]}], "]"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30110],

Cell[BoxData[
 RowBox[{"-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157940454]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"I", " ", "x"}]}], "]"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17781],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123081229]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16687],

Cell["\<\
Square root is discontinuous across its branch-cut along the negative real \
axis:\
\>", "ExampleText",
 CellID->22974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"0.01", "I"}]}], "]"}], ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"0.01", "I"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.004999937502734195`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.0000124996093955`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.004999937502734195`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.0000124996093955`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487155980]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18413],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->382746612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26827],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   RowBox[{
    StyleBox["x", "TI"], "^", "2"}], "]"}]], "InlineFormula"],
 " cannot automatically be reduced to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25668],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100226269]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "4"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15133],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90686533]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " assumed positive, the simplification can be done:"
}], "ExampleText",
 CellID->18297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30319],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132436585]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to do the formal reduction:"
}], "ExampleText",
 CellID->3184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16781],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->375853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3910],

Cell["Along the branch cut, these are not the same:", "ExampleText",
 CellID->23250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "z", "]"}]}], ",", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "z"}], "]"}]}], "}"}], "/.", 
  RowBox[{"z", "->", 
   RowBox[{"-", "1"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], ",", "\[ImaginaryI]"}], "}"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65887852]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12374],

Cell[TextData[{
 "Approximation to ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "#"}], "]"}], "&"}], ",", "1", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5450],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           SqrtBox[
            RowBox[{"1", "+", 
             SqrtBox[
              RowBox[{"1", "+", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SqrtBox[
                  RowBox[{"1", "+", 
                   SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]], "Output",
 ImageSize->{370, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94246970]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32102],

Cell[BoxData["1.6180285974702324`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->704262711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30332],

Cell["Riemann surface for square root:", "ExampleText",
 CellID->14310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"2", "x", " ", "y"}], ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26066],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20989627]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18350],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5582]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26407],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->28883],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4995],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/SquareRoot.html"], 
   None}], "IT"]], "RelatedLinks",
 CellID->609416310],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Sqrt/"], 
   None}]], "RelatedLinks",
 CellID->100143758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->223058438],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->120058067],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->67584370],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->220576889]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sqrt (\[Sqrt]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 41.9528306}", "context" -> "System`", 
    "keywords" -> {
     "radical", "roots", "sqrt", "sqt", "square root", "square roots", "surd",
       "M_SQRT2", "M_SQRT1_2", "M_2_SQRTPI"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sqrt[z] or Sqrt[z] gives the square root of z. ", "synonyms" -> {}, 
    "title" -> "Sqrt", "type" -> "Symbol", "uri" -> "ref/Sqrt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7978, 292, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->395398925]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 75288, 2211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2357, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2980, 81, 139, 6, 70, "ObjectName",
 CellID->7030],
Cell[3122, 89, 629, 22, 70, "Usage",
 CellID->1500]
}, Open  ]],
Cell[CellGroupData[{
Cell[3788, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4266, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4389, 139, 499, 19, 70, "Notes",
 CellID->18552],
Cell[4891, 160, 373, 15, 70, "Notes",
 CellID->11607],
Cell[5267, 177, 334, 13, 70, "Notes",
 CellID->23306],
Cell[5604, 192, 460, 18, 70, "Notes",
 CellID->17965],
Cell[6067, 212, 280, 8, 70, "Notes",
 CellID->19578],
Cell[6350, 222, 235, 8, 70, "Notes",
 CellID->9487],
Cell[6588, 232, 210, 7, 70, "Notes",
 CellID->31226],
Cell[6801, 241, 193, 7, 70, "Notes",
 CellID->28162],
Cell[6997, 250, 444, 19, 70, "Notes",
 CellID->13605],
Cell[7444, 271, 497, 16, 70, "Notes",
 CellID->20577]
}, Closed]],
Cell[CellGroupData[{
Cell[7978, 292, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->395398925],
Cell[CellGroupData[{
Cell[8363, 306, 145, 5, 70, "ExampleSection",
 CellID->947560],
Cell[CellGroupData[{
Cell[8533, 315, 95, 3, 28, "Input",
 CellID->3635],
Cell[8631, 320, 169, 6, 38, "Output",
 CellID->351631467]
}, Open  ]],
Cell[8815, 329, 120, 3, 70, "ExampleDelimiter",
 CellID->3891],
Cell[8938, 334, 76, 1, 70, "ExampleText",
 CellID->6231],
Cell[CellGroupData[{
Cell[9039, 339, 149, 5, 28, "Input",
 CellID->27408],
Cell[9191, 346, 235, 7, 36, "Output",
 CellID->958911186]
}, Open  ]],
Cell[9441, 356, 120, 3, 70, "ExampleDelimiter",
 CellID->6660],
Cell[9564, 361, 83, 1, 70, "ExampleText",
 CellID->8248],
Cell[CellGroupData[{
Cell[9672, 366, 115, 4, 70, "Input",
 CellID->13497],
Cell[9790, 372, 190, 6, 36, "Output",
 CellID->6311796]
}, Open  ]],
Cell[9995, 381, 120, 3, 70, "ExampleDelimiter",
 CellID->3329],
Cell[10118, 386, 198, 7, 70, "ExampleText",
 CellID->30221],
Cell[CellGroupData[{
Cell[10341, 397, 163, 5, 70, "Input",
 CellID->13582],
Cell[10507, 404, 262, 10, 43, "Output",
 CellID->18834270]
}, Open  ]],
Cell[10784, 417, 121, 3, 70, "ExampleDelimiter",
 CellID->12711],
Cell[CellGroupData[{
Cell[10930, 424, 211, 7, 28, "Input",
 CellID->21623],
Cell[11144, 433, 2033, 38, 118, "Output",
 Evaluatable->False,
 CellID->164858720]
}, Open  ]],
Cell[13192, 474, 121, 3, 70, "ExampleDelimiter",
 CellID->21053],
Cell[13316, 479, 259, 10, 70, "ExampleText",
 CellID->3321],
Cell[CellGroupData[{
Cell[13600, 493, 119, 4, 70, "Input",
 CellID->30843],
Cell[13722, 499, 193, 7, 45, "Output",
 CellID->383925701]
}, Open  ]],
Cell[13930, 509, 257, 10, 70, "ExampleText",
 CellID->31132],
Cell[CellGroupData[{
Cell[14212, 523, 146, 5, 70, "Input",
 CellID->7783],
Cell[14361, 530, 158, 5, 36, "Output",
 CellID->251303531]
}, Open  ]],
Cell[14534, 538, 119, 3, 70, "ExampleDelimiter",
 CellID->646],
Cell[14656, 543, 251, 11, 70, "ExampleText",
 CellID->18480],
Cell[CellGroupData[{
Cell[14932, 558, 78, 3, 70, "Input",
 CellID->1524],
Cell[15013, 563, 158, 5, 36, "Output",
 CellID->20345011]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15220, 574, 216, 7, 70, "ExampleSection",
 CellID->24941],
Cell[15439, 583, 82, 1, 70, "ExampleText",
 CellID->21912],
Cell[CellGroupData[{
Cell[15546, 588, 95, 3, 70, "Input",
 CellID->7636],
Cell[15644, 593, 191, 7, 38, "Output",
 CellID->66253425]
}, Open  ]],
Cell[15850, 603, 120, 3, 70, "ExampleDelimiter",
 CellID->2792],
Cell[15973, 608, 75, 1, 70, "ExampleText",
 CellID->4579],
Cell[CellGroupData[{
Cell[16073, 613, 120, 4, 70, "Input",
 CellID->4607],
Cell[16196, 619, 273, 7, 36, "Output",
 CellID->161448837]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16518, 632, 223, 7, 70, "ExampleSection",
 CellID->12279],
Cell[16744, 641, 73, 1, 70, "ExampleText",
 CellID->129435838],
Cell[CellGroupData[{
Cell[16842, 646, 273, 10, 70, "Input",
 CellID->910703014],
Cell[17118, 658, 1222, 41, 100, "Output",
 CellID->19266897]
}, Open  ]],
Cell[18355, 702, 125, 3, 70, "ExampleDelimiter",
 CellID->264636501],
Cell[18483, 707, 76, 1, 70, "ExampleText",
 CellID->3418],
Cell[CellGroupData[{
Cell[18584, 712, 142, 4, 70, "Input",
 CellID->24590],
Cell[18729, 718, 298, 10, 36, "Output",
 CellID->207658858]
}, Open  ]],
Cell[CellGroupData[{
Cell[19064, 733, 166, 5, 70, "Input",
 CellID->7102],
Cell[19233, 740, 398, 10, 36, "Output",
 CellID->39749724]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19680, 756, 232, 7, 70, "ExampleSection",
 CellID->8996],
Cell[19915, 765, 75, 1, 70, "ExampleText",
 CellID->16327],
Cell[CellGroupData[{
Cell[20015, 770, 189, 6, 70, "Input",
 CellID->13895],
Cell[20207, 778, 350, 12, 39, "Output",
 CellID->227760694]
}, Open  ]],
Cell[20572, 793, 121, 3, 70, "ExampleDelimiter",
 CellID->11250],
Cell[20696, 798, 83, 1, 70, "ExampleText",
 CellID->3261],
Cell[CellGroupData[{
Cell[20804, 803, 244, 8, 70, "Input",
 CellID->31880],
Cell[21051, 813, 697, 24, 54, "Output",
 CellID->256491576]
}, Open  ]],
Cell[21763, 840, 121, 3, 70, "ExampleDelimiter",
 CellID->18501],
Cell[CellGroupData[{
Cell[21909, 847, 184, 6, 70, "Input",
 CellID->3604],
Cell[22096, 855, 923, 32, 51, "Output",
 CellID->614511436]
}, Open  ]],
Cell[23034, 890, 121, 3, 70, "ExampleDelimiter",
 CellID->18326],
Cell[23158, 895, 91, 1, 70, "ExampleText",
 CellID->7172],
Cell[CellGroupData[{
Cell[23274, 900, 204, 7, 70, "Input",
 CellID->21353],
Cell[23481, 909, 259, 9, 38, "Output",
 CellID->61542634]
}, Open  ]],
Cell[CellGroupData[{
Cell[23777, 923, 162, 5, 70, "Input",
 CellID->15510],
Cell[23942, 930, 241, 9, 44, "Output",
 CellID->21168292]
}, Open  ]],
Cell[24198, 942, 121, 3, 70, "ExampleDelimiter",
 CellID->24174],
Cell[24322, 947, 217, 7, 70, "ExampleText",
 CellID->30500],
Cell[CellGroupData[{
Cell[24564, 958, 265, 9, 70, "Input",
 CellID->18165],
Cell[24832, 969, 192, 7, 38, "Output",
 CellID->160257031]
}, Open  ]],
Cell[25039, 979, 121, 3, 70, "ExampleDelimiter",
 CellID->11661],
Cell[25163, 984, 134, 4, 70, "ExampleText",
 CellID->3066],
Cell[CellGroupData[{
Cell[25322, 992, 161, 5, 70, "Input",
 CellID->10260],
Cell[25486, 999, 296, 11, 38, "Output",
 CellID->911072202]
}, Open  ]],
Cell[25797, 1013, 121, 3, 70, "ExampleDelimiter",
 CellID->22991],
Cell[25921, 1018, 216, 7, 70, "ExampleText",
 CellID->5846],
Cell[CellGroupData[{
Cell[26162, 1029, 238, 8, 70, "Input",
 CellID->29403],
Cell[26403, 1039, 582, 19, 45, "Output",
 CellID->298538768]
}, Open  ]],
Cell[27000, 1061, 94, 1, 70, "ExampleText",
 CellID->19453],
Cell[CellGroupData[{
Cell[27119, 1066, 157, 5, 70, "Input",
 CellID->8044],
Cell[27279, 1073, 203, 8, 38, "Output",
 CellID->20751603]
}, Open  ]],
Cell[27497, 1084, 121, 3, 70, "ExampleDelimiter",
 CellID->14424],
Cell[CellGroupData[{
Cell[27643, 1091, 258, 9, 70, "Input",
 CellID->19717],
Cell[27904, 1102, 160, 5, 36, "Output",
 CellID->83308212]
}, Open  ]],
Cell[28079, 1110, 121, 3, 70, "ExampleDelimiter",
 CellID->21375],
Cell[28203, 1115, 77, 1, 70, "ExampleText",
 CellID->4445],
Cell[CellGroupData[{
Cell[28305, 1120, 292, 10, 70, "Input",
 CellID->30110],
Cell[28600, 1132, 187, 6, 36, "Output",
 CellID->157940454]
}, Open  ]],
Cell[CellGroupData[{
Cell[28824, 1143, 312, 11, 70, "Input",
 CellID->17781],
Cell[29139, 1156, 170, 5, 36, "Output",
 CellID->123081229]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29358, 1167, 226, 7, 70, "ExampleSection",
 CellID->16687],
Cell[29587, 1176, 129, 4, 70, "ExampleText",
 CellID->22974],
Cell[CellGroupData[{
Cell[29741, 1184, 315, 12, 70, "Input",
 CellID->12299],
Cell[30059, 1198, 447, 12, 36, "Output",
 CellID->487155980]
}, Open  ]],
Cell[CellGroupData[{
Cell[30543, 1215, 407, 14, 70, "Input",
 CellID->18413],
Cell[30953, 1231, 11145, 187, 70, "Output",
 Evaluatable->False,
 CellID->382746612]
}, Open  ]],
Cell[42113, 1421, 121, 3, 70, "ExampleDelimiter",
 CellID->26827],
Cell[42237, 1426, 340, 13, 70, "ExampleText",
 CellID->12912],
Cell[CellGroupData[{
Cell[42602, 1443, 119, 4, 70, "Input",
 CellID->25668],
Cell[42724, 1449, 193, 7, 45, "Output",
 CellID->100226269]
}, Open  ]],
Cell[CellGroupData[{
Cell[42954, 1461, 163, 6, 70, "Input",
 CellID->15133],
Cell[43120, 1469, 157, 5, 36, "Output",
 CellID->90686533]
}, Open  ]],
Cell[43292, 1477, 171, 6, 70, "ExampleText",
 CellID->18297],
Cell[CellGroupData[{
Cell[43488, 1487, 204, 7, 70, "Input",
 CellID->30319],
Cell[43695, 1496, 158, 5, 36, "Output",
 CellID->132436585]
}, Open  ]],
Cell[43868, 1504, 215, 8, 70, "ExampleText",
 CellID->3184],
Cell[CellGroupData[{
Cell[44108, 1516, 158, 5, 70, "Input",
 CellID->16781],
Cell[44269, 1523, 155, 5, 36, "Output",
 CellID->375853]
}, Open  ]],
Cell[44439, 1531, 120, 3, 70, "ExampleDelimiter",
 CellID->3910],
Cell[44562, 1536, 84, 1, 70, "ExampleText",
 CellID->23250],
Cell[CellGroupData[{
Cell[44671, 1541, 297, 11, 70, "Input",
 CellID->16484],
Cell[44971, 1554, 245, 8, 36, "Output",
 CellID->65887852]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45265, 1568, 224, 7, 70, "ExampleSection",
 CellID->12374],
Cell[45492, 1577, 202, 8, 70, "ExampleText",
 CellID->18983],
Cell[CellGroupData[{
Cell[45719, 1589, 210, 8, 70, "Input",
 CellID->5450],
Cell[45932, 1599, 637, 24, 100, "Output",
 CellID->94246970]
}, Open  ]],
Cell[CellGroupData[{
Cell[46606, 1628, 93, 3, 70, "Input",
 CellID->32102],
Cell[46702, 1633, 176, 5, 36, "Output",
 CellID->704262711]
}, Open  ]],
Cell[46893, 1641, 121, 3, 70, "ExampleDelimiter",
 CellID->30332],
Cell[47017, 1646, 71, 1, 70, "ExampleText",
 CellID->14310],
Cell[CellGroupData[{
Cell[47113, 1651, 471, 16, 70, "Input",
 CellID->26066],
Cell[47587, 1669, 23221, 385, 70, "Output",
 Evaluatable->False,
 CellID->20989627]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70869, 2061, 311, 9, 70, "SeeAlsoSection",
 CellID->18350],
Cell[71183, 2072, 693, 26, 70, "SeeAlso",
 CellID->5582]
}, Open  ]],
Cell[CellGroupData[{
Cell[71913, 2103, 314, 9, 70, "TutorialsSection",
 CellID->26407],
Cell[72230, 2114, 163, 3, 70, "Tutorials",
 CellID->28883],
Cell[72396, 2119, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[72566, 2127, 320, 9, 70, "RelatedLinksSection",
 CellID->4995],
Cell[72889, 2138, 201, 5, 70, "RelatedLinks",
 CellID->609416310],
Cell[73093, 2145, 216, 5, 70, "RelatedLinks",
 CellID->100143758]
}, Open  ]],
Cell[CellGroupData[{
Cell[73346, 2155, 319, 9, 70, "MoreAboutSection",
 CellID->223058438],
Cell[73668, 2166, 151, 3, 70, "MoreAbout",
 CellID->120058067],
Cell[73822, 2171, 150, 3, 70, "MoreAbout",
 CellID->67584370],
Cell[73975, 2176, 155, 3, 70, "MoreAbout",
 CellID->220576889]
}, Open  ]],
Cell[74145, 2182, 50, 0, 70, "History"],
Cell[74198, 2184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

