(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18722,        717]
NotebookOptionsPosition[     14528,        573]
NotebookOutlinePosition[     15784,        609]
CellTagsIndexPosition[     15699,        604]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sqrt" :> Documentation`HelpLookup["paclet:ref/Sqrt"], 
          "RadicalBox" :> Documentation`HelpLookup["paclet:ref/RadicalBox"], 
          "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sqrt\"\>", 2->"\<\"RadicalBox\"\>", 
       3->"\<\"OverscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SqrtBox", "ObjectName",
 CellID->24526],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SqrtBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SqrtBox"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that represents the \
displayed object ",
     Cell[BoxData[
      SqrtBox[
       StyleBox["x", "TI"]]], "InlineFormula"],
     " in notebook expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Inside ",
 Cell["\\(\[Ellipsis]\\)", "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[TextData[Cell[BoxData[
  RowBox[{"\\@", 
   StyleBox["x", "TI"]}]], "InlineFormula"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13865],

Cell[TextData[{
 "In a notebook a ",
 Cell[BoxData[
  ButtonBox["SqrtBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SqrtBox"]], "InlineFormula"],
 " can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out from under the square root sign. "
}], "Notes",
 CellID->1037],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27494],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31746],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " does not fit on a single line, it is output as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "2"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2341],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["SqrtBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SqrtBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->11268]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335275560],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->77213528],

Cell["Display a letter under a square root sign:", "ExampleText",
 CellID->199545933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SqrtBox", "[", "\"\<x\>\"", "]"}], "//", "DisplayForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->588923719],

Cell[BoxData[
 TagBox[
  SqrtBox["x"],
  DisplayForm]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->156287927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179292804],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SqrtBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SqrtBox"]], "InlineFormula"],
 " form is typically interpreted as a square root:"
}], "ExampleText",
 CellID->145883430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"SqrtBox", "[", "\"\<x\>\"", "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5935187],

Cell[BoxData[
 SqrtBox["x"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116427324]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents a square root as a 1/2 power:"
}], "ExampleText",
 CellID->467770795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159520666],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->258585983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The standard formatting for a 1/2 power expression uses ",
 Cell[BoxData[
  ButtonBox["SqrtBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SqrtBox"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}], ",", "StandardForm"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35539747],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SqrtBox", "[", "\"\<x\>\"", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->87006028]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->416076514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "^", 
  RowBox[{"(", 
   RowBox[{"1", "/", "2"}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114330713],

Cell[BoxData[
 SqrtBox["x"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338066648]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15349],

Cell["Nested sqrt boxes: ", "ExampleText",
 CellID->418340676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "#"}]], "&"}], ",", "Pi", ",", "10"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->107528510],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           SqrtBox[
            RowBox[{"1", "+", 
             SqrtBox[
              RowBox[{"1", "+", 
               SqrtBox[
                RowBox[{"1", "+", 
                 SqrtBox[
                  RowBox[{"1", "+", 
                   SqrtBox[
                    RowBox[{
                    "1", "+", "\[Pi]"}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]], "Output",\

 ImageSize->{390, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33597737]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5967],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadicalBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadicalBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24187]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3839],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->17398],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->607118074]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SqrtBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 37.6558456}", "context" -> "System`", 
    "keywords" -> {"square roots"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SqrtBox[x] is a low-level box construct that represents the displayed \
object Sqrt[x] in notebook expressions. ", "synonyms" -> {"sqrt box"}, 
    "title" -> "SqrtBox", "type" -> "Symbol", "uri" -> "ref/SqrtBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7020, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->335275560]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15556, 597}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2221, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2844, 81, 45, 1, 70, "ObjectName",
 CellID->24526],
Cell[2892, 84, 625, 20, 70, "Usage",
 CellID->16688]
}, Open  ]],
Cell[CellGroupData[{
Cell[3554, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4032, 126, 414, 16, 70, "Notes",
 CellID->13865],
Cell[4449, 144, 564, 20, 70, "Notes",
 CellID->1037],
Cell[5016, 166, 686, 27, 70, "Notes",
 CellID->27494],
Cell[5705, 195, 333, 13, 70, "Notes",
 CellID->31746],
Cell[6041, 210, 408, 16, 70, "Notes",
 CellID->2341],
Cell[6452, 228, 531, 18, 70, "Notes",
 CellID->11268]
}, Closed]],
Cell[CellGroupData[{
Cell[7020, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335275560],
Cell[CellGroupData[{
Cell[7405, 265, 147, 5, 70, "ExampleSection",
 CellID->77213528],
Cell[7555, 272, 85, 1, 70, "ExampleText",
 CellID->199545933],
Cell[CellGroupData[{
Cell[7665, 277, 147, 5, 28, "Input",
 CellID->588923719],
Cell[7815, 284, 208, 8, 52, "Output",
 CellID->156287927]
}, Open  ]],
Cell[8038, 295, 125, 3, 70, "ExampleDelimiter",
 CellID->179292804],
Cell[8166, 300, 230, 8, 70, "ExampleText",
 CellID->145883430],
Cell[CellGroupData[{
Cell[8421, 312, 186, 6, 70, "Input",
 CellID->5935187],
Cell[8610, 320, 169, 6, 38, "Output",
 CellID->116427324]
}, Open  ]],
Cell[8794, 329, 148, 5, 70, "ExampleText",
 CellID->467770795],
Cell[CellGroupData[{
Cell[8967, 338, 100, 3, 70, "Input",
 CellID->159520666],
Cell[9070, 343, 413, 15, 50, "Output",
 CellID->258585983]
}, Open  ]],
Cell[9498, 361, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[9626, 366, 237, 8, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[9888, 378, 249, 9, 70, "Input",
 CellID->35539747],
Cell[10140, 389, 331, 12, 50, "Output",
 CellID->87006028]
}, Open  ]],
Cell[10486, 404, 80, 1, 70, "ExampleText",
 CellID->416076514],
Cell[CellGroupData[{
Cell[10591, 409, 139, 5, 70, "Input",
 CellID->114330713],
Cell[10733, 416, 169, 6, 38, "Output",
 CellID->338066648]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10951, 428, 224, 7, 70, "ExampleSection",
 CellID->15349],
Cell[11178, 437, 62, 1, 70, "ExampleText",
 CellID->418340676],
Cell[CellGroupData[{
Cell[11265, 442, 196, 8, 70, "Input",
 CellID->107528510],
Cell[11464, 452, 705, 27, 100, "Output",
 CellID->33597737]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12230, 486, 310, 9, 70, "SeeAlsoSection",
 CellID->5967],
Cell[12543, 497, 702, 26, 70, "SeeAlso",
 CellID->24187]
}, Open  ]],
Cell[CellGroupData[{
Cell[13282, 528, 313, 9, 70, "TutorialsSection",
 CellID->3839],
Cell[13598, 539, 179, 4, 70, "Tutorials",
 CellID->17398],
Cell[13780, 545, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[13989, 553, 299, 8, 70, "MoreAboutSection"],
Cell[14291, 563, 165, 3, 70, "MoreAbout",
 CellID->607118074]
}, Open  ]],
Cell[14471, 569, 27, 0, 70, "History"],
Cell[14501, 571, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

