(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23272,        824]
NotebookOptionsPosition[     18309,        654]
NotebookOutlinePosition[     19541,        690]
CellTagsIndexPosition[     19456,        685]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PowersRepresentations" :> 
          Documentation`HelpLookup["paclet:ref/PowersRepresentations"], 
          "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PowersRepresentations\"\>", 
       2->"\<\"EllipticTheta\"\>", 3->"\<\"Reduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Diophantine Equations\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 4->"\<\"Number Theory\"\>", 
       5->"\<\"New in 6.0: Mathematical Functions\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SquaresR", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SquaresR",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SquaresR"], "[", 
       RowBox[{
        StyleBox["d", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of ways ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["r", "d"], "(", "n", ")"}], TraditionalForm]], 
      "InlineMath"],
     " to represent the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " as a sum of ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " squares."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "d"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the number of ways to write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["n", "1", "2"], "+", 
     SubsuperscriptBox["n", "2", "2"], "+", "\[Ellipsis]", "+", 
     SubsuperscriptBox["n", "d", "2"]}], "=", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be positive, negative or zero."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40208901],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251706880],

Cell["Number of ways to represent 45 as two sums of squares:", "ExampleText",
 CellID->458959983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"2", ",", " ", "45"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718722543],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1591927113]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "The number of integer points on a circle of radius ",
 Cell[BoxData[
  SqrtBox[
   StyleBox["n", "TI"]]], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->159709131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SquaresR", "[", 
     RowBox[{"2", ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142265325],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd07tOgkEQhuGJlSWFhYWFGmOIMUZFPCuDR1BQwHNrtPYW9tL2krgENcxX
zLsJ2Tx8MzvZ/4eVz5/J95yZff19/vfZmnZme8PjC8+ed0urgXwh9uXYF1G/
BKtO/avwGs5bR38T3kD9JvIteBvzdtC/i7yF/j3Ut5HvwwfwIXwU1r2Ocf4J
6k/hM9SfI+/AHo77FUfezeeVLvIL9Muaf5nrC2xXOB+2a/TDdoNcVv8tcth6
yGW9737s8T5KP9fbXZ5XYLvH+bANkMM2xPlD5A/olzX/ETlso3Dc1+X4X5RR
rq+wjfM8H+e8wBW2CebLui9cZa2nbIcLXGF7zue7rN8z8iprvWC+rOeHvML2
in5Z94cr6u0N/XCBK2zv6Jc1X47nUVFvH+Gm/wKCT1si
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 16.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153132672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14342320],

Cell[TextData[{
 "The number of integer points on a sphere of dimension ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->400341797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SquaresR", "[", 
     RowBox[{"n", ",", "100"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460113603],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 2.}, {2., 12.}, {3., 30.}, {4., 744.}, {5., 10890.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5.}, {0., 10890.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1015409198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Number of lattice points inside the circle of radius 20 with center at the \
origin:\
\>", "ExampleText",
 CellID->134690164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"SquaresR", "[", 
    RowBox[{"2", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", 
     RowBox[{"20", "^", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665537877],

Cell[BoxData["1257"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2077331724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->667935202],

Cell[TextData[{
 "Approximation of the ",
 ButtonBox["Sierpinski constant",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/SierpinskiConstant.html"], None}],
 ":"
}], "ExampleText",
 CellID->182955291],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SquaresR", "[", 
       RowBox[{"2", ",", "k"}], "]"}], "/", "k"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "n"}], "}"}]}], "]"}], " ", "-", " ", 
   RowBox[{"Pi", " ", 
    RowBox[{"Log", "[", "n", "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->984636959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"s", "[", "100000", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1523081946],

Cell[BoxData["2.5853587724249607`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2072635989]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["The number of representations as the sum of two squares:", "ExampleText",
 CellID->86538229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"2", ",", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313917246],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460829136]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowersRepresentations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFormula"],
 " enumerates the ordered representations up to units:"
}], "ExampleText",
 CellID->4657563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"100", ",", "2", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72641349],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1329257670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28153297],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZTransform"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->20204796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"SquaresR", "[", 
    RowBox[{"2", ",", "n"}], "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99520813],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"EllipticTheta", "[", 
   RowBox[{"3", ",", "0", ",", 
    FractionBox["1", "z"]}], "]"}], "2"]], "Output",
 ImageSize->{162, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421699813]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowersRepresentations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowersRepresentations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->206581126],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->117668622],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->265868],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->354536583],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->78322432],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->315671941],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->506001672]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SquaresR - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 44.2341390}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SquaresR[d, n] gives the number of ways r_d (n) to represent the integer \
n as a sum of d squares.", "synonyms" -> {"squares R"}, "title" -> "SquaresR",
     "type" -> "Symbol", "uri" -> "ref/SquaresR"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7198, 211, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->40208901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19314, 678}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2960, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3583, 94, 1573, 37, 70, "ObjectNameGrid"],
Cell[5159, 133, 871, 29, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6067, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6545, 184, 616, 22, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[7198, 211, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40208901],
Cell[CellGroupData[{
Cell[7582, 225, 148, 5, 70, "ExampleSection",
 CellID->251706880],
Cell[7733, 232, 97, 1, 70, "ExampleText",
 CellID->458959983],
Cell[CellGroupData[{
Cell[7855, 237, 133, 4, 28, "Input",
 CellID->718722543],
Cell[7991, 243, 159, 5, 36, "Output",
 CellID->1591927113]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8199, 254, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8423, 263, 186, 7, 70, "ExampleText",
 CellID->159709131],
Cell[CellGroupData[{
Cell[8634, 274, 280, 9, 70, "Input",
 CellID->142265325],
Cell[8917, 285, 877, 23, 137, "Output",
 CellID->153132672]
}, Open  ]],
Cell[9809, 311, 124, 3, 70, "ExampleDelimiter",
 CellID->14342320],
Cell[9936, 316, 175, 6, 70, "ExampleText",
 CellID->400341797],
Cell[CellGroupData[{
Cell[10136, 326, 280, 9, 70, "Input",
 CellID->460113603],
Cell[10419, 337, 504, 16, 129, "Output",
 CellID->1015409198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10972, 359, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[11202, 368, 135, 4, 70, "ExampleText",
 CellID->134690164],
Cell[CellGroupData[{
Cell[11362, 376, 269, 9, 70, "Input",
 CellID->665537877],
Cell[11634, 387, 162, 5, 36, "Output",
 CellID->2077331724]
}, Open  ]],
Cell[11811, 395, 125, 3, 70, "ExampleDelimiter",
 CellID->667935202],
Cell[11939, 400, 234, 8, 70, "ExampleText",
 CellID->182955291],
Cell[12176, 410, 414, 14, 70, "Input",
 CellID->984636959],
Cell[CellGroupData[{
Cell[12615, 428, 131, 4, 70, "Input",
 CellID->1523081946],
Cell[12749, 434, 177, 5, 36, "Output",
 CellID->2072635989]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12975, 445, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[13216, 454, 98, 1, 70, "ExampleText",
 CellID->86538229],
Cell[CellGroupData[{
Cell[13339, 459, 129, 4, 70, "Input",
 CellID->313917246],
Cell[13471, 465, 159, 5, 36, "Output",
 CellID->460829136]
}, Open  ]],
Cell[13645, 473, 253, 7, 70, "ExampleText",
 CellID->4657563],
Cell[CellGroupData[{
Cell[13923, 484, 151, 4, 70, "Input",
 CellID->72641349],
Cell[14077, 490, 304, 11, 36, "Output",
 CellID->1329257670]
}, Open  ]],
Cell[14396, 504, 124, 3, 70, "ExampleDelimiter",
 CellID->28153297],
Cell[14523, 509, 191, 8, 70, "ExampleText",
 CellID->20204796],
Cell[CellGroupData[{
Cell[14739, 521, 199, 6, 70, "Input",
 CellID->99520813],
Cell[14941, 529, 279, 9, 52, "Output",
 CellID->421699813]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15281, 545, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15600, 556, 732, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[16369, 587, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[16690, 598, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[16925, 607, 319, 9, 70, "MoreAboutSection",
 CellID->206581126],
Cell[17247, 618, 153, 3, 70, "MoreAbout",
 CellID->117668622],
Cell[17403, 623, 152, 3, 70, "MoreAbout",
 CellID->265868],
Cell[17558, 628, 162, 3, 70, "MoreAbout",
 CellID->354536583],
Cell[17723, 633, 136, 3, 70, "MoreAbout",
 CellID->78322432],
Cell[17862, 638, 174, 3, 70, "MoreAbout",
 CellID->315671941],
Cell[18039, 643, 198, 4, 70, "MoreAbout",
 CellID->506001672]
}, Open  ]],
Cell[18252, 650, 27, 0, 70, "History"],
Cell[18282, 652, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

