(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13153,        484]
NotebookOptionsPosition[     10038,        380]
NotebookOutlinePosition[     11360,        418]
CellTagsIndexPosition[     11275,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Evaluation Stack" :> 
          Documentation`HelpLookup["paclet:tutorial/TheEvaluationStack"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Evaluation Stack\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack" :> Documentation`HelpLookup["paclet:ref/Stack"], 
          "StackInhibit" :> 
          Documentation`HelpLookup["paclet:ref/StackInhibit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stack\"\>", 
       2->"\<\"StackInhibit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicExecutionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Execution History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StackBegin", "ObjectName",
 CellID->16372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StackBegin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StackBegin"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", starting a fresh evaluation stack. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 " to prevent \"outer\" evaluations from appearing in the evaluation stack \
when you call ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7379],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4372],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 " is automatically done when the evaluation of each input line begins in an \
interactive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->28486]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->439036007],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->276323543],

Cell[TextData[{
 "Show only the evaluations being done inside of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->681524005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"StackBegin", "[", 
    RowBox[{"2", "+", 
     RowBox[{"x", "*", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"Stack", "[", "]"}], "]"}], ";", "2"}], "]"}]}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89413321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Plus", ",", "Times", ",", "g", ",", "CompoundExpression", ",", "Print"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->27883567],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"2", "+", 
    RowBox[{"x", " ", 
     RowBox[{"g", "[", "2", "]"}]}]}], "]"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34422810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36167035],

Cell["Get the detailed stack contents: ", "ExampleText",
 CellID->35982804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"StackBegin", "[", 
    RowBox[{"2", "+", 
     RowBox[{"x", "*", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}], "]"}]}]}], 
    "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441865332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"2", "+", 
     RowBox[{"x", " ", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}], "]"}]}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"x", " ", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->284372149],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"2", "+", 
    RowBox[{"x", " ", 
     RowBox[{"g", "[", "2", "]"}]}]}], "]"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7994988]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32103],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackInhibit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackInhibit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9748]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9602],

Cell[TextData[ButtonBox["The Evaluation Stack",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheEvaluationStack"]], "Tutorials",
 CellID->19270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->253790534]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StackBegin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 50.7499308}", "context" -> "System`", 
    "keywords" -> {
     "evaluation of functions", "functions being evaluated", 
      "pending evaluations", "partial stack"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StackBegin[expr] evaluates expr, starting a fresh evaluation stack. ", 
    "synonyms" -> {"stack begin"}, "title" -> "StackBegin", "type" -> 
    "Symbol", "uri" -> "ref/StackBegin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4708, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->439036007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11132, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1863, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2486, 75, 48, 1, 70, "ObjectName",
 CellID->16372],
Cell[2537, 78, 573, 18, 70, "Usage",
 CellID->24454]
}, Open  ]],
Cell[CellGroupData[{
Cell[3147, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3625, 118, 396, 14, 70, "Notes",
 CellID->7379],
Cell[4024, 134, 313, 12, 70, "Notes",
 CellID->4372],
Cell[4340, 148, 331, 12, 70, "Notes",
 CellID->28486]
}, Closed]],
Cell[CellGroupData[{
Cell[4708, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->439036007],
Cell[CellGroupData[{
Cell[5093, 179, 148, 5, 70, "ExampleSection",
 CellID->276323543],
Cell[5244, 186, 168, 6, 70, "ExampleText",
 CellID->681524005],
Cell[CellGroupData[{
Cell[5437, 196, 354, 12, 70, "Input",
 CellID->89413321],
Cell[5794, 210, 199, 6, 23, "Print",
 CellID->27883567],
Cell[5996, 218, 298, 10, 36, "Output",
 CellID->34422810]
}, Open  ]],
Cell[6309, 231, 124, 3, 70, "ExampleDelimiter",
 CellID->36167035],
Cell[6436, 236, 75, 1, 70, "ExampleText",
 CellID->35982804],
Cell[CellGroupData[{
Cell[6536, 241, 361, 12, 70, "Input",
 CellID->441865332],
Cell[6900, 255, 936, 34, 70, "Print",
 CellID->284372149],
Cell[7839, 291, 297, 10, 36, "Output",
 CellID->7994988]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8197, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->32103],
Cell[8511, 319, 452, 17, 70, "SeeAlso",
 CellID->9748]
}, Open  ]],
Cell[CellGroupData[{
Cell[9000, 341, 313, 9, 70, "TutorialsSection",
 CellID->9602],
Cell[9316, 352, 149, 3, 70, "Tutorials",
 CellID->19270]
}, Open  ]],
Cell[CellGroupData[{
Cell[9502, 360, 299, 8, 70, "MoreAboutSection"],
Cell[9804, 370, 162, 3, 70, "MoreAbout",
 CellID->253790534]
}, Open  ]],
Cell[9981, 376, 27, 0, 70, "History"],
Cell[10011, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

