(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65504,       2384]
NotebookOptionsPosition[     52568,       1920]
NotebookOutlinePosition[     53959,       1958]
CellTagsIndexPosition[     53873,       1953]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"], 
          "Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Statistics\"\>", 
       2->"\<\"Discrete Distributions\"\>", 
       3->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "MeanDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MeanDeviation"], 
          "MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], "Kurtosis" :> 
          Documentation`HelpLookup["paclet:ref/Kurtosis"], "CentralMoment" :> 
          Documentation`HelpLookup["paclet:ref/CentralMoment"], "Covariance" :> 
          Documentation`HelpLookup["paclet:ref/Covariance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Variance\"\>", 2->"\<\"Mean\"\>", 
       3->"\<\"Quantile\"\>", 4->"\<\"MeanDeviation\"\>", 
       5->"\<\"MedianDeviation\"\>", 6->"\<\"Kurtosis\"\>", 
       7->"\<\"CentralMoment\"\>", 
       8->"\<\"Covariance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Numerical Data\"\>", 3->"\<\"Statistics\"\>", 
       4->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StandardDeviation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StandardDeviation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StandardDeviation"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the standard deviation of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StandardDeviation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StandardDeviation"], "[", 
       StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the standard deviation of the symbolic \
distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   RowBox[{
    ButtonBox["Variance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Variance"], "[", 
    StyleBox["list", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1409],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->26413],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"StandardDeviation", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->18242],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209580331],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->764231826],

Cell["Standard deviation of a list of numbers:", "ExampleText",
 CellID->46582167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
   "1.21", ",", "3.4", ",", "2", ",", "4.66", ",", "1.5", ",", "5.61", ",", 
    "7.22"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6538],

Cell[BoxData["2.2718326984009645`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23867425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5666],

Cell["Standard deviation of elements in each column:", "ExampleText",
 CellID->23374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5.2", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.3", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.4", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.10000000000000009`", ",", "1"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875119218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->791078686],

Cell["Standard deviation of a symbolic lognormal distribution:", "ExampleText",
 CellID->95484360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"0", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->834848358],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", 
   "\[ExponentialE]"}]]], "Output",
 ImageSize->{80, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63550814]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32663],

Cell["Exact numeric input:", "ExampleText",
 CellID->7388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20671],

Cell[BoxData[
 SqrtBox[
  FractionBox["17", "10"]]], "Output",
 ImageSize->{42, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93960522]
}, Open  ]],

Cell["Numerical approximation:", "ExampleText",
 CellID->3049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], "//",
   "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21948],

Cell[BoxData["1.3038404810405297`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181775232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6905],

Cell["Standard deviation of symbolic values:", "ExampleText",
 CellID->11203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1842],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SqrtBox["6"]], 
  RowBox[{"(", 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], ")"}], " ", 
       RowBox[{"Conjugate", "[", "a", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", 
         RowBox[{"2", " ", "b"}], "-", "c"}], ")"}], " ", 
       RowBox[{"Conjugate", "[", "b", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "+", 
         RowBox[{"2", " ", "c"}]}], ")"}], " ", 
       RowBox[{"Conjugate", "[", "c", "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{563, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118940228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Element]", "Reals"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6452],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"b", " ", "c"}], "+", 
    SuperscriptBox["c", "2"], "-", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]}]], 
  SqrtBox["3"]]], "Output",
 ImageSize->{183, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208592865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29194],

Cell["Mixed numeric and symbolic data:", "ExampleText",
 CellID->12248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "x"}], "}"}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25851],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"68", "-", 
    RowBox[{"20", " ", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}]}]], 
  RowBox[{"2", " ", 
   SqrtBox["3"]}]]], "Output",
 ImageSize->{113, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172477956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30841],

Cell["Exact numeric data:", "ExampleText",
 CellID->4297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}], ",", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26550],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"10", "-", 
     SqrtBox["6"], "-", 
     SqrtBox["10"], "-", 
     SqrtBox["15"]}], ")"}]}]]], "Output",
 ImageSize->{190, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15264336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359275129],

Cell["Arbitrary\[Hyphen]precision data:", "ExampleText",
 CellID->188291280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "3", ",", "10", ",", "1"}], "}"}], ",", 
    "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24927221],

Cell[BoxData["3.56370593624109226950843939072`19.596487680879548"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208221284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.2887412528075859`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146656822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.288911730482463`", ",", "0.28869713719547496`", ",", 
   "0.28858614960404116`", ",", "0.288551786374441`", ",", 
   "0.28847051135210905`", ",", "0.28877315969690187`", ",", 
   "0.28858804644630304`", ",", "0.2888899064270891`", ",", 
   "0.2886912222633124`", ",", "0.2887292146815066`"}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427670247]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29112],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->859360755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "10"], ",", 
   FractionBox["1", "5"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["82", "33"]], "5"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["491", "11"]], "15"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["278", "33"]], "5"], ",", 
   SqrtBox[
    FractionBox["17", "33"]], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["1814", "11"]], "15"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["817", "33"]], "5"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["354", "11"]], "5"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["4019", "11"]], "15"]}], "}"}]], "Output",
 ImageSize->{493, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->685571931]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27166],

Cell["Transform data to have mean 0 and unit variance:", "ExampleText",
 CellID->36947642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3308855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.4852954852902345`", ",", "0.6990138891559194`", ",", 
   "1.1843848176564409`", ",", "4.93687402384605`", ",", 
   "3.0465086543690556`", ",", "2.3255248977463303`", ",", 
   "3.356102703664395`", ",", "4.680153446508238`", ",", "4.564946678822803`",
    ",", "3.846994982753599`", ",", "4.543571201396375`", ",", 
   "1.1556689133442866`", ",", "0.6989554797748077`", ",", 
   "0.7375863335934374`", ",", "0.6887250233882358`", ",", 
   "1.3511285233425196`", ",", "4.1207164741049676`", ",", 
   "2.855358671836817`", ",", "1.9174905988967594`", ",", 
   "0.22082169388519035`"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322076060]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"standardized", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"data", "-", 
     RowBox[{"Mean", "[", "data", "]"}]}], ")"}], "/", 
   RowBox[{"StandardDeviation", "[", "data", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431639415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.582942052911091`"}], ",", 
   RowBox[{"-", "1.0729032975420274`"}], ",", 
   RowBox[{"-", "0.7704506579215971`"}], ",", "1.5678646364564042`", ",", 
   "0.3899078156560977`", ",", 
   RowBox[{"-", "0.059363921709118014`"}], ",", "0.5828273580552105`", ",", 
   "1.4078925167817116`", ",", "1.3361029040493535`", ",", 
   "0.8887205561470265`", ",", "1.3227830507348113`", ",", 
   RowBox[{"-", "0.7883446036614673`"}], ",", 
   RowBox[{"-", "1.0729396945952059`"}], ",", 
   RowBox[{"-", "1.048867375834106`"}], ",", 
   RowBox[{"-", "1.0793146716631556`"}], ",", 
   RowBox[{"-", "0.666546466377516`"}], ",", "1.0592865763160184`", ",", 
   "0.2707951671938556`", ",", 
   RowBox[{"-", "0.3136252371199598`"}], ",", 
   RowBox[{"-", "1.3708826020552456`"}]}], "}"}]], "Output",
 ImageSize->{488, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41860274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", "standardized", "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->444853232],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->430010991]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "standardized", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->580424416],

Cell[BoxData["0.9999999999999998`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->243657372]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27885],

Cell[TextData[{
 "The square of ",
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->180528295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24818],

Cell[BoxData[
 FractionBox["5", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46037415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8772],

Cell[BoxData[
 SqrtBox[
  FractionBox["5", "3"]]], "Output",
 ImageSize->{35, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->564377014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353623198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 " of deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7602946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->691934725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.8390220012700738`", ",", "2.444113578274283`", ",", 
   "4.6879582733832965`", ",", "5.773831528313577`", ",", 
   "5.460754064365183`", ",", "4.0281783938278615`", ",", 
   "7.246358989999939`", ",", "8.185792238611745`", ",", "3.518340272282634`",
    ",", "5.094664329039831`", ",", "0.7511016167531048`", ",", 
   "3.216654982862801`", ",", "3.095943876247318`", ",", "8.893721790292243`",
    ",", "0.8324999986741877`", ",", "7.0660836634269835`", ",", 
   "5.900890691278365`", ",", "8.87874631624607`", ",", "5.844000432108163`", 
   ",", "9.238902834108975`"}], "}"}]], "Output",
 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388163047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214941188],

Cell[BoxData["2.539453118146452`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110990203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], "/", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->650778682],

Cell[BoxData["2.539453118146452`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->106782445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137012746],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " is the square root of a scaled ",
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22673528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86545193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.182519564288517`", ",", "8.010798380985335`", ",", "6.541541507021751`", 
   ",", "6.157975969295826`", ",", "4.679645603744557`", ",", 
   "4.49229173691905`", ",", "0.1270521684357151`", ",", "3.568462819094802`",
    ",", "1.427255531087983`", ",", "0.23206055754880328`", ",", 
   "2.4370633067640246`", ",", "8.302478689626788`", ",", 
   "4.518740334335398`", ",", "5.052432689427102`", ",", 
   "2.1202622079115563`", ",", "0.07492540297426631`", ",", 
   "3.3673593768969745`", ",", "1.5648393879067357`", ",", 
   "6.967223557037723`", ",", "5.172797626889709`"}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143667759]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309913758],

Cell[BoxData["2.5452565358978987`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136775493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{
   RowBox[{"CentralMoment", "[", 
    RowBox[{"data", ",", "2"}], "]"}], " ", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154126311],

Cell[BoxData["2.5452565358978987`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->499275935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97257252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of the deviations:"
}], "ExampleText",
 CellID->22987128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451046271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2881849568708335`", ",", "9.472224654818941`", ",", "8.019837782518337`",
    ",", "4.618630277529244`", ",", "3.5750920708921052`", ",", 
   "5.236945987392416`", ",", "1.0054875979522304`", ",", 
   "0.7484240940276221`", ",", "5.132794173070778`", ",", 
   "1.4384198605802911`"}], "}"}]], "Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331475730]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootMeanSquare", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162394754],

Cell[BoxData["2.949138447992653`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14785930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->251299893],

Cell[BoxData["2.9491384479926523`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->690647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396400762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " is the square root of a scaled ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of squared deviations:"
}], "ExampleText",
 CellID->19399639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89934925],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5918989180564849`", ",", "4.699364100084884`", ",", "2.850614133217646`",
    ",", "3.2997704840652697`", ",", "1.5056493356344747`", ",", 
   "1.3228505494306009`", ",", "2.081362080355719`", ",", 
   "0.09667563025170467`", ",", "4.587790114931568`", ",", 
   "2.9292017989021337`", ",", "1.9713205847293513`", ",", 
   "2.3556627913534856`", ",", "2.5414209723205605`", ",", 
   "0.049507500284581285`", ",", "2.786032280102387`", ",", 
   "4.066568945890451`", ",", "1.206410885794783`", ",", 
   "0.4309911397225741`", ",", "2.0337278332440922`", ",", 
   "3.739658603126826`"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->901741930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443930393],

Cell[BoxData["1.404555634773273`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484019566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{
   RowBox[{"Mean", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"data", "-", 
       RowBox[{"Mean", "[", "data", "]"}]}], ")"}], "^", "2"}], "]"}], " ", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134444918],

Cell[BoxData["1.404555634773273`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->168028131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70099947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " as a scaled ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 " from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->394865487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148442668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.39582763229159657`", ",", "5.746354438356917`", ",", 
   "4.203212333105699`", ",", "4.707192765954174`", ",", "8.848179715467063`",
    ",", "4.251105309953838`", ",", "8.46009833061771`", ",", 
   "7.458351059300272`", ",", "0.7160990134330714`", ",", 
   "8.664944254754218`", ",", "7.386054061265459`", ",", "5.232606593536106`",
    ",", "8.014361433226302`", ",", "7.726619147298431`", ",", 
   "6.3901279883311135`", ",", "5.257427885247727`", ",", 
   "7.937672219877632`", ",", "6.636312598673406`", ",", 
   "2.2757666559420175`", ",", "0.034735632230087354`"}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612129578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mean", "=", 
  RowBox[{"Mean", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->618390570],

Cell[BoxData["5.517152453443142`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103865114]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"len", "=", 
  RowBox[{"Length", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5648062],

Cell[BoxData["20"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->419154537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EuclideanDistance", "[", 
   RowBox[{"data", ",", 
    RowBox[{"Table", "[", 
     RowBox[{"mean", ",", 
      RowBox[{"{", "len", "}"}]}], "]"}]}], "]"}], "/", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"(", 
    RowBox[{"len", "-", "1"}], ")"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->263731272],

Cell[BoxData["2.8092468792444287`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->645319803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->35249381],

Cell[BoxData["2.8092468792444287`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->333897296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211774243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " squared is less than ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " if all absolute deviations are less than 1:"
}], "ExampleText",
 CellID->250203883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390325569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.37629870718914593`", ",", "0.01009136948889311`", ",", 
   "0.038138217291788346`", ",", "0.5385868852028148`", ",", 
   "0.19710920711206215`", ",", "0.1798955443002308`", ",", 
   "0.10637012636567`", ",", "0.34352833397257343`", ",", 
   "0.027826056434888002`", ",", "0.3078411297138639`"}], "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268490075]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287940559],

Cell[BoxData["0.1431961650499252`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->560516581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", "data", "]"}], "^", "2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->421485872],

Cell[BoxData["0.03082891211295058`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171306130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156147355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " squared is greater than ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " if all absolute deviations are greater than 1:"
}], "ExampleText",
 CellID->486490344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "5"}], "]"}], ",", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", "5"}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->471760332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.708411793415354`", ",", "1.740391663049565`", ",", "1.2035457580758195`",
    ",", "1.8314797847964372`", ",", "1.5942444646358815`", ",", 
   "5.437050327252348`", ",", "5.886689260566868`", ",", "5.852149775916169`",
    ",", "5.757698301575713`", ",", "5.680484342149786`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74475534]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106654448],

Cell[BoxData["2.053599854348783`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302292143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", "data", "]"}], "^", "2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->309580972],

Cell[BoxData["4.726890208734343`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->140524601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->797726614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " of a random variable as the square root of an ",
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->572927312],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173202917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"ExpectedValue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"Mean", "[", "dist", "]"}]}], ")"}], "^", "2"}], ",", "dist", 
     ",", "x"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140877037],

Cell[BoxData[
 SqrtBox[
  RowBox[{"\[Alpha]", " ", 
   SuperscriptBox["\[Beta]", "2"]}]]], "Output",
 ImageSize->{46, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10193139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd", "=", 
  RowBox[{"StandardDeviation", "[", "dist", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259210552],

Cell[BoxData[
 RowBox[{
  SqrtBox["\[Alpha]"], " ", "\[Beta]"}]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->642476847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ev", "\[Equal]", "sd"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"\[Beta]", ">", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->232098844],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->358214302]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20648],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Covariance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Covariance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23732],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->5411],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with StandardDeviation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
StandardDeviation"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->132439892],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->144444471],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->453162955],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->264376421],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->90839857]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StandardDeviation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 51.9218358}", "context" -> "System`", 
    "keywords" -> {"sample standard deviation", "standard error"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StandardDeviation[list] gives the standard deviation of the elements in \
list. StandardDeviation[dist] gives the standard deviation of the symbolic \
distribution dist.", "synonyms" -> {"standard deviation"}, "title" -> 
    "StandardDeviation", "type" -> "Symbol", "uri" -> 
    "ref/StandardDeviation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12231, 338, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->209580331]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53729, 1946}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3198, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3821, 95, 4201, 83, 70, "ObjectNameGrid"],
Cell[8025, 180, 1006, 31, 70, "Usage",
 CellID->5858]
}, Open  ]],
Cell[CellGroupData[{
Cell[9068, 216, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9546, 233, 545, 20, 70, "Notes",
 CellID->1409],
Cell[10094, 255, 228, 7, 70, "Notes",
 CellID->26413],
Cell[10325, 264, 1529, 55, 70, "Notes",
 CellID->18242],
Cell[11857, 321, 337, 12, 70, "Notes",
 CellID->11945]
}, Closed]],
Cell[CellGroupData[{
Cell[12231, 338, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209580331],
Cell[CellGroupData[{
Cell[12616, 352, 148, 5, 70, "ExampleSection",
 CellID->764231826],
Cell[12767, 359, 82, 1, 70, "ExampleText",
 CellID->46582167],
Cell[CellGroupData[{
Cell[12874, 364, 230, 7, 28, "Input",
 CellID->6538],
Cell[13107, 373, 175, 5, 36, "Output",
 CellID->23867425]
}, Open  ]],
Cell[13297, 381, 120, 3, 70, "ExampleDelimiter",
 CellID->5666],
Cell[13420, 386, 85, 1, 70, "ExampleText",
 CellID->23374],
Cell[CellGroupData[{
Cell[13530, 391, 324, 11, 70, "Input",
 CellID->2246],
Cell[13857, 404, 222, 7, 36, "Output",
 CellID->875119218]
}, Open  ]],
Cell[14094, 414, 125, 3, 70, "ExampleDelimiter",
 CellID->791078686],
Cell[14222, 419, 98, 1, 70, "ExampleText",
 CellID->95484360],
Cell[CellGroupData[{
Cell[14345, 424, 185, 5, 70, "Input",
 CellID->834848358],
Cell[14533, 431, 293, 11, 38, "Output",
 CellID->63550814]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14875, 448, 216, 7, 70, "ExampleSection",
 CellID->32663],
Cell[15094, 457, 58, 1, 70, "ExampleText",
 CellID->7388],
Cell[CellGroupData[{
Cell[15177, 462, 189, 6, 70, "Input",
 CellID->20671],
Cell[15369, 470, 191, 7, 60, "Output",
 CellID->93960522]
}, Open  ]],
Cell[15575, 480, 62, 1, 70, "ExampleText",
 CellID->3049],
Cell[CellGroupData[{
Cell[15662, 485, 215, 7, 70, "Input",
 CellID->21948],
Cell[15880, 494, 176, 5, 36, "Output",
 CellID->181775232]
}, Open  ]],
Cell[16071, 502, 120, 3, 70, "ExampleDelimiter",
 CellID->6905],
Cell[16194, 507, 77, 1, 70, "ExampleText",
 CellID->11203],
Cell[CellGroupData[{
Cell[16296, 512, 165, 5, 70, "Input",
 CellID->1842],
Cell[16464, 519, 864, 29, 74, "Output",
 CellID->118940228]
}, Open  ]],
Cell[CellGroupData[{
Cell[17365, 553, 223, 8, 70, "Input",
 CellID->6452],
Cell[17591, 563, 438, 16, 65, "Output",
 CellID->208592865]
}, Open  ]],
Cell[18044, 582, 121, 3, 70, "ExampleDelimiter",
 CellID->29194],
Cell[18168, 587, 71, 1, 70, "ExampleText",
 CellID->12248],
Cell[CellGroupData[{
Cell[18264, 592, 276, 8, 70, "Input",
 CellID->25851],
Cell[18543, 602, 340, 13, 65, "Output",
 CellID->172477956]
}, Open  ]],
Cell[18898, 618, 121, 3, 70, "ExampleDelimiter",
 CellID->30841],
Cell[19022, 623, 57, 1, 70, "ExampleText",
 CellID->4297],
Cell[CellGroupData[{
Cell[19104, 628, 304, 10, 70, "Input",
 CellID->26550],
Cell[19411, 640, 331, 13, 60, "Output",
 CellID->15264336]
}, Open  ]],
Cell[19757, 656, 125, 3, 70, "ExampleDelimiter",
 CellID->359275129],
Cell[19885, 661, 76, 1, 70, "ExampleText",
 CellID->188291280],
Cell[CellGroupData[{
Cell[19986, 666, 252, 8, 70, "Input",
 CellID->24927221],
Cell[20241, 676, 208, 5, 36, "Output",
 CellID->208221284]
}, Open  ]],
Cell[20464, 684, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[20592, 689, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[20705, 694, 200, 6, 70, "Input",
 CellID->315224713],
Cell[20908, 702, 176, 5, 36, "Output",
 CellID->146656822]
}, Open  ]],
Cell[CellGroupData[{
Cell[21121, 712, 254, 8, 70, "Input",
 CellID->594479966],
Cell[21378, 722, 486, 12, 54, "Output",
 CellID->427670247]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21913, 740, 239, 7, 70, "ExampleSection",
 CellID->29112],
Cell[22155, 749, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[22391, 761, 570, 19, 70, "Input",
 CellID->19878761],
Cell[22964, 782, 484, 17, 36, "Output",
 CellID->859360755]
}, Open  ]],
Cell[CellGroupData[{
Cell[23485, 804, 114, 3, 70, "Input",
 CellID->235263230],
Cell[23602, 809, 812, 32, 78, "Output",
 CellID->685571931]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24463, 847, 223, 7, 70, "ExampleSection",
 CellID->27166],
Cell[24689, 856, 90, 1, 70, "ExampleText",
 CellID->36947642],
Cell[CellGroupData[{
Cell[24804, 861, 155, 5, 70, "Input",
 CellID->3308855],
Cell[24962, 868, 776, 17, 71, "Output",
 CellID->322076060]
}, Open  ]],
Cell[CellGroupData[{
Cell[25775, 890, 263, 8, 70, "Input",
 CellID->431639415],
Cell[26041, 900, 967, 22, 71, "Output",
 CellID->41860274]
}, Open  ]],
Cell[CellGroupData[{
Cell[27045, 927, 138, 4, 70, "Input",
 CellID->444853232],
Cell[27186, 933, 158, 5, 36, "Output",
 CellID->430010991]
}, Open  ]],
Cell[CellGroupData[{
Cell[27381, 943, 115, 3, 70, "Input",
 CellID->580424416],
Cell[27499, 948, 176, 5, 36, "Output",
 CellID->243657372]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27724, 959, 233, 7, 70, "ExampleSection",
 CellID->27885],
Cell[27960, 968, 343, 13, 70, "ExampleText",
 CellID->180528295],
Cell[CellGroupData[{
Cell[28328, 985, 167, 5, 70, "Input",
 CellID->24818],
Cell[28498, 992, 177, 6, 51, "Output",
 CellID->46037415]
}, Open  ]],
Cell[CellGroupData[{
Cell[28712, 1003, 175, 5, 70, "Input",
 CellID->8772],
Cell[28890, 1010, 190, 7, 60, "Output",
 CellID->564377014]
}, Open  ]],
Cell[29095, 1020, 125, 3, 70, "ExampleDelimiter",
 CellID->353623198],
Cell[29223, 1025, 463, 17, 70, "ExampleText",
 CellID->7602946],
Cell[CellGroupData[{
Cell[29711, 1046, 158, 5, 70, "Input",
 CellID->691934725],
Cell[29872, 1053, 764, 16, 71, "Output",
 CellID->388163047]
}, Open  ]],
Cell[CellGroupData[{
Cell[30673, 1074, 116, 3, 70, "Input",
 CellID->214941188],
Cell[30792, 1079, 175, 5, 36, "Output",
 CellID->110990203]
}, Open  ]],
Cell[CellGroupData[{
Cell[31004, 1089, 279, 9, 70, "Input",
 CellID->650778682],
Cell[31286, 1100, 175, 5, 36, "Output",
 CellID->106782445]
}, Open  ]],
Cell[31476, 1108, 125, 3, 70, "ExampleDelimiter",
 CellID->137012746],
Cell[31604, 1113, 361, 12, 70, "ExampleText",
 CellID->22673528],
Cell[CellGroupData[{
Cell[31990, 1129, 157, 5, 70, "Input",
 CellID->86545193],
Cell[32150, 1136, 767, 16, 71, "Output",
 CellID->143667759]
}, Open  ]],
Cell[CellGroupData[{
Cell[32954, 1157, 116, 3, 70, "Input",
 CellID->309913758],
Cell[33073, 1162, 176, 5, 36, "Output",
 CellID->136775493]
}, Open  ]],
Cell[CellGroupData[{
Cell[33286, 1172, 348, 12, 70, "Input",
 CellID->154126311],
Cell[33637, 1186, 176, 5, 36, "Output",
 CellID->499275935]
}, Open  ]],
Cell[33828, 1194, 124, 3, 70, "ExampleDelimiter",
 CellID->97257252],
Cell[33955, 1199, 362, 12, 70, "ExampleText",
 CellID->22987128],
Cell[CellGroupData[{
Cell[34342, 1215, 158, 5, 70, "Input",
 CellID->451046271],
Cell[34503, 1222, 478, 12, 54, "Output",
 CellID->331475730]
}, Open  ]],
Cell[CellGroupData[{
Cell[35018, 1239, 379, 13, 70, "Input",
 CellID->162394754],
Cell[35400, 1254, 174, 5, 36, "Output",
 CellID->14785930]
}, Open  ]],
Cell[CellGroupData[{
Cell[35611, 1264, 116, 3, 70, "Input",
 CellID->251299893],
Cell[35730, 1269, 173, 5, 36, "Output",
 CellID->690647]
}, Open  ]],
Cell[35918, 1277, 125, 3, 70, "ExampleDelimiter",
 CellID->396400762],
Cell[36046, 1282, 365, 12, 70, "ExampleText",
 CellID->19399639],
Cell[CellGroupData[{
Cell[36436, 1298, 156, 5, 70, "Input",
 CellID->89934925],
Cell[36595, 1305, 778, 17, 71, "Output",
 CellID->901741930]
}, Open  ]],
Cell[CellGroupData[{
Cell[37410, 1327, 116, 3, 70, "Input",
 CellID->443930393],
Cell[37529, 1332, 175, 5, 36, "Output",
 CellID->484019566]
}, Open  ]],
Cell[CellGroupData[{
Cell[37741, 1342, 431, 15, 70, "Input",
 CellID->134444918],
Cell[38175, 1359, 175, 5, 36, "Output",
 CellID->168028131]
}, Open  ]],
Cell[38365, 1367, 124, 3, 70, "ExampleDelimiter",
 CellID->70099947],
Cell[38492, 1372, 477, 17, 70, "ExampleText",
 CellID->394865487],
Cell[CellGroupData[{
Cell[38994, 1393, 158, 5, 70, "Input",
 CellID->148442668],
Cell[39155, 1400, 766, 16, 71, "Output",
 CellID->612129578]
}, Open  ]],
Cell[CellGroupData[{
Cell[39958, 1421, 129, 4, 70, "Input",
 CellID->618390570],
Cell[40090, 1427, 175, 5, 36, "Output",
 CellID->103865114]
}, Open  ]],
Cell[CellGroupData[{
Cell[40302, 1437, 128, 4, 70, "Input",
 CellID->5648062],
Cell[40433, 1443, 159, 5, 36, "Output",
 CellID->419154537]
}, Open  ]],
Cell[CellGroupData[{
Cell[40629, 1453, 337, 11, 70, "Input",
 CellID->263731272],
Cell[40969, 1466, 176, 5, 36, "Output",
 CellID->645319803]
}, Open  ]],
Cell[CellGroupData[{
Cell[41182, 1476, 115, 3, 70, "Input",
 CellID->35249381],
Cell[41300, 1481, 176, 5, 36, "Output",
 CellID->333897296]
}, Open  ]],
Cell[41491, 1489, 125, 3, 70, "ExampleDelimiter",
 CellID->211774243],
Cell[41619, 1494, 395, 12, 70, "ExampleText",
 CellID->250203883],
Cell[CellGroupData[{
Cell[42039, 1510, 157, 5, 70, "Input",
 CellID->390325569],
Cell[42199, 1517, 489, 12, 54, "Output",
 CellID->268490075]
}, Open  ]],
Cell[CellGroupData[{
Cell[42725, 1534, 112, 3, 70, "Input",
 CellID->287940559],
Cell[42840, 1539, 176, 5, 36, "Output",
 CellID->560516581]
}, Open  ]],
Cell[CellGroupData[{
Cell[43053, 1549, 139, 4, 70, "Input",
 CellID->421485872],
Cell[43195, 1555, 177, 5, 36, "Output",
 CellID->171306130]
}, Open  ]],
Cell[43387, 1563, 125, 3, 70, "ExampleDelimiter",
 CellID->156147355],
Cell[43515, 1568, 401, 12, 70, "ExampleText",
 CellID->486490344],
Cell[CellGroupData[{
Cell[43941, 1584, 392, 14, 70, "Input",
 CellID->471760332],
Cell[44336, 1600, 471, 11, 54, "Output",
 CellID->74475534]
}, Open  ]],
Cell[CellGroupData[{
Cell[44844, 1616, 112, 3, 70, "Input",
 CellID->106654448],
Cell[44959, 1621, 175, 5, 36, "Output",
 CellID->302292143]
}, Open  ]],
Cell[CellGroupData[{
Cell[45171, 1631, 139, 4, 70, "Input",
 CellID->309580972],
Cell[45313, 1637, 175, 5, 36, "Output",
 CellID->140524601]
}, Open  ]],
Cell[45503, 1645, 125, 3, 70, "ExampleDelimiter",
 CellID->797726614],
Cell[45631, 1650, 377, 12, 70, "ExampleText",
 CellID->572927312],
Cell[46011, 1664, 196, 6, 70, "Input",
 CellID->173202917],
Cell[CellGroupData[{
Cell[46232, 1674, 330, 11, 70, "Input",
 CellID->140877037],
Cell[46565, 1687, 229, 8, 45, "Output",
 CellID->10193139]
}, Open  ]],
Cell[CellGroupData[{
Cell[46831, 1700, 140, 4, 70, "Input",
 CellID->259210552],
Cell[46974, 1706, 205, 7, 38, "Output",
 CellID->642476847]
}, Open  ]],
Cell[CellGroupData[{
Cell[47216, 1718, 291, 9, 70, "Input",
 CellID->232098844],
Cell[47510, 1729, 161, 5, 36, "Output",
 CellID->358214302]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47732, 1741, 311, 9, 70, "SeeAlsoSection",
 CellID->20648],
Cell[48046, 1752, 1951, 71, 70, "SeeAlso",
 CellID->24884]
}, Open  ]],
Cell[CellGroupData[{
Cell[50034, 1828, 314, 9, 70, "TutorialsSection",
 CellID->23732],
Cell[50351, 1839, 141, 3, 70, "Tutorials",
 CellID->5411],
Cell[50495, 1844, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[50651, 1849, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[50845, 1857, 305, 8, 70, "RelatedLinksSection"],
Cell[51153, 1867, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51566, 1884, 319, 9, 70, "MoreAboutSection",
 CellID->132439892],
Cell[51888, 1895, 155, 3, 70, "MoreAbout",
 CellID->144444471],
Cell[52046, 1900, 139, 3, 70, "MoreAbout",
 CellID->453162955],
Cell[52188, 1905, 132, 3, 70, "MoreAbout",
 CellID->264376421],
Cell[52323, 1910, 150, 3, 70, "MoreAbout",
 CellID->90839857]
}, Open  ]],
Cell[52488, 1916, 50, 0, 70, "History"],
Cell[52541, 1918, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

