(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76097,       2543]
NotebookOptionsPosition[     63829,       2110]
NotebookOutlinePosition[     65212,       2148]
CellTagsIndexPosition[     65126,       2143]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Forms of Input and Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormsOfInputAndOutput"], 
          "Reducing Expressions to Their Standard Form" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReducingExpressionsToTheirStandardForm"], 
          "The Interpretation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheInterpretationOfTextualForms"], 
          "The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Forms of Input and Output\"\>", 
       2->"\<\"Reducing Expressions to Their Standard Form\"\>", 
       3->"\<\"The Interpretation of Textual Forms\"\>", 
       4->"\<\"The Representation of Textual Forms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"], 
          "OutputForm" :> Documentation`HelpLookup["paclet:ref/OutputForm"], 
          "InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TraditionalForm\"\>", 2->"\<\"OutputForm\"\>", 
       3->"\<\"InputForm\"\>", 4->"\<\"Style\"\>", 
       5->"\<\"MakeExpression\"\>", 6->"\<\"ToBoxes\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellMenu"], 
          "Tokens Related to the Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellTokens"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalTypesetting"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Menu\"\>", 
       2->"\<\"Tokens Related to the Cell Menu\"\>", 
       3->"\<\"Converting between Expressions & Strings\"\>", 
       4->"\<\"Graphics Directives\"\>", 
       5->"\<\"Mathematical Typesetting\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StandardForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StandardForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StandardForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " two\[Hyphen]dimensional representation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " generates output that gives a unique and unambiguous representation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, suitable for use as input. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15763429]
}], "Notes",
 CellID->26146],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " incorporates many aspects of traditional mathematical notation. "
}], "Notes",
 CellID->845],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is the standard format type used for both input and output of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in notebooks. "
}], "Notes",
 CellID->20646],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " are displayed graphically in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29118],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " can be edited in the notebook front end. "
}], "Notes",
 CellID->19457],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " uses special characters as well as ordinary keyboard characters."
}], "Notes",
 CellID->14788],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is based on boxes. "
}], "Notes",
 CellID->6981],

Cell[TextData[{
 "The notebook front end contains menu items for conversion to and from ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46064404],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->759991405],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is used by default for output:"
}], "ExampleText",
 CellID->50858609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}]}], "+", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21849426],

Cell[BoxData[
 RowBox[{"\[Pi]", "+", 
  FractionBox["1", "x"], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{61, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474406522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]}], "+", "Pi"}], "//", 
  "StandardForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23307750],

Cell[BoxData[
 RowBox[{"\[Pi]", "+", 
  FractionBox["1", "x"], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{61, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->204501615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168869160],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " for graphics:"
}], "ExampleText",
 CellID->5423303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456579029],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->19351983]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108635468],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->76308404,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27065],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->230152069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"StandardForm", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox["123",
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     FractionBox["1", "23"],
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox["1.23`",
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"1", "+", 
      RowBox[{"23", " ", "\[ImaginaryI]"}]}],
     StandardForm],
    StandardForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{164, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272754241]
}, Open  ]],

Cell[TextData[{
 "Arbitrary-precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->311286961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "I"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28481542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox["3.33333333333333333333333333333333333333`20.",
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{
     "3.33333333333333333333333333333333333333`20.", " ", "\[ImaginaryI]"}],
     StandardForm],
    StandardForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->879302152]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->224777360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"{", 
   RowBox[{"I", ",", "Pi", ",", "E"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydUk0PgjAMLWww4xd488jRq3fOevJHLMQEDgaD/H/sJtHlUYNxydq9fryu
3S62r6832zeVLc6dvddN9ShObccmFRFRyTvbE58HPvldDgNr7aRy2C9aAs4B
Z4CVZ1FgXbGIGe4CHfpjMctZDU3tiVQT2QKcskho2ptcNYxi6au5Oxtf+h0H
3hSyjFgLb5ZAlp+m/viJNhCxAIbopx5ywMiq/p7OHDN2LGLxBd2ot+MPWLPW
47Tns49iFPaH+AD49ZPLL5KiJ8/LpKA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->316536575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80999419],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->220523646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVUs0OgjAMLoyfaFT05pGbJ1+AB9CTD7EQEzgYCfL+sx0LLqWAkKzdV9bv
a77tobvq+dJdXer83uqmqstPfnu3WFIBABS4sjPg3uDOrsIYzBFFRdh+sGE4
W8DKsihW3WIIER5dPrH/odhFOIZxPXEsocTi4RQDwfgvNVuNB2zP9H6QVsJP
O17Kqdc5xJGTvSqfUYmqO7G6pxz9epcdCCZ9jWZVUsH1Na6tml/0XJ6a4MFl
99Ss3b7e0g1w3ouZeyWc4yrdHxQTEYIvIRDIXA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470648411]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->21729394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "\"\<A first line\\nA second line\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell[BoxData["\<\"A first line\\nA second line\"\>"], "Output",
 ImageSize->{95, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->271314209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->660577078],

Cell[TextData[{
 "Different ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->388790367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    RadicalBox["a", "3"], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    SuperscriptBox["x", 
     RowBox[{"-", "1"}]]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVdtOwzAMTZO0AwaaxFZAgEZ5hf+AJ964SFwkqglp04RAY//XTyux47LW
sSATq9Q4x3aO49ppbsrl9O29XM4mZXG9KD+ns8lXcfWxcCqTKKXm7h0fKTev
3QzfeV076cdHN2qn1CT7qH2C0YIvPm6yi+KZvPYQWUL3JDOSKVoNjGbFcRdw
9piHFtfdsh1mUateN+g1YPiM4RHDeTQr5FOQzEkeRK0GnDq4xfQ90g+ZPiP9
9h9799G0EE2lP9iXD7l0U8fAOhLqpaiTpDwTbzdeIKXIuy9qT1mUQ8RVVSn/
QOMhpiXQu3A8IGoi5gwelr6kFSLA9FzMgddK/yMPvquxWC+pOwzVwAhd0uTE
9y+zYc90Ti7sPVXdapl2XTvex1FRdurVOQi8eS+yDoZ1JxuNwnG+VpTwi4nn
7JeshgHDgL553P+PVxbtWZvPjxfML469+WfJJ/QyirO5PR6Y1ba51Quz9tfW
du8sf+up5Bs0XKuB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139880611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4576816],

Cell["Special typeset expressions:", "ExampleText",
 CellID->24395000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"y", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], ",", " ", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"y", "[", "k", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}], ",", " ", 
    "\n", "  ", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", " ", "Reals"}], "]"}], ",", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "\[And]", "y"}], ")"}], "\[Or]", "z"}]}], "}"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->692214967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}],
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "n"], 
      RowBox[{"y", "[", "k", "]"}]}],
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"x", "\[Element]", "Reals"}],
     StandardForm],
    StandardForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "&&", "y"}], ")"}], "||", "z"}],
     StandardForm],
    StandardForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{329, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774655339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100925433],

Cell["Different list structures:", "ExampleText",
 CellID->415848662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], ",", 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {"a", "b"},
           {"c", "d"}
          }], "\[NoBreak]", ")"}], 
        RowBox[{
         RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "b"},
            {"c", "d"}
           }], "\[NoBreak]", ")"}], "\[NoBreak]"}]},
       {
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {"a", "b"},
           {"c", "d"}
          }], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {"a", "b"},
           {"c", "d"}
          }], "\[NoBreak]", ")"}]}
      }], ")"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250695724],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWdtOGzEQdXYTSIsCAVVAXyr4mfLUj9hGVZMHRAV8PH3a7ji7ET2MNTvj
yyZSLNtrj8+cGd/GP5rX7a/H5nW3ae4enps/293m5e7703NXVc+cm7055+5v
XZdvu5z/0+9v999n97kzSuvha+vmyvInKF8I7T9H9pfkxeJDPmLxafHm5nc9
Mb+p7S+Va0rUrHOoq654yUinepQfas+h4/prx0evHTu+FU8qfq4K8WO1j7Zc
tSm8jVAvumIN9Yu+fiH0XzLyaqbfaWAcCR/KT40f14TU+LX6TGWf5ZHaJ7d/
lZllXsriUPYynW9FK8Np8CvKpNbosalkjxkrp17IcS69LHoejz2XZr1L27OU
n+pns9ba7DnvA9YVW4vr1IqThWdSUQoiQqkpEZ9nQazVoKQN1kdngzxeoy3P
vNwUJ855UHNsjXe0apTmEgbp5qfDiPfcNBi1mPPyzM+Jsjzn8YVjOhESD7Qb
omaspqOk/dcqgcXicLMzJQnu2NlSwh64k05vj3x+NF00ox6Ynu/rnf/hXoia
DyvRec9cH8xzw7fYVW4cKpwfMahS7B9xXF5MymVKC0/jzV+gfCJoeMuhiOBa
Gh+9VTt+rIdq+flamJ9Y+9i8LvaVjeLkhxv5u3qMX1/37aS5I8W9Q+NhvH7s
eNrxrfrfZNbfyrcpmuEL+F6rz2nHll7kUr/waVcYSn56zbSsD68+69b2WhTq
x1mv6osbE1JthJ78tGbqUS4XuefGIXm0L2P/k7691qcoaUxMWCOURWKjwMwh
FgwWk/QdfGXv1dodSBPDwlsDasHGtEQpeObAPZfzht+tdV6EYxOIS9r7wzcr
qsSboWRJSrYmrXT3xTO2tTYuUwVZLKd3+N5A6Ln1h7s/4L1h9U7qmLXKjh/P
mniWRLToj9/MTFvPj3ja5nYyanffcygxQsnOI6LcmNOIm/0DJvgXyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{504, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19886342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->745678177],

Cell["Some objects use a special output representation:", "ExampleText",
 CellID->483444329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"ser", "=", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49083534],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//StandardForm=",
 CellID->146688104]
}, Open  ]],

Cell[TextData[{
 "Compare with the underlying ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the expression:"
}], "ExampleText",
 CellID->252858662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152587590],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SeriesData", "[", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", "0", ",", 
       RowBox[{"Rational", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "6"}], "]"}]}], "]"}], ",", "1", ",", "4", 
     ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->40133936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43308889],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->65245750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"i", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151992235],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//StandardForm=",
 CellID->762722451]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298336904],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->549604059]
}, Open  ]],

Cell[TextData[{
 "The elided parts are visible using ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->186619138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "i", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->400554568],

Cell["\<\
InterpolatingFunction[{{1, 4}}, {3, 1, 0, {4}, {4}, 0, 0, 0, 0}, 
 {{1, 2, 3, 4}}, {{1}, {2}, {3}, {1}}, {Automatic}]\
\>", "Output",
 ImageSize->{455, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->237457522]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->352112550],

Cell["\<\
SparseArray[Automatic, {5, 5}, 0, {1, {{0, 1, 1, 1, 1, 1}, {{2}}}, {1}}]\
\>", "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->579888308]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->481160516],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " affects display but not evaluation:"
}], "ExampleText",
 CellID->45936541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145860351],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//StandardForm=",
 CellID->213787217]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " to the evaluated integral:"
}], "ExampleText",
 CellID->306237246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167840055],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230844738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46625405],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//StandardForm=",
 CellID->399044607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174392104],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is two-dimensional unambiguous formatting:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->15763429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37175165],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]]], "Output",
 ImageSize->{27, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//StandardForm=",
 CellID->225878969]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " approximates ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " using keyboard characters:"
}], "ExampleText",
 CellID->457767460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52050003],

Cell[OutputFormData["\<\
E^((I*x)/n)\
\>", "\<\
 (I x)/n
E\
\>"], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//OutputForm=",
 CellID->133362446]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " is two-dimensional, but ambiguous formatting:"
}], "ExampleText",
 CellID->104493560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16589577],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]], TraditionalForm]], "Output",
 ImageSize->{23, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->141708584]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " provide one-dimensional formatting:"
}], "ExampleText",
 CellID->13054338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114959516],

Cell["E^((I*x)/n)", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->108196333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->223015926],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"E", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Complex", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//FullForm=",
 CellID->188088331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->932960539],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to generate a string in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->280553715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"a", "^", "b"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367460198],

Cell[BoxData["\<\"\\!\\(a\\^b\\)\"\>"], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82415754]
}, Open  ]],

Cell["The string includes two-dimensional markup:", "ExampleText",
 CellID->22957834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106513457],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(a\\^b\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->485229205]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert back:"
}], "ExampleText",
 CellID->53150226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33622413],

Cell[BoxData[
 SuperscriptBox["a", "b"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28561281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9785682],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"a", ",", "b"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->259014510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266200449],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " to get the box representation of an expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->143229747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69350682],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"y\"\>", ",", "\<\"3\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248756192]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert back:"
}], "ExampleText",
 CellID->36196865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->593016255],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358085427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33241170],

Cell[TextData[{
 "Add formatting via ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->810203101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "StandardForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161343839],

Cell[BoxData[
 RowBox[{"bin", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//StandardForm=",
 CellID->12485007]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"bin", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734130829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "StandardForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88224750],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwSAOxjAQDkP0fyAJj
6f//gTQXkGQBcnnBPFYQyQySBQMGFjQ+VnmCqtjQ+Mw4dTEBuexEqUbmM+DU
xYzNZSwIPqY+Jqz6wLaxwvk47MSuF8QHcaGBBQXoYYJdr8CoKhqoAvFBKY3p
P/YUhycNoKQdDqL0wdI1Jw1UE+sm9NwD8zmMJi6H8lGgCr1M4MHmEwZImcTA
CADZIoEt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{27, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//StandardForm=",
 CellID->218551827]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->37666482],

Cell["Nested roots:", "ExampleText",
 CellID->370612919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", "#"}]}], "]"}], "&"}], ",", "x", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398613320],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox["1", 
          SqrtBox[
           RowBox[{"1", "+", 
            FractionBox["1", 
             SqrtBox[
              RowBox[{"1", "+", 
               FractionBox["1", 
                SqrtBox[
                 RowBox[{"1", "+", 
                  FractionBox["1", 
                   SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    
                    FractionBox["1", 
                    "x"]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]]], "Output",
 ImageSize->{313, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174962740]
}, Open  ]],

Cell["Nested powers:", "ExampleText",
 CellID->111117125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"-", "#"}]}], "&"}], ",", "x", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->279431],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwFACxtgQDkP0fyALj
gv//gTQyyQQUZgKyQHQWWISBFUL9BwMggyEbohKqKgcLD6ceDNN5QSQLstJ4
MMUBJFmQVCeARflQeJh62TBEQsGUEJppYWBRCRSeOBGmeYMpGTTTfMCiSig8
RSJMcwRTamimOYFFdVB42jj0mmKIm4MpAzQzLcCiZig8TL2YLtQFU1ZopumB
RR1QePZEmKYMplzQTFMBi3qh8DyJME0STPmhmSYFFg1B4QUTYRo/mIpAM00A
LBqHwovFoTcdQxySCZLQzATbzZCBwsOlF5InGRgBD5TMJA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->501866476]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14180],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12417],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->30965],

Cell[TextData[ButtonBox["Reducing Expressions to Their Standard Form",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ReducingExpressionsToTheirStandardForm"]], "Tutorials",
 CellID->15175161],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"]], "Tutorials",\

 CellID->27366],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->157498705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->284942951],

Cell[TextData[ButtonBox["Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellMenu"]], "MoreAbout",
 CellID->351758164],

Cell[TextData[ButtonBox["Tokens Related to the Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellTokens"]], "MoreAbout",
 CellID->210602737],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->259166154],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->9157524],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->82598345]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StandardForm"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StandardForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 52.6406042}", "context" -> "System`", 
    "keywords" -> {
     "output formatting", "standard representation", "two-dimensional format",
       "two-dimensional input", "two-dimensional output"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StandardForm[expr] prints as the standard Mathematica two-dimensional \
representation of expr. ", "synonyms" -> {"standard form"}, "title" -> 
    "StandardForm", "type" -> "Symbol", "uri" -> "ref/StandardForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12164, 332, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46064404]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 64983, 2136}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3623, 79, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4246, 106, 4196, 83, 70, "ObjectNameGrid"],
Cell[8445, 191, 664, 21, 70, "Usage",
 CellID->22930]
}, Open  ]],
Cell[CellGroupData[{
Cell[9146, 217, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9624, 234, 428, 13, 70, "Notes",
 CellID->26146],
Cell[10055, 249, 238, 7, 70, "Notes",
 CellID->845],
Cell[10296, 258, 319, 10, 70, "Notes",
 CellID->20646],
Cell[10618, 270, 594, 20, 70, "Notes",
 CellID->29118],
Cell[11215, 292, 217, 7, 70, "Notes",
 CellID->19457],
Cell[11435, 301, 240, 7, 70, "Notes",
 CellID->14788],
Cell[11678, 310, 194, 7, 70, "Notes",
 CellID->6981],
Cell[11875, 319, 252, 8, 70, "Notes",
 CellID->21786]
}, Closed]],
Cell[CellGroupData[{
Cell[12164, 332, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46064404],
Cell[CellGroupData[{
Cell[12548, 346, 148, 5, 70, "ExampleSection",
 CellID->759991405],
Cell[12699, 353, 215, 7, 70, "ExampleText",
 CellID->50858609],
Cell[CellGroupData[{
Cell[12939, 364, 192, 7, 28, "Input",
 CellID->21849426],
Cell[13134, 373, 239, 8, 51, "Output",
 CellID->474406522]
}, Open  ]],
Cell[CellGroupData[{
Cell[13410, 386, 234, 9, 28, "Input",
 CellID->23307750],
Cell[13647, 397, 253, 8, 65, "Output",
 CellID->204501615]
}, Open  ]],
Cell[13915, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->168869160],
Cell[14043, 413, 197, 7, 70, "ExampleText",
 CellID->5423303],
Cell[CellGroupData[{
Cell[14265, 424, 181, 6, 70, "Input",
 CellID->456579029],
Cell[14449, 432, 262, 8, 121, "Output",
 CellID->19351983]
}, Open  ]],
Cell[CellGroupData[{
Cell[14748, 445, 134, 4, 70, "Input",
 CellID->108635468],
Cell[14885, 451, 13177, 221, 129, 62, 1, "CachedBoxData", "BoxData", "Output",
 
 CellID->76308404]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28111, 678, 216, 7, 70, "ExampleSection",
 CellID->27065],
Cell[CellGroupData[{
Cell[28352, 689, 234, 7, 70, "ExampleSubsection",
 CellID->230152069],
Cell[28589, 698, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[29169, 724, 283, 9, 70, "Input",
 CellID->540624369],
Cell[29455, 735, 653, 30, 51, "Output",
 CellID->272754241]
}, Open  ]],
Cell[30123, 768, 330, 13, 70, "ExampleText",
 CellID->311286961],
Cell[CellGroupData[{
Cell[30478, 785, 290, 11, 70, "Input",
 CellID->28481542],
Cell[30771, 798, 500, 19, 36, "Output",
 CellID->879302152]
}, Open  ]],
Cell[31286, 820, 61, 1, 70, "ExampleText",
 CellID->224777360],
Cell[CellGroupData[{
Cell[31372, 825, 161, 5, 70, "Input",
 CellID->70178760],
Cell[31536, 832, 487, 12, 70, "Output",
 Evaluatable->False,
 CellID->316536575]
}, Open  ]],
Cell[32038, 847, 124, 3, 70, "ExampleDelimiter",
 CellID->80999419],
Cell[32165, 852, 80, 1, 70, "ExampleText",
 CellID->220523646],
Cell[CellGroupData[{
Cell[32270, 857, 211, 7, 70, "Input",
 CellID->48683404],
Cell[32484, 866, 495, 12, 70, "Output",
 Evaluatable->False,
 CellID->470648411]
}, Open  ]],
Cell[32994, 881, 73, 1, 70, "ExampleText",
 CellID->21729394],
Cell[CellGroupData[{
Cell[33092, 886, 145, 4, 70, "Input",
 CellID->49753538],
Cell[33240, 892, 207, 5, 68, "Output",
 CellID->271314209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33496, 903, 240, 7, 70, "ExampleSubsection",
 CellID->660577078],
Cell[33739, 912, 199, 8, 70, "ExampleText",
 CellID->388790367],
Cell[CellGroupData[{
Cell[33963, 924, 296, 10, 70, "Input",
 CellID->25296522],
Cell[34262, 936, 716, 16, 70, "Output",
 Evaluatable->False,
 CellID->139880611]
}, Open  ]],
Cell[34993, 955, 123, 3, 70, "ExampleDelimiter",
 CellID->4576816],
Cell[35119, 960, 70, 1, 70, "ExampleText",
 CellID->24395000],
Cell[CellGroupData[{
Cell[35214, 965, 735, 23, 70, "Input",
 CellID->692214967],
Cell[35952, 990, 1116, 47, 58, "Output",
 CellID->774655339]
}, Open  ]],
Cell[37083, 1040, 125, 3, 70, "ExampleDelimiter",
 CellID->100925433],
Cell[37211, 1045, 69, 1, 70, "ExampleText",
 CellID->415848662],
Cell[CellGroupData[{
Cell[37305, 1050, 836, 30, 70, "Input",
 CellID->250695724],
Cell[38144, 1082, 1182, 23, 70, "Output",
 Evaluatable->False,
 CellID->19886342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39375, 1111, 241, 7, 70, "ExampleSubsection",
 CellID->745678177],
Cell[39619, 1120, 92, 1, 70, "ExampleText",
 CellID->483444329],
Cell[CellGroupData[{
Cell[39736, 1125, 287, 9, 70, "Input",
 CellID->49083534],
Cell[40026, 1136, 514, 17, 68, "Output",
 CellID->146688104]
}, Open  ]],
Cell[40555, 1156, 229, 8, 70, "ExampleText",
 CellID->252858662],
Cell[CellGroupData[{
Cell[40809, 1168, 106, 3, 70, "Input",
 CellID->152587590],
Cell[40918, 1173, 563, 19, 50, "Output",
 CellID->40133936]
}, Open  ]],
Cell[41496, 1195, 124, 3, 70, "ExampleDelimiter",
 CellID->43308889],
Cell[41623, 1200, 91, 1, 70, "ExampleText",
 CellID->65245750],
Cell[CellGroupData[{
Cell[41739, 1205, 246, 8, 70, "Input",
 CellID->151992235],
Cell[41988, 1215, 370, 13, 50, "Output",
 CellID->762722451]
}, Open  ]],
Cell[CellGroupData[{
Cell[42395, 1233, 364, 12, 70, "Input",
 CellID->298336904],
Cell[42762, 1247, 493, 17, 50, "Output",
 CellID->549604059]
}, Open  ]],
Cell[43270, 1267, 221, 8, 70, "ExampleText",
 CellID->186619138],
Cell[CellGroupData[{
Cell[43516, 1279, 105, 3, 70, "Input",
 CellID->400554568],
Cell[43624, 1284, 285, 8, 66, "Output",
 CellID->237457522]
}, Open  ]],
Cell[CellGroupData[{
Cell[43946, 1297, 105, 3, 70, "Input",
 CellID->352112550],
Cell[44054, 1302, 240, 7, 50, "Output",
 CellID->579888308]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44355, 1316, 237, 7, 70, "ExampleSection",
 CellID->481160516],
Cell[44595, 1325, 220, 7, 70, "ExampleText",
 CellID->45936541],
Cell[CellGroupData[{
Cell[44840, 1336, 193, 6, 70, "Input",
 CellID->145860351],
Cell[45036, 1344, 263, 9, 68, "Output",
 CellID->213787217]
}, Open  ]],
Cell[45314, 1356, 223, 8, 70, "ExampleText",
 CellID->306237246],
Cell[CellGroupData[{
Cell[45562, 1368, 152, 5, 70, "Input",
 CellID->167840055],
Cell[45717, 1375, 249, 9, 54, "Output",
 CellID->230844738]
}, Open  ]],
Cell[CellGroupData[{
Cell[46003, 1389, 107, 3, 70, "Input",
 CellID->46625405],
Cell[46113, 1394, 263, 9, 68, "Output",
 CellID->399044607]
}, Open  ]],
Cell[46391, 1406, 125, 3, 70, "ExampleDelimiter",
 CellID->174392104],
Cell[46519, 1411, 275, 8, 70, "ExampleText",
 CellID->15763429],
Cell[CellGroupData[{
Cell[46819, 1423, 186, 6, 70, "Input",
 CellID->37175165],
Cell[47008, 1431, 266, 8, 58, "Output",
 CellID->225878969]
}, Open  ]],
Cell[47289, 1442, 354, 12, 70, "ExampleText",
 CellID->457767460],
Cell[CellGroupData[{
Cell[47668, 1458, 184, 6, 70, "Input",
 CellID->52050003],
Cell[47855, 1466, 217, 10, 65, "Output",
 CellID->133362446]
}, Open  ]],
Cell[48087, 1479, 237, 7, 70, "ExampleText",
 CellID->104493560],
Cell[CellGroupData[{
Cell[48349, 1490, 189, 6, 70, "Input",
 CellID->16589577],
Cell[48541, 1498, 300, 9, 58, "Output",
 CellID->141708584]
}, Open  ]],
Cell[48856, 1510, 343, 12, 70, "ExampleText",
 CellID->13054338],
Cell[CellGroupData[{
Cell[49224, 1526, 184, 6, 70, "Input",
 CellID->114959516],
Cell[49411, 1534, 170, 5, 50, "Output",
 CellID->108196333]
}, Open  ]],
Cell[CellGroupData[{
Cell[49618, 1544, 183, 6, 70, "Input",
 CellID->223015926],
Cell[49804, 1552, 579, 20, 50, "Output",
 CellID->188088331]
}, Open  ]],
Cell[50398, 1575, 125, 3, 70, "ExampleDelimiter",
 CellID->932960539],
Cell[50526, 1580, 344, 13, 70, "ExampleText",
 CellID->280553715],
Cell[CellGroupData[{
Cell[50895, 1597, 162, 5, 70, "Input",
 CellID->367460198],
Cell[51060, 1604, 178, 5, 36, "Output",
 CellID->82415754]
}, Open  ]],
Cell[51253, 1612, 85, 1, 70, "ExampleText",
 CellID->22957834],
Cell[CellGroupData[{
Cell[51363, 1617, 104, 3, 70, "Input",
 CellID->106513457],
Cell[51470, 1622, 310, 11, 50, "Output",
 CellID->485229205]
}, Open  ]],
Cell[51795, 1636, 210, 8, 70, "ExampleText",
 CellID->53150226],
Cell[CellGroupData[{
Cell[52030, 1648, 107, 3, 70, "Input",
 CellID->33622413],
Cell[52140, 1653, 180, 6, 36, "Output",
 CellID->28561281]
}, Open  ]],
Cell[CellGroupData[{
Cell[52357, 1664, 102, 3, 70, "Input",
 CellID->9785682],
Cell[52462, 1669, 347, 13, 50, "Output",
 CellID->259014510]
}, Open  ]],
Cell[52824, 1685, 125, 3, 70, "ExampleDelimiter",
 CellID->266200449],
Cell[52952, 1690, 368, 13, 70, "ExampleText",
 CellID->143229747],
Cell[CellGroupData[{
Cell[53345, 1707, 210, 7, 70, "Input",
 CellID->69350682],
Cell[53558, 1716, 428, 13, 36, "Output",
 CellID->248756192]
}, Open  ]],
Cell[54001, 1732, 210, 8, 70, "ExampleText",
 CellID->36196865],
Cell[CellGroupData[{
Cell[54236, 1744, 108, 3, 70, "Input",
 CellID->593016255],
Cell[54347, 1749, 228, 8, 36, "Output",
 CellID->358085427]
}, Open  ]],
Cell[54590, 1760, 124, 3, 70, "ExampleDelimiter",
 CellID->33241170],
Cell[54717, 1765, 198, 8, 70, "ExampleText",
 CellID->810203101],
Cell[CellGroupData[{
Cell[54940, 1777, 158, 5, 70, "Input",
 CellID->161343839],
Cell[55101, 1784, 223, 7, 50, "Output",
 CellID->12485007]
}, Open  ]],
Cell[55339, 1794, 359, 12, 70, "Input",
 CellID->734130829],
Cell[CellGroupData[{
Cell[55723, 1810, 157, 5, 70, "Input",
 CellID->88224750],
Cell[55883, 1817, 477, 12, 70, "Output",
 Evaluatable->False,
 CellID->218551827]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56409, 1835, 227, 7, 70, "ExampleSection",
 CellID->37666482],
Cell[56639, 1844, 56, 1, 70, "ExampleText",
 CellID->370612919],
Cell[CellGroupData[{
Cell[56720, 1849, 242, 9, 70, "Input",
 CellID->398613320],
Cell[56965, 1860, 1112, 37, 176, "Output",
 CellID->174962740]
}, Open  ]],
Cell[58092, 1900, 57, 1, 70, "ExampleText",
 CellID->111117125],
Cell[CellGroupData[{
Cell[58174, 1905, 196, 7, 70, "Input",
 CellID->279431],
Cell[58373, 1914, 565, 13, 70, "Output",
 Evaluatable->False,
 CellID->501866476]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58999, 1934, 311, 9, 70, "SeeAlsoSection",
 CellID->14180],
Cell[59313, 1945, 1455, 53, 70, "SeeAlso",
 CellID->13667]
}, Open  ]],
Cell[CellGroupData[{
Cell[60805, 2003, 314, 9, 70, "TutorialsSection",
 CellID->12417],
Cell[61122, 2014, 157, 3, 70, "Tutorials",
 CellID->30965],
Cell[61282, 2019, 198, 4, 70, "Tutorials",
 CellID->15175161],
Cell[61483, 2025, 179, 4, 70, "Tutorials",
 CellID->27366],
Cell[61665, 2031, 183, 4, 70, "Tutorials",
 CellID->157498705]
}, Open  ]],
Cell[CellGroupData[{
Cell[61885, 2040, 319, 9, 70, "MoreAboutSection",
 CellID->284942951],
Cell[62207, 2051, 129, 3, 70, "MoreAbout",
 CellID->351758164],
Cell[62339, 2056, 153, 3, 70, "MoreAbout",
 CellID->210602737],
Cell[62495, 2061, 193, 4, 70, "MoreAbout",
 CellID->259166154],
Cell[62691, 2067, 147, 3, 70, "MoreAbout",
 CellID->9157524],
Cell[62841, 2072, 158, 3, 70, "MoreAbout",
 CellID->82598345]
}, Open  ]],
Cell[CellGroupData[{
Cell[63036, 2080, 305, 8, 70, "RelatedLinksSection"],
Cell[63344, 2090, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[63749, 2106, 50, 0, 70, "History"],
Cell[63802, 2108, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

