(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15043,        453]
NotebookOptionsPosition[     12445,        369]
NotebookOutlinePosition[     13803,        406]
CellTagsIndexPosition[     13718,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], 
         "MaxStepFraction" :> 
         Documentation`HelpLookup["paclet:ref/MaxStepFraction"], "MaxSteps" :> 
         Documentation`HelpLookup["paclet:ref/MaxSteps"], "PlotPoints" :> 
         Documentation`HelpLookup["paclet:ref/PlotPoints"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"NDSolve\"\>", 
      2->"\<\"MaxStepFraction\"\>", 3->"\<\"MaxSteps\"\>", 
      4->"\<\"PlotPoints\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StartingStepSize", "ObjectName",
 CellID->25318],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["StartingStepSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " and related functions that specifies the initial step size to use in \
trying to generate results."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11828781],

Cell[TextData[{
 "Specify the step size for ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to use for starting the integration of an ODE:"
}], "ExampleText",
 CellID->125153368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"0.001", " ", 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"t", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", " ", "t"}], "]"}], " ", 
        RowBox[{"UnitStep", "[", 
         RowBox[{"1", "-", "t"}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "25000"}], "}"}], ",", 
    RowBox[{"StartingStepSize", "\[Rule]", "0.1"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28399837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "25000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{339, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->935262952]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->161328313],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->723096048]
}, Open  ]],

Cell["\<\
Without this specification, features at the beginning of the interval may be \
missed:\
\>", "ExampleText",
 CellID->328118826],

Cell[BoxData[
 RowBox[{
  RowBox[{"zsol", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"0.001", " ", 
          RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
        RowBox[{"t", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Pi]", " ", "t"}], "]"}], " ", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"1", "-", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "25000"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->153292946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "25000"}], "}"}], ",", "1000"}], "]"}], "]"}], "/.",
     "zsol"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->155833943],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25608869]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16991],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxStepFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31461]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StartingStepSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 58.0782434}", "context" -> "System`", 
    "keywords" -> {"initial step size", "step control", "step size control"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StartingStepSize is an option to NDSolve and related functions that \
specifies the initial step size to use in trying to generate results.", 
    "synonyms" -> {"starting step size"}, "title" -> "StartingStepSize", 
    "type" -> "Symbol", "uri" -> "ref/StartingStepSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2258, 73, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13584, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 884, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1507, 46, 54, 1, 70, "ObjectName",
 CellID->25318],
Cell[1564, 49, 657, 19, 70, "Usage",
 CellID->26611]
}, Open  ]],
Cell[CellGroupData[{
Cell[2258, 73, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2635, 87, 147, 5, 70, "ExampleSection",
 CellID->11828781],
Cell[2785, 94, 253, 8, 70, "ExampleText",
 CellID->125153368],
Cell[CellGroupData[{
Cell[3063, 106, 877, 27, 47, "Input",
 CellID->28399837],
Cell[3943, 135, 470, 17, 36, "Output",
 CellID->935262952]
}, Open  ]],
Cell[CellGroupData[{
Cell[4450, 157, 292, 9, 28, "Input",
 CellID->161328313],
Cell[4745, 168, 4767, 82, 123, "Output",
 Evaluatable->False,
 CellID->723096048]
}, Open  ]],
Cell[9527, 253, 137, 4, 70, "ExampleText",
 CellID->328118826],
Cell[9667, 259, 864, 28, 70, "Input",
 CellID->153292946],
Cell[CellGroupData[{
Cell[10556, 291, 323, 11, 70, "Input",
 CellID->155833943],
Cell[10882, 304, 159, 5, 36, "Output",
 CellID->25608869]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11102, 316, 311, 9, 70, "SeeAlsoSection",
 CellID->16991],
Cell[11416, 327, 957, 35, 70, "SeeAlso",
 CellID->31461]
}, Open  ]],
Cell[12388, 365, 27, 0, 70, "History"],
Cell[12418, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

