(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35025,       1282]
NotebookOptionsPosition[     27707,       1028]
NotebookOutlinePosition[     29088,       1067]
CellTagsIndexPosition[     29002,       1062]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], 
          "EulerGamma" :> 
          Documentation`HelpLookup["paclet:ref/EulerGamma"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Zeta\"\>", 
       2->"\<\"EulerGamma\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Zeta Functions & Polylogarithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/ZetaFunctionsAndPolylogarithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematical Constants\"\>", 
       2->"\<\"Zeta Functions & Polylogarithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StieltjesGamma", "ObjectName",
 CellID->29107],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StieltjesGamma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StieltjesGamma"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Stieltjes constant ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Gamma]", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "n"], "/", 
    RowBox[{"n", "!"}]}], TraditionalForm]], "InlineMath"],
 " is the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "s"}], ")"}], "n"], TraditionalForm]], "InlineMath"],
 " in the Laurent expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7851],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]], "InlineMath"],
 " are generalizations of Euler's constant; ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "=", 
    SubscriptBox["\[Gamma]", "0"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->28258],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->809858622],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300204090],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->590325967],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->299233259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"StieltjesGamma", "[", "1", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349315483],

Cell[BoxData[
 RowBox[{"-", 
  "0.0728158454836767248605863758749013191377363383343379525989699247866`50.\
00000000000001"}]], "Output",
 ImageSize->{383, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234339621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46818659],

Cell[TextData[{
 "Plot values of ",
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->270209595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StieltjesGamma", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "25"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314244588],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWL1v00AUv8R2+kGlKgghmiYksLQTsFSdKgYCDMCChBAbUYWUDlBUOrOx
tVMnEAsSIMEEQiITDCAkmFhZwz9y3Nl3Od/Pzx+J7TQiUuK8d+/7vd/57Fu9
/f6Dh739ne1e5/pe73F/Z/tJ59runmA5FcbYUHyfnmHiPxf//O+Qc3E9J38d
Sfsf9mUiblUwv05ZM83enKIckNU8ea2Kq1yqkfZ8rmu4jLnyUgtzgt8q+gAa
YwjsB+zgI6Nh3simWsjjT5K58yiqNt6IrzI7norrmahxMxs4B7M4y+WjwNXj
l7cnBJ+2m3P6j2WiCsEUYbeouBnhbzwkOMDPP88ffPrN69+Xt54fHnxniyMp
af+jv3r3zluxevXKy9Bq1Mavn393H30afP4TIzU5ct5BjPUEKRNr3fL3HmKs
W3VOwp+eLMTJAKJyJpmMVJwMICsFyxLQKZ0OoErl5DRD96iMVsvA41lV87a6
VpWNlqKDwPWnyYO7gJbStC1lo/c8eDzJ7Ymdj9QKd6dVoBEnjVAN4/e4Zcpv
aE90QX6OrBfSQTYGGfmzWU21sAw+F1IsjpOJQV3+TJpQYToP2LET7oJ0Hm1u
ZpF5o/6GfVpZtGyO0m6nxNoEuhqZ8w5VHW/UpeR4IjuAz81wUlhJ7dICWbWO
inqJ26hYgp6E95eWuro8fL8yuqe5vR+hPB3JBW5P8yZYdWHdhfWu1YWLEP8m
qW3W0XqXjLEPWieAprW6EGkD6HsJWiaiBtArYGXLtyL38W/CSIW0iXsb0niq
SJOftr2i7Tu6f4Il+4f322z6oieCJXuC8YwbX5XsWhqN+KOxHK+/qKugpvgU
rBu8SmTd1DnH4NCD9ftkTjfAJ+LPg/V18LJBWr0NWpfAKq31DLQ2rHwPwTPm
u0baPCCrZOgkLayKodesyMY5361B1EcJUibKI8vfOkQTrM7z7E8tOO/mPJvn
lEy/MyjCqnmGn90Yp2VV9znuqcPj/9v7sCyTrd+HFTLZBH86iMGzxKtJvCSc
2PU708CP2V/K8BPNy+xYefyxDP6LQEoHevEiQcpUMknK5G+kZgOpWRHmRKpW
3sxMhLBp2mczeW8auwJxKNH9/uFLDSO/rPIPzabYGA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622564840]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->334853570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->290764101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StieltjesGamma", "[", "n", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350610411],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["\[Gamma]",
    StieltjesGamma], "n"], TraditionalForm]], "Output",
 ImageSize->{16, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->43186988]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->136688911],

Cell["Expansion of the Riemann zeta function:", "ExampleText",
 CellID->587216185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "s", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640252272],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"s", "-", "1"}]], "+", "EulerGamma", "-", 
   RowBox[{
    RowBox[{"StieltjesGamma", "[", "1", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"s", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"StieltjesGamma", "[", "2", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"StieltjesGamma", "[", "3", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"StieltjesGamma", "[", "4", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"s", "-", "1"}], "]"}], "5"],
    SeriesData[$CellContext`s, 1, {}, -1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`s, 1, {
   1, EulerGamma, -StieltjesGamma[1], Rational[1, 2] StieltjesGamma[2], 
    Rational[-1, 6] StieltjesGamma[3], Rational[1, 24] StieltjesGamma[4]}, -1,
    5, 1],
  Editable->False]], "Output",
 ImageSize->{498, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5413324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343360261],

Cell["\<\
Test Li\[CloseCurlyQuote]s criterion for the Riemann hypothesis:\
\>", "ExampleText",
 CellID->65974969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}], "!"}]}], " ", 
        RowBox[{"D", "[", " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["s", 
            RowBox[{"n", "-", "1"}]], " ", 
           RowBox[{"Log", "[", 
            FractionBox[
             RowBox[{"s", " ", 
              RowBox[{"(", 
               RowBox[{"s", "-", "1"}], ")"}], " ", 
              RowBox[{"Gamma", "[", 
               FractionBox["s", "2"], "]"}], " ", 
              RowBox[{"Zeta", "[", "s", "]"}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Pi]", 
               RowBox[{"s", "/", "2"}]]}]], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "n"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"s", "->", "1"}]}], "]"}], " ", "//", "FullSimplify"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77114602],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       TagBox["\[DoubledGamma]",
        Function[{}, EulerGamma]], "-", 
       RowBox[{"log", "(", 
        RowBox[{"4", " ", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"1", "+", 
     TagBox["\[DoubledGamma]",
      Function[{}, EulerGamma]], "-", 
     SuperscriptBox[
      TagBox["\[DoubledGamma]",
       Function[{}, EulerGamma]], "2"], "+", 
     FractionBox[
      SuperscriptBox["\[Pi]", "2"], "8"], "-", 
     RowBox[{"log", "(", 
      RowBox[{"4", " ", "\[Pi]"}], ")"}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox[
       TagBox["\[Gamma]",
        StieltjesGamma], "1"]}]}], ",", 
    RowBox[{
     FractionBox["1", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"log", "(", "8", ")"}]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"log", "(", "\[Pi]", ")"}]}], "-", 
       RowBox[{"48", " ", 
        SubscriptBox[
         TagBox["\[Gamma]",
          StieltjesGamma], "1"]}], "+", 
       RowBox[{"4", " ", 
        TagBox["\[DoubledGamma]",
         Function[{}, EulerGamma]], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", 
             TagBox["\[DoubledGamma]",
              Function[{}, EulerGamma]]}], ")"}], " ", 
           TagBox["\[DoubledGamma]",
            Function[{}, EulerGamma]]}], "+", 
          RowBox[{"6", " ", 
           SubscriptBox[
            TagBox["\[Gamma]",
             StieltjesGamma], "1"]}]}], ")"}]}], "+", 
       RowBox[{"12", " ", 
        SubscriptBox[
         TagBox["\[Gamma]",
          StieltjesGamma], "2"]}], "-", 
       RowBox[{"7", " ", 
        TagBox[
         RowBox[{"\[Zeta]", "(", 
          TagBox["3",
           Zeta,
           Editable->True,
           Selectable->True], ")"}],
         InterpretTemplate[
          Function[BoxForm`e$, 
           Zeta[BoxForm`e$]]],
         Editable->False,
         Selectable->False]}]}], ")"}]}]}], "}"}], TraditionalForm]], "Output",\

 ImageSize->{452, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->372916291]
}, Open  ]],

Cell["All values should be positive:", "ExampleText",
 CellID->162908672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->905144146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.02309570896612101`", ",", "0.09234573522804657`", ",", 
   "0.2076389205543243`"}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->308410912]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->288957526],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " case evaluates automatically:"
}], "ExampleText",
 CellID->589806803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StieltjesGamma", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92196725],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21944550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95713361],

Cell["Various symbolic relations are automatically used:", "ExampleText",
 CellID->79656462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", " ", "<", " ", 
  RowBox[{"StieltjesGamma", "[", "10", "]"}], "<", 
  RowBox[{"10", "^", 
   RowBox[{"-", "3"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153219622],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250679924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"StieltjesGamma", "[", "n", "]"}], "]"}], "<", 
    RowBox[{"2", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", " ", "-", " ", "1"}], ")"}], "!"}], "/", 
      RowBox[{"Pi", "^", "n"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421024153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72101172]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->494950945],

Cell[TextData[{
 "Substitution of derivatives of ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " at",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "1"}], TraditionalForm]], "InlineMath"],
 " yields indeterminate values:"
}], "ExampleText",
 CellID->402950162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", "3", "]"}], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Zeta", "[", "#", "]"}], "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", "#"}], ")"}]}]}], ")"}], "&"}], "]"}], "[", "1", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49435864],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\^4\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->238084358],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(ComplexInfinity + \
ComplexInfinity\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->14982110],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56368018]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " to obtain the expansion coefficient:"
}], "ExampleText",
 CellID->46230630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "3", "]"}], "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Zeta", "[", "#", "]"}], "+", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}]}]}], ")"}], "&"}], "]"}], "[", "s", 
    "]"}], ",", 
   RowBox[{"s", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90549129],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"StieltjesGamma", "[", "3", "]"}]}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180530754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->358047126],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 " must be an exact non-negative integer:"
}], "ExampleText",
 CellID->2577793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StieltjesGamma", "[", "2.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399412916],

Cell[BoxData[
 RowBox[{
  RowBox[{"StieltjesGamma", "::", "\<\"intnm\"\>"}], ":", 
  " ", "\<\"Non-negative machine-size integer expected at position \\!\\(1\\) \
in \\!\\(StieltjesGamma[2.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/intnm\\\", ButtonNote -> \
\\\"StieltjesGamma::intnm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->125558398],

Cell[BoxData[
 RowBox[{"StieltjesGamma", "[", "2.`", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625690634]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to obtain a numerical approximation:"
}], "ExampleText",
 CellID->1040941825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"StieltjesGamma", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532645693],

Cell[BoxData[
 RowBox[{"-", "0.00969036319287232`"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159624577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134966373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StieltjesGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFormula"],
 " does not allow numericalization of its arguments:"
}], "ExampleText",
 CellID->281209369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"StieltjesGamma", "[", 
   RowBox[{"2", "n"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330081837],

Cell[BoxData[
 RowBox[{"StieltjesGamma", "[", 
  RowBox[{"2", " ", "n"}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47394852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64646239],

Cell["\<\
It is currently not known if Stieltjes constants are algebraic numbers:\
\>", "ExampleText",
 CellID->362772051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"StieltjesGamma", "[", "2", "]"}], ",", "Algebraics"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278497045],

Cell[BoxData[
 RowBox[{
  RowBox[{"StieltjesGamma", "[", "2", "]"}], "\[Element]", 
  "Algebraics"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271904601]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19304],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerGamma"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->410],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->8940],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#27217"], None}]], "RelatedLinks",
 CellID->64429998],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/StieltjesContants.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ZetaFunctionsandPolylogarithms/\
StieltjesGamma/"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StieltjesGamma"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1522774],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->4717598],

Cell[TextData[ButtonBox["Zeta Functions & Polylogarithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ZetaFunctionsAndPolylogarithms"]], "MoreAbout",
 CellID->6829659]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StieltjesGamma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 17.7349966}", "context" -> "System`", 
    "keywords" -> {
     "Euler's constant", "generalization of Euler's constant", 
      "harmonic sums", "Keiper's algorithm", "Stieltjes constants", 
      "Stieltjes gamma"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StieltjesGamma[n] gives the Stieltjes constant \\[Gamma]_n. ", 
    "synonyms" -> {"stieltjes gamma"}, "title" -> "StieltjesGamma", "type" -> 
    "Symbol", "uri" -> "ref/StieltjesGamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5606, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->300204090]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28859, 1055}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2013, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2636, 77, 52, 1, 70, "ObjectName",
 CellID->29107],
Cell[2691, 80, 600, 19, 70, "Usage",
 CellID->26365]
}, Open  ]],
Cell[CellGroupData[{
Cell[3328, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3806, 121, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3929, 127, 599, 22, 70, "Notes",
 CellID->7851],
Cell[4531, 151, 326, 12, 70, "Notes",
 CellID->28258],
Cell[4860, 165, 260, 8, 70, "Notes",
 CellID->809858622],
Cell[5123, 175, 230, 7, 70, "Notes",
 CellID->31226],
Cell[5356, 184, 213, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5606, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300204090],
Cell[CellGroupData[{
Cell[5991, 210, 148, 5, 70, "ExampleSection",
 CellID->590325967],
Cell[6142, 217, 70, 1, 70, "ExampleText",
 CellID->299233259],
Cell[CellGroupData[{
Cell[6237, 222, 163, 5, 28, "Input",
 CellID->349315483],
Cell[6403, 229, 267, 8, 36, "Output",
 CellID->234339621]
}, Open  ]],
Cell[6685, 240, 124, 3, 70, "ExampleDelimiter",
 CellID->46818659],
Cell[6812, 245, 211, 8, 70, "ExampleText",
 CellID->270209595],
Cell[CellGroupData[{
Cell[7048, 257, 265, 8, 28, "Input",
 CellID->314244588],
Cell[7316, 267, 1355, 26, 147, "Output",
 Evaluatable->False,
 CellID->622564840]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8720, 299, 220, 7, 70, "ExampleSection",
 CellID->334853570],
Cell[8943, 308, 203, 7, 70, "ExampleText",
 CellID->290764101],
Cell[CellGroupData[{
Cell[9171, 319, 151, 5, 70, "Input",
 CellID->350610411],
Cell[9325, 326, 263, 9, 50, "Output",
 CellID->43186988]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9637, 341, 227, 7, 70, "ExampleSection",
 CellID->136688911],
Cell[9867, 350, 82, 1, 70, "ExampleText",
 CellID->587216185],
Cell[CellGroupData[{
Cell[9974, 355, 216, 7, 70, "Input",
 CellID->640252272],
Cell[10193, 364, 1356, 42, 81, "Output",
 CellID->5413324]
}, Open  ]],
Cell[11564, 409, 125, 3, 70, "ExampleDelimiter",
 CellID->343360261],
Cell[11692, 414, 114, 3, 70, "ExampleText",
 CellID->65974969],
Cell[CellGroupData[{
Cell[11831, 421, 1153, 35, 70, "Input",
 CellID->77114602],
Cell[12987, 458, 2411, 78, 108, "Output",
 CellID->372916291]
}, Open  ]],
Cell[15413, 539, 73, 1, 70, "ExampleText",
 CellID->162908672],
Cell[CellGroupData[{
Cell[15511, 544, 97, 3, 70, "Input",
 CellID->905144146],
Cell[15611, 549, 277, 9, 36, "Output",
 CellID->308410912]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15937, 564, 237, 7, 70, "ExampleSection",
 CellID->288957526],
Cell[16177, 573, 220, 8, 70, "ExampleText",
 CellID->589806803],
Cell[CellGroupData[{
Cell[16422, 585, 109, 3, 70, "Input",
 CellID->92196725],
Cell[16534, 590, 166, 5, 36, "Output",
 CellID->21944550]
}, Open  ]],
Cell[16715, 598, 124, 3, 70, "ExampleDelimiter",
 CellID->95713361],
Cell[16842, 603, 92, 1, 70, "ExampleText",
 CellID->79656462],
Cell[CellGroupData[{
Cell[16959, 608, 197, 6, 70, "Input",
 CellID->153219622],
Cell[17159, 616, 161, 5, 36, "Output",
 CellID->250679924]
}, Open  ]],
Cell[CellGroupData[{
Cell[17357, 626, 436, 15, 70, "Input",
 CellID->421024153],
Cell[17796, 643, 251, 8, 36, "Output",
 CellID->72101172]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18096, 657, 230, 7, 70, "ExampleSection",
 CellID->494950945],
Cell[18329, 666, 336, 13, 70, "ExampleText",
 CellID->402950162],
Cell[CellGroupData[{
Cell[18690, 683, 354, 13, 70, "Input",
 CellID->49435864],
Cell[19047, 698, 371, 7, 70, "Message",
 CellID->238084358],
Cell[19421, 707, 413, 8, 70, "Message",
 CellID->14982110],
Cell[19837, 717, 169, 5, 36, "Output",
 CellID->56368018]
}, Open  ]],
Cell[20021, 725, 216, 8, 70, "ExampleText",
 CellID->46230630],
Cell[CellGroupData[{
Cell[20262, 737, 455, 16, 70, "Input",
 CellID->90549129],
Cell[20720, 755, 217, 7, 36, "Output",
 CellID->180530754]
}, Open  ]],
Cell[20952, 765, 125, 3, 70, "ExampleDelimiter",
 CellID->358047126],
Cell[21080, 770, 247, 8, 70, "ExampleText",
 CellID->2577793],
Cell[CellGroupData[{
Cell[21352, 782, 111, 3, 70, "Input",
 CellID->399412916],
Cell[21466, 787, 441, 8, 70, "Message",
 CellID->125558398],
Cell[21910, 797, 201, 6, 36, "Output",
 CellID->625690634]
}, Open  ]],
Cell[22126, 806, 210, 8, 70, "ExampleText",
 CellID->1040941825],
Cell[CellGroupData[{
Cell[22361, 818, 138, 4, 70, "Input",
 CellID->532645693],
Cell[22502, 824, 194, 6, 36, "Output",
 CellID->159624577]
}, Open  ]],
Cell[22711, 833, 125, 3, 70, "ExampleDelimiter",
 CellID->134966373],
Cell[22839, 838, 239, 7, 70, "ExampleText",
 CellID->281209369],
Cell[CellGroupData[{
Cell[23103, 849, 157, 5, 70, "Input",
 CellID->330081837],
Cell[23263, 856, 221, 7, 36, "Output",
 CellID->47394852]
}, Open  ]],
Cell[23499, 866, 124, 3, 70, "ExampleDelimiter",
 CellID->64646239],
Cell[23626, 871, 122, 3, 70, "ExampleText",
 CellID->362772051],
Cell[CellGroupData[{
Cell[23773, 878, 180, 6, 70, "Input",
 CellID->278497045],
Cell[23956, 886, 243, 8, 36, "Output",
 CellID->271904601]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24260, 901, 311, 9, 70, "SeeAlsoSection",
 CellID->19304],
Cell[24574, 912, 447, 17, 70, "SeeAlso",
 CellID->24245]
}, Open  ]],
Cell[CellGroupData[{
Cell[25058, 934, 312, 9, 70, "TutorialsSection",
 CellID->410],
Cell[25373, 945, 144, 3, 70, "Tutorials",
 CellID->30600]
}, Open  ]],
Cell[CellGroupData[{
Cell[25554, 953, 320, 9, 70, "RelatedLinksSection",
 CellID->8940],
Cell[25877, 964, 270, 6, 70, "RelatedLinks",
 CellID->64429998],
Cell[26150, 972, 188, 4, 70, "RelatedLinks"],
Cell[26341, 978, 215, 4, 70, "RelatedLinks"],
Cell[26559, 984, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26988, 1002, 317, 9, 70, "MoreAboutSection",
 CellID->1522774],
Cell[27308, 1013, 153, 3, 70, "MoreAbout",
 CellID->4717598],
Cell[27464, 1018, 171, 3, 70, "MoreAbout",
 CellID->6829659]
}, Open  ]],
Cell[27650, 1024, 27, 0, 70, "History"],
Cell[27680, 1026, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

