(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40318,       1349]
NotebookOptionsPosition[     33111,       1099]
NotebookOutlinePosition[     34537,       1138]
CellTagsIndexPosition[     34451,       1133]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StirlingS2" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS2"], "NorlundB" :> 
          Documentation`HelpLookup["paclet:ref/NorlundB"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StirlingS2\"\>", 
       2->"\<\"NorlundB\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 3->"\<\"Integer Functions\"\>", 
       4->"\<\"Mathematical Functions\"\>", 
       5->"\<\"Number Theoretic Functions\"\>", 
       6->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StirlingS1", "ObjectName",
 CellID->17589],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StirlingS1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StirlingS1"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Stirling number of the first kind ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["S", "n", 
        RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"n", "-", "m"}]], 
    SubsuperscriptBox["S", "n", 
     RowBox[{"(", "m", ")"}]]}], TraditionalForm]], "InlineMath"],
 " gives the number of permutations of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements which contain exactly ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " cycles. "
}], "Notes",
 CellID->9925],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS1"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->25144825]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3183605],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->403575173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS1", "[", 
  RowBox[{"50", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20126521],

Cell[BoxData[
 RowBox[{"-", 
  "608281864034267560872252163321295376887552831379210240000000000"}]], \
"Output",
 ImageSize->{496, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536584472]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12089],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS1"]], "InlineFormula"],
 " threads element\[Dash]wise over lists:"
}], "ExampleText",
 CellID->144264457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134763362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "11", ",", "274"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489037501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235648017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->56099227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS1", "[", 
   RowBox[{"n", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70202900],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   TagBox["S",
    StirlingS1], "n", 
   RowBox[{"(", "m", ")"}]], TraditionalForm]], "Output",
 ImageSize->{25, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->644396616]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8738],

Cell["\<\
Plot Stirling numbers of the first kind on a logarithmic scale:\
\>", "ExampleText",
 CellID->135223939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"StirlingS1", "[", 
        RowBox[{"n", ",", "m"}], "]"}], "]"}], "+", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "60"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"m", ",", " ", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36884709],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184698318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325555284],

Cell["\<\
Plot the average number of cycles in symmetric group elements:\
\>", "ExampleText",
 CellID->113925860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"k", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "k"}], ")"}]}], " ", 
        RowBox[{"StirlingS1", "[", 
         RowBox[{"n", ",", " ", "k"}], "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"k", ",", " ", "n"}], "}"}]}], "]"}], "/", 
     RowBox[{"n", "!"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", " ", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168747835],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 1.5}, {3., 1.8333333333333333`}, {4., 
     2.0833333333333335`}, {5., 2.283333333333333}, {6., 2.45}, {7., 
     2.592857142857143}, {8., 2.717857142857143}, {9., 2.828968253968254}, {
     10., 2.9289682539682538`}, {11., 3.019877344877345}, {12., 
     3.103210678210678}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 12.}, {1., 3.103210678210678}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440168825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27050],

Cell["Generate values from the generating function:", "ExampleText",
 CellID->457408841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"-", "t"}], ",", "12"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194530595],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"39916800", " ", "t"}]}], "+", 
   RowBox[{"120543840", " ", 
    SuperscriptBox["t", "2"]}], "-", 
   RowBox[{"150917976", " ", 
    SuperscriptBox["t", "3"]}], "+", 
   RowBox[{"105258076", " ", 
    SuperscriptBox["t", "4"]}], "-", 
   RowBox[{"45995730", " ", 
    SuperscriptBox["t", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "6"],
    SeriesData[$CellContext`t, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {-39916800, 120543840, -150917976, 
   105258076, -45995730}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67089988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StirlingS1", "[", 
    RowBox[{"12", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134792640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "39916800"}], ",", "120543840", ",", 
   RowBox[{"-", "150917976"}], ",", "105258076", ",", 
   RowBox[{"-", "45995730"}]}], "}"}]], "Output",
 ImageSize->{409, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21633973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24797867],

Cell["\<\
Stirling numbers of the first kind are effectively inverses of Stirling \
numbers of the second kind:\
\>", "ExampleText",
 CellID->218402307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"StirlingS1", "[", 
       RowBox[{"m", ",", "l"}], "]"}], " ", 
      RowBox[{"StirlingS2", "[", 
       RowBox[{"l", ",", "n"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "0", ",", 
       RowBox[{
        RowBox[{"Max", "[", 
         RowBox[{"n", ",", "m"}], "]"}], "+", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788227672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{377, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160933105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185535181],

Cell["\<\
Calculate large Stirling numbers of the first kind using Cauchy\
\[CloseCurlyQuote]s theorem:\
\>", "ExampleText",
 CellID->103102577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "100"}], ",", 
     RowBox[{"m", "=", "11"}], ",", 
     RowBox[{"\[Rho]", "=", "1"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "m"}], " ", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Pochhammer", "[", 
             RowBox[{
              RowBox[{"1", "+", "x"}], ",", 
              RowBox[{"n", "-", "1"}]}], "]"}], "/", 
            RowBox[{"x", "^", "m"}]}], "  ", "\[Rho]", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}], "/.", 
          RowBox[{"x", "\[Rule]", " ", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[CurlyPhi]", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "Pi"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38264963],

Cell[BoxData[
 RowBox[{"-", "3.90376773476619`*^155"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->642634176]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS1", "[", 
   RowBox[{"100", ",", "11"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44712849],

Cell[BoxData[
 RowBox[{"-", "3.903767734763898`*^155"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->393560065]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS1"]], "InlineFormula"],
 " can have large values for moderately sized arguments:"
}], "ExampleText",
 CellID->288872411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS1", "[", 
   RowBox[{"1000", ",", " ", "600"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138196488],

Cell[BoxData[
 TagBox[
  RowBox[{"40999738089307874277928755567377270", 
   RowBox[{"\[LeftSkeleton]", "1287", "\[RightSkeleton]"}], 
   "79537458006861662947374493898306945"}],
  Short]], "Output",
 ImageSize->{339, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->70541154]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46300917],

Cell[BoxData["4.09997380893078742779287556`15.954589770191005*^1356"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159881457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127422742],

Cell[TextData[{
 "The value at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "=", "0"}], ",", 
    RowBox[{"m", "=", "0"}]}], TraditionalForm]], "InlineMath"],
 " is defined to be 1:"
}], "ExampleText",
 CellID->75747374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS1", "[", 
  RowBox[{"0", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67282836],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622056582]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23619],

Cell["Plot sums of digits:", "ExampleText",
 CellID->173507766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"StirlingS1", "[", 
       RowBox[{"n", ",", "m"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "36"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "36"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155386529],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyF0M1rE0EYBvDgreApBy97UtaLEA9Ct1KUlZbA1GJgiiBODZQOFEO3RmOH
BGrXppSsrsauTQ2ZZJuQtQmlG0PTbpKmJhppM3+Xm/TDfiTmgdnD8uN93pmb
0/6J6WsOh4M/OYID8E7exTtdA4PCdc6NhgWAJOgliGBlmcatXKMliBzv4jjO
NcDfHbr18NGY2+P2TPlCYW8oFk5sVyp7LSYAlx2nk3c4R++Mjs8JbtEDAzhE
YrJK07mdgxZjiOd4jhMHhJEb/PCD28gDPJJP9pIQ0aNpc6dqEyYCEQJeEAfc
9waHhiAY93sCiKwEwrocy5f32oRBQQCiyEHB/XhqDCLoxT4s44ASNozibmcK
Y4BHUHTZ5/7IpADgU+STibRCYpph7h4cEyYhhKEoIHFsEiKEngWIosiqSg3D
rJ8QZv8HIi8CMAERkLCHSFTRYjYxrFPCCIQQEIQnMbK/PmxP0XKaYVmNM8Jk
iWAAAY7Mz87PPn8VDC6tfUwksvX6P8IIhhLCCD+ZCfrm6aL6JpMy0sXK4TnC
MLYBcr+UXvgXoxHlW2wtmjZ+VM8TuwsjCftfzy0FQyvLX7OrcVr+Wb9AmKIQ
gpD37cwSUdV34YgW1/ebFwnTZJkQ/C4aVGLyl0zWyJj7h5cIo3I7q9MLUVXd
TOl6qVS/TOw5iqYoETmqqTSlFY1S4wphiqYROUIXaJimqG4edCEdo73/sP4p
Wchu79SuFrX3MTSFbmSSuSRNV/eurHtsNEVf15Lx71tpq3750icxqZb5nNjI
61u7+12LOoZmUqW8kSuWqz0IM0y6qeeNolU+6EWYaRqFQmmr2uxV1DFWwSxZ
1W7vcpqGWe5HWMOqb1d+/6eoY2rVWvenO8thrVHr8XRnaf751epDWPOo3xTG
jvrs0k7forbpT9hf1xIzOA==
   "], {{0, 0}, {36, 36}}, {0, 198}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123031337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305722348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Det", " ", "@", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "j"], 
         RowBox[{"i", "!"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "+", "j"}], ")"}], "!"}]], 
       RowBox[{"StirlingS1", "[", 
        RowBox[{
         RowBox[{"i", "+", "j"}], ",", "i"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407400546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "64"], ",", 
   FractionBox["1", "1024"], ",", 
   FractionBox["1", "32768"], ",", 
   FractionBox["1", "2097152"], ",", 
   FractionBox["1", "268435456"], ",", 
   FractionBox["1", "68719476736"], ",", 
   FractionBox["1", "35184372088832"], ",", 
   FractionBox["1", "36028797018963968"]}], "}"}]], "Output",
 ImageSize->{373, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23078848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "n"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], "/", "2"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->294183058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "64"], ",", 
   FractionBox["1", "1024"], ",", 
   FractionBox["1", "32768"], ",", 
   FractionBox["1", "2097152"], ",", 
   FractionBox["1", "268435456"], ",", 
   FractionBox["1", "68719476736"], ",", 
   FractionBox["1", "35184372088832"], ",", 
   FractionBox["1", "36028797018963968"]}], "}"}]], "Output",
 ImageSize->{373, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184442999]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18892],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StirlingS2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NorlundB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NorlundB"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22854],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->1175]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15320],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/StirlingNumberoftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/StirlingS1/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StirlingS1"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->264626423],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->17036416],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->47419200],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->441384675],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->102025465],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->94843322],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->446619289]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StirlingS1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 18.2037586}", "context" -> "System`", 
    "keywords" -> {
     "enumeration of permutations", "Stirling1", 
      "Stirling number of the 1st kind", "Stirling number of the first kind", 
      "Stirling numbers", "Stirling numbers S1", "Stirling s1"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StirlingS1[n, m] gives the Stirling number of the first kind \
SubsuperscriptBox[S, n, (m)]. ", "synonyms" -> {"stirling s1"}, "title" -> 
    "StirlingS1", "type" -> "Symbol", "uri" -> "ref/StirlingS1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5435, 174, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3183605]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34310, 1126}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2664, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3287, 89, 48, 1, 70, "ObjectName",
 CellID->17589],
Cell[3338, 92, 693, 22, 70, "Usage",
 CellID->11611]
}, Open  ]],
Cell[CellGroupData[{
Cell[4068, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4546, 136, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4681, 142, 506, 18, 70, "Notes",
 CellID->9925],
Cell[5190, 162, 208, 7, 70, "Notes",
 CellID->25144825]
}, Closed]],
Cell[CellGroupData[{
Cell[5435, 174, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3183605],
Cell[CellGroupData[{
Cell[5818, 188, 148, 5, 70, "ExampleSection",
 CellID->403575173],
Cell[CellGroupData[{
Cell[5991, 197, 129, 4, 28, "Input",
 CellID->20126521],
Cell[6123, 203, 243, 8, 36, "Output",
 CellID->536584472]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6415, 217, 216, 7, 70, "ExampleSection",
 CellID->12089],
Cell[6634, 226, 220, 7, 70, "ExampleText",
 CellID->144264457],
Cell[CellGroupData[{
Cell[6879, 237, 188, 6, 70, "Input",
 CellID->134763362],
Cell[7070, 245, 216, 7, 36, "Output",
 CellID->489037501]
}, Open  ]],
Cell[7301, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->235648017],
Cell[7429, 260, 202, 7, 70, "ExampleText",
 CellID->56099227],
Cell[CellGroupData[{
Cell[7656, 271, 167, 5, 70, "Input",
 CellID->70202900],
Cell[7826, 278, 287, 10, 54, "Output",
 CellID->644396616]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8162, 294, 222, 7, 70, "ExampleSection",
 CellID->8738],
Cell[8387, 303, 114, 3, 70, "ExampleText",
 CellID->135223939],
Cell[CellGroupData[{
Cell[8526, 310, 448, 14, 70, "Input",
 CellID->36884709],
Cell[8977, 326, 6056, 103, 70, "Output",
 Evaluatable->False,
 CellID->184698318]
}, Open  ]],
Cell[15048, 432, 125, 3, 70, "ExampleDelimiter",
 CellID->325555284],
Cell[15176, 437, 113, 3, 70, "ExampleText",
 CellID->113925860],
Cell[CellGroupData[{
Cell[15314, 444, 657, 21, 70, "Input",
 CellID->168747835],
Cell[15974, 467, 768, 21, 137, "Output",
 CellID->440168825]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16791, 494, 233, 7, 70, "ExampleSection",
 CellID->27050],
Cell[17027, 503, 88, 1, 70, "ExampleText",
 CellID->457408841],
Cell[CellGroupData[{
Cell[17140, 508, 269, 9, 70, "Input",
 CellID->194530595],
Cell[17412, 519, 796, 25, 36, "Output",
 CellID->67089988]
}, Open  ]],
Cell[CellGroupData[{
Cell[18245, 549, 237, 8, 70, "Input",
 CellID->134792640],
Cell[18485, 559, 328, 10, 36, "Output",
 CellID->21633973]
}, Open  ]],
Cell[18828, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->24797867],
Cell[18955, 577, 152, 4, 70, "ExampleText",
 CellID->218402307],
Cell[CellGroupData[{
Cell[19132, 585, 629, 20, 70, "Input",
 CellID->788227672],
Cell[19764, 607, 801, 25, 54, "Output",
 CellID->160933105]
}, Open  ]],
Cell[20580, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->185535181],
Cell[20708, 640, 144, 4, 70, "ExampleText",
 CellID->103102577],
Cell[CellGroupData[{
Cell[20877, 648, 1229, 37, 70, "Input",
 CellID->38264963],
Cell[22109, 687, 197, 6, 36, "Output",
 CellID->642634176]
}, Open  ]],
Cell[CellGroupData[{
Cell[22343, 698, 156, 5, 70, "Input",
 CellID->44712849],
Cell[22502, 705, 198, 6, 36, "Output",
 CellID->393560065]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22749, 717, 226, 7, 70, "ExampleSection",
 CellID->30042],
Cell[22978, 726, 235, 7, 70, "ExampleText",
 CellID->288872411],
Cell[CellGroupData[{
Cell[23238, 737, 168, 5, 70, "Input",
 CellID->138196488],
Cell[23409, 744, 335, 10, 54, "Output",
 CellID->70541154]
}, Open  ]],
Cell[CellGroupData[{
Cell[23781, 759, 96, 3, 70, "Input",
 CellID->46300917],
Cell[23880, 764, 213, 6, 36, "Output",
 CellID->159881457]
}, Open  ]],
Cell[24108, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->127422742],
Cell[24236, 778, 233, 9, 70, "ExampleText",
 CellID->75747374],
Cell[CellGroupData[{
Cell[24494, 791, 128, 4, 70, "Input",
 CellID->67282836],
Cell[24625, 797, 158, 5, 36, "Output",
 CellID->622056582]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24832, 808, 224, 7, 70, "ExampleSection",
 CellID->23619],
Cell[25059, 817, 63, 1, 70, "ExampleText",
 CellID->173507766],
Cell[CellGroupData[{
Cell[25147, 822, 421, 13, 70, "Input",
 CellID->155386529],
Cell[25571, 837, 1225, 25, 201, "Output",
 CellID->123031337]
}, Open  ]],
Cell[26811, 865, 125, 3, 70, "ExampleDelimiter",
 CellID->305722348],
Cell[CellGroupData[{
Cell[26961, 872, 782, 26, 70, "Input",
 CellID->407400546],
Cell[27746, 900, 564, 17, 81, "Output",
 CellID->23078848]
}, Open  ]],
Cell[CellGroupData[{
Cell[28347, 922, 326, 12, 70, "Input",
 CellID->294183058],
Cell[28676, 936, 565, 17, 81, "Output",
 CellID->184442999]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29302, 960, 311, 9, 70, "SeeAlsoSection",
 CellID->18892],
Cell[29616, 971, 455, 17, 70, "SeeAlso",
 CellID->19390]
}, Open  ]],
Cell[CellGroupData[{
Cell[30108, 993, 314, 9, 70, "TutorialsSection",
 CellID->22854],
Cell[30425, 1004, 155, 3, 70, "Tutorials",
 CellID->1175]
}, Open  ]],
Cell[CellGroupData[{
Cell[30617, 1012, 321, 9, 70, "RelatedLinksSection",
 CellID->15320],
Cell[30941, 1023, 199, 4, 70, "RelatedLinks"],
Cell[31143, 1029, 199, 4, 70, "RelatedLinks"],
Cell[31345, 1035, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31770, 1053, 319, 9, 70, "MoreAboutSection",
 CellID->264626423],
Cell[32092, 1064, 156, 3, 70, "MoreAbout",
 CellID->17036416],
Cell[32251, 1069, 150, 3, 70, "MoreAbout",
 CellID->47419200],
Cell[32404, 1074, 145, 3, 70, "MoreAbout",
 CellID->441384675],
Cell[32552, 1079, 155, 3, 70, "MoreAbout",
 CellID->102025465],
Cell[32710, 1084, 161, 3, 70, "MoreAbout",
 CellID->94843322],
Cell[32874, 1089, 165, 3, 70, "MoreAbout",
 CellID->446619289]
}, Open  ]],
Cell[33054, 1095, 27, 0, 70, "History"],
Cell[33084, 1097, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

