(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12454,        445]
NotebookOptionsPosition[      9139,        333]
NotebookOutlinePosition[     10451,        370]
CellTagsIndexPosition[     10366,        365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Searching Files\"\>", 
       2->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetStreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/SetStreamPosition"], "Skip" :> 
          Documentation`HelpLookup["paclet:ref/Skip"], "Find" :> 
          Documentation`HelpLookup["paclet:ref/Find"], "FindList" :> 
          Documentation`HelpLookup["paclet:ref/FindList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetStreamPosition\"\>", 
       2->"\<\"Skip\"\>", 3->"\<\"Find\"\>", 
       4->"\<\"FindList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StreamPosition", "ObjectName",
 CellID->9505],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StreamPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StreamPosition"], "[", 
       StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns an integer which specifies the position of the \
current point in an open stream. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "On most computer systems, the integer returned by ",
 Cell[BoxData[
  ButtonBox["StreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StreamPosition"]], "InlineFormula"],
 " gives the position counting from the beginning of the file in bytes. "
}], "Notes",
 CellID->13271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->294518527],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->5829459],

Cell["Open a stream:", "ExampleText",
 CellID->2102684787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<123 456 789\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1322990999],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "82"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24617284]
}, Open  ]],

Cell["Read the first number from the stream object:", "ExampleText",
 CellID->832320077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1592955828],

Cell[BoxData["123"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382745274]
}, Open  ]],

Cell["The position counting from the beginning of the stream:", "ExampleText",
 CellID->95057581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPosition", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482938930],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->287632845]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->2052414146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1418257024],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->476104820]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2515],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetStreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetStreamPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Find",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Find"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8259]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9457],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->24037],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->59647788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->165507380],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->3874370]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StreamPosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 22.2194864}", "context" -> "System`", 
    "keywords" -> {"position in files", "file position"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StreamPosition[stream] returns an integer which specifies the position \
of the current point in an open stream. ", "synonyms" -> {"stream position"}, 
    "title" -> "StreamPosition", "type" -> "Symbol", "uri" -> 
    "ref/StreamPosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4344, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->294518527]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10223, 358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2262, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2885, 81, 51, 1, 70, "ObjectName",
 CellID->9505],
Cell[2939, 84, 549, 16, 70, "Usage",
 CellID->16425]
}, Open  ]],
Cell[CellGroupData[{
Cell[3525, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4003, 122, 304, 8, 70, "Notes",
 CellID->13271]
}, Closed]],
Cell[CellGroupData[{
Cell[4344, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->294518527],
Cell[CellGroupData[{
Cell[4729, 149, 146, 5, 70, "ExampleSection",
 CellID->5829459],
Cell[4878, 156, 58, 1, 70, "ExampleText",
 CellID->2102684787],
Cell[CellGroupData[{
Cell[4961, 161, 154, 4, 28, "Input",
 CellID->1322990999],
Cell[5118, 167, 224, 7, 36, "Output",
 CellID->24617284]
}, Open  ]],
Cell[5357, 177, 88, 1, 70, "ExampleText",
 CellID->832320077],
Cell[CellGroupData[{
Cell[5470, 182, 131, 4, 28, "Input",
 CellID->1592955828],
Cell[5604, 188, 160, 5, 36, "Output",
 CellID->382745274]
}, Open  ]],
Cell[5779, 196, 97, 1, 70, "ExampleText",
 CellID->95057581],
Cell[CellGroupData[{
Cell[5901, 201, 112, 3, 70, "Input",
 CellID->482938930],
Cell[6016, 206, 158, 5, 36, "Output",
 CellID->287632845]
}, Open  ]],
Cell[6189, 214, 61, 1, 70, "ExampleText",
 CellID->2052414146],
Cell[CellGroupData[{
Cell[6275, 219, 104, 3, 70, "Input",
 CellID->1418257024],
Cell[6382, 224, 163, 5, 36, "Output",
 CellID->476104820]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6606, 236, 310, 9, 70, "SeeAlsoSection",
 CellID->2515],
Cell[6919, 247, 942, 35, 70, "SeeAlso",
 CellID->8259]
}, Open  ]],
Cell[CellGroupData[{
Cell[7898, 287, 313, 9, 70, "TutorialsSection",
 CellID->9457],
Cell[8214, 298, 140, 3, 70, "Tutorials",
 CellID->24037],
Cell[8357, 303, 194, 4, 70, "Tutorials",
 CellID->59647788]
}, Open  ]],
Cell[CellGroupData[{
Cell[8588, 312, 319, 9, 70, "MoreAboutSection",
 CellID->165507380],
Cell[8910, 323, 157, 3, 70, "MoreAbout",
 CellID->3874370]
}, Open  ]],
Cell[9082, 329, 27, 0, 70, "History"],
Cell[9112, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

