(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41099,       1514]
NotebookOptionsPosition[     31778,       1190]
NotebookOutlinePosition[     33395,       1231]
CellTagsIndexPosition[     33309,       1226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "StringFreeQ" :> Documentation`HelpLookup["paclet:ref/StringFreeQ"],
           "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "Characters" :> Documentation`HelpLookup["paclet:ref/Characters"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Count\"\>", 
       2->"\<\"StringFreeQ\"\>", 3->"\<\"StringPosition\"\>", 
       4->"\<\"StringCases\"\>", 5->"\<\"Characters\"\>", 
       6->"\<\"StringExpression\"\>", 
       7->"\<\"RegularExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Processing Textual Data\"\>", 
       2->"\<\"String Manipulation\"\>", 
       3->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringCount", "ObjectName",
 CellID->10087],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCount"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"sub\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a count of the number of times ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"sub\", \"TI\"]\)\>\""], "InlineFormula"],
     " appears as a substring of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCount"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of substrings in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " that match the general string expression ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCount"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]counts the number of occurrences of any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCount"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25699]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string expression ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28210],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " overlapping substrings are not treated as separate. With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " counts substrings that overlap as separate. "
}], "Notes",
 CellID->249999609],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", multiple substrings that match the same string expression are all counted \
as separate. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", only the first such matching substring at a given position is counted as \
separate. "
}], "Notes",
 CellID->26352],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " treat lower\[Hyphen] and uppercase letters as equivalent. "
}], "Notes",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCount"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]}], "]"}]], "InlineFormula"],
 " gives the number of substrings matching the specified regular expression. \
"
}], "Notes",
 CellID->17602]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359206683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->275425232],

Cell[TextData[{
 "The number of occurrences of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"bb\", \"TI\"]\)\>\""], "InlineFormula"],
 " in the string ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"abbaabbaa\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->321252391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abbaabbaa\>\"", ",", "\"\<bb\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9358],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631058245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30014],

Cell[TextData[{
 "Count the number of substrings of the form ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"axb\", \"TI\"]\)\>\""], "InlineFormula"],
 " for different ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " characters: "
}], "ExampleText",
 CellID->116034192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abcadcadcbaac\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "_", "~~", "\"\<c\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25989],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202089]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14831],

Cell["Use string patterns:", "ExampleText",
 CellID->1602070101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", "\"\<cat\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->842221421],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1057916632]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "__", "~~", "\"\<e\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1826230663],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->526908104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<11a22b3\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->390705797],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5221905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<11a22b3\>\"", ",", 
   RowBox[{"_", "?", "LetterQ"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->180469199],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->424541275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113608023],

Cell["Regular expressions:", "ExampleText",
 CellID->1090058956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<a1b22c333\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<..2\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298182474],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->852277274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1770421952],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->2095818079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(?<=the )\>\"", "]"}], "~~", 
    RowBox[{"WordCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387675659],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172496516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319981946],

Cell["Count occurrences of either substrings:", "ExampleText",
 CellID->637514334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<cd\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72950628],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409336363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"\"\<abc\>\"", "|", "\"\<cd\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41376520],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178604896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91998220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->25857700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<ability\>\"", ",", "\"\<argument\>\"", ",", "\"\<listable\>\""}], 
    "}"}], ",", 
   RowBox[{"\"\<a\>\"", " ", "~~", "___", "~~", "\"\<l\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1610019191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95248680]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->63993257],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6921],

Cell[TextData[{
 "The number of occurrences of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"a\", \"TI\"]\)\>\""], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"abAB\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1974320454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1634040581],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249504056]
}, Open  ]],

Cell["Ignore case:", "ExampleText",
 CellID->1634050968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\"", ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4346],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515474785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Overlaps",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->377],

Cell[TextData[{
 "All substrings in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[
RowBox[{\"the\", \" \", \"cat\", \" \", \"in\", \" \", \"the\", \" \", \
\"hat\"}], \"TI\"]\)\>\""], "InlineFormula"],
 " starting and ending with ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"t\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->969322618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", "__", "~~", "\"\<t\>\""}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->594294584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"the cat in the hat\"\>", ",", "\<\"the cat in t\"\>", 
   ",", "\<\"the cat\"\>", ",", "\<\"t in the hat\"\>", ",", "\<\"t in t\"\>",
    ",", "\<\"the hat\"\>"}], "}"}]], "Output",
 ImageSize->{508, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10937692]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " does not include overlaps by default:"
}], "ExampleText",
 CellID->1335913582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", "__", "~~", "\"\<t\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986737587],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95609630]
}, Open  ]],

Cell["This includes the overlaps:", "ExampleText",
 CellID->758043289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", "__", "~~", "\"\<t\>\""}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->299173538],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123765400]
}, Open  ]],

Cell["This includes overlaps starting at the same position:", "ExampleText",
 CellID->1560564219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", "__", "~~", "\"\<t\>\""}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->950435539],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->219068002]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3354],

Cell["A 10-million-base random DNA string:", "ExampleText",
 CellID->245279094],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dna", " ", "=", " ", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<a\>\"", ",", "\"\<c\>\"", ",", "\"\<g\>\"", ",", "\"\<t\>\""}], 
       "}"}], ",", 
      RowBox[{"10", "^", "7"}]}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1079152963],

Cell["The number of sequences with adenine symmetrically placed:", \
"ExampleText",
 CellID->655712165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"dna", ",", 
   RowBox[{
   "\"\<a\>\"", "~~", "y_", "~~", "_", "~~", "y_", "~~", "\"\<a\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1824450226],

Cell[BoxData["141309"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121596934]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->579713432],

Cell["Find how many words occur in the U.S. Constitution:", "ExampleText",
 CellID->1411685779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", 
   RowBox[{"WordCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->803555597],

Cell[BoxData["7632"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164590727]
}, Open  ]],

Cell[TextData[{
 "The number of occurrences of the word ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"president\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->110345185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", "\"\<president\>\"", ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1293136934],

Cell[BoxData["121"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187758551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7303],

Cell["\<\
All strings made of two characters with length 4 and which overlap \
themselves:\
\>", "ExampleText",
 CellID->18149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "/@", 
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AAAA\"\>", ",", "\<\"AAAB\"\>", ",", "\<\"AABA\"\>", 
   ",", "\<\"AABB\"\>", ",", "\<\"ABAA\"\>", ",", "\<\"ABAB\"\>", 
   ",", "\<\"ABBA\"\>", ",", "\<\"ABBB\"\>", ",", "\<\"BAAA\"\>", 
   ",", "\<\"BAAB\"\>", ",", "\<\"BABA\"\>", ",", "\<\"BABB\"\>", 
   ",", "\<\"BBAA\"\>", ",", "\<\"BBAB\"\>", ",", "\<\"BBBA\"\>", 
   ",", "\<\"BBBB\"\>"}], "}"}]], "Output",
 ImageSize->{360, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287743164]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"StringCount", "[", 
      RowBox[{
       RowBox[{"#", "~~", "#"}], ",", "#", ",", 
       RowBox[{"Overlaps", "->", "True"}]}], "]"}], ">", "2"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27831],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AAAA\"\>", ",", "\<\"ABAB\"\>", ",", "\<\"BABA\"\>", 
   ",", "\<\"BBBB\"\>"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56780226]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " gives the number of matching substrings:"
}], "ExampleText",
 CellID->920527687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abaababba\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"___", "~~", "\"\<b\>\""}]}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->836642421],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1301450]
}, Open  ]],

Cell[TextData[{
 "The length of matching substrings obtained from ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1641545086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", " ", "@", " ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abaababba\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<b\>\""}], ",", 
    RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1873732838],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19452285]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3856],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5682]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25661],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->9160],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->325921189],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->998713456],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->352182816],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->193895752]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringCount - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 24.0007820}", "context" -> "System`", 
    "keywords" -> {"counting string matches", "wc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringCount[\"string\", \" sub\"] gives a count of the number of times \
\" sub\" appears as a substring of \" string\". StringCount[\"string\", patt] \
gives the number of substrings in \" string\" that match the general string \
expression patt. StringCount[\"string\", {patt_1, patt_2, ...}] counts the \
number of occurrences of any of the patt_i. StringCount[{s_1, s_2, ...}, p] \
gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string count"}, "title" -> "StringCount", "type" -> 
    "Symbol", "uri" -> "ref/StringCount"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10214, 317, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->359206683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33165, 1219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3248, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3871, 98, 49, 1, 70, "ObjectName",
 CellID->10087],
Cell[3923, 101, 2893, 88, 70, "Usage",
 CellID->25699]
}, Open  ]],
Cell[CellGroupData[{
Cell[6853, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7331, 211, 336, 11, 70, "Notes",
 CellID->28210],
Cell[7670, 224, 787, 26, 70, "Notes",
 CellID->249999609],
Cell[8460, 252, 688, 23, 70, "Notes",
 CellID->26352],
Cell[9151, 277, 493, 17, 70, "Notes",
 CellID->2995],
Cell[9647, 296, 530, 16, 70, "Notes",
 CellID->17602]
}, Closed]],
Cell[CellGroupData[{
Cell[10214, 317, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359206683],
Cell[CellGroupData[{
Cell[10599, 331, 148, 5, 70, "ExampleSection",
 CellID->275425232],
Cell[10750, 338, 276, 9, 70, "ExampleText",
 CellID->321252391],
Cell[CellGroupData[{
Cell[11051, 351, 150, 4, 28, "Input",
 CellID->9358],
Cell[11204, 357, 158, 5, 36, "Output",
 CellID->631058245]
}, Open  ]],
Cell[11377, 365, 121, 3, 70, "ExampleDelimiter",
 CellID->30014],
Cell[11501, 370, 275, 9, 70, "ExampleText",
 CellID->116034192],
Cell[CellGroupData[{
Cell[11801, 383, 198, 5, 70, "Input",
 CellID->25989],
Cell[12002, 390, 155, 5, 36, "Output",
 CellID->202089]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12206, 401, 216, 7, 70, "ExampleSection",
 CellID->14831],
Cell[12425, 410, 64, 1, 70, "ExampleText",
 CellID->1602070101],
Cell[CellGroupData[{
Cell[12514, 415, 167, 5, 70, "Input",
 CellID->842221421],
Cell[12684, 422, 159, 5, 36, "Output",
 CellID->1057916632]
}, Open  ]],
Cell[CellGroupData[{
Cell[12880, 432, 209, 5, 70, "Input",
 CellID->1826230663],
Cell[13092, 439, 158, 5, 36, "Output",
 CellID->526908104]
}, Open  ]],
Cell[CellGroupData[{
Cell[13287, 449, 177, 5, 70, "Input",
 CellID->390705797],
Cell[13467, 456, 156, 5, 36, "Output",
 CellID->5221905]
}, Open  ]],
Cell[CellGroupData[{
Cell[13660, 466, 174, 5, 70, "Input",
 CellID->180469199],
Cell[13837, 473, 158, 5, 36, "Output",
 CellID->424541275]
}, Open  ]],
Cell[14010, 481, 126, 3, 70, "ExampleDelimiter",
 CellID->1113608023],
Cell[14139, 486, 64, 1, 70, "ExampleText",
 CellID->1090058956],
Cell[CellGroupData[{
Cell[14228, 491, 202, 5, 70, "Input",
 CellID->1298182474],
Cell[14433, 498, 158, 5, 36, "Output",
 CellID->852277274]
}, Open  ]],
Cell[14606, 506, 126, 3, 70, "ExampleDelimiter",
 CellID->1770421952],
Cell[14735, 511, 90, 1, 70, "ExampleText",
 CellID->2095818079],
Cell[CellGroupData[{
Cell[14850, 516, 276, 7, 70, "Input",
 CellID->1387675659],
Cell[15129, 525, 158, 5, 36, "Output",
 CellID->172496516]
}, Open  ]],
Cell[15302, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->319981946],
Cell[15430, 538, 82, 1, 70, "ExampleText",
 CellID->637514334],
Cell[CellGroupData[{
Cell[15537, 543, 214, 6, 70, "Input",
 CellID->72950628],
Cell[15754, 551, 158, 5, 36, "Output",
 CellID->409336363]
}, Open  ]],
Cell[CellGroupData[{
Cell[15949, 561, 189, 5, 70, "Input",
 CellID->41376520],
Cell[16141, 568, 158, 5, 36, "Output",
 CellID->178604896]
}, Open  ]],
Cell[16314, 576, 124, 3, 70, "ExampleDelimiter",
 CellID->91998220],
Cell[16441, 581, 227, 7, 70, "ExampleText",
 CellID->25857700],
Cell[CellGroupData[{
Cell[16693, 592, 306, 10, 70, "Input",
 CellID->1610019191],
Cell[17002, 604, 212, 7, 36, "Output",
 CellID->95248680]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17263, 617, 221, 7, 70, "ExampleSection",
 CellID->63993257],
Cell[CellGroupData[{
Cell[17509, 628, 226, 7, 70, "ExampleSubsection",
 CellID->6921],
Cell[17738, 637, 260, 9, 70, "ExampleText",
 CellID->1974320454],
Cell[CellGroupData[{
Cell[18023, 650, 150, 4, 70, "Input",
 CellID->1634040581],
Cell[18176, 656, 158, 5, 36, "Output",
 CellID->249504056]
}, Open  ]],
Cell[18349, 664, 56, 1, 70, "ExampleText",
 CellID->1634050968],
Cell[CellGroupData[{
Cell[18430, 669, 191, 5, 70, "Input",
 CellID->4346],
Cell[18624, 676, 158, 5, 36, "Output",
 CellID->515474785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18831, 687, 223, 7, 70, "ExampleSubsection",
 CellID->377],
Cell[19057, 696, 345, 11, 70, "ExampleText",
 CellID->969322618],
Cell[CellGroupData[{
Cell[19427, 711, 257, 6, 70, "Input",
 CellID->594294584],
Cell[19687, 719, 355, 9, 36, "Output",
 CellID->10937692]
}, Open  ]],
Cell[20057, 731, 222, 7, 70, "ExampleText",
 CellID->1335913582],
Cell[CellGroupData[{
Cell[20304, 742, 208, 5, 70, "Input",
 CellID->986737587],
Cell[20515, 749, 157, 5, 36, "Output",
 CellID->95609630]
}, Open  ]],
Cell[20687, 757, 70, 1, 70, "ExampleText",
 CellID->758043289],
Cell[CellGroupData[{
Cell[20782, 762, 258, 6, 70, "Input",
 CellID->299173538],
Cell[21043, 770, 158, 5, 36, "Output",
 CellID->123765400]
}, Open  ]],
Cell[21216, 778, 97, 1, 70, "ExampleText",
 CellID->1560564219],
Cell[CellGroupData[{
Cell[21338, 783, 257, 6, 70, "Input",
 CellID->950435539],
Cell[21598, 791, 158, 5, 36, "Output",
 CellID->219068002]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21817, 803, 222, 7, 70, "ExampleSection",
 CellID->3354],
Cell[22042, 812, 79, 1, 70, "ExampleText",
 CellID->245279094],
Cell[22124, 815, 449, 14, 70, "Input",
 CellID->1079152963],
Cell[22576, 831, 103, 2, 70, "ExampleText",
 CellID->655712165],
Cell[CellGroupData[{
Cell[22704, 837, 216, 7, 70, "Input",
 CellID->1824450226],
Cell[22923, 846, 163, 5, 36, "Output",
 CellID->121596934]
}, Open  ]],
Cell[23101, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->579713432],
Cell[23229, 859, 95, 1, 70, "ExampleText",
 CellID->1411685779],
Cell[CellGroupData[{
Cell[23349, 864, 237, 7, 70, "Input",
 CellID->803555597],
Cell[23589, 873, 161, 5, 36, "Output",
 CellID->164590727]
}, Open  ]],
Cell[23765, 881, 187, 6, 70, "ExampleText",
 CellID->110345185],
Cell[CellGroupData[{
Cell[23977, 891, 269, 7, 70, "Input",
 CellID->1293136934],
Cell[24249, 900, 160, 5, 36, "Output",
 CellID->187758551]
}, Open  ]],
Cell[24424, 908, 120, 3, 70, "ExampleDelimiter",
 CellID->7303],
Cell[24547, 913, 127, 4, 70, "ExampleText",
 CellID->18149],
Cell[CellGroupData[{
Cell[24699, 921, 225, 8, 70, "Input",
 CellID->3611],
Cell[24927, 931, 540, 12, 54, "Output",
 CellID->287743164]
}, Open  ]],
Cell[CellGroupData[{
Cell[25504, 948, 314, 11, 70, "Input",
 CellID->27831],
Cell[25821, 961, 271, 8, 36, "Output",
 CellID->56780226]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26141, 975, 233, 7, 70, "ExampleSection",
 CellID->15613],
Cell[26377, 984, 224, 7, 70, "ExampleText",
 CellID->920527687],
Cell[CellGroupData[{
Cell[26626, 995, 264, 7, 70, "Input",
 CellID->836642421],
Cell[26893, 1004, 157, 5, 36, "Output",
 CellID->1301450]
}, Open  ]],
Cell[27065, 1012, 238, 8, 70, "ExampleText",
 CellID->1641545086],
Cell[CellGroupData[{
Cell[27328, 1024, 291, 7, 70, "Input",
 CellID->1873732838],
Cell[27622, 1033, 158, 5, 36, "Output",
 CellID->19452285]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27841, 1045, 310, 9, 70, "SeeAlsoSection",
 CellID->3856],
Cell[28154, 1056, 1731, 62, 70, "SeeAlso",
 CellID->5682]
}, Open  ]],
Cell[CellGroupData[{
Cell[29922, 1123, 314, 9, 70, "TutorialsSection",
 CellID->25661],
Cell[30239, 1134, 150, 3, 70, "Tutorials",
 CellID->9160],
Cell[30392, 1139, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[30569, 1145, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[30711, 1150, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[30926, 1159, 319, 9, 70, "MoreAboutSection",
 CellID->325921189],
Cell[31248, 1170, 156, 3, 70, "MoreAbout",
 CellID->998713456],
Cell[31407, 1175, 149, 3, 70, "MoreAbout",
 CellID->352182816],
Cell[31559, 1180, 145, 3, 70, "MoreAbout",
 CellID->193895752]
}, Open  ]],
Cell[31719, 1186, 29, 0, 70, "History"],
Cell[31751, 1188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

