(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28929,       1092]
NotebookOptionsPosition[     22234,        856]
NotebookOutlinePosition[     23825,        897]
CellTagsIndexPosition[     23740,        892]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Drop" :> Documentation`HelpLookup["paclet:ref/Drop"], 
          "StringTake" :> Documentation`HelpLookup["paclet:ref/StringTake"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Drop\"\>", 2->"\<\"StringTake\"\>", 
       3->"\<\"StringPosition\"\>", 
       4->"\<\"StringReplacePart\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringDrop", "ObjectName",
 CellID->30798],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringDrop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringDrop"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " with its first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringDrop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringDrop"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " with its last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringDrop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringDrop"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " with its ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " character dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringDrop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringDrop"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " with characters ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringDrop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringDrop"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " drops characters ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " through ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in steps of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23005],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sequence specification."
}], "Notes",
 CellID->3209]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785795221],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->20034591],

Cell["Drop the first 4 characters from a string:", "ExampleText",
 CellID->19016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7603],

Cell[BoxData["\<\"efghijklm\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25347]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " to show quotes:"
}], "ExampleText",
 CellID->13264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226],

Cell["\"efghijklm\"", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->13869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28661],

Cell["Drop from the end of the string:", "ExampleText",
 CellID->26640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14361],

Cell[BoxData["\<\"abcdefghi\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30213],

Cell["Drop characters 5 through 10:", "ExampleText",
 CellID->29073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20930],

Cell[BoxData["\<\"abcdklm\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15946],

Cell["Drop character 3 from a string:", "ExampleText",
 CellID->17545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11965],

Cell[BoxData["\<\"abdefghijklm\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23705],

Cell["Drop every other character:", "ExampleText",
 CellID->21218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5151],

Cell[BoxData["\<\"bdfhjl\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8071],

Cell["Drop the last 2 characters from several strings:", "ExampleText",
 CellID->11842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<abcdef\>\"", ",", "\"\<xyzw\>\"", ",", "\"\<stuv\>\""}], 
    "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"xy\"\>", ",", "\<\"st\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " works with special characters:"
}], "ExampleText",
 CellID->23182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{
  "\"\<\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ReturnIndicator]\>\"", 
   ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24889],

Cell[BoxData["\<\"\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\"\>"], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20207],

Cell[TextData[{
 "Newline (",
 Cell[BoxData["\\n"], "InlineFormula"],
 ") counts as a single character:"
}], "ExampleText",
 CellID->13578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abc\\ndef\>\"", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18489],

Cell[BoxData["\<\"def\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30290],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " works like applying ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " to the list of characters:"
}], "ExampleText",
 CellID->12673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<abcdefghijklm\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"k\"\>", ",", "\<\"l\"\>", ",", "\<\"m\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11399],

Cell[BoxData["\<\"abcdklm\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7323]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " with an empty string can be used like ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15517],

Cell[BoxData["\<\"afghijk\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14645],

Cell[BoxData["\<\"afghijk\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28802]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " can drop several sequences of characters at a time:"
}], "ExampleText",
 CellID->6862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20164],

Cell[BoxData["\<\"afij\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28675]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " operates on the raw characters in a string:"
}], "ExampleText",
 CellID->5388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28145],

Cell[BoxData["\<\"ox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, 0]]\\)\"\>"], \
"Output",
 ImageSize->{221, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1560]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23281],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\* StyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, \
0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->29148]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4196],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringTake",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringTake"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14954],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->3020],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->410302322],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->508647062],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->38902138]
}, Open  ]],

Cell["New in 2  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringDrop - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 24.4539186}", "context" -> "System`", 
    "keywords" -> {"delete substring"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringDrop[\"string\", n] gives \" string\" with its first n characters \
dropped. StringDrop[\"string\", -n] gives \" string\" with its last n \
characters dropped. StringDrop[\"string\", {n}] gives \" string\" with its \
n\\[Null]^th character dropped. StringDrop[\"string\", {m, n}] gives \" \
string\" with characters m through n dropped. StringDrop[{s_1, s_2, ...}, \
spec] gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string drop"}, "title" -> "StringDrop", "type" -> 
    "Symbol", "uri" -> "ref/StringDrop"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7940, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->785795221]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23597, 885}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2394, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3017, 83, 48, 1, 70, "ObjectName",
 CellID->30798],
Cell[3068, 86, 3398, 108, 70, "Usage",
 CellID->21852]
}, Open  ]],
Cell[CellGroupData[{
Cell[6503, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6981, 216, 652, 25, 70, "Notes",
 CellID->23005],
Cell[7636, 243, 267, 10, 70, "Notes",
 CellID->3209]
}, Closed]],
Cell[CellGroupData[{
Cell[7940, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785795221],
Cell[CellGroupData[{
Cell[8325, 272, 147, 5, 70, "ExampleSection",
 CellID->20034591],
Cell[8475, 279, 81, 1, 70, "ExampleText",
 CellID->19016],
Cell[CellGroupData[{
Cell[8581, 284, 144, 4, 28, "Input",
 CellID->7603],
Cell[8728, 290, 170, 5, 36, "Output",
 CellID->25347]
}, Open  ]],
Cell[8913, 298, 200, 8, 70, "ExampleText",
 CellID->13264],
Cell[CellGroupData[{
Cell[9138, 310, 99, 3, 28, "Input",
 CellID->226],
Cell[9240, 315, 168, 5, 50, "Output",
 CellID->13869]
}, Open  ]],
Cell[9423, 323, 121, 3, 70, "ExampleDelimiter",
 CellID->28661],
Cell[9547, 328, 71, 1, 70, "ExampleText",
 CellID->26640],
Cell[CellGroupData[{
Cell[9643, 333, 164, 5, 70, "Input",
 CellID->14361],
Cell[9810, 340, 170, 5, 36, "Output",
 CellID->25826]
}, Open  ]],
Cell[9995, 348, 121, 3, 70, "ExampleDelimiter",
 CellID->30213],
Cell[10119, 353, 68, 1, 70, "ExampleText",
 CellID->29073],
Cell[CellGroupData[{
Cell[10212, 358, 195, 6, 70, "Input",
 CellID->20930],
Cell[10410, 366, 168, 5, 36, "Output",
 CellID->22947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10627, 377, 216, 7, 70, "ExampleSection",
 CellID->15946],
Cell[10846, 386, 70, 1, 70, "ExampleText",
 CellID->17545],
Cell[CellGroupData[{
Cell[10941, 391, 169, 5, 70, "Input",
 CellID->11965],
Cell[11113, 398, 173, 5, 36, "Output",
 CellID->30077]
}, Open  ]],
Cell[11301, 406, 121, 3, 70, "ExampleDelimiter",
 CellID->23705],
Cell[11425, 411, 66, 1, 70, "ExampleText",
 CellID->21218],
Cell[CellGroupData[{
Cell[11516, 416, 224, 7, 70, "Input",
 CellID->5151],
Cell[11743, 425, 167, 5, 36, "Output",
 CellID->12108]
}, Open  ]],
Cell[11925, 433, 120, 3, 70, "ExampleDelimiter",
 CellID->8071],
Cell[12048, 438, 87, 1, 70, "ExampleText",
 CellID->11842],
Cell[CellGroupData[{
Cell[12160, 443, 243, 8, 70, "Input",
 CellID->13759],
Cell[12406, 453, 241, 8, 36, "Output",
 CellID->20081]
}, Open  ]],
Cell[12662, 464, 121, 3, 70, "ExampleDelimiter",
 CellID->22606],
Cell[12786, 469, 208, 7, 70, "ExampleText",
 CellID->23182],
Cell[CellGroupData[{
Cell[13019, 480, 289, 8, 70, "Input",
 CellID->24889],
Cell[13311, 490, 222, 6, 36, "Output",
 CellID->7714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13582, 502, 233, 7, 70, "ExampleSection",
 CellID->20207],
Cell[13818, 511, 139, 5, 70, "ExampleText",
 CellID->13578],
Cell[CellGroupData[{
Cell[13982, 520, 141, 4, 70, "Input",
 CellID->18489],
Cell[14126, 526, 164, 5, 36, "Output",
 CellID->12572]
}, Open  ]],
Cell[14305, 534, 121, 3, 70, "ExampleDelimiter",
 CellID->30290],
Cell[14429, 539, 341, 12, 70, "ExampleText",
 CellID->12673],
Cell[CellGroupData[{
Cell[14795, 555, 244, 8, 70, "Input",
 CellID->50],
Cell[15042, 565, 310, 8, 36, "Output",
 CellID->29010]
}, Open  ]],
Cell[CellGroupData[{
Cell[15389, 578, 215, 7, 70, "Input",
 CellID->11399],
Cell[15607, 587, 167, 5, 36, "Output",
 CellID->7323]
}, Open  ]],
Cell[15789, 595, 121, 3, 70, "ExampleDelimiter",
 CellID->16119],
Cell[15913, 600, 359, 12, 70, "ExampleText",
 CellID->14599],
Cell[CellGroupData[{
Cell[16297, 616, 216, 6, 70, "Input",
 CellID->15517],
Cell[16516, 624, 168, 5, 36, "Output",
 CellID->23802]
}, Open  ]],
Cell[CellGroupData[{
Cell[16721, 634, 192, 6, 70, "Input",
 CellID->14645],
Cell[16916, 642, 168, 5, 36, "Output",
 CellID->28802]
}, Open  ]],
Cell[17099, 650, 242, 7, 70, "ExampleText",
 CellID->6862],
Cell[CellGroupData[{
Cell[17366, 661, 431, 14, 70, "Input",
 CellID->20164],
Cell[17800, 677, 165, 5, 36, "Output",
 CellID->28675]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18014, 688, 225, 7, 70, "ExampleSection",
 CellID->5069],
Cell[18242, 697, 220, 7, 70, "ExampleText",
 CellID->5388],
Cell[CellGroupData[{
Cell[18487, 708, 189, 6, 70, "Input",
 CellID->28145],
Cell[18679, 716, 213, 6, 54, "Output",
 CellID->1560]
}, Open  ]],
Cell[CellGroupData[{
Cell[18929, 727, 163, 5, 70, "Input",
 CellID->23281],
Cell[19095, 734, 365, 13, 50, "Output",
 CellID->29148]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19521, 754, 310, 9, 70, "SeeAlsoSection",
 CellID->4196],
Cell[19834, 765, 967, 35, 70, "SeeAlso",
 CellID->26775]
}, Open  ]],
Cell[CellGroupData[{
Cell[20838, 805, 314, 9, 70, "TutorialsSection",
 CellID->14954],
Cell[21155, 816, 150, 3, 70, "Tutorials",
 CellID->3020],
Cell[21308, 821, 174, 4, 70, "Tutorials",
 CellID->336637905]
}, Open  ]],
Cell[CellGroupData[{
Cell[21519, 830, 319, 9, 70, "MoreAboutSection",
 CellID->410302322],
Cell[21841, 841, 149, 3, 70, "MoreAbout",
 CellID->508647062],
Cell[21993, 846, 144, 3, 70, "MoreAbout",
 CellID->38902138]
}, Open  ]],
Cell[22152, 852, 52, 0, 70, "History"],
Cell[22207, 854, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

