(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15614,        522]
NotebookOptionsPosition[     12283,        412]
NotebookOutlinePosition[     13612,        449]
CellTagsIndexPosition[     13527,        444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FileFormat" :> 
          Documentation`HelpLookup["paclet:ref/FileFormat"], "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"], 
          "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FileFormat\"\>", 2->"\<\"ImportString\"\>", 
       3->"\<\"BinaryReadList\"\>", 4->"\<\"SyntaxQ\"\>", 
       5->"\<\"Hash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Importing & Exporting\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Patterns\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StringFormat", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringFormat",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringFormat"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]attempts to determine what ",
     Cell[BoxData[
      ButtonBox["ImportString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImportString"]], "InlineFormula",
      ShowStringCharacters->False],
     " format could be used to import the string ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFormat"]], "InlineFormula"],
 " returns a format name of the type used by ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32194],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFormat"]], "InlineFormula"],
 " uses heuristic methods, and may not give correct results, particularly for \
shorter strings."
}], "Notes",
 CellID->10525],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFormat"]], "InlineFormula"],
 " does not verify that ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " would succeed if applied to ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->14105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->583336545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55559750],

Cell["Format interpretation of some strings of data: ", "ExampleText",
 CellID->642247146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "\"\<abcd 1234\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1015440968],

Cell[BoxData["\<\"Text\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1178754647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "\"\<1 2 3\\n 5 6 7\\n 8 9 0\\n\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150419685],

Cell[BoxData["\<\"Table\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->792708554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "\"\<1,2\\n 3,4\\n 5,6\\n\>\"", "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1487927533],

Cell[BoxData["\<\"CSV\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150977816]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "\"\<1\\t2\\n 3\\t4\\n 5\\t6\\n\>\"", 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->175983795],

Cell[BoxData["\<\"TSV\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->101801497]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26115],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileFormat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5889]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->195917635],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->559916284],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->77998985],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->910857242],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->33048294],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout",
 CellID->239495397]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 29.9384340}", "context" -> "System`", 
    "keywords" -> {"text format", "import format", "file format"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringFormat[\"string\"] attempts to determine what ImportString format \
could be used to import the string \" string\".", 
    "synonyms" -> {"string format", "file"}, "title" -> "StringFormat", 
    "type" -> "Symbol", "uri" -> "ref/StringFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7287, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->583336545]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13384, 437}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2513, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 81, 1577, 37, 70, "ObjectNameGrid"],
Cell[4716, 120, 823, 24, 70, "Usage",
 CellID->9650]
}, Open  ]],
Cell[CellGroupData[{
Cell[5576, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6054, 166, 475, 17, 70, "Notes",
 CellID->32194],
Cell[6532, 185, 269, 8, 70, "Notes",
 CellID->10525],
Cell[6804, 195, 446, 15, 70, "Notes",
 CellID->14105]
}, Closed]],
Cell[CellGroupData[{
Cell[7287, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->583336545],
Cell[CellGroupData[{
Cell[7672, 229, 147, 5, 70, "ExampleSection",
 CellID->55559750],
Cell[7822, 236, 90, 1, 70, "ExampleText",
 CellID->642247146],
Cell[CellGroupData[{
Cell[7937, 241, 125, 3, 28, "Input",
 CellID->1015440968],
Cell[8065, 246, 170, 5, 36, "Output",
 CellID->1178754647]
}, Open  ]],
Cell[CellGroupData[{
Cell[8272, 256, 144, 4, 28, "Input",
 CellID->150419685],
Cell[8419, 262, 170, 5, 36, "Output",
 CellID->792708554]
}, Open  ]],
Cell[CellGroupData[{
Cell[8626, 272, 138, 4, 28, "Input",
 CellID->1487927533],
Cell[8767, 278, 168, 5, 36, "Output",
 CellID->150977816]
}, Open  ]],
Cell[CellGroupData[{
Cell[8972, 288, 144, 4, 70, "Input",
 CellID->175983795],
Cell[9119, 294, 168, 5, 36, "Output",
 CellID->101801497]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9348, 306, 311, 9, 70, "SeeAlsoSection",
 CellID->26115],
Cell[9662, 317, 1199, 44, 70, "SeeAlso",
 CellID->5889]
}, Open  ]],
Cell[CellGroupData[{
Cell[10898, 366, 299, 8, 70, "MoreAboutSection"],
Cell[11200, 376, 193, 4, 70, "MoreAbout",
 CellID->195917635],
Cell[11396, 382, 154, 3, 70, "MoreAbout",
 CellID->559916284],
Cell[11553, 387, 148, 3, 70, "MoreAbout",
 CellID->77998985],
Cell[11704, 392, 141, 3, 70, "MoreAbout",
 CellID->910857242],
Cell[11848, 397, 184, 3, 70, "MoreAbout",
 CellID->33048294],
Cell[12035, 402, 176, 3, 70, "MoreAbout",
 CellID->239495397]
}, Open  ]],
Cell[12226, 408, 27, 0, 70, "History"],
Cell[12256, 410, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

