(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28240,       1051]
NotebookOptionsPosition[     21477,        809]
NotebookOutlinePosition[     22981,        850]
CellTagsIndexPosition[     22896,        845]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Join" :> Documentation`HelpLookup["paclet:ref/Join"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], "Row" :> 
          Documentation`HelpLookup["paclet:ref/Row"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], "StringInsert" :> 
          Documentation`HelpLookup["paclet:ref/StringInsert"], 
          "StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Join\"\>", 
       2->"\<\"StringExpression\"\>", 3->"\<\"Row\"\>", 
       4->"\<\"Characters\"\>", 5->"\<\"StringInsert\"\>", 
       6->"\<\"StringReplacePart\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Core Language\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "StringJoin ",
 StyleBox["(<>)", "OperatorCharacter"]
}], "ObjectName",
 CellID->1716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "<>", "\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "<>", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringJoin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringJoin"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringJoin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringJoin"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a string consisting of a concatenation of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5060]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21562]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261383795],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->112387277],

Cell["Join strings:", "ExampleText",
 CellID->25531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abcd\>\"", "<>", "\"\<ABCD\>\"", "<>", "\"\<xyz\>\""}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17987],

Cell[BoxData["\<\"abcdABCDxyz\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9590]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " to show string quotes:"
}], "ExampleText",
 CellID->26472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26399],

Cell["\"abcdABCDxyz\"", "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->10945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7483],

Cell["All lists are ignored:", "ExampleText",
 CellID->15518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<AB\>\"", ",", "\"\<CD\>\""}], "}"}], ",", "\"\<XY\>\""}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11564],

Cell[BoxData["\<\"ABCDXY\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5583]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20110],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " works with special characters:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<\[Alpha]\[Beta]\[Gamma]\>\"", "<>", 
  "\"\<\[CirclePlus]\[CircleTimes]\>\"", "<>", 
  "\"\< \[ReturnIndicator]\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533],

Cell[BoxData["\<\"\[Alpha]\[Beta]\[Gamma]\[CirclePlus]\[CircleTimes] \
\[ReturnIndicator]\"\>"], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4019],

Cell["Join strings, with a newline in between:", "ExampleText",
 CellID->13827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<one\>\"", "<>", "\"\<\\n\>\"", "<>", "\"\<two\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11660],

Cell[BoxData["\<\"one\\ntwo\"\>"], "Output",
 ImageSize->{25, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8822],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " preserves formatting information embedded in strings:"
}], "ExampleText",
 CellID->22336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "<>", "\"\<\!\(\*
StyleBox[\"blue\",
FontColor->RGBColor[0, 0, 1]]\)\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491],

Cell[BoxData["\<\"\\!\\(\\*\\nStyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, \
0, 0]]\\)\\!\\(\\*\\nStyleBox[\\\"blue\\\",\\nFontColor->RGBColor[0, 0, \
1]]\\)\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241099673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32751],

Cell["Iteratively join a string to its reverse:", "ExampleText",
 CellID->28690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "<>", 
     RowBox[{"StringReverse", "[", "#", "]"}]}], "&"}], ",", "\"\<AB\>\"", 
   ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AB\"\>", ",", "\<\"ABBA\"\>", ",", "\<\"ABBAABBA\"\>", 
   ",", "\<\"ABBAABBAABBAABBA\"\>", 
   ",", "\<\"ABBAABBAABBAABBAABBAABBAABBAABBA\"\>", 
   ",", "\<\"ABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBAABBA\
\"\>"}], "}"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15314],

Cell["Find trigrams in a string:", "ExampleText",
 CellID->12661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<aabcaabc\>\"", "]"}], ",", "3", ",", 
    "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"c\"\>", ",", "\<\"a\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "/@", "data"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aab\"\>", ",", "\<\"abc\"\>", ",", "\<\"bca\"\>", 
   ",", "\<\"caa\"\>", ",", "\<\"aab\"\>", ",", "\<\"abc\"\>"}], 
  "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3637],

Cell["Join a list of words, after inserting spaces in between:", "ExampleText",
 CellID->1307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<dog\>\"", ",", "\"\<cat\>\"", ",", "\"\<sheep\>\"", ",", 
     "\"\<cow\>\""}], "}"}], ",", "\"\< \>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"dog\"\>", ",", "\<\" \"\>", ",", "\<\"cat\"\>", 
   ",", "\<\" \"\>", ",", "\<\"sheep\"\>", ",", "\<\" \"\>", 
   ",", "\<\"cow\"\>"}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28286],

Cell[BoxData["\<\"dog cat sheep cow\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17784],

Cell["Create a Champernowne number:", "ExampleText",
 CellID->7045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<0.\>\"", ",", 
    RowBox[{"ToString", "/@", 
     RowBox[{"Range", "[", "30", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10418],

Cell[BoxData["0.12345678910111213141516171819202122232425262728293`50.\
091514977524966"], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15709]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19511],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " acts as a kind of inverse to ",
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<abcdefg\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16907],

Cell[BoxData["\<\"abcdefg\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11729]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5694],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " works only with explicit strings:"
}], "ExampleText",
 CellID->20967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<item \>\"", "<>", "456"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6032],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringJoin", "::", "\<\"string\"\>"}], ":", 
  " ", "\<\"String expected at position \\!\\(2\\) in \\!\\(\\\"item \\\" <> \
456\\).\"\>"}]], "Message", "MSG",
 CellID->168293751],

Cell[BoxData[
 RowBox[{"\<\"item \"\>", "<>", "456"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206587651]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to convert to a string:"
}], "ExampleText",
 CellID->25699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<item \>\"", "<>", 
  RowBox[{"ToString", "[", "456", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17692],

Cell[BoxData["\<\"item 456\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9511677]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12996],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9622],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->23613],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->20293]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->148589813],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->707798061],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->146427087],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->348928747],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->426541698]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringJoin (<>) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 31.4853486}", "context" -> "System`", 
    "keywords" -> {
     "catenating strings", "concatenate strings", "implode", 
      "joining strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"SubscriptBox[ s, 1]\" <> \"SubscriptBox[ s, 2]\" <> ..., \
StringJoin[\"SubscriptBox[ s, 1]\", \"SubscriptBox[ s, 2]\", ...] or \
StringJoin[{\"SubscriptBox[ s, 1]\", \"SubscriptBox[ s, 2]\", ...}] yields a \
string consisting of a concatenation of the s_i. ", 
    "synonyms" -> {"string join", "<>"}, "title" -> "StringJoin", "type" -> 
    "Symbol", "uri" -> "ref/StringJoin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5991, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->261383795]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22753, 838}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2859, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3482, 90, 103, 4, 70, "ObjectName",
 CellID->1716],
Cell[3588, 96, 1547, 45, 70, "Usage",
 CellID->5060]
}, Open  ]],
Cell[CellGroupData[{
Cell[5172, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5650, 163, 304, 12, 70, "Notes",
 CellID->21562]
}, Closed]],
Cell[CellGroupData[{
Cell[5991, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261383795],
Cell[CellGroupData[{
Cell[6376, 194, 148, 5, 70, "ExampleSection",
 CellID->112387277],
Cell[6527, 201, 52, 1, 70, "ExampleText",
 CellID->25531],
Cell[CellGroupData[{
Cell[6604, 206, 134, 4, 28, "Input",
 CellID->17987],
Cell[6741, 212, 171, 5, 36, "Output",
 CellID->9590]
}, Open  ]],
Cell[6927, 220, 207, 8, 70, "ExampleText",
 CellID->26472],
Cell[CellGroupData[{
Cell[7159, 232, 101, 3, 28, "Input",
 CellID->26399],
Cell[7263, 237, 170, 5, 50, "Output",
 CellID->10945]
}, Open  ]],
Cell[7448, 245, 120, 3, 70, "ExampleDelimiter",
 CellID->7483],
Cell[7571, 250, 61, 1, 70, "ExampleText",
 CellID->15518],
Cell[CellGroupData[{
Cell[7657, 255, 231, 8, 70, "Input",
 CellID->11564],
Cell[7891, 265, 166, 5, 36, "Output",
 CellID->5583]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8106, 276, 216, 7, 70, "ExampleSection",
 CellID->20110],
Cell[8325, 285, 206, 7, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[8556, 296, 194, 5, 70, "Input",
 CellID->533],
Cell[8753, 303, 232, 6, 36, "Output",
 CellID->31353]
}, Open  ]],
Cell[9000, 312, 120, 3, 70, "ExampleDelimiter",
 CellID->4019],
Cell[9123, 317, 79, 1, 70, "ExampleText",
 CellID->13827],
Cell[CellGroupData[{
Cell[9227, 322, 130, 3, 70, "Input",
 CellID->11660],
Cell[9360, 327, 170, 5, 54, "Output",
 CellID->29233]
}, Open  ]],
Cell[9545, 335, 120, 3, 70, "ExampleDelimiter",
 CellID->8822],
Cell[9668, 340, 231, 7, 70, "ExampleText",
 CellID->22336],
Cell[CellGroupData[{
Cell[9924, 351, 214, 7, 70, "Input",
 CellID->491],
Cell[10141, 360, 306, 7, 36, "Output",
 CellID->241099673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10496, 373, 223, 7, 70, "ExampleSection",
 CellID->32751],
Cell[10722, 382, 80, 1, 70, "ExampleText",
 CellID->28690],
Cell[CellGroupData[{
Cell[10827, 387, 233, 8, 70, "Input",
 CellID->5685],
Cell[11063, 397, 422, 11, 54, "Output",
 CellID->20052]
}, Open  ]],
Cell[11500, 411, 121, 3, 70, "ExampleDelimiter",
 CellID->15314],
Cell[11624, 416, 65, 1, 70, "ExampleText",
 CellID->12661],
Cell[CellGroupData[{
Cell[11714, 421, 220, 7, 70, "Input",
 CellID->22313],
Cell[11937, 430, 741, 20, 36, "Output",
 CellID->20324]
}, Open  ]],
Cell[CellGroupData[{
Cell[12715, 455, 101, 3, 70, "Input",
 CellID->29470],
Cell[12819, 460, 307, 9, 36, "Output",
 CellID->18784]
}, Open  ]],
Cell[13141, 472, 120, 3, 70, "ExampleDelimiter",
 CellID->3637],
Cell[13264, 477, 94, 1, 70, "ExampleText",
 CellID->1307],
Cell[CellGroupData[{
Cell[13383, 482, 251, 8, 70, "Input",
 CellID->15275],
Cell[13637, 492, 324, 9, 36, "Output",
 CellID->17378]
}, Open  ]],
Cell[CellGroupData[{
Cell[13998, 506, 102, 3, 70, "Input",
 CellID->28286],
Cell[14103, 511, 178, 5, 36, "Output",
 CellID->4118]
}, Open  ]],
Cell[14296, 519, 121, 3, 70, "ExampleDelimiter",
 CellID->17784],
Cell[14420, 524, 67, 1, 70, "ExampleText",
 CellID->7045],
Cell[CellGroupData[{
Cell[14512, 529, 243, 7, 70, "Input",
 CellID->10418],
Cell[14758, 538, 227, 6, 36, "Output",
 CellID->15709]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15034, 550, 233, 7, 70, "ExampleSection",
 CellID->19511],
Cell[15270, 559, 336, 12, 70, "ExampleText",
 CellID->29897],
Cell[CellGroupData[{
Cell[15631, 575, 115, 3, 70, "Input",
 CellID->2214],
Cell[15749, 580, 310, 8, 36, "Output",
 CellID->15745]
}, Open  ]],
Cell[CellGroupData[{
Cell[16096, 593, 102, 3, 70, "Input",
 CellID->16907],
Cell[16201, 598, 168, 5, 36, "Output",
 CellID->11729]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16418, 609, 225, 7, 70, "ExampleSection",
 CellID->5694],
Cell[16646, 618, 211, 7, 70, "ExampleText",
 CellID->20967],
Cell[CellGroupData[{
Cell[16882, 629, 102, 3, 70, "Input",
 CellID->6032],
Cell[16987, 634, 213, 5, 70, "Message",
 CellID->168293751],
Cell[17203, 641, 195, 6, 36, "Output",
 CellID->206587651]
}, Open  ]],
Cell[17413, 650, 206, 8, 70, "ExampleText",
 CellID->25699],
Cell[CellGroupData[{
Cell[17644, 662, 138, 4, 70, "Input",
 CellID->17692],
Cell[17785, 668, 171, 5, 36, "Output",
 CellID->9511677]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18017, 680, 311, 9, 70, "SeeAlsoSection",
 CellID->12996],
Cell[18331, 691, 1458, 53, 70, "SeeAlso",
 CellID->3350]
}, Open  ]],
Cell[CellGroupData[{
Cell[19826, 749, 313, 9, 70, "TutorialsSection",
 CellID->9622],
Cell[20142, 760, 151, 3, 70, "Tutorials",
 CellID->23613],
Cell[20296, 765, 151, 3, 70, "Tutorials",
 CellID->20293]
}, Open  ]],
Cell[CellGroupData[{
Cell[20484, 773, 319, 9, 70, "MoreAboutSection",
 CellID->148589813],
Cell[20806, 784, 151, 3, 70, "MoreAbout",
 CellID->707798061],
Cell[20960, 789, 145, 3, 70, "MoreAbout",
 CellID->146427087],
Cell[21108, 794, 149, 3, 70, "MoreAbout",
 CellID->348928747],
Cell[21260, 799, 145, 3, 70, "MoreAbout",
 CellID->426541698]
}, Open  ]],
Cell[21420, 805, 27, 0, 70, "History"],
Cell[21450, 807, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

