(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21223,        817]
NotebookOptionsPosition[     15806,        620]
NotebookOutlinePosition[     17048,        656]
CellTagsIndexPosition[     16963,        651]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Operations on Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Length" :> Documentation`HelpLookup["paclet:ref/Length"], 
          "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Length\"\>", 
       2->"\<\"Characters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"String Manipulation\"\>", 
       3->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringLength", "ObjectName",
 CellID->6867],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringLength",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringLength"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of characters in a string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " counts special characters such as ",
 Cell[BoxData["\[Alpha]"], "InlineFormula"],
 " as single characters, even if their full names involve many characters. "
}], "Notes",
 CellID->21722],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives the list of lengths of each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17822]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326231437],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->159762836],

Cell["Find the number of characters in a string:", "ExampleText",
 CellID->30440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<tiger\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16807],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21584]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6713],

Cell["Find lengths of all strings in a list:", "ExampleText",
 CellID->25834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<cat\>\"", ",", "\"\<dog\>\"", ",", "\"\<fish\>\"", ",", 
    "\"\<coelenterate\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3", ",", "4", ",", "12"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " treats special characters just like ordinary ones:"
}], "ExampleText",
 CellID->8951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", 
  "\"\<\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ReturnIndicator]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21077],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8452],

Cell["Newlines count as one character:", "ExampleText",
 CellID->6999],

Cell[CellGroupData[{

Cell[BoxData["\"\<ab\\ncd\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->16891],

Cell[BoxData["\<\"ab\\ncd\"\>"], "Output",
 ImageSize->{18, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14052]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24734],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16707]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9020],

Cell["Find the growth rate of a string substitution system:", "ExampleText",
 CellID->5489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringReplace", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "->", "\"\<AB\>\""}], ",", 
        RowBox[{"\"\<B\>\"", "->", "\"\<A\>\""}]}], "}"}]}], "]"}], "&"}], 
   ",", "\"\<A\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"AB\"\>", ",", "\<\"ABA\"\>", 
   ",", "\<\"ABAAB\"\>", ",", "\<\"ABAABABA\"\>", 
   ",", "\<\"ABAABABAABAAB\"\>"}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12846]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20419],

Cell["The empty string has zero length:", "ExampleText",
 CellID->4713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19514],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23981]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24593],

Cell["\<\
Formatting constructs are included in giving lengths of formatted strings:\
\>", "ExampleText",
 CellID->6749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11942],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\* StyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, \
0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->5791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4827],

Cell[BoxData["50"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " counts every character as length 1, regardless of the length of its full \
name:"
}], "ExampleText",
 CellID->20227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\[Alpha]\[Beta]\[Gamma]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30223],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\[Alpha]\\[Beta]\\[Gamma]\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->26844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<\[Alpha]\[Beta]\[Gamma]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11668],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18752]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27762],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28666],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->27614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->597964600],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->925110146],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->90556217],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->57684413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StringLength"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringLength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 31.7666058}", "context" -> "System`", 
    "keywords" -> {"length of string"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringLength[\"string\"] gives the number of characters in a string. ", 
    "synonyms" -> {"string length"}, "title" -> "StringLength", "type" -> 
    "Symbol", "uri" -> "ref/StringLength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4846, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326231437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16820, 644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2157, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2780, 80, 49, 1, 70, "ObjectName",
 CellID->6867],
Cell[2832, 83, 514, 15, 70, "Usage",
 CellID->28073]
}, Open  ]],
Cell[CellGroupData[{
Cell[3383, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3861, 120, 333, 9, 70, "Notes",
 CellID->21722],
Cell[4197, 131, 612, 23, 70, "Notes",
 CellID->17822]
}, Closed]],
Cell[CellGroupData[{
Cell[4846, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326231437],
Cell[CellGroupData[{
Cell[5231, 173, 148, 5, 70, "ExampleSection",
 CellID->159762836],
Cell[5382, 180, 81, 1, 70, "ExampleText",
 CellID->30440],
Cell[CellGroupData[{
Cell[5488, 185, 116, 3, 28, "Input",
 CellID->16807],
Cell[5607, 190, 154, 5, 36, "Output",
 CellID->21584]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5810, 201, 215, 7, 70, "ExampleSection",
 CellID->6713],
Cell[6028, 210, 77, 1, 70, "ExampleText",
 CellID->25834],
Cell[CellGroupData[{
Cell[6130, 215, 229, 7, 70, "Input",
 CellID->9516],
Cell[6362, 224, 220, 7, 36, "Output",
 CellID->12050]
}, Open  ]],
Cell[6597, 234, 121, 3, 70, "ExampleDelimiter",
 CellID->28239],
Cell[6721, 239, 231, 7, 70, "ExampleText",
 CellID->8951],
Cell[CellGroupData[{
Cell[6977, 250, 248, 6, 70, "Input",
 CellID->21077],
Cell[7228, 258, 154, 5, 36, "Output",
 CellID->12012]
}, Open  ]],
Cell[7397, 266, 120, 3, 70, "ExampleDelimiter",
 CellID->8452],
Cell[7520, 271, 70, 1, 70, "ExampleText",
 CellID->6999],
Cell[CellGroupData[{
Cell[7615, 276, 80, 2, 70, "Input",
 CellID->16891],
Cell[7698, 280, 168, 5, 54, "Output",
 CellID->14052]
}, Open  ]],
Cell[CellGroupData[{
Cell[7903, 290, 104, 3, 70, "Input",
 CellID->24734],
Cell[8010, 295, 154, 5, 36, "Output",
 CellID->16707]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8213, 306, 222, 7, 70, "ExampleSection",
 CellID->9020],
Cell[8438, 315, 91, 1, 70, "ExampleText",
 CellID->5489],
Cell[CellGroupData[{
Cell[8554, 320, 380, 12, 70, "Input",
 CellID->16871],
Cell[8937, 334, 321, 9, 36, "Output",
 CellID->6900]
}, Open  ]],
Cell[CellGroupData[{
Cell[9295, 348, 104, 3, 70, "Input",
 CellID->32116],
Cell[9402, 353, 244, 8, 36, "Output",
 CellID->12846]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9695, 367, 233, 7, 70, "ExampleSection",
 CellID->20419],
Cell[9931, 376, 71, 1, 70, "ExampleText",
 CellID->4713],
Cell[CellGroupData[{
Cell[10027, 381, 111, 3, 70, "Input",
 CellID->19514],
Cell[10141, 386, 154, 5, 36, "Output",
 CellID->23981]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10344, 397, 226, 7, 70, "ExampleSection",
 CellID->24593],
Cell[10573, 406, 120, 3, 70, "ExampleText",
 CellID->6749],
Cell[CellGroupData[{
Cell[10718, 413, 163, 5, 70, "Input",
 CellID->11942],
Cell[10884, 420, 364, 13, 50, "Output",
 CellID->5791]
}, Open  ]],
Cell[CellGroupData[{
Cell[11285, 438, 166, 5, 70, "Input",
 CellID->4827],
Cell[11454, 445, 155, 5, 36, "Output",
 CellID->27682]
}, Open  ]],
Cell[11624, 453, 121, 3, 70, "ExampleDelimiter",
 CellID->18219],
Cell[11748, 458, 262, 8, 70, "ExampleText",
 CellID->20227],
Cell[CellGroupData[{
Cell[12035, 470, 130, 3, 70, "Input",
 CellID->30223],
Cell[12168, 475, 319, 11, 50, "Output",
 CellID->26844]
}, Open  ]],
Cell[CellGroupData[{
Cell[12524, 491, 137, 4, 70, "Input",
 CellID->11668],
Cell[12664, 497, 154, 5, 36, "Output",
 CellID->18752]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12879, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->27762],
Cell[13193, 520, 450, 17, 70, "SeeAlso",
 CellID->6869]
}, Open  ]],
Cell[CellGroupData[{
Cell[13680, 542, 314, 9, 70, "TutorialsSection",
 CellID->28666],
Cell[13997, 553, 151, 3, 70, "Tutorials",
 CellID->27614]
}, Open  ]],
Cell[CellGroupData[{
Cell[14185, 561, 319, 9, 70, "MoreAboutSection",
 CellID->597964600],
Cell[14507, 572, 169, 3, 70, "MoreAbout",
 CellID->925110146],
Cell[14679, 577, 148, 3, 70, "MoreAbout",
 CellID->90556217],
Cell[14830, 582, 144, 3, 70, "MoreAbout",
 CellID->57684413]
}, Open  ]],
Cell[CellGroupData[{
Cell[15011, 590, 305, 8, 70, "RelatedLinksSection"],
Cell[15319, 600, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[15724, 616, 52, 0, 70, "History"],
Cell[15779, 618, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

