(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33065,       1198]
NotebookOptionsPosition[     26138,        962]
NotebookOutlinePosition[     27862,       1005]
CellTagsIndexPosition[     27777,       1000]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Operations on Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringInsert" :> 
          Documentation`HelpLookup["paclet:ref/StringInsert"], "StringDrop" :> 
          Documentation`HelpLookup["paclet:ref/StringDrop"], "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "StringJoin" :> 
          Documentation`HelpLookup["paclet:ref/StringJoin"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringInsert\"\>", 
       2->"\<\"StringDrop\"\>", 3->"\<\"StringReplace\"\>", 
       4->"\<\"StringJoin\"\>", 5->"\<\"ReplacePart\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringReplacePart", "ObjectName",
 CellID->24095],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplacePart"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the characters at positions ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " by ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplacePart"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["m", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["m", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts copies of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\""], "InlineFormula"],
     " at several positions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplacePart"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"snew\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"snew\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["m", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["m", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces characters at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " by ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"snew\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->14983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " uses position specifications in the form returned by ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->95387040]
}], "Notes",
 CellID->30870],

Cell[TextData[{
 "When a list of ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"snew\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " is given, its length must be the same as the length of the list of \
positions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23353]
}], "Notes",
 CellID->20360],

Cell[TextData[{
 "When multiple positions are given, all refer to the original ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 ", before any replacements have been done. "
}], "Notes",
 CellID->13960],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", "\"\<\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be used to delete substrings. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20056]
}], "Notes",
 CellID->8310]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96740698],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->862044852],

Cell["Replace characters 2 through 5 with a new string:", "ExampleText",
 CellID->26599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<ABCDEFGH\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16016],

Cell[BoxData["\<\"aABCDEFGHfghijk\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349737086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29376],

Cell["Replace several sequences of characters with a new string:", \
"ExampleText",
 CellID->21816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<ABCDEFGH\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7650],

Cell[BoxData["\<\"ABCDEFGHbABCDEFGHfghABCDEFGH\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329284177]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7101],

Cell["Negative positions count from the end:", "ExampleText",
 CellID->13479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<ABCDEFGH\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24857],

Cell[BoxData["\<\"abcdefghABCDEFGHk\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259387283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18951],

Cell["Replace two sequences of characters with two new strings:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<XYZ\>\"", ",", "\"\<ABCD\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28495],

Cell[BoxData["\<\"aXYZdefghiABCDk\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->713910472]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5339267],

Cell[TextData[{
 "Simulating a multiway system ",
 ButtonBox["[more info]:",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-937"], None}]
}], "ExampleText",
 CellID->379802245],

Cell[BoxData[
 RowBox[{
  RowBox[{"step", "[", 
   RowBox[{"rule_List", ",", "slist_List"}], "]"}], ":=", 
  RowBox[{"Union", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"s", ",", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"step1", "[", 
            RowBox[{"#", ",", "s"}], "]"}], "&"}], ",", "rule"}], "]"}]}], 
       "]"}], ",", "slist"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1283512847],

Cell[BoxData[
 RowBox[{
  RowBox[{"step1", "[", 
   RowBox[{
    RowBox[{"p_String", "\[Rule]", "q_String"}], ",", "s_String"}], "]"}], ":=",
   
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"StringReplacePart", "[", 
      RowBox[{"s", ",", "q", ",", "#"}], "]"}], "&"}], ",", 
    RowBox[{"StringPosition", "[", 
     RowBox[{"s", ",", "p"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527185414],

Cell[BoxData[
 RowBox[{
  RowBox[{"evolvelist", "[", 
   RowBox[{"rule_", ",", "init_List", ",", "t_Integer"}], "]"}], ":=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"step", "[", 
      RowBox[{"rule", ",", "#"}], "]"}], "&"}], ",", "init", ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2035209223],

Cell["The evolution of a multiway system:", "ExampleText",
 CellID->324347935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"evolvelist", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<AAB\>\"", "\[Rule]", "\"\<BB\>\""}], ",", 
     RowBox[{"\"\<BA\>\"", "\[Rule]", "\"\<ABB\>\""}]}], "}"}], ",", 
   RowBox[{"{", "\"\<ABBAAB\>\"", "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->641881545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"ABBAAB\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ABABBAB\"\>", ",", "\<\"ABBBB\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AABBBBAB\"\>", ",", "\<\"ABABABBB\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AABBBABBB\"\>", ",", "\<\"ABAABBBBB\"\>", 
     ",", "\<\"BBBBBAB\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->147372114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->314671647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " can use the output from ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->95387040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pos", "=", 
  RowBox[{"StringPosition", "[", 
   RowBox[{"\"\<a1b22c333d\>\"", ",", 
    RowBox[{"DigitCharacter", ".."}], ",", 
    RowBox[{"Overlaps", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405489715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336053684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<a1b22c333d\>\"", ",", "\"\<XYZ\>\"", ",", "pos"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594822787],

Cell[BoxData["\<\"aXYZbXYZcXYZd\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226679562]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->786920928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<a1b22c333d\>\"", ",", 
   RowBox[{
    RowBox[{"DigitCharacter", ".."}], "\[Rule]", "\"\<XYZ\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224777333],

Cell[BoxData["\<\"aXYZbXYZcXYZd\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->221299988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339591212],

Cell[TextData[{
 "Replacing with an empty string is equivalent to ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32703],

Cell[BoxData["\<\"afghijk\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9202116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17758],

Cell[BoxData["\<\"afghijk\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226262950]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " can drop several sequences of characters at a time:"
}], "ExampleText",
 CellID->24049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27145],

Cell[BoxData["\<\"afij\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123936006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->791885892],

Cell[TextData[{
 "Use position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{
     StyleBox["n", "TI"], "-", 
     StyleBox["1", "TR"]}]}], "}"}]], "InlineFormula"],
 " to insert at position ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", without overwriting anything:"
}], "ExampleText",
 CellID->8790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<ABCDEFGH\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9100],

Cell[BoxData["\<\"abABCDEFGHcdefghijk\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507944608]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringInsert"]], "InlineFormula"],
 " can do the same:"
}], "ExampleText",
 CellID->755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefghijk\>\"", ",", "\"\<ABCDEFGH\>\"", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16010],

Cell[BoxData["\<\"abABCDEFGHcdefghijk\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->421703515]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->43833049],

Cell["The position specifications are not allowed to overlap:", "ExampleText",
 CellID->196342651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcde\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12026772],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplacePart", "::", "\<\"ovlp\"\>"}], ":", 
  " ", "\<\"Position \\!\\({3, 5}\\) overlaps previous positions; new string \
\\!\\(\\\"XYZ\\\"\\) will not be inserted. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/StringReplacePart/ovlp\\\", ButtonNote -> \
\\\"StringReplacePart::ovlp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->287764760],

Cell[BoxData["\<\"XYZde\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70181069]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6005],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24352]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7825],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->26241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->210854866],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->2387477]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StringReplacePart"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringReplacePart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 39.0792930}", "context" -> "System`", 
    "keywords" -> {
     "replace part of string", "replace string", "replace substring"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringReplacePart[\"string\", \" snew\", {m, n}] replaces the characters \
at positions m through n in \" string\" by \" snew\". \
StringReplacePart[\"string\", \" snew\", {{m_1, n_1}, {m_2, n_2}, ...}] \
inserts copies of \" snew\" at several positions. \
StringReplacePart[\"string\", {\"SubscriptBox[ snew, 1]\", \"SubscriptBox[ \
snew, 2]\", ...}, {{m_1, n_1}, {m_2, n_2}, ...}] replaces characters at \
positions m_i through n_i in \" string\" by \"SubscriptBox[ snew, i]\". ", 
    "synonyms" -> {"string replace part"}, "title" -> "StringReplacePart", 
    "type" -> "Symbol", "uri" -> "ref/StringReplacePart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8810, 280, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->96740698]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27635, 993}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2180, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2803, 79, 55, 1, 70, "ObjectName",
 CellID->24095],
Cell[2861, 82, 3909, 119, 70, "Usage",
 CellID->14983]
}, Open  ]],
Cell[CellGroupData[{
Cell[6807, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7285, 223, 463, 15, 70, "Notes",
 CellID->30870],
Cell[7751, 240, 352, 11, 70, "Notes",
 CellID->20360],
Cell[8106, 253, 238, 6, 70, "Notes",
 CellID->13960],
Cell[8347, 261, 426, 14, 70, "Notes",
 CellID->8310]
}, Closed]],
Cell[CellGroupData[{
Cell[8810, 280, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96740698],
Cell[CellGroupData[{
Cell[9194, 294, 148, 5, 70, "ExampleSection",
 CellID->862044852],
Cell[9345, 301, 88, 1, 70, "ExampleText",
 CellID->26599],
Cell[CellGroupData[{
Cell[9458, 306, 224, 6, 28, "Input",
 CellID->16016],
Cell[9685, 314, 181, 5, 36, "Output",
 CellID->349737086]
}, Open  ]],
Cell[9881, 322, 121, 3, 70, "ExampleDelimiter",
 CellID->29376],
Cell[10005, 327, 99, 2, 70, "ExampleText",
 CellID->21816],
Cell[CellGroupData[{
Cell[10129, 333, 438, 14, 70, "Input",
 CellID->7650],
Cell[10570, 349, 194, 5, 36, "Output",
 CellID->329284177]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10813, 360, 215, 7, 70, "ExampleSection",
 CellID->7101],
Cell[11031, 369, 77, 1, 70, "ExampleText",
 CellID->13479],
Cell[CellGroupData[{
Cell[11133, 374, 266, 8, 70, "Input",
 CellID->24857],
Cell[11402, 384, 183, 5, 36, "Output",
 CellID->259387283]
}, Open  ]],
Cell[11600, 392, 121, 3, 70, "ExampleDelimiter",
 CellID->18951],
Cell[11724, 397, 146, 3, 70, "ExampleText",
 CellID->23353],
Cell[CellGroupData[{
Cell[11895, 404, 431, 14, 70, "Input",
 CellID->28495],
Cell[12329, 420, 181, 5, 36, "Output",
 CellID->713910472]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12559, 431, 225, 7, 70, "ExampleSection",
 CellID->5339267],
Cell[12787, 440, 225, 7, 70, "ExampleText",
 CellID->379802245],
Cell[13015, 449, 539, 17, 70, "Input",
 CellID->1283512847],
Cell[13557, 468, 431, 14, 70, "Input",
 CellID->527185414],
Cell[13991, 484, 345, 11, 70, "Input",
 CellID->2035209223],
Cell[14339, 497, 78, 1, 70, "ExampleText",
 CellID->324347935],
Cell[CellGroupData[{
Cell[14442, 502, 327, 9, 70, "Input",
 CellID->641881545],
Cell[14772, 513, 526, 15, 36, "Output",
 CellID->147372114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15347, 534, 237, 7, 70, "ExampleSection",
 CellID->314671647],
Cell[15587, 543, 404, 13, 70, "ExampleText",
 CellID->95387040],
Cell[CellGroupData[{
Cell[16016, 560, 262, 7, 70, "Input",
 CellID->405489715],
Cell[16281, 569, 361, 13, 36, "Output",
 CellID->336053684]
}, Open  ]],
Cell[CellGroupData[{
Cell[16679, 587, 178, 5, 70, "Input",
 CellID->594822787],
Cell[16860, 594, 178, 5, 36, "Output",
 CellID->226679562]
}, Open  ]],
Cell[17053, 602, 215, 8, 70, "ExampleText",
 CellID->786920928],
Cell[CellGroupData[{
Cell[17293, 614, 226, 7, 70, "Input",
 CellID->224777333],
Cell[17522, 623, 178, 5, 36, "Output",
 CellID->221299988]
}, Open  ]],
Cell[17715, 631, 125, 3, 70, "ExampleDelimiter",
 CellID->339591212],
Cell[17843, 636, 279, 9, 70, "ExampleText",
 CellID->20056],
Cell[CellGroupData[{
Cell[18147, 649, 216, 6, 70, "Input",
 CellID->32703],
Cell[18366, 657, 170, 5, 36, "Output",
 CellID->9202116]
}, Open  ]],
Cell[CellGroupData[{
Cell[18573, 667, 192, 6, 70, "Input",
 CellID->17758],
Cell[18768, 675, 172, 5, 36, "Output",
 CellID->226262950]
}, Open  ]],
Cell[18955, 683, 243, 7, 70, "ExampleText",
 CellID->24049],
Cell[CellGroupData[{
Cell[19223, 694, 431, 14, 70, "Input",
 CellID->27145],
Cell[19657, 710, 169, 5, 36, "Output",
 CellID->123936006]
}, Open  ]],
Cell[19841, 718, 125, 3, 70, "ExampleDelimiter",
 CellID->791885892],
Cell[19969, 723, 362, 14, 70, "ExampleText",
 CellID->8790],
Cell[CellGroupData[{
Cell[20356, 741, 223, 6, 70, "Input",
 CellID->9100],
Cell[20582, 749, 185, 5, 36, "Output",
 CellID->507944608]
}, Open  ]],
Cell[20782, 757, 196, 7, 70, "ExampleText",
 CellID->755],
Cell[CellGroupData[{
Cell[21003, 768, 173, 5, 70, "Input",
 CellID->16010],
Cell[21179, 775, 185, 5, 36, "Output",
 CellID->421703515]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21413, 786, 229, 7, 70, "ExampleSection",
 CellID->43833049],
Cell[21645, 795, 98, 1, 70, "ExampleText",
 CellID->196342651],
Cell[CellGroupData[{
Cell[21768, 800, 322, 10, 70, "Input",
 CellID->12026772],
Cell[22093, 812, 463, 8, 70, "Message",
 CellID->287764760],
Cell[22559, 822, 169, 5, 36, "Output",
 CellID->70181069]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22789, 834, 310, 9, 70, "SeeAlsoSection",
 CellID->6005],
Cell[23102, 845, 1218, 44, 70, "SeeAlso",
 CellID->24352]
}, Open  ]],
Cell[CellGroupData[{
Cell[24357, 894, 313, 9, 70, "TutorialsSection",
 CellID->7825],
Cell[24673, 905, 151, 3, 70, "Tutorials",
 CellID->26241]
}, Open  ]],
Cell[CellGroupData[{
Cell[24861, 913, 319, 9, 70, "MoreAboutSection",
 CellID->210854866],
Cell[25183, 924, 143, 3, 70, "MoreAbout",
 CellID->2387477]
}, Open  ]],
Cell[CellGroupData[{
Cell[25363, 932, 305, 8, 70, "RelatedLinksSection"],
Cell[25671, 942, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[26081, 958, 27, 0, 70, "History"],
Cell[26111, 960, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

