(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34219,       1226]
NotebookOptionsPosition[     27010,        974]
NotebookOutlinePosition[     28761,       1018]
CellTagsIndexPosition[     28675,       1013]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Take" :> Documentation`HelpLookup["paclet:ref/Take"], 
          "StringDrop" :> Documentation`HelpLookup["paclet:ref/StringDrop"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Take\"\>", 2->"\<\"StringDrop\"\>", 
       3->"\<\"StringPosition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StringTake", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string containing the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["n", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " character in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives characters ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["spec", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["spec", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the substrings specified by the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringTake",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringTake"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24685]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringTake",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringTake"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives characters ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " through ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in steps of\[NonBreakingSpace]",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13896],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sequence specification."
}], "Notes",
 CellID->26263]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32953346],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->473652015],

Cell["Take the first 6 characters in a string:", "ExampleText",
 CellID->8249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27170],

Cell[BoxData["\<\"abcdef\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30989]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " to show quotes:"
}], "ExampleText",
 CellID->19788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14524],

Cell["\"abcdef\"", "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->15446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9339],

Cell["Take from the end of the string:", "ExampleText",
 CellID->1313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543],

Cell[BoxData["\<\"jklm\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29885],

Cell["Take characters 5 through 10:", "ExampleText",
 CellID->18715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31539],

Cell[BoxData["\<\"efghij\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19395]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24668],

Cell["Find character 6 in a string:", "ExampleText",
 CellID->10141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", "6", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14908],

Cell[BoxData["\<\"f\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14905],

Cell["\"f\"", "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->26482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4287],

Cell["Take every other character:", "ExampleText",
 CellID->17055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8603],

Cell[BoxData["\<\"acegikm\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16163],

Cell["Take the last 2 characters from several strings:", "ExampleText",
 CellID->9063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<abcdef\>\"", ",", "\"\<stuv\>\"", ",", "\"\<xyzw\>\""}], 
    "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ef\"\>", ",", "\<\"uv\"\>", ",", "\<\"zw\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18240],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " works with special characters:"
}], "ExampleText",
 CellID->26696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{
  "\"\<\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ReturnIndicator]\>\"", 
   ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12694],

Cell[BoxData["\<\"\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\
\[ReturnIndicator]\"\>"], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9383]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29332],

Cell[TextData[{
 "Newline (",
 Cell[BoxData["\\n"], "InlineFormula"],
 ") counts as a single character:"
}], "ExampleText",
 CellID->30067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abc\\ndef\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32560],

Cell[BoxData["\<\"abc\\nd\"\>"], "Output",
 ImageSize->{25, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15711],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " can effectively do \"part\" extraction in strings:"
}], "ExampleText",
 CellID->175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Characters", "[", "\"\<abcdefghijklm\>\"", "]"}], "[", 
  RowBox[{"[", "6", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21476],

Cell[BoxData["\<\"f\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10182]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", "6", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5321],

Cell[BoxData["\<\"f\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8501],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " works like applying ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " to the list of characters:"
}], "ExampleText",
 CellID->9293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<abcdefghijklm\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>"}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15426],

Cell[BoxData["\<\"efghij\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3679]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21608],

Cell["Taking between positions 1 and 0 gives a zero-length string:", \
"ExampleText",
 CellID->11931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<abcdef\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13727],

Cell[BoxData["\<\"\"\>"], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18662],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->19633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " operates on the raw characters in a string:"
}], "ExampleText",
 CellID->11523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", 
   RowBox[{"-", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292],

Cell[BoxData["\<\">RGBColor[1, 0, 0]]\\)\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4235]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12382],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\* StyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, \
0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->14012]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17633],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9719],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->1310],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->6742497],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->199187942],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->30843007]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringTake - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 40.4074520}", "context" -> "System`", 
    "keywords" -> {
     "extraction of substrings", "parts of strings", "string part", 
      "TakeString"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringTake[\"string\", n] gives a string containing the first n \
characters in \" string\". StringTake[\"string\", -n] gives the last n \
characters in \" string\". StringTake[\"string\", {n}] gives the \
n\\[Null]\\[Null]^th character in \" string\". StringTake[\"string\", {m, n}] \
gives characters m through n in \" string\". StringTake[\"string\", {spec_1, \
spec_2, ...}] gives a list of the substrings specified by the spec_i. \
StringTake[{s_1, s_2, ...}, spec] gives the list of results for each of the \
s_i. ", "synonyms" -> {"string take"}, "title" -> "StringTake", "type" -> 
    "Symbol", "uri" -> "ref/StringTake"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12778, 364, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32953346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28532, 1006}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2251, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2874, 80, 4194, 83, 70, "ObjectNameGrid"],
Cell[7071, 165, 4214, 135, 70, "Usage",
 CellID->24685]
}, Open  ]],
Cell[CellGroupData[{
Cell[11322, 305, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11800, 322, 670, 25, 70, "Notes",
 CellID->13896],
Cell[12473, 349, 268, 10, 70, "Notes",
 CellID->26263]
}, Closed]],
Cell[CellGroupData[{
Cell[12778, 364, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32953346],
Cell[CellGroupData[{
Cell[13162, 378, 148, 5, 70, "ExampleSection",
 CellID->473652015],
Cell[13313, 385, 78, 1, 70, "ExampleText",
 CellID->8249],
Cell[CellGroupData[{
Cell[13416, 390, 145, 4, 28, "Input",
 CellID->27170],
Cell[13564, 396, 167, 5, 36, "Output",
 CellID->30989]
}, Open  ]],
Cell[13746, 404, 200, 8, 70, "ExampleText",
 CellID->19788],
Cell[CellGroupData[{
Cell[13971, 416, 101, 3, 28, "Input",
 CellID->14524],
Cell[14075, 421, 165, 5, 50, "Output",
 CellID->15446]
}, Open  ]],
Cell[14255, 429, 120, 3, 70, "ExampleDelimiter",
 CellID->9339],
Cell[14378, 434, 70, 1, 70, "ExampleText",
 CellID->1313],
Cell[CellGroupData[{
Cell[14473, 439, 162, 5, 70, "Input",
 CellID->543],
Cell[14638, 446, 165, 5, 36, "Output",
 CellID->12224]
}, Open  ]],
Cell[14818, 454, 121, 3, 70, "ExampleDelimiter",
 CellID->29885],
Cell[14942, 459, 68, 1, 70, "ExampleText",
 CellID->18715],
Cell[CellGroupData[{
Cell[15035, 464, 195, 6, 70, "Input",
 CellID->31539],
Cell[15233, 472, 167, 5, 36, "Output",
 CellID->19395]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15449, 483, 216, 7, 70, "ExampleSection",
 CellID->24668],
Cell[15668, 492, 68, 1, 70, "ExampleText",
 CellID->10141],
Cell[CellGroupData[{
Cell[15761, 497, 169, 5, 70, "Input",
 CellID->14908],
Cell[15933, 504, 160, 5, 36, "Output",
 CellID->745]
}, Open  ]],
Cell[CellGroupData[{
Cell[16130, 514, 101, 3, 70, "Input",
 CellID->14905],
Cell[16234, 519, 160, 5, 50, "Output",
 CellID->26482]
}, Open  ]],
Cell[16409, 527, 120, 3, 70, "ExampleDelimiter",
 CellID->4287],
Cell[16532, 532, 66, 1, 70, "ExampleText",
 CellID->17055],
Cell[CellGroupData[{
Cell[16623, 537, 224, 7, 70, "Input",
 CellID->8603],
Cell[16850, 546, 168, 5, 36, "Output",
 CellID->27908]
}, Open  ]],
Cell[17033, 554, 121, 3, 70, "ExampleDelimiter",
 CellID->16163],
Cell[17157, 559, 86, 1, 70, "ExampleText",
 CellID->9063],
Cell[CellGroupData[{
Cell[17268, 564, 243, 8, 70, "Input",
 CellID->16292],
Cell[17514, 574, 239, 8, 36, "Output",
 CellID->17659]
}, Open  ]],
Cell[17768, 585, 121, 3, 70, "ExampleDelimiter",
 CellID->18240],
Cell[17892, 590, 208, 7, 70, "ExampleText",
 CellID->26696],
Cell[CellGroupData[{
Cell[18125, 601, 289, 8, 70, "Input",
 CellID->12694],
Cell[18417, 611, 231, 6, 36, "Output",
 CellID->9383]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18697, 623, 233, 7, 70, "ExampleSection",
 CellID->29332],
Cell[18933, 632, 139, 5, 70, "ExampleText",
 CellID->30067],
Cell[CellGroupData[{
Cell[19097, 641, 141, 4, 70, "Input",
 CellID->32560],
Cell[19241, 647, 168, 5, 54, "Output",
 CellID->13532]
}, Open  ]],
Cell[19424, 655, 121, 3, 70, "ExampleDelimiter",
 CellID->15711],
Cell[19548, 660, 226, 7, 70, "ExampleText",
 CellID->175],
Cell[CellGroupData[{
Cell[19799, 671, 173, 5, 70, "Input",
 CellID->21476],
Cell[19975, 678, 162, 5, 36, "Output",
 CellID->10182]
}, Open  ]],
Cell[CellGroupData[{
Cell[20174, 688, 168, 5, 70, "Input",
 CellID->5321],
Cell[20345, 695, 162, 5, 36, "Output",
 CellID->24632]
}, Open  ]],
Cell[20522, 703, 120, 3, 70, "ExampleDelimiter",
 CellID->8501],
Cell[20645, 708, 340, 12, 70, "ExampleText",
 CellID->9293],
Cell[CellGroupData[{
Cell[21010, 724, 247, 8, 70, "Input",
 CellID->30986],
Cell[21260, 734, 291, 8, 36, "Output",
 CellID->4149]
}, Open  ]],
Cell[CellGroupData[{
Cell[21588, 747, 215, 7, 70, "Input",
 CellID->15426],
Cell[21806, 756, 166, 5, 36, "Output",
 CellID->3679]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22021, 767, 226, 7, 70, "ExampleSection",
 CellID->21608],
Cell[22250, 776, 101, 2, 70, "ExampleText",
 CellID->11931],
Cell[CellGroupData[{
Cell[22376, 782, 187, 6, 70, "Input",
 CellID->13727],
Cell[22566, 790, 160, 5, 36, "Output",
 CellID->13063]
}, Open  ]],
Cell[CellGroupData[{
Cell[22763, 800, 100, 3, 70, "Input",
 CellID->18662],
Cell[22866, 805, 292, 11, 50, "Output",
 CellID->19633]
}, Open  ]],
Cell[23173, 819, 121, 3, 70, "ExampleDelimiter",
 CellID->25098],
Cell[23297, 824, 221, 7, 70, "ExampleText",
 CellID->11523],
Cell[CellGroupData[{
Cell[23543, 835, 206, 7, 70, "Input",
 CellID->292],
Cell[23752, 844, 183, 5, 36, "Output",
 CellID->4235]
}, Open  ]],
Cell[CellGroupData[{
Cell[23972, 854, 163, 5, 70, "Input",
 CellID->12382],
Cell[24138, 861, 365, 13, 50, "Output",
 CellID->14012]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24564, 881, 311, 9, 70, "SeeAlsoSection",
 CellID->17633],
Cell[24878, 892, 704, 26, 70, "SeeAlso",
 CellID->20813]
}, Open  ]],
Cell[CellGroupData[{
Cell[25619, 923, 313, 9, 70, "TutorialsSection",
 CellID->9719],
Cell[25935, 934, 150, 3, 70, "Tutorials",
 CellID->1310],
Cell[26088, 939, 174, 4, 70, "Tutorials",
 CellID->336637905]
}, Open  ]],
Cell[CellGroupData[{
Cell[26299, 948, 317, 9, 70, "MoreAboutSection",
 CellID->6742497],
Cell[26619, 959, 149, 3, 70, "MoreAbout",
 CellID->199187942],
Cell[26771, 964, 144, 3, 70, "MoreAbout",
 CellID->30843007]
}, Open  ]],
Cell[26930, 970, 50, 0, 70, "History"],
Cell[26983, 972, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

