(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12487,        459]
NotebookOptionsPosition[      9064,        343]
NotebookOutlinePosition[     10370,        380]
CellTagsIndexPosition[     10285,        375]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching and Reading Strings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SearchingAndReadingStrings"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Searching and Reading Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Characters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Low-Level File Operations\"\>", 
       2->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringToStream", "ObjectName",
 CellID->1825],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringToStream",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringToStream"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens an input stream for reading from a string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 " yields a stream of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16526],

Cell[TextData[{
 "Operations like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " work on streams returned by ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22975],

Cell[TextData[{
 "You must use ",
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 " to close streams created by ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10363]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112835389],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251547882],

Cell["Convert a string to a stream: ", "ExampleText",
 CellID->114746021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<234,32412,4234\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1710760725],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "30"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116084044]
}, Open  ]],

Cell["Read the first number from the stream object:", "ExampleText",
 CellID->1736668918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1744258449],

Cell[BoxData["234"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->589380386]
}, Open  ]],

Cell["Read the next character from the stream: ", "ExampleText",
 CellID->459027605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Character"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->136217562],

Cell[BoxData["\<\",\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->844004046]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->711868795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->747440128],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->172240684]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13143],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29644],

Cell[TextData[ButtonBox["Searching and Reading Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingAndReadingStrings"]], "Tutorials",
 CellID->6142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->379560629],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->80520754],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->21835901]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringToStream - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 40.8762140}", "context" -> "System`", 
    "keywords" -> {
     "reading from strings", "sscanf", "treating strings like files"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringToStream[\"string\"] opens an input stream for reading from a \
string. ", "synonyms" -> {"string to stream"}, "title" -> "StringToStream", 
    "type" -> "Symbol", "uri" -> "ref/StringToStream"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4997, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112835389]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10142, 368}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1926, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2549, 76, 51, 1, 70, "ObjectName",
 CellID->1825],
Cell[2603, 79, 523, 15, 70, "Usage",
 CellID->15238]
}, Open  ]],
Cell[CellGroupData[{
Cell[3163, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3641, 116, 499, 18, 70, "Notes",
 CellID->16526],
Cell[4143, 136, 468, 18, 70, "Notes",
 CellID->22975],
Cell[4614, 156, 346, 13, 70, "Notes",
 CellID->10363]
}, Closed]],
Cell[CellGroupData[{
Cell[4997, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112835389],
Cell[CellGroupData[{
Cell[5382, 188, 148, 5, 70, "ExampleSection",
 CellID->251547882],
Cell[5533, 195, 73, 1, 70, "ExampleText",
 CellID->114746021],
Cell[CellGroupData[{
Cell[5631, 200, 157, 4, 28, "Input",
 CellID->1710760725],
Cell[5791, 206, 225, 7, 36, "Output",
 CellID->116084044]
}, Open  ]],
Cell[6031, 216, 89, 1, 70, "ExampleText",
 CellID->1736668918],
Cell[CellGroupData[{
Cell[6145, 221, 131, 4, 28, "Input",
 CellID->1744258449],
Cell[6279, 227, 160, 5, 36, "Output",
 CellID->589380386]
}, Open  ]],
Cell[6454, 235, 84, 1, 70, "ExampleText",
 CellID->459027605],
Cell[CellGroupData[{
Cell[6563, 240, 133, 4, 70, "Input",
 CellID->136217562],
Cell[6699, 246, 166, 5, 36, "Output",
 CellID->844004046]
}, Open  ]],
Cell[6880, 254, 60, 1, 70, "ExampleText",
 CellID->711868795],
Cell[CellGroupData[{
Cell[6965, 259, 103, 3, 70, "Input",
 CellID->747440128],
Cell[7071, 264, 163, 5, 36, "Output",
 CellID->172240684]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7295, 276, 311, 9, 70, "SeeAlsoSection",
 CellID->13143],
Cell[7609, 287, 200, 6, 70, "SeeAlso",
 CellID->21398]
}, Open  ]],
Cell[CellGroupData[{
Cell[7846, 298, 314, 9, 70, "TutorialsSection",
 CellID->29644],
Cell[8163, 309, 165, 3, 70, "Tutorials",
 CellID->6142]
}, Open  ]],
Cell[CellGroupData[{
Cell[8365, 317, 319, 9, 70, "MoreAboutSection",
 CellID->379560629],
Cell[8687, 328, 158, 3, 70, "MoreAbout",
 CellID->80520754],
Cell[8848, 333, 144, 3, 70, "MoreAbout",
 CellID->21835901]
}, Open  ]],
Cell[9007, 339, 27, 0, 70, "History"],
Cell[9037, 341, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

