(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40911,       1391]
NotebookOptionsPosition[     34009,       1150]
NotebookOutlinePosition[     35250,       1186]
CellTagsIndexPosition[     35164,       1181]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StruveL" :> Documentation`HelpLookup["paclet:ref/StruveL"], 
          "BesselJ" :> Documentation`HelpLookup["paclet:ref/BesselJ"], 
          "BesselY" :> Documentation`HelpLookup["paclet:ref/BesselY"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"StruveL\"\>", 
       2->"\<\"BesselJ\"\>", 3->"\<\"BesselY\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions Used in Optics\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StruveH", "ObjectName",
 CellID->10690],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StruveH",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StruveH"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Struve function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         StyleBox["H",
          SingleLetterItalics->False,
          FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["H",
      SingleLetterItalics->False,
      FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{"z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", 
        SuperscriptBox["n", "2"]}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    
    RowBox[{
     FractionBox["2", "\[Pi]"], "\[InvisibleSpace]", 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "n", "-", "1"}], ")"}], "!!"}]]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->19139],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StruveH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveH"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->12846],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->3223355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29045936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->29432689],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->308134264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{"0", ",", "5.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9481597],

Cell[BoxData[
 RowBox[{"-", "0.21244833447546793`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200629806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42035776],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox[
      InterpretationBox["H",
       StruveH,
       Editable->False,
       Selectable->False],
      SingleLetterItalics->False,
      FontWeight->"Bold",
      FontSlant->"Plain"], "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->114350614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"StruveH", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70556718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150873099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605478359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"StruveH", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232918324],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], "\[Pi]"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"9", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"225", " ", "\[Pi]"}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "7"]}], 
    RowBox[{"11025", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], 
    RowBox[{"893025", " ", "\[Pi]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2/Pi, 0, Rational[-2, 9]/Pi, 0, Rational[2, 225]/Pi, 0, 
    Rational[-2, 11025]/Pi, 0, Rational[2, 893025]/Pi}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{301, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474597425]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7469],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->337704487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"7", "/", "3"}], "+", "I"}], ",", 
   RowBox[{"4.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100710779],

Cell[BoxData[
 RowBox[{"2.3576526265546756`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.400540725475053`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126792933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84931005],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->257377927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"StruveH", "[", 
    RowBox[{"0", ",", "4"}], "]"}], ",", " ", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80681587],

Cell[BoxData["0.\
1350145734224863971618958976170894634587458047767552296505506391196`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118883346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416893329],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->594100288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{"0", ",", "4.000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176846073],

Cell[BoxData["0.13501457342248639716189589777079653353`22.97141305065729"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->857592783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262493211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->843712961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540765259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.05217374424234107`", ",", "0.1984573362019444`", ",", 
   "0.41028847596941564`"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339383330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1457207232],

Cell[TextData[{
 "For half-integer indices, ",
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->514919149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43578819],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SqrtBox[
    FractionBox["2", "\[Pi]"]], 
   SqrtBox["x"]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], 
   SqrtBox["x"]]}]], "Output",
 ImageSize->{130, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20209645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46195782],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->66993709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StruveH", "[", 
   RowBox[{"\[Nu]", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297903020],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox[
     InterpretationBox["H",
      StruveH,
      Editable->False,
      Selectable->False],
     FontWeight->"Bold",
     FontSlant->"Plain"], "\[Nu]"], "(", "x", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->51859359]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2079],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveH"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->128267551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveH", "[", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113762563],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], "\[Pi]"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "\[Pi]"], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"9", " ", "\[Pi]"}]], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], 
    RowBox[{"6", " ", "\[Pi]"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"50", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "6"]}], 
    RowBox[{"180", " ", "\[Pi]"}]], "-", 
   FractionBox[
    RowBox[{"3541", " ", 
     SuperscriptBox["x", "7"]}], 
    RowBox[{"33075", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"5029", " ", 
     SuperscriptBox["x", "8"]}], 
    RowBox[{"37800", " ", "\[Pi]"}]], "-", 
   FractionBox[
    RowBox[{"525769", " ", 
     SuperscriptBox["x", "9"]}], 
    RowBox[{"3572100", " ", "\[Pi]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2/Pi, (-1)/Pi, Rational[4, 9]/Pi, Rational[-1, 6]/Pi, Rational[1, 50]/Pi, 
    Rational[11, 180]/Pi, Rational[-3541, 33075]/Pi, Rational[5029, 37800]/Pi,
     Rational[-525769, 3572100]/Pi}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{481, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131494383]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5325],

Cell["Solve the inhomogeneous Bessel differential equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->234677171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{
     FractionBox["2", "\[Pi]"], 
     RowBox[{"x", "^", "2"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580259273],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"1", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"BesselY", "[", 
       RowBox[{"1", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{"StruveH", "[", 
      RowBox[{"1", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{428, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387700306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199845510],

Cell["\<\
The diffraction pattern from an infinitely long line source by a circular \
aperture:\
\>", "ExampleText",
 CellID->88355536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"3", 
    RowBox[{"Pi", "/", 
     RowBox[{"(", 
      RowBox[{"8", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", 
    RowBox[{"StruveH", "[", 
     RowBox[{"1", ",", 
      RowBox[{"2", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->422976516],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8980167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26718],

Cell["Derivative:", "ExampleText",
 CellID->421588663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"StruveH", "[", 
    RowBox[{"\[Nu]", ",", "z"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633933223],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"-", "\[Nu]"}]], " ", 
      SuperscriptBox["z", "\[Nu]"]}], 
     RowBox[{
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["3", "2"], "+", "\[Nu]"}], "]"}]}]], "+", 
    RowBox[{"StruveH", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ",", "z"}], "]"}], "-", 
    RowBox[{"StruveH", "[", 
     RowBox[{
      RowBox[{"1", "+", "\[Nu]"}], ",", "z"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{392, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70190668]
}, Open  ]],

Cell["Anti-derivative:", "ExampleText",
 CellID->115311407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"StruveH", "[", 
    RowBox[{"\[Nu]", ",", "z"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->506603145],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "\[Nu]"}]], " ", 
  SuperscriptBox["z", 
   RowBox[{"2", "+", "\[Nu]"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["\[Nu]", "2"]}], "]"}], " ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"1", "+", 
       FractionBox["\[Nu]", "2"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["3", "2"], "+", "\[Nu]"}], ",", 
      FractionBox["3", "2"], ",", 
      RowBox[{"2", "+", 
       FractionBox["\[Nu]", "2"]}]}], "}"}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["z", "2"], "4"]}]}], "]"}]}]], "Output",
 ImageSize->{572, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67200336]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10362],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StruveL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4439],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->7377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1010],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/StruveFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/StruveH/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->165193584],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->366419328],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->272349327],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->93870597]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StruveH - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 46.3607294}", "context" -> "System`", 
    "keywords" -> {"Bessel equation", "Struve function", "Struve function H"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StruveH[n, z] gives the Struve function H n (z). ", 
    "synonyms" -> {"Struve H"}, "title" -> "StruveH", "type" -> "Symbol", 
    "uri" -> "ref/StruveH"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6633, 231, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29045936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35022, 1174}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2211, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2834, 79, 45, 1, 70, "ObjectName",
 CellID->10690],
Cell[2882, 82, 759, 26, 70, "Usage",
 CellID->24619]
}, Open  ]],
Cell[CellGroupData[{
Cell[3678, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4156, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4279, 136, 1075, 39, 70, "Notes",
 CellID->19139],
Cell[5357, 177, 571, 21, 70, "Notes",
 CellID->12846],
Cell[5931, 200, 244, 8, 70, "Notes",
 CellID->3223355],
Cell[6178, 210, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6397, 219, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6633, 231, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29045936],
Cell[CellGroupData[{
Cell[7017, 245, 147, 5, 70, "ExampleSection",
 CellID->29432689],
Cell[7167, 252, 201, 5, 70, "ExampleText",
 CellID->308134264],
Cell[CellGroupData[{
Cell[7393, 261, 126, 4, 28, "Input",
 CellID->9481597],
Cell[7522, 267, 194, 6, 36, "Output",
 CellID->200629806]
}, Open  ]],
Cell[7731, 276, 124, 3, 70, "ExampleDelimiter",
 CellID->42035776],
Cell[7858, 281, 520, 21, 70, "ExampleText",
 CellID->114350614],
Cell[CellGroupData[{
Cell[8403, 306, 242, 8, 28, "Input",
 CellID->70556718],
Cell[8648, 316, 4637, 80, 153, "Output",
 Evaluatable->False,
 CellID->150873099]
}, Open  ]],
Cell[13300, 399, 125, 3, 70, "ExampleDelimiter",
 CellID->605478359],
Cell[CellGroupData[{
Cell[13450, 406, 245, 8, 70, "Input",
 CellID->232918324],
Cell[13698, 416, 1048, 34, 55, "Output",
 CellID->474597425]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14795, 456, 215, 7, 70, "ExampleSection",
 CellID->7469],
Cell[15013, 465, 226, 5, 70, "ExampleText",
 CellID->337704487],
Cell[CellGroupData[{
Cell[15264, 474, 201, 7, 70, "Input",
 CellID->100710779],
Cell[15468, 483, 272, 7, 36, "Output",
 CellID->126792933]
}, Open  ]],
Cell[15755, 493, 124, 3, 70, "ExampleDelimiter",
 CellID->84931005],
Cell[15882, 498, 207, 5, 70, "ExampleText",
 CellID->257377927],
Cell[CellGroupData[{
Cell[16114, 507, 185, 6, 70, "Input",
 CellID->80681587],
Cell[16302, 515, 235, 7, 36, "Output",
 CellID->118883346]
}, Open  ]],
Cell[16552, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->416893329],
Cell[16680, 530, 250, 7, 70, "ExampleText",
 CellID->594100288],
Cell[CellGroupData[{
Cell[16955, 541, 151, 4, 70, "Input",
 CellID->176846073],
Cell[17109, 547, 218, 6, 36, "Output",
 CellID->857592783]
}, Open  ]],
Cell[17342, 556, 125, 3, 70, "ExampleDelimiter",
 CellID->262493211],
Cell[17470, 561, 345, 11, 70, "ExampleText",
 CellID->843712961],
Cell[CellGroupData[{
Cell[17840, 576, 191, 6, 70, "Input",
 CellID->540765259],
Cell[18034, 584, 277, 9, 36, "Output",
 CellID->339383330]
}, Open  ]],
Cell[18326, 596, 126, 3, 70, "ExampleDelimiter",
 CellID->1457207232],
Cell[18455, 601, 378, 12, 70, "ExampleText",
 CellID->514919149],
Cell[CellGroupData[{
Cell[18858, 617, 149, 5, 70, "Input",
 CellID->43578819],
Cell[19010, 624, 386, 16, 80, "Output",
 CellID->20209645]
}, Open  ]],
Cell[19411, 643, 124, 3, 70, "ExampleDelimiter",
 CellID->46195782],
Cell[19538, 648, 202, 7, 70, "ExampleText",
 CellID->66993709],
Cell[CellGroupData[{
Cell[19765, 659, 169, 5, 70, "Input",
 CellID->297903020],
Cell[19937, 666, 413, 16, 50, "Output",
 CellID->51859359]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20399, 688, 238, 7, 70, "ExampleSection",
 CellID->2079],
Cell[20640, 697, 346, 11, 70, "ExampleText",
 CellID->128267551],
Cell[CellGroupData[{
Cell[21011, 712, 265, 9, 70, "Input",
 CellID->113762563],
Cell[21279, 723, 1493, 47, 55, "Output",
 CellID->131494383]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22821, 776, 222, 7, 70, "ExampleSection",
 CellID->5325],
Cell[23046, 785, 233, 5, 70, "ExampleText",
 CellID->234677171],
Cell[CellGroupData[{
Cell[23304, 794, 632, 22, 70, "Input",
 CellID->580259273],
Cell[23939, 818, 611, 20, 36, "Output",
 CellID->387700306]
}, Open  ]],
Cell[24565, 841, 125, 3, 70, "ExampleDelimiter",
 CellID->199845510],
Cell[24693, 846, 135, 4, 70, "ExampleText",
 CellID->88355536],
Cell[CellGroupData[{
Cell[24853, 854, 474, 16, 70, "Input",
 CellID->422976516],
Cell[25330, 872, 3004, 53, 70, "Output",
 Evaluatable->False,
 CellID->8980167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28383, 931, 233, 7, 70, "ExampleSection",
 CellID->26718],
Cell[28619, 940, 54, 1, 70, "ExampleText",
 CellID->421588663],
Cell[CellGroupData[{
Cell[28698, 945, 184, 6, 70, "Input",
 CellID->633933223],
Cell[28885, 953, 744, 26, 69, "Output",
 CellID->70190668]
}, Open  ]],
Cell[29644, 982, 59, 1, 70, "ExampleText",
 CellID->115311407],
Cell[CellGroupData[{
Cell[29728, 987, 192, 6, 70, "Input",
 CellID->506603145],
Cell[29923, 995, 876, 30, 54, "Output",
 CellID->67200336]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30860, 1032, 311, 9, 70, "SeeAlsoSection",
 CellID->10362],
Cell[31174, 1043, 690, 26, 70, "SeeAlso",
 CellID->29574]
}, Open  ]],
Cell[CellGroupData[{
Cell[31901, 1074, 313, 9, 70, "TutorialsSection",
 CellID->4439],
Cell[32217, 1085, 143, 3, 70, "Tutorials",
 CellID->7377]
}, Open  ]],
Cell[CellGroupData[{
Cell[32397, 1093, 320, 9, 70, "RelatedLinksSection",
 CellID->1010],
Cell[32720, 1104, 185, 4, 70, "RelatedLinks"],
Cell[32908, 1110, 205, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33150, 1119, 319, 9, 70, "MoreAboutSection",
 CellID->165193584],
Cell[33472, 1130, 158, 3, 70, "MoreAbout",
 CellID->366419328],
Cell[33633, 1135, 157, 3, 70, "MoreAbout",
 CellID->272349327],
Cell[33793, 1140, 144, 3, 70, "MoreAbout",
 CellID->93870597]
}, Open  ]],
Cell[33952, 1146, 27, 0, 70, "History"],
Cell[33982, 1148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

