(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12890,        460]
NotebookOptionsPosition[      9505,        344]
NotebookOutlinePosition[     10811,        381]
CellTagsIndexPosition[     10726,        376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Automatic Loading of Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AutomaticLoadingOfPackages"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Automatic Loading of Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stub", "ObjectName",
 CellID->18093],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Stub",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that if a symbol is \
ever used, ",
     Cell[BoxData[
      ButtonBox["Needs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
     " should automatically be called on the context of the symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Symbols with the ",
 Cell[BoxData[
  ButtonBox["Stub",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
 " attribute are created by ",
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31612],

Cell["\<\
A symbol is considered \[OpenCurlyDoubleQuote]used\[CloseCurlyDoubleQuote] if \
its name appears explicitly, not in the form of a string. \
\>", "Notes",
 CellID->24976],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"], "[", "\"\<\!\(\*
StyleBox[\"nameform\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", "\"\<\!\(\*
StyleBox[\"nameform\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " do not constitute \[OpenCurlyDoubleQuote]uses\[CloseCurlyDoubleQuote] of a \
symbol. "
}], "Notes",
 CellID->30986]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158851390],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->408476787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePackage", "[", 
  RowBox[{"\"\<BarCharts`\>\"", ",", "\"\<BarChart\>\""}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->622561236],

Cell[BoxData["\<\"BarCharts`\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511723545]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\"\<BarChart\>\"", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->923321450],

Cell[BoxData[
 RowBox[{"{", "Stub", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->624270617]
}, Open  ]],

Cell["\<\
Use of the symbol implies reading the corresponding package automatically:\
\>", "ExampleText",
 CellID->929089169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "2"}], "}"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->532787260],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81SwjAQDrSAfweP3sSDjF7Kj17lqCdPHh0PDOMMHBwReQBewxfwpZjx
EXiFuklTTQOhaYF2C8tA0u0mu98m22WbtI+9yeD1rTcZ9nv1h3FvNBj2P+v3
72M45ZQYY3P4fZ0xOPbhSPzmvg+1WnpQOsBqQe1C3Zb0DefyA1982Llo3dTO
thQaSna7gm+W0tZoXbcnsdWX9u4s0VmWlqjYLqx661hCact7C9r9pxdHoBnp
70mqo9Tm0VbniTnSjPBQac0lVbRzs6B5BJu7gNbNuNdPYEBC+QeCnk6nL8/f
8GUNXnBa8g8Fv+k9Sf6l4AMd4afvf5RqVJCgVvym6gdep/sKDqSnEt260jaH
BucYEaqioyIvJ1TkT4SKUBXTy025OKfx5lfRbLWmYSwT5swwcxIjVu63RfFf
HSP+u6+aHF2cSHFFWLz/QoSq6KjIywkV+ROhwoqK/CkuDwyq4KPfA+DNX3Wk
IjUswA7CbuN25NV2BeJPEOFSW9ztNS6bHaxskITRuZuZtnxs3CetNJ+klbyI
tO7XfJpzaNMeRj45SFWjdT6hWo2Kk/mg4Q6Gx4/0zDX/TNa0G0AxjrTSfJJW
8iLSugmt2WUA+djoWq4BZ5tXKwSCFTT7lVCO5xq6H1vo5e3Eiuni+wixdn/E
yO9uVW7SJ/ktpVqsU9pJCuPw2Lp1Oh1Z9iJ7cNuDcxT06G5anbC97n0lOsc9
TWgn0/YuPF3E0+1Mh1GX6vjrRKdkz+Elj52mO2M8XrlrVxnZg3sUHGb3zme+
WdXWsjUlNlSWyuQnRqEsyErhyxq8iI3W8Xvcs5S2zf5mzpQLBi0W38hmpV9f
4n3m\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{238, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->534884602]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16336],

Cell["Stub symbols are created in the declared context:", "ExampleText",
 CellID->150170874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePackage", "[", 
  RowBox[{"\"\<Histograms`\>\"", ",", "\"\<Histogram\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121535974],

Cell[BoxData["\<\"Histograms`\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183254195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Context", "[", "\"\<Histogram\>\"", "]"}], ",", 
   RowBox[{"Attributes", "[", "\"\<Histogram\>\"", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98958239],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Histograms`\"\>", ",", 
   RowBox[{"{", "Stub", "}"}]}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6134064]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21674],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->7697],

Cell[TextData[ButtonBox["Automatic Loading of Packages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AutomaticLoadingOfPackages"]], "Tutorials",
 CellID->9656]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->6801988]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stub - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 47.1419994}", "context" -> "System`", 
    "keywords" -> {"autoloading", "attribute", "needs", "load on demand"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Stub is an attribute which specifies that if a symbol is ever used, \
Needs should automatically be called on the context of the symbol. ", 
    "synonyms" -> {}, "title" -> "Stub", "type" -> "Symbol", "uri" -> 
    "ref/Stub"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4252, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->158851390]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10583, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1328, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1951, 61, 42, 1, 70, "ObjectName",
 CellID->18093],
Cell[1996, 64, 640, 19, 70, "Usage",
 CellID->24814]
}, Open  ]],
Cell[CellGroupData[{
Cell[2673, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3151, 105, 345, 13, 70, "Notes",
 CellID->31612],
Cell[3499, 120, 179, 4, 70, "Notes",
 CellID->24976],
Cell[3681, 126, 534, 17, 70, "Notes",
 CellID->30986]
}, Closed]],
Cell[CellGroupData[{
Cell[4252, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158851390],
Cell[CellGroupData[{
Cell[4637, 162, 148, 5, 70, "ExampleSection",
 CellID->408476787],
Cell[CellGroupData[{
Cell[4810, 171, 190, 5, 28, "Input",
 CellID->622561236],
Cell[5003, 178, 175, 5, 36, "Output",
 CellID->511723545]
}, Open  ]],
Cell[CellGroupData[{
Cell[5215, 188, 146, 4, 28, "Input",
 CellID->923321450],
Cell[5364, 194, 183, 6, 36, "Output",
 CellID->624270617]
}, Open  ]],
Cell[5562, 203, 125, 3, 70, "ExampleText",
 CellID->929089169],
Cell[CellGroupData[{
Cell[5712, 210, 196, 6, 28, "Input",
 CellID->532787260],
Cell[5911, 218, 1123, 23, 174, "Output",
 Evaluatable->False,
 CellID->534884602]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7083, 247, 233, 7, 70, "ExampleSection",
 CellID->16336],
Cell[7319, 256, 92, 1, 70, "ExampleText",
 CellID->150170874],
Cell[CellGroupData[{
Cell[7436, 261, 167, 4, 70, "Input",
 CellID->121535974],
Cell[7606, 267, 176, 5, 36, "Output",
 CellID->183254195]
}, Open  ]],
Cell[CellGroupData[{
Cell[7819, 277, 219, 6, 70, "Input",
 CellID->98958239],
Cell[8041, 285, 247, 8, 36, "Output",
 CellID->6134064]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8349, 300, 314, 9, 70, "TutorialsSection",
 CellID->21674],
Cell[8666, 311, 130, 3, 70, "Tutorials",
 CellID->7697],
Cell[8799, 316, 165, 3, 70, "Tutorials",
 CellID->9656]
}, Open  ]],
Cell[CellGroupData[{
Cell[9001, 324, 299, 8, 70, "MoreAboutSection"],
Cell[9303, 334, 130, 3, 70, "MoreAbout",
 CellID->6801988]
}, Open  ]],
Cell[9448, 340, 27, 0, 70, "History"],
Cell[9478, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

