(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    110357,       2752]
NotebookOptionsPosition[    101742,       2445]
NotebookOutlinePosition[    103044,       2482]
CellTagsIndexPosition[    102957,       2477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
          "ChiSquareDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiSquareDistribution"], 
          "CauchyDistribution" :> 
          Documentation`HelpLookup["paclet:ref/CauchyDistribution"], 
          "NoncentralStudentTDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/NoncentralStudentTDistribution"], "Beta" :> 
          Documentation`HelpLookup["paclet:ref/Beta"], "BetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/BetaRegularized"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NormalDistribution\"\>", 
       2->"\<\"ChiSquareDistribution\"\>", 3->"\<\"CauchyDistribution\"\>", 
       4->"\<\"NoncentralStudentTDistribution\"\>", 5->"\<\"Beta\"\>", 
       6->"\<\"BetaRegularized\"\>", 
       7->"\<\"InverseBetaRegularized\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Statistical Distributions\"\>", 
       4->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StudentTDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StudentTDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StudentTDistribution"], "[", 
       StyleBox["\[Nu]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9699]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData["x"], "InlineFormula"],
 " in a Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " degrees of freedom is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Nu]", "/", 
      RowBox[{"(", 
       RowBox[{"\[Nu]", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Nu]"}], ")"}], "/", "2"}]], TraditionalForm]], 
  "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2129,
  ButtonNote->"2129"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 "For integer ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 ", the Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution gives the distribution of the deviation from the true mean of \
the observed mean for a sample of ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " values from a normal distribution, normalized by standard deviation of the \
sample."
}], "Notes",
 CellID->417885378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellID->21086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25532,
  ButtonNote->"25532"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126330658],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->1000683],

Cell[TextData[{
 "The mean and variance of a Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22901],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vs1OwzAMzpK0HYgBGgghcdmNG48BJ96BUiFthwk0Ju0RgMOeOSSZ3aWu
k1bdoFLr+O+L8zVx+1yu52/Lcr2oytnTqvyYL6rP2eP7yprUSAixtffdrbBj
Y0f+3hpjZfhU9qmsK7cys1Jk3gyXGzuvBK+T2koNWQp09HsD5FJddaIrgjoJ
dPRLgiqDCsChdtBuOCa6j8pqHWAS1iDXl16QKIgtSKwKEPdR+oBqVGL2KTd7
QpfM6vT/8JeoivUfn8NEBZd9eOxc598wmUXqj9mHModnLzbX+WCOsH/046be
o3pvF01Pv/fLRknkoxdLfC08esZaOdZoDU22IlaeOx3G0g6piQ1XRTsr6rKm
wV/giWVzs3HIFxFemzMh05LU1L1nJh3+B6Jftd4nPcfX7Lz4nTyDKu+J3+mu
Td+w2V/eiiv8qbUw5jth5fEOsRbAckXstBuPTeoE54bbsa+wzgLkKckagnUC
ku2nPbFKQ999foQK26iUwzg6/oG1UV+4nEDnztVud7axNmws/mVtTNCT4O9Q
jH4BV9suEw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55342733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14777],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V81SwjAQDk3KjwqKOo5HLo43H0NPjkfPHcYZmAGtwDjcetMTw5FH4Mgj
+Ag8BkceoSZp0qbbbWhBzQxNd7P77eZLsimP3qT3MvQm/a7XeRh5fq/fHXfu
30ZcRSuEkBn/3VwT/h7yN/mbhSHvqXiy6XT6Ldtms/lM9DQIglA28lVCW+UP
l4cgrhxWTRrx3lGjome8Z7wXeqpkPR7BRg3KdCc6BahNQ9bjDkB1jAyys6rr
EEqWVm4sKxiL1vCVqdeAlbKtAVtqICZW7IBsqCX6ORbdIjvI7Nj/8GfJCh3/
fQ4tGZwV4XHnPP+GSTcn/zz9vszps5cXq7U3R7p+FOMm3qMs0ZP0SLH1Ra0c
zUchlvBccHQX1WKswRzSbOVoce6YaQsrJAM6PStYWbXsxDTIpkbyvLFoGPJp
Dq/pSJppB+S0e880gQzH74B8kVlPeI4v0bj6njxRWd4CLyGLMn2Fepe5kctr
oxksFovlchnPwMjt3bBKfFsmz7A+GPLA8PZ9fz6fi9dGGNULuD9chNEBmjs8
G9BL74dhce+cexJHMHeOsBIrnD19xXL/OHglhwAR3or10FZJo++Q9XodyEba
4iFkNf6kuKypvo7O1Ya93W5T2FwG2A0jRqYaZ1Alr6lzWFX+R8AfzyrrDxk7
BnIFxWkDq2csuiELe/GRLtCKIQ5KcN1WHLyGthpofq8IrElixVarVbROfPFb
aOSx7KN/FKTyA2Puj/A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488726348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28146],

Cell[TextData[{
 "The probability density function depends on the ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22767],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Nu]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ")"}], 
   FractionBox[
    RowBox[{"1", "+", "\[Nu]"}], "2"]], 
  RowBox[{
   SqrtBox["\[Nu]"], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["\[Nu]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}]}]]], "Output",
 ImageSize->{109, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12859224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "3", "]"}], ",", "x"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->588535587]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29004],

Cell[TextData[{
 "Generate a set of random numbers that have the Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellID->5680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "10", "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9415774327175022`"}], ",", 
   RowBox[{"-", "1.0136822954638662`"}], ",", "0.873304977980275`", ",", 
   "0.3815530163133755`", ",", "0.4333631176029625`"}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121422571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23704],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22655],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VktOwzAQdWwnaauUvxASm+7YcQxYcQfSCKldIFAp4gjAomc2tjtOnMnY
CW0hUjqeN+Pn8bPj+qFcL56ey/WyKmf3q/J1sazeZncvKw2JhDG20e/1FdNt
pVv23Silrf8r9K/QoUzbVFuWWhge0zZRDlFjpbYSegnwXdwC0Bf7opddINap
57s4R6zcqwACYkttmiPk26y09oEmgnp9bek5yoLcHOUKj7HJkntUIyKjn1Gj
R3xOzE7+j36Rqsj44TWMVHAyRMfeef6Nkmmg/hC+q3Lu2wuNdbSzRu78GKZN
vUdlg7N2ZNj6klnc6TFIJboWmj0lUUo1XENbrQBKayf9XHxCSoS5WeGT1fm8
lsE+EAn1pkajmI8DurZHckpzVFP/npn2xG+Rf95ZT/wdX5Djuv/JAqq8QXHj
m2P6kuz9aVE3w+/a83O+IijNtw+ag8oVwvFpPI6uRqaoHTuHeeZgR2QWva/j
jGOwE23NVScx9hc8pcKrnwFjcTBGrOBENfu6fe/qsj2ivng3nHaqLEie94ji
7nb1ofyV3d4KWfIDVY4lHA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1359514]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27582],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V8tOwkAULe0UxPcrRBMXKDHu/ALXuHItGDWpxkQWRqIu2LHTFWHJJ7Dk
E/wEPoPPqNPpHTqc3ikVH5PA9L7OvffMdAYugrfHh6fgrXUfVM9fgvZj6/61
Wn9+kSqv4DhOT36O9xz5HMon9emFoZy96Ft0Op1PNSaTyXui97rdbqiG88Fq
i/LLl2COr8w0lJOcXbJGs5CzkHOk90jW9hg2Hih7c9E9QF0zZG13AdU1Kkh3
taRTkKy8/KlMMBlaI1aVXgIv8i2Br2cgJl7iB9V4Gdm3uewZsst0J/6Hv4yq
WPvvc5hRwWYeHuf2+TdM+pb6bfpFmdPvni3X+sIc6fMjHzfTPSoSvTNrybe+
rJer+cjFEl8Lj+6zWo41rGGWLYuW506YvnhCCtDprvBk1bI7pUENstiiuWwc
8oaF19lMmmkXapq/Z9ZARvspyDup9cT3eJfNq+/JVaryBKIiOTqmK2w0f/f+
rTbuazAYDIdDXaFZ8a3hlcQeEfvICspNI7rdbvf7/ejxIEyfImqxGcQmW3s1
NO51Zt9cWaPMfFm3Jo9wSPjROqffQb7WI6jx7htrVCKecb82QMbbcYXiCiwq
Xz3+SmlQryWaoz1dIEwedxkQ9FseVyd/ddIpsKXIlzL5nVGGssFu0Vo9ZsHe
L0N8d4uEu8T2bT85XYb5NDrmL6c8+AzYR4Uy1kGPe9w8K+3182u8B7HXubD0
LtwH75vQuP1SUTWy8vu9Bl0FiZcYjUZdNcbjsUaJ7fF/GafwBQaws9U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->708996311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13237],

Cell[TextData[{
 "The 0.75 quantile of a Student ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{"\[Nu]", "=", "5"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "5", "]"}], ",", "0.75"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25764],

Cell[BoxData["0.7266868438004231`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74996132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7660],

Cell[TextData[{
 "Compute p\[Hyphen]values for a t\[Hyphen]test with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " degrees of freedom and alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "<", "t"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->813014373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "n", "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338871180],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"BetaRegularized", "[", 
      RowBox[{
       FractionBox["n", 
        RowBox[{"n", "+", 
         SuperscriptBox["t", "2"]}]], ",", "1", ",", 
       FractionBox["n", "2"], ",", 
       FractionBox["1", "2"]}], "]"}], " ", 
     RowBox[{"Sign", "[", "t", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{322, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18957281]
}, Open  ]],

Cell[TextData[{
 "Alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", ">", "t"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->326644389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"StudentTDistribution", "[", "n", "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->944228315],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{
      RowBox[{"BetaRegularized", "[", 
       RowBox[{
        FractionBox["n", 
         RowBox[{"n", "+", 
          SuperscriptBox["t", "2"]}]], ",", "1", ",", 
        FractionBox["n", "2"], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"Sign", "[", "t", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{350, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->784666831]
}, Open  ]],

Cell[TextData[{
 "Alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "X", "\[RightBracketingBar]"}], ">", 
    "t"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->86298351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"StudentTDistribution", "[", "n", "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->892686001],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{
     FractionBox["n", 
      RowBox[{"n", "+", 
       SuperscriptBox["t", "2"]}]], ",", "1", ",", 
     FractionBox["n", "2"], ",", 
     FractionBox["1", "2"]}], "]"}], " ", 
   RowBox[{"Sign", "[", "t", "]"}]}]}]], "Output",
 ImageSize->{294, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182845145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183138611],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->12056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "15", "]"}], ",", "x"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563811319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3501],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellID->32525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Nu]", ",", 
     RowBox[{"1", "/", "10"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19697],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlXQVYVckXJx4pYC9rIoLdYq4uc7FbVGwRUcQW1wILXbu71wS7FbvmGdii
DwQMVBoUpUHy8Yc385v3v1e//T6/354zJ+6dOWfOmblP+/E+gycaGRgYNDc3
MCj7m/0xV+/fV/bnFqnXe7tj7+0qgfuUQUdDgT9fn/Hp+oxCClxfx58t8Bcd
PUXgGB3+JDDTd/MucDijE+D3bLzADky+wB+ZfoF7MfskOb9KkuszV2L1qRV/
lf73XvgLDH+B4S8w/AWGv8DwFxj+AsNfYPgLDH+B4S8w/JXzqyS5PnMlVs9z
NSv9L0H4Cwx/geEvMPwFhr/A8BcY/gLDX2D4Cwx/geEvMPyV86skuT5zJVb/
4ZFR1SPjp/AXGP4Cw19g+AsMf4HhLzD8BYa/wPAXGP4Cw19g+CvnV0lyfeZK
rI7SyckS/gLDX2D4Cwx/geEvMPwFhr/A8BcY/gLDX2D4Cwx/5fwqSa7PXInV
Te/HNrkf+0v4Cwx/geEvMPwFhr/A8BcY/gLDX2D4Cwx/geEvMPyV86skuT5z
JVYvDh5e+l+R8BcY/gLDX2D4Cwx/geEvMPwFhr/A8BcY/gLDX2D4K+dXSXJ9
5kqs9tb9MZDgLzD8BYa/wPAXGP4Cw19g+AsMf4HhLzD8BYa/wPBXzq+S5PrM
lVht8/1I6X9Gwl9g+AsMf4HhLzD8BYa/wPAXGP4Cw19g+AsMf4Hhr5xfJcn1
mSuxmqlVCX+B4S8w/AWGv8DwFxj+AsNfYPgLDH+B4S8w/AWGv3J+lSTXZ67E
6rFl4bqqmfAXGP4Cw19g+AsMf4HhLzD8BYa/wPAXGP4Cw19g+CvnV0lyfeZK
rDbVJWQL4S8w/AWGv8DwFxj+AsNfYPgLDH+B4S8w/AWGv8DwV86vkuT6zJVY
fSFv/cW89eWEv8DwFxj+AsNfYPgLDH+B4S8w/AWGv8DwFxj+AsNfOb9Kkusz
V2L1MF3Athb+AsNfYPgLDH+B4S8w/AWGv8DwFxj+AsNfYPgLDH/l/CpJrs9c
idXs7wrCX2D4Cwx/geEvMPwFhr/A8BcY/gLDX2D4Cwx/geGvnF8lMPwF1rH3
NuX5JoQA6/7aHi3ys4IuAUOecnwT3X7GRjxPYIxXYqU9qN+AUd+AX0lX+gf5
OjcczdQzy57q9WDCsaTArD74pzz4JWDYrxwP/Riv1K+Qp1bWp5AH+Ur9Cnni
fdzUTQ8j8T4Y1lJgVuPnCczma4bA9jo58QSYzZcMgbUlZX9+CXyNyReYTU8j
Sa7fSNgHfcBvdANeEmDoB4Z+YOgDhj5gvH/gJCafPinbTi7+JvQBQx8w9AHD
X2DoB8b8auNU9ieDNGDyKDD0A0M/MPQDQz8w9APDX2D4C4znvbJsOZzKEc8b
GPYBwz5g2AcM+4BhHzDsUep751Kr9L8CoQ8Y+oChDxj6gKEPGM8fGPqBMd/Z
+9cq5ptW2AMMe4Dl81GrmI9axXzUKuajVujXPY4VhhL0A0M/MPQDQz8w9AND
PzD0K/XF6gKcsdAHDH3A0AcMfcDQB4z5CAz9wIgvZbuDi3kmwh5g2AMMe4Bh
DzDsAYY9wLAHGPpb69aDudAPDP3A0A8M/cDQDwz9wNAPDP0s71oK/cDQDwz9
wNAPDP3A0A8M/cDQv1w3IayEfmDoB4Z+YOgHhn5g6AeGfmDoR36FfmDoB4Z+
YOgHhn5g6AeGfmU+121PL0YRef0cQuT1cwiR18/6/KjsZ4MO+5X5E/sPeXyJ
JvL6WZ9flf1dZb4FHf4p+91yfkORb+X1dojwX74/0FIlRj6DP8Dy+KjPp8p+
rjKfy/u1Gb/1b5X5XNnPBR37IWC8H9gHrMy/oAOjPwr7gWGvsj+r3B8o+7PK
/QHoyL+wB/szZX6W92MzhP3AoMN+YNgPDPuBYa+y36rcXyj7q8r9hbLfqrQf
+Rb2oj8Je4FhLzDsBYa98n5ohsCwBxjzVZnv5f3PDIFhDzDsAYY9wLBH3q/M
+K1/qdyPgA575P3JDIFhDzDsAYY9wLBH3k/MEBj6gaEf+Vi+vzeS5PHLSOgH
hn5geT1gJMnrASNJvv83EvFfuR9g71El7AGGPcCwBxj2AMMeYNgDjPWp3K+A
Dnvk/bYMgWEPMOwBhj3AsEfeH8sQGPqBoV/e/8oQGPqBoR8Y+oGhX96vyhAY
+oGhX96PyhAY+oGhHxj6gaFf3j/KEBj6gaFf3h/KEBj6gaEfGPqBoV/ez8kQ
GPqBoR/1M/QDQz8w9ANDPzD0A0M/MPQDs7hqIvoFwNivsPlrIup/1HcKrFZi
jGf/31SqrQtQD4i8/6/fvyjPt5X7Afl5cMZv57vgx/5JmY+V56WgYz+CfIL9
lTK/KM/vlPFeef6B9Y793wjd+w4T/Rf4z5+PWie+yQu+bzETGM8f+y3mrol4
nngfwJCP8aDj+XK6BHugD+ORX5V0ZT8J7xdYeb4POrM3k0Bebd2Ad+SV7k8s
2aZTYCABF+nmZxJ/Lilkuu7vfIEhz1w3ATI53VgChjxmT6EYrxPfT3/egeej
kzea99Mynor9EezfqZOXS+E/e9+ZFP5sZXQCeg/d84ghyvUDfFU3PpWw553E
83exwJA3Thef04nucZSgP5ov+HXyWhhL/Zg+Cvk7mP9qPE82X4sp5N9i+gVu
zN4HBf8s9rwonjf8hz1sPSULOvvbWI3nj+cDbKjjN1LDftiH9wP74A/0433p
yM/17wfzGf5ifoIutz9YrE/MT+wPlPdjED/wfPA8UE8gXmD+wn/QES9Ah//Y
v4OO+Q06xqNfhfFsfuWK8aBjPOiIf4hHmA94vpAPOuSDLo+fWiKfTyWKekor
xoOO54d+D56fjr+S/nwXdMgHHfJBh3zQIR/xVPZ++unPU0GHfNAhH3RZ/Omn
P59Fvwby55a9njWmQj7okA865IMO+aBDPvoxkF+z7IU8MBfyQYd80CEfdMgH
HfLRb4H8x7rtv6WQDzrkgw75oEM+6JCPfgrk6+JqO/15GOiQDzrkgw75oEM+
+iWQj/MFyAcd8kGHfNAhX3k+oci3kiLfCoz8BYz8j/yLeIf4gvgGjPiG/ID9
CsYjPoIf/gJj/wZ+eT4MFvUf6MgnoCM/yvmLRf5ldCOxn0B+AT/yqdI+xFvE
I8RL6Ee8xPtCvER+QbzE+0H+wftHfER+QXyEPNAhD3TIQ37C8wKGfMRPyFfG
T9AhH3TIv6R7ANni/hH4H+nG3xHxGPrBj/mK/Af5Sox4DPnKeA1+7C+UGOOh
T7c9nlcs5Csx4jfkgw55Sgx+zAcdPcdAkukrxTJ9/4cRz2X6Sukyff+HwY/5
hvyA+Qa6bH4q90OlWObv/2HEf1k+K6Xj+SNf4P2CX/Y8SvmBQYe9GC9bH6V0
2FsWjWym6vMJMOxTYuQT2KfMN+CHveCHfaADgw57IQ/2gg57dXHkmJmwFxj2
KTHyE+xV5i/wwx4lxnjYh/GwD3TYl1623L9aCPuAYY8SI7/BHtChX4nBD3uQ
L2EP6LBnb1l4rabPh8DQr8TIh7AHdOhXYvDDHuRX2AM67JHKwombPn8CQ78S
I3/CHtChX4nBD3uQj2EP6NjvIx+hPke+QT8A+UlebwSLfIN8JK8Pg0X/Gxj1
IPTBP+QfyEM/AfqQP8CvrH8Q30FXYvQLsB6V8R79WTw/YNDRPwUdGPYq4yv6
D+AHlj2v/4t/LO2pRLxQxgfQMV4Zj9A/xHjl+gUd45XxAf0/8AODX7le0a8D
PzD4lesJ/TXwA4NfOd/RD5Pn1wqCHxj9IswvnFcAo/5UnteBjv0IMNaLXF62
Yj6rRH8H+1HUr9iPKs8XgbH+Mb+xnoGxH4Q87P8wHv4Bwx/s7+T9EX2/AP02
rGfl+lLu/4Bl+/fS8dgPYzz2V+DH8wMGHeMhD+dHoAODrrwvj/0X+LF+gcGP
eIr1C3nK++xsv6xV7Kf1+ymsb8gDhjxg8GN9gx8Y/MDgx3oGPzD4gcGP9Qt+
YPADgx/rF/zA4AcGP9Yv+IHBDwx+rF/wA4MfGPxYr/L9dwVJvp+uIPrvjrye
AcZ6kJ9HhRD5ffUQ8f6RX5B/IA8Y8rB+sX6AlesRdGDQdep6m4r7VMCYzxxL
Cro4P0U/TH4/ylDIQz2Legb2g474JL9vlUmU/Fg/4Jffj8oU9Yr8+WtF/x5Y
1h8sXS/y56sV8oEhH/yQj/oB8uX3k4pFfYL+IPbDOL8Dxn4D+2PwY38KfmDw
Y78KfuwfwQ8MfuwnwY/9HfiBwY/9Hvix/wI/MPixH8N5D+YvMOb3DZ08k9/O
I8APLL9vaSL6J8iH4Jef54YQ+fcdIWI/pOynK/vtwMh/6D/I6sPS9Yf+BujI
91hfOuhoJvrXyE/KfgMw/FX2t7H/w3zD+kC+BEb/B/zy84RcoV/Zj1CuN4zH
+5bfhzQU6x/+gx9Yri9P9I9hr/x8K1P0K4CxfuXnj/nCPmCsL/QTIB/rFfJA
B8b6hTzQMZ8xHv0t0GXnI6XjZfpz9PtnrH/EE2DIl99vLBb7bWDEC8hDvY/4
iniBeAOM9YD9NDDiCZ6nsp5X1ufKeAR+6Ef8gX5g6MN+HBjxCfpBhz5lPAMd
+hC/oA8Y8rGfB0Z8g3xl/AM/5CPeQT4w5GH/D4x4CPnKeAl+yEd8hHxgyEO9
AIz4CfnK+Ap+eT4NE/kWGHTl/T/QsZ8GxvoBxv4D8VK+vqIV6ylK9KOB5f1D
/f0/yIc/qGeA5fG/UGB5fAkT8UhJl/fjjcV5P+Kd8n4e4rd8/UeL9Q46MMYj
PoKO+gYY8Rb1gqz/UYqx30e+wPMBlp//pgiM8fJ+RIqozxCf4b88HxiplfkB
+zfYCwx7gaEPGPYgXwEjn6G+A53nQ0l5nqv8Hhn5AfYg3svvq+SL/ofyfh3o
mA/y+3SZv92fQzyXnz9oFf2gEoGV99NAx/xQ9lPk98mKBcZ6Z3lI3y8Bxnhg
zDdg2fzsp8fIF5Cv7Kco+yfA4Ff2S4BBV/ZHgEFX9kOAQUd9xP7W7//Qj1De
L1FgwY/4Jr+PYKiWr7880T/AfML6wn4U8xHrR75fyxPzH/ESdMRDYNDl93u0
ivuAxeJ8APEYGHS8P9inPB+U/z6JStyvkdcr0Yp6JUrEJ+XvmYBfZl/p80N9
ivgtP9+JEvsz0OXn93p9yvoX8RPzAf0VxBfQkQ9ARzxBfIN8xDPMF8X3SuL3
IhB/0G/F+0F8wPkq4gfWG+jo98r3o/geS6u4760V/Ng/yutN/f0fZb8ZGOOB
MR/gL+ItMNY/9mtYL/J6xpSP1wis/J4Rzx/PC/MB+wE8P2Doz2LxRWDEG+zn
gRHfgbE/BMZ+EPYrvz9TvE+1/H3i+zut4r6fVrxfvA/EH6wf9vz0/VDkD/l9
MyOBsb/B/ET+Acb7VvZ7sP7k59fBivtl+vuK8B/xTrkeQMd6AJ35Zy7WC94n
3g/WG+Y35hPmN9Yr8iXWK54fxoOO8aBjPPKhbHyO/j63/D5xsdj/gy6/71ss
9u+gy+/jFov9N+jy+7LFYv+M+aSY7yJ/YL0B43nK8c27eP6Y/3j+eN/A2L9g
vmI88gXGg47xwBiP9wc6MOI/6kvEf3l9mSEw+JFvZPmihbF8f1OKwY/6EPyI
N+AHBj/WM/jxfsEPDH7Ua+DH+wY/MPhRf4Ef7x/8wOBHPQV+zAfwA2O/iPcN
jHyGfIx+B7DyPoi8H5ks9reI/3h/iBd4fny+ifjN9JqJ+A2s/B4Z6xHxS97/
0P62P8H+BvER9qA/B31YL/L8YSzsw/4JGPEV/PBX/j1QsdgfYf2BH+tN0U8T
8Q1YWY/J+2mFAiO/Yr+G5yX//tNQYNn94X44hzNWfF+nEvZCPtarLH+30N/X
RnzH+2N+RgiM5wd/5L+PVSzkw375esf36EaSLH+1wL0rU6EP9gBjP/us8+nZ
Tofvinps0fGDoZ23PSIXap+ru+J6lMhnqJeWcbrox/Px8+tbLGraWP97bmcP
1SAPNcVi/xfkuuS68fbff0/Nss6V6E/JH0X/tj3HjSubF5ztHSn2h5gfswsf
h9/rGiX2s2aVutiEdtKf/9mGJsWrSQIprjIm+Ih9+G/fv7XmdPG9IR/vY3+t
+4JK+t/v8uh+9lWc/++/z3X0y5npb2ank/yAFo4Op/S/v1XBt9nAr9szifJ+
f+PJ+w7ONcknrU76ffqy5ffvrZpxunnT8c+rmhiI9Xzqs2uRxc9ikU/rxE8P
7ja/SJzPPXrUwThnkP73eo4/nPls3bYCkV/XPL5bdXxmvsinnZx32w25rD8v
i7nb9qDv9HyRT193Wz2q5kT9+diGvwv3NC7IE/n0rysmZ5Id9Odhk+eMWjdt
T544/xqhnlH/XWw2HZlU0rn6lEjSfW317hNefaabCoe1bHYpgnjP7dR+9sxs
MqwBfe/2OZI0mjDgmeftFFpx4ansheHxJMtD8938QiQ5VH1mnWlv4si40VPe
PJhgICVkr+5QUjGOON+sUGG7XzipN/JEnSDDH0Sz499GHTyTyc0L8XesclPI
yFo3HRK+qdSv0urODy3MJIMsb2mHNsomR5JM2y1tlEXa3qo5M2WtSsq6cPTd
Os8sEr4/e0P8QAPJsL23aZ+uhaTW0l5DXh8pok/aRo+q+beRVGHbiDe7hxSS
TpvdqqWHqqRv3UdXzN9XQE5vnLKkjsZUMiTHH1wryCfnk9b6xUSaS4dCoqN+
BafSwxWvrXpXYimFHB7tVm9eKu0dVttrYU9rKTG+ksmulqnU7uHMfnU3lZcO
3/GeeuO0qXp4QceFG6++IBZfxnb/nmWi7v1h+Z0NjV+S2Z/70YFVzdSZb8/k
xWujyNiV4T5975qoDWvvbdGo1xdizvil7pz/CJMnDeHyop7HnAvYZiYFuhos
squnv4/6btPwwMMpz8noxpd/DcsxUjtL9TrO2vGa5M5q/fnhYyP1zveNpja9
9pqUrFB37e1ZQjf2ijy1+Nxbkr44OSRnSz61/HluzahxYeRw1tbjbgfjSN3Z
B3+ZOb4i0ZOd3c6fTyK1Wl3YnrDxCXm5oNeNtXW0pF1aG9Px7TQki8mXNnH5
I5l+qR3Xv+j4YvsZ6UbqQdZvOsY8iyaPW351Kf0fdLVn4IHDPb8Ck40cH35W
48XiICOpYMvKTPuCaOLOno9kzJ/PLPb8pHz+/OxD/CbNWWGqnjnGsarB0gzS
b/3Rizfsk2infwx7tBibTkK9rmXbrEyke42Ox+W/yyB3gs79Cuv4jmZRVcuq
XTJJf8ZPOnL+118HOSx8b6QODfnU1etYDgk0XufU800mbbVyyvLd93JJZHH2
SG/fBKrNvNrhsXsOqT7APGT/oAT685m9y+TEHDJ+WvVqK4PDqNsJwxrkXDYJ
Sovs/2xuGDUyrDLZdk8umcToZBCnhzN5pJjL4/qlcK5/w825z78FG0kRmdGa
1o9ziOU97baDdpnU+UOObZWF+eRV7vODptEZNGfLUOfqewrIidypfzxZGk8P
Rl8P+Nu2gDgsGbD+jn0YbajxfRPXqTRedfv7v88/Q+mcftebt84tIA0YndTj
9JNsPDnCxy/xt5jf3j+e/PG9846nDgXEmuknf3H9rrsOzI1/q6ULO1//4bNB
S5a+cPnatGkG/S9+b9TwTVpSFF5nxuXGGfS+zaNnXXdrSVeDkNBTGXHUum+J
RdWxWjLVzthDczGUXrFtVDDjUTFpcMHnbLmNodQzZV9zt9ElxIfRySVO78bG
k/J8fN74pA83kuLI/SMRY24+15I1TD/ZyfVz+8hibl/hzt6uvs9K9S6OXHbg
UGm9H/m166MJxXSYbb3wrRaGUsMmH/Y1OZNOk0fenxs92lCab7e7hs2aOPqx
51yfTiMMpTbj0v0txoRS5/G1els4GEqbMlIPWnUJpaHtzI80jjWUOjI66czp
fDz5xMdvXeQZPW5hHAkvauXheNlQasD0kW9c38lYJ7sb+9JJ8sINNs8vGUrc
PgL78qZUO+DZPZ0+vd/fN2CesdQsJc1raps42m63QZ9Bq4yl5zHfbn6qEUq3
mQZEPRpvLA2Lbm/Q3jyUVnGZPaTQViUFMzoBvREbT9rz8XUDZlj2bRBHQofs
Gdcw31gqZvrIC66v/KK3/SKbpRPz/vU/jbZRSUOsum89lpxGvTuUy3i9y0Sa
WWnCnKOZsdTqYEEfx2smUlLo1G2O3zQ0YL6ft/dRE6moh/+P0A8a2vNSd+vb
A0ylZEYnRzl9BhtPrPn4U353T5UkxJJD7y736uVsKg1n+sgkrq95/FnXlKul
eFb4+7wJppJZuSbvIiek0fc1atjfu20mrTOsm1fjXizd0mDnvJxEM8nf7Xte
RbWGPmrfZ6z01UxaGz7iuCZIQ2s1WtWmwWpzaQmjk4ecvomNJ1v5+PkOOdZD
LseSQesWtBz9r7lkw/SRj1zfmNPed3JbpBFVm5TZtlfNpSvrlj/pHZRPk/5w
jXGOtpD6VW1Grvnl02D3MbmOyZaSw7S7Ma45qTSl3PpPfeIspJf9Ns14vDWW
Hq9+aUm36pbSz/WWXg6HNHRiralvVtW0lEY2bLSj7k4NTdznF2F731JKY3Ti
xemv2Xhygo8Pn2z/Z+qqWBLkMsf6x0NLqQ7TR6DvArOPCPt8KlSr0Dqf3ltc
s+rDblaS17lv/8y0yad3gs9Prm1gLXVY08Vn/rRYqj3TqsfNAVaS7eWv7wP/
1dBNA7P+GjXSShq92MTdbYGGPpsalD4j10pqyOhkPafz8aSEj39hmTxui2cs
CYyfEzTC2FoaxPST21x//6iqNS8H59H8zjlt/QNsJJd5U1z2Xc6jPVT1POfX
LC/Ve3W44pm+sVRKb2NXcaWNtM4tp6rHFA29febguYhdNtLk0/VmuI/X0AH1
LNMqtygvLWR0cofT+Xjiwscn3pz3MqBLLDEq2vo6tkt5aQDTT35x/bW3v9hu
38JMvTTdpeLcxCixH3x68GxAzLg35OuFnk/zHv7+ex37CtZ/6uIVKvopw+aF
Dh5Ob5Ecll9pbkuWX0+z/Eub8fzry/bfYr+O+taiWsLNeg8+k5PHAh7FtMsT
52/o57hz+dgP7+L6sT+l3N5PzF5x3hbZ2njAuAEfFOdnhlK3wj9CC/vFktrv
rBb5P/n9/Iyalpi06B5P0qbvslpX+r48J5Zb57DkO2k39lMFs+dJ4rzMojq9
VWXgN3E+1vVIM/Mp/+YLXO1STbeL8b+fj20d3qxm4E38bpy5OoDv18c02TDv
ZLz+96zGsP29uO/UKO9Vi6LiBFGvtj1V5YdHcRhV/t6EZs+czYajMsm8qh8T
gjrk/Pb7VZNI9VVVjuQQd6ZP/L7Ejn2X7NOW6s+/ohZc8ZuVrP89iZPlNnTZ
0ztMYBNWD4jfu0X9bhdUfsPeeVpyuIf7OGm9/vcgduRP/R74OlTgDaHZhxJa
6H/vwfVbBa+Odw1++32H+lzeEf8d7RvNCRX1xtHltnlxV+LE+VZSfMuonTHp
Ak/95BFc/qv+/Ot+l1Yb+zYPFfXJnl6D6lx0ixPnX4WvHgSGTE0X2NPbubBp
nkb0A2yHDXzTsVycqGecAuc08rNJFxjzs/rxckO371RJoyLrdT4Rqv89BPvc
0403v9KI869dRnufTngbqz//SjT86LUuTeAV7rNsz57SiPOvlSkfanQ+Eivq
pbXaoKy4CmkCb1nj+J0O05+HHa5xzy1wvUbg5BO5WTX9YkU9NZQ8G2CZov89
gCpnPI7V+0cjsHvCjlnNh8WK+qqKkcVZx8367/drJ270dR6tEXjS9+qtaneM
FfXW2kfNXJvlqtTRVYtK6tb6Kvo1L96M9Ft777OINy58PWL+eHrUKdw8OB7r
V/S3XNj6+u179wN8PVmy9Sjo6B8UdfTosbB/JpnJ1oPoNw1m80183z6Gva/f
vmfPGlq1y2rvF8TPy91wzENT9V1p2PDlgS/IwG9P/zbdYaZuudOrdhvHF8Q4
f++2qqv036PbsfgqreTx9cJUT1X6DP335M+jzixdFP2eTG730ny3dwzpOWf6
jVMFJWRK0ZIG37fFkWo17m7yCEwmRsXja5/pl0JSWTwiE3k88nq571jEKANp
QrdpW5c7FIp4gvrpccsIg0PbzNRH+9rHpzqK+krtw/sTp5k94v70tGleS8e+
y6ahL9L++NLrLhmxY+O5tMJfNLndkuKoR7fIZFYfUzdeH09l/CSW8w9h/CSd
86eUrF9p0jeK5FJ1C/cX78lqNh+kr3w+xDQY6b5udQqx31Q5brZtAilIvtXt
yugionnsGn+pcyL557L1mX8r5ZIlTn6PPsWnkcf+h6fb3s0h9Q42HnTkn3Qy
6dbrfwrnGEozIzMqF/TOI5Na513x71JEjOxiJlVMNJJOnAx+/CKxkBwpTmoX
uttYSmb20B/cHk9Wv6tRvw9gz59O5M8/n9lDQ7g9UcxeWp3bm8n6AXQ/7wc8
Zu+TzuDvcxazn/py+28x+2lzbn8Y6w/Q67w/UJW9b2rO33cb1g9Qp/N+wEDW
L6AHeb9gMvNfPYP7H8n6BWoD3i+YyOaH2ovPD2/2fKghfz4n2fOheD4VWT+B
/sX7CW1NztVPyTdT/9lvy4rAH8/FeRzWL/qDSQdsz+4qnV8LKg9162+cR08W
nzTNuHNLrOcVFiOH3LHUiHgOnDml1YnMe2lifXs879xo/JefNPhCPdvBDWNJ
3aweSz3bRoh8Gmrk5FIpMJxET3tzxmlsCvH9WPWiz/l3Ir/dYvUwyeb18OGD
zdvvafuOJEp9HFd5ZJKHhd1K8qITBX8Yq6fJf7yezhmwo8G9ponk106pwaDk
TLLQLeSy/eMwcd/wNqt/iQmvf09oHJZtnBZGRltcnuiZk0vGVFq0sPv0BMFv
y+ppgnr6WdgXjzEp8WSFr7Hdy+BfJHSSv/uDpfrfZzzYJZDcbhQm8CJWr9Jq
vF79c/92n35O8dRrwaDNiR2KyGnGL84vw5g8gTuz+pjM5/Xx80/ZU6rEh5Lp
CeqO05cVkmevtKuyM+PE/cQ1ZwKeOt0NFfgXq0epmtej64aOPf7kZhx9u3mN
1rqrgbSV8Yv7Kc+ZPIEbsvqXTOD175oLddxyloeS9949Ew4aGUhe/s3eVT+d
Lu4n83qRol7s+DJmwbe56bRhu7OtwiYZSXVa1qnzeH2c4J/ZfXHcnqmhAvN6
lEbwerSfl+vcLqPjaMXJz8d6zDSS5jB+cR7F5Qm8jtW/JIzXv4vDVcFZHUPJ
sKdDq1ToaiQl938UJvVIF/nBitWP1ILXj5ffd7Gm1dOpV8XWFSxWqaTO2XEv
jv8VJ/iHl3tt+m+TUIEbsvqUoj5d8e7CGFoxjm7xffIj/YBKGsP4xf6hA5Mn
8ChWD5M/eD3cp1nimj8NQ8m8XWtGtl6ukga0fGu+IT1N3MdswupLOpnXl7vP
Gc2rHJhG/WzdXjw4aSqtC3iyuFlhrOB3Ct+5wDVfI/BZVr9S1K8Lqy3dtTki
lpoc8XGJeG0qtWX84jxuLZMncD6rlwnqZdtf6os7wzTk5s3aNyerTaU+n2+1
8J2dJu5vDmD1JzXj9efFJ4eu12ucRhs3nfb2UIi5FOHdwv3S01jBr/1eN2He
W43Ac1h9Swfz+pb4L22ecby0vpr0c+0cAwuphPGL88BIJk/gLayeJna8nm59
K7PF0AsaErLnTt2sYnNpwebmXkst08T9zwfk67i4J6m039brfQzzLaWtg11a
Vz8YK+j2pPbgHRc0AvN6ll7l9eyjHpPOD18SS/s+G0fGtikn1Wf84vxxE5Mn
8ChWP5MkXj+vnG7t3XeLhlxa5z6h6K9ykt/mQ2ZDg1LF/dGhI7cafvMrxTYu
FT7Ut5Y6/ddjxoAFsYK+q32NSNPtGoGfsXqWHuf17Gavr9qsUbG02Hj2gL5T
rKVTjF+cdzozeQK7s/qZPOf189r7XYMs5mnIosCU5gG+1lLxmN1Gf01JFfdP
jaLq+Vi0S6Vtu/V54T+svLRxXFfnkFJ9oJvGaWxPltbjwMmsvqXGvL61+jzw
vO/fsdQn5NAY1eHykjZWxy/OV9czeQJPYfU0Gcjr6Ql+9p7rx2rI+7smz/OD
9L+n8KHTuP9mn3xBfNn+T7rJ93/Ptp2bU7LdTFpa9+rthY7630+YftBnkjr4
NTkqnb7tO0alXrRtTHabf14Rv8qfR5uXN1RP8l2b8H3ZG3Hfr3jCRZfr79XE
7GrG4oqds+n5T4PfdKl+j5xpv8Ty5u0MenWlk0vdIEou+veaFrfmJ7U7ajLf
uttDsmxeh3Fr+qfT6kXaNSZNHoj7HqcXR8060eMl8UqnTTfZJpO4K/N72Wbr
f0/B2ovp4/JICy5vAZNHnLg8I2YPuSO3hzzh9tS+uLb457Qi8n3chCdTEzSi
vvTm/h9m/ksLuf9d2HkKKV7AzlOGsnxPHvJ833VJowYNTSP03yuw8xSK85Qo
lv9pDM//hg3r957yNYLEjG3yZczyRPK1m1tvp0kRxGHB/jcdPyaRbJbPaT7P
50fYfoAmYz9wr/Dp1RfvSGibOz2fWKWTRy+sJjx/9I6Uk2YdKKqVTsZ6V8nV
uCWRZSN+TD10N428ZPmbIn8fYvmfevD8f/uvuKpOr8PIplsPEjOmZpN9jjHH
A1L7OmerDzYqq5fHvqt0+eCnBOJqe7kufZ9FBje2S1zeJIy29JeKrpTu6x+x
/Ex9eH6+vDlL1bSknzPyuRvjJ605fxW2HyAT+X5gx307srhpPLV79a3HJ78i
sjd+wroht0Jp0z6WbZo2LCYrWP6lH3n+3cfopDmnb2XjSW0+fjXL9wT5PvTT
RItdUaXz7dn3pJdLDKSz/bc8sTwfR31je6Sd2GAgrf0jb3OgVyh1CgrqcvOp
geTH8icdzvPnFkYnbTj9JBtPML4Py9ekEs/X7Vn+J8j/C0w2GVQel05NmoQe
fhJtJH0buWJsiwFxdO36dsd3hhtJu3amfpnrEEqXRobZpRcZSS4sH1Jfng/3
MTpZxukTW+yMDBgz2HnhMvdrZfV7MpNH1nB5S1k+JsjHPL+TiTy/r7ZfffWE
YTrdsqphz4KOJtLsj+djX6niaPX6jWuY1DSRLqRtqP8mTUNHD++x0sXJRKrK
8h29xfPd+THDOnm+Guwsvndg/GQM52+/cd3YTwOGOGcMXele1g9wf1LXwvrh
YGenj/4by/h9mD5Sjeubz/IxQT7m+Z0s4Pnd3rFa46SZadT5/sGR/200kzxb
BtYZ8iKWtmo9ZKTFODMptJn11pRgDS3fMDrGfaqZ5MDyHX3L8104o5OKnO7F
xpOWfPzfLL8SF55f77F8TZrxfF07rJZ5xV+ptOuVxm32frSQ9s10uHZkfyy9
d9bEqX+AhVT7ysDPvQM1tGL0TqeKpXgxy2f0Cs9n9RmdVOJ0Pp7c5eMfs/xJ
+vH8eYCdd5JD/LzzPsvPBPm58NiNxSMPpdId4zddP1feSvo7w/xU2H+pdPqk
tj5pDlbS+Q9WUwtmx9KXH+f07BJXTrpbpUlKq9UamtZu3fX2H8tJa1g+o4t5
PnvF6CSD08+x8QTjt7D8SbQ8f84Z3j7+3Dr99xr8PJb04uexw1i+Jit4vn6g
qeLaeVgqvTbr5ww/ZxtpiUnBqhWDUukeR48Vq6faSEFbZjRcOiiWLviY8aid
g40U4fV287QZGlqt0Wnrm5VspHEsv9GPPL9FMjqpzulX2Xjix8dbsnxKkE93
H5s/u3dX/fcfP9h5ManFz4vNWP4m7Xj+fs3OV2kHfr5qz/IF/cnzBe6P3eb5
aiLLVzSC56v5rJ4k53k9WcTOewnOe31ZPpXceT4tbqDLBzSR54MvLB9QO54P
7rH7HaLf68HiO13M4/sTlg9oGM8Hz1g+oJbIByx+0wE8fl9n8Z6u5/G++rxF
PQs39XXWRts1L4v3Xi4T92ub9Hdev+i+pix+R7D4Sf7k8ZPHM6Li8cxzfOTZ
iO6DnR8sG36zLB5VvbV0gnPkYOeKr2atK1vvPN4QxJuj08Yttu00xPl8xvFx
ZfGhIVvfpDNf3zXZeiNd+HrTsvlOdvL5Tth8J9P4fH/E5he5zufXUja/yG4+
v/j9it9+H8Bym+bCyoGvxP1P4ADWzxf3S8NGekz2H6n/fYtohsX3jzfm/JEa
7qpS20SENev09qu4v+XdOighcfVXco3RJWtOh75JnD76QfcmYwf9on+fnPjv
SJufpCrrv4t+Pe57zSvva1N3ZBpxXL9w3oaH32j1mPaPLngnk0Vt/dOODPou
7kc6MDqpxen+jC7u0zZl5wFE+f3Ms9vj7cKb/SROrD8v7us0Zv17gU+zfrq4
jzPwdafEn1/iyVqfsO8nCn8R45rVTsyO1/8+8xbWLxf9802sny7653ZONqlN
EtNpJfuSO7UHG0hxrB8u+uXHWL9c4BOsny7647z/Lfrj/7H+uMDPWf9c9Mfb
sP636I9XY/1xgSey/rnoj59i/W3R/97L+t8CN2X9cdH/5v1t0f9ey/rfAm9j
/XHR/45j/W3R7z7O+t+i3z2G9bNFf9uR9btFf3sK618r+9u/fT//78TnVsPf
vSPV1i2rY3IyVnwfX3LpaPf/XKPpyfUh01Mvh4rzHn/Oj/qgnqvnS4cv+n8/
pRHH6I9fne19JPSq/t8XucHxsOePv/SP0P/7IkvZfQp1Er9PcWX1gWCHWkbq
csGfy41NySXLJs071cg5S/SjAtj9D9Ka3/8wonbdXV5kkv5VqpmfeJtL7rQZ
syraJFP0j16z+xjkF7+PkbRuV2iTfRnELWNS78JyRSSrotWnZSH6f+8jn91H
oDP4fYSS97GPZlbWUt8D4fe86xlI951y2l1rov/3O4widPcpyCN+n2JXhwqr
1tcv1n+vfsrtzwUviqhtrWvZBjmlcb7bRFXujwLRTzDLCTDrEVZAhhYaGMc0
NpUSojYd8HAuEPX7mkblc9XmBeTnzwzXdifNJady0oYz5/JF/dyXnV+TJ/z8
2uzPIacu+eSTSo87f/WrXE7a83B4Zr1W+SI/T2Tnx+QePz+u/ODfSQfz80rz
Uur4MXOtpY6qGfttnuaJ/NiNne+S3vx81ya75Rq6K49Uta2Q7fZG/z36wGdB
A7/eeElG5L0J+ouaqPd/9PFtOOil+P56AKcPZ3RpD6df874a9jQtnx73m1hj
caswYsnmo/i+3JPdbyNz+P22YjY/yXk+P4ew+3BkLL8P13RGJ1WNxFwyZHqn
oN3u4eROrRMTru1N++337y6cHHfNvW0MeTr8hvX9AEOpU3z59W4fY0jHwy65
sx4n6v+9nZmdfvZY8O6378v3/dPJySs0nXRl9+GkRH4fzqVrgKVmsYm0qcmi
irZemZi/4nvwqCDtjYyPWTQh0iA2Nj6LpMTOntzRJ4tW7FAQa5GSjflMB/D5
vNqtwVWr8Qli/IHxZ9Mm7w8T+AuTR2K5vG9MHoG8EWy9ie8VLrP1JVnx9XWb
rRfRrz024HFeuYGZ9HWTY77qY3kkhq0XOoqvl3ZrOsb8Wz9MfM9wgvGTt5z/
OlsfYj2N22q1YfTSDPrPr539n20vIhMZJvM45utPrCeDD7r1Rvz4enve867n
gI3FtM6trrtcwwykP+mAe50D0kW/cydbbwK/YvzEjvPz+4YkmN837M3WI8F6
rGIT5/StY7roR45l61P0Cz3nL/ll3K+Qdq/pMNczUSVd+p4QVDergI5X22nf
vzWRvrP7ivQUv6/I1zMdxtfz9f2/Mqb80Ij7+zm5CQYub9KIQj7pxuVfZPLJ
BC4/nsUD0Q88k9A90HVyAc25kPYiobR+effyTO64ngX0wBzrxevDzHBfkp7l
9yVXsfhB03j86LxxWmDGQ434PsB7dg1/5z5pIt5cYPJJFpcfweSTQ1w+jz+i
/3dw5cvFT4LyqZ3BgnVVv1gg/tDKPP4svzg/YEdU6m+/v/Zqx9JdE+ZaSvvY
eILxu1m8Ev07+qNf/k2XfHooeKvB2qxyUkUWr6iWx6tHjE6Ocnp7Fr9Ef23+
RbfwJV/yaEOjfwNfWttIpix+0T95/PJldNKY0//rEzYxso2hWu30s4Ndnzfi
+6AIyyutz3qHkJYsvlA3Hl9wPnu3WYu7HW5EkmfxgU+GdcukDqMG37lW/5Po
j0U3316x3bzPxD9tRNKHhfrvuSfZubVucCzqt++573N5qew+KKnA74NeYPGS
nOfxci+zV7rJ7cX9dNjr0u1ph+1/6b/Xxn179cl5N693jSaO7P63uC/uYJXa
YOFR/e97b5ryOaX8Ai2Zc3lYnVlr4sV9+d2tWx122pBAFrD7pJIbv0+K7zFe
8/1jIbsfLvav7mx/S7rz/S2+b1rF97PpFYZPNjDME99fp8xonk1PGqvt2mf9
cvPVf2+denrnpquHc4jq094I633677Gdr2p9OpXT//vTHs+8PQrMc0jyqln7
Ri7Tfz+9xH6Ep2p4FqnL7qtKPvy+6hC2f6Vr+P4V9Z3LgY8VpwXkE+O/V12b
dkH/vfRuh7Gz6t7t66z8XtqT85d01vGLeLlnYZfjHgH676fxvgotbnyqXPeX
mC+p3R61Okm1ZNqU1oUPVfrvqR3Y/phU5vtj9EMdujP+6YxffD8d1WBi1YRJ
RWK/+yXJe1krV/2/f1tp6MB+aa6DnYFnPm9q8/lxIbHr3jnI/6OxRF1b/9N+
RYHY31aZvnXD3W5DnMX9j0lODVp90H/fLL5XHke7GWssJBd2H17sX9+w++9i
v7r+Y8jRRWEqdaZhk7yogpdkUKduM13rm6hVVxynj7r9kqxldAn0gYwugY79
pVTuyKutmfrvmbtyHMjuL6uz+f1lnu/VbXm+5/NdfI9WyOaf+L6Z53P1Rp7P
Uc/58vkzms0vGsfn12THQKO7W/XfL/uw50lr8+eJ+2dD7ya2eF06D38UDQ7V
bNJ/r/yYxQ9Si8cPvv7oLL7+rvcf2Sdx+Qd6q/qxG+sTvpKrDBM1xz3Yehff
B+P7xWC+3jdOfd3u8JwCmjuqkkXH9slkE8OkiOPvbL1J9ny9TUrZ6WG130w6
8nLuxdMX0snShMtOnz4aqL13zpw2414+8WdYmsRxWOvPPxeVzrspg5eu/i+m
SHwPa221+6H72Rfkc4WsM9/C+zkfspgXUbbf8Gby1ZD/lo2nE/l457b3Rg38
O0l8r7d+Xbs/9pxNEN937anUq2W352ECz+6ecl+jThff43Wv2+D4wUHp4ns7
i9NaK8ucNJGPhww/c9RySprIh7XjT/asl6v/PUPEy/gF96e7Zr0i/wOA+VDC

   "], {{{}, 
     {RGBColor[
      0.32831851553371477`, 0.11809044856519872`, 0.5784717078449851], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVTtMU2EY/Ut7e69iIFFXQ3zr4CbGpboJIbK4GcrggwUqRpiARNyE4szD
RRMTioOvAVpNTMDYNqllkpqQKglKvMWBgcEYSYzn5DtNh+/+r+95vsc9evPu
tcEm51wGFAX9wudizLkv2C+C8qCPoCuec7d8545EnHuOcxV8C1jf49wB/jT2
m7grYM2CxnF3H9SLfQprC2gI70vOeKh3GrIZ3CXE/wB0LmK8lLmE+xBUkw/D
UbunnnWsnaAp3D8GreFuDuvBwLnDgb1R37h8IH8pZr62IZbWwPQfwno2bnp+
QMd3UA77ftAoaAQ0ABrTOZTva6CK9gXFTtmiM3meicMj2FoBbhs410CheBgD
4+xW7Iw7hX2P7NF+MxJzuckw/gkdNVBrzGyGwmRHe/pzGnGciZsMsaeeJP2L
mRxz1yXcqJOYVaKWz13Qb9BnZ7wF5SwBXftBz8D/CvZfgFajxv9XudmH97z0
l6P2zpz8A2/Wb+SH9cIcMdZFxbuE93e++dEHrO5h3x4xvOl/Srj365zzTYb8
jO2qMwyPIe4PnuWU8XcpxlXcXfcadZUX5nvQ8dK3vLMm6DdrOIJ6WMb9N5wP
QG7eN19nnfnPPmE9Ed+kVuYvJfx2lZMFxUxsZyQ3r3wQy17hxn235GrK5Y7O
oTDeVV6IXVnYLsO3E4H10ID8SKkeK6qHk8Ck7Jkt1l1FtVqv16J8SMgPYsMz
/Qkg1xZY7jvUO7SdUTx1PGblF/OxJt+eQvaTb7OEOH4VDnnNFM6A177VB/lZ
LyX1Mm3+8cxu6NvcYV3dwL4lsBnAfKZ8y2mnepq5blavjAlj6mDs7XrjfVr1
NCa/J3VXlZ854UMf2b+DvtUBa+CtT2AslgL2057NjCXlltiwdqY8i7uE/RPs
tzULMsKMdqrChP6vK4Y+8Mc9y8Go/JqUH1X5xhmzqT3n1p5qmLWw4lk9lKST
98QjrXhHpG9CvdSjemxVr7N38up9Yj4E3ceh86HmLrEnz4WYxVSUX1nFta0Z
x/sZyBUhvxW1Hk3KHv3fEs+8cGZN8D8wrH8BdbB2+A86HzOMc/J9RPnjv+i2
/keUG5JsQT3OeGiX991aeSYP6+tUvDHXkpohjJN1wnphjjZkl7V2R/VWn03s
Nf5DOHeICefiG81GxkeMivJ5Tn3CvPCdfTShu3ovTYiXNhlzTj1bEw6Lsk27
Rb0V1OuheMr6B6ZVa1nh+x8MVB+9
         "],
         VertexColors->None], 
        PolygonBox[{{1529, 2066, 1096, 1098}, {2068, 2067, 139, 1096}, {1985, 
         1509, 1076, 990}, {1978, 1977, 169, 981}, {1958, 1381, 309, 437}, {
         1439, 1993, 1000, 1001}, {1430, 1989, 994, 995}, {1474, 2022, 1039, 
         62}, {1966, 1967, 973, 139}, {1983, 1420, 990, 988}, {1989, 1431, 
         996, 994}, {1901, 1902, 437, 301}, {1473, 1345, 935, 406}, {2085, 
         1485, 301, 1152}, {1315, 1293, 523, 903}, {1572, 1288, 522, 573}, {
         1905, 1906, 903, 309}, {2048, 2049, 989, 169}, {1574, 1573, 93, 
         522}, {1345, 1889, 883, 935}, {1969, 1968, 154, 973}, {1576, 1529, 
         1098, 575}, {1892, 1893, 521, 285}, {1509, 1990, 995, 1076}, {2062, 
         1311, 62, 883}, {1286, 1572, 573, 521}, {1512, 1994, 1001, 1078}, {
         1995, 1515, 1080, 1002}, {1975, 1976, 981, 154}, {2024, 2023, 285, 
         1039}, {1991, 1512, 1078, 996}, {1993, 1440, 1002, 1000}, {1293, 
         1575, 575, 523}, {1484, 2085, 1152, 93}, {1419, 1983, 988, 989}},
         VertexColors->None]}]}, 
     {RGBColor[0.4155431680256406, 0.2697505629226986, 0.7010765087511159], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lmto1mUYxv/v+/4PozQ6SCFBc5ip0ElBK0RTcwuh5hTsQ+Vi4qwvzjTp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIl1EQxe/f7/WnrDQNso2ZlQo9KOiFKBlptEhSKCjT0LRapJYFPciw
FraooHeb3kEEZtbGVMg0KOkdBBkVtAiyRWRQmVFYv8O0ODDznZm53517ZjKq
6kvrEpxzZcAH6XHn4oFzxdhVfDgVOfcQPw27zXPuFn4rKIw59xw/B24CqMZu
olAq+eNBIvZyck7DPSD+PfHloCF0bjt4jV0MjsMtC6x2K7iKn4hfy/n38Yep
MYn4edSLgfXwo6ifx/d6+G/EdoGFcD4YC1dJTCq1C4i5hF0G30NsNxgD/x0/
SLCcJPwh/EJil6oB+J3k9BM7F386Zw/Dt1Avn/g4/jX8P4Rm42dhJ4MK4nfg
Z2I3kN+Mv5eY89jP+DaZWl18+0V+M6ig3mfip3JeD/wsYhuJ+UT8R3AGPgnf
xz5K/Eb8H8QPqfegHT8D/ix2SWC1O8AI/s3I3mY2/G/sHPIXk5uD34Mfi9vd
+qnxhNxpod3teszuNgN8cHbHduI7wCvqrYCfj70ALEqwHpaQWwq6xYFsclNA
JfF74O9hT4HPTbA7STtt6olnGnoHt5uYIuw+cALuZGRaKOD83sB6pN7oTdWL
Y6FpTT3RWV5kvdGZKwPriXrR6VmvD4b2L+r57ch6pN7oTjei/z3y7Z96sQ9T
Y1XMNNuntwhMuwPgDX4u/hVi/4IL2I8i42pALfYW0AS33zNtDIf21tKIZulc
ZP+mmXoJt5VveTHr4WO9dWC91BtLe5pJzaI0KC1dJv+uZ5oqwh+ITCst0hz5
jaFpcbXqwV0M7N8GQSibb7s8m/Fq7A1gp2ffRnPWV2LyfZuxAWodCGxWX4A1
2E8D08od4rPhs0LTumY+mfzM0N5OMzWT2C9gX8w0tQluc2i19ObSxjhylvim
Ednpgc2uvqXD/5Q+fNOctJwSt90iTU/ETwttN2Q42xUjvu0C7Yy1ge0Azb56
pruqZ+qV7twVmcalbc38NuyawHaPZlhvqTvrrnpT7ZIfkc2edsog5x0JrNfa
aXPg3kamDd1Zu6wuMi1opyXG7Z/1r+rxocBmUrMoza2DKw9tFqQJ3V07SrtJ
PZD2tAO1+6TBfzicshk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5027678205175664, 0.4214106772801983, 0.8236813096572466], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tsVUUUPfdx5lxBtAWN2CYaJBZFBGl5qDRgIASEQGkJAhYF+mFLFFrE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIllUUhvf3f//+vh8rnQmxcsA8oNlomnNQI1FQTE1xDqCmM1J64UyU
lgqJkZglCE4GloY3HgnxgIergunCCxE0dcTDhaN1MRWoF86MWKLmWM/b28XL
/6797r2+tddea/3Dln/UuKoQQngfFMGaLITVYCWLEkbHELZgr4efQ2+A14Mm
7GbwAfxDcDkJYRYYzP5HOKpNQ5iN/hp2D3iC9jAxHwtWJl7bwdmd4B68BTTL
N1jG2eWgBb4CtMBbwXd5CHM4fxB+km/UwMehz8T+CjxXCqGdtTZ8TSOOl9GG
gCpiL6EPgw8F1dgZ9gL4QnCK/ZMS3/0LzncWnIP78Ap8Li7a5w2+fxNU8+1M
d2J9EHojv8Px+Tbn54If0caDVzi/AXstvtrRl2Af4PwxtHHgDFpz9N7joAL7
H3xNw/9EzmzFbgN30N4Fr7J3O/ZGtOv4mw6fkfnsKPkklir29KH9gZ/P0TaB
LrRFie/exffzonPwBnxy7lzomyc4exn7L/hA9D7sx6A/elnBuXj6/12Vk0r8
PYnWRoHh6JXYv6GvRt+TOSbFsorv16Ptxv/38JFgAPwoa7187ynni9hp7lrT
HSN8f3RtKAdH4BdZu8v+HnAJ/kJ0rK2pfW1mbXdqnw90l9y5no99TfXNnqmJ
3/wx9q7o3CpHv2J/Gl3LZ8EF1V50behNp8O34e8QvkrgEfrDzG+rHqlG78gd
m97gKvyK8p04pz3w7txvVUFOniE3/UqupcD506o39H7sfR79HvZL+K9B26gc
oI3AnoJdrvxiN0TnUjX1E/zF3LHpjcvx/SC69nVmJ9os7CGJ3+AwfG/m3unm
zDfoO8Dx1Hsi54slv90u1p6F90bHqpi+zR2TYtGZMWibcu9VDfTi++vo2utU
fNg/YzcE9/Bt7C+x6xLPkNnRPa7eVg7UW8qB7q4em4BWBWpS92At/M/oXn8T
+xf8zWNtAbwD/7ew67DfSd3Tn2CvyxyLvqlY7uZ+C8WkWdI/dy1qpmjWrWBP
e8EzT7PpY+zTBc8ozab10d/SjHpPsytz7ajGNHsm4W9K6hn0d3SPqDfUU6pl
vYFyr5ousT8HZcEzsgfeyJ4mtN8L5mszz2atXYXPYa0xdUy6a2vmWak7n4e/
xVpd6jv8kLnGVFv7sGvhTbl7Rz2j2p4RranG//OdedbrG/I1M3cvyefE3G+g
3OuOyv3SzLNbb6D/As00zTL9J+jtuqP/C/SGr6NNyPxfoR75DL4t+q6amf8C
bFTJKg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5830630512181361, 0.5584822716207425, 0.9099374038446147], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm9ol1UUfve+v3vfmaFCTZ2uzDCsleuPBhkl6QTLNQg1K9osrSgz2prO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmuIl1UQxs++/33n1QwtzEvbVixY0rbaxYIMCXMFdSUQd9UkV8uK0iIt
L0FKaSmkwW50oVay2tXAwk262Yc1KLD6ULmaXcAuUpRkpJaZxmpuv4fn/TD8
5zkz57xz5sw8869buGTmA1lKaT1SjfyTp3RDkdJNlZQmsjASfILf/qqU7mPt
BWzTWdvGprfAw8DDkZfAl7F/4ICU6rEPAU9g3xxsT0VKq8EL8d+NrZa1QehD
sY9H7+d3VPI3j6N34t+G/xjwG/jv0RngJcTQjP4w9qXgedhrsF8DnpL5jEng
y4lhG+cMw/9C/GuQTuzXYZ+Bfj/+i8Fz2X8L+A7wXeDZ4MPsD9ZO6TzwLPS1
2FeCF4Cvx76OtaWc3c95c9Gfx/449ruxjwWPAU8GN4D3gkew5y/dDWkCz8Y+
H3szeCq20cS7nXgv5cwrc+dQuevAPkX5xv9W/GeAG8DV2Mdjrwe3gSezpwv7
6+BGcCP+LeDp4M3o12LfCN6gHKC/Es7lWeLvAj8LXpv5zjvRG3PnbhMyE/0o
Z9byvW7s72B/O5xLvfkE7F9iP8m3OsCt4GnY56C/h6wCLwYvQt+LPAReAL4T
/WNkD/q3rA1l/wfKCfrNrDWjv4k8qlpg7Rf0FUgPeFruXL2GLAI/Au7N/I1e
9E/C3x7MmQfRD7JWg76Ptc/QPwyffS5rP+ttwL+CL6nY9zD4u8x7DoB/DMc+
HLwdfA74CnA/sh/8BXgX+nkV3+Xr8N10py3of5O7sejtrDXl7iH1jnqgA7wB
n1XYjiLt4MfCd1VMXeivIqnKPbGfvfuQ5VXOuWp9JLityjWv3C5TDjLnWGdv
Ah/L/I3T6H3IBZl7VLWqO+kuqtlezrqtcG2rZhXL09gPlflfAV4P/l79qB7E
t7UwNywjhmPoRwq/jWpGb786d+71Pk+CXwQfKeO5Ct/zkbNVztG63N/Q2XqD
H8I9qt7UG7eolnLXSiuyHPwE+EAZT4HvH+op/P8FfxN+Q72dcvJbmAPU+9qj
3ruocK2rB5XrreG3Us4VW3fuuynGIeDBhXtHHDBLtRqORT09CX1iWb/qQdVy
C/t3ZF7bGM6B7i5OfA79mbL/xCF1YQ4W994IXhm+o+4mzrtd3FH2jzhrTbhH
9DbiqDXiq8LccUqcHe4R5V6c14Q+texPcUoD+hn1HHqjejLMIeKOd8GHsJ0O
12ZdxVyxJXduFXMP+k+FY1UNfhTuQfWe7qy7dYJPlv7ihvngnZljeD88EzQL
xGG7wj2q3tSM+TzMgeK+HvCf4Rkg7hcn5AN8Z91VnHgx9trwLKpgvzrMUeIm
zYiB4Rmj2aIeHhTmaHFzPbgvzPnietXouNwcKu7UDDoezolyoZ74Pcwh4g71
xJnwDNHsUM/lhWegZp9yoFnUXpirNZN25I5B31ZPj0Dvq3bs45B6cI6cSH4j
1do9uXOhmtNbzsv9VsqnauNB8O6y/18OzwzNCs2AT8OcJa7SG3wVnkmaRdrz
n+Yfa6Mzc4RqWTOgu6xf/RdQjIpN/wnkqxpS7WjPvbl7VLGJE/8H+RAL0g==

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6471933538768004, 0.6615218235467013, 0.9113993772212006], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVU9I1FEQfr/dfe+nHYQOaYWGVrSnyovkTQIPVpdoPXjIEk/qobCoS0GR
BXqoDTpEWVFZK2qLUYc8SFhEJVLBRn9YMGODIOlQa6cS6vv6JjrM/t6bN2/e
zDffzDZ0H9xzIOGcuwJJQrKxc2shldhsD85lvHPpyLn3WC9Dn4VNL84q8K2B
FHH+FmezsCnh+xs216DfgXUnzhqhPxXJdhOkHfoe6Juh2wAn3dDdTWg/BenH
/jXOnwXt57CexjqHdRukkJD/8ZRzY5Bq6Ooh49BnLLYM9VgfTUnP8z74OObl
Iwf9bUhVpPgmI8WxgPMF2BWwb4HMQE46xU+fzGEd8nscFHMH9HnopiH5lN77
+xZiGEoplifw+QD2w9B3RbKds9ioa8X6eULv8a0K6K9in8W+E2/tjeWP77db
XifgL+v1PvOjL/oZgv6S1zvv8H0ZlAOxor8m2HwJyrNgWBIP1pT1rjC7eeh3
R8L5FWwfBWG0H99DXrE+xPpbLMxzuBuSwrMHshgpR+6Jc5P5n7B6Ef+BSHxg
bBP2rsN3W0JnA8Yb2pB3Dca9D0GcI994b9x88h36pf2Y6fluHrYrcTdK6nzU
3u6xGIvEBDbLQXG/CcKOuLEheC8YrwZT4j3zrrPcV+DwDuz7Yf8Z3zL2JeMA
77BeS7g3EuTnAn5uer3PerKuzJM9Rk6Rh8S+YPgTV2cxE3dyhTjQnj3BGIgd
OUO8aT9q3H4R1Evso6/4xoi5bDwsGRdngnqMvkYNQ969CNudXnwmvmPGsaWk
cMGxexrEj0nLd8n0zCNtsREz9gL1xUi5sWfYQ+x/2rZ7zZq09Vyz9UIZ9yqh
x7E778X7DouTeRKTX0G4l4x3XVbXy179wP11Yg45i7e+sz5esZD7s8b/9Qjw
Y1BP1MbqW/bnLi8s6g17zkHak3vkNLGvge6H9SZzHbTeb8Xdc7HwO+41g9qs
tm1W331es/LfHErbLJqy2cR5eAY2R4KwO+zVhy0We4vFTw5uDuIhZwL7k/gT
I/YUOcbZvNHmczW+q2LhyPmRt3n0M6V8mEuv17xmPeh7Syz/zLHPas16FK2m
xHUx/K8z5wj196C7H8TRRsuPeTGn0162jGveZnuz5U0OENfVXvHcCOIE+VC2
Hmb/svYdxucRrx7jGf/H1th/2bDxmBzO2X8G8WHNP1ndQ6xZQB5xZmy1uZGx
etZYr1XZLL0VxC3yirnlbAbWQlcXhPsfJk/pIA==
         "],
         VertexColors->None], 
        PolygonBox[{{1750, 1395, 319, 457}, {1354, 2088, 1197, 288}, {1742, 
         1385, 312, 448}, {1808, 1453, 769, 768}, {1763, 1762, 158, 722}, {
         1759, 1404, 328, 466}, {1839, 1267, 6, 769}, {1545, 1546, 369, 5}, {
         1799, 1443, 360, 498}, {1770, 1413, 336, 474}, {1778, 1424, 344, 
         482}, {1454, 1808, 768, 1011}, {1363, 1728, 422, 295}, {2088, 1820, 
         411, 1197}, {1423, 1777, 474, 344}, {1729, 1364, 295, 431}, {1442, 
         1798, 490, 360}, {1821, 1822, 688, 83}, {1719, 1348, 278, 411}, {
         1825, 1826, 722, 143}, {2071, 1274, 22, 1108}, {1522, 2071, 1108, 
         386}, {1304, 1885, 874, 22}, {1788, 1434, 352, 490}, {1713, 1814, 
         774, 934}, {1433, 1787, 482, 352}, {1699, 1700, 653, 6}, {1724, 1355,
          288, 422}, {2018, 1714, 669, 1032}, {1412, 1769, 466, 336}, {1884, 
         1454, 1011, 874}, {1403, 1758, 457, 328}, {1813, 2012, 1024, 774}, {
         1934, 1935, 777, 278}, {1698, 1697, 5, 653}, {1817, 2018, 1032, 
         777}, {1373, 1734, 431, 304}, {2012, 1564, 567, 1024}, {1394, 1749, 
         448, 319}, {1565, 1522, 386, 567}, {1715, 1713, 934, 669}, {1384, 
         1741, 440, 312}, {1735, 1374, 304, 440}},
         VertexColors->None]}]}, 
     {RGBColor[0.7113236565354648, 0.7645613754726602, 0.9128613505977863], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1IlFEUfd/M972ZfixoYyAKUyHRyigNK2IWQ2WJYeTUuImkFgVlQZBN
BBGNbaJGF1Ekk2A1qQQWBQ39gLQxW6goJEmLcukyahNB53CuuLjc++57775z
z73vprq6j16IOef6IXFIb+Rcj3euPXCuIeHcM9h9OHAcOgdpDrQuQlbj/Ef4
RmCPQp7g7n2sz+JMF/RpSBr2EeiDiFWBfS5SLMbZy334y7DPwG6DPQm7E/Zh
2OOBzt3AO5cgB+DPwD8G3/ZAvi5IE/z74B+A73Kkt/nuc+jfoXBug/4cU/y3
8FcgQ1gfw71fsBfgz8L+B3sRdgH2bchjkLIbvj2QVKAcmu3tKuy9g2zF+mqo
GC/gzwWK8d4ph7Tl0BopFuPkQ935HlvJh7m8xv4bSAn+pUBcfoH/Je5uAJ48
1idht3rduQd9IqGzOXuTGErAVQ2dhMzQhrQEqs8DqxEx1MRV655Q+TCXtdj/
g/Ua3H0KvR6+Rthl+Ich/cB2B/ou5FSg2rMHmNch6DTiFGHXAVdtQnGJ/VUk
/OyvvPXYTehbXtjPQ3d74SSuecP2EL5O1gn2Rd6DPRuIgzbj4ZpXLVmDR5Hw
ERtrPhFTDQpeNWZtOnAm45XvDujaSNjp229+cjDixcMm3EslxGMSe/VO/A7j
TDXWGadabkkIO/Nnf3GvL1KezHHUi0dyyBp1hIrzk30HmbM7AxaT3NWG+iM8
yzsb4V9lNWZ9+W9+ePV2IVC9iI8Yqq12rDf5++bEV8V6mL2TtP6ZNL7IFblb
st4bjOsf8M1sKBzEQL6K9t6VUH3MHt4JLI1ebzOfGes9zoApr7cddA14qYtp
BnzyypGx2HPE3xDqPmtNDthnZeMmZfxwDg0aNs6GCS8cJcNMnMTLmpFn9mCV
Vx+yTnyD8VlXzghywNnz1evvMgfWmBwSK/lN2gwYt3/NGbkr0lxcB/uv8UMu
NifFDfHyjyz3Cf8+/+mscUR+FmyOtFsdOQOWueX/ZE/yTxA375Xt7zF2LzDP
JVbyzVrO9BET/U1xxWTsea9/wXpzhrHPyjar6GdenKkfvPjmn1vyejdp+Oqt
r9hT7BPiyocr+eUtl+uR/naL9RXPck6xPiWr3aLt0c+ci9a3nCVD1mdjxgV5
mLaZxnqxLsytYBzmbA5zf9p67z8LKMo6
         "],
         VertexColors->None], 
        PolygonBox[{{2047, 1762, 724, 1072}, {1586, 1587, 586, 271}, {1730, 
         1822, 781, 1144}, {1334, 1925, 927, 928}, {1760, 1826, 791, 977}, {
         1736, 1375, 305, 432}, {2044, 1752, 713, 1066}, {1951, 1365, 296, 
         955}, {2032, 1726, 683, 1053}, {1927, 1926, 24, 927}, {1280, 1720, 
         675, 832}, {1743, 1386, 313, 441}, {1625, 1626, 449, 313}, {1275, 
         2072, 1110, 24}, {1462, 1536, 542, 264}, {1606, 1607, 432, 296}, {
         1595, 1596, 423, 289}, {1763, 1760, 977, 724}, {1771, 1979, 984, 
         467}, {1678, 1679, 491, 353}, {1658, 1659, 475, 337}, {1761, 1970, 
         976, 458}, {1589, 1590, 412, 279}, {1668, 1669, 483, 345}, {2072, 
         1462, 264, 1110}, {1721, 1588, 279, 675}, {1636, 1637, 458, 320}, {
         1731, 1951, 955, 423}, {1647, 1648, 467, 329}, {1717, 1586, 271, 
         670}, {1725, 1356, 289, 412}, {2083, 1730, 1144, 1143}, {1688, 1689, 
         499, 361}, {1979, 1414, 337, 984}, {1821, 2032, 1053, 781}, {1751, 
         1396, 320, 449}, {1800, 1444, 361, 491}, {1779, 1425, 345, 475}, {
         1825, 2044, 1066, 791}, {1789, 1435, 353, 483}, {1970, 1405, 329, 
         976}, {1705, 1704, 10, 658}, {1706, 1707, 658, 11}, {1269, 1840, 657,
          10}, {1276, 1716, 670, 822}, {1828, 2047, 1072, 795}, {1335, 1701, 
         656, 657}, {1549, 1548, 11, 378}, {1614, 1615, 441, 305}, {1309, 
         1280, 832, 586}, {1307, 1276, 822, 542}, {1701, 1334, 928, 656}},
         VertexColors->None]}]}, 
     {RGBColor[0.7741468876642555, 0.8508382416843361, 0.9088718926461762], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Vn9ollUUfr/3/d77ztB0aaTUtARRWDTtx8ypicISaTYLbTgoV8v+yJEl
tc1MI90+raAfM8rmhigarsJq07TCJhRYM6gQNQvSoNAowVnDplk9j8/TH5d7
3vOec+5zz33OufeGh5bf+1gcRVGSw8A8BHMTxhjIO0IUTU2jKIfv1TA6h/EV
9OswD1reBqe/MJphU4m5CvpK6Dvh92+QzwcYc/FvIfTboS/K5D8BuguO8xb0
V0B/Ed9NGL9i7Id+I/QDQd8R5BKMcojj4dtvG655l9d9Ff//gP2pWDgZ7wfo
58B+SD6KRgDnOMinod8F/UjMV2GcgTwF+mLuDTYD+L6Uk35f0NpcdyFs6mDz
HOSuWHvmurNgMwf4d8JnBOQc7CdBPw3yLOg7oT8B+ycwtkDfh3mp4zxi+RXI
RzAvszwdeDuYI/jWYm6wLzETG/UrHJN74T6KvZdPMd8DnxWQ709kR5sy4Lkd
2PLw3Yz5Er7P4l8r1pqHeSLxwL7FeevBPBzf9ZHOrD7ReX2HPe2G/zOIMx6j
2vmfyvgYo3M68wWxzv0jYjMeng0xEc95rHt1URStzIlnjeYe4zEufXm2jMf4
tyD2zUFYH8T6fUGx38N8TaacR5A/xL8W+IxF/O5Y50Is1cZTijmfiPczYX9H
0HrF5gM5cPm/bVblJA+NhDVOhJN4N8I+zsmPZ3PB9XLW/NyJ2F1Bdg0+X54j
4w065iHuMdG5vwvbnlRrXjCPmfOjmK9L5Ms9LfJe7rNcb86ONAe4fl0iDAcg
j0rEt0Je9cBa4Dw7Ud5qEnGRGArI5XqMrdA9CSzHgOmgY/SZt9zHUe+F2I/Y
dzXsu+F7mLzCXO4e0oj5+6C9ku+HbM84hy2Tyz865qOw/zqIy0tizeQP88u6
4BndBJt1mb4Z86Cx8Xy2Y7Tj+1nY/BKEtQry/qDaLUD+JNN6zOsJr7sB+jOw
ORmrHzIG87ME+i+g34vv1zHewBgWqT72Of9jYTMTMa/H9wLkeZNtF8fiKfGz
Dnotk5fdPsdF7pWUaxDn86D6mwb5eKb12MMYm2dH+x6vy/h7LS+C/ZZMsdbC
vjQRDvboEnOVtcG9TXStdbl+X4Dfi5lyx5473vxpMQ/ZE2q9H+Jnjsa5lpnH
WvOTfWKNeVuViKPExn48KVEc3g0T3E94puRuf6R9VLnnECP5SZy7kY+/85Kb
Y90TxHbaMjGQRzWuo33GyTj0uzaVL/tirfH3mluUmacp5hXvQHKfvG2A37dB
NUTbA+bYUOiGBfUS5vNG84W9ij2L9wV7Eu8D8of5p23i/kFesYcQ+ynjr/Ma
jM/abfYe2ZeI7UrIr0Ge7DuXOV7tPPN/qW1YBwtd7/22YRxiPJ9of/PMo3LX
3UljaPMeqI+DOE3O8Ry4P+5lCPa1I1V/Ogr5gUz7Yrw2+5Jrl3tlTj2A7wnm
M0O/DxgVedUP7yL2wDfxf1MQ14izyRxlv+L9xPV/xv81qXpNK22DcjQFug7I
g4jzPLBsyPQ2+RO6tlQceRnyS0E5Y3/6KYgvqzA/HXRH/o55fapeQC7yHTAc
43HolwffwfD9LKi+Rma6U/PupQXjJI5++x7H/6dS9c3psK/IZPsl9HWpeHrJ
bw76VEN/dxBHm3wvkicVruVBn0+n78SlsH04qHfXYl4cxKNvMC9LxXH2ud+C
arQc821B76ZCrNrjujzjNp/hDPyfHnRndvqO51pzobszqJ7zvheH+u3BOMQ2
P9WdSh/eY8cy2bF/8b3AM38H/98O4vI/mDtS8XSbeU0uERvfQIy7CzYVqfpY
oznFnPCeH12k+puMdQZgX5ao77H/shbaXZdjXDvN9ud7bbbfbLyLV3ldYswb
J2tlq+uFPisdh2/eEsdiLZb+LwNPe1A+K1O9h3hWe1K9mRj7Vr5ZgnoEc7TT
7xzi3uj98U30fqr1+H7sDTqHc5D7M71rWBMFv2m517W+bzbDtixV/sjFVvfM
UueFOWHtt9qX+buYVw75phtlnDMwfxzECb659vjd9R8J1m2K
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIV1UUxs/s//+sM0YXtB4Ms4sQCVoKldmYdkGzcNQUG22gHDV9SNOS
Ms1UUBstL5GGmY0Pifey1JIyLAWFyh4y8pIJplSYldBYZpN0+X1952HB+u21
9j777L3Wt68bO2X45JRl2Rysit2WZ9n6yLJpNVlWg91YZNnb8EqSulUYI96H
sXvwu5J/EL8ZewM+j92HP5T8RvKHwZ3Iz+D5rHUD7ijiL8GziY8j3gi/pjg8
Ae4L34EtI/9axq7Avxyrws9hf7DJi8nvRqwn+V+z/lF4v3LhueQWtVlWR14b
+buIp/Ba7Rg7CB+Ad8Ptyb9L34MfgAfCQ+Dx8AR4JHyC/F/gb+Gr4EHEG+Em
eAQ8DH4CngQ3Vnx2PRnrUfEZHmP+94wdIt6Rsaj1meostcdW/AZythO/Gq4l
fhPcQrwP/AjxF7A1cIX1DhD7jPU+IP8yxo4QO1w4NhMbgT+T+FTiDxPvB/eC
6+EB8Hbmd1A+fhU7hH8lY52J/wn/hN+Osb/g6+He8FvhtXUHdxM7W3ivG+GF
hdfQXO3xFPn/kN/K/C7wd/Dv8I/wNfBRcnfkvstXGesPDyTegF9PvIXYEnhW
8hoNxJ+Hp+M3EV8gLlybqrlF+FuJryK+VmeGX4cNTb7TS8M1qtrsnrz2ar5x
NvkbM+CF8An8J7F58HL4NP4z2KPwWGx8ck3If4r4J8ljU+DHsYnJNXAvfn/s
weR/WoG/lvw2rY1Nh5vh4+X3NHcW/FXyGg/BI7HRyTU2H39ueC86g3rFyH9f
ucm5j8EfJ8/pkbuGVDvN8K3Eb8EGpbIGtD4576Zyj7nH5KsGd6q2sF6Z5zxN
fFz5/+qx2fDk8n9V0wtyn6H+RT3SBA8O7001uht/MGNduK/V2IfwALhjjXt8
Mfw6/Gt5HxPxR5X/rx59NnxmWl81vTJ8pjpLaYa+NYY5O8vz0F6nwZ+X96O1
JsF7yvP5/27gbeX/Lw3vQd+WJvXDvzNc29pzXWENkXZI84aE70Dfksbpbl4m
fqqsF9VePbwpuQY3wRuwxFrL4UvCPajek4bVFtZEaaFqZCuxvtIseAZzzoV7
Sr2kmtwC3567d1Zgf4d7RL2hM+ytePisdcbq7fNVr6Uev4jcM4x1Jf8CvCx3
zWvv6tF1Wrs8X2nAN2ENk3bpTH8Ia6K08DD8c1gDpX2q6d/CGiTt0ZnMK6zJ
0mJp2pmwJkgL1HMnw5orrVUPnJOuhM9KGvplWOOl7brDvWHNllbrDrXX9bn/
RXveHH4j9Da8kqwN74TfKmlEXe4z1NnpTduB/174bbo/+exfLKwluoN/w5oo
LZRmtEjf4Vby2zJr6Tb1d8WaeiT8RuhtkEZ8EX4T9RaqRzuTe3P4W+qxfWFN
l5arJz8Na6K0UD2u2nkz/C+qoQtVa5q0TG/qKvVPuNe1p/3hN05vm3rio/Ab
IO1XTap35+S+O/Xwfw99/fs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8317402520438303, 0.8700440940753852, 0.8830701170154197], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2tolmUYfr/3+57n/dyUcDZxbktTyzbTyv3YXKVpOXKwRYNKFoRZdNg8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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllFuIl1UUxc//+885R20kr4hD6pimOaJmBo7jZbxDgkbzkhhIzoN37cns
pRsRM2YveYFyvIE3BCkviSalYCWYCClZjk5JOvogJljqlGn6W6yHxbfXWfvb
55x99t4DG99sWFmEEJaACrA5hTA6htDMYhO4DW+Hj0G8Cr8Ofw8+qxTCz+BQ
DuED+EW08+UQpsLr8WmAz4Lvg7+NfhZ+Bv4YbQu8kX9vgYvoh+H/oz0EXeGV
oI2zPOSfqk4h9AWV+Nai90H7khgtaBm+A96o86EfBN/BO9Bvol9B/xO7Gb0B
rQ2swm5l7ST2FPA7/kdZq+B+ZbAM+yf0Y2h1oDd7d7BexXle4bsCfQ//nCJ2
DzAJ34ng1cJ3noT+CXpTyWdehL0Y7MUeBJZiL8s+aw1oxb8a3ptYQ4k/nFj1
rI0g1lRwCHsfaxux/8PnAnxA9t6D8X8EHrNWhd6fM36OtjB7r4P4nEC7Bn8K
v65gPvYv4AHairLPPlt7FL7D19E5US4ieIb7f8taD+K9Dh+L/wz4TnxnF87F
SvjJwjn5KvpN9ZaPwCj8e8Ij9kx82tAHwfvChxPvG+yPo2urlbU3sE/zzwH2
e1Fvnryn9poD7uD/F3gZ32Hoo/BvQf9Itcn9/0H7V/evcE10wd6Nz1Lsu6CU
fEfdbQD//IH9HD79iDe6wrU+BF5dds2rlu6D48E1VUTnRLmoYe0I/LfsWHrz
7/F9LfpsusNQtOfB34VjJP7NoIX476D/iP+C6Luq5urxHZd815n4dEuuedX6
SNbW4Xs3uZbngSto3ZPPohpuV23Aa+GV8MnRNaVaUo18iD4yOlc6w/vRPaze
1ZsU2CVwNvjMG/S22b2knOyP7gn1Qhf236ze1Ywouac3Yb8QPTv0Jmv1vtm+
6tlh2DXZva09duHbOXsW6I2q4WWwDftZfN7FbifmmZJnzkR8+7M2ln+nc57V
0TNGs0U91Kr86X1Lnik/RMdUrK2sXU6uQdWeZlKv7JpVrapGbyTXhGpBM60M
v57dO+qBX7N7Ur2oHjqf3MPqXfVAHfp4MA3tU/zPoS+PniWaOffg66PfTjl7
Cd8x2bNtHGjGXpPdm5o5l/B/K3pWKQd12F8k147u2AS/lTyLNeOmZM9gzV71
yDG0Cdm5Us8qd0Xy2ZRDzYbj0bWiGfF08pl0Fs2gjuyZo1mjnjqRXKOqTc2M
7dhzo2eZZlxtdM+r1zWzVIs9k3OvmixF17RqWTnSW3+WPav05muiZ4JmgXry
Cb6ryog=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.889333616423405, 0.8892499464664344, 0.8572683413846631], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tsVUUUPafnzD1EbVQoGAUjiK1iMZooIVrjg36ggcRECJBAwNBajTxV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllF9Mz2EUxt/v7/d7f28kMZOxRklRMTYzFwxz44KxYbTpoiX/KeZfRJgu
1NiYbLgwRkNubCpMZRSyxSbTBQsX6kJbN1q48Ofz7Fw823Pec97ve77nPOdk
l1asLY8554pBAuzxzuWnOHcfY1HkXCZ2X3Auwi7Efxi7AP8D7OX4b+Er46wz
7txzcBV7DXYLvAnsxa4Ap+E1IB8e5/5C7udhF2KPAX9IIh97JjyGfwH+HOw8
vjUOfOatc9jf8b/EzsA/EdTD5xDfCt9ETE/SuXJvuXeAXHg66IXXcX86PBU0
Yc/gzZPwQu63cH8lZ9v4/lZwlNgqcAV+GaxwdhYlrSaqxRnih7DrsNfB+0Al
sUfAALwYVMGPgSF4GbgHbwQ13O/iexXcvROMvwY74TvAcXg1GI0/i/zKyK+I
O6u91Vi1bQbpvL+UszS+Xat/go8Fb/Xv/N9mbz1SbzpANnYC3MCfgz/O/Tbs
i9jZ2OeJHQSTeK+R+E/4K731uhssgZfg34evIW5ayApWa2niL/5/IJNv1XHW
ju8gWA//SHwp/EKwb2dG1ssJvDEvZj2N4XOgH/8wZwH/9mC92ICrFns2bz5O
WM0ncjcDvImspsrtK0gmLMeHxJ8Nlqs0fBM+irMtxD7j7Av2I2+9nMt771Sf
pGmjkLOf+H+DXO4+wd4PPxBMS6siq5VqqlqqZjH4+KR9SzVNxV8QTOuDoBt+
m5jdkWmix1uP1Btp8hv+duz6yGrShX3Nm3akqQ71MpjWB/G/8DYTmgVp9JU3
jUgb6vEUajU/mDY2EtMJv+RNm5opD59KTAm+xdwfIPdT3mbhA0gL9g/KXTPa
501j0pZqrl7NCjar6pl6fSjYrKrnzcFqplq9j9tsjyQtd824tK2aq9bSuGa1
LZhWNLPLvGlKWpLGNet5wWZNMy8t5AbLVZqQ9puCvaUZ0C6bFqx32mnV8BNg
JLIe9BJ/N9js5SVMG7uCzZ40ol0VBdOidtb1YJqUFlvjtttKvWlJO067JCfY
rGinqLZd3rSuGg/j+xFslrUjn+LrDzZ76vmvYDtTu1Ka0y4o8vaWdkJDsJyV
q3autD45xXorzf8HpcWyrw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVTtMVFEQveu7j0c0URuNlYpBYwEmGkpKKkk0scNoAyLSQCEuGI1WfIwG
1mUh4U9ciIqVLHb4AUkkxvAr7BQWEgkqbKGJBY3nOIdgMXlz7507d+bMmXkF
lfWX6vY4595CAsizyLn60LnSmHND3rlhyDz2H+NwAPoU9FRgZwvQuwKz4d4j
yEPIS+y3y/6ds/1eb2eUPm82OcgvyAYkif1Bb++0y2bcmY9B+cnJdsmZP/p9
An2UcUC6ISOMT+v7yOUepFux0C/j7/fmn+sVZ3ksQg4i71OhxXYT915BHgQW
05Bw6Ajs/k6M/cqlS3GMyGZFOKziPOstphbFSNvX8H0gtPh7vOVDvQi4z0Gv
gX4LPhog54XTd+Vf7c3mhvD/GVhsxPBbYFh1wfdMZHFchN4LvTBmd5ogjc5y
axOGKcWehmzCdzO+cUgisHzo84q3eCqgP4XPT5G9TV+tyi8TsxwY/zXYjMCm
BOvr3uKOKwfmQuz5fkrvNkSGO+Oadlb/jLhEnbUjf9I6e6/zCeHzB5Ilhnhn
TZivSi+LGUdZ62XIDNbr2o8L00Zxa1q+d+KOy/5jYH3BerUpjnlvNsz331d6
nbc4aDchbEcVb1rrc2i809580555d2J/W/lk5X9O2C0Kg2mdbwtH5riumrWq
tk2qY6PqQn1LNreBcVNktc1qnzbkB2vM+o7h/EVkOZPjHeLzXezdgXQGdm9T
dx9jrzIyztLHVW+8bdTbcfGtTpgQG+qdmi1T6kP2xEn1RZz+ot350aMZktWb
Oz3foryJwapq2qA4GEOf7o2rvhvq90G8MxtZz6ypXrzLeTakmUYuj8UMk1nY
H81HbFh76AWh+V/E93i+cb8Q+pfQ8iJXJsWvz9gbjWxN3HKqxQT29su+Rlwi
7+j7R2T+z4Inx7zFccTb++XkAM5/R3ZG3HnG/QTrpV5lHYgDa1vrLI/LkOeR
xTSpPiAHGU8x9DPCgTPjQmh3We+k5gznKefOV/VFqe6Sc5wvfIecLdK8qYKP
pdDyIt/JKd5jXmOaF8Q1DC03xlQi3FaFVVb/gaRmEWtVrDiJX6EwZEys27Jy
KRLHqjUvyUfWam9o9drhImfFPuydCK1/ObeqFDPxYK/yrbR6mFzyeVZ7+hnR
HMpoDsyrZ4lTSljNab9Gc4x8TmsG9mj+L2guLounK+JqQjUu15xj/+dUT9aZ
NR3We6xRRvgS28OI81Ce5bCmHmG+OenN0rf++1fxy/7q0P+YmPP9hHhFIcf4
Lr8JcY9vsLZlqmuFOEEuJ8RncuqDeMX+fqMeH9L/nxiQF4W6z7oP6KxUvGDM
Sf2b5zUTl9zujFwUlhnN8mlhVat4xrVH27+1IE2y
         "],
         VertexColors->None], 
        PolygonBox[{{2081, 1291, 103, 1127}, {1300, 1916, 915, 207}, {1490, 
         2081, 1127, 308}, {1317, 1908, 905, 162}, {1973, 1972, 147, 905}, {
         1290, 1556, 561, 435}, {1957, 1380, 308, 444}, {1982, 1981, 162, 
         908}, {1302, 1919, 918, 222}, {1988, 1296, 177, 992}, {2077, 1284, 
         74, 1117}, {2042, 1962, 970, 1064}, {1947, 1359, 292, 426}, {1918, 
         1917, 917, 918}, {2028, 1480, 418, 1048}, {1314, 1540, 435, 103}, {
         1556, 2035, 1055, 561}, {1992, 1298, 192, 998}, {1936, 1937, 885, 
         74}, {1557, 2042, 1064, 562}, {1915, 1914, 914, 915}, {1912, 1911, 
         911, 912}, {1890, 2028, 1048, 885}, {1318, 1910, 908, 177}, {2045, 
         1502, 1070, 1069}, {1963, 1960, 316, 970}, {1391, 1961, 444, 316}, {
         1914, 1438, 998, 914}, {2036, 1947, 426, 1055}, {1479, 2077, 1117, 
         292}, {1501, 2045, 1069, 147}, {1996, 1300, 207, 1004}, {1502, 1558, 
         562, 1070}, {1917, 1447, 1004, 917}, {1298, 1913, 912, 192}, {1911, 
         1429, 992, 911}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1285, 2078, 1480, 2028, 1890, 1937, 1936, 2027, 1313, 1284, 
         2077, 1479, 1358, 1946, 1359, 1947, 2036, 2035, 1556, 1290, 2080, 
         1489, 1540, 1314, 1291, 2081, 1490, 1379, 1956, 1380, 1957, 1494, 
         1961, 1391, 1960, 1963, 1962, 2042, 1557, 1558, 1502, 2045, 1501, 
         1316, 1294, 1972, 1973, 1907, 1908, 1317, 1295, 1981, 1982, 1909, 
         1910, 1318, 1296, 1988, 1429, 1911, 1912, 1913, 1298, 1992, 1438, 
         1914, 1915, 1916, 1300, 1996, 1447, 1917, 1918, 1919, 1302}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1277, 1535, 1534, 1344, 1579, 1343, 1551, 1844, 1843, 2074, 
         2073, 2016, 1888, 1342, 1932, 1463, 2013, 1308, 1537, 1465, 2014, 
         1464, 2015, 1553, 1282, 2076, 1469, 1539, 2021, 1471, 2019, 1470, 
         2020, 1554, 1555, 1478, 2026, 1477, 1312, 1283, 1944, 1945, 1894, 
         1895, 1896, 1287, 1952, 1368, 1897, 1898, 1899, 1289, 1955, 1378, 
         1903, 1904, 2040, 2041, 2039, 1493, 1823, 2089, 1389, 1959, 1390, 
         1746, 1497, 1824, 2090, 1399, 1964, 1400, 1755, 1500, 1827, 2091, 
         1408, 1971, 1409, 1766, 1505, 1829, 2092, 1417, 1980, 1418, 1774, 
         1508, 1830, 2093, 1428, 1986, 1987, 1783, 1782, 2050, 1831, 1832, 
         1792, 1794, 1793, 2051, 1833, 1834, 1803, 1805, 1804, 1835}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1329, 1692, 1328, 1690, 1691, 1327, 2056, 1326, 1923, 1922, 
         2055, 2054, 1837, 1710, 1338, 1709, 1337, 2009, 1461, 2008, 1460, 
         1812, 1811, 1583, 1336, 1708, 1459, 2007, 2006, 1886, 1929, 1928, 
         2005, 1305, 1271, 2069, 1456, 1341, 1930, 1931, 1712, 1711, 1815, 
         1552, 1281, 1851, 1850, 1468, 1538, 1310, 1853, 1852, 1722, 1349, 
         1591, 1592, 1593, 1855, 1727, 1357, 1597, 1598, 1599, 1858, 1857, 
         2034, 2033, 1366, 1605, 1367, 1732, 1488, 1737, 1376, 1613, 1377, 
         1738, 1492, 1744, 1387, 1624, 1388, 1745, 1496, 1753, 1397, 1635, 
         1398, 1754, 1499, 1764, 1406, 1646, 1407, 1765, 1504, 1772, 1415, 
         1657, 1416, 1773, 1507, 1780, 1426, 1667, 1427, 1781, 1511, 1790, 
         1436, 1677, 1437, 1791, 1514, 1801, 1445, 1687, 1446, 1802, 1517}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1457, 1810, 1458, 1549, 1548, 1270, 1706, 1707, 1703, 1705, 
         1704, 1269, 1840, 1702, 1335, 1701, 1334, 1925, 1927, 1926, 2004, 
         1550, 1275, 2072, 1462, 1536, 1307, 1276, 1716, 1717, 1586, 1587, 
         1309, 1280, 1720, 1721, 1588, 1589, 1590, 1854, 1725, 1356, 1594, 
         1595, 1596, 1856, 1731, 1951, 1365, 1604, 1606, 1607, 1860, 1736, 
         1375, 1612, 1614, 1615, 1864, 1743, 1386, 1623, 1625, 1626, 1867, 
         1751, 1396, 1634, 1636, 1637, 1870, 1761, 1970, 1405, 1645, 1647, 
         1648, 1873, 1771, 1979, 1414, 1656, 1658, 1659, 1876, 1779, 1425, 
         1666, 1668, 1669, 1878, 1789, 1435, 1676, 1678, 1679, 1880, 1800, 
         1444, 1686, 1688, 1689, 1882}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8, 23, 38, 1189, 53, 1193, 68, 682, 1726, 2032, 1821, 1822, 
         1730, 2083, 98, 113, 128, 712, 1752, 2044, 1825, 1826, 1760, 1763, 
         1762, 2047, 1828, 733, 173, 188, 203, 218}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1516, 1799, 1443, 1683, 1442, 1798, 1513, 1788, 1434, 1673, 
         1433, 1787, 1510, 1778, 1424, 1663, 1423, 1777, 1506, 1770, 1413, 
         1653, 1412, 1769, 1503, 1759, 1404, 1642, 1403, 1758, 1498, 1750, 
         1395, 1631, 1394, 1749, 1495, 1742, 1385, 1620, 1384, 1741, 1491, 
         1735, 1374, 1609, 1373, 1734, 1487, 1729, 1364, 1601, 1363, 1728, 
         1483, 1724, 1355, 1943, 1354, 2088, 1820, 1476, 1719, 1348, 1934, 
         1935, 1818, 1817, 2018, 1714, 1715, 1713, 1814, 1813, 2012, 1564, 
         1565, 1522, 2071, 1274, 1559, 1268, 1304, 1885, 1884, 1454, 1808, 
         1453, 1809, 1839, 1267, 1699, 1700, 1696, 1698, 1697, 1266, 1545, 
         1546, 1452, 1581, 1838}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1541, 1578, 1532, 1580, 1542, 1533, 1530, 1531, 2082, 1322, 
         2057, 1323, 1921, 1920, 2053, 2052, 1836, 1694, 2094, 1330, 1693, 
         1331, 1998, 1450, 1997, 1449, 1695, 1332, 1582, 1806, 1807, 1451, 
         1924, 1333, 1883, 1999, 1303, 2000, 1547, 1455, 2001, 2003, 2002, 
         1340, 1584, 1585, 1306, 1273, 1563, 1279, 1849, 1848, 1525, 1569, 
         1568, 2017, 1467, 1816, 2086, 1346, 1933, 1347, 1718, 1475, 1819, 
         2087, 1352, 1942, 1353, 1723, 1482, 2029, 2031, 2030, 1362, 1600, 
         1602, 1603, 1859, 1733, 1372, 1608, 1610, 1611, 1863, 1740, 1383, 
         1619, 1621, 1622, 1866, 1748, 1393, 1630, 1632, 1633, 1869, 1757, 
         1402, 1641, 1643, 1644, 1872, 1768, 1411, 1652, 1654, 1655, 1875, 
         1776, 1422, 1662, 1664, 1665, 1877, 1786, 1432, 1672, 1674, 1675, 
         1879, 1797, 1441, 1682, 1684, 1685, 1881}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1301, 1321, 1681, 1680, 1796, 1795, 1299, 1320, 1671, 1670, 
         1785, 1784, 1297, 1319, 1661, 1660, 1421, 1775, 1874, 1651, 1650, 
         1649, 1410, 1767, 1871, 1640, 1639, 1638, 1401, 1756, 1868, 1629, 
         1628, 1627, 1392, 1747, 1865, 1618, 1617, 1616, 1382, 1739, 1862, 
         1861, 2038, 2037, 1371, 1953, 1370, 1954, 1486, 1950, 1361, 1948, 
         1360, 1949, 1481, 1941, 1351, 1938, 1940, 1939, 2025, 1571, 2065, 
         1526, 2064, 1527, 1567, 1566, 1847, 1846, 1845, 1524, 2061, 1466, 
         1523, 2075, 1278, 1562, 1272, 2070, 1521, 1561, 1560, 2060, 1520, 
         2059, 2058, 1887, 1339, 2010, 2011, 1841, 1842, 1518, 1325, 1519, 
         1324, 1448, 1544, 1543}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1472, 2084, 1473, 1345, 1889, 2062, 1311, 2063, 1570, 1474, 
         2022, 2024, 2023, 1350, 1891, 1892, 1893, 1286, 1572, 1288, 2079, 
         1528, 1574, 1573, 1484, 2085, 1485, 1369, 1900, 1901, 1902, 1292, 
         1958, 1381, 1905, 1906, 1315, 1293, 1575, 1576, 1529, 2066, 2068, 
         2067, 1577, 2043, 1966, 1967, 1965, 1969, 1968, 2046, 1975, 1976, 
         1974, 1978, 1977, 2048, 2049, 1984, 1419, 1983, 1420, 1985, 1509, 
         1990, 1430, 1989, 1431, 1991, 1512, 1994, 1439, 1993, 1440, 1995, 
         1515}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->NCache[{{-3, 3}, {
      Rational[1, 10], 4}}, {{-3, 3}, {0.1, 4}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149769564]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30451],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellID->9228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Nu]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24435],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15419820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28660],

Cell[TextData[{
 "A Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " degrees of freedom has finite moments only when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "<", "k", "<", "\[Nu]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->24000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "k"}], ",", 
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "k", "<", "\[Nu]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1030],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "k"]}], ")"}], " ", 
   SuperscriptBox["\[Nu]", 
    RowBox[{"k", "/", "2"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox[
     RowBox[{"1", "+", "k"}], "2"], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "k"}], "+", "\[Nu]"}], ")"}]}], "]"}]}], 
  RowBox[{"2", " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["\[Nu]", "2"], "]"}]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->True,
 ImageSize->{289, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379039326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4807],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"], "[", "1", "]"}]], 
  "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CauchyDistribution",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/CauchyDistribution"], "[", 
   RowBox[{"0", ",", "1"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "1", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299324638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9142],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57965266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14582],

Cell[TextData[{
 "The Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution converges to the standard normal distribution as ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " tends to infinity",
 ":"
}], "ExampleText",
 CellID->107351460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"\[Nu]", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23225],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334311367]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32689],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266091385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75622466],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 " with noncentrality 0:"
}], "ExampleText",
 CellID->286945964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61776903],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Nu]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ")"}], 
   FractionBox[
    RowBox[{"1", "+", "\[Nu]"}], "2"]], 
  RowBox[{
   SqrtBox["\[Nu]"], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["\[Nu]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}]}]]], "Output",
 ImageSize->{109, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281213500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "0"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333922946],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Nu]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ")"}], 
   FractionBox[
    RowBox[{"1", "+", "\[Nu]"}], "2"]], 
  RowBox[{
   SqrtBox["\[Nu]"], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["\[Nu]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}]}]]], "Output",
 ImageSize->{109, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184604040]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " is a not a positive real number:"
}], "ExampleText",
 CellID->20041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"StudentTDistribution", "[", 
   RowBox[{"3", "+", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15879],

Cell[BoxData[
 RowBox[{
  RowBox[{"StudentTDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
positive.\"\>"}]], "Message", "MSG",
 CellID->539648224],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"StudentTDistribution", "[", 
   RowBox[{"3", "+", "\[ImaginaryI]"}], "]"}], "]"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267158556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22623],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", 
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Nu]", "->", 
    RowBox[{"2", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25472],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(2\\\\ \[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->54456721],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V0tuwjAQNflAaEvph0qVuoAuqu56i/4WHCJClUAVJaUs2GXbHWo3cAOW
HKFH4BgcI/U4NjGTcQIUaik485959jim6Q/aL11/0Gn5jce+H7Q7rY/GQ6/P
WXaBMTbhz80l4+8RfxPPJIr4bMOvMxwOf8RYLBZfCd8OwzASg32T3CL/cbkz
5gqxHEKJz5aUwuzw2eEz8G1JK3nsNh6YtnO928hrRaOV3EJeLU03XZWnQkga
tEVikRrKh4Gr2YrUS0hL6paQrq15TLScP2RjZ0Q/o6Jn0BZRXfV/8MvIipTv
HsOMDE7WwTG3zv0g6RryN/G3RU71ninW8dYYuRt16XKPOgmfrUrWW19Sy1J4
rIUSnQvt3SW5FGo4h1W00twM7BxdF5+QDuKpqvDJqmhrCYMYUmKypqJRnqsG
XFcjKaQtzfLYXLfmr4JoLL9D9HlqPXEf18m46jt5JLO8RVZAwzF9TVrT3979
cuO6xuPxdDqF17LEtSbnQNNKbMuorhqidasgCEajEbwe5Fj1yDzzYtFW+goz
WY9OBzuMReP7GsV7AXq+RJwdXpTcmmjrdJfrNwlFwz7zSG3ac+yD3wFlT8b9
y2kpV71ZzNG7J+rRcyvL3MjbTyqrLtIyVYr3EF3jG9IqIm9FJD9EdMGIHCAD
pwMoN4nKQH7BZ7iMgxfaU94+eyLX82qDVc6L8CxrwHqnUXJC76o/sBXgB2v5
Tmp7UvqZSJ3ZbBaKMZ/P62TM+F8OK/wCFurL3w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->796652214]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10573],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CauchyDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CauchyDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NoncentralStudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralStudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12483],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->410472696],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->166188117],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->191453768],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->233258707]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StudentTDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 47.5013836}", "context" -> "System`", 
    "keywords" -> {"t distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StudentTDistribution[\\[Nu]] represents a Student t distribution with \
\\[Nu] degrees of freedom.", "synonyms" -> {"student distribution"}, "title" -> 
    "StudentTDistribution", "type" -> "Symbol", "uri" -> 
    "ref/StudentTDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8874, 269, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126330658]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 102814, 2470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3195, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3818, 98, 1585, 37, 70, "ObjectNameGrid"],
Cell[5406, 137, 682, 21, 70, "Usage",
 CellID->9699]
}, Open  ]],
Cell[CellGroupData[{
Cell[6125, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6603, 180, 757, 28, 70, "Notes",
 CellID->429991538],
Cell[7363, 210, 469, 14, 70, "Notes",
 CellID->417885378],
Cell[7835, 226, 297, 10, 70, "Notes",
 CellID->21086],
Cell[8135, 238, 702, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[8874, 269, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126330658],
Cell[CellGroupData[{
Cell[9259, 283, 146, 5, 70, "ExampleSection",
 CellID->1000683],
Cell[9408, 290, 213, 7, 70, "ExampleText",
 CellID->25532],
Cell[CellGroupData[{
Cell[9646, 301, 147, 4, 28, "Input",
 CellID->22901],
Cell[9796, 307, 772, 17, 48, "Output",
 Evaluatable->False,
 CellID->55342733]
}, Open  ]],
Cell[CellGroupData[{
Cell[10605, 329, 151, 4, 28, "Input",
 CellID->14777],
Cell[10759, 335, 964, 20, 58, "Output",
 Evaluatable->False,
 CellID->488726348]
}, Open  ]],
Cell[11738, 358, 121, 3, 70, "ExampleDelimiter",
 CellID->28146],
Cell[11862, 363, 283, 9, 70, "ExampleText",
 CellID->2129],
Cell[CellGroupData[{
Cell[12170, 376, 173, 6, 70, "Input",
 CellID->22767],
Cell[12346, 384, 511, 19, 79, "Output",
 CellID->12859224]
}, Open  ]],
Cell[CellGroupData[{
Cell[12894, 408, 309, 11, 28, "Input",
 CellID->12592],
Cell[13206, 421, 3519, 62, 172, "Output",
 Evaluatable->False,
 CellID->588535587]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16774, 489, 216, 7, 70, "ExampleSection",
 CellID->29004],
Cell[16993, 498, 184, 6, 70, "ExampleText",
 CellID->5680],
Cell[CellGroupData[{
Cell[17202, 508, 177, 6, 70, "Input",
 CellID->13404],
Cell[17382, 516, 365, 10, 36, "Output",
 CellID->121422571]
}, Open  ]],
Cell[17762, 529, 121, 3, 70, "ExampleDelimiter",
 CellID->23704],
Cell[17886, 534, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[18010, 541, 151, 4, 70, "Input",
 CellID->22655],
Cell[18164, 547, 783, 17, 70, "Output",
 Evaluatable->False,
 CellID->1359514]
}, Open  ]],
Cell[CellGroupData[{
Cell[18984, 569, 151, 4, 70, "Input",
 CellID->27582],
Cell[19138, 575, 1000, 20, 70, "Output",
 Evaluatable->False,
 CellID->708996311]
}, Open  ]],
Cell[20153, 598, 121, 3, 70, "ExampleDelimiter",
 CellID->13237],
Cell[20277, 603, 244, 9, 70, "ExampleText",
 CellID->25270],
Cell[CellGroupData[{
Cell[20546, 616, 177, 6, 70, "Input",
 CellID->25764],
Cell[20726, 624, 175, 5, 36, "Output",
 CellID->74996132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20950, 635, 222, 7, 70, "ExampleSection",
 CellID->7660],
Cell[21175, 644, 312, 10, 70, "ExampleText",
 CellID->813014373],
Cell[CellGroupData[{
Cell[21512, 658, 173, 6, 70, "Input",
 CellID->338871180],
Cell[21688, 666, 537, 18, 52, "Output",
 CellID->18957281]
}, Open  ]],
Cell[22240, 687, 175, 7, 70, "ExampleText",
 CellID->326644389],
Cell[CellGroupData[{
Cell[22440, 698, 199, 7, 70, "Input",
 CellID->944228315],
Cell[22642, 707, 594, 20, 52, "Output",
 CellID->784666831]
}, Open  ]],
Cell[23251, 730, 243, 9, 70, "ExampleText",
 CellID->86298351],
Cell[CellGroupData[{
Cell[23519, 743, 199, 7, 70, "Input",
 CellID->892686001],
Cell[23721, 752, 452, 15, 52, "Output",
 CellID->182845145]
}, Open  ]],
Cell[24188, 770, 125, 3, 70, "ExampleDelimiter",
 CellID->183138611],
Cell[24316, 775, 112, 3, 70, "ExampleText",
 CellID->12056],
Cell[CellGroupData[{
Cell[24453, 782, 289, 10, 70, "Input",
 CellID->27871],
Cell[24745, 794, 2404, 43, 70, "Output",
 Evaluatable->False,
 CellID->563811319]
}, Open  ]],
Cell[27164, 840, 120, 3, 70, "ExampleDelimiter",
 CellID->3501],
Cell[27287, 845, 222, 9, 70, "ExampleText",
 CellID->32525],
Cell[CellGroupData[{
Cell[27534, 858, 420, 14, 70, "Input",
 CellID->19697],
Cell[27957, 874, 58898, 994, 70, "Output",
 CellID->149769564]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86904, 1874, 233, 7, 70, "ExampleSection",
 CellID->30451],
Cell[87140, 1883, 91, 1, 70, "ExampleText",
 CellID->9228],
Cell[CellGroupData[{
Cell[87256, 1888, 443, 14, 70, "Input",
 CellID->24435],
Cell[87702, 1904, 157, 5, 36, "Output",
 CellID->15419820]
}, Open  ]],
Cell[87874, 1912, 121, 3, 70, "ExampleDelimiter",
 CellID->28660],
Cell[87998, 1917, 391, 15, 70, "ExampleText",
 CellID->24000],
Cell[CellGroupData[{
Cell[88414, 1936, 318, 9, 70, "Input",
 CellID->1030],
Cell[88735, 1947, 805, 29, 70, "Output",
 CellID->379039326]
}, Open  ]],
Cell[89555, 1979, 120, 3, 70, "ExampleDelimiter",
 CellID->4807],
Cell[89678, 1984, 457, 16, 70, "ExampleText",
 CellID->32035],
Cell[CellGroupData[{
Cell[90160, 2004, 167, 6, 70, "Input",
 CellID->220],
Cell[90330, 2012, 281, 10, 57, "Output",
 CellID->299324638]
}, Open  ]],
Cell[CellGroupData[{
Cell[90648, 2027, 188, 6, 70, "Input",
 CellID->9142],
Cell[90839, 2035, 280, 10, 57, "Output",
 CellID->57965266]
}, Open  ]],
Cell[91134, 2048, 121, 3, 70, "ExampleDelimiter",
 CellID->14582],
Cell[91258, 2053, 285, 10, 70, "ExampleText",
 CellID->107351460],
Cell[CellGroupData[{
Cell[91568, 2067, 273, 9, 70, "Input",
 CellID->23225],
Cell[91844, 2078, 325, 12, 68, "Output",
 CellID->334311367]
}, Open  ]],
Cell[CellGroupData[{
Cell[92206, 2095, 189, 6, 70, "Input",
 CellID->32689],
Cell[92398, 2103, 325, 12, 68, "Output",
 CellID->266091385]
}, Open  ]],
Cell[92738, 2118, 124, 3, 70, "ExampleDelimiter",
 CellID->75622466],
Cell[92865, 2123, 400, 13, 70, "ExampleText",
 CellID->286945964],
Cell[CellGroupData[{
Cell[93290, 2140, 176, 6, 70, "Input",
 CellID->61776903],
Cell[93469, 2148, 512, 19, 79, "Output",
 CellID->281213500]
}, Open  ]],
Cell[CellGroupData[{
Cell[94018, 2172, 209, 6, 70, "Input",
 CellID->333922946],
Cell[94230, 2180, 512, 19, 79, "Output",
 CellID->184604040]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94791, 2205, 226, 7, 70, "ExampleSection",
 CellID->23770],
Cell[95020, 2214, 317, 10, 70, "ExampleText",
 CellID->20041],
Cell[CellGroupData[{
Cell[95362, 2228, 167, 5, 70, "Input",
 CellID->15879],
Cell[95532, 2235, 216, 5, 70, "Message",
 CellID->539648224],
Cell[95751, 2242, 272, 8, 36, "Output",
 CellID->267158556]
}, Open  ]],
Cell[96038, 2253, 121, 3, 70, "ExampleDelimiter",
 CellID->22623],
Cell[96162, 2258, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[96331, 2266, 248, 8, 70, "Input",
 CellID->25472],
Cell[96582, 2276, 386, 7, 70, "Message",
 CellID->54456721],
Cell[96971, 2285, 984, 20, 70, "Output",
 Evaluatable->False,
 CellID->796652214]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98016, 2312, 311, 9, 70, "SeeAlsoSection",
 CellID->10573],
Cell[98330, 2323, 1820, 62, 70, "SeeAlso",
 CellID->22304]
}, Open  ]],
Cell[CellGroupData[{
Cell[100187, 2390, 314, 9, 70, "TutorialsSection",
 CellID->12483],
Cell[100504, 2401, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[100698, 2409, 299, 8, 70, "MoreAboutSection"],
Cell[101000, 2419, 184, 4, 70, "MoreAbout",
 CellID->410472696],
Cell[101187, 2425, 165, 3, 70, "MoreAbout",
 CellID->166188117],
Cell[101355, 2430, 161, 3, 70, "MoreAbout",
 CellID->191453768],
Cell[101519, 2435, 151, 3, 70, "MoreAbout",
 CellID->233258707]
}, Open  ]],
Cell[101685, 2441, 27, 0, 70, "History"],
Cell[101715, 2443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

